/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.api;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.imforward.client.vo.IMQueryMsgReqVO;
import com.ebaiyihui.imforward.client.vo.IMQueryUserLoginReqVO;
import com.ebaiyihui.imforward.client.vo.IMSingleMsgResultVO;
import com.ebaiyihui.onlineoutpatient.common.dto.FollowUpCaseRecord;
import com.ebaiyihui.onlineoutpatient.common.dto.ImmediateConsultationDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.MedicalOpinionDto;
import com.ebaiyihui.onlineoutpatient.common.dto.PatAdvisoryDetailDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.admission.AdvisoryDetailDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.admission.DocAdvisoryRecordReq;
import com.ebaiyihui.onlineoutpatient.common.dto.admission.PatAdvisoryRecordReq;
import com.ebaiyihui.onlineoutpatient.common.dto.admission.UpdateAdmissionDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.admission.UpdateDoctorAdmissionStatusDto;
import com.ebaiyihui.onlineoutpatient.common.dto.admission.UpdateRefuseAdmDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.manager.QueryAppealOrderTypeDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.manager.QueryCaseRecordDTO;
import com.ebaiyihui.onlineoutpatient.common.util.ResultData;
import com.ebaiyihui.onlineoutpatient.common.vo.AdmDateVo;
import com.ebaiyihui.onlineoutpatient.common.vo.AllowBuyCheckReqVO;
import com.ebaiyihui.onlineoutpatient.common.vo.AllowBuyCheckRespVO;
import com.ebaiyihui.onlineoutpatient.common.vo.DocAdvisoryDetailVo;
import com.ebaiyihui.onlineoutpatient.common.vo.DocAdvisoryRecordVo;
import com.ebaiyihui.onlineoutpatient.common.vo.ImAccountVo;
import com.ebaiyihui.onlineoutpatient.common.vo.ImmediateConsultationVo;
import com.ebaiyihui.onlineoutpatient.common.vo.PatAdvisoryDetailVo;
import com.ebaiyihui.onlineoutpatient.common.vo.PatAdvisoryRecordVo;
import com.ebaiyihui.onlineoutpatient.common.vo.PatientEndAdmReqVO;
import com.ebaiyihui.onlineoutpatient.common.vo.QueryMedicalRecordsVo;
import com.ebaiyihui.onlineoutpatient.common.vo.TimeDelayQueryReqVO;
import com.ebaiyihui.onlineoutpatient.common.vo.TimeDelayQueryRespVO;
import com.ebaiyihui.onlineoutpatient.common.vo.TimeDelayUpdateReqVO;
import com.ebaiyihui.onlineoutpatient.common.vo.inform.IMMsgResultVO;
import com.ebaiyihui.onlineoutpatient.core.business.allowcheck.AllowCheckManage;
import com.ebaiyihui.onlineoutpatient.core.business.createorder.CreateOrderManage;
import com.ebaiyihui.onlineoutpatient.core.config.annotation.DoctorAppTag;
import com.ebaiyihui.onlineoutpatient.core.config.annotation.PatientAppTag;
import com.ebaiyihui.onlineoutpatient.core.dao.InquiryMchCodeMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ServiceMerchantConfigMapper;
import com.ebaiyihui.onlineoutpatient.core.exception.AdmissionException;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.InquiryMchCodeEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientMedicalRecordEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ServiceMerchantConfigEntity;
import com.ebaiyihui.onlineoutpatient.core.service.AdmissionService;
import com.ebaiyihui.onlineoutpatient.core.utils.PageUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.AdmissionInfoParam;
import com.ebaiyihui.onlineoutpatient.core.vo.AutoSendMessageReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.AutoSendMessageResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ImAccountReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.PatientAdmissionVoReq;
import com.ebaiyihui.onlineoutpatient.core.vo.RequestDoctorServiceCheckVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admission"})
@Api(tags={"\u5c31\u8bca\u8bb0\u5f55API"})
public class AdmissionController {
    private static final Logger log = LoggerFactory.getLogger(AdmissionController.class);
    @Resource
    private AllowCheckManage allowCheckManage;
    @Resource
    private AdmissionService admissionService;
    @Autowired
    private CreateOrderManage createOrderManage;
    @Autowired
    private InquiryMchCodeMapper inquiryMchCodeMapper;
    @Autowired
    private ServiceMerchantConfigMapper serviceMerchantConfigMapper;

    @ApiOperation(value="\u5927\u4f17\u7aef\u54a8\u8be2\u8bb0\u5f55\u8be6\u60c5\u67e5\u8be2", notes="\u8be6\u60c5\u67e5\u8be2\u5305\u542b\uff1a\u5c31\u8bca\u8bb0\u5f55(\u672a\u652f\u4ed8\u65f6\u4e0d\u5b58\u5728)\uff0c\u8ba2\u5355\u8bb0\u5f55\uff0c\u533b\u751f\u4fe1\u606f\uff0c\u75c5\u4f8b")
    @RequestMapping(value={"/queryPatAdvisoryDetail"}, method={RequestMethod.POST})
    public BaseResponse<PatAdvisoryDetailVo> queryPatAdvisoryDetail(@RequestBody PatAdvisoryDetailDTO param) {
        return this.admissionService.queryPatAdvisoryDetail(param);
    }

    @ApiOperation(value="\u533b\u751f\u7aef\u67e5\u8be2IM\u54a8\u8be2\u8bb0\u5f55", notes="\u67e5\u8be2\u533b\u751f\u54a8\u8be2\u8bb0\u5f55\uff0c\u7528\u4e8e\u533b\u751f\u7aef")
    @RequestMapping(value={"/queryDocAdvisoryRecord"}, method={RequestMethod.POST})
    public BaseResponse<PageUtil<DocAdvisoryRecordVo>> queryDocAdvisoryRecord(@RequestBody @Validated DocAdvisoryRecordReq param, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.admissionService.queryDocAdvisoryRecord(param);
    }

    @ApiOperation(value="\u5927\u4f17\u7aef\u67e5\u8be2IM\u54a8\u8be2\u8bb0\u5f55", notes="\u67e5\u8be2\u75c5\u4eba\u54a8\u8be2\u8bb0\u5f55\uff0c\u7528\u4e8e\u5927\u4f17\u7aef,\u9700\u8981\u4f20\u5165userId")
    @RequestMapping(value={"/queryPatAdvisoryRecord"}, method={RequestMethod.POST})
    @PatientAppTag
    public BaseResponse<PageUtil<PatAdvisoryRecordVo>> queryPatAdvisoryRecord(@RequestBody @Validated PatAdvisoryRecordReq param, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.admissionService.queryPatAdvisoryRecord(param);
    }

    @ApiOperation(value="\u83b7\u53d6im\u8d26\u53f7,==\u804a\u5929\u754c\u9762", notes="\u83b7\u53d6\u533b\u751f\u548c\u75c5\u4eba\u7684im\u8d26\u53f7")
    @RequestMapping(value={"/queryImAccount"}, method={RequestMethod.POST})
    public BaseResponse<ImAccountVo> queryImAccount(@RequestBody @Validated ImAccountReqVo param, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.admissionService.queryImAccount(param);
    }

    @ApiOperation(value="\u7acb\u5373\u54a8\u8be2/\u6dfb\u52a0order\u6570\u636e\u5e76\u8fd4\u56de=\u6536\u94f6\u53f0", notes="\u7acb\u5373\u54a8\u8be2")
    @RequestMapping(value={"/immediateConsultation"}, method={RequestMethod.POST})
    @PatientAppTag
    public BaseResponse<ImmediateConsultationVo> immediateConsultation(@RequestBody @Validated ImmediateConsultationDTO immediateConsultationDTO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.createOrderManage.checkProcess(immediateConsultationDTO);
    }

    @PostMapping(value={"/allowBuyCheck"})
    @ApiOperation(value="\u786e\u8ba4\u5c31\u8bca\u5361\u540e\u505a\u8d44\u683c\u786e\u8ba4", notes="\u786e\u8ba4\u5c31\u8bca\u5361\u540e\u505a\u8d44\u683c\u786e\u8ba4")
    public BaseResponse<AllowBuyCheckRespVO> allowBuyCheck(@RequestBody @Validated AllowBuyCheckReqVO param, HttpServletRequest request, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.allowCheckManage.checkProcess(param);
    }

    @ApiOperation(value="\u67e5\u8be2im\u804a\u5929\u6d88\u606f\u8bb0\u5f55", httpMethod="POST", notes="\u67e5\u8be2im\u6d88\u606f\u8bb0\u5f55")
    @RequestMapping(value={"/getmsg"}, method={RequestMethod.POST})
    public BaseResponse<List<IMMsgResultVO>> getAllMsgContent(@RequestBody IMQueryMsgReqVO reqVO) {
        return this.admissionService.getAllMsgContent(reqVO);
    }

    @ApiOperation(value="\u67e5\u8be2im\u804a\u5929\u6d88\u606f\u8bb0\u5f55(\u65b0)", httpMethod="POST", notes="\u67e5\u8be2im\u6d88\u606f\u8bb0\u5f55")
    @RequestMapping(value={"/getmsgNew"}, method={RequestMethod.POST})
    public BaseResponse<List<IMSingleMsgResultVO>> getAllMsgContentNew(@RequestBody IMQueryMsgReqVO reqVO) {
        return this.admissionService.getAllMsgContentNew(reqVO);
    }

    @ApiOperation(value="\u67e5\u8be2APP\u5ba2\u6237\u7aef\u662f\u6216\u5426\u9700\u8981\u767b\u9646IM", httpMethod="POST", notes="\u67e5\u8be2APP\u5ba2\u6237\u7aef\u662f\u6216\u5426\u9700\u8981\u767b\u9646IM")
    @RequestMapping(value={"/querysdklogin"}, method={RequestMethod.POST})
    public BaseResponse<?> querySdkLogin(@RequestBody IMQueryUserLoginReqVO reqVO) {
        return this.admissionService.querySdkLogin(reqVO);
    }

    @ApiOperation(value="\u4e91\u7aef\u8c03\u7528\u5728\u7ebf\u95ee\u8bca\u5c31\u8bca\u8bb0\u5f55")
    @RequestMapping(value={"/querymedicalrecordslist"}, method={RequestMethod.POST})
    public BaseResponse<QueryMedicalRecordsVo> queryMedicalRecordsList(@RequestBody PatAdvisoryDetailDTO param) {
        if (StringUtils.isBlank((String)param.getAdmissionId()) && StringUtils.isBlank((String)param.getOrderId()) && StringUtils.isBlank((String)param.getClinicCode())) {
            return BaseResponse.error((String)"\u5165\u53c2\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        return this.admissionService.queryMedicalRecordsList(param);
    }

    @RequestMapping(value={"/timeDelayQuery"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5ef6\u65f6\u67e5\u8be2\u8bf7\u6c42", notes="\u5ef6\u65f6\u67e5\u8be2\u8bf7\u6c42")
    public BaseResponse<TimeDelayQueryRespVO> timeDelayQuery(@RequestBody @Validated TimeDelayQueryReqVO param, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.admissionService.timeDelayQuery(param);
    }

    @RequestMapping(value={"/timeDelay"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5ef6\u65f6", notes="\u5ef6\u65f6")
    public BaseResponse<String> timeDelay(@RequestBody @Validated TimeDelayUpdateReqVO param, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        if (param.getMsgIncrease() == 0 && param.getTimeIncrease() == 0) {
            return BaseResponse.error((String)"\u6d88\u606f\u6761\u6570\u4e0e\u65f6\u95f4\u4e0d\u53ef\u540c\u65f6\u4e3a0");
        }
        return this.admissionService.timeDelayUpdate(param);
    }

    @RequestMapping(value={"/patientEndAdm"}, method={RequestMethod.POST})
    @PatientAppTag
    @ApiOperation(value="\u75c5\u4eba\u4e3b\u52a8\u7ed3\u675f\u5c31\u8bca", notes="\u60a3\u8005\u7aefAPP\u8c03\u7528")
    public BaseResponse<String> patientEndAdm(@RequestBody PatientEndAdmReqVO reqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.admissionService.patientEndAdm(reqVO);
    }

    @ApiOperation(value="\u533b\u751f\u62d2\u7edd\u5c31\u8bca\uff0c\u8bb0\u5f55\u4fee\u6539", notes="\u533b\u751f\u62d2\u7edd\u54a8\u8be2\uff0c\u4fee\u6539\u8bb0\u5f55\u72b6\u6001\uff0c\u6dfb\u52a0\u62d2\u7edd\u7406\u7531\u4fe1\u606f")
    @RequestMapping(value={"/updateRefuseAdm"}, method={RequestMethod.POST})
    public BaseResponse<String> updateRefuseAdm(@RequestBody @Validated UpdateRefuseAdmDTO param, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.admissionService.updateRefuseAdm(param);
    }

    @ApiOperation(value="\u533b\u751f\u4e3b\u52a8\u7ed3\u675f\u5c31\u8bca\uff0c\u8bb0\u5f55\u4fee\u6539", notes="\u533b\u751f\u4e3b\u52a8\u7ed3\u675f\u54a8\u8be2\uff0c\u4fee\u6539\u8bb0\u5f55\u72b6\u6001")
    @RequestMapping(value={"/updateFinisheAdm"}, method={RequestMethod.POST})
    public BaseResponse<UpdateAdmissionDTO> updateFinisheAdm(@RequestBody @Validated UpdateAdmissionDTO param, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.admissionService.updateFinishAdm(param);
    }

    @ApiOperation(value="\u533b\u751f\u7aef\u54a8\u8be2\u8bb0\u5f55\u8be6\u60c5\u67e5\u8be2", notes="\u8be6\u60c5\u67e5\u8be2\u5305\u542b\uff1a\u5c31\u8bca\u8bb0\u5f55\uff0c\u8ba2\u5355\u8bb0\u5f55\uff0c\u75c5\u4eba\u4fe1\u606f\uff0c\u75c5\u4f8b")
    @RequestMapping(value={"/queryDocAdvisoryDetail"}, method={RequestMethod.POST})
    @DoctorAppTag
    public BaseResponse<DocAdvisoryDetailVo> queryDocAdvisoryDetail(@RequestBody @Validated AdvisoryDetailDTO param, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        param.setAccessToken(request.getHeader("token"));
        log.info("getAccessToken:{}" + param.getAccessToken());
        return this.admissionService.queryDocAdvisoryDetail(param);
    }

    @ApiOperation(value="\u533b\u751f\u63a5\u5355", notes="\u4e2a\u4eba\u63a5\u5355")
    @RequestMapping(value={"/docReceiveOrder"}, method={RequestMethod.POST})
    public BaseResponse<AdmDateVo> personReceiveOrder(@RequestBody @Validated UpdateDoctorAdmissionStatusDto param, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.admissionService.updateDoctorAdmissionStatus(param);
    }

    @ApiOperation(value="\u6dfb\u52a0\u8bca\u7597\u610f\u89c1", notes="\u8bca\u7597\u610f\u89c1")
    @RequestMapping(value={"/medicalopinion"}, method={RequestMethod.POST})
    public ResultData<Object> medicalOpinion(@RequestBody MedicalOpinionDto param, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ResultData().error(bindingResult.getFieldError().getDefaultMessage());
        }
        return this.admissionService.medicalOpinion(param);
    }

    @ApiOperation(value="\u60a3\u8005\u7aef\u5019\u8bca\u62a5\u9053\u63a5\u53e3", notes="\u60a3\u8005\u7aef\u5019\u8bca\u62a5\u9053\u63a5\u53e3")
    @RequestMapping(value={"/patientAdmission"}, method={RequestMethod.POST})
    public BaseResponse patientAdmission(@RequestBody PatientAdmissionVoReq patientAdmissionVoReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        try {
            this.admissionService.patientAdmission(patientAdmissionVoReq);
        }
        catch (AdmissionException e) {
            e.printStackTrace();
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success();
    }

    @ApiOperation(value="\u60a3\u8005\u7aef\u5f00\u59cb\u95ee\u8bca\u63a5\u53e3", notes="\u60a3\u8005\u7aef\u5f00\u59cb\u95ee\u8bca\u63a5\u53e3")
    @RequestMapping(value={"/patientStartConsultation"}, method={RequestMethod.POST})
    public BaseResponse patientStartConsultation(@RequestBody PatientAdmissionVoReq patientAdmissionVoReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        try {
            this.admissionService.patientStartConsultation(patientAdmissionVoReq);
        }
        catch (AdmissionException e) {
            e.printStackTrace();
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success();
    }

    @ApiOperation(value="\u60a3\u8005\u7aef\u9000\u53f7", notes="\u60a3\u8005\u7aef\u9000\u53f7")
    @RequestMapping(value={"/patientbacksource"}, method={RequestMethod.POST})
    public BaseResponse<String> patientBackSource(@RequestBody PatientAdmissionVoReq patientAdmissionVoReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.admissionService.patientBackSource(patientAdmissionVoReq);
    }

    @ApiOperation(value="\u8bc4\u8bba\u4e4b\u540e\u66f4\u65b0\u8ba2\u5355\u72b6\u6001", notes="\u8bc4\u8bba\u4e4b\u540e\u66f4\u65b0\u8ba2\u5355\u72b6\u6001")
    @RequestMapping(value={"/updateStatusByReview"}, method={RequestMethod.GET})
    public BaseResponse<String> updateStatusByReview(@RequestParam(value="admid") String admid) {
        return this.admissionService.updateStatusByReview(admid);
    }

    @ApiOperation(value="im\u9875\u9762\u65f6\u95f4\u7ed3\u675f\u540e\uff0c\u8ba2\u5355\u4fee\u6539\u4e3a\u5b8c\u6210", notes="\u8ba2\u5355\u4fee\u6539\u4e3a\u5b8c\u6210")
    @RequestMapping(value={"/updateStatusForTimeOut"}, method={RequestMethod.GET})
    public BaseResponse<String> updateStatusForTimeOut(@RequestParam(value="admId") String admId) {
        return this.admissionService.updateStatusForTimeOut(admId);
    }

    @ApiOperation(value="\u60a3\u8005\u518d\u6b21\u7533\u8bf7\u6821\u9a8c\u533b\u751f\u670d\u52a1\u662f\u5426\u5f00\u901a", notes="\u67e5\u8be2\u533b\u751f\u5728\u7ebf\u95ee\u8bca\u662f\u5426\u5f00\u901a")
    @RequestMapping(value={"/doctorServiceCheck"}, method={RequestMethod.POST})
    public BaseResponse doctorServiceCheck(@RequestBody RequestDoctorServiceCheckVo vo) {
        return this.admissionService.doctorServiceCheck(vo);
    }

    @ApiOperation(value="\u60a3\u8005\u7aef\u9000\u6b3e", notes="\u60a3\u8005\u7aef\u5f85\u63a5\u8bca\u72b6\u6001\u7684\u9000\u6b3e")
    @RequestMapping(value={"/patientRefund"}, method={RequestMethod.POST})
    public BaseResponse<String> patientRefund(@RequestBody PatientAdmissionVoReq patientAdmissionVoReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.admissionService.patientRefund(patientAdmissionVoReq);
    }

    @ApiOperation(value="\u4e91\u7aef\u8c03\u7528\u5728\u7ebf\u95ee\u8bca\u5c31\u8bca\u8bb0\u5f55\u67e5\u8be2\u590d\u8bca\u75c5\u4f8b")
    @RequestMapping(value={"/queryFollowUpCaseRecord"}, method={RequestMethod.POST})
    public BaseResponse<FollowUpCaseRecord> queryFollowUpCaseRecord(@RequestBody QueryAppealOrderTypeDTO param, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.admissionService.queryFollowUpCaseRecord(param);
    }

    @ApiOperation(value="\u4e91\u7aef\u8c03\u7528\u5728\u7ebf\u95ee\u8bca\u67e5\u8be2\u5b8c\u6574\u7684\u590d\u8bca\u75c5\u4f8b\u6839\u636eorderNumber")
    @RequestMapping(value={"/queryCaseRecord"}, method={RequestMethod.POST})
    public BaseResponse<PatientMedicalRecordEntity> queryCaseRecord(@RequestBody QueryCaseRecordDTO param, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.admissionService.queryCaseRecord(param);
    }

    @ApiOperation(value="\u4e91\u7aef\u8c03\u7528\u5728\u7ebf\u95ee\u8bca\u67e5\u8be2\u590d\u8bca\u4fe1\u606f")
    @RequestMapping(value={"/queryAdmInfo"}, method={RequestMethod.POST})
    public BaseResponse<AdmissionEntity> queryAdmInfo(@RequestBody QueryCaseRecordDTO param, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.admissionService.queryAdmInfo(param);
    }

    @ApiOperation(value="\u60a3\u8005\u91cd\u65b0\u5019\u8bca\u6392\u961f")
    @RequestMapping(value={"/toAdmAgain"}, method={RequestMethod.POST})
    public BaseResponse<String> toAdmAgain(@RequestBody AdmissionInfoParam admissionInfoParam) {
        return this.admissionService.toAdmAgain(admissionInfoParam);
    }

    @ApiOperation(value="\u533b\u751f\u7aef\u70b9\u51fb\u8fc7\u53f7")
    @RequestMapping(value={"/passNumber"}, method={RequestMethod.POST})
    public BaseResponse<String> passNumber(@RequestBody AdmissionInfoParam admissionInfoParam) {
        return this.admissionService.passNumber(admissionInfoParam);
    }

    @ApiOperation(value="\u54a8\u8be2\u4e13\u5bb6\u652f\u4ed8\u521d\u59cb\u5316\u540c\u6b65")
    @RequestMapping(value={"/payInitSynchronousMchCode"}, method={RequestMethod.POST})
    public BaseResponse<Integer> payInitSynchronousMchCode(@RequestBody InquiryMchCodeEntity inquiryMchCodeEntity) {
        InquiryMchCodeEntity inquiryMchCodeEntity1 = new InquiryMchCodeEntity();
        BeanUtils.copyProperties((Object)inquiryMchCodeEntity, (Object)inquiryMchCodeEntity1);
        this.inquiryMchCodeMapper.insert((Object)inquiryMchCodeEntity1);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u533b\u751f\u670d\u52a1\u914d\u7f6e\u652f\u4ed8\u521d\u59cb\u5316\u540c\u6b65")
    @RequestMapping(value={"/payInitSynchronous"}, method={RequestMethod.POST})
    public BaseResponse<Integer> payInitSynchronou(@RequestBody ServiceMerchantConfigEntity serviceMerchantConfigEntity) {
        ServiceMerchantConfigEntity serviceMerchantConfigEntity1 = new ServiceMerchantConfigEntity();
        serviceMerchantConfigEntity1.setBizSysSeq("zxmz");
        BeanUtils.copyProperties((Object)serviceMerchantConfigEntity, (Object)serviceMerchantConfigEntity1);
        this.serviceMerchantConfigMapper.insert((Object)serviceMerchantConfigEntity1);
        ServiceMerchantConfigEntity serviceMerchantConfigEntity2 = new ServiceMerchantConfigEntity();
        serviceMerchantConfigEntity2.setBizSysSeq("53110");
        BeanUtils.copyProperties((Object)serviceMerchantConfigEntity, (Object)serviceMerchantConfigEntity2);
        this.serviceMerchantConfigMapper.insert((Object)serviceMerchantConfigEntity2);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u822a\u5929\u590d\u8bca\u9884\u7ea6\u6d41\u7a0b\u4fee\u6539-\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f")
    @RequestMapping(value={"/getOrderInfo"}, method={RequestMethod.POST})
    public BaseResponse<ImmediateConsultationVo> getOrderInfo(@RequestBody AdmissionInfoParam admissionInfoParam) {
        return this.admissionService.getOrderInfo(admissionInfoParam);
    }

    @ApiOperation(value="\u524d\u7aef\u53d1\u9001\u533b\u751f\u6d88\u606f-\u4fbf\u6c11\u95e8\u8bca\u81ea\u52a8\u6d88\u606f\u53d1\u9001")
    @PostMapping(value={"/autoSendMessage"})
    public BaseResponse<AutoSendMessageResVo> autoSendMessage(@RequestBody AutoSendMessageReqVo reqVo) {
        return this.admissionService.autoSendMessage(reqVo);
    }
}

