/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.api;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.dto.DoctorRequestRefundDTO;
import com.ebaiyihui.onlineoutpatient.common.util.ResultData;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.PayCreateOrderVo;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.RequestBusinessBillVo;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.ResponseNotifyRestVo;
import com.ebaiyihui.onlineoutpatient.core.business.callbackrefundpaysuccess.CallbackRefundPaySuccessManage;
import com.ebaiyihui.onlineoutpatient.core.business.callbackwhilepaysuccess.CallbackWhilePaySuccessManage;
import com.ebaiyihui.onlineoutpatient.core.config.annotation.DoctorAppTag;
import com.ebaiyihui.onlineoutpatient.core.model.ServicePayBillEntity;
import com.ebaiyihui.onlineoutpatient.core.service.PayCallBackService;
import com.ebaiyihui.onlineoutpatient.core.service.PaymentService;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.XmlUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.MedicalNotifyReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.MedicalPayReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.PayCallBackVO;
import com.ebaiyihui.onlineoutpatient.core.vo.RequestRefundVo;
import com.ebaiyihui.onlineoutpatient.core.vo.yibao.YdCreadOrderResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pay"})
@Api(tags={"\u652f\u4ed8\u76f8\u5173API"})
public class PayController {
    private static final Logger log = LoggerFactory.getLogger(PayController.class);
    @Autowired
    private PayCallBackService payCallBackService;
    @Autowired
    private PaymentService paymentService;
    @Autowired
    private CallbackWhilePaySuccessManage callbackWhilePaySuccessManage;
    @Autowired
    private CallbackRefundPaySuccessManage callbackRefundPaySuccessManage;

    @ApiOperation(value="\u652f\u4ed8\u8c03\u7528", notes="\u652f\u4ed8\u8c03\u7528")
    @RequestMapping(value={"/paycalls"}, method={RequestMethod.POST})
    public BaseResponse payCalls(@RequestBody @Validated PayCreateOrderVo param) {
        return this.payCallBackService.payCalls(param);
    }

    @ApiOperation(value="\u533b\u4fdd\u4e0b\u5355", notes="\u533b\u4fdd\u4e0b\u5355\u901a\u7528")
    @RequestMapping(value={"/pay/createMedicalOrder"}, method={RequestMethod.POST})
    public BaseResponse<YdCreadOrderResponse> createMedicalOrder(@RequestBody MedicalPayReqVo medicalPayReqVo) {
        BaseResponse medicalOrder = this.payCallBackService.createMedicalOrder(medicalPayReqVo);
        return medicalOrder;
    }

    @ApiOperation(value="\u652f\u4ed8\u6210\u529f\u540e\u56de\u8c03", notes="\u652f\u4ed8\u6210\u529f\u540e\u56de\u8c03")
    @RequestMapping(value={"/callbackWhilePaySuccess"}, method={RequestMethod.POST})
    public BaseResponse<String> callbackWhilePaySuccess(@RequestBody @Validated ResponseNotifyRestVo param, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.success((Object)"fail");
        }
        return this.callbackWhilePaySuccessManage.callbackWhilePaySuccess(param);
    }

    @ApiOperation(value="\u8d63\u5357\u533b\u4fdd\u652f\u4ed8\u5b9d\u6210\u529f\u540e\u56de\u8c03", notes="\u524d\u7aef\u56de\u8c03")
    @RequestMapping(value={"/medicalCallbackWhilePaySuccess"}, method={RequestMethod.POST})
    public BaseResponse medicalCallbackWhilePaySuccess(@RequestBody MedicalNotifyReqVo param) {
        return this.payCallBackService.medicalCallbackWhilePaySuccess(param);
    }

    @ApiOperation(value="\u817e\u8baf\u533b\u4fdd\u56de\u8c03", notes="\u817e\u8baf\u533b\u4fdd\u56de\u8c03")
    @PostMapping(value={"/tencentNotify"})
    public String tencentNotify(@RequestBody String tencentNotify) {
        return this.callbackWhilePaySuccessManage.WXMedicalCallbackWhilePaySuccess(tencentNotify);
    }

    @ApiOperation(value="\u9000\u6b3e\u6210\u529f\u540e\u56de\u8c03", notes="\u9000\u6b3e\u6210\u529f\u540e\u56de\u8c03")
    @RequestMapping(value={"/callbackRefundPaySuccess"}, method={RequestMethod.POST})
    public BaseResponse<String> callbackRefundPaySuccess(@RequestBody @Validated ResponseNotifyRestVo param, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.success((Object)"fail");
        }
        return this.callbackRefundPaySuccessManage.callbackRefundPaySuccess(param);
    }

    @ApiOperation(value="\u533b\u751f\u7533\u8bf7\u9000\u6b3e", notes="\u533b\u751f\u7533\u8bf7\u9000\u6b3e")
    @RequestMapping(value={"/doctor/allRefund"}, method={RequestMethod.POST})
    @DoctorAppTag
    public ResultData<String> doctorAllRefund(@RequestBody @Validated DoctorRequestRefundDTO doctorRequestRefundDTO) {
        return this.paymentService.doctorAllRefund(doctorRequestRefundDTO);
    }

    @ApiOperation(value="\u9000\u6b3e\u8c03\u7528", notes="\u9000\u6b3e\u8c03\u7528")
    @RequestMapping(value={"/refundcalls"}, method={RequestMethod.POST})
    public BaseResponse refundCalls(@RequestBody @Validated RequestRefundVo param) {
        return this.payCallBackService.refundCalls(param);
    }

    @ApiOperation(value="\u5728\u7ebf\u95ee\u8bca\u5bf9\u8d26\u4e1a\u52a1\u67e5\u8be2", notes="\u5728\u7ebf\u95ee\u8bca\u5bf9\u8d26\u4e1a\u52a1\u67e5\u8be2")
    @RequestMapping(value={"/businessBill"}, method={RequestMethod.POST})
    public BaseResponse<List<ServicePayBillEntity>> getBusinessBill(@RequestBody @Validated RequestBusinessBillVo param) {
        return this.paymentService.getBusinessBill(param);
    }

    @ApiOperation(value="\u5b9c\u6625\u652f\u4ed8\u56de\u8c03", notes="\u5b9c\u6625\u652f\u4ed8\u56de\u8c03")
    @PostMapping(value={"notice"})
    public String notice(@RequestBody String requestHisXml) {
        log.info("\u652f\u4ed8\u56de\u8c03\u5165\u53c2 requestHisXml:{}", (Object)requestHisXml);
        if (Objects.isNull(requestHisXml)) {
            return "ERROR";
        }
        PayCallBackVO resHisDTO = (PayCallBackVO)XmlUtil.convertToJavaBean((String)requestHisXml, PayCallBackVO.class);
        log.info("\u652f\u4ed8\u56de\u8c03\u5165\u53c2 resHisDTO:{}", (Object)JSONObject.toJSONString((Object)resHisDTO));
        ResponseNotifyRestVo payNotifyReqVO = new ResponseNotifyRestVo();
        if (resHisDTO.getType().equals("pay")) {
            payNotifyReqVO.setReturnCode("SUCCESS");
            payNotifyReqVO.setReturnMsg("TRADE_FINISHED");
        }
        if (resHisDTO.getStatus().equals("1")) {
            payNotifyReqVO.setResultCode("SUCCESS");
        }
        payNotifyReqVO.setDealTradeNo(resHisDTO.getCjylsh());
        payNotifyReqVO.setOutTradeNo(resHisDTO.getCddh());
        payNotifyReqVO.setTradeNo(resHisDTO.getCcxlsh());
        payNotifyReqVO.setPayTime(DateUtils.stringToFullDate((String)resHisDTO.getDjysj()));
        payNotifyReqVO.setTotalAmount(new BigDecimal(resHisDTO.getMzfje()));
        payNotifyReqVO.setPayChannel("WECHAT");
        payNotifyReqVO.setServiceCode("");
        return (String)this.callbackWhilePaySuccessManage.callbackWhilePaySuccess(payNotifyReqVO).getData();
    }
}

