/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.core.model.SensitiveWord;
import com.ebaiyihui.onlineoutpatient.core.service.impl.SensitiveWordService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/permissions/api/v1/sensitiveWord"})
@Api(tags={"\u654f\u611f\u8bcd\u7ba1\u7406"})
public class SensitiveWordController {
    @Autowired
    private SensitiveWordService sensitiveWordService;

    @ApiOperation(value="\u83b7\u53d6\u654f\u611f\u8bcd\u5217\u8868")
    @GetMapping(value={"/list"})
    public BaseResponse<?> getSensitiveWordList(@RequestParam Integer pageNum, @RequestParam Integer pageSize, @RequestParam(required=false) String keyword, @RequestParam(required=false) Integer type) {
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        if (keyword != null) {
            queryWrapper.like((Object)"word", (Object)keyword);
        }
        if (type != null) {
            queryWrapper.eq((Object)"type", (Object)type);
        }
        IPage result = this.sensitiveWordService.page((IPage)page, (Wrapper)queryWrapper);
        return BaseResponse.success((Object)result);
    }

    @ApiOperation(value="\u6dfb\u52a0\u654f\u611f\u8bcd")
    @PostMapping(value={"/add"})
    public BaseResponse<?> addSensitiveWord(@RequestBody SensitiveWord sensitiveWord) {
        if (this.sensitiveWordService.save((Object)sensitiveWord)) {
            return BaseResponse.success((Object)sensitiveWord);
        }
        return BaseResponse.error((String)"\u654f\u611f\u8bcd\u5df2\u5b58\u5728");
    }

    @ApiOperation(value="\u5220\u9664\u654f\u611f\u8bcd")
    @GetMapping(value={"/delete"})
    public BaseResponse<?> deleteSensitiveWord(@RequestParam Integer id) {
        if (this.sensitiveWordService.removeById((Serializable)id)) {
            return BaseResponse.success();
        }
        return BaseResponse.error((String)"\u654f\u611f\u8bcd\u4e0d\u5b58\u5728");
    }

    @ApiOperation(value="\u68c0\u67e5\u6587\u672c\u662f\u5426\u5305\u542b\u654f\u611f\u8bcd")
    @PostMapping(value={"/check"})
    public BaseResponse<?> checkSensitiveWord(@RequestBody String text) {
        boolean contains = this.sensitiveWordService.containsSensitiveWord(text);
        return BaseResponse.success((Object)contains);
    }
}

