/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.business.allowcheck.core;

import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.vo.AllowBuyCheckReqVO;
import com.ebaiyihui.onlineoutpatient.common.vo.AllowBuyCheckRespVO;
import com.ebaiyihui.onlineoutpatient.common.vo.RegisteredRecordResVo;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ImmediateConsultationVoTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.InquiryMchCodeMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.service.HisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorInfofeignClient;
import com.ebaiyihui.onlineoutpatient.core.vo.ResPatientInformationVo;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class HisCheckPublicService {
    private static final Logger log = LoggerFactory.getLogger(HisCheckPublicService.class);
    @Autowired
    private HisTemplateService hisTemplateService;
    @Resource
    private PatientMapper patientMapper;
    @Autowired
    private DoctorInfofeignClient doctorClient;
    @Autowired
    private InquiryMchCodeMapper inquiryMchCodeMapper;

    public BaseResponse<AllowBuyCheckRespVO> hisCheck(AllowBuyCheckReqVO param) {
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(param.getDoctorId());
        BaseResponse doctorDetailsVoBaseResponse = this.doctorClient.queryPersonnelInfo(queryPersonnelInfoReq);
        if (null == doctorDetailsVoBaseResponse || null == doctorDetailsVoBaseResponse.getData()) {
            return BaseResponse.error((String)"\u67e5\u8be2\u4e2a\u4eba\u4fe1\u606f\u533b\u751f\u51fa\u9519");
        }
        if (param.getServType().equals(ServiceTypeEnum.HOS.getValue())) {
            return null;
        }
        ResPatientInformationVo resPatientInformationVo = this.patientMapper.getPatientById(param.getPatientId());
        if (!ServiceTypeEnum.YHST.getCode().equals(param.getServiceCode())) {
            return null;
        }
        String hisUrl = "https://ihos.chinachdu.com/yichun-hisfront/fzOutpatient/queryRegister";
        List registeredRecordList = this.hisTemplateService.getRegisteredRecord(resPatientInformationVo.getIdcard(), resPatientInformationVo.getPatientName(), param.getDeptName(), hisUrl, param.getDeptId().toString(), ((PersonnelInfo)doctorDetailsVoBaseResponse.getData()).getDoctorId(), resPatientInformationVo.getCardNo(), param.getAppCode());
        if (CollectionUtils.isEmpty((Collection)registeredRecordList)) {
            AllowBuyCheckRespVO data = new AllowBuyCheckRespVO();
            data.setType(ImmediateConsultationVoTypeEnum.TYPE_RETURN.getValue());
            return BaseResponse.success((Object)data);
        }
        registeredRecordList.sort(Comparator.comparing(RegisteredRecordResVo::getRegDate).reversed());
        AllowBuyCheckRespVO data = new AllowBuyCheckRespVO();
        data.setType(ImmediateConsultationVoTypeEnum.OK.getValue());
        data.setRegisteredRecords(registeredRecordList);
        if (StringUtils.isEmpty((String)hisUrl)) {
            data.setIsHis("2");
        } else {
            data.setIsHis("1");
        }
        return BaseResponse.success((Object)data);
    }
}

