/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.business.callbackrefundpaysuccess.core;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.ResponseNotifyRestVo;
import com.ebaiyihui.onlineoutpatient.core.business.callbackrefundpaysuccess.core.CheckOrderService;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.InquiryMchCodeMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.model.InquiryMchCodeEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.service.HisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.vo.PayNotifyResultVo;
import com.ebaiyihui.onlineoutpatient.core.vo.PayReqInfoVo;
import com.ebaiyihui.onlineoutpatient.core.vo.UnregisterPayMethodReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.UnregisterPayMethodResVo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HisRefundService {
    private static final Logger log = LoggerFactory.getLogger(HisRefundService.class);
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private InquiryMchCodeMapper inquiryMchCodeMapper;
    @Autowired
    private HisTemplateService hisTemplateService;
    @Autowired
    private CheckOrderService checkOrderService;
    private static final String ONE_ONE = "-1";

    public BaseResponse<String> hisRefund(ResponseNotifyRestVo dto) {
        OrderEntity orderInfo = this.checkOrderService.getOrderByOrderSeq(dto.getOutTradeNo());
        PatientEntity patientEntity = this.patientMapper.selectById(orderInfo.getPatientId());
        InquiryMchCodeEntity inquiryEntity = this.getHisUrl(orderInfo.getAppCode(), orderInfo.getHospitalId());
        if (orderInfo.getServType().equals(ServiceTypeEnum.NOS.getValue()) && patientEntity != null && StringUtils.isNotEmpty((String)orderInfo.getClinicCode()) && null != inquiryEntity && StringUtils.isNotEmpty((String)inquiryEntity.getHisUrl()) && "HYT".equals(inquiryEntity.getAppCode()) && this.HYTRefund(dto, orderInfo)) {
            return BaseResponse.error((String)"\u9000\u53f7\u56de\u5199\u652f\u4ed8\u65b9\u5f0f");
        }
        return BaseResponse.success((Object)"success");
    }

    private InquiryMchCodeEntity getHisUrl(String appCode, String hospitalId) {
        QueryWrapper wrapper = new QueryWrapper();
        InquiryMchCodeEntity inquiryMchCodeEntity = new InquiryMchCodeEntity();
        inquiryMchCodeEntity.setAppCode(appCode);
        inquiryMchCodeEntity.setHospitalId(hospitalId);
        log.info("inquiryMchCodeEntity:{}" + inquiryMchCodeEntity.toString());
        wrapper.setEntity((Object)inquiryMchCodeEntity);
        InquiryMchCodeEntity entity = (InquiryMchCodeEntity)this.inquiryMchCodeMapper.selectOne((Wrapper)wrapper);
        return entity;
    }

    private boolean HYTRefund(ResponseNotifyRestVo dto, OrderEntity orderInfo) {
        UnregisterPayMethodReqVo unregisterPayMethodReqVo = new UnregisterPayMethodReqVo();
        PayNotifyResultVo payNotifyReqVO = (PayNotifyResultVo)JSON.parseObject((String)dto.getNotifyResultStr(), PayNotifyResultVo.class);
        log.info("payNotifyReqVO:" + JSON.toJSONString((Object)payNotifyReqVO));
        PayReqInfoVo payReqInfoVo = (PayReqInfoVo)JSON.parseObject((String)payNotifyReqVO.getReqInfo(), PayReqInfoVo.class);
        log.info("payReqInfoVo:" + JSON.toJSONString((Object)payReqInfoVo));
        BigDecimal bigDecimal = new BigDecimal(orderInfo.getOwnCost());
        BigDecimal ownCost = bigDecimal.multiply(new BigDecimal(100));
        String sign = "";
        if (StringUtils.isNotEmpty((String)payNotifyReqVO.getSign())) {
            sign = payNotifyReqVO.getSign();
        }
        String transInfo = "SUCCESS|OK|SUCCESS|||SUCCESS|" + payNotifyReqVO.getAppid() + "|" + payNotifyReqVO.getMchId() + "|" + payNotifyReqVO.getNonceStr() + "|" + payReqInfoVo.getOutRefundNo() + "||" + payReqInfoVo.getRefundFee() + "|" + payReqInfoVo.getRefundId() + "|" + payReqInfoVo.getRefundRecvAccout() + "|" + sign + "|" + payReqInfoVo.getTotalFee() + "|" + payReqInfoVo.getTransactionId() + "|" + payReqInfoVo.getOutTradeNo() + "||";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String format = simpleDateFormat.format(orderInfo.getPaymentTime());
        unregisterPayMethodReqVo.setTransInfo(transInfo);
        unregisterPayMethodReqVo.setClinicCode(orderInfo.getClinicCode());
        UnregisterPayMethodResVo unregisterPayMethodResVo = this.hisTemplateService.unregisterPayMethod(unregisterPayMethodReqVo);
        if (null == unregisterPayMethodResVo || unregisterPayMethodResVo.getResult().equals(ONE_ONE)) {
            log.info("\u9000\u53f7\u56de\u5199\u652f\u4ed8\u65b9\u5f0f\u5931\u8d25");
            return true;
        }
        log.info("\u9000\u53f7\u56de\u5199\u652f\u4ed8\u65b9\u5f0f\u6210\u529f");
        return false;
    }
}

