/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.business.callbackwhilepaysuccess;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.ResponseNotifyRestVo;
import com.ebaiyihui.onlineoutpatient.core.business.callbackwhilepaysuccess.CallbackWhilePaySuccessFactory;
import com.ebaiyihui.onlineoutpatient.core.business.callbackwhilepaysuccess.core.UpdateOrderRecordService;
import com.ebaiyihui.onlineoutpatient.core.business.callbackwhilepaysuccess.service.CallbackWhilePaySuccess;
import com.ebaiyihui.onlineoutpatient.core.common.enums.PayChannelEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.sender.AliMedicalInformationSender;
import com.ebaiyihui.onlineoutpatient.core.sender.OrderSender;
import com.ebaiyihui.onlineoutpatient.core.service.electronicInvoice.InvoiceService;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryOrderServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.RedisUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.XmlUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.wx.NotifyRequest;
import com.ebaiyihui.onlineoutpatient.core.utils.wx.WXPayUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorMessageEventsVo;
import com.ebaiyihui.onlineoutpatient.core.vo.OrderTaskVo;
import com.ebaiyihui.onlineoutpatient.core.vo.yibao.TencentNotifyResponse;
import java.text.ParseException;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CallbackWhilePaySuccessManage {
    private static final Logger log = LoggerFactory.getLogger(CallbackWhilePaySuccessManage.class);
    @Autowired
    private CallbackWhilePaySuccessFactory callbackWhilePaySuccessFactory;
    @Autowired
    private BaseInquiryOrderServiceImpl baseInquiryOrderService;
    @Autowired
    private InvoiceService invoiceService;
    @Autowired
    private OrderSender orderSender;
    @Autowired
    AliMedicalInformationSender aliMedicalInformationSender;
    @Autowired
    private UpdateOrderRecordService updateOrderRecordService;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private RedisUtil redisUtil;

    public BaseResponse<String> callbackWhilePaySuccess(ResponseNotifyRestVo dto) {
        if (!("SUCCESS".equals(dto.getReturnCode()) || "SUCCESS".equals(dto.getResultCode()) || "TRADE_FINISHED".equals(dto.getReturnMsg()))) {
            return BaseResponse.error((String)"\u652f\u4ed8\u56de\u8c03\u5931\u8d25");
        }
        OrderEntity order = (OrderEntity)this.baseInquiryOrderService.getOne((Wrapper)new QueryWrapper().eq((Object)"order_seq", (Object)dto.getOutTradeNo()));
        if (null == order) {
            order = (OrderEntity)this.baseInquiryOrderService.getOne((Wrapper)new QueryWrapper().eq((Object)"deal_seq", (Object)dto.getOutTradeNo()));
        }
        if (null == order) {
            return BaseResponse.error((String)"fail");
        }
        log.info("order:{}" + order.toString());
        CallbackWhilePaySuccess callbackWhilePaySuccess = (CallbackWhilePaySuccess)this.callbackWhilePaySuccessFactory.get(order.getOrganId());
        BaseResponse response1 = callbackWhilePaySuccess.inquireOrder(dto);
        log.info("response1:{}" + JSON.toJSONString((Object)response1));
        OrderEntity orderEntity = (OrderEntity)response1.getData();
        if (StringUtils.isEmpty((String)orderEntity.getXId())) {
            return BaseResponse.error((String)"fail");
        }
        BaseResponse response2 = callbackWhilePaySuccess.updateOrderRecord(dto, orderEntity);
        log.info("response2:{}" + JSON.toJSONString((Object)response2));
        AdmissionEntity admissionEntity = (AdmissionEntity)response2.getData();
        if (admissionEntity == null) {
            return BaseResponse.error((String)"fail");
        }
        BaseResponse response3 = callbackWhilePaySuccess.medicarePayment(dto, orderEntity, admissionEntity);
        log.info("response3:{}" + JSON.toJSONString((Object)response3));
        if (response3 != null && !((String)response3.getData()).equals("fail")) {
            return BaseResponse.error((String)"fail");
        }
        if ("YCRMYY".equals(orderEntity.getAppCode())) {
            OrderTaskVo orderTaskVo3 = new OrderTaskVo();
            orderTaskVo3.setType(Integer.valueOf(8));
            orderTaskVo3.setId(orderEntity.getXId());
            if (Objects.equals(orderEntity.getServType(), 3)) {
                this.orderSender.sendDelay(orderTaskVo3);
            }
            BaseResponse response4 = this.invoiceService.operaInvoice(orderEntity, "1");
            log.info("response4:{}" + JSON.toJSONString((Object)response4));
        }
        this.aliMedicalInformationSender.sendOrderInformationData(new DoctorMessageEventsVo(orderEntity.getXId(), orderEntity.getAppCode()));
        return BaseResponse.success((Object)"success");
    }

    public String WXMedicalCallbackWhilePaySuccess(String tencentNotify) {
        try {
            log.info("======>>\u8fdb\u5165\u4e86\u652f\u4ed8\u56de\u8c03,\u56de\u8c03\u7684\u4fe1\u606f\u662f:{}", (Object)JSONObject.toJSONString((Object)tencentNotify));
            TencentNotifyResponse tencentNotifyResponse = (TencentNotifyResponse)XmlUtil.convertToJavaBean((String)tencentNotify, TencentNotifyResponse.class);
            ResponseNotifyRestVo responseNotifyRestVo = new ResponseNotifyRestVo();
            responseNotifyRestVo.setTradeNo(tencentNotifyResponse.getMed_trans_id());
            responseNotifyRestVo.setPayTime(DateUtils.parseDate((String)tencentNotifyResponse.getTime_end(), (String)"yyyyMMddHHmmss"));
            responseNotifyRestVo.setDealTradeNo(tencentNotifyResponse.getHosp_out_trade_no());
            responseNotifyRestVo.setPayChannel(PayChannelEnum.WECHAT.getPayChannel());
            OrderEntity orderEntity = this.orderMapper.selectByOrderSeq(tencentNotifyResponse.getHosp_out_trade_no());
            BaseResponse admissionEntityBaseResponse = this.updateOrderRecordService.updateOrderRecord(responseNotifyRestVo, orderEntity);
            if ("1".equals(admissionEntityBaseResponse.getCode())) {
                if (Objects.equals(orderEntity.getAppCode(), "GNYFY") && (Objects.equals(orderEntity.getServType(), 3) || Objects.equals(orderEntity.getServType(), 7))) {
                    log.info("======>>YB_\u540c\u6b65his\uff1a{}", (Object)orderEntity.getXId());
                    String key = orderEntity.getXId() + "_YB_PAY";
                    String string = this.redisUtil.get(key);
                    log.info("======>>YB_\u540c\u6b65his-value\uff1a{}", (Object)string);
                    if (StringUtils.isNotEmpty((String)string)) {
                        return this.returnStr("SUCCESS");
                    }
                    this.redisUtil.set(orderEntity.getXId() + "_YB_PAY", "ybPay" + orderEntity.getXId(), 86400L);
                }
                return this.returnStr("SUCCESS");
            }
            return this.returnStr("FAIL");
        }
        catch (ParseException e) {
            e.printStackTrace();
            return this.returnStr("SUCCESS");
        }
    }

    private String returnStr(String status) {
        try {
            String PAYKEY = "d4f25f38b817b20ef1b5e69696651245";
            NotifyRequest notifyRequest = new NotifyRequest();
            notifyRequest.setNonce_str(DateUtils.getCurrentDateSimpleToString());
            notifyRequest.setResult_code(status);
            notifyRequest.setReturn_code(status);
            Map objectMap = WXPayUtil.object2Map((Object)notifyRequest);
            String sign = WXPayUtil.generateSignature((Map)objectMap, (String)PAYKEY);
            objectMap.put("sign", sign);
            return WXPayUtil.mapToXml((Map)objectMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

