/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.business.createorder;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.dto.ImmediateConsultationDTO;
import com.ebaiyihui.onlineoutpatient.common.vo.AllowBuyCheckReqVO;
import com.ebaiyihui.onlineoutpatient.common.vo.AllowBuyCheckRespVO;
import com.ebaiyihui.onlineoutpatient.common.vo.ImmediateConsultationVo;
import com.ebaiyihui.onlineoutpatient.core.business.allowcheck.AllowcheckFactory;
import com.ebaiyihui.onlineoutpatient.core.business.allowcheck.service.AllowCheck;
import com.ebaiyihui.onlineoutpatient.core.business.createorder.CreateOrderFactory;
import com.ebaiyihui.onlineoutpatient.core.business.createorder.service.CreateOrder;
import com.ebaiyihui.onlineoutpatient.core.service.RedisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.utils.GetCardInfoUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.RedisUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.yc.SimulateOrderReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.yc.SimulateOrderResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.yc.VirtualConsultOrderReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.yc.VirtualConsultOrderResVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateOrderManage {
    private static final Logger log = LoggerFactory.getLogger(CreateOrderManage.class);
    @Autowired
    private CreateOrderFactory createOrderFactory;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private RedisTemplateService redisTemplateService;
    @Autowired
    private AllowcheckFactory allowcheckFactory;
    @Autowired
    private GetCardInfoUtil getCardInfoUtil;
    private static final Long EXPIRE_DATE = 2L;

    public BaseResponse<ImmediateConsultationVo> checkProcess(ImmediateConsultationDTO immediateConsultationDTO) {
        CardDetailsInfoRespVO cardDetailsInfoRespVO = this.getCardInfoUtil.getCardDetailBypaitentId(immediateConsultationDTO.getPatientId());
        immediateConsultationDTO.setCredNo(cardDetailsInfoRespVO.getCredNo());
        immediateConsultationDTO.setIdcard(cardDetailsInfoRespVO.getCredNo());
        String redisKey = immediateConsultationDTO.getPatientId() + "_" + immediateConsultationDTO.getDoctorId() + "_" + immediateConsultationDTO.getMedicalRecordId() + "_" + immediateConsultationDTO.getDeptId() + "_" + immediateConsultationDTO.getServType();
        log.info("redisKey:{}" + redisKey);
        Boolean flag = this.redisTemplateService.addLock(redisKey, redisKey, EXPIRE_DATE.longValue());
        if (!flag.booleanValue()) {
            return BaseResponse.error((String)"\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\u8ba2\u5355");
        }
        log.info("\u52a0\u9501\u6210\u529f");
        CreateOrder createOrder = (CreateOrder)this.createOrderFactory.get(immediateConsultationDTO.getOrganId());
        log.info("createOrder{}", (Object)JSON.toJSONString((Object)createOrder));
        BaseResponse orderCheckResponse = createOrder.orderCheck(immediateConsultationDTO);
        log.info("\u8ba2\u5355\u6821\u9a8c\u8fd4\u56de\u503c{}", (Object)JSON.toJSONString((Object)orderCheckResponse));
        this.redisUtil.del(redisKey);
        log.info("\u5220\u9664\u9501");
        if (null == orderCheckResponse || !orderCheckResponse.getCode().equals("1")) {
            return BaseResponse.error((String)orderCheckResponse.getMsg());
        }
        BaseResponse buyCheckRespVoBaseResponse = createOrder.preSettlementCheck(immediateConsultationDTO, (ImmediateConsultationVo)orderCheckResponse.getData());
        if (null == buyCheckRespVoBaseResponse) {
            return orderCheckResponse;
        }
        return buyCheckRespVoBaseResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseResponse<SimulateOrderResVo> simulatedOrder(SimulateOrderReqVo reqVo) {
        String redisKey = reqVo.getPatientId() + "_" + reqVo.getClassicPrescriptionId();
        log.info("redisKey:{}" + redisKey);
        try {
            Boolean flag = this.redisTemplateService.addLock(redisKey, redisKey, EXPIRE_DATE.longValue());
            if (!flag.booleanValue()) {
                BaseResponse baseResponse = BaseResponse.error((String)"\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\u8ba2\u5355");
                return baseResponse;
            }
            log.info("\u52a0\u9501\u6210\u529f");
            CreateOrder createOrder = (CreateOrder)this.createOrderFactory.get(reqVo.getOrganId());
            log.info("createOrder{}", (Object)JSON.toJSONString((Object)createOrder));
            BaseResponse orderCheckResponse = createOrder.orderingRecipe(reqVo);
            log.info("\u590d\u8bca0\u5143\u4e0b\u5355\u8fd4\u56de\u503c{}", (Object)JSON.toJSONString((Object)orderCheckResponse));
            if (!orderCheckResponse.isSuccess()) {
                BaseResponse baseResponse = BaseResponse.error((String)orderCheckResponse.getMsg());
                return baseResponse;
            }
            BaseResponse baseResponse = orderCheckResponse;
            return baseResponse;
        }
        catch (Exception e) {
            log.error("\u6574\u65b9\u8d2d\u836f\u4e0b\u5355\u7cfb\u7edf\u5f02\u5e38:{}", (Object)e.getMessage());
            BaseResponse baseResponse = BaseResponse.error((String)"\u4e0b\u5355\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            return baseResponse;
        }
        finally {
            this.redisUtil.del(redisKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseResponse<VirtualConsultOrderResVo> virtualConsultOrder(VirtualConsultOrderReqVo reqVo) {
        CardDetailsInfoRespVO cardDetailsInfoRespVO = this.getCardInfoUtil.getCardDetailBypaitentId(reqVo.getPatientId());
        reqVo.setCredNo(cardDetailsInfoRespVO.getCredNo());
        reqVo.setCardNo(cardDetailsInfoRespVO.getCardNo());
        reqVo.setPatientName(cardDetailsInfoRespVO.getPatientName());
        String redisKey = reqVo.getPatientId() + "_" + reqVo.getDoctorId() + "_virtual_consult";
        log.info("redisKey:{}", (Object)redisKey);
        try {
            Boolean flag = this.redisTemplateService.addLock(redisKey, redisKey, EXPIRE_DATE.longValue());
            if (!flag.booleanValue()) {
                BaseResponse baseResponse = BaseResponse.error((String)"\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\u8ba2\u5355");
                return baseResponse;
            }
            log.info("\u52a0\u9501\u6210\u529f");
            CreateOrder createOrder = (CreateOrder)this.createOrderFactory.get(reqVo.getOrganId());
            log.info("createOrder{}", (Object)JSON.toJSONString((Object)createOrder));
            AllowCheck allowCheck = (AllowCheck)this.allowcheckFactory.get(reqVo.getOrganId());
            AllowBuyCheckReqVO allowBuyCheckReqVO = new AllowBuyCheckReqVO();
            allowBuyCheckReqVO.setOrganId(reqVo.getOrganId());
            allowBuyCheckReqVO.setPatientId(reqVo.getPatientId());
            allowBuyCheckReqVO.setDoctorId(reqVo.getDoctorId());
            allowBuyCheckReqVO.setServType(Integer.valueOf(2));
            BaseResponse patientInfoCheck = allowCheck.patientInfoCheck(allowBuyCheckReqVO);
            log.info("\u865a\u62df\u54a8\u8be2\u4e0b\u5355\u60a3\u8005\u4fe1\u606f\u6821\u9a8c\u8fd4\u56de\u503c{}", (Object)JSON.toJSONString((Object)patientInfoCheck));
            BaseResponse buyCheckRespVoBaseResponse = allowCheck.orderCheck(allowBuyCheckReqVO);
            log.info("\u865a\u62df\u54a8\u8be2\u4e0b\u5355\u6821\u9a8c\u8fd4\u56de\u503c{}", (Object)JSON.toJSONString((Object)buyCheckRespVoBaseResponse));
            if (buyCheckRespVoBaseResponse != null && buyCheckRespVoBaseResponse.isSuccess()) {
                log.info("\u865a\u62df\u54a8\u8be2\u4e0b\u5355\u6821\u9a8c\u901a\u8fc7");
                VirtualConsultOrderResVo virtualConsultOrderResVo = new VirtualConsultOrderResVo();
                virtualConsultOrderResVo.setAdmId(((AllowBuyCheckRespVO)buyCheckRespVoBaseResponse.getData()).getAdmId());
                virtualConsultOrderResVo.setOrderId(((AllowBuyCheckRespVO)buyCheckRespVoBaseResponse.getData()).getOrderId());
                BaseResponse baseResponse = BaseResponse.success((Object)virtualConsultOrderResVo);
                return baseResponse;
            }
            BaseResponse orderResponse = createOrder.virtualConsultOrdering(reqVo);
            log.info("\u865a\u62df\u54a8\u8be2\u4e0b\u5355\u8fd4\u56de\u503c{}", (Object)JSON.toJSONString((Object)orderResponse));
            if (!orderResponse.isSuccess()) {
                BaseResponse baseResponse = BaseResponse.error((String)orderResponse.getMsg());
                return baseResponse;
            }
            BaseResponse baseResponse = orderResponse;
            return baseResponse;
        }
        catch (Exception e) {
            log.error("\u865a\u62df\u54a8\u8be2\u4e0b\u5355\u7cfb\u7edf\u5f02\u5e38:{}", (Object)e.getMessage());
            BaseResponse baseResponse = BaseResponse.error((String)"\u4e0b\u5355\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            return baseResponse;
        }
        finally {
            this.redisUtil.del(redisKey);
        }
    }
}

