/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.business.createorder.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctor.basedata.api.vo.ServiceCheckReqVo;
import com.doctoruser.api.common.enums.DoctorTypeEnum;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.ebaiyihui.card.common.CardServiceApi;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.fz.AppointmentRegistrationReqVo;
import com.ebaiyihui.his.pojo.vo.fz.QueryDocReqVo;
import com.ebaiyihui.his.pojo.vo.fz.body.AppointmentRegistrationRes;
import com.ebaiyihui.his.pojo.vo.fz.body.QueryDocRes;
import com.ebaiyihui.onlineoutpatient.common.bo.patient.PatientCheckRequestBo;
import com.ebaiyihui.onlineoutpatient.common.dto.ImmediateConsultationDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.patient.FindOneByPatientIdDTO;
import com.ebaiyihui.onlineoutpatient.common.util.ResultData;
import com.ebaiyihui.onlineoutpatient.common.vo.ImmediateConsultationVo;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.CardTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ChannelCodeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ImmediateConsultationVoTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.OrderStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.PayBillStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.NetInquiryOrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ScheduleRecordMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ServiceMerchantConfigMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ServicePayBillMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.InquiryServiceConfigEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ScheduleRecordEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ServiceMerchantConfigEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ServicePayBillEntity;
import com.ebaiyihui.onlineoutpatient.core.sender.AliMedicalInformationSender;
import com.ebaiyihui.onlineoutpatient.core.sender.OrderSender;
import com.ebaiyihui.onlineoutpatient.core.service.IMInformService;
import com.ebaiyihui.onlineoutpatient.core.service.PatientService;
import com.ebaiyihui.onlineoutpatient.core.service.PayAsyncService;
import com.ebaiyihui.onlineoutpatient.core.service.PayCallBackService;
import com.ebaiyihui.onlineoutpatient.core.service.client.DepartmentFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorInfofeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorWorkingServiceClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.MedicalCloudFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryAdmissionServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryOrderServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryServiceConfigServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.manager.ManagerOrderService;
import com.ebaiyihui.onlineoutpatient.core.service.remotecall.InternetHospitalDetailInfoService;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.IDCardUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.RedisUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.SnowflakeIdWorker;
import com.ebaiyihui.onlineoutpatient.core.utils.StringUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.gateway.GateWayCommonUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.id.UUIDUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorMessageEventsVo;
import com.ebaiyihui.onlineoutpatient.core.vo.DrugOrderCartDto;
import com.ebaiyihui.onlineoutpatient.core.vo.DrugRecordDto;
import com.ebaiyihui.onlineoutpatient.core.vo.InternetHospitalEntity;
import com.ebaiyihui.onlineoutpatient.core.vo.OrderTaskVo;
import com.ebaiyihui.onlineoutpatient.core.vo.RequestRefundVo;
import com.ebaiyihui.onlineoutpatient.core.vo.yc.FromOutlineVO;
import com.ebaiyihui.onlineoutpatient.core.vo.yc.MosClassicConfigRes;
import com.ebaiyihui.onlineoutpatient.core.vo.yc.MosClassicPrescriptionVo;
import com.ebaiyihui.onlineoutpatient.core.vo.yc.ObtainClassicPresReqDto;
import com.ebaiyihui.onlineoutpatient.core.vo.yc.PatientDynamicMedicalReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.yc.SimulateOrderReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.yc.SimulateOrderResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.yc.VirtualConsultOrderReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.yc.VirtualConsultOrderResVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.InsertTagsRecordVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalEntityVo;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class OrderCheckService {
    private static final Logger log = LoggerFactory.getLogger(OrderCheckService.class);
    @Autowired
    private DepartmentFeignClient departmentInfoApi;
    @Autowired
    private DoctorInfofeignClient doctorCilent;
    @Autowired
    private DoctorWorkingServiceClient doctorWorkingServiceClient;
    @Autowired
    private BaseInquiryOrderServiceImpl baseInquiryOrderService;
    @Resource
    private BaseInquiryServiceConfigServiceImpl baseService;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    private InternetHospitalDetailInfoService internetHospitalDetailInfoService;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private PayAsyncService payAsyncService;
    @Autowired
    private OrderSender orderSender;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private BaseInquiryAdmissionServiceImpl baseInquiryAdmissionService;
    @Autowired
    private ServicePayBillMapper servicePayBillMapper;
    @Autowired
    private ServiceMerchantConfigMapper serviceMerchantConfigMapper;
    @Autowired
    private IMInformService imInformService;
    @Autowired
    AliMedicalInformationSender aliMedicalInformationSender;
    public static final String CODE = "1";
    @Autowired
    private ManagerOrderService managerOrderService;
    @Autowired
    private CardServiceApi cardServiceApi;
    @Resource
    private MedicalCloudFeignClient medicalCloudFeignClient;
    @Autowired
    private NetInquiryOrderMapper netInquiryOrderMapper;
    @Autowired
    private PatientService patientService;
    @Autowired
    private PayCallBackService payCallBackService;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    private static final String HOSPITALID = "29";
    private static final String ORGID = "00007";

    public BaseResponse<ImmediateConsultationVo> orderCheck(ImmediateConsultationDTO immediateConsultationDTO) {
        BaseResponse baseResponse = this.doctorServiceCheck(immediateConsultationDTO);
        if (!baseResponse.isSuccess()) {
            return BaseResponse.error((String)"\u533b\u751f\u670d\u52a1\u67e5\u8be2\u5931\u8d25");
        }
        OrderEntity order = this.getRecentOrder(immediateConsultationDTO);
        if (order == null) {
            this.insertTagsRecord(immediateConsultationDTO);
            return this.createOrder(immediateConsultationDTO);
        }
        log.info("\u60a3\u8005\u6700\u65b0\u7684\u8ba2\u5355\uff1a{}", (Object)order.toString());
        if (OrderStatusEnum.TOPAY.getValue().equals(order.getStatus())) {
            log.info("\u5904\u7406\u672a\u652f\u4ed8\u8ba2\u5355\uff1a{}", (Object)order.toString());
            ImmediateConsultationVo vo = new ImmediateConsultationVo();
            vo.setType(ImmediateConsultationVoTypeEnum.TOPAY.getValue());
            vo.setDealSeq(order.getDealSeq());
            vo.setMerchantSeq(order.getMerchantId());
            vo.setOrderSeq(order.getOrderSeq());
            vo.setXCreateTime(order.getXCreateTime());
            vo.setPayAmount(order.getPayAmount());
            vo.setOrderId(order.getXId());
            if (null != order.getScheduleDate()) {
                vo.setScheduleDate(DateUtils.dateToString((Date)order.getScheduleDate(), (String)"yyyy-MM-dd"));
                vo.setScheduleStartTime(order.getScheduleStartTime());
                vo.setScheduleEndTime(order.getScheduleEndTime());
            }
            InquiryServiceConfigEntity doctorServiceDetail = this.getDoctorServiceDetail(immediateConsultationDTO);
            vo.setPayPrice(doctorServiceDetail.getPrice());
            vo.setHospitalName(immediateConsultationDTO.getHospitalName());
            vo.setDeptName(immediateConsultationDTO.getDeptName());
            vo.setDocName(immediateConsultationDTO.getDoctorName());
            vo.setPrice(order.getPrice());
            OrderEntity orderEntity = new OrderEntity();
            orderEntity.setXId(order.getXId());
            orderEntity.setMedicalRecordId(immediateConsultationDTO.getMedicalRecordId());
            this.orderMapper.updateById((Object)orderEntity);
            AdmissionEntity admissionEntity = this.admissionMapper.queryAdmByOrderId(order.getXId());
            if (null != admissionEntity) {
                AdmissionEntity adm = new AdmissionEntity();
                adm.setXId(admissionEntity.getXId());
                adm.setMedicalRecordId(immediateConsultationDTO.getMedicalRecordId());
                this.admissionMapper.update(adm);
            }
            this.insertTagsRecord(immediateConsultationDTO);
            return BaseResponse.success((Object)vo);
        }
        AdmissionEntity admission = this.getAdmissionByHospitalIdAndOrderId(order.getHospitalId(), order.getXId());
        log.info("\u4e0b\u5355\u67e5\u8be2\u5230\u5c31\u8bca\u8bb0\u5f55:" + JSON.toJSONString((Object)admission));
        if (admission == null) {
            this.insertTagsRecord(immediateConsultationDTO);
            return this.createOrder(immediateConsultationDTO);
        }
        boolean isWaitAdmission = AdmissionStatusEnum.WAIT_ADMISSION.getValue().equals(admission.getStatus());
        boolean inConsult = AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admission.getStatus());
        boolean toBeReceive = AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(admission.getStatus());
        if (!(inConsult || toBeReceive || isWaitAdmission)) {
            this.insertTagsRecord(immediateConsultationDTO);
            return this.createOrder(immediateConsultationDTO);
        }
        ImmediateConsultationVo vo = new ImmediateConsultationVo();
        vo.setType(ImmediateConsultationVoTypeEnum.IN_CONSULTATION.getValue());
        vo.setAdmId(admission.getXId());
        this.insertTagsRecord(immediateConsultationDTO);
        return BaseResponse.success((Object)vo);
    }

    private BaseResponse<Boolean> doctorServiceCheck(ImmediateConsultationDTO immediateConsultationDTO) {
        String serviceCode = "";
        if (ServiceTypeEnum.HOS.getValue().equals(immediateConsultationDTO.getServType())) {
            serviceCode = ServiceTypeEnum.HOS.getCode();
        }
        if (ServiceTypeEnum.NOS.getValue().equals(immediateConsultationDTO.getServType())) {
            serviceCode = ServiceTypeEnum.NOS.getCode();
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)immediateConsultationDTO.getServiceCode())) {
            serviceCode = ServiceTypeEnum.YHST.getCode();
        }
        ServiceCheckReqVo serviceCheckReqVo = new ServiceCheckReqVo();
        serviceCheckReqVo.setDeptId(Long.valueOf(Long.parseLong(immediateConsultationDTO.getDeptId())));
        serviceCheckReqVo.setDoctorId(Long.valueOf(Long.parseLong(immediateConsultationDTO.getDoctorId())));
        serviceCheckReqVo.setOrganId(Long.valueOf(Long.parseLong(immediateConsultationDTO.getOrganId())));
        serviceCheckReqVo.setServiceCode(serviceCode);
        log.info("\u533b\u751f\u6821\u9a8c\u5165\u53c2" + JSON.toJSONString((Object)serviceCheckReqVo));
        BaseResponse baseResponse = this.doctorWorkingServiceClient.checkDoctorServiceByCode(serviceCheckReqVo);
        return baseResponse;
    }

    private AdmissionEntity getAdmissionByHospitalIdAndOrderId(String hospitalId, String orderId) {
        QueryWrapper queryWrapperAdmissionEntity = new QueryWrapper();
        AdmissionEntity admissionEntity = new AdmissionEntity();
        admissionEntity.setOrganId(hospitalId);
        admissionEntity.setOrderId(orderId);
        queryWrapperAdmissionEntity.setEntity((Object)admissionEntity);
        log.info("\u5c31\u8bca\u8bb0\u5f55\u5165\u53c2{}", (Object)JSON.toJSONString((Object)admissionEntity));
        return (AdmissionEntity)this.baseInquiryAdmissionService.getOne((Wrapper)queryWrapperAdmissionEntity);
    }

    private OrderEntity getRecentOrder(ImmediateConsultationDTO immediateConsultationDTO) {
        QueryWrapper queryWrapperOrderEntity = new QueryWrapper();
        OrderEntity orderEntity = new OrderEntity();
        orderEntity.setDoctorId(immediateConsultationDTO.getDoctorId());
        orderEntity.setHospitalId(immediateConsultationDTO.getHospitalId());
        orderEntity.setPatientId(immediateConsultationDTO.getPatientId());
        orderEntity.setServType(immediateConsultationDTO.getServType());
        queryWrapperOrderEntity.setEntity((Object)orderEntity);
        queryWrapperOrderEntity.notIn((Object)"status", new Object[]{-1, 6});
        queryWrapperOrderEntity.last("limit 1");
        queryWrapperOrderEntity.orderByDesc((Object)"x_create_time");
        log.info("\u67e5\u8ba2\u5355\u5165\u53c2{}", (Object)JSON.toJSONString((Object)orderEntity));
        OrderEntity order = (OrderEntity)this.baseInquiryOrderService.getOne((Wrapper)queryWrapperOrderEntity);
        if (null == order) {
            return null;
        }
        return order;
    }

    private InquiryServiceConfigEntity getDoctorServiceDetail(ImmediateConsultationDTO immediateConsultationDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        InquiryServiceConfigEntity wrapperEntity = new InquiryServiceConfigEntity();
        wrapperEntity.setDoctorId(immediateConsultationDTO.getDoctorId());
        wrapperEntity.setOrganId(immediateConsultationDTO.getOrganId());
        wrapperEntity.setDeptId(Long.valueOf(Long.parseLong(immediateConsultationDTO.getDeptId())));
        if (ServiceTypeEnum.NOS.getValue().equals(immediateConsultationDTO.getServType())) {
            wrapperEntity.setServiceCode(ServiceTypeEnum.NOS.getCode());
        }
        if (ServiceTypeEnum.HOS.getValue().equals(immediateConsultationDTO.getServType())) {
            wrapperEntity.setServiceCode(ServiceTypeEnum.HOS.getCode());
        }
        if (ServiceTypeEnum.BMMZ.getValue().equals(immediateConsultationDTO.getServType())) {
            wrapperEntity.setServiceCode(ServiceTypeEnum.BMMZ.getCode());
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)immediateConsultationDTO.getServiceCode())) {
            wrapperEntity.setServiceCode(ServiceTypeEnum.YHST.getCode());
        }
        queryWrapper.setEntity((Object)wrapperEntity);
        queryWrapper.last("limit 1");
        log.info("\u83b7\u53d6\u533b\u751f\u4fe1\u606f\u5165\u53c2{}", (Object)JSON.toJSONString((Object)wrapperEntity));
        InquiryServiceConfigEntity inquiryServiceConfigEntity = (InquiryServiceConfigEntity)this.baseService.getOne((Wrapper)queryWrapper);
        log.info("\u83b7\u53d6\u533b\u751f\u4fe1\u606f\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)inquiryServiceConfigEntity));
        return inquiryServiceConfigEntity;
    }

    private ScheduleRecordEntity getScheduleById(String scheduleId) {
        QueryWrapper objectQueryWrapper = new QueryWrapper();
        ScheduleRecordEntity scheduleRecordEntity = new ScheduleRecordEntity();
        scheduleRecordEntity.setId(Long.valueOf(scheduleId));
        objectQueryWrapper.setEntity((Object)scheduleRecordEntity);
        ScheduleRecordEntity scheduleRecord = (ScheduleRecordEntity)this.scheduleRecordMapper.selectOne((Wrapper)objectQueryWrapper);
        log.info("\u6392\u73ed\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)scheduleRecord));
        return scheduleRecord;
    }

    private String getAppCode(String hospitalId) {
        InternetHospitalEntity internetHospitalEntity = this.internetHospitalDetailInfoService.getInternetHospitalInfo(hospitalId, this.projProperties.getInternetHospitalUrl());
        if (null == internetHospitalEntity) {
            return null;
        }
        return internetHospitalEntity.getAppCode();
    }

    public BaseResponse<ImmediateConsultationVo> createOrder(ImmediateConsultationDTO immediateConsultationDTO) {
        ScheduleRecordEntity scheduleById;
        BaseResponse inquiryServiceBaseResponse = this.doctorUseCheck(immediateConsultationDTO);
        if (!inquiryServiceBaseResponse.isSuccess()) {
            return BaseResponse.error((String)inquiryServiceBaseResponse.getMsg());
        }
        InquiryServiceConfigEntity serviceConfig = (InquiryServiceConfigEntity)inquiryServiceBaseResponse.getData();
        BigDecimal doctorPrice = serviceConfig.getPrice();
        String serviceName = ServiceTypeEnum.getDesc((Integer)immediateConsultationDTO.getServType());
        OrderEntity orderEntity = new OrderEntity();
        ImmediateConsultationVo responseDTO = new ImmediateConsultationVo();
        responseDTO.setType(ImmediateConsultationVoTypeEnum.OK.getValue());
        BeanUtils.copyProperties((Object)immediateConsultationDTO, (Object)orderEntity);
        orderEntity.setPayMethod(ChannelCodeEnum.getValue((String)immediateConsultationDTO.getSmallProgramSource()));
        orderEntity.setServTime(serviceConfig.getServTime());
        orderEntity.setTotalNum(serviceConfig.getNumLimit());
        orderEntity.setXVersion(Long.valueOf(0L));
        String uuid = UUIDUtil.generateViewId();
        orderEntity.setXId(uuid);
        if (StringUtils.isBlank((String)immediateConsultationDTO.getAppCode())) {
            String appCode = this.getAppCode(immediateConsultationDTO.getHospitalId());
            if (StringUtils.isNotBlank((String)appCode)) {
                orderEntity.setAppCode(appCode);
            }
        } else {
            orderEntity.setAppCode(immediateConsultationDTO.getAppCode());
        }
        if (immediateConsultationDTO.getDeptId() != null) {
            orderEntity.setDeptId(Long.valueOf(immediateConsultationDTO.getDeptId()));
        }
        orderEntity.setPayAmount(doctorPrice);
        orderEntity.setIdCard(immediateConsultationDTO.getIdcard());
        long sysId = this.snowflakeIdWorker.nextId();
        String sysIdSub = String.valueOf(sysId);
        String substring = sysIdSub.substring(sysIdSub.length() - 8);
        String currentDateSimpleNoSpeToString = DateUtils.getCurrentDateSimpleNoSpeToString();
        String outPatientId = ORGID.concat(HOSPITALID).concat(currentDateSimpleNoSpeToString).concat(substring);
        orderEntity.setOrderSeq(UUIDUtil.generateViewId());
        orderEntity.setDealSeq(outPatientId);
        if (StringUtils.isNotEmpty((String)immediateConsultationDTO.getScheduleDate()) && StringUtils.isNotEmpty((String)immediateConsultationDTO.getScheduleId())) {
            Date date = this.stringToDate(immediateConsultationDTO);
            ScheduleRecordEntity scheduleById2 = this.getScheduleById(immediateConsultationDTO.getScheduleId());
            orderEntity.setScheduleStartTime(scheduleById2.getStartTime());
            orderEntity.setScheduleEndTime(scheduleById2.getEndTime());
            orderEntity.setScheduleDate(date);
            responseDTO.setScheduleStartTime(orderEntity.getScheduleStartTime());
            responseDTO.setScheduleEndTime(orderEntity.getScheduleEndTime());
            responseDTO.setScheduleDate(immediateConsultationDTO.getScheduleDate());
        }
        responseDTO.setDealSeq(orderEntity.getDealSeq());
        responseDTO.setOrderSeq(orderEntity.getOrderSeq());
        responseDTO.setXCreateTime(orderEntity.getXCreateTime());
        responseDTO.setServiceName(serviceName);
        responseDTO.setPayAmount(orderEntity.getPayAmount());
        responseDTO.setPayPrice(doctorPrice);
        responseDTO.setHospitalName(orderEntity.getHospitalName());
        responseDTO.setDeptName(orderEntity.getDeptName());
        responseDTO.setDocName(orderEntity.getDoctorName());
        AdmissionEntity admissionEntity = this.createAdmissionEntity(orderEntity, immediateConsultationDTO);
        log.info("admissionEntity:{}", (Object)JSON.toJSONString((Object)admissionEntity));
        responseDTO.setAdmId(admissionEntity.getXId());
        Integer isTestOrder = this.getIsTestOrder(orderEntity);
        orderEntity.setIsTestOrder(isTestOrder);
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setId(UUIDUtil.getUUID());
        if (StringUtils.isNotEmpty((String)orderEntity.getTotCost()) || doctorPrice.compareTo(BigDecimal.ZERO) != 0) {
            orderEntity.setBillPayId(servicePayBillEntity.getId());
        }
        log.info("\u65b0\u589e\u8ba2\u5355\u5165\u53c2:" + JSON.toJSONString((Object)orderEntity));
        this.orderMapper.insert((Object)orderEntity);
        if ("YCRMYY".equals(orderEntity.getAppCode()) && orderEntity.getServType() == 7) {
            log.info("YCRMYY\uff0c\u5e76\u4e14\u670d\u52a1\u7c7b\u578b\u4e3a7\uff0c\u9700\u8981\u6dfb\u52a0\u836f\u54c1\u5230\u533b\u836f\u4e91\u8d2d\u7269\u8f66=====");
            CompletableFuture.runAsync(() -> {
                PatientDynamicMedicalEntityVo patientDynamicMedicalEntityVo = this.internetHospitalDetailInfoService.getMedicalInfoById(orderEntity.getMedicalRecordId());
                if (!ObjectUtils.isEmpty((Object)patientDynamicMedicalEntityVo)) {
                    String medicalDetail = patientDynamicMedicalEntityVo.getMedicalDetail();
                    JSONObject parseObject = JSONObject.parseObject((String)medicalDetail);
                    String historyMedicationInfo = parseObject.getString("historyMedication");
                    log.info("\u8f6c\u6362\u524d\u836f\u54c1\u4fe1\u606f===\u300b{}", (Object)JSON.toJSONString((Object)historyMedicationInfo));
                    List dtoList = JSONObject.parseArray((String)historyMedicationInfo, DrugRecordDto.class);
                    log.info("\u8f6c\u6362\u540e\u836f\u54c1\u4fe1\u606f===\u300b{}", (Object)JSON.toJSONString((Object)dtoList));
                    if (Optional.ofNullable(dtoList).isPresent() && !dtoList.isEmpty()) {
                        dtoList.forEach(d -> {
                            Integer type = d.getType();
                            d.setDrugType(Integer.valueOf(type == 4 ? 4 : 2));
                            d.setType(Integer.valueOf(type == 4 ? 4 : 2));
                            if (d.getType() == 4) {
                                d.setDrugDosage(d.getDrugQuantity());
                                d.setRemark("");
                            } else {
                                d.setDrugDosage(d.getDrugQuantity());
                                d.setSingleDoes(d.getDrugQuantity());
                            }
                            DrugOrderCartDto drugOrderCartDto = new DrugOrderCartDto();
                            drugOrderCartDto.setOrderNumber(orderEntity.getXId());
                            drugOrderCartDto.setAppCode(orderEntity.getAppCode());
                            drugOrderCartDto.setDrugRecordDto(d);
                            this.managerOrderService.saveDrugRecord(drugOrderCartDto);
                        });
                    }
                }
            });
        }
        responseDTO.setOrderId(orderEntity.getXId());
        if (StringUtils.isEmpty((String)orderEntity.getTotCost()) && doctorPrice.compareTo(BigDecimal.ZERO) == 0) {
            log.info("0\u539f\u8ba2\u5355\u65b0\u589e");
            this.zeroOrderCreate(orderEntity, admissionEntity, immediateConsultationDTO, uuid, servicePayBillEntity);
            this.aliMedicalInformationSender.sendOrderInformationData(new DoctorMessageEventsVo(orderEntity.getXId(), orderEntity.getAppCode()));
            return BaseResponse.success((Object)responseDTO);
        }
        servicePayBillEntity.setAppCode(orderEntity.getAppCode());
        servicePayBillEntity.setCreateTime(new Date());
        servicePayBillEntity.setUpdateTime(new Date());
        QueryWrapper queryWrapper = new QueryWrapper();
        ServiceMerchantConfigEntity entity = new ServiceMerchantConfigEntity();
        entity.setAppCode(orderEntity.getAppCode());
        entity.setBizSysSeq(ServiceTypeEnum.getCode((Integer)orderEntity.getServType()));
        entity.setHospitalId(orderEntity.getHospitalId());
        entity.setApplyName(orderEntity.getPayMethod());
        queryWrapper.setEntity((Object)entity);
        log.info("\u67e5\u8be2\u652f\u4ed8\u914d\u7f6e\u8868\u5165\u53c2:{}" + entity.toString());
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = (ServiceMerchantConfigEntity)this.serviceMerchantConfigMapper.selectOne((Wrapper)queryWrapper);
        log.info("\u67e5\u8be2\u652f\u4ed8\u914d\u7f6e\u8868\u51fa\u53c2serviceMerchantConfigEntity:{}" + serviceMerchantConfigEntity.toString());
        servicePayBillEntity.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        servicePayBillEntity.setDealAmount(doctorPrice);
        servicePayBillEntity.setGoodsInfo(this.projProperties.getProductInfo());
        servicePayBillEntity.setOrderAmount(doctorPrice);
        servicePayBillEntity.setOrganId(orderEntity.getOrganId());
        servicePayBillEntity.setPayChannel(orderEntity.getPayMethod());
        String serviceCode = orderEntity.getAppCode() + "_" + StringUtil.toFirstChar((String)orderEntity.getHospitalName()) + "_" + ServiceTypeEnum.getCode((Integer)orderEntity.getServType());
        servicePayBillEntity.setServiceCode(serviceCode);
        servicePayBillEntity.setStatus(PayBillStatusEnum.TOPAY.getValue());
        servicePayBillEntity.setOrganName(StringUtil.toFirstChar((String)orderEntity.getHospitalName()));
        servicePayBillEntity.setWorkServiceCode(ServiceTypeEnum.getCode((Integer)orderEntity.getServType()));
        servicePayBillEntity.setOutTradeNo(orderEntity.getOrderSeq());
        servicePayBillEntity.setDealTradeNo(orderEntity.getDealSeq());
        this.servicePayBillMapper.insert((Object)servicePayBillEntity);
        orderEntity.setStatus(OrderStatusEnum.TOPAY.getValue());
        admissionEntity.setStatus(Integer.valueOf(0));
        log.info("\u975e0\u5143\u8ba2\u5355\u65b0\u589e\u521b\u5efa\u8ba2\u5355\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)orderEntity));
        orderEntity.setXId(orderEntity.getXId());
        String source = Objects.equals("WX", immediateConsultationDTO.getSmallProgramSource()) ? "WX" : "ZFB";
        this.orderMapper.updateSmallProgramSource(orderEntity.getXId(), source);
        this.baseInquiryOrderService.updateById((Object)orderEntity);
        log.info("\u975e0\u5143\u65b0\u589e\u521b\u5efa\u5c31\u8bca\u53c2\u6570\uff1a" + admissionEntity.toString());
        this.admissionMapper.insertAdvisoryRecord(admissionEntity);
        if (StringUtils.isNotEmpty((String)orderEntity.getScheduleId()) && null != (scheduleById = this.getScheduleById(orderEntity.getScheduleId()))) {
            this.scheduleRecordMapper.reduceAvailableCount(scheduleById.getId());
        }
        this.aliMedicalInformationSender.sendOrderInformationData(new DoctorMessageEventsVo(orderEntity.getXId(), orderEntity.getAppCode()));
        OrderTaskVo orderTaskVo1 = new OrderTaskVo();
        orderTaskVo1.setType(Integer.valueOf(1));
        orderTaskVo1.setId(uuid);
        this.orderSender.sendDelay(orderTaskVo1);
        this.payAsyncService.createImSession(orderEntity, admissionEntity);
        return BaseResponse.success((Object)responseDTO);
    }

    private Integer getIsTestOrder(OrderEntity orderEntity) {
        Integer isTestOrder = null;
        String aa = "\u51af\u7389\u73c2,\u5468\u6625\u82f1,\u5e38\u745c,\u5e84\u96ea\u541b,\u5f6d\u7a0b\u660a,\u6768\u6842\u8339,\u6c64\u840d\u840d,\u6c6a\u6d77\u4e1c,\u738b\u7487,\u738b\u751c\u751c,\u803f\u8d3a\u59d7,\u80e1\u6842\u82f1,\u8521\u541b,\u8def\u5f71,\u9a6c\u5f66\u534e,\u5f90\u590f\u96e8,\u738b\u8d85,\u65b9\u9536\u7490,\u5f20\u6d69\u6d01,\u97e9\u6653\u4f1f,\u90ed\u9759\u96ef,\u738b\u6d9b,\u4ff1\u5f00\u7855,\u674e\u840c\u840c,\u4ed8\u4e16\u5947,\u8d75\u4e9a\u7ea2,\u5f20\u84d3\u857e,\u5b59\u8273\u82ac,\u9ec4\u8389,\u8463\u6c5f,\u738b\u5b8f\u98de,\u9648\u4f1f,\u5218\u6668,\u5de6\u632f\u829d,\u9a6c\u745e\u745e,\u6731\u5e86\u6db5,\u738b\u8d85,\u7533\u8273\u6ce2,\u623f\u5fd7\u8fdc,\u8303\u56fd\u5a77,\u8d75\u4e9a\u7ea2,\u80e1\u4f1a\u5f1f,\u90ed\u9759\u96ef,\u96f7\u5947\u82b1,\u738b\u6d9b,\u5f90\u590f\u96e8,\u738b\u8d85,\u5f20\u84d3\u857e,\u674e\u751f\u4eae,\u738b\u4f73\u58a8,\u6731\u5e86\u6db5,\u97e9\u9614,\u5415\u5e06,\u4ed8\u4e16\u5947,\u738b\u5fb7\u745e,\u6768\u662d\u745e,\u9648\u8f89\u8f89,\u7f57\u91d1,\u6b66\u6587\u6770,\u6731\u4e34\u8f69,\u4efb\u745e\u9e4f,\u6bb7\u6566\u864e,\u5218\u519b\u4fdd,\u6c88\u73ca\u73ca,\u5218\u541b\u534e,\u8d56\u4e5f\u975e,\u97e9\u6653\u4f1f,\u6768\u94ed,\u6d4b\u8bd5,\u95eb\u4eae,\u738b\u8d85,\u8d75\u4e9a\u7ea2,\u738b\u751c\u751c,\u738b\u4f73\u58a8,\u5eb7\u4f73,\u8d3e\u9759,\u6c99\u519b\u950b,\u738b\u6676\u6676,\u6768\u5a1c,\u6c6a\u677e,\u5218\u60e0\u82ac,\u738b\u4fca\u4e3d,\u725b\u65b9\u6e2f,\u5f20\u620a\u672a,\u6768\u94ed,\u738b\u5b89\u6734,\u5218\u6ce2,\u6768\u6587\u7965,\u674e\u6c38\u71d5,\u9f99\u6c38\u534e,\u8d3e\u9759\u9759,\u7a0b\u8273\u7f8e,\u5510\u6bd3\u4e54,\u90ed\u9759\u96ef,\u80e1\u4f1a\u5f1f,\u96f7\u5947\u82b1,\u738b\u6d9b,\u5f90\u590f\u96e8,\u5f20\u84d3\u857e,\u674e\u751f\u4eae,\u6731\u5e86\u6db5,\u97e9\u9614,\u5415\u5e06,\u4ed8\u4e16\u5947,\u738b\u5fb7\u745e,\u6768\u662d\u745e,\u9648\u8f89\u8f89,\u7f57\u91d1,\u6b66\u6587\u6770,\u6731\u4e34\u8f69,\u4efb\u745e\u9e4f,\u6bb7\u6566\u864e,\u5218\u519b\u4fdd,\u6c88\u73ca\u73ca,\u5218\u541b\u534e,\u8d56\u4e5f\u975e,\u97e9\u6653\u4f1f,\u6d4b\u8bd5,\u795d\u6210\u9f99,CS\u8d75\u4e9a\u7ea2,CS\u80e1\u4f1a\u5f1f,CS\u90ed\u9759\u96ef,CS\u96f7\u5947\u82b1,CS\u738b\u6d9b,CS\u5f90\u590f\u96e8,CS\u738b\u8d85,CS\u5f20\u84d3\u857e,CS\u674e\u751f\u4eae,CS\u738b\u4f73\u58a8,CS\u6731\u5e86\u6db5,CS\u97e9\u9614,CS\u5415\u5e06,CS\u4ed8\u4e16\u5947,CS\u738b\u5fb7\u745e,CS\u6768\u662d\u745e,CS\u9648\u8f89\u8f89,CS\u7f57\u91d1,CS\u6b66\u6587\u6770,CS\u6731\u4e34\u8f69,CS\u4efb\u745e\u9e4f,CS\u6bb7\u6566\u864e,CS\u5218\u519b\u4fdd,CS\u6c88\u73ca\u73ca,CS\u5218\u541b\u534e,CS\u8d56\u4e5f\u975e,CS\u97e9\u6653\u4f1f,CS\u6768\u94ed,CS\u6d4b\u8bd5,CS\u95eb\u4eae,CS\u738b\u8d85,CS\u8d75\u4e9a\u7ea2,CS\u738b\u751c\u751c,CS\u738b\u4f73\u58a8,CS\u5eb7\u4f73,CS\u8d3e\u9759,CS\u6c99\u519b\u950b,CS\u738b\u6676\u6676,CS\u6768\u5a1c,CS\u6c6a\u677e,CS\u5218\u60e0\u82ac,CS\u738b\u4fca\u4e3d,CS\u725b\u65b9\u6e2f,CS\u5f20\u620a\u672a,CS\u6768\u94ed,CS\u738b\u5b89\u6734,CS\u5218\u6ce2,CS\u6768\u6587\u7965,CS\u674e\u6c38\u71d5,CS\u9f99\u6c38\u534e,CS\u8d3e\u9759\u9759,CS\u7a0b\u8273\u7f8e,CS\u5510\u6bd3\u4e54,CS\u90ed\u9759\u96ef,CS\u80e1\u4f1a\u5f1f,CS\u96f7\u5947\u82b1,CS\u738b\u6d9b,CS\u5f90\u590f\u96e8,CS\u5f20\u84d3\u857e,CS\u674e\u751f\u4eae,CS\u6731\u5e86\u6db5,CS\u97e9\u9614,CS\u5415\u5e06,CS\u4ed8\u4e16\u5947,CS\u738b\u5fb7\u745e,CS\u6768\u662d\u745e,CS\u9648\u8f89\u8f89,CS\u7f57\u91d1,CS\u6b66\u6587\u6770,CS\u6731\u4e34\u8f69,CS\u4efb\u745e\u9e4f,CS\u6bb7\u6566\u864e,CS\u5218\u519b\u4fdd,CS\u6c88\u73ca\u73ca,CS\u5218\u541b\u534e,CS\u8d56\u4e5f\u975e,CS\u97e9\u6653\u4f1f,CS\u6d4b\u8bd5,CS\u795d\u6210\u9f99,\u738b\u6d9b9,ZS\u738b\u6d9b,\u7267\u7ae5,ZS\u8d75\u4e9a\u7ea2,\u6d4b\u8bd5\u533b\u751f,\u6d4b\u8bd5\u836f\u5e08,byh\u6d4b\u8bd5,\u5f6d\u519b,\u836f\u5e08\u6d4b\u8bd5,ZS\u5f20\u84d3\u857e,ZS\u5f90\u590f\u96e8,\u738b\u632f\u751f,\u674e\u79c0\u5947,zs\u738b\u6d9b,\u8fd0\u8425\u6d4b\u8bd5\u533b\u751f,\u6b27\u9633\u9876\u8363";
        List<String> list = Arrays.asList(aa.split(","));
        for (String s : list) {
            if (!s.equals(orderEntity.getDoctorName())) continue;
            isTestOrder = 1;
        }
        return isTestOrder;
    }

    private Date stringToDate(ImmediateConsultationDTO immediateConsultationDTO) {
        Date date = null;
        try {
            date = DateUtils.strToDate((String)immediateConsultationDTO.getScheduleDate(), (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    private BaseResponse<QueryDocRes> hisDoctorUseCheck(ImmediateConsultationDTO immediateConsultationDTO) {
        if (immediateConsultationDTO.getServType() == 7 || immediateConsultationDTO.getServType() == 2) {
            return BaseResponse.success();
        }
        try {
            FrontRequest param = new FrontRequest();
            QueryDocReqVo queryDocReqVo = new QueryDocReqVo();
            QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
            queryPersonnelInfoReq.setDoctorId(immediateConsultationDTO.getDoctorId());
            BaseResponse personnelInfoBaseResponse = this.doctorCilent.queryPersonnelInfo(queryPersonnelInfoReq);
            if (null == personnelInfoBaseResponse || null == personnelInfoBaseResponse.getData()) {
                return BaseResponse.error((String)"\u8be5\u533b\u751fhis\u533b\u751f\u5de5\u53f7\u7f3a\u5931\uff0c\u8bf7\u8865\u5168\u533b\u751f\u4fe1\u606f");
            }
            queryDocReqVo.setDoctorCode(((PersonnelInfo)personnelInfoBaseResponse.getData()).getEmplCode());
            log.info("his\u533b\u751fcode:" + JSON.toJSONString((Object)personnelInfoBaseResponse));
            queryDocReqVo.setConsulMethod("101");
            queryDocReqVo.setIsCostDetail(CODE);
            param.setBody((Object)queryDocReqVo);
            log.info("hisdocparam:" + JSON.toJSONString((Object)param));
            FrontResponse frontResponse = new GateWayCommonUtil().requestHis("/fzOutpatient/queryDoc", param, QueryDocRes.class);
            log.info("hisdocparamfrontResponse:" + JSON.toJSONString((Object)frontResponse));
            if (frontResponse.getCode().equals("0")) {
                return BaseResponse.error((String)"\u8be5\u533b\u751f\u672a\u5728his\u7cfb\u7edf\u914d\u7f6e");
            }
            return BaseResponse.success((Object)frontResponse.getBody());
        }
        catch (Exception e) {
            return BaseResponse.error((String)"\u67e5\u8be2\u8be5\u533b\u751f\u662f\u5426\u5728his\u7cfb\u7edf\u914d\u7f6e\u5f02\u5e38");
        }
    }

    private BaseResponse<InquiryServiceConfigEntity> doctorUseCheck(ImmediateConsultationDTO immediateConsultationDTO) {
        InquiryServiceConfigEntity serviceConfig = this.getDoctorServiceDetail(immediateConsultationDTO);
        if (serviceConfig == null) {
            return BaseResponse.error((String)"\u533b\u751f\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
        }
        if (StringUtils.isEmpty((String)immediateConsultationDTO.getScheduleDate()) && StringUtils.isEmpty((String)immediateConsultationDTO.getScheduleId())) {
            String scheduleDate = DateUtils.dateToSimpleString((Date)new Date());
            Integer orderCount = this.orderMapper.countDoctorTodayOrders(immediateConsultationDTO.getDoctorId(), immediateConsultationDTO.getOrganId(), scheduleDate, immediateConsultationDTO.getServType());
            if (orderCount >= serviceConfig.getDailyLimit() && -1 != serviceConfig.getDailyLimit()) {
                return BaseResponse.error((String)"\u533b\u751f\u5f53\u65e5\u670d\u52a1\u5df2\u8fbe\u4e0a\u9650");
            }
        } else {
            if (StringUtils.isEmpty((String)immediateConsultationDTO.getScheduleId())) {
                return BaseResponse.error((String)"\u6392\u73ed\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ScheduleRecordEntity scheduleById = this.getScheduleById(immediateConsultationDTO.getScheduleId());
            if (scheduleById.getAvailableCount() <= 0) {
                return BaseResponse.error((String)"\u533b\u751f\u5f53\u65e5\u670d\u52a1\u5df2\u8fbe\u4e0a\u9650");
            }
        }
        return BaseResponse.success((Object)serviceConfig);
    }

    private void zeroOrderCreate(OrderEntity orderEntity, AdmissionEntity admissionEntity, ImmediateConsultationDTO immediateConsultationDTO, String uuid, ServicePayBillEntity servicePayBillEntity) {
        orderEntity.setPaymentTime(new Date());
        orderEntity.setPayMethod(ChannelCodeEnum.NOPAY.getValue());
        orderEntity.setStatus(OrderStatusEnum.PAID.getValue());
        orderEntity.setXId(orderEntity.getXId());
        log.info("0\u5143\u65b0\u589eorder\u5165\u53c2:" + orderEntity.toString());
        this.orderMapper.updateById((Object)orderEntity);
        log.info("0\u5143\u65b0\u589eorder\u6210\u529f\u51fa\u53c2:" + orderEntity.toString());
        String source = Objects.equals("WX", immediateConsultationDTO.getSmallProgramSource()) ? "WX" : "ZFB";
        this.orderMapper.updateSmallProgramSource(orderEntity.getXId(), source);
        if (StringUtils.isNotEmpty((String)orderEntity.getScheduleId())) {
            log.info("\u6392\u73ed0\u5143\u65b0\u589e");
            admissionEntity.setStatus(AdmissionStatusEnum.WAIT_ADMISSION.getValue());
            Date scheduleDate = orderEntity.getScheduleDate();
            String scheduleDateStr = DateUtils.dateToSimpleString((Date)scheduleDate);
            String scheduleEndTime = orderEntity.getScheduleEndTime();
            String newDateTimeStr = scheduleDateStr + " " + scheduleEndTime + ":00";
            Date expirationDateTime = DateUtils.stringToFullDate((String)newDateTimeStr);
            admissionEntity.setEndTime(expirationDateTime);
        } else {
            log.info("\u975e\u6392\u73ed0\u5143\u65b0\u589e");
            admissionEntity.setEndTime(DateUtils.getDateAfter((Date)new Date(), (int)1));
            admissionEntity.setConvertWaitTime(new Date());
            admissionEntity.setStatus(AdmissionStatusEnum.TO_BE_RECEIVED.getValue());
        }
        if (immediateConsultationDTO.getServType().equals(ServiceTypeEnum.NOS.getValue()) && !ServiceTypeEnum.NOS.getCode().equals(immediateConsultationDTO.getServiceCode())) {
            FindOneByPatientIdDTO byPatientIdDTO = new FindOneByPatientIdDTO();
            byPatientIdDTO.setPatientId(admissionEntity.getPatientId());
            ResultData patientEntityResultData = this.patientService.findOneByPatientId(byPatientIdDTO);
            PatientEntity patientEntity = (PatientEntity)patientEntityResultData.getData();
            QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
            queryPersonnelInfoReq.setDoctorId(admissionEntity.getDoctorId());
            BaseResponse personnelInfoBaseResponse = this.doctorCilent.queryPersonnelInfo(queryPersonnelInfoReq);
            String emplCode = "";
            String deptCode = "";
            if (personnelInfoBaseResponse.isSuccess() && null != personnelInfoBaseResponse.getData()) {
                emplCode = ((PersonnelInfo)personnelInfoBaseResponse.getData()).getEmplCode();
                BaseResponse baseResponse = this.departmentInfoApi.getDepartmentDetail(Long.valueOf(Long.parseLong(((PersonnelInfo)personnelInfoBaseResponse.getData()).getDeptId().toString())));
            }
            log.info("emplCode:{}", (Object)emplCode);
            log.info("deptCode:{}", (Object)deptCode);
            FrontRequest param = new FrontRequest();
            AppointmentRegistrationReqVo appointmentRegistrationReqVo = new AppointmentRegistrationReqVo();
            appointmentRegistrationReqVo.setConsultationMode("101");
            appointmentRegistrationReqVo.setDepartmentsCode(deptCode);
            appointmentRegistrationReqVo.setDoctorCode(emplCode);
            appointmentRegistrationReqVo.setInvoicing(CODE);
            appointmentRegistrationReqVo.setIsSchedule(CODE);
            appointmentRegistrationReqVo.setMedicalInsCode("0");
            appointmentRegistrationReqVo.setOrderNo(admissionEntity.getOrderId());
            appointmentRegistrationReqVo.setPatientId(patientEntity.getCardNo());
            appointmentRegistrationReqVo.setRegistrationType("0011");
            if (null != admissionEntity.getScheduleDate()) {
                appointmentRegistrationReqVo.setScheduleDate(DateUtils.dateToString((Date)admissionEntity.getScheduleDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            } else {
                appointmentRegistrationReqVo.setScheduleDate(DateUtils.getCurrentDateToString());
            }
            appointmentRegistrationReqVo.setPaymentMoney(new BigDecimal(0));
            appointmentRegistrationReqVo.setTotalAmunt(new BigDecimal(0));
            param.setBody((Object)appointmentRegistrationReqVo);
            FrontResponse frontResponse = new GateWayCommonUtil().requestHis("/fzOutpatient/doRegister", param, AppointmentRegistrationRes.class);
            if (frontResponse.getCode().equals("0")) {
                RequestRefundVo requestRefundVo = new RequestRefundVo();
                requestRefundVo.setOrderId(orderEntity.getXId());
                this.payCallBackService.refundCalls(requestRefundVo);
                log.info("his\u6302\u53f7\u5931\u8d25");
            }
            AppointmentRegistrationRes registrationRes = (AppointmentRegistrationRes)frontResponse.getBody();
            admissionEntity.setPatientNumber(registrationRes.getPatientNumber());
        }
        log.info("admissionEntity{}", (Object)JSON.toJSONString((Object)admissionEntity));
        this.admissionMapper.insertAdvisoryRecord(admissionEntity);
        log.info("0\u5143\u5c31\u8bca\u8bb0\u5f55\u65b0\u589e\u6210\u529f");
        if (StringUtils.isNotEmpty((String)immediateConsultationDTO.getScheduleDate()) && StringUtils.isNotEmpty((String)immediateConsultationDTO.getScheduleId())) {
            ScheduleRecordEntity scheduleById = this.getScheduleById(immediateConsultationDTO.getScheduleId());
            if (null != scheduleById) {
                this.scheduleRecordMapper.reduceAvailableCount(scheduleById.getId());
            }
            OrderTaskVo orderTaskVo3 = new OrderTaskVo();
            orderTaskVo3.setType(Integer.valueOf(3));
            orderTaskVo3.setId(uuid);
            this.orderSender.sendDelay(orderTaskVo3);
            OrderTaskVo orderTaskVo4 = new OrderTaskVo();
            orderTaskVo4.setType(Integer.valueOf(4));
            orderTaskVo4.setId(uuid);
            this.orderSender.sendDelay(orderTaskVo4);
        } else {
            OrderTaskVo orderTaskVo2 = new OrderTaskVo();
            orderTaskVo2.setType(Integer.valueOf(2));
            orderTaskVo2.setId(uuid);
            this.orderSender.sendDelay(orderTaskVo2);
        }
        CompletableFuture<BaseResponse> createImSessionFuture = CompletableFuture.supplyAsync(() -> this.payAsyncService.createImSession(orderEntity, admissionEntity));
        if (orderEntity.getScheduleDate() == null) {
            createImSessionFuture.thenAccept(response -> {
                if (response.isSuccess()) {
                    this.payAsyncService.asyncTask(orderEntity, admissionEntity);
                } else {
                    log.error("createImSession failed: {}", (Object)response.getMsg());
                }
            });
        } else {
            createImSessionFuture.thenAccept(response -> {
                if (response.isSuccess()) {
                    this.imInformService.makeAnAppiontment(admissionEntity.getXId());
                } else {
                    log.error("createImSession failed: {}", (Object)response.getMsg());
                }
            });
        }
    }

    private void insertTagsRecord(ImmediateConsultationDTO immediateConsultationDTO) {
        InsertTagsRecordVo insertTagsRecordVo = new InsertTagsRecordVo();
        insertTagsRecordVo.setDeptId(immediateConsultationDTO.getDeptId());
        insertTagsRecordVo.setHospitalId(immediateConsultationDTO.getHospitalId());
        insertTagsRecordVo.setMedicalRecordId(immediateConsultationDTO.getMedicalRecordId());
        insertTagsRecordVo.setServType(immediateConsultationDTO.getServType());
        String response = this.internetHospitalDetailInfoService.insertTagsRecord(insertTagsRecordVo);
        if (StringUtils.isEmpty((String)response)) {
            return;
        }
        log.info("\u4e0b\u5355\u75c5\u4f8b\u4f7f\u7528\u8bb0\u5f55\u65b0\u589e\u6210\u529f");
    }

    private AdmissionEntity createAdmissionEntity(OrderEntity orderInfo, ImmediateConsultationDTO immediateConsultationDTO) {
        AdmissionEntity entity = new AdmissionEntity();
        entity.setXId(String.valueOf(System.currentTimeMillis()));
        entity.setOrganId(orderInfo.getHospitalId());
        entity.setOrderId(orderInfo.getXId());
        entity.setPatientId(orderInfo.getPatientId());
        entity.setDoctorId(orderInfo.getDoctorId());
        entity.setDoctorType(orderInfo.getDoctorType());
        entity.setServType(orderInfo.getServType());
        entity.setMedicalRecordId(orderInfo.getMedicalRecordId());
        entity.setServTime(orderInfo.getServTime());
        entity.setTotalNum(orderInfo.getTotalNum());
        entity.setCurrentNum(orderInfo.getTotalNum());
        entity.setDoctorName(orderInfo.getDoctorName());
        entity.setOrganId(orderInfo.getHospitalId());
        entity.setPauseTime(Long.valueOf(0L));
        entity.setXId(UUIDUtil.getUUID());
        return entity;
    }

    public BaseResponse<SimulateOrderResVo> orderingRecipe(SimulateOrderReqVo orderReqVo) {
        ObtainClassicPresReqDto reqDto = new ObtainClassicPresReqDto();
        reqDto.setAppCode("YCRMYY");
        BaseResponse ycrmyy = this.medicalCloudFeignClient.getOneByAppCode(reqDto);
        log.info("\u67e5\u8be2\u5230\u533b\u836f\u4e91\u914d\u7f6e\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)ycrmyy));
        orderReqVo.setDeptId(((MosClassicConfigRes)ycrmyy.getData()).getReciveDeptId());
        orderReqVo.setDoctorId(((MosClassicConfigRes)ycrmyy.getData()).getReciveDoctorId());
        orderReqVo.setDoctorName(((MosClassicConfigRes)ycrmyy.getData()).getReciveDoctorName());
        orderReqVo.setDeptName(((MosClassicConfigRes)ycrmyy.getData()).getReciveDeptName());
        orderReqVo.setDoctorType(DoctorTypeEnum.PERSONAL.getValue());
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(orderReqVo.getCardId());
        BaseResponse patientResult = this.cardServiceApi.getCardDetail(cardDetailsInfoReqVO);
        if (!patientResult.isSuccess()) {
            return BaseResponse.error((String)"\u60a3\u8005\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        InquiryServiceConfigEntity wrapperEntity = new InquiryServiceConfigEntity();
        wrapperEntity.setDoctorId(((MosClassicConfigRes)ycrmyy.getData()).getReciveDoctorId());
        wrapperEntity.setOrganId(orderReqVo.getOrganId());
        wrapperEntity.setDeptId(Long.valueOf(Long.parseLong(((MosClassicConfigRes)ycrmyy.getData()).getReciveDeptId())));
        wrapperEntity.setServiceCode(ServiceTypeEnum.NOS.getCode());
        queryWrapper.setEntity((Object)wrapperEntity);
        queryWrapper.last("limit 1");
        log.info("\u7ecf\u5178\u540d\u65b9===\u300b\u83b7\u53d6\u533b\u751f\u4fe1\u606f\u5165\u53c2{}", (Object)JSON.toJSONString((Object)wrapperEntity));
        InquiryServiceConfigEntity serviceConfig = (InquiryServiceConfigEntity)this.baseService.getOne((Wrapper)queryWrapper);
        log.info("\u7ecf\u5178\u540d\u65b9===\u300b\u83b7\u53d6\u533b\u751f\u4fe1\u606f\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)serviceConfig));
        if (Objects.isNull(serviceConfig)) {
            return BaseResponse.error((String)"\u6b64\u65b9\u6682\u672a\u5f00\u901a\u670d\u52a1\uff0c\u8bf7\u7b49\u5f85\u7ba1\u7406\u5458\u5f00\u901a");
        }
        CardDetailsInfoRespVO cardDetailsInfoRespVO = (CardDetailsInfoRespVO)patientResult.getData();
        log.info("\u7ecf\u5178\u540d\u65b9===\u300b\u83b7\u53d6\u60a3\u8005\u4fe1\u606f\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)cardDetailsInfoRespVO));
        Integer age = 0;
        age = IDCardUtil.getAge((String)cardDetailsInfoRespVO.getCredNo());
        BaseResponse classicPrescriptionVoBaseResponse = this.medicalCloudFeignClient.classicPreDetail(orderReqVo.getClassicPrescriptionId());
        MosClassicPrescriptionVo mosClassicPrescriptionVo = (MosClassicPrescriptionVo)classicPrescriptionVoBaseResponse.getData();
        String adminId = UUIDUtil.generateViewId();
        PatientDynamicMedicalReqVo medicalReqVo = new PatientDynamicMedicalReqVo();
        medicalReqVo.setAdmId(adminId);
        medicalReqVo.setMainSuit(orderReqVo.getIcdName());
        medicalReqVo.setPrimaryDiagno(mosClassicPrescriptionVo.getTcmSyndrome().replace("\u3001", ";").replace("\u3002", ""));
        medicalReqVo.setPatientId(orderReqVo.getPatientId());
        medicalReqVo.setMainSuit(orderReqVo.getIcdName());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("patientName", (Object)cardDetailsInfoRespVO.getPatientName());
        jsonObject.put("patientSex", (Object)IDCardUtil.getGender((String)cardDetailsInfoRespVO.getCredNo()));
        jsonObject.put("patientAge", (Object)age.toString());
        jsonObject.put("clinicDepartment", (Object)medicalReqVo.getDeptName());
        jsonObject.put("clinicDate", (Object)DateUtils.dateToSimpleString((Date)new Date()));
        jsonObject.put("mainSuit", (Object)orderReqVo.getIcdName());
        jsonObject.put("primaryDiagno", Arrays.asList(mosClassicPrescriptionVo.getTcmSyndrome().replace("\u3001", ";").replace("\u3002", "").split(";")));
        medicalReqVo.setMedicalDetail(jsonObject.toJSONString());
        medicalReqVo.setMedicalUserFills(jsonObject.toJSONString());
        medicalReqVo.setHospitalName("\u5b9c\u6625\u5e02\u4eba\u6c11\u533b\u9662");
        String insertMedical = this.internetHospitalDetailInfoService.insertMedicalNew(medicalReqVo);
        if (StringUtils.isEmpty((String)insertMedical)) {
            return BaseResponse.error((String)"\u65b0\u5efa\u75c5\u5386\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
        }
        log.info("\u5904\u65b9\u6574\u65b9\u8d2d\u836f--\u65b0\u589e\u75c5\u5386\u6210\u529f");
        OrderEntity orderEntity = new OrderEntity();
        BeanUtils.copyProperties((Object)orderReqVo, (Object)orderEntity);
        orderEntity.setServTime(serviceConfig.getServTime());
        orderEntity.setTotalNum(serviceConfig.getNumLimit());
        orderEntity.setXVersion(Long.valueOf(0L));
        String uuid = UUIDUtil.generateViewId();
        orderEntity.setXId(uuid);
        orderEntity.setAppCode(orderReqVo.getAppCode());
        orderEntity.setDeptId(Long.valueOf(orderReqVo.getDeptId()));
        orderEntity.setPayAmount(BigDecimal.ZERO);
        orderEntity.setOrderSeq(UUIDUtil.generateViewId());
        orderEntity.setIdCard(cardDetailsInfoRespVO.getCredNo());
        orderEntity.setDealSeq(UUIDUtil.generateViewId());
        orderEntity.setMedicalRecordId(insertMedical);
        orderEntity.setPaymentTime(new Date());
        orderEntity.setPayMethod(ChannelCodeEnum.NOPAY.getValue());
        orderEntity.setStatus(OrderStatusEnum.PAID.getValue());
        log.info("\u7ecf\u5178\u540d\u65b9===\u300b\u65b0\u589e0\u5143\u8ba2\u5355\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)orderEntity));
        this.orderMapper.insert((Object)orderEntity);
        AdmissionEntity admissionEntity = new AdmissionEntity();
        admissionEntity.setOrganId(orderEntity.getHospitalId());
        admissionEntity.setOrderId(orderEntity.getXId());
        admissionEntity.setPatientId(orderEntity.getPatientId());
        admissionEntity.setDoctorId(orderEntity.getDoctorId());
        admissionEntity.setDoctorType(orderEntity.getDoctorType());
        admissionEntity.setServType(orderEntity.getServType());
        admissionEntity.setServTime(orderEntity.getServTime());
        admissionEntity.setTotalNum(orderEntity.getTotalNum());
        admissionEntity.setCurrentNum(orderEntity.getTotalNum());
        admissionEntity.setDoctorName(orderEntity.getDoctorName());
        admissionEntity.setOrganId(orderEntity.getHospitalId());
        admissionEntity.setPauseTime(Long.valueOf(0L));
        admissionEntity.setXId(adminId);
        admissionEntity.setStartTime(new Date());
        admissionEntity.setEndTime(DateUtils.getDateAfter((Date)new Date(), (int)1));
        admissionEntity.setStatus(AdmissionStatusEnum.FINISH_APPLY.getValue());
        admissionEntity.setReceptionTime(new Date());
        admissionEntity.setXCreateTime(new Date());
        admissionEntity.setXUpdateTime(new Date());
        admissionEntity.setXVersion(Long.valueOf(0L));
        admissionEntity.setConvertWaitTime(new Date());
        log.info("\u7ecf\u5178\u540d\u65b9===\u300badmissionEntity{}", (Object)JSON.toJSONString((Object)admissionEntity));
        this.admissionMapper.insertAdvisoryRecord(admissionEntity);
        log.info("\u7ecf\u5178\u540d\u65b9===\u300b0\u5143\u5c31\u8bca\u8bb0\u5f55\u65b0\u589e\u6210\u529f");
        BaseResponse imSessionRes = this.payAsyncService.createImSession(orderEntity, admissionEntity);
        if (!imSessionRes.isSuccess()) {
            return BaseResponse.error((String)"\u521b\u5efa\u804a\u5929\u4f1a\u8bdd\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
        }
        String startContent = "\u60a8\u597d\uff0c\u6211\u662f\u60a8\u6b64\u6b21\u95ee\u8bca\u7684\u533b\u751f\u3002";
        this.imInformService.doctorInquiryPrompted(admissionEntity.getXId(), startContent);
        this.imInformService.autoTreatmentCard(admissionEntity.getXId());
        String content = "\u60a8\u597d\uff0c\u8bf7\u60a8\u8010\u5fc3\u7b49\u5f85\uff0c\u6b63\u5728\u4e3a\u60a8\u8bca\u65ad\u5f00\u65b9\u3002";
        this.imInformService.doctorInquiryPrompted(admissionEntity.getXId(), content);
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(((MosClassicConfigRes)ycrmyy.getData()).getReciveDoctorId());
        BaseResponse personnelInfoBaseResponse = this.doctorCilent.queryPersonnelInfo(queryPersonnelInfoReq);
        if (!personnelInfoBaseResponse.isSuccess()) {
            return BaseResponse.error((String)"\u83b7\u53d6\u533b\u751f\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
        }
        FromOutlineVO fromOutlineVO = new FromOutlineVO();
        fromOutlineVO.setOrganId(orderEntity.getHospitalId());
        fromOutlineVO.setOrganName(orderEntity.getHospitalName());
        fromOutlineVO.setPresDoctorId(((MosClassicConfigRes)ycrmyy.getData()).getReciveDoctorId());
        fromOutlineVO.setPresDoctorName(((PersonnelInfo)personnelInfoBaseResponse.getData()).getDoctorName());
        fromOutlineVO.setPresDoctorPhone(((PersonnelInfo)personnelInfoBaseResponse.getData()).getPhoneNum());
        fromOutlineVO.setPresDoctorCode(((PersonnelInfo)personnelInfoBaseResponse.getData()).getEmplCode());
        fromOutlineVO.setPresDeptCode(((MosClassicConfigRes)ycrmyy.getData()).getReciveDeptId());
        fromOutlineVO.setPresDeptName(((MosClassicConfigRes)ycrmyy.getData()).getReciveDeptName());
        fromOutlineVO.setPatientId(orderEntity.getPatientId());
        fromOutlineVO.setPatientName(cardDetailsInfoRespVO.getPatientName());
        fromOutlineVO.setPatientNo(cardDetailsInfoRespVO.getOrganPmi());
        fromOutlineVO.setBirthDates(cardDetailsInfoRespVO.getBirth());
        fromOutlineVO.setPatientGender(String.valueOf(cardDetailsInfoRespVO.getGender()));
        fromOutlineVO.setPatientAge(String.valueOf(age));
        fromOutlineVO.setPatientPhone(cardDetailsInfoRespVO.getTel());
        fromOutlineVO.setPatientIdCard(cardDetailsInfoRespVO.getCredNo());
        fromOutlineVO.setPatientUserId(orderEntity.getPatientUserId());
        fromOutlineVO.setMedicalRecordNo(admissionEntity.getXId());
        fromOutlineVO.setOrderSeq(orderEntity.getOrderSeq());
        fromOutlineVO.setServCode(String.valueOf(ServiceTypeEnum.NOS.getValue()));
        fromOutlineVO.setServCodeName(ServiceTypeEnum.NOS.getDesc());
        fromOutlineVO.setPrice(BigDecimal.ZERO);
        fromOutlineVO.setRegisterTime(orderEntity.getXCreateTime());
        ObtainClassicPresReqDto obtainClassicPresReqDto = new ObtainClassicPresReqDto();
        obtainClassicPresReqDto.setAppCode(orderEntity.getAppCode());
        obtainClassicPresReqDto.setOrganId(orderEntity.getOrganId());
        obtainClassicPresReqDto.setOutLineOrderId(orderEntity.getXId());
        obtainClassicPresReqDto.setAdmissionId(admissionEntity.getXId());
        obtainClassicPresReqDto.setUniqueId(UUIDUtil.generateViewId());
        obtainClassicPresReqDto.setIcdName(orderReqVo.getIcdName());
        obtainClassicPresReqDto.setTcmIcdName(orderReqVo.getIcdName());
        obtainClassicPresReqDto.setDiagnostic(orderReqVo.getIcdName());
        obtainClassicPresReqDto.setPresType(Integer.valueOf(2));
        obtainClassicPresReqDto.setDrugAmount(Integer.valueOf(orderReqVo.getDosage().intValue()));
        obtainClassicPresReqDto.setCreatFlag("0");
        obtainClassicPresReqDto.setAgeNum(Integer.valueOf(orderReqVo.getDosage().intValue()));
        obtainClassicPresReqDto.setClassicPrescriptionId(orderReqVo.getClassicPrescriptionId());
        obtainClassicPresReqDto.setFromOutlineVO(fromOutlineVO);
        obtainClassicPresReqDto.setRemark(orderReqVo.getClassicPrescriptionName());
        BaseResponse mapBaseResponse = this.medicalCloudFeignClient.autObtainPres(obtainClassicPresReqDto);
        if (!mapBaseResponse.isSuccess()) {
            return BaseResponse.error((String)"\u5904\u65b9\u81ea\u52a8\u5f00\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
        }
        String endContent = "\u60a8\u7684\u5904\u65b9\u5df2\u5f00\u5177\u5b8c\u6210\uff0c\u8bf7\u70b9\u51fb\u5904\u65b9\u8fdb\u884c\u8d2d\u4e70\u836f\u54c1\uff0c\u82e5\u7528\u836f\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u4efb\u4f55\u4e0d\u9002\u75c7\u72b6\uff0c\u8bf7\u7acb\u5373\u505c\u836f\u5e76\u7ebf\u4e0b\u5c31\u533b\u3002";
        this.imInformService.doctorInquiryPrompted(admissionEntity.getXId(), endContent);
        log.info("\u5f00\u5177\u5904\u65b9\u6210\u529f\uff1a{}", mapBaseResponse.getData());
        SimulateOrderResVo resVo = new SimulateOrderResVo();
        resVo.setAdmId(admissionEntity.getXId());
        resVo.setMainId((String)mapBaseResponse.getData());
        return BaseResponse.success((Object)resVo);
    }

    public BaseResponse<VirtualConsultOrderResVo> virtualConsultOrdering(VirtualConsultOrderReqVo reqVo) {
        PatientCheckRequestBo patientCheckRequestBo = new PatientCheckRequestBo();
        patientCheckRequestBo.setPatientId(reqVo.getPatientId());
        patientCheckRequestBo.setDoctorId(reqVo.getDoctorId());
        patientCheckRequestBo.setOrganId(reqVo.getOrganId());
        patientCheckRequestBo.setServType(Integer.valueOf(2));
        patientCheckRequestBo.setUserId(reqVo.getUserId());
        patientCheckRequestBo.setPatientName(reqVo.getPatientName());
        patientCheckRequestBo.setUserPhone(reqVo.getUserPhone());
        patientCheckRequestBo.setIdCard(reqVo.getCredNo());
        patientCheckRequestBo.setCardNo(reqVo.getCardNo());
        patientCheckRequestBo.setCardType(CardTypeEnum.OUTPATIENT_CARD.getValue());
        BaseResponse patientInfoRespVO = this.patientService.checkPatient(patientCheckRequestBo);
        if (!patientInfoRespVO.isSuccess()) {
            return BaseResponse.error((String)patientInfoRespVO.getMsg());
        }
        String adminId = reqVo.getSource() + "_" + UUIDUtil.generateViewId();
        PatientDynamicMedicalReqVo medicalReqVo = new PatientDynamicMedicalReqVo();
        medicalReqVo.setAdmId(adminId);
        medicalReqVo.setPrimaryDiagno("Z71.900");
        medicalReqVo.setPatientId(reqVo.getPatientId());
        medicalReqVo.setMainSuit("\u54a8\u8be2");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("patientName", (Object)reqVo.getPatientName());
        jsonObject.put("patientSex", (Object)IDCardUtil.getGender((String)reqVo.getCredNo()));
        jsonObject.put("patientAge", (Object)IDCardUtil.getAge((String)reqVo.getCredNo()));
        jsonObject.put("conditionDescription", (Object)reqVo.getDiseaseDesc());
        jsonObject.put("question", (Object)reqVo.getDiseaseDesc());
        medicalReqVo.setMedicalDetail(jsonObject.toJSONString());
        medicalReqVo.setMedicalUserFills(jsonObject.toJSONString());
        medicalReqVo.setHospitalId(reqVo.getOrganId());
        medicalReqVo.setAppCode(reqVo.getAppCode());
        medicalReqVo.setServType(Integer.valueOf(2));
        String insertMedical = this.internetHospitalDetailInfoService.insertMedicalNew(medicalReqVo);
        if (StringUtils.isEmpty((String)insertMedical)) {
            return BaseResponse.error((String)"\u65b0\u5efa\u75c5\u5386\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
        }
        log.info("\u54a8\u8be2\u5ba2\u670d--\u65b0\u589e\u75c5\u5386\u6210\u529f");
        OrderEntity orderEntity = new OrderEntity();
        orderEntity.setServTime(Integer.valueOf(1440));
        orderEntity.setTotalNum(Integer.valueOf(10000));
        orderEntity.setXVersion(Long.valueOf(0L));
        orderEntity.setXId(reqVo.getSource() + "_" + UUIDUtil.generateViewId());
        orderEntity.setServType(Integer.valueOf(2));
        orderEntity.setAppCode(reqVo.getAppCode());
        orderEntity.setDeptId(Long.valueOf(reqVo.getDeptId()));
        orderEntity.setPayAmount(BigDecimal.ZERO);
        orderEntity.setOrderSeq(UUIDUtil.generateViewId());
        orderEntity.setIdCard(reqVo.getCredNo());
        orderEntity.setDealSeq(UUIDUtil.generateViewId());
        orderEntity.setPaymentTime(new Date());
        orderEntity.setPayMethod(ChannelCodeEnum.NOPAY.getValue());
        orderEntity.setStatus(OrderStatusEnum.PAID.getValue());
        orderEntity.setPatientId(reqVo.getPatientId());
        orderEntity.setDoctorId(reqVo.getDoctorId());
        orderEntity.setOrganId(reqVo.getOrganId());
        orderEntity.setPatientUserId(reqVo.getUserId());
        orderEntity.setDoctorName(reqVo.getDoctorName());
        orderEntity.setHospitalId(reqVo.getOrganId());
        orderEntity.setHospitalName(reqVo.getHospitalName());
        orderEntity.setDeptName(reqVo.getDeptName());
        orderEntity.setXCreateTime(new Date());
        orderEntity.setXUpdateTime(new Date());
        orderEntity.setDoctorType(reqVo.getDoctorType() == null ? DoctorTypeEnum.PERSONAL.getValue() : reqVo.getDoctorType());
        orderEntity.setPrice("0");
        orderEntity.setFundType(CODE);
        orderEntity.setSmallProgramSource("WX");
        orderEntity.setBillPayId(UUIDUtil.getUUID());
        orderEntity.setMedicalRecordId(insertMedical);
        log.info("\u54a8\u8be2\u5ba2\u670d===\u300b\u65b0\u589e0\u5143\u8ba2\u5355\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)orderEntity));
        this.orderMapper.insert((Object)orderEntity);
        AdmissionEntity admissionEntity = new AdmissionEntity();
        admissionEntity.setOrganId(orderEntity.getHospitalId());
        admissionEntity.setOrderId(orderEntity.getXId());
        admissionEntity.setPatientId(orderEntity.getPatientId());
        admissionEntity.setDoctorId(orderEntity.getDoctorId());
        admissionEntity.setDoctorType(orderEntity.getDoctorType());
        admissionEntity.setServType(orderEntity.getServType());
        admissionEntity.setServTime(orderEntity.getServTime());
        admissionEntity.setTotalNum(orderEntity.getTotalNum());
        admissionEntity.setCurrentNum(orderEntity.getTotalNum());
        admissionEntity.setDoctorName(orderEntity.getDoctorName());
        admissionEntity.setOrganId(orderEntity.getHospitalId());
        admissionEntity.setPauseTime(Long.valueOf(0L));
        admissionEntity.setXId(adminId);
        admissionEntity.setStartTime(new Date());
        admissionEntity.setEndTime(DateUtils.getDateAfter((Date)new Date(), (int)1));
        admissionEntity.setStatus(AdmissionStatusEnum.IN_CONSULTATION.getValue());
        admissionEntity.setReceptionTime(new Date());
        admissionEntity.setXCreateTime(new Date());
        admissionEntity.setXUpdateTime(new Date());
        admissionEntity.setXVersion(Long.valueOf(0L));
        admissionEntity.setConvertWaitTime(new Date());
        admissionEntity.setMedicalRecordId(insertMedical);
        log.info("\u54a8\u8be2\u5ba2\u670d===\u300badmissionEntity{}", (Object)JSON.toJSONString((Object)admissionEntity));
        this.admissionMapper.insertAdvisoryRecord(admissionEntity);
        log.info("\u54a8\u8be2\u5ba2\u670d===\u300b0\u5143\u5c31\u8bca\u8bb0\u5f55\u65b0\u589e\u6210\u529f");
        BaseResponse imSessionRes = this.payAsyncService.createImSession(orderEntity, admissionEntity);
        if (!imSessionRes.isSuccess()) {
            return BaseResponse.error((String)"\u521b\u5efa\u804a\u5929\u4f1a\u8bdd\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
        }
        VirtualConsultOrderResVo resVo = new VirtualConsultOrderResVo();
        resVo.setOrderId(orderEntity.getXId());
        resVo.setAdmId(admissionEntity.getXId());
        return BaseResponse.success((Object)resVo);
    }
}

