/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.receiver;

import com.alibaba.fastjson.JSONObject;
import com.alipay.api.domain.InqueryDoctorStatusData;
import com.alipay.api.domain.InquiryChannel;
import com.alipay.api.response.AlipayCommerceMedicalIndustrydataInquirydoctorstatusUploadResponse;
import com.ebaiyihui.framework.utils.StringUtil;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.service.manager.AliMedicalPushService;
import com.ebaiyihui.onlineoutpatient.core.utils.RedisUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorAliListVo;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorMessageEventsVo;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DoctorInformationStateService {
    private static final Logger log = LoggerFactory.getLogger(DoctorInformationStateService.class);
    public static final String FIRST_CONSULTATION = "FIRST_CONSULTATION";
    public static final String FURTHER_CONSULTATION = "FURTHER_CONSULTATION";
    public static final String IMAGE_INQUIRY = "IMAGE_INQUIRY";
    public static final int TWO = 2;
    public static final int NUMBER = -1;
    @Autowired
    private AliMedicalPushService aliMedicalPushService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ProjProperties projProperties;

    @RabbitListener(queues={"doctor.information.state"})
    @RabbitHandler
    public void addDoctorReceiver(DoctorMessageEventsVo doctorMessageEventsVo) {
        log.info("\u5f00\u59cb\u533b\u751f\u72b6\u6001\u4fe1\u606f\u540c\u6b65");
        Boolean alipayDoctorStartStart = this.projProperties.getAlipayDoctorStartStart();
        if (alipayDoctorStartStart == null || !alipayDoctorStartStart.booleanValue()) {
            log.info("\u533b\u751f\u72b6\u6001\u4fe1\u606f\u540c\u6b65-\u63a8\u9001\u72b6\u6001\u5173\u95ed\u6216\u7a7a\uff0c\u505c\u6b62\u6267\u884c\uff1a{}", (Object)alipayDoctorStartStart);
            return;
        }
        try {
            if (CollectionUtils.isEmpty((Collection)doctorMessageEventsVo.getDoctorListVo())) {
                log.info("\u533b\u751f\u72b6\u6001\u4fe1\u606f\u540c\u6b65-\u6570\u636e\u7a7a\uff0c\u505c\u6b62\u6267\u884c");
                return;
            }
            log.info("\u5f00\u59cb\u533b\u751f\u72b6\u6001\u4fe1\u606f\u540c\u6b65,\u533b\u751f\u6570\u91cf:" + doctorMessageEventsVo.getDoctorListVo().size());
            ArrayList<InqueryDoctorStatusData> doctorStatusList = new ArrayList<InqueryDoctorStatusData>();
            for (DoctorAliListVo doctor : doctorMessageEventsVo.getDoctorListVo()) {
                if (StringUtil.isEmpty((String)doctor.getIdCard())) {
                    log.info("\u8be5\u6761\u533b\u751f\u6570\u636e\u8eab\u4efd\u8bc1\u8bc1\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u8be5\u6761:{}", (Object)JSONObject.toJSONString((Object)doctor));
                    continue;
                }
                if (StringUtil.isEmpty((String)this.redisUtil.get("online:cache:doctor:pro:ALI_DOCTOR" + doctor.getIdCard()))) {
                    log.info("\u533b\u751f\u4fe1\u606f\u72b6\u6001\u540c\u6b65-\u8be5\u533b\u751f\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8df3\u8fc7\u6267\u884c\uff1akey{}", (Object)("online:cache:doctor:pro:ALI_DOCTOR" + doctor.getIdCard()));
                    continue;
                }
                InqueryDoctorStatusData inqueryDoctorStatusData = new InqueryDoctorStatusData();
                inqueryDoctorStatusData.setAverageTime(null);
                inqueryDoctorStatusData.setDoctorPlatformStatus(null == doctor.getOfficeStatus() ? "ONLINE" : (doctor.getOfficeStatus().equals(-1) ? "OFFLINE" : "ONLINE"));
                inqueryDoctorStatusData.setEvaluationScore(null);
                inqueryDoctorStatusData.setMerchantDoctorId(doctor.getDoctorId());
                inqueryDoctorStatusData.setIdNo(doctor.getIdCard());
                inqueryDoctorStatusData.setPracticingDoctorCertificateNo(null);
                inqueryDoctorStatusData.setNumOfPeopleServed(String.valueOf(doctor.getServTimes()));
                ArrayList<InquiryChannel> inquiryChannelList = new ArrayList<InquiryChannel>();
                for (Integer type : doctor.getTypes()) {
                    InquiryChannel inquiryChannel = new InquiryChannel();
                    inquiryChannel.setInquiryMode(IMAGE_INQUIRY);
                    inquiryChannel.setInquiryPrice(String.valueOf(doctor.getServiceConfigData().getPrice().setScale(2, RoundingMode.HALF_UP)));
                    inquiryChannel.setInquiryType(type.equals(2) ? FIRST_CONSULTATION : FURTHER_CONSULTATION);
                    String query = "doctorId=" + doctor.getDoctorId() + "&deptId=" + doctor.getDeptId() + "&organId=" + doctor.getOrganId() + "&serveCode=53110&selectDate=1";
                    String encodedQuery = URLEncoder.encode(query, "UTF-8");
                    String url = "alipays://platformapi/startapp?appId=2021003164692422&page=pages/doctorHomePage/pages/index&query=" + encodedQuery;
                    inquiryChannel.setInquiryUrl(url);
                    inquiryChannelList.add(inquiryChannel);
                }
                inqueryDoctorStatusData.setInquiryChannelList(inquiryChannelList);
                doctorStatusList.add(inqueryDoctorStatusData);
                log.info("\u63a8\u9001\u533b\u751f\u72b6\u6001\u4fe1\u606f\u5230\u652f\u4ed8\u5b9d\uff0c\u533b\u751f\u72b6\u6001\u4fe1\u606f:{}", (Object)JSONObject.toJSONString(doctorStatusList));
                AlipayCommerceMedicalIndustrydataInquirydoctorstatusUploadResponse response = this.aliMedicalPushService.doctorStatusUpload(doctorStatusList);
                if (response.isSuccess()) {
                    log.info("\u8c03\u7528\u6210\u529f:{}", (Object)JSONObject.toJSONString((Object)response));
                } else {
                    log.info("\u8c03\u7528\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + response.getMsg() + "\uff0c" + response.getSubMsg());
                }
                doctorStatusList = new ArrayList();
            }
            log.info("\u533b\u751f\u72b6\u6001\u4fe1\u606f\u540c\u6b65mq\u5b8c\u6210");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u533b\u751f\u72b6\u6001\u4fe1\u606f\u540c\u6b65mq\u6d88\u8d39\u5f02\u5e38" + e);
        }
        log.info("\u533b\u751f\u72b6\u6001\u4fe1\u606f\u540c\u6b65mq\u6d88\u8d39\u5b8c\u6bd5!");
    }
}

