/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.receiver;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ConsultationStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.OrderStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.PayBillStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.WhetherEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ZkPatPreOrderStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.MedicalAdmissionRefMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ScheduleRecordMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ServicePayBillMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.MedicalAdmissionRefEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ScheduleRecordEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ServicePayBillEntity;
import com.ebaiyihui.onlineoutpatient.core.sender.AliMedicalInformationSender;
import com.ebaiyihui.onlineoutpatient.core.sender.OrderSender;
import com.ebaiyihui.onlineoutpatient.core.service.AliSmsPushService;
import com.ebaiyihui.onlineoutpatient.core.service.AlipaySmallProgramPushService;
import com.ebaiyihui.onlineoutpatient.core.service.GoEasyPushService;
import com.ebaiyihui.onlineoutpatient.core.service.HisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.service.IMInformService;
import com.ebaiyihui.onlineoutpatient.core.service.OrderService;
import com.ebaiyihui.onlineoutpatient.core.service.PayCallBackService;
import com.ebaiyihui.onlineoutpatient.core.service.SmallProgramPushService;
import com.ebaiyihui.onlineoutpatient.core.service.UmAppPushService;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryOrderServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.nczk.ZkbgService;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.HttpKit;
import com.ebaiyihui.onlineoutpatient.core.utils.RedisUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.AdmissionOrCancellationReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.AdmissionOrCancellationResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorMessageEventsVo;
import com.ebaiyihui.onlineoutpatient.core.vo.OrderTaskVo;
import com.ebaiyihui.onlineoutpatient.core.vo.RequestRefundVo;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.ZkbgRefundVo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@Component
public class TopicCustomerService {
    private static final Logger log = LoggerFactory.getLogger(TopicCustomerService.class);
    @Autowired
    private OrderService orderService;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private PayCallBackService payCallBackService;
    @Autowired
    private UmAppPushService umAppPushService;
    @Autowired
    private OrderSender orderSender;
    @Autowired
    private SmallProgramPushService smallProgramPushService;
    @Autowired
    private AlipaySmallProgramPushService alipaySmallProgramPushService;
    @Autowired
    private BaseInquiryOrderServiceImpl baseInquiryOrderService;
    @Resource
    private IMInformService imInformService;
    @Autowired
    private HisTemplateService hisTemplateService;
    private ServicePayBillMapper servicePayBillMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private ZkbgService zkbgService;
    @Autowired
    private MedicalAdmissionRefMapper medicalAdmissionRefMapper;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    AliMedicalInformationSender aliMedicalInformationSender;
    @Autowired
    private GoEasyPushService goEasyPushService;
    @Autowired
    private AliSmsPushService aliSmsPushService;
    private ExecutorService executor = Executors.newCachedThreadPool();

    @RabbitListener(queues={"byh-online-outpatient-delay-queue"})
    public void orderDelayQueue1(@Payload OrderTaskVo orderTaskVo) {
        log.info("\u5b9a\u65f6\u4efb\u52a1\u76d1\u542c\u7ed3\u679c\uff1a{}", (Object)orderTaskVo.toString());
        try {
            AdmissionEntity admissionEntity;
            String id = orderTaskVo.getId();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            log.info("\u3010orderDelayQueue \u76d1\u542c\u7684\u6d88\u606f\u3011 - \u3010\u6d88\u8d39\u65f6\u95f4\u3011 - [{}]- \u3010\u8ba2\u5355ID\u3011 - [{}]", (Object)new Date(), (Object)id);
            OrderEntity orderEntity = (OrderEntity)this.orderMapper.selectById((Serializable)((Object)id));
            if (null == orderEntity) {
                return;
            }
            Boolean flag = true;
            if (null == orderEntity.getScheduleDate() && StringUtils.isEmpty((String)orderEntity.getScheduleId())) {
                flag = false;
            }
            if (orderTaskVo.getType() == 1 && orderEntity.getStatus().equals(OrderStatusEnum.TOPAY.getValue())) {
                if (Objects.equals(orderEntity.getFundType(), "2")) {
                    String url = this.projProperties.getBaseAddress() + "/medicare/medicalPayment/ybAliUndoOrder";
                    String data = this.redisUtil.get("yb_" + orderEntity.getXId());
                    if (StringUtils.isNotBlank((String)data)) {
                        try {
                            String result = HttpKit.jsonPost((String)url, (String)data);
                            log.info("\u533b\u4fdd\u64a4\u9500\u7ed3\u679c\uff1a{}", (Object)result);
                            this.redisUtil.del("yb_" + orderEntity.getXId());
                        }
                        catch (Exception e) {
                            log.info("\u533b\u4fdd\u64a4\u9500\u5931\u8d25\uff1a{}", (Throwable)e);
                        }
                    }
                }
                log.info("\u3010\u5728\u7ebf\u95ee\u8bca\u65e0\u6392\u73ed\u8ba2\u5355\u672a\u652f\u4ed8\uff0c\u53d6\u6d88\u8be5\u8ba2\u5355\u3011" + orderEntity.toString());
                this.orderService.updateStatusById(id, OrderStatusEnum.CANCEL.getValue());
                this.servicePayBillMapper.deleteById((Serializable)((Object)orderEntity.getBillPayId()));
                log.info("\u8ba2\u535530\u5206\u949f\u672a\u652f\u4ed8\uff0c\u5220\u9664\u8d26\u5355\u8868\u4e2d\u8bb0\u5f55");
                this.aliMedicalInformationSender.sendOrderInformationData(new DoctorMessageEventsVo(orderEntity.getXId()));
                if (flag.booleanValue()) {
                    log.info("\u3010\u5728\u7ebf\u95ee\u8bca\u6709\u6392\u73ed\u8ba2\u5355\u672a\u652f\u4ed8\uff0c\u53d6\u6d88\u8be5\u8ba2\u5355\u3011\uff1a{}", (Object)orderEntity.toString());
                    QueryWrapper queryWrapper = new QueryWrapper();
                    ScheduleRecordEntity scheduleRecordEntity = new ScheduleRecordEntity();
                    scheduleRecordEntity.setId(Long.valueOf(orderEntity.getScheduleId()));
                    queryWrapper.setEntity((Object)scheduleRecordEntity);
                    ScheduleRecordEntity scheduleOne = (ScheduleRecordEntity)this.scheduleRecordMapper.selectOne((Wrapper)queryWrapper);
                    if (null != scheduleOne && WhetherEnum.ALLOW.getValue().equals(scheduleOne.getStatus())) {
                        this.scheduleRecordMapper.addAvailableCount(scheduleOne.getId());
                        return;
                    }
                    return;
                }
                return;
            }
            if (orderTaskVo.getType() == 3) {
                admissionEntity = this.admissionMapper.queryAdmByOrderId(id);
                if (null == admissionEntity) {
                    log.info("\u5c31\u8bca\u8bb0\u5f55\u4e0d\u5b58\u5728");
                    return;
                }
                log.info("\u5230\u8fbe\u590d\u8bca\u65f6\u95f4\u70b9\uff0c\u63d0\u793a\u60a3\u8005\u53bb\u5019\u8bca");
                try {
                    this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                    this.umAppPushService.patientWaiteRemindAppPush(admissionEntity.getXId());
                }
                catch (Exception e) {
                    log.error("\u51fa\u73b0\u5f02\u5e38 \u63a8\u9001\u5931\u8d25");
                    return;
                }
                admissionEntity.setConvertWaitTime(new Date());
                this.admissionMapper.updateById((Object)admissionEntity);
                this.admissionMapper.updateAdmissionStatusById(admissionEntity.getXId(), AdmissionStatusEnum.TO_BE_RECEIVED.getValue(), null);
                log.info("\u5230\u8fbe\u590d\u8bca\u65f6\u95f4\u70b9\uff0c\u63d0\u793a\u60a3\u8005\u53bb\u8bca\u7597");
                this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
            if (orderTaskVo.getType() == 4) {
                admissionEntity = this.admissionMapper.queryAdmByOrderId(id);
                OrderEntity byId = this.orderService.findById(id);
                if (null == admissionEntity) {
                    log.info("\u5c31\u8bca\u8bb0\u5f55\u4e0d\u5b58\u5728");
                    return;
                }
                if (null == byId) {
                    log.info("\u8ba2\u5355\u4e0d\u5b58\u5728");
                    return;
                }
                if (admissionEntity.getStatus().equals(AdmissionStatusEnum.WAIT_ADMISSION.getValue())) {
                    log.info("======\u5b9a\u65f6\u5904\u7406\u60a3\u8005\u672a\u70b9\u51fb'\u5019\u8bca\u62a5\u9053\u63a5\u53e3'  \u89c6\u4e3a\u8fc7\u671f\u8ba2\u5355=====");
                    AdmissionEntity admission = new AdmissionEntity();
                    admission.setStatus(AdmissionStatusEnum.EXPIRED.getValue());
                    admission.setXId(admissionEntity.getXId());
                    admission.setXRemark("\u60a3\u8005\u8d85\u65f6\u672a\u5019\u8bca");
                    this.admissionMapper.update(admission);
                    if (orderEntity.getPayAmount().compareTo(BigDecimal.ZERO) == 0) {
                        this.orderService.updateStatusById(id, OrderStatusEnum.EXPIRED.getValue());
                    } else {
                        RequestRefundVo requestRefundVo = new RequestRefundVo();
                        requestRefundVo.setOrderId(id);
                        BaseResponse baseResponse = this.payCallBackService.refundCalls(requestRefundVo);
                        this.orderService.updateStatusById(id, OrderStatusEnum.REFUNDED.getValue());
                    }
                    this.aliMedicalInformationSender.sendOrderInformationData(new DoctorMessageEventsVo(orderEntity.getXId()));
                    return;
                }
                if (admissionEntity.getStatus().equals(AdmissionStatusEnum.TO_BE_RECEIVED.getValue()) || AdmissionStatusEnum.PASSNUMBER.getValue().equals(admissionEntity.getStatus()) || admissionEntity.getStatus().equals(AdmissionStatusEnum.IN_CONSULTATION.getValue()) && admissionEntity.getConsultationStatus().equals(ConsultationStatusEnum.CONFIRMED_CONSULTATION.getValue())) {
                    log.info("====\u5b9a\u65f6\u5904\u7406\u5df2\u5019\u8bca\u4f46\u662f\u672a\u63a5\u5f85\u7684 \u8fc7\u671f\u8ba2\u5355 \u8fdb\u884c\u4e2d\u60a3\u8005\u672a\u786e\u8ba4\u95ee\u8bca  \u9700\u505a\u9000\u6b3e\u5904\u7406====");
                    if (orderEntity.getPayAmount().compareTo(BigDecimal.ZERO) == 0) {
                        AdmissionEntity admission = new AdmissionEntity();
                        if (admissionEntity.getStatus().equals(AdmissionStatusEnum.PASSNUMBER.getValue())) {
                            log.info("\u8fc7\u53f7\u60a3\u8005\u8d85\u65f60\u5143\u672a\u91cd\u65b0\u5019\u8bca\u8fdb\u5165");
                            this.imInformService.passNumOutTimeToPat(admissionEntity.getXId());
                            this.imInformService.passNumOutTimeToDoc(admissionEntity);
                            admission.setXRemark("\u8fc7\u53f7\u8d85\u65f6\u672a\u91cd\u65b0\u5019\u8bca\u9000\u6b3e");
                            this.scheduleRecordMapper.addAvailableCount(Long.valueOf(byId.getScheduleId()));
                        }
                        if (admissionEntity.getStatus().equals(AdmissionStatusEnum.IN_CONSULTATION.getValue()) && admissionEntity.getConsultationStatus().equals(ConsultationStatusEnum.CONFIRMED_CONSULTATION.getValue())) {
                            admission.setStatus(AdmissionStatusEnum.EXPIRED.getValue());
                        } else {
                            admission.setStatus(AdmissionStatusEnum.REFUNDED_REFUSE_ZERO.getValue());
                        }
                        admission.setXId(admissionEntity.getXId());
                        this.admissionMapper.update(admission);
                        this.aliMedicalInformationSender.sendOrderInformationData(new DoctorMessageEventsVo(admission.getOrderId()));
                        return;
                    }
                    AdmissionEntity admissionentity = new AdmissionEntity();
                    admissionentity.setXId(admissionEntity.getXId());
                    if (admissionEntity.getStatus().equals(AdmissionStatusEnum.TO_BE_RECEIVED.getValue())) {
                        admissionentity.setXRemark("\u8d85\u65f6\u672a\u63a5\u8bca\u9000\u6b3e");
                        admissionentity.setStatus(AdmissionStatusEnum.NOT_RECEIVED_TIME_OUT.getValue());
                    }
                    if (admissionEntity.getStatus().equals(AdmissionStatusEnum.PASSNUMBER.getValue())) {
                        log.info("\u8fc7\u53f7\u60a3\u8005\u8d85\u65f6\u672a\u91cd\u65b0\u5019\u8bca\u8fdb\u5165");
                        if ("HYT".equals(byId.getAppCode()) && StringUtils.isNotEmpty((String)byId.getClinicCode())) {
                            AdmissionOrCancellationReqVo admissionOrCancellationReqVo = new AdmissionOrCancellationReqVo();
                            admissionOrCancellationReqVo.setClinicCode(byId.getClinicCode());
                            admissionOrCancellationReqVo.setYnSee("0");
                            AdmissionOrCancellationResVo admissionOrCancellation = this.hisTemplateService.admissionOrCancellation(admissionOrCancellationReqVo);
                            if (null == admissionOrCancellation) {
                                log.info("\u53d6\u6d88\u63a5\u8bca\u5931\u8d25");
                                return;
                            }
                        }
                        this.imInformService.passNumOutTimeToPat(admissionEntity.getXId());
                        this.imInformService.passNumOutTimeToDoc(admissionEntity);
                        admissionentity.setStatus(AdmissionStatusEnum.EXPIRED.getValue());
                        admissionentity.setXRemark("\u8fc7\u53f7\u8d85\u65f6\u672a\u91cd\u65b0\u5019\u8bca\u9000\u6b3e");
                        this.scheduleRecordMapper.addAvailableCount(Long.valueOf(byId.getScheduleId()));
                    }
                    if (admissionEntity.getStatus().equals(AdmissionStatusEnum.IN_CONSULTATION.getValue()) && admissionEntity.getConsultationStatus().equals(ConsultationStatusEnum.CONFIRMED_CONSULTATION.getValue())) {
                        admissionentity.setXRemark("\u60a3\u8005\u9884\u7ea6\u65f6\u95f4\u5185\u672a\u786e\u8ba4\u95ee\u8bca");
                        admissionentity.setStatus(AdmissionStatusEnum.EXPIRED.getValue());
                    }
                    RequestRefundVo requestRefundVo = new RequestRefundVo();
                    requestRefundVo.setOrderId(id);
                    BaseResponse baseResponse = this.payCallBackService.refundCalls(requestRefundVo);
                    log.info("\u8fc7\u671f\u672a\u63a5\u8bca\u9000\u6b3e\u8bf7\u6c42\u7ed3\u679c\uff1abaseResponse{}", (Object)JSON.toJSONString((Object)baseResponse));
                    this.admissionMapper.update(admissionentity);
                    this.orderService.updateStatusById(id, OrderStatusEnum.REFUNDED.getValue());
                    if (StringUtils.isNotEmpty((String)orderEntity.getBillRefundId())) {
                        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
                        servicePayBillEntity.setId(orderEntity.getBillRefundId());
                        servicePayBillEntity.setStatus(PayBillStatusEnum.REFUNDED.getValue());
                        this.servicePayBillMapper.updateById((Object)servicePayBillEntity);
                    }
                    this.imInformService.expireRefund(admissionEntity.getXId());
                    this.aliMedicalInformationSender.sendOrderInformationData(new DoctorMessageEventsVo(admissionEntity.getOrderId()));
                    return;
                }
            }
            if (orderTaskVo.getType() == 2) {
                admissionEntity = this.admissionMapper.queryAdmByOrderId(id);
                if (null == admissionEntity) {
                    log.info("\u5c31\u8bca\u8bb0\u5f55\u4e0d\u5b58\u5728");
                    return;
                }
                if (admissionEntity.getStatus().equals(AdmissionStatusEnum.TO_BE_RECEIVED.getValue())) {
                    if (orderEntity.getPayAmount().compareTo(BigDecimal.ZERO) == 0) {
                        admissionEntity.setStatus(AdmissionStatusEnum.REFUNDED_REFUSE_ZERO.getValue());
                        this.admissionMapper.update(admissionEntity);
                        this.imInformService.expireRefund(admissionEntity.getXId());
                        this.aliMedicalInformationSender.sendOrderInformationData(new DoctorMessageEventsVo(admissionEntity.getOrderId()));
                        this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                        return;
                    }
                    admissionEntity.setStatus(AdmissionStatusEnum.NOT_RECEIVED_TIME_OUT.getValue());
                    this.orderService.updateStatusById(id, OrderStatusEnum.REFUNDED.getValue());
                    if (StringUtils.isNotEmpty((String)orderEntity.getBillRefundId())) {
                        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
                        servicePayBillEntity.setId(orderEntity.getBillRefundId());
                        servicePayBillEntity.setStatus(PayBillStatusEnum.REFUNDED.getValue());
                        this.servicePayBillMapper.updateById((Object)servicePayBillEntity);
                    }
                    admissionEntity.setMessage("\u8d85\u65f6\u672a\u63a5\u8bca\u9000\u6b3e");
                    admissionEntity.setXRemark("\u8d85\u65f6\u672a\u63a5\u8bca\u9000\u6b3e");
                    this.admissionMapper.update(admissionEntity);
                    RequestRefundVo requestRefundVo = new RequestRefundVo();
                    requestRefundVo.setOrderId(orderEntity.getXId());
                    BaseResponse baseResponse = this.payCallBackService.refundCalls(requestRefundVo);
                    this.aliMedicalInformationSender.sendOrderInformationData(new DoctorMessageEventsVo(admissionEntity.getOrderId()));
                    this.imInformService.expireRefund(admissionEntity.getXId());
                    this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                    return;
                }
                return;
            }
            if (orderTaskVo.getType() == 5) {
                log.info("\u5b9a\u65f6\u5904\u7406\u54a8\u8be2\u4e2d\u5c31\u8bca\u8bb0\u5f55\u54a8\u8be2\u65f6\u95f4\u5230\u671f\u7684\u8fc7\u671f\u5904\u7406\u4efb\u52a1++++++");
                Boolean flags = this.processConsultationOrder(id);
                if (!flags.booleanValue()) {
                    log.info("\u5c31\u8bca\u8bb0\u5f55\u4e0d\u5b58\u5728");
                    return;
                }
                return;
            }
            if (orderTaskVo.getType() == 6) {
                log.info("===\u533b\u751f\u8ddd\u79bb\u95ee\u8bca\u7ed3\u675f10\u5206\u949f\u524d\u672a\u5f00\u5177\u8bca\u7597\u610f\u89c1\u6216\u8005\u590d\u8bca\u75c5\u4f8b\u8fdb\u884c\u63a8\u9001====");
                admissionEntity = this.admissionMapper.queryAdmByOrderId(orderTaskVo.getId());
                if (null == admissionEntity) {
                    log.info("\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u8ba2\u5355");
                    return;
                }
                if (!AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admissionEntity.getStatus())) {
                    log.info("+++++++++++++\u4e0d\u662f\u95ee\u8bca\u4e2d\u72b6\u6001+++++++++++++");
                    return;
                }
                if (AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admissionEntity.getStatus())) {
                    log.info("+++++++++++++++\u95ee\u8bca\u4e2d\uff0c\u7b26\u5408\u6d88\u606f\u6d88\u8d39\u6761\u4ef6++++++++++++++");
                    try {
                        this.imInformService.tenMinutesBeforeEnd(admissionEntity.getXId());
                        this.umAppPushService.noMedicalOpinionFollowUpCaseAppPush(admissionEntity.getXId());
                    }
                    catch (Exception e) {
                        log.info("\u533b\u751f\u8ddd\u79bb\u95ee\u8bca\u7ed3\u675f10\u5206\u949f\u524d\u672a\u5f00\u5177\u8bca\u7597\u610f\u89c1\u6216\u8005\u590d\u8bca\u75c5\u4f8b\u63a8\u9001\u5931\u8d25:{}", (Throwable)e);
                    }
                    log.info("\u533b\u751f\u8ddd\u79bb\u95ee\u8bca\u7ed3\u675f10\u5206\u949f\u524d\u672a\u5f00\u5177\u8bca\u7597\u610f\u89c1\u6216\u8005\u590d\u8bca\u75c5\u4f8b\u63a8\u9001\u6210\u529f");
                    return;
                }
                return;
            }
            if (orderTaskVo.getType() == 7) {
                log.info("\u5904\u7406\u4f17\u5eb7\u8ba2\u5355\u8d85\u65f6\u7ed3\u675f");
                admissionEntity = this.admissionMapper.queryAdmByOrderId(orderTaskVo.getId());
                if (new Date().before(admissionEntity.getEndTime())) {
                    OrderTaskVo orderTaskVo1 = new OrderTaskVo();
                    orderTaskVo1.setType(Integer.valueOf(7));
                    orderTaskVo1.setId(admissionEntity.getOrderId());
                    this.orderSender.sendDelay(orderTaskVo1);
                }
                if (AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admissionEntity.getStatus())) {
                    MedicalAdmissionRefEntity medicalAdmissionRefEntity = (MedicalAdmissionRefEntity)this.medicalAdmissionRefMapper.selectOne((Wrapper)new QueryWrapper().lambda().eq(MedicalAdmissionRefEntity::getAdmissionId, (Object)admissionEntity.getXId()));
                    try {
                        if (Objects.equals(1, orderEntity.getKeepOrder())) {
                            ZkbgRefundVo zkbgRefundVo = new ZkbgRefundVo();
                            zkbgRefundVo.setAdmId(admissionEntity.getXId());
                            zkbgRefundVo.setStatus("2");
                            this.zkbgService.refund(zkbgRefundVo);
                        }
                        medicalAdmissionRefEntity.setPreStatus(ZkPatPreOrderStatusEnum.REFUND_PRE.getValue());
                        this.medicalAdmissionRefMapper.updateById((Object)medicalAdmissionRefEntity);
                        admissionEntity.setStatus(AdmissionStatusEnum.FINISH_APPLY.getValue());
                        String remark = "\u8ba2\u5355\u8d85\u65f6\u7ed3\u675f";
                        admissionEntity.setXRemark(remark);
                        this.admissionMapper.update(admissionEntity);
                        this.imInformService.zkFastPreFailDoc(admissionEntity.getXId(), remark);
                    }
                    catch (Exception e) {
                        log.info("\u5b9a\u65f6\u5904\u7406\u4f17\u5eb7\u8ba2\u5355\u8d85\u65f6\u7ed3\u675f\u5931\u8d25:{}", (Throwable)e);
                    }
                }
                return;
            }
            if (orderTaskVo.getType() == 8) {
                admissionEntity = this.admissionMapper.queryAdmByOrderId(id);
                if (null == admissionEntity) {
                    log.info("\u5c31\u8bca\u8bb0\u5f55\u4e0d\u5b58\u5728");
                    return;
                }
                this.smallProgramPushService.OverdueFollowUp(id);
                return;
            }
        }
        catch (Exception e) {
            log.info("orderDelayQueue\u76d1\u542c\u5f02\u5e38", (Throwable)e);
            return;
        }
    }

    private Boolean processConsultationOrder(String orderId) {
        Date nowDate = new Date();
        AdmissionEntity admissionEntity = this.admissionMapper.queryAdmByOrderId(orderId);
        OrderEntity orderEntity = this.orderService.findById(orderId);
        if (null == admissionEntity) {
            log.info("\u5c31\u8bca\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return false;
        }
        if (null == orderEntity) {
            log.info("\u8ba2\u5355\u4e0d\u5b58\u5728");
            return false;
        }
        log.info("\u8d85\u65f6\u5df2\u5b8c\u6210\u8ba2\u5355\u72b6\u6001\u63a8\u9001:{}", (Object)JSON.toJSONString((Object)admissionEntity));
        log.info("IN_CONSULTATION:{}", (Object)AdmissionStatusEnum.IN_CONSULTATION.getValue());
        log.info("status:{}", (Object)admissionEntity.getStatus());
        log.info("consultationStatus:{}", (Object)admissionEntity.getConsultationStatus());
        log.info("CONFIRMED_CONSULTATION:{}", (Object)ConsultationStatusEnum.CONFIRMED_CONSULTATION.getValue());
        log.info("flag={}", (Object)(AdmissionStatusEnum.IN_CONSULTATION.getValue() == admissionEntity.getStatus() && admissionEntity.getConsultationStatus() == ConsultationStatusEnum.CONFIRMED_CONSULTATION.getValue() ? 1 : 0));
        if (AdmissionStatusEnum.IN_CONSULTATION.getValue() == admissionEntity.getStatus() && admissionEntity.getConsultationStatus() == ConsultationStatusEnum.CONFIRMED_CONSULTATION.getValue()) {
            if (admissionEntity.getEndTime().after(nowDate)) {
                log.info("\u5b9a\u65f6\u5904\u7406\u54a8\u8be2\u4e2d  \u8ba2\u5355\u6709\u5ef6\u65f6 \u91cd\u65b0\u653e\u5165\u961f\u5217++++++");
                OrderTaskVo orderTaskVo = new OrderTaskVo();
                orderTaskVo.setType(Integer.valueOf(5));
                orderTaskVo.setId(orderId);
                int expireTime = DateUtils.secondsBetween((Date)nowDate, (Date)admissionEntity.getEndTime());
                if (2592000 < expireTime) {
                    log.info("\u5ef6\u8fdf\u65f6\u95f4\u8fc7\u957f\uff0c\u53d6\u6d88\u81ea\u52a8\u7ed3\u675f");
                    return true;
                }
                this.orderSender.sendDelay(orderTaskVo);
                return true;
            }
            log.info("====\u5b9a\u65f6\u5904\u7406\u8fdb\u884c\u4e2d\u60a3\u8005\u672a\u786e\u8ba4\u95ee\u8bca  \u9700\u505a\u9000\u6b3e\u5904\u7406====");
            if (orderEntity.getPayAmount().compareTo(BigDecimal.ZERO) == 0) {
                AdmissionEntity admission = new AdmissionEntity();
                admission.setStatus(AdmissionStatusEnum.EXPIRED.getValue());
                admission.setXId(admissionEntity.getXId());
                admission.setXRemark("\u8d85\u65f6\u672a\u786e\u8ba4\u5019\u8bca\u9000\u6b3e");
                this.admissionMapper.update(admission);
                this.imInformService.notConfirmedManager(admissionEntity.getXId());
                this.aliMedicalInformationSender.sendOrderInformationData(new DoctorMessageEventsVo(admission.getOrderId()));
                return true;
            }
            AdmissionEntity admissionentity = new AdmissionEntity();
            admissionentity.setXId(admissionEntity.getXId());
            admissionentity.setXRemark("\u60a3\u8005\u9884\u7ea6\u65f6\u95f4\u5185\u672a\u786e\u8ba4\u95ee\u8bca");
            RequestRefundVo requestRefundVo = new RequestRefundVo();
            requestRefundVo.setOrderId(orderId);
            BaseResponse baseResponse = this.payCallBackService.refundCalls(requestRefundVo);
            log.info("\u8fc7\u671f\u786e\u8ba4\u95ee\u8bca\u9000\u6b3e\u8bf7\u6c42\u7ed3\u679c\uff1abaseResponse{}", (Object)JSON.toJSONString((Object)baseResponse));
            admissionentity.setStatus(AdmissionStatusEnum.EXPIRED.getValue());
            this.admissionMapper.update(admissionentity);
            this.orderService.updateStatusById(orderId, OrderStatusEnum.REFUNDED.getValue());
            if (StringUtils.isNotEmpty((String)orderEntity.getBillRefundId())) {
                ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
                servicePayBillEntity.setId(orderEntity.getBillRefundId());
                servicePayBillEntity.setStatus(PayBillStatusEnum.REFUNDED.getValue());
                this.servicePayBillMapper.updateById((Object)servicePayBillEntity);
            }
            this.imInformService.managerRefund(admissionEntity.getXId());
            this.aliMedicalInformationSender.sendOrderInformationData(new DoctorMessageEventsVo(admissionEntity.getOrderId()));
            log.info("++++++\u8d85\u65f6\u60a3\u8005\u672a\u786e\u8ba4\u95ee\u8bca\u7ed3\u675f\u8fd4\u56detrue++++++");
            return true;
        }
        if (AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admissionEntity.getStatus())) {
            if (admissionEntity.getEndTime().after(nowDate)) {
                log.info("\u5b9a\u65f6\u5904\u7406\u54a8\u8be2\u4e2d  \u8ba2\u5355\u6709\u5ef6\u65f6 \u91cd\u65b0\u653e\u5165\u961f\u5217++++++");
                OrderTaskVo orderTaskVo = new OrderTaskVo();
                orderTaskVo.setType(Integer.valueOf(5));
                orderTaskVo.setId(orderId);
                int expireTime = DateUtils.secondsBetween((Date)nowDate, (Date)admissionEntity.getEndTime());
                if (2592000 < expireTime) {
                    log.info("\u5ef6\u8fdf\u65f6\u95f4\u8fc7\u957f\uff0c\u53d6\u6d88\u81ea\u52a8\u7ed3\u675f");
                    return true;
                }
                this.orderSender.sendDelay(orderTaskVo);
                return true;
            }
            log.info("\u5b9a\u65f6\u5904\u7406\u54a8\u8be2\u4e2d  \u8ba2\u5355\u65e0\u5ef6\u65f6  \u4fee\u6539\u8ba2\u5355\u72b6\u6001\u4e3a \u8d85\u65f6\u5df2\u5b8c\u6210++++++");
            admissionEntity.setStatus(AdmissionStatusEnum.FINISH_TIME_OUT.getValue());
            admissionEntity.setCurrentNum(Integer.valueOf(0));
            admissionEntity.setXUpdateTime(new Date());
            this.admissionMapper.update(admissionEntity);
            this.aliMedicalInformationSender.sendOrderInformationData(new DoctorMessageEventsVo(admissionEntity.getOrderId()));
            log.info("++++++\u8d85\u65f6\u7ed3\u675f\u5f02\u6b65\u63a8\u9001++++++");
            this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            log.info("++++++\u8d85\u65f6\u7ed3\u675f\u8fd4\u56detrue++++++");
            return true;
        }
        log.info("++++++\u8d85\u65f6\u7ed3\u675f\u8fd4\u56defalse++++++");
        return false;
    }

    private OrderEntity getOrderById(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        OrderEntity wrapperEntity = new OrderEntity();
        wrapperEntity.setXId(id);
        queryWrapper.setEntity((Object)wrapperEntity);
        OrderEntity orderEntity = (OrderEntity)this.baseInquiryOrderService.getOne((Wrapper)queryWrapper);
        if (null == orderEntity) {
            return null;
        }
        return orderEntity;
    }

    @RabbitListener(queues={"inquiry.end.pre"})
    @RabbitHandler
    public void threeMinPre(String admId) {
        log.info("----------------\u63a5\u6536\u5ef6\u8fdf\u961f\u5217\u6d88\u606f--------------------");
        log.info("\u63a5\u6536\u65f6\u95f4:{}", (Object)DateUtils.getCurrentDateToString());
        log.info("\u6d88\u606f\u6d88\u8d39\u8005\uff0c\u5b9a\u65f6\u4efb\u52a1\u76d1\u542c\u7ed3\u679c,{}", (Object)admId);
        AdmissionEntity admissionEntity = this.admissionMapper.findById(admId);
        if (null == admissionEntity) {
            log.info("\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u8ba2\u5355");
            return;
        }
        if (!AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admissionEntity.getStatus())) {
            log.info("+++++++++++++\u4e0d\u662f\u95ee\u8bca\u4e2d\u72b6\u6001+++++++++++++");
            return;
        }
        if (AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admissionEntity.getStatus())) {
            log.info("+++++++++++++++\u95ee\u8bca\u4e2d\uff0c\u7b26\u5408\u6d88\u606f\u6d88\u8d39\u6761\u4ef6++++++++++++++");
            Date nowDate = new Date();
            int i = DateUtils.secondsBetween((Date)nowDate, (Date)admissionEntity.getEndTime());
            if (i == 180 && (admissionEntity.getExtendTimes() == 0 || admissionEntity.getExtendTimes() == 1)) {
                this.imInformService.inquiryEndPre(admId);
                this.umAppPushService.inquiryEndPreAppPush(admId);
            } else if (i > 180 && (admissionEntity.getExtendTimes() == 0 || admissionEntity.getExtendTimes() == 1)) {
                log.info("\u95ee\u8bca\u7ed3\u675f\u65f6\u95f4\u5df2\u7ecf\u88ab\u533b\u751f\u5ef6\u8fdf\uff0c\u6d88\u606f\u6d88\u8d39\u65f6\u95f4\u7531\u5ef6\u8fdf\u65f6\u95f4\u63a8\u8fdf");
            } else {
                log.info("\u95ee\u8bca\u5373\u5c06\u7ed3\u675f");
            }
        }
    }

    static /* synthetic */ SmallProgramPushService access$000(TopicCustomerService x0) {
        return x0.smallProgramPushService;
    }

    static /* synthetic */ AlipaySmallProgramPushService access$100(TopicCustomerService x0) {
        return x0.alipaySmallProgramPushService;
    }

    static /* synthetic */ IMInformService access$200(TopicCustomerService x0) {
        return x0.imInformService;
    }

    static /* synthetic */ AliSmsPushService access$300(TopicCustomerService x0) {
        return x0.aliSmsPushService;
    }

    static /* synthetic */ UmAppPushService access$400(TopicCustomerService x0) {
        return x0.umAppPushService;
    }

    static /* synthetic */ GoEasyPushService access$500(TopicCustomerService x0) {
        return x0.goEasyPushService;
    }

    static /* synthetic */ Logger access$600() {
        return log;
    }

    static /* synthetic */ OrderEntity access$700(TopicCustomerService x0, String x1) {
        return x0.getOrderById(x1);
    }
}

