/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.sender;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorMessageEventsVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AliMedicalInformationSender {
    private static final Logger log = LoggerFactory.getLogger(AliMedicalInformationSender.class);
    @Autowired
    private AmqpTemplate rabbitTemplate;

    public void sendDoctorInformationData(DoctorMessageEventsVo doctorMessageEventsVo) {
        log.info("-------------\u652f\u4ed8\u5b9d\u540c\u6b65\u3010\u533b\u751f\u3011\u4fe1\u606f\u961f\u5217-------------");
        this.rabbitTemplate.convertAndSend("byh-online-outpatient-delay-exchange", "doctor.information.data.key", (Object)doctorMessageEventsVo, message -> {
            message.getMessageProperties().setHeader("x-delay", (Object)0);
            log.info("\u6dfb\u52a0\u5b8c\u6210\uff1a" + JSONObject.toJSONString((Object)doctorMessageEventsVo));
            return message;
        });
        log.info("--------------\u652f\u4ed8\u5b9d\u540c\u6b65\u3010\u533b\u751f\u3011\u961f\u5217\u6dfb\u52a0\u5b8c\u6210--------------");
    }

    public void sendDoctorInformationState(DoctorMessageEventsVo doctorMessageEventsVo) {
        log.info("-------------\u652f\u4ed8\u5b9d\u540c\u6b65\u3010\u533b\u751f\u72b6\u6001\u3011\u4fe1\u606f\u961f\u5217-------------");
        this.rabbitTemplate.convertAndSend("byh-online-outpatient-delay-exchange", "doctor.information.state.key", (Object)doctorMessageEventsVo, message -> {
            message.getMessageProperties().setHeader("x-delay", (Object)0);
            log.info("\u6dfb\u52a0\u5b8c\u6210\uff1a" + JSONObject.toJSONString((Object)doctorMessageEventsVo));
            return message;
        });
        log.info("--------------\u652f\u4ed8\u5b9d\u540c\u6b65\u3010\u533b\u751f\u72b6\u6001\u3011\u961f\u5217\u6dfb\u52a0\u5b8c\u6210--------------");
    }

    public void sendOrderInformationData(DoctorMessageEventsVo doctorMessageEventsVo) {
        log.info("-------------\u652f\u4ed8\u5b9d\u540c\u6b65\u3010\u8ba2\u5355\u3011\u4fe1\u606f\u961f\u5217-------------");
        this.rabbitTemplate.convertAndSend("byh-online-outpatient-delay-exchange", "order.information.data.key", (Object)doctorMessageEventsVo, message -> {
            message.getMessageProperties().setHeader("x-delay", (Object)0);
            log.info("\u6dfb\u52a0\u5b8c\u6210\uff1a" + JSONObject.toJSONString((Object)doctorMessageEventsVo));
            return message;
        });
        log.info("--------------\u652f\u4ed8\u5b9d\u540c\u6b65\u3010\u8ba2\u5355\u3011\u961f\u5217\u6dfb\u52a0\u5b8c\u6210--------------");
    }
}

