/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.core.dao.TeamDoctorInfoMapper;
import com.ebaiyihui.onlineoutpatient.core.exception.BusinessException;
import com.ebaiyihui.onlineoutpatient.core.model.TeamDoctorInfoEntity;
import com.ebaiyihui.onlineoutpatient.core.service.DoctorTemInfomService;
import com.ebaiyihui.onlineoutpatient.core.service.client.DocNewTeamFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.DocTeamFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorInfofeignClient;
import com.ebaiyihui.onlineoutpatient.core.vo.GetPersonTeamDetialResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.GetPersonTeamResVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DoctorTemInfomServiceImpl
implements DoctorTemInfomService {
    private static final Logger log = LoggerFactory.getLogger(DoctorTemInfomServiceImpl.class);
    @Autowired
    private DoctorInfofeignClient doctorClient;
    @Autowired
    private DocTeamFeignClient docTeamFeignClient;
    @Autowired
    private DocNewTeamFeignClient docNewTeamFeignClient;
    @Autowired
    private TeamDoctorInfoMapper teamDoctorInfoMapper;

    public BaseResponse<Boolean> getDocIsLearder(String doctorId, String orgId) {
        if (StringUtils.isBlank((String)doctorId)) {
            return BaseResponse.error((String)"\u533b\u751fid\u4e0d\u53ef\u4e3a\u7a7a");
        }
        BaseResponse doctorInfo = this.doctorClient.getDoctorInfo(Long.valueOf(Long.parseLong(doctorId)), orgId);
        log.info("\u533b\u751f\u4fe1\u606fdoctorInfo:" + doctorInfo);
        if (doctorInfo.isSuccess() && doctorInfo.getData() == null) {
            return BaseResponse.error((String)"\u57fa\u7840\u670d\u52a1\u6ca1\u6709\u8be5\u533b\u751f\u4fe1\u606f");
        }
        BaseResponse teamLeader = this.docTeamFeignClient.isTeamLeader(Long.valueOf(Long.parseLong(doctorId)), null);
        log.info("\u8fd4\u56de\u4fe1\u606fteamLeader:" + teamLeader);
        if (!Objects.isNull(teamLeader) && teamLeader.isSuccess() && !Objects.isNull(teamLeader.getData())) {
            String leaderFlag = teamLeader.getData().toString();
            if ("teamLeader".equals(leaderFlag)) {
                return BaseResponse.success((Object)true);
            }
            return BaseResponse.success((Object)false);
        }
        return BaseResponse.error((String)"\u533b\u751f\u57fa\u7840\u670d\u52a1\u8fd4\u56de\u5931\u8d25");
    }

    public List<GetPersonTeamDetialResVo> getPersonTeamNew(String doctorId) {
        if (StringUtils.isBlank((String)doctorId)) {
            throw new BusinessException("\u533b\u751fid\u4e0d\u53ef\u4e3a\u7a7a");
        }
        BaseResponse personTeamNew = this.docNewTeamFeignClient.getPersonTeamNew(Long.valueOf(Long.parseLong(doctorId)));
        log.info("\u56e2\u961f\u6210\u5458\u4fe1\u606fpersonTeamNew:" + JSONObject.toJSONString((Object)personTeamNew));
        if (!Objects.isNull(personTeamNew) && personTeamNew.isSuccess() && !Objects.isNull(personTeamNew.getData())) {
            JSONArray objects = JSONArray.parseArray((String)JSONObject.toJSONString((Object)personTeamNew.getData()));
            if (objects.isEmpty()) {
                return null;
            }
            String teamList = objects.getJSONObject(0).get((Object)"teamList").toString();
            if (StringUtils.isEmpty((String)teamList)) {
                return null;
            }
            log.info("\u56e2\u961f\u533b\u751fteamlis\uff1a" + JSONObject.toJSONString((Object)teamList));
            List getPersonTeamDetialResVos = JSONArray.parseArray((String)teamList, GetPersonTeamDetialResVo.class);
            if (CollectionUtils.isEmpty((Collection)getPersonTeamDetialResVos) || !"1".equals(((GetPersonTeamDetialResVo)getPersonTeamDetialResVos.get(0)).getUsable())) {
                return null;
            }
            return getPersonTeamDetialResVos;
        }
        return null;
    }

    public List<GetPersonTeamDetialResVo> getPersonTeamNewAll(String doctorId) {
        if (StringUtils.isBlank((String)doctorId)) {
            throw new BusinessException("\u533b\u751fid\u4e0d\u53ef\u4e3a\u7a7a");
        }
        BaseResponse personTeamNew = this.docNewTeamFeignClient.getPersonTeamNew(Long.valueOf(Long.parseLong(doctorId)));
        log.info("\u56e2\u961f\u6210\u5458\u4fe1\u606fpersonTeamNew:" + JSONObject.toJSONString((Object)personTeamNew));
        if (!Objects.isNull(personTeamNew) && personTeamNew.isSuccess() && !Objects.isNull(personTeamNew.getData())) {
            JSONArray objects = JSONArray.parseArray((String)JSONObject.toJSONString((Object)personTeamNew.getData()));
            if (objects.isEmpty()) {
                return null;
            }
            String teamList = objects.getJSONObject(0).get((Object)"teamList").toString();
            if (StringUtils.isEmpty((String)teamList)) {
                return null;
            }
            log.info("\u56e2\u961f\u533b\u751fteamlis\uff1a" + JSONObject.toJSONString((Object)teamList));
            List getPersonTeamDetialResVos = JSONArray.parseArray((String)teamList, GetPersonTeamDetialResVo.class);
            if (CollectionUtils.isEmpty((Collection)getPersonTeamDetialResVos)) {
                return null;
            }
            return getPersonTeamDetialResVos;
        }
        return null;
    }

    public List<String> getTeamInfo(String doctorId) {
        if (StringUtils.isBlank((String)doctorId)) {
            throw new BusinessException("\u533b\u751fid\u4e0d\u53ef\u4e3a\u7a7a");
        }
        BaseResponse personTeam = this.docTeamFeignClient.getPersonTeam(Long.valueOf(Long.parseLong(doctorId)));
        log.info("\u6839\u636e\u961f\u5458\u67e5\u8be2\u56e2\u961f\u4fe1\u606fpersonTeam:" + JSONObject.toJSONString((Object)personTeam));
        if (!Objects.isNull(personTeam) && personTeam.isSuccess() && personTeam.getData() != null) {
            ArrayList<String> doctorids = new ArrayList<String>();
            List data = JSONArray.parseArray((String)JSONObject.toJSONString((Object)personTeam.getData()), GetPersonTeamResVo.class);
            log.info("data:" + data);
            if (!CollectionUtils.isEmpty((Collection)data)) {
                data.stream().forEach(i -> {
                    List teamDoctorId = i.getTeamList().stream().filter(item -> 1 == item.getIsLeader() && "1".equals(item.getUsable().toString())).map(item -> String.valueOf(item.getDoctorId())).collect(Collectors.toList());
                    doctorids.addAll(teamDoctorId);
                });
            }
            log.info("\u961f\u957fid\u96c6\u5408doctorids:" + JSONObject.toJSONString(doctorids));
            return doctorids;
        }
        return null;
    }

    public List<TeamDoctorInfoEntity> selectTeamInfoByAdmId(String admId) {
        List teamDoctorInfoEntityList = this.teamDoctorInfoMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(TeamDoctorInfoEntity::getAdmId, (Object)admId));
        if (!CollectionUtils.isEmpty((Collection)teamDoctorInfoEntityList)) {
            return teamDoctorInfoEntityList;
        }
        return null;
    }
}

