/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctor.basedata.api.DepartmentInfoApi;
import com.doctor.basedata.api.dto.UcUserEvaluationDTO;
import com.doctoruser.api.common.enums.DoctorTypeEnum;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.doctoruser.api.pojo.vo.FindUserIdReqVO;
import com.doctoruser.api.pojo.vo.GetUserInfoByUserIdReqVO;
import com.doctoruser.api.pojo.vo.UserInfoByUserIdRespVO;
import com.ebaiyihui.common.pojo.vo.FindUserIdListReq;
import com.ebaiyihui.common.pojo.vo.FindUserIdRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.fz.DiagnosisInfoReqVo;
import com.ebaiyihui.his.pojo.vo.fz.body.DiagnosisData;
import com.ebaiyihui.imforward.client.vo.AccountVO;
import com.ebaiyihui.imforward.client.vo.PushGroupMsgDataVO;
import com.ebaiyihui.imforward.client.vo.PushGroupMsgReqVO;
import com.ebaiyihui.imforward.client.vo.PushSingleMsgDataVO;
import com.ebaiyihui.imforward.client.vo.PushSingleMsgReqVO;
import com.ebaiyihui.onlineoutpatient.common.bo.iminform.Message;
import com.ebaiyihui.onlineoutpatient.common.dto.iminform.AdmissionInfo;
import com.ebaiyihui.onlineoutpatient.common.dto.iminform.CaseHistory;
import com.ebaiyihui.onlineoutpatient.common.dto.iminform.CaseHistoryVo;
import com.ebaiyihui.onlineoutpatient.common.dto.iminform.MessageInfo;
import com.ebaiyihui.onlineoutpatient.common.dto.iminform.PersonImInformReq;
import com.ebaiyihui.onlineoutpatient.common.dto.iminform.TeamImInformReq;
import com.ebaiyihui.onlineoutpatient.common.dto.iminform.Text;
import com.ebaiyihui.onlineoutpatient.common.util.ResultData;
import com.ebaiyihui.onlineoutpatient.common.vo.DoctorReferralCard;
import com.ebaiyihui.onlineoutpatient.common.vo.PatientNoResponseReqVo;
import com.ebaiyihui.onlineoutpatient.common.vo.ReferralCard;
import com.ebaiyihui.onlineoutpatient.common.vo.ReferralCardNew;
import com.ebaiyihui.onlineoutpatient.common.vo.TreatmentCard;
import com.ebaiyihui.onlineoutpatient.core.common.constants.CommonConstants;
import com.ebaiyihui.onlineoutpatient.core.common.constants.IMInformConstants;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.DoctorTeamMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ICDMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.InquiryImVideoStatusMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.InquiryServiceConfigMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.MedicalAdmissionRefMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMedicalRecordMapper;
import com.ebaiyihui.onlineoutpatient.core.exception.AdmissionException;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.DoctorTeamEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ICDEntity;
import com.ebaiyihui.onlineoutpatient.core.model.InquiryImVideoStatus;
import com.ebaiyihui.onlineoutpatient.core.model.InquiryServiceConfigEntity;
import com.ebaiyihui.onlineoutpatient.core.model.MedicalAdmissionRefEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientMedicalRecordEntity;
import com.ebaiyihui.onlineoutpatient.core.model.TeamDoctorInfoEntity;
import com.ebaiyihui.onlineoutpatient.core.service.DoctorTemInfomService;
import com.ebaiyihui.onlineoutpatient.core.service.IMInformService;
import com.ebaiyihui.onlineoutpatient.core.service.RedisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorInfofeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.IMPushMsgFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.IMSyncMsgClient;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryServiceConfigServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.remotecall.InternetHospitalDetailInfoService;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.IDCardUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.JsonUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.UserRestTemplateUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.gateway.GateWayCommonUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.id.UUIDUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.DrugReqDto;
import com.ebaiyihui.onlineoutpatient.core.vo.InformMedicalOptionVo;
import com.ebaiyihui.onlineoutpatient.core.vo.InitiateVideoReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.InternetHospitalEntity;
import com.ebaiyihui.onlineoutpatient.core.vo.UpdateImVideoStatusReq;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.dto.FastCreateOrderDto;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.vo.ZkCaseHistory;
import com.ebaiyihui.onlineoutpatient.core.vo.recommService.RecommArticleReqVO;
import com.ebaiyihui.onlineoutpatient.core.vo.recommService.RecommDoctorReqVO;
import com.ebaiyihui.onlineoutpatient.core.vo.recommService.RecommServiceReqVO;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.MedicalSortVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalEntityVo;
import com.ebaiyihui.usercenter.client.UserClient;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class IMInformServiceImpl
implements IMInformService {
    private static final Logger log = LoggerFactory.getLogger(IMInformServiceImpl.class);
    @Autowired
    private BaseInquiryServiceConfigServiceImpl baseService;
    public static final String FORMAT_PATTERN = "yyyy\u5e74MM\u6708dd\u65e5";
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private IMPushMsgFeignClient imPushMsgFeignClient;
    @Autowired
    private UserClient userCenterClient;
    @Autowired
    private DoctorInfofeignClient doctorInfofeignClient;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    private DoctorTeamMapper doctorTeamMapper;
    @Autowired
    private DoctorInfofeignClient doctorClient;
    @Autowired
    private DepartmentInfoApi departmentInfoApi;
    @Autowired
    private InternetHospitalDetailInfoService internetHospitalDetailInfoService;
    @Autowired
    private InquiryServiceConfigMapper inquiryServiceConfigMapper;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private IMSyncMsgClient imSyncMsgClient;
    @Autowired
    private DoctorTemInfomService doctorTemInfomService;
    @Autowired
    private InquiryImVideoStatusMapper inquiryImVideoStatusMapper;
    @Autowired
    private RedisTemplateService redisTemplateService;
    @Autowired
    private PatientMedicalRecordMapper patientMedicalRecordMapper;
    @Autowired
    private MedicalAdmissionRefMapper medicalAdmissionRefMapper;
    @Autowired
    private ICDMapper icdMapper;
    private ExecutorService executor = Executors.newCachedThreadPool();

    public void paySuccess(String admissionId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admissionId);
        Integer doctorType = admissionInfo.getDoctorType();
        if (doctorType == null) {
            return;
        }
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        log.info("\u4f20\u5165\u7684servType\u4e3a\uff1a{}" + JSON.toJSONString((Object)orderEntity.getServType()));
        InternetHospitalEntity internetHospitalEntity = this.internetHospitalDetailInfoService.getInternetHospitalInfo(orderEntity.getHospitalId(), this.projProperties.getInternetHospitalUrl());
        String serveTelephone = internetHospitalEntity.getTelphone();
        if (orderEntity.getServType().equals(ServiceTypeEnum.HOS.getValue())) {
            if (null != orderEntity.getScheduleDate()) {
                messageInfos.add(this.getInformCustomPerPatientParam(admissionInfo, (Object)this.getCaseHistory(admissionId), "order"));
                Date scheduleDate = orderEntity.getScheduleDate();
                Integer scheduleRange = orderEntity.getScheduleRange();
                SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_PATTERN);
                String scheduleDateStr = formatter.format(scheduleDate);
                String scheduleTime = "";
                if (null == orderEntity.getScheduleStartTime() && null == orderEntity.getScheduleEndTime()) {
                    log.info("======\u5728\u7ebf\u54a8\u8be2\u6392\u73ed\u7684\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a====");
                    scheduleTime = "";
                } else {
                    scheduleTime = orderEntity.getScheduleStartTime() + "-" + orderEntity.getScheduleEndTime();
                }
                messageInfos.add(this.getInformPerPatientParam(admissionInfo, (Object)new Text("\u5c31\u8bca\u65f6\u95f4" + scheduleDateStr + "" + scheduleTime + "\uff0c\u8bf7\u60a8\u5b89\u6392\u597d\u65f6\u95f4\u5728\u4e92\u8054\u7f51\u533b\u9662\u5927\u4f17\u7aef\u51c6\u65f6\u5c31\u8bca\uff0c\u5c31\u8bca\u524d\u8bf7\u8fdb\u884c\"\u5019\u8bca\u62a5\u5230\"\u64cd\u4f5c\uff0c\u4fbf\u4e8e\u533b\u751f\u53ca\u65f6\u63a5\u5165\u4e3a\u60a8\u8bca\u7597")));
            } else {
                log.info("\u5728\u7ebf\u54a8\u8be2\u652f\u4ed8\u6210\u529f\u53d1\u9001IM\u6d88\u606f");
                messageInfos.add(this.getInformCustomPersonDocParam(admissionInfo, (Object)this.getCaseHistory(admissionId), "order"));
                messageInfos.add(this.getInformCustomPerPatientParam(admissionInfo, (Object)this.getCaseHistory(admissionId), "order"));
                if (orderEntity.getAppCode().equals("HYT")) {
                    messageInfos.add(this.getInformPerPatientParam(admissionInfo, (Object)new Text("\u6b22\u8fce\u60a8\u4f7f\u7528\u5728\u7ebf\u54a8\u8be2\u670d\u52a1\uff0c\u5df2\u901a\u77e5" + admissionInfo.getAimName() + "\u533b\u751f\u67e5\u770b\u60a8\u7684\u75c5\u60c5\u8d44\u6599\uff0c\u56e0\u533b\u751f\u627f\u62c5\u7e41\u91cd\u7684\u65e5\u5e38\u5de5\u4f5c\uff0c\u82e5\u56de\u590d\u8f83\u6162\u671b\u60a8\u8c05\u89e3\uff0c\u533b\u751f\u53ef\u80fd\u4f1a\u5411\u60a8\u53d1\u8d77\u89c6\u9891\uff0c\u8bf7\u60a8\u8863\u7740\u5927\u65b9\u5f97\u4f53\uff0c\u82e5\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\u5ba2\u670d:" + serveTelephone + "\uff0c\u6216\u8005\u81f3\u9996\u9875\u70b9\u51fb\u667a\u80fd\u5ba2\u670d\u54a8\u8be2\u3002")));
                } else {
                    messageInfos.add(this.getInformPerPatientParam(admissionInfo, (Object)new Text("\u6b22\u8fce\u60a8\u4f7f\u7528\u5728\u7ebf\u54a8\u8be2\u670d\u52a1\uff0c\u5df2\u901a\u77e5" + admissionInfo.getAimName() + "\u533b\u751f\u67e5\u770b\u60a8\u7684\u75c5\u60c5\u8d44\u6599\uff0c\u56e0\u533b\u751f\u627f\u62c5\u7e41\u91cd\u7684\u65e5\u5e38\u5de5\u4f5c\uff0c\u82e5\u56de\u590d\u8f83\u6162\u671b\u60a8\u8c05\u89e3\uff0c\u533b\u751f\u53ef\u80fd\u4f1a\u5411\u60a8\u53d1\u8d77\u89c6\u9891\uff0c\u8bf7\u60a8\u8863\u7740\u5927\u65b9\u5f97\u4f53\uff0c\u82e5\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\u5ba2\u670d:" + serveTelephone + "\u3002")));
                }
            }
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            log.info("=====messageInfos:{}=====" + JSON.toJSONString((Object)parameter.getMessageInfos()));
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u54a8\u8be2\u533b\u751f-\u652f\u4ed8\u6210\u529fIM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
            }
        } else if (orderEntity.getServType().equals(ServiceTypeEnum.NOS.getValue())) {
            if (null != orderEntity.getScheduleDate()) {
                if ("2291".equals(orderEntity.getOrganId())) {
                    return;
                }
                messageInfos.add(this.getInformCustomPerPatientParam(admissionInfo, (Object)this.getCaseHistory(admissionId), "order"));
                Date scheduleDate = orderEntity.getScheduleDate();
                Integer scheduleRange = orderEntity.getScheduleRange();
                SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_PATTERN);
                String scheduleDateStr = formatter.format(scheduleDate);
                String scheduleTime = "";
                if (null == orderEntity.getScheduleStartTime() && null == orderEntity.getScheduleEndTime()) {
                    log.info("======\u5728\u7ebf\u590d\u8bca\u6392\u73ed\u7684\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a====");
                    scheduleTime = "";
                } else {
                    scheduleTime = orderEntity.getScheduleStartTime() + "-" + orderEntity.getScheduleEndTime();
                }
                messageInfos.add(this.getInformPerPatientParam(admissionInfo, (Object)new Text("\u5c31\u8bca\u65f6\u95f4" + scheduleDateStr + "" + scheduleTime + "\uff0c\u8bf7\u60a8\u5b89\u6392\u597d\u65f6\u95f4\u5728\u4e92\u8054\u7f51\u533b\u9662\u5927\u4f17\u7aef\u51c6\u65f6\u5c31\u8bca\uff0c\u5c31\u8bca\u524d\u8bf7\u8fdb\u884c\"\u5019\u8bca\u62a5\u5230\"\u64cd\u4f5c\uff0c\u4fbf\u4e8e\u533b\u751f\u53ca\u65f6\u63a5\u5165\u4e3a\u60a8\u8bca\u7597")));
            } else {
                log.info("\u5728\u7ebf\u590d\u8bca\u652f\u4ed8\u6210\u529f\u53d1\u9001IM\u6d88\u606f");
                messageInfos.add(this.getInformCustomPersonDocParam(admissionInfo, (Object)this.getCaseHistory(admissionId), "order"));
                messageInfos.add(this.getInformCustomPerPatientParam(admissionInfo, (Object)this.getCaseHistory(admissionId), "order"));
                if (orderEntity.getAppCode().equals("HYT")) {
                    messageInfos.add(this.getInformPerPatientParam(admissionInfo, (Object)new Text("\u6b22\u8fce\u60a8\u4f7f\u7528\u5728\u7ebf\u590d\u8bca\u670d\u52a1\uff0c\u5df2\u901a\u77e5" + admissionInfo.getAimName() + "\u533b\u751f\u67e5\u770b\u60a8\u7684\u75c5\u60c5\u8d44\u6599\uff0c\u56e0\u533b\u751f\u627f\u62c5\u7e41\u91cd\u7684\u65e5\u5e38\u5de5\u4f5c\uff0c\u82e5\u56de\u590d\u8f83\u6162\u671b\u60a8\u8c05\u89e3\uff0c\u533b\u751f\u53ef\u80fd\u4f1a\u5411\u60a8\u53d1\u8d77\u89c6\u9891\uff0c\u8bf7\u60a8\u8863\u7740\u5927\u65b9\u5f97\u4f53\uff0c\u82e5\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\u5ba2\u670d:" + serveTelephone + "\uff0c\u6216\u8005\u81f3\u9996\u9875\u70b9\u51fb\u667a\u80fd\u5ba2\u670d\u54a8\u8be2\u3002")));
                } else {
                    messageInfos.add(this.getInformPerPatientParam(admissionInfo, (Object)new Text("\u6b22\u8fce\u60a8\u4f7f\u7528\u5728\u7ebf\u590d\u8bca\u670d\u52a1\uff0c\u5df2\u901a\u77e5" + admissionInfo.getAimName() + "\u533b\u751f\u67e5\u770b\u60a8\u7684\u75c5\u60c5\u8d44\u6599\uff0c\u56e0\u533b\u751f\u627f\u62c5\u7e41\u91cd\u7684\u65e5\u5e38\u5de5\u4f5c\uff0c\u82e5\u56de\u590d\u8f83\u6162\u671b\u60a8\u8c05\u89e3\uff0c\u533b\u751f\u53ef\u80fd\u4f1a\u5411\u60a8\u53d1\u8d77\u89c6\u9891\uff0c\u8bf7\u60a8\u8863\u7740\u5927\u65b9\u5f97\u4f53\uff0c\u82e5\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\u5ba2\u670d:" + serveTelephone + "\u3002")));
                }
            }
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            log.info("=====messageInfos:{}=====" + JSON.toJSONString((Object)parameter.getMessageInfos()));
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u590d\u8bca\u533b\u751f-\u652f\u4ed8\u6210\u529fIM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
            }
        } else if (orderEntity.getServType().equals(ServiceTypeEnum.BMMZ.getValue())) {
            if (null != orderEntity.getScheduleDate()) {
                messageInfos.add(this.getInformCustomPerPatientParam(admissionInfo, (Object)this.getCaseHistory(admissionId), "order"));
                Date scheduleDate = orderEntity.getScheduleDate();
                SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_PATTERN);
                String scheduleDateStr = formatter.format(scheduleDate);
                String scheduleTime = "";
                if (null == orderEntity.getScheduleStartTime() && null == orderEntity.getScheduleEndTime()) {
                    log.info("======\u4fbf\u6c11\u95e8\u8bca\u6392\u73ed\u7684\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a====");
                    scheduleTime = "";
                } else {
                    scheduleTime = orderEntity.getScheduleStartTime() + "-" + orderEntity.getScheduleEndTime();
                }
                messageInfos.add(this.getInformPerPatientParam(admissionInfo, (Object)new Text("\u5c31\u8bca\u65f6\u95f4" + scheduleDateStr + "" + scheduleTime + "\uff0c\u8bf7\u60a8\u5b89\u6392\u597d\u65f6\u95f4\u5728\u4e92\u8054\u7f51\u533b\u9662\u5927\u4f17\u7aef\u51c6\u65f6\u5c31\u8bca\uff0c\u5c31\u8bca\u524d\u8bf7\u8fdb\u884c\"\u5019\u8bca\u62a5\u5230\"\u64cd\u4f5c\uff0c\u4fbf\u4e8e\u533b\u751f\u53ca\u65f6\u63a5\u5165\u4e3a\u60a8\u8bca\u7597")));
            } else {
                log.info("\u4fbf\u6c11\u95e8\u8bca\u652f\u4ed8\u6210\u529f\u53d1\u9001IM\u6d88\u606f");
                messageInfos.add(this.getInformCustomPersonDocParam(admissionInfo, (Object)this.getCaseHistory(admissionId), "order"));
                messageInfos.add(this.getInformCustomPerPatientParam(admissionInfo, (Object)this.getCaseHistory(admissionId), "order"));
                messageInfos.add(this.getInformPerPatientParam(admissionInfo, (Object)new Text("\u6b22\u8fce\u60a8\u4f7f\u7528\u4fbf\u6c11\u95e8\u8bca\u670d\u52a1\uff0c\u5df2\u901a\u77e5" + admissionInfo.getAimName() + "\u533b\u751f\u67e5\u770b\u60a8\u7684\u75c5\u60c5\u8d44\u6599\uff0c\u56e0\u533b\u751f\u627f\u62c5\u7e41\u91cd\u7684\u65e5\u5e38\u5de5\u4f5c\uff0c\u82e5\u56de\u590d\u8f83\u6162\u671b\u60a8\u8c05\u89e3\uff0c\u533b\u751f\u53ef\u80fd\u4f1a\u5411\u60a8\u53d1\u8d77\u89c6\u9891\uff0c\u8bf7\u60a8\u8863\u7740\u5927\u65b9\u5f97\u4f53\uff0c\u82e5\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\u5ba2\u670d:" + serveTelephone + "\u3002")));
            }
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            log.info("getMessageInfos:{}", (Object)JSON.toJSONString((Object)parameter.getMessageInfos()));
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u4fbf\u6c11\u95e8\u8bca\u533b\u751f-\u652f\u4ed8\u6210\u529fIM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
            }
        }
    }

    private CaseHistory getCaseHistory(String admissionId) {
        CaseHistoryVo caseHistoryVo = this.admissionMapper.queryCaseHistory(admissionId);
        log.info("\u5c31\u8bca\u8bb0\u5f55:" + JSON.toJSONString((Object)caseHistoryVo));
        CaseHistory caseHistory = new CaseHistory();
        caseHistory.setAdmissionId(caseHistoryVo.getAdmissionId());
        caseHistory.setDeptName(caseHistoryVo.getDeptName());
        caseHistory.setServType(caseHistoryVo.getServType());
        caseHistory.setTelphone(caseHistoryVo.getTelphone());
        caseHistory.setDescription(caseHistoryVo.getDescription());
        caseHistory.setLastDeptName(caseHistoryVo.getLastDeptName());
        caseHistory.setLastDoctorName(caseHistoryVo.getLastDoctorName());
        caseHistory.setQuestion(caseHistoryVo.getQuestion());
        caseHistory.setTagName(caseHistoryVo.getTagName());
        caseHistory.setVisiteMsg(caseHistoryVo.getVisiteMsg());
        log.info("\u75c5\u4f8bID:" + caseHistoryVo.getMedicalRecordId());
        PatientDynamicMedicalEntityVo entityVo = this.internetHospitalDetailInfoService.getMedicalInfoById(caseHistoryVo.getMedicalRecordId());
        if (null == entityVo) {
            log.info("\u75c5\u4f8b\u8be6\u60c5\u67e5\u8be2\u9519\u8bef");
            return null;
        }
        List<MedicalSortVo> list = this.internetHospitalDetailInfoService.getCardMedicalUserFills(caseHistoryVo.getServType(), entityVo.getMedicalDetail(), caseHistoryVo.getHospitalId(), caseHistoryVo.getDeptId());
        log.info("list:{}", (Object)JSON.toJSONString((Object)list));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        list = list.stream().filter(medicalSortVo -> medicalSortVo.getIsCard().equals(1)).collect(Collectors.toList());
        list.forEach(item -> {
            if ("historyMedication".equals(item.getKeywords())) {
                String value = item.getValue().toString();
                log.info("========\u5386\u53f2\u7528\u836f\u7684value:{}", (Object)value);
                JSONArray jsonArray = JSONObject.parseArray((String)value);
                log.info("========\u5386\u53f2\u7528\u836f\u7684jsonArray:{}", (Object)jsonArray);
                StringBuilder medications = new StringBuilder();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject medication = jsonArray.getJSONObject(i);
                    String commonName = medication.getString("commonName");
                    medications.append(commonName);
                    if (i >= jsonArray.size() - 1) continue;
                    medications.append(", ");
                }
                item.setValue((Object)medications);
                item.setTitleType(Integer.valueOf(40));
            }
        });
        caseHistory.setMedicalUserFills(list);
        log.info("caseHistory:{}", (Object)caseHistory.toString());
        return caseHistory;
    }

    private TreatmentCard getTreatmentCard(String admissionId) {
        TreatmentCard treatmentCard = new TreatmentCard();
        PatientDynamicMedicalEntityVo entityVo = this.internetHospitalDetailInfoService.getMedicalInfoByAdmId(admissionId);
        AdmissionEntity admissionEntity = this.admissionMapper.findById(admissionId);
        if (null == entityVo) {
            log.info("\u75c5\u4f8b\u8be6\u60c5\u67e5\u8be2\u9519\u8bef,\u67e5\u8be2\u4e3a\u7a7a");
            return null;
        }
        List list = new ArrayList();
        list = this.internetHospitalDetailInfoService.getMedicalUserFills(entityVo.getServType(), entityVo.getMedicalDetail(), entityVo.getHospitalId(), entityVo.getDeptId());
        log.info("list:{}" + JSON.toJSONString(list));
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        treatmentCard.setMedicalRecordId(entityVo.getXId());
        treatmentCard.setMedicalUserFills(list);
        log.info("caseHistory:{}" + treatmentCard.toString());
        return treatmentCard;
    }

    private ReferralCard getReferralCard(String referralId) {
        log.info("referralId:{}" + referralId);
        QueryWrapper queryWrapper = new QueryWrapper();
        DoctorTeamEntity entity = new DoctorTeamEntity();
        entity.setXId(referralId);
        queryWrapper.setEntity((Object)entity);
        DoctorTeamEntity doctorTeamEntity = (DoctorTeamEntity)this.doctorTeamMapper.selectOne((Wrapper)queryWrapper);
        log.info("doctorTeamEntity:{}" + doctorTeamEntity.toString());
        ReferralCard referralCard = new ReferralCard();
        referralCard.setTitle("\u8f6c\u8bca\u63d0\u9192");
        ArrayList<String> list = new ArrayList<String>();
        list.add(doctorTeamEntity.getReferralReason());
        referralCard.setReferralReason(list);
        referralCard.setReferralDoctorId(doctorTeamEntity.getReferralDoctorId());
        referralCard.setReferralDoctorName(doctorTeamEntity.getReferralDoctorName());
        referralCard.setReferralId(referralId);
        referralCard.setReferralPeople("2");
        log.info("referralCard:{}" + referralCard.toString());
        return referralCard;
    }

    private ReferralCardNew getReferralCardNew(String referralId) {
        log.info("referralId:{}" + referralId);
        QueryWrapper queryWrapper = new QueryWrapper();
        DoctorTeamEntity entity = new DoctorTeamEntity();
        entity.setXId(referralId);
        queryWrapper.setEntity((Object)entity);
        DoctorTeamEntity doctorTeamEntity = (DoctorTeamEntity)this.doctorTeamMapper.selectOne((Wrapper)queryWrapper);
        log.info("doctorTeamEntity:{}" + doctorTeamEntity.toString());
        ReferralCardNew referralCardNew = new ReferralCardNew();
        referralCardNew.setTitle("\u8f6c\u8bca\u63d0\u9192");
        ArrayList<String> list = new ArrayList<String>();
        list.add(doctorTeamEntity.getReferralReason());
        referralCardNew.setReferralReason(list);
        referralCardNew.setAdmissionDoctorId(doctorTeamEntity.getAdmissionDoctorId());
        referralCardNew.setAdmissionDoctorName(doctorTeamEntity.getAdmissionDoctorName());
        referralCardNew.setReferralId(referralId);
        referralCardNew.setReferralPeople("1");
        log.info("referralCard:{}" + referralCardNew.toString());
        return referralCardNew;
    }

    private DoctorReferralCard getDoctorReferralCard(String referralId) {
        log.info("referralId:{}" + referralId);
        QueryWrapper queryWrapper = new QueryWrapper();
        DoctorTeamEntity entity = new DoctorTeamEntity();
        entity.setXId(referralId);
        queryWrapper.setEntity((Object)entity);
        DoctorTeamEntity doctorTeamEntity = (DoctorTeamEntity)this.doctorTeamMapper.selectOne((Wrapper)queryWrapper);
        log.info("doctorTeamEntity:{}" + doctorTeamEntity.toString());
        DoctorReferralCard doctorReferralCard = new DoctorReferralCard();
        doctorReferralCard.setAdmissonDoctorId(doctorTeamEntity.getAdmissionDoctorId());
        doctorReferralCard.setAdmissonDoctorName(doctorTeamEntity.getAdmissionDoctorName());
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(doctorTeamEntity.getAdmissionDoctorId());
        BaseResponse doctorDetailsVOBaseResponse = this.doctorClient.queryPersonnelInfo(queryPersonnelInfoReq);
        if (null == doctorDetailsVOBaseResponse || null == doctorDetailsVOBaseResponse.getData()) {
            log.info("\u67e5\u8be2\u533b\u751f\u670d\u52a1\u5931\u8d25,\u8fd4\u56de\u7684\u6570\u636e\u4e3a\u7a7a");
            return doctorReferralCard;
        }
        log.info("doctorDetailsVOBaseResponse:{}" + JSON.toJSONString((Object)doctorDetailsVOBaseResponse.getData()));
        PersonnelInfo personnelInfo = (PersonnelInfo)doctorDetailsVOBaseResponse.getData();
        log.info("personnelInfo:{}" + JSON.toJSONString((Object)personnelInfo));
        doctorReferralCard.setDeptId(personnelInfo.getDeptId());
        doctorReferralCard.setDeptName(personnelInfo.getDeptName());
        doctorReferralCard.setOrganId(personnelInfo.getOrganId());
        doctorReferralCard.setOrganName(personnelInfo.getOrganName());
        doctorReferralCard.setPortrait(personnelInfo.getPortrait());
        doctorReferralCard.setTitle(personnelInfo.getTitle());
        QueryPersonnelInfoReq queryPersonnelInfo = new QueryPersonnelInfoReq();
        queryPersonnelInfo.setDoctorId(doctorTeamEntity.getReferralDoctorId());
        BaseResponse doctorDetailsVO = this.doctorClient.queryPersonnelInfo(queryPersonnelInfo);
        if (null == doctorDetailsVO || null == doctorDetailsVO.getData()) {
            log.info("\u67e5\u8be2\u533b\u751f\u670d\u52a1\u5931\u8d25,\u8fd4\u56de\u7684\u6570\u636e\u4e3a\u7a7a");
            return doctorReferralCard;
        }
        log.info("doctorDetailsVO:{}" + JSON.toJSONString((Object)doctorDetailsVO.getData()));
        PersonnelInfo personnelInfo1 = (PersonnelInfo)doctorDetailsVO.getData();
        log.info("personnelInfo1:{}" + JSON.toJSONString((Object)personnelInfo1));
        doctorReferralCard.setReferralDoctorId(personnelInfo1.getDoctorId());
        doctorReferralCard.setReferralDoctorName(personnelInfo1.getDoctorName());
        doctorReferralCard.setReferralDeptId(personnelInfo1.getDeptId());
        doctorReferralCard.setReferralDeptName(personnelInfo1.getDeptName());
        doctorReferralCard.setReferralDoctorPortrait(personnelInfo1.getPortrait());
        doctorReferralCard.setReferralDoctorTitle(personnelInfo1.getTitle());
        doctorReferralCard.setDoctorCardName("\u533b\u751f\u540d\u7247");
        log.info("doctorReferralCard:{}" + doctorReferralCard.toString());
        return doctorReferralCard;
    }

    @Async
    public void receive(String admissionId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admissionId);
        Integer doctorType = admissionInfo.getDoctorType();
        if (doctorType == null) {
            return;
        }
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        log.info("\u4f20\u5165\u7684servType\u4e3a\uff1a{}" + JSON.toJSONString((Object)orderEntity.getServType()));
        if (orderEntity.getServType().equals(ServiceTypeEnum.HOS.getValue())) {
            messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text(" \u54a8\u8be2\u8fc7\u7a0b\u4e2d\u82e5\u9700\u9000\u6b3e\u6216\u6709\u7591\u95ee\uff0c\u53ef\u70b9\u51fb\"\u9000\u6b3e\"\u6309\u94ae\u8fdb\u2f8f\u9000\u6b3e\u6216\u7533\u8bc9\u64cd\u4f5c\u3002"), IMInformConstants.REFRESH));
            messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text(" \u533b\u751f\u5df2\u63a5\u8bca\uff0c\u56e0\u7ebf\u4e0a\u54a8\u8be2\u65e0\u6cd5\u5ba2\u89c2\u5168\u9762\u4e86\u89e3\u60a8\u7684\u75c5\u60c5\uff0c\u533b\u751f\u7684\u5efa\u8bae\u4ec5\u4f9b\u53c2\u8003\u3002"), IMInformConstants.REFRESH));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u54a8\u8be2\u533b\u751f-\u63a5\u5355IM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
            }
        } else if (orderEntity.getServType().equals(ServiceTypeEnum.NOS.getValue())) {
            messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text(" \u590d\u8bca\u8fc7\u7a0b\u4e2d\u82e5\u9700\u9000\u6b3e\u6216\u6709\u7591\u95ee\uff0c\u53ef\u70b9\u51fb\"\u9000\u6b3e\"\u6309\u94ae\u8fdb\u2f8f\u9000\u6b3e\u6216\u7533\u8bc9\u64cd\u4f5c\uff0c\u4e3a\u4e86\u9a8c\u8bc1\u8be5\u533b\u4fdd\u60a3\u8005\u771f\u5b9e\u4fe1\u606f\uff0c\u5efa\u8bae\u60a8\u91c7\u7528\u89c6\u9891\u65b9\u5f0f\u4e0e\u60a3\u8005\u6c9f\u901a\u3002"), IMInformConstants.REFRESH));
            messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text(" \u533b\u751f\u5df2\u63a5\u8bca\uff0c\u56e0\u7ebf\u4e0a\u590d\u8bca\u65e0\u6cd5\u5ba2\u89c2\u5168\u9762\u4e86\u89e3\u60a8\u7684\u75c5\u60c5\uff0c\u533b\u751f\u7684\u5efa\u8bae\u4ec5\u4f9b\u53c2\u8003\u3002"), IMInformConstants.REFRESH));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u590d\u8bca\u533b\u751f-\u63a5\u5355IM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
            }
        } else if (orderEntity.getServType().equals(ServiceTypeEnum.BMMZ.getValue())) {
            messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text(" \u4fbf\u6c11\u95e8\u8bca\u8fc7\u7a0b\u4e2d\u82e5\u9700\u9000\u6b3e\u6216\u6709\u7591\u95ee\uff0c\u53ef\u70b9\u51fb\"\u9000\u6b3e\"\u6309\u94ae\u8fdb\u2f8f\u9000\u6b3e\u6216\u7533\u8bc9\u64cd\u4f5c\uff0c\u4e3a\u4e86\u9a8c\u8bc1\u8be5\u533b\u4fdd\u60a3\u8005\u771f\u5b9e\u4fe1\u606f\uff0c\u5efa\u8bae\u60a8\u91c7\u7528\u89c6\u9891\u65b9\u5f0f\u4e0e\u60a3\u8005\u6c9f\u901a\u3002"), IMInformConstants.REFRESH));
            messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text(" \u533b\u751f\u5df2\u63a5\u8bca\uff0c\u56e0\u7ebf\u4e0a\u4fbf\u6c11\u95e8\u8bca\u65e0\u6cd5\u5ba2\u89c2\u5168\u9762\u4e86\u89e3\u60a8\u7684\u75c5\u60c5\uff0c\u533b\u751f\u7684\u5efa\u8bae\u4ec5\u4f9b\u53c2\u8003\u3002"), IMInformConstants.REFRESH));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u590d\u8bca\u533b\u751f-\u63a5\u5355IM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
            }
        }
    }

    @Async
    public void initiativeFinish(String admissionId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        Integer doctorType = admissionInfo.getDoctorType();
        if (doctorType == null) {
            return;
        }
        log.info("\u4f20\u5165\u7684servType\u4e3a\uff1a{}" + JSON.toJSONString((Object)admissionInfo.getServiceType()));
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        if (admissionInfo.getServiceType().equals(ServiceTypeEnum.HOS.getValue())) {
            messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text("\u672c\u6b21\u54a8\u8be2\u5df2\u7ed3\u675f"), IMInformConstants.REFRESH));
            if (admissionInfo.getAdmissionId().startsWith("KFZX")) {
                messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u672c\u6b21\u54a8\u8be2\u5df2\u7ed3\u675f"), IMInformConstants.REFRESH));
            } else {
                messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u60a8\u7684\u5728\u7ebf\u54a8\u8be2\u5df2\u7ed3\u675f\uff0c\u60a8\u53ef\u5bf9" + admissionInfo.getAimName() + "\u533b\u751f\u8fdb\u884c\u8bc4\u4ef7"), IMInformConstants.REFRESH));
            }
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u54a8\u8be2\u533b\u751f-\u4e3b\u52a8\u7ed3\u675fIM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
            }
        } else if (admissionInfo.getServiceType().equals(ServiceTypeEnum.NOS.getValue())) {
            messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text("\u672c\u6b21\u590d\u8bca\u5df2\u7ed3\u675f"), IMInformConstants.REFRESH));
            messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u60a8\u7684\u5728\u7ebf\u590d\u8bca\u5df2\u7ed3\u675f\uff0c\u60a8\u53ef\u5bf9" + admissionInfo.getAimName() + "\u533b\u751f\u8fdb\u884c\u8bc4\u4ef7"), IMInformConstants.REFRESH));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u590d\u8bca\u533b\u751f-\u4e3b\u52a8\u7ed3\u675fIM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
            }
        }
    }

    @Async
    public void referralFinish(String admissionId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        Integer doctorType = admissionInfo.getDoctorType();
        if (doctorType == null) {
            return;
        }
        log.info("\u4f20\u5165\u7684servType\u4e3a\uff1a{}" + JSON.toJSONString((Object)admissionInfo.getServiceType()));
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        if (admissionInfo.getServiceType().equals(ServiceTypeEnum.HOS.getValue())) {
            messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text("\u672c\u6b21\u54a8\u8be2\u5df2\u7ed3\u675f"), IMInformConstants.REFRESH));
            messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u60a8\u7684\u5728\u7ebf\u54a8\u8be2\u5df2\u7ed3\u675f\u3002"), IMInformConstants.REFRESH));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u54a8\u8be2\u533b\u751f-\u4e3b\u52a8\u7ed3\u675fIM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
            }
        } else if (admissionInfo.getServiceType().equals(ServiceTypeEnum.NOS.getValue())) {
            messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text("\u672c\u6b21\u590d\u8bca\u5df2\u7ed3\u675f"), IMInformConstants.REFRESH));
            messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u60a8\u7684\u5728\u7ebf\u590d\u8bca\u5df2\u7ed3\u675f\u3002"), IMInformConstants.REFRESH));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u590d\u8bca\u533b\u751f-\u4e3b\u52a8\u7ed3\u675fIM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
            }
        }
    }

    @Async
    public void expiredFinish(String admissionId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        Integer doctorType = admissionInfo.getDoctorType();
        if (doctorType == null) {
            return;
        }
        log.info("\u4f20\u5165\u7684servType\u4e3a\uff1a{}" + JSON.toJSONString((Object)admissionInfo.getServiceType()));
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        if (admissionInfo.getServiceType().equals(ServiceTypeEnum.HOS.getValue())) {
            messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text("\u672c\u6b21\u54a8\u8be2\u5df2\u7ed3\u675f"), IMInformConstants.REFRESH));
            messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u60a8\u7684\u54a8\u8be2\u65f6\u95f4\u5df2\u7ed3\u675f\uff0c\u60a8\u53ef\u5bf9" + admissionInfo.getAimName() + "\u533b\u751f\u505a\u51fa\u8bc4\u4ef7\uff0c\u82e5\u9700\u7ee7\u7eed\u95ee\u8bca\u8bf7\u91cd\u65b0\u7533\u8bf7"), IMInformConstants.REFRESH));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u54a8\u8be2\u533b\u751f-\u8d85\u65f6\u7ed3\u675fIM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
            }
        } else if (admissionInfo.getServiceType().equals(ServiceTypeEnum.NOS.getValue())) {
            messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text("\u672c\u6b21\u590d\u8bca\u5df2\u7ed3\u675f"), IMInformConstants.REFRESH));
            messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u60a8\u7684\u590d\u8bca\u65f6\u95f4\u5df2\u7ed3\u675f\uff0c\u60a8\u53ef\u5bf9" + admissionInfo.getAimName() + "\u533b\u751f\u505a\u51fa\u8bc4\u4ef7\uff0c\u82e5\u9700\u7ee7\u7eed\u95ee\u8bca\u8bf7\u91cd\u65b0\u7533\u8bf7"), IMInformConstants.REFRESH));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u590d\u8bca\u533b\u751f-\u8d85\u65f6\u7ed3\u675fIM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
            }
        }
    }

    @Async
    public void refuse(String admissionId, String message, String doctorId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admissionId);
        Integer doctorType = admissionInfo.getDoctorType();
        if (doctorType == null) {
            return;
        }
        if (DoctorTypeEnum.TEAM.getValue().equals(admissionInfo.getDoctorType())) {
            admissionInfo.setAimName(this.getDoctorName(doctorId));
        }
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        InternetHospitalEntity internetHospitalEntity = this.internetHospitalDetailInfoService.getInternetHospitalInfo(orderEntity.getHospitalId(), this.projProperties.getInternetHospitalUrl());
        String serveTelephone = internetHospitalEntity.getTelphone();
        if (admissionInfo.getServiceType().equals(ServiceTypeEnum.HOS.getValue())) {
            messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text(admissionInfo.getAimName() + "\u533b\u751f\u62d2\u7edd\u4e86\u60a3\u8005" + admissionInfo.getPatientName() + "\u7684\u54a8\u8be2\u7533\u8bf7"), IMInformConstants.REFRESH));
            if (admissionInfo.getPayAmount().compareTo(BigDecimal.ZERO) == 0) {
                messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text(admissionInfo.getAimName() + "\u533b\u751f\u56e0" + message + "\u62d2\u7edd\u4e86\u60a8\u7684\u54a8\u8be2"), IMInformConstants.REFRESH));
            } else {
                messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("1\u3001" + admissionInfo.getAimName() + "\u533b\u751f\u56e0" + message + "\u62d2\u7edd\u4e86\u60a8\u7684\u54a8\u8be2\uff1b\n2\u3001\u60a8\u7684\u54a8\u8be2\u8d39\u7528\u5c06\u4e3a\u60a8\u57281-3\u4e2a\u5de5\u4f5c\u65e5\u9000\u8fd8\u5230\u60a8\u539f\u6709\u8d26\u6237\uff0c\n\u82e5\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\u5ba2\u670d:" + serveTelephone), IMInformConstants.REFRESH));
            }
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u54a8\u8be2\u533b\u751f-\u62d2\u7eddIM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
            }
        } else if (admissionInfo.getServiceType().equals(ServiceTypeEnum.NOS.getValue())) {
            messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text(admissionInfo.getAimName() + "\u533b\u751f\u62d2\u7edd\u4e86\u60a3\u8005" + admissionInfo.getPatientName() + "\u7684\u590d\u8bca\u7533\u8bf7"), IMInformConstants.REFRESH));
            if (admissionInfo.getPayAmount().compareTo(BigDecimal.ZERO) == 0) {
                messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text(admissionInfo.getAimName() + "\u533b\u751f\u56e0" + message + "\u62d2\u7edd\u4e86\u60a8\u7684\u590d\u8bca"), IMInformConstants.REFRESH));
            } else {
                messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("1\u3001" + admissionInfo.getAimName() + "\u533b\u751f\u56e0" + message + "\u62d2\u7edd\u4e86\u60a8\u7684\u590d\u8bca\uff1b\n2\u3001\u60a8\u7684\u590d\u8bca\u8d39\u7528\u5c06\u4e3a\u60a8\u57281-3\u4e2a\u5de5\u4f5c\u65e5\u9000\u8fd8\u5230\u60a8\u539f\u6709\u8d26\u6237\uff0c\n\u82e5\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\u5ba2\u670d:" + serveTelephone), IMInformConstants.REFRESH));
            }
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u590d\u8bca\u533b\u751f-\u62d2\u7eddIM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
            }
        }
    }

    public void videoInterrogation(InitiateVideoReqVo param) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(param.getAdmId());
        Integer doctorType = admissionInfo.getDoctorType();
        if (doctorType == null) {
            return;
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)param.getDoctorId())) {
            param.setDoctorId(admissionInfo.getDoctorId());
        }
        if (DoctorTypeEnum.TEAM.getValue().equals(admissionInfo.getDoctorType())) {
            admissionInfo.setAimName(this.getDoctorName(param.getDoctorId()));
        }
        String text = "\u89c6\u9891";
        if (Objects.isNull(param.getType()) || Objects.equals("1", param.getType())) {
            text = "\u89c6\u9891";
        } else if (Objects.equals("2", param.getType())) {
            text = "\u8bed\u97f3";
        }
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        if (admissionInfo.getAdmissionId().startsWith("KFZX")) {
            messageInfos.add(this.getInformPerPatientParam(admissionInfo, (Object)new Text("\u5ba2\u670d\u5411\u60a8\u53d1\u8d77\u4e86" + text)));
        } else {
            messageInfos.add(this.getInformPerPatientParam(admissionInfo, (Object)new Text(admissionInfo.getAimName() + "\u533b\u751f\u5411\u60a8\u53d1\u8d77\u4e86" + text + "\u95ee\u8bca")));
        }
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(param.getAdmId());
        parameter.setBusiCode("zxzx");
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("IM INFORM COMPLETE \u533b\u751f-\u89c6\u9891\u95ee\u8bcaIM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)param.getAdmId());
        }
    }

    @Async
    public void applyRefundSuccess(String admissionId, String doctorId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        Integer doctorType = admissionInfo.getDoctorType();
        if (doctorType == null) {
            return;
        }
        if (DoctorTypeEnum.TEAM.getValue().equals(admissionInfo.getDoctorType())) {
            admissionInfo.setAimName(this.getDoctorName(doctorId));
        }
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text("\u9000\u6b3e\u7533\u8bf7\u5df2\u5904\u7406\u6210\u529f\uff0c\u6b3e\u9879\u5c06\u539f\u8def\u9000\u56de"), IMInformConstants.REFRESH));
        messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text(admissionInfo.getAimName() + "\u533b\u751f\u53d1\u8d77\u7684\u9000\u6b3e\u7533\u8bf7\u5df2\u5904\u7406\u6210\u529f\uff0c\u6b3e\u9879\u5c06\u539f\u8def\u9000\u56de\u3002"), IMInformConstants.REFRESH));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admissionId);
        parameter.setBusiCode("zxzx");
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("IM INFORM COMPLETE \u533b\u751f-\u7533\u8bf7\u9000\u6b3e\u6210\u529fIM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
        }
    }

    @Async
    public void expireRefund(String admissionId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        Integer doctorType = admissionInfo.getDoctorType();
        if (doctorType == null) {
            return;
        }
        log.info("\u4f20\u5165\u7684servType\u4e3a\uff1a{}" + JSON.toJSONString((Object)admissionInfo.getServiceType()));
        InquiryServiceConfigEntity inquiryServiceConfigEntity = this.buildInquiryServiceConfigEntity(admissionId);
        int minute = inquiryServiceConfigEntity.getOrderTime();
        String time = DateUtils.toDayHourMinuteString((int)minute);
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        if (admissionInfo.getServiceType().equals(ServiceTypeEnum.HOS.getValue())) {
            if (admissionInfo.getPayAmount().compareTo(BigDecimal.ZERO) == 0) {
                log.info("0\u5143\u8d85\u65f6\u54a8\u8be2\u8ba2\u5355\u672a\u63a5\u5f85");
                messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text(MessageFormat.format("\u5728{0}\u5185\u672a\u5904\u7406\u60a3\u8005\u7684\u7533\u8bf7\uff0c\u5df2\u53d6\u6d88\u672c\u6b21\u54a8\u8be2\u3002", time)), IMInformConstants.REFRESH));
                messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u7531\u4e8e" + admissionInfo.getAimName() + "\u533b\u751f\u65e5\u5e38\u5de5\u4f5c\u7e41\u5fd9\uff0c\u672a\u80fd\u53ca\u65f6\u5904\u7406\u60a8\u7684\u7533\u8bf7\uff0c\u672c\u6b21\u54a8\u8be2\u5df2\u53d6\u6d88\u3002"), IMInformConstants.REFRESH));
            } else {
                log.info("\u975e0\u5143\u8d85\u65f6\u54a8\u8be2\u8ba2\u5355\u672a\u63a5\u5f85");
                messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text(MessageFormat.format("\u5728{0}\u5185\u672a\u5904\u7406\u60a3\u8005\u7684\u7533\u8bf7\uff0c\u5df2\u5bf9\u54a8\u8be2\u505a\u9000\u6b3e\u5904\u7406\u3002", time)), IMInformConstants.REFRESH));
                messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u7531\u4e8e" + admissionInfo.getAimName() + "\u533b\u751f\u65e5\u5e38\u5de5\u4f5c\u7e41\u5fd9\uff0c\u672a\u80fd\u53ca\u65f6\u5904\u7406\u60a8\u7684\u7533\u8bf7\uff0c\u4e3a\u4fdd\u969c\u60a8\u7684\u6743\u76ca\u5df2\u4e3a\u60a8\u9000\u6b3e\uff0c\u6b3e\u9879\u5c06\u539f\u8def\u8fd4\u56de\u3002"), IMInformConstants.REFRESH));
            }
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u54a8\u8be2\u533b\u751f-\u8d85\u65f6\u9000\u6b3eIM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
            }
        } else if (admissionInfo.getServiceType().equals(ServiceTypeEnum.NOS.getValue())) {
            if (admissionInfo.getPayAmount().compareTo(BigDecimal.ZERO) == 0) {
                log.info("0\u5143\u8d85\u65f6\u590d\u8bca\u672a\u63a5\u5f85");
                messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text(MessageFormat.format("\u5728{0}\u5185\u672a\u5904\u7406\u60a3\u8005\u7684\u7533\u8bf7\uff0c\u5df2\u53d6\u6d88\u672c\u6b21\u590d\u8bca\u3002", time)), IMInformConstants.REFRESH));
                messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u7531\u4e8e" + admissionInfo.getAimName() + "\u533b\u751f\u65e5\u5e38\u5de5\u4f5c\u7e41\u5fd9\uff0c\u672a\u80fd\u53ca\u65f6\u5904\u7406\u60a8\u7684\u7533\u8bf7\uff0c\u672c\u6b21\u590d\u8bca\u5df2\u53d6\u6d88\u3002"), IMInformConstants.REFRESH));
            } else {
                log.info("\u975e0\u5143\u8d85\u65f6\u590d\u8bca\u672a\u63a5\u5f85");
                messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text(MessageFormat.format("\u5728{0}\u5185\u672a\u5904\u7406\u60a3\u8005\u7684\u7533\u8bf7\uff0c\u5df2\u5bf9\u590d\u8bca\u505a\u9000\u6b3e\u5904\u7406\u3002", time)), IMInformConstants.REFRESH));
                messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u7531\u4e8e" + admissionInfo.getAimName() + "\u533b\u751f\u65e5\u5e38\u5de5\u4f5c\u7e41\u5fd9\uff0c\u672a\u80fd\u53ca\u65f6\u5904\u7406\u60a8\u7684\u7533\u8bf7\uff0c\u4e3a\u4fdd\u969c\u60a8\u7684\u6743\u76ca\u5df2\u4e3a\u60a8\u9000\u6b3e\uff0c\u6b3e\u9879\u5c06\u539f\u8def\u8fd4\u56de\u3002"), IMInformConstants.REFRESH));
            }
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u590d\u8bca\u533b\u751f-\u8d85\u65f6\u9000\u6b3eIM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
            }
        }
    }

    public InquiryServiceConfigEntity buildInquiryServiceConfigEntity(String admissionId) {
        AdmissionEntity admissionEntity = this.admissionMapper.findById(admissionId);
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admissionId);
        QueryWrapper queryWrapper = new QueryWrapper();
        InquiryServiceConfigEntity wrapperEntity = new InquiryServiceConfigEntity();
        wrapperEntity.setDoctorId(admissionEntity.getDoctorId());
        wrapperEntity.setOrganId(admissionEntity.getOrganId());
        wrapperEntity.setDeptId(orderEntity.getDeptId());
        if (ServiceTypeEnum.NOS.getValue().equals(admissionEntity.getServType())) {
            wrapperEntity.setServiceCode(ServiceTypeEnum.NOS.getCode());
        }
        if (ServiceTypeEnum.HOS.getValue().equals(admissionEntity.getServType())) {
            wrapperEntity.setServiceCode(ServiceTypeEnum.HOS.getCode());
        }
        queryWrapper.setEntity((Object)wrapperEntity);
        queryWrapper.last("limit 1");
        InquiryServiceConfigEntity inquiryServiceConfigEntity = (InquiryServiceConfigEntity)this.baseService.getOne((Wrapper)queryWrapper);
        if (null == inquiryServiceConfigEntity) {
            log.info("\u672a\u67e5\u8be2\u5230\u533b\u751f\u7684\u670d\u52a1\u4fe1\u606f");
            return null;
        }
        log.info("\u533b\u751f\u7684\u670d\u52a1\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)inquiryServiceConfigEntity));
        return inquiryServiceConfigEntity;
    }

    @Async
    public void delay(String admissionId, String doctorId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        Integer doctorType = admissionInfo.getDoctorType();
        if (doctorType == null) {
            return;
        }
        if (DoctorTypeEnum.TEAM.getValue().equals(admissionInfo.getDoctorType())) {
            admissionInfo.setAimName(this.getDoctorName(doctorId));
        }
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        if (admissionInfo.getServiceType().equals(ServiceTypeEnum.HOS.getValue())) {
            messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text(admissionInfo.getAimName() + "\u533b\u751f\u5df2\u6210\u529f\u7ed9\u54a8\u8be2\u5ef6\u65f6"), IMInformConstants.REFRESH));
            messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text(admissionInfo.getAimName() + "\u533b\u751f\u4e3a\u60a8\u5ef6\u957f\u4e86\u54a8\u8be2"), IMInformConstants.REFRESH));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u54a8\u8be2\u533b\u751f-\u5ef6\u65f6\u95ee\u8bcaIM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
            }
        } else if (admissionInfo.getServiceType().equals(ServiceTypeEnum.NOS.getValue())) {
            messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text(admissionInfo.getAimName() + "\u533b\u751f\u5df2\u6210\u529f\u7ed9\u590d\u8bca\u5ef6\u65f6"), IMInformConstants.REFRESH));
            messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text(admissionInfo.getAimName() + "\u533b\u751f\u4e3a\u60a8\u5ef6\u957f\u4e86\u590d\u8bca"), IMInformConstants.REFRESH));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u590d\u8bca\u533b\u751f-\u5ef6\u65f6\u95ee\u8bcaIM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
            }
        }
    }

    @Async
    public void patientEndAdm(String admissionId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        Integer doctorType = admissionInfo.getDoctorType();
        log.info("\u4f20\u5165\u7684servType\u4e3a\uff1a{}" + JSON.toJSONString((Object)admissionInfo.getServiceType()));
        if (null != doctorType) {
            if (admissionInfo.getServiceType().equals(ServiceTypeEnum.NOS.getValue())) {
                ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
                messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text(admissionInfo.getPatientName() + "\u4e3b\u52a8\u7ed3\u675f\u4e86\u4e0e\u60a8\u7684\u590d\u8bca"), IMInformConstants.REFRESH));
                messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u60a8\u4e3b\u52a8\u7ed3\u675f\u4e86\u4e0e" + admissionInfo.getAimName() + "\u533b\u751f\u7684\u590d\u8bca"), IMInformConstants.REFRESH));
                messageInfos.add(this.getInformPerPatientParam(admissionInfo, (Object)new Text("\u60a8\u7684\u590d\u8bca\u5df2\u7ed3\u675f\uff0c\u60a8\u53ef\u5bf9" + admissionInfo.getAimName() + "\u533b\u751f\u505a\u51fa\u8bc4\u4ef7")));
                PersonImInformReq parameter = new PersonImInformReq();
                parameter.setMessageInfos(messageInfos);
                parameter.setAdmissionId(admissionId);
                parameter.setBusiCode("zxzx");
                if (this.pushImInform(messageInfos, admissionInfo)) {
                    log.info("IM INFORM COMPLETE \u5728\u7ebf\u590d\u8bca\u75c5\u4eba\u4e3b\u52a8\u7ed3\u675f\u5c31\u8bca\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
                }
            } else if (admissionInfo.getServiceType().equals(ServiceTypeEnum.HOS.getValue())) {
                ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
                messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text(admissionInfo.getPatientName() + "\u4e3b\u52a8\u7ed3\u675f\u4e86\u4e0e\u60a8\u7684\u54a8\u8be2"), IMInformConstants.REFRESH));
                if (admissionInfo.getAdmissionId().startsWith("KFZX")) {
                    messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u60a8\u7684\u54a8\u8be2\u5df2\u7ed3\u675f"), IMInformConstants.REFRESH));
                } else {
                    messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u60a8\u4e3b\u52a8\u7ed3\u675f\u4e86\u4e0e" + admissionInfo.getAimName() + "\u533b\u751f\u7684\u54a8\u8be2"), IMInformConstants.REFRESH));
                    messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u60a8\u7684\u54a8\u8be2\u5df2\u7ed3\u675f\uff0c\u60a8\u53ef\u5bf9" + admissionInfo.getAimName() + "\u533b\u751f\u505a\u51fa\u8bc4\u4ef7"), IMInformConstants.REFRESH));
                }
                PersonImInformReq parameter = new PersonImInformReq();
                parameter.setMessageInfos(messageInfos);
                parameter.setAdmissionId(admissionId);
                parameter.setBusiCode("zxzx");
                if (this.pushImInform(messageInfos, admissionInfo)) {
                    log.info("IM INFORM COMPLETE \u5728\u7ebf\u54a8\u8be2\u75c5\u4eba\u4e3b\u52a8\u7ed3\u675f\u5c31\u8bca\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
                }
            }
        }
    }

    @Async
    public void medicalOpinion(String admissionId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        Integer doctorType = admissionInfo.getDoctorType();
        log.info("doctorType:{}" + JSON.toJSONString((Object)doctorType));
        log.info("serviceType:{}" + JSON.toJSONString((Object)admissionInfo.getServiceType()));
        if (null != doctorType) {
            ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
            if (admissionInfo.getServiceType().equals(ServiceTypeEnum.HOS.getValue())) {
                messageInfos.add(this.getInformCustomPersonDocParamOpinion(admissionInfo, (Object)new Text("\u60a8\u5411" + admissionInfo.getPatientName() + "\u7684\u54a8\u8be2\u7ed9\u51fa\u4e86\u8bca\u7597\u610f\u89c1\"" + admissionInfo.getMedicalOpinion() + "\""), "advice", admissionInfo.getMedicalOpinion()));
                messageInfos.add(this.getInformCustomPerPatientParam(admissionInfo, (Object)new Text(admissionInfo.getMedicalOpinion()), "advice"));
                PersonImInformReq parameter = new PersonImInformReq();
                parameter.setMessageInfos(messageInfos);
                parameter.setAdmissionId(admissionId);
                parameter.setBusiCode("zxzx");
                if (this.pushImInform(messageInfos, admissionInfo)) {
                    log.info("IM INFORM COMPLETE \u5728\u7ebf\u54a8\u8be2\u533b\u751f\u5bf9\u60a3\u8005\u7684\u8bca\u7597\u610f\u89c1\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
                }
            } else if (admissionInfo.getServiceType().equals(ServiceTypeEnum.NOS.getValue())) {
                messageInfos.add(this.getInformAllPersonDocParam(admissionInfo, (Object)new Text("\u60a8\u5411" + admissionInfo.getPatientName() + "\u7684\u590d\u8bca\u7ed9\u51fa\u4e86\u8bca\u7597\u610f\u89c1\"" + admissionInfo.getMedicalOpinion() + "\"")));
                messageInfos.add(this.getInformCustomPerPatientParam(admissionInfo, (Object)new Text(admissionInfo.getMedicalOpinion()), "advice"));
                PersonImInformReq parameter = new PersonImInformReq();
                parameter.setMessageInfos(messageInfos);
                parameter.setAdmissionId(admissionId);
                parameter.setBusiCode("zxzx");
                if (this.pushImInform(messageInfos, admissionInfo)) {
                    log.info("IM INFORM COMPLETE \u5728\u7ebf\u590d\u8bca\u533b\u751f\u5bf9\u60a3\u8005\u7684\u8bca\u7597\u610f\u89c1\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
                }
            }
        }
    }

    public void patientAdmissionSendImMessage(String admId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admId);
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        InternetHospitalEntity internetHospitalEntity = this.internetHospitalDetailInfoService.getInternetHospitalInfo(orderEntity.getHospitalId(), this.projProperties.getInternetHospitalUrl());
        String serveTelephone = internetHospitalEntity.getTelphone();
        if ("HYT".equals(orderEntity.getAppCode())) {
            messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u6b22\u8fce\u60a8\u4f7f\u7528" + ServiceTypeEnum.getDesc((Integer)admissionInfo.getServiceType()) + "\u670d\u52a1\uff0c\u5df2\u901a\u77e5" + admissionInfo.getAimName() + "\u533b\u751f\u67e5\u770b\u60a8\u7684\u75c5\u60c5\u8d44\u6599\uff0c\u56e0\u533b\u751f\u627f\u62c5\u7e41\u91cd\u7684\u65e5\u5e38\u5de5\u4f5c\uff0c\u82e5\u56de\u590d\u8f83\u6162\u671b\u60a8\u8c05\u89e3,\u82e5\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\u5ba2\u670d\uff1a" + serveTelephone + "\uff0c\u6216\u8005\u81f3\u9996\u9875\u70b9\u51fb\u667a\u80fd\u5ba2\u670d\u54a8\u8be2"), IMInformConstants.REFRESH));
        } else {
            messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u6b22\u8fce\u60a8\u4f7f\u7528" + ServiceTypeEnum.getDesc((Integer)admissionInfo.getServiceType()) + "\u670d\u52a1\uff0c\u5df2\u901a\u77e5" + admissionInfo.getAimName() + "\u533b\u751f\u67e5\u770b\u60a8\u7684\u75c5\u60c5\u8d44\u6599\uff0c\u56e0\u533b\u751f\u627f\u62c5\u7e41\u91cd\u7684\u65e5\u5e38\u5de5\u4f5c\uff0c\u82e5\u56de\u590d\u8f83\u6162\u671b\u60a8\u8c05\u89e3,\u82e5\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\u5ba2\u670d\uff1a" + serveTelephone + "\u3002"), IMInformConstants.REFRESH));
        }
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admId);
        parameter.setBusiCode("zxzx");
        log.info("=====\u5019\u8bca\u62a5\u9053\u63a8\u9001\u8c03\u7528IM\u670d\u52a1=====");
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("IM INFORM COMPLETE \u533b\u751f-\u652f\u4ed8\u6210\u529fIM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admId);
        }
    }

    public void doctorAdmissionSendImMessage(String admId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admId);
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        messageInfos.add(this.getInformAllPersonDocParam(admissionInfo, (Object)new Text("\u60a8\u5df2\u63a5\u8bca\u8be5\u60a3\u8005\uff0c\u8bf7\u5f00\u59cb\u770b\u8bca\u5427")));
        messageInfos.add(this.getInformPerPatientParam(admissionInfo, (Object)new Text("\u56e0\u533b\u751f\u4e0d\u80fd\u9762\u8bca\uff0c\u65e0\u6cd5\u5ba2\u89c2\u5168\u9762\u7684\u4e86\u89e3\u60a8\u7684\u75c5\u60c5\uff0c\u533b\u751f\u7684\u5efa\u8bae\u4ec5\u9650\u53c2\u8003\u3002")));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admId);
        parameter.setBusiCode("zxzx");
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("IM INFORM COMPLETE \u533b\u751f\u7aef\u5f00\u59cb\u770b\u8bca\u4fe1\u606f\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admId);
        }
    }

    public void addDoctorMedicalOpinion(String admId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admId);
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        if (admissionInfo.getServiceType().equals(ServiceTypeEnum.HOS.getValue())) {
            messageInfos.add(this.getInformAllPersonDocParam(admissionInfo, (Object)new Text("\u60a8\u5411" + admissionInfo.getPatientName() + "\u7684\u54a8\u8be2\u7ed9\u51fa\u4e86\u8bca\u7597\u610f\u89c1\"" + admissionInfo.getMedicalOpinion() + "\"")));
            InformMedicalOptionVo informMedicalOptionVo = new InformMedicalOptionVo();
            informMedicalOptionVo.setMedicalOption(admissionInfo.getMedicalOpinion());
            messageInfos.add(this.getInformCustomPerPatientParam(admissionInfo, (Object)new Text(admissionInfo.getMedicalOpinion()), "advice"));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u54a8\u8be2\u533b\u751f\u7aef\u7ed9\u51fa\u8bca\u7597\u610f\u89c1\u4fe1\u606f\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admId);
            }
        } else if (admissionInfo.getServiceType().equals(ServiceTypeEnum.NOS.getValue())) {
            messageInfos.add(this.getInformAllPersonDocParam(admissionInfo, (Object)new Text("\u60a8\u5411" + admissionInfo.getPatientName() + "\u7684\u590d\u8bca\u7ed9\u51fa\u4e86\u8bca\u7597\u610f\u89c1\"" + admissionInfo.getMedicalOpinion() + "\"")));
            InformMedicalOptionVo informMedicalOptionVo = new InformMedicalOptionVo();
            informMedicalOptionVo.setMedicalOption(admissionInfo.getMedicalOpinion());
            messageInfos.add(this.getInformCustomPerPatientParam(admissionInfo, (Object)new Text(admissionInfo.getMedicalOpinion()), "advice"));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u590d\u8bca\u533b\u751f\u7aef\u7ed9\u51fa\u8bca\u7597\u610f\u89c1\u4fe1\u606f\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admId);
            }
        }
    }

    public void endDoctorAdmissionSendImMessage(String admId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admId);
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        if (admissionInfo.getServiceType().equals(ServiceTypeEnum.NOS.getValue())) {
            messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text("\u672c\u6b21\u590d\u8bca\u5df2\u7ed3\u675f"), IMInformConstants.REFRESH));
            if (admissionInfo.getAdmissionId().startsWith("KFZX")) {
                messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u672c\u6b21\u54a8\u8be2\u5df2\u7ed3\u675f"), IMInformConstants.REFRESH));
            } else {
                messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u60a8\u7684\u5728\u7ebf\u54a8\u8be2\u5df2\u7ed3\u675f\uff0c\u60a8\u53ef\u5bf9" + admissionInfo.getAimName() + "\u533b\u751f\u8fdb\u884c\u8bc4\u4ef7"), IMInformConstants.REFRESH));
            }
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u590d\u8bca\u533b\u751f\u7aef\u7ed9\u51fa\u8bca\u7597\u610f\u89c1\u4fe1\u606f\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admId);
            }
        } else if (admissionInfo.getServiceType().equals(ServiceTypeEnum.HOS.getValue())) {
            messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text("\u672c\u6b21\u54a8\u8be2\u5df2\u7ed3\u675f"), IMInformConstants.REFRESH));
            if (admissionInfo.getAdmissionId().startsWith("KFZX")) {
                messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u672c\u6b21\u54a8\u8be2\u5df2\u7ed3\u675f"), IMInformConstants.REFRESH));
            } else {
                messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u60a8\u7684\u5728\u7ebf\u54a8\u8be2\u5df2\u7ed3\u675f\uff0c\u60a8\u53ef\u5bf9" + admissionInfo.getAimName() + "\u533b\u751f\u8fdb\u884c\u8bc4\u4ef7"), IMInformConstants.REFRESH));
            }
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u54a8\u8be2\u533b\u751f\u7aef\u7ed9\u51fa\u8bca\u7597\u610f\u89c1\u4fe1\u606f\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admId);
            }
        }
    }

    public BaseResponse<String> doctorRefundAppeal(String admissionId, String doctorId) {
        Boolean flag;
        String redisKey = admissionId + "_TKSS";
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admissionId);
        if (Objects.equals(DoctorTypeEnum.TEAM.getValue(), orderEntity.getDoctorType()) && (flag = Boolean.valueOf(this.redisTemplateService.addLockNew(redisKey, redisKey, 600L))).booleanValue()) {
            log.info("\u8be5\u8ba2\u5355\u5df2\u9000\u6b3e\u7533\u8bc9");
            return BaseResponse.error((String)"\u8be5\u8ba2\u5355\u5df2\u9000\u6b3e\u7533\u8bc9");
        }
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        InternetHospitalEntity internetHospitalEntity = this.internetHospitalDetailInfoService.getInternetHospitalInfo(orderEntity.getHospitalId(), this.projProperties.getInternetHospitalUrl());
        String serveTelephone = internetHospitalEntity.getTelphone();
        AdmissionEntity admissionEntity = (AdmissionEntity)this.admissionMapper.selectById((Serializable)((Object)admissionId));
        log.info("admissionEntity:{}", (Object)JSON.toJSONString((Object)admissionEntity));
        if (DoctorTypeEnum.TEAM.getValue().equals(admissionInfo.getDoctorType())) {
            admissionInfo.setAimName(this.getDoctorName(doctorId));
        }
        if (admissionInfo.getServiceType().equals(ServiceTypeEnum.HOS.getValue())) {
            messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text(admissionInfo.getAimName() + "\u533b\u751f\u5df2\u53d1\u8d77\u9488\u5bf9" + admissionInfo.getPatientName() + "\u60a3\u8005\u54a8\u8be2\u7533\u8bf7\u5355\u7684\u7533\u8bc9\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u7ba1\uf9e4\u5458\u5904\uf9e4\u3002\u60a8\u53ef\u80fd\u6536\u5230\u5ba2\u670d " + serveTelephone + "\u7684\u81f4\u7535\u6216\u77ed\u4fe1\uff0c\u65e8\u5728\u5bf9\u672c\u6b21\u7533\u8bc9\u8ba2\u5355\u7684\u8fdb\u4e00\u6b65\uf9ba\u89e3\uff0c\u8bf7\u4fdd\u6301\u901a\u8bdd\u7545\u901a\uff0c\u8c22\u8c22\u3002"), IMInformConstants.REFRESH));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u54a8\u8be2\u533b\u751f\u7aef\u63d0\u51fa\u9000\u6b3e\u7533\u8bc9\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
            }
        } else if (admissionInfo.getServiceType().equals(ServiceTypeEnum.NOS.getValue())) {
            messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text(admissionInfo.getAimName() + "\u533b\u751f\u5df2\u53d1\u8d77\u9488\u5bf9" + admissionInfo.getPatientName() + "\u60a3\u8005\u590d\u8bca\u7533\u8bf7\u5355\u7684\u7533\u8bc9\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u7ba1\uf9e4\u5458\u5904\uf9e4\u3002\u60a8\u53ef\u80fd\u6536\u5230\u5ba2\u670d " + serveTelephone + "\u7684\u81f4\u7535\u6216\u77ed\u4fe1\uff0c\u65e8\u5728\u5bf9\u672c\u6b21\u7533\u8bc9\u8ba2\u5355\u7684\u8fdb\u4e00\u6b65\uf9ba\u89e3\uff0c\u8bf7\u4fdd\u6301\u901a\u8bdd\u7545\u901a\uff0c\u8c22\u8c22\u3002"), IMInformConstants.REFRESH));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u590d\u8bca\u533b\u751f\u7aef\u63d0\u51fa\u9000\u6b3e\u7533\u8bc9\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
            }
        }
        return BaseResponse.success((Object)"\u7533\u8bc9\u6210\u529f");
    }

    public void managerRefund(String admissionId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admissionId);
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        InternetHospitalEntity internetHospitalEntity = this.internetHospitalDetailInfoService.getInternetHospitalInfo(orderEntity.getHospitalId(), this.projProperties.getInternetHospitalUrl());
        String serveTelephone = internetHospitalEntity.getTelphone();
        AdmissionEntity admissionEntity = (AdmissionEntity)this.admissionMapper.selectById((Serializable)((Object)admissionId));
        log.info("admissionEntity:{}", (Object)JSON.toJSONString((Object)admissionEntity));
        if (admissionInfo.getServiceType().equals(ServiceTypeEnum.HOS.getValue())) {
            if (!Objects.equals(admissionEntity.getStatus(), AdmissionStatusEnum.WAIT_ADMISSION)) {
                messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text("\u56e0" + admissionEntity.getXRemark() + "\uff0c\u7ba1\u7406\u5458\u5df2\u4e3a\u60a3\u8005\u9000\u6b3e\uff0c\u672c\u6b21\u54a8\u8be2\u5df2\u5931\u6548\u3002"), IMInformConstants.REFRESH));
            }
            messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u56e0" + admissionEntity.getXRemark() + "\uff0c\u60a8\u7684\u672c\u6b21\u54a8\u8be2\u5df2\u5931\u6548\uff0c\u7cfb\u7edf\u5c06\u81ea\u52a8\u4e3a\u60a8\u9000\u6b3e\u3002"), IMInformConstants.REFRESH));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u54a8\u8be2\u533b\u751f\u7aef\u63d0\u51fa\u9000\u6b3e\u7533\u8bc9\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
            }
        } else if (admissionInfo.getServiceType().equals(ServiceTypeEnum.NOS.getValue())) {
            if (!Objects.equals(admissionEntity.getStatus(), AdmissionStatusEnum.WAIT_ADMISSION)) {
                messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text("\u56e0" + admissionEntity.getXRemark() + "\uff0c\u7ba1\u7406\u5458\u5df2\u4e3a\u60a3\u8005\u9000\u6b3e\uff0c\u672c\u6b21\u590d\u8bca\u5df2\u5931\u6548\u3002"), IMInformConstants.REFRESH));
            }
            messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u56e0" + admissionEntity.getXRemark() + "\uff0c\u60a8\u7684\u672c\u6b21\u590d\u8bca\u5df2\u5931\u6548\uff0c\u7cfb\u7edf\u5c06\u81ea\u52a8\u4e3a\u60a8\u9000\u6b3e\u3002"), IMInformConstants.REFRESH));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u590d\u8bca\u533b\u751f\u7aef\u63d0\u51fa\u9000\u6b3e\u7533\u8bc9\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
            }
        }
    }

    public void notConfirmedManager(String admissionId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admissionId);
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        InternetHospitalEntity internetHospitalEntity = this.internetHospitalDetailInfoService.getInternetHospitalInfo(orderEntity.getHospitalId(), this.projProperties.getInternetHospitalUrl());
        String serveTelephone = internetHospitalEntity.getTelphone();
        AdmissionEntity admissionEntity = (AdmissionEntity)this.admissionMapper.selectById((Serializable)((Object)admissionId));
        log.info("admissionEntity:{}", (Object)JSON.toJSONString((Object)admissionEntity));
        if (admissionInfo.getServiceType().equals(ServiceTypeEnum.HOS.getValue())) {
            if (!Objects.equals(admissionEntity.getStatus(), AdmissionStatusEnum.WAIT_ADMISSION)) {
                messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text("\u56e0" + admissionEntity.getXRemark() + "\uff0c\u672c\u6b21\u54a8\u8be2\u5df2\u5931\u6548\u3002"), IMInformConstants.REFRESH));
            }
            messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u56e0" + admissionEntity.getXRemark() + "\uff0c\u60a8\u7684\u672c\u6b21\u54a8\u8be2\u5df2\u5931\u6548\u3002"), IMInformConstants.REFRESH));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u54a8\u8be2\u60a3\u8005\u8d85\u65f6\u672a\u786e\u8ba4\u95ee\u8bca\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
            }
        } else if (admissionInfo.getServiceType().equals(ServiceTypeEnum.NOS.getValue())) {
            if (!Objects.equals(admissionEntity.getStatus(), AdmissionStatusEnum.WAIT_ADMISSION)) {
                messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text("\u56e0" + admissionEntity.getXRemark() + "\uff0c\u672c\u6b21\u590d\u8bca\u5df2\u5931\u6548\u3002"), IMInformConstants.REFRESH));
            }
            messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u56e0" + admissionEntity.getXRemark() + "\uff0c\u60a8\u7684\u672c\u6b21\u590d\u8bca\u5df2\u5931\u6548\u3002"), IMInformConstants.REFRESH));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u590d\u8bca\u8d85\u65f6\u672a\u786e\u8ba4\u95ee\u8bca\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
            }
        }
    }

    public void appealSuccess(String admissionId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        Integer doctorType = admissionInfo.getDoctorType();
        if (doctorType == null) {
            return;
        }
        if (admissionInfo.getServiceType().equals(ServiceTypeEnum.HOS.getValue())) {
            if (DoctorTypeEnum.PERSONAL.getValue().equals(doctorType)) {
                ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
                messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text("\u60a8\u5bf9" + admissionInfo.getPatientName() + "\u60a3\u8005\u7684\u54a8\u8be2\u8ba2\u5355\u7533\u8bc9\u5df2\u5904\u7406\u5b8c\u6210\u3002"), IMInformConstants.REFRESH));
                PersonImInformReq parameter = new PersonImInformReq();
                parameter.setMessageInfos(messageInfos);
                parameter.setAdmissionId(admissionId);
                parameter.setBusiCode("zxzx");
                if (this.pushImInform(messageInfos, admissionInfo)) {
                    log.info("IM INFORM COMPLETE \u5728\u7ebf\u54a8\u8be2\u533b\u751f-\u7533\u8bc9\u6210\u529fIM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
                }
            } else {
                ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
                messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text("\u60a8\u5bf9" + admissionInfo.getPatientName() + "\u60a3\u8005\u7684\u54a8\u8be2\u8ba2\u5355\u7533\u8bc9\u5df2\u5904\u7406\u5b8c\u6210\u3002"), IMInformConstants.REFRESH));
                TeamImInformReq parameter = new TeamImInformReq();
                parameter.setMessageInfos(messageInfos);
                parameter.setGroupId(admissionInfo.getGroupId());
                parameter.setAdmissionId(admissionId);
                parameter.setBusiCode("zxzx");
                if (this.teamImInform(parameter)) {
                    log.info("IM INFORM COMPLETE \u5728\u7ebf\u54a8\u8be2\u56e2\u961f-\u7533\u8bc9\u6210\u529fIM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
                }
            }
        } else if (admissionInfo.getServiceType().equals(ServiceTypeEnum.NOS.getValue())) {
            if (DoctorTypeEnum.PERSONAL.getValue().equals(doctorType)) {
                ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
                messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text("\u60a8\u5bf9" + admissionInfo.getPatientName() + "\u60a3\u8005\u7684\u590d\u8bca\u8ba2\u5355\u7533\u8bc9\u5df2\u5904\u7406\u5b8c\u6210\u3002"), IMInformConstants.REFRESH));
                PersonImInformReq parameter = new PersonImInformReq();
                parameter.setMessageInfos(messageInfos);
                parameter.setAdmissionId(admissionId);
                parameter.setBusiCode("zxzx");
                if (this.pushImInform(messageInfos, admissionInfo)) {
                    log.info("IM INFORM COMPLETE \u5728\u7ebf\u590d\u8bca\u533b\u751f-\u7533\u8bc9\u6210\u529fIM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
                }
            } else {
                ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
                messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text("\u60a8\u5bf9" + admissionInfo.getPatientName() + "\u60a3\u8005\u7684\u590d\u8bca\u8ba2\u5355\u7533\u8bc9\u5df2\u5904\u7406\u5b8c\u6210\u3002"), IMInformConstants.REFRESH));
                TeamImInformReq parameter = new TeamImInformReq();
                parameter.setMessageInfos(messageInfos);
                parameter.setGroupId(admissionInfo.getGroupId());
                parameter.setAdmissionId(admissionId);
                parameter.setBusiCode("zxzx");
                if (this.teamImInform(parameter)) {
                    log.info("IM INFORM COMPLETE \u5728\u7ebf\u590d\u8bca\u56e2\u961f-\u7533\u8bc9\u6210\u529fIM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
                }
            }
        }
    }

    public void patientMissedVideo(InitiateVideoReqVo param) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(param.getAdmId());
        ArrayList<MessageInfo> messageInfosDoc = new ArrayList<MessageInfo>();
        ArrayList<MessageInfo> messageInfosPat = new ArrayList<MessageInfo>();
        String text = "\u89c6\u9891";
        if (Objects.isNull(param.getType()) || Objects.equals("1", param.getType())) {
            text = "\u89c6\u9891";
        } else if (Objects.equals("2", param.getType())) {
            text = "\u8bed\u97f3";
        }
        messageInfosDoc.add(this.getInformAllPersonDocParam(admissionInfo, (Object)new Text("\u60a3\u8005\u672a\u54cd\u5e94" + text + "\u95ee\u8bca\u8bf7\u6c42\uff0c\u5df2\u4e3a\u60a8\u5207\u6362\u2f84\u56fe\u6587\u95ee\u8bca\u6a21\u5f0f\uff0c\u4e0e\u60a3\u8005\u6c9f\u901a\u540e\u53ef\u518d\u6b21\u53d1\u8d77" + text + "\u901a\u8bdd")));
        messageInfosPat.add(this.getInformPerPatientParam(admissionInfo, (Object)new Text("\u60a8\u672a\u54cd\u5e94\u533b\u751f\u53d1\u6765\u7684" + text + "\u901a\u8bdd\u8bf7\u6c42\uff0c\u5df2\u4e3a\u60a8\u5207\u6362\u2f84\u56fe\u2f42\u95ee\u8bca\u6a21\u5f0f\u3002")));
        PersonImInformReq parameterDoc = new PersonImInformReq();
        PersonImInformReq parameterPat = new PersonImInformReq();
        parameterDoc.setMessageInfos(messageInfosDoc);
        parameterPat.setMessageInfos(messageInfosPat);
        parameterDoc.setAdmissionId(param.getAdmId());
        parameterPat.setAdmissionId(param.getAdmId());
        parameterDoc.setBusiCode("zxzx");
        parameterPat.setBusiCode("zxzx");
        if (this.pushImInform(messageInfosDoc, admissionInfo)) {
            log.info(" \u60a3\u800530s\u672a\u63a5\u542c\u2f83\u81ea\u52a8\u6302\u65ad\u89c6\u9891\u6216\u533b\u751f\u4e3b\u52a8\u6302\u65ad\u89c6\u9891\u6216\u60a3\u8005\u4e3b\u52a8\u6302\u65ad\u89c6\u9891im-doc\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)param.getAdmId());
        }
    }

    public Boolean pushEvaluationMessage(UcUserEvaluationDTO ucUserEvaluationDTO) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(ucUserEvaluationDTO.getAdmId());
        Integer doctorType = ucUserEvaluationDTO.getEvalType().intValue();
        if (doctorType == null) {
            return false;
        }
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        messageInfos.add(this.getInformCustomPerPatientParam(admissionInfo, (Object)ucUserEvaluationDTO, "review"));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admissionInfo.getAdmissionId());
        parameter.setBusiCode("zxzx");
        if (!this.pushImInform(messageInfos, admissionInfo)) {
            return false;
        }
        log.info("IM INFORM COMPLETE \u60a3\u8005-\u8bc4\u4ef7IM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionInfo.getAdmissionId());
        return true;
    }

    public void waitingReportPushPatientCard(String admissionId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        messageInfos.add(this.getInformCustomPersonDocParam(admissionInfo, (Object)this.getCaseHistory(admissionId), "order"));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admissionId);
        parameter.setBusiCode("zxzx");
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("IM INFORM COMPLETE \u5019\u8bca\u62a5\u9053\u63a8\u9001\u5c0f\u5361\u7247\u5230\u533b\u751f\u7aefIM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
        }
    }

    private <T> MessageInfo getInformCustomPersonDocParam(AdmissionInfo admissionInfo, T content, String businessCode) {
        String doctorUserId = admissionInfo.getDoctorUserId();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)doctorUserId)) {
            log.error("IM INFORM ERROR : \u65e0\u6cd5\u67e5\u8be2\u5230\u63a5\u6536\u4eba\u4fe1\u606f");
            return new MessageInfo();
        }
        MessageInfo messageInfo = new MessageInfo();
        Message message = new Message();
        message.setMessageType(IMInformConstants.SERVICE_SYSTEM_FREE_TYPE);
        message.setBusinessCode(businessCode);
        message.setApplicationCode("zxzx");
        message.setAdmissionId(admissionInfo.getAdmissionId());
        message.setData(content);
        message.setApplicationCode("zxzx");
        messageInfo.setSingleAccount(this.newAccount("EHOS_DOCTOR", doctorUserId));
        messageInfo.setSelfAccount(this.newAccount("EHOS_PATIENT", admissionInfo.getPatientUserId()));
        if (DoctorTypeEnum.TEAM.getValue().equals(admissionInfo.getDoctorType())) {
            message.setTeamFlag("1");
            message.setMsgId(UUIDUtil.generateViewId());
            List list = this.getAccountVOS(admissionInfo);
            messageInfo.setReceiveAccounts(list);
        }
        messageInfo.setMessage(message);
        return messageInfo;
    }

    private List<AccountVO> getAccountVOS(AdmissionInfo admissionInfo) {
        ArrayList<AccountVO> list = new ArrayList<AccountVO>();
        List teamDoctorInfoEntityList = this.doctorTemInfomService.selectTeamInfoByAdmId(admissionInfo.getAdmissionId());
        if (!CollectionUtils.isEmpty((Collection)teamDoctorInfoEntityList)) {
            for (TeamDoctorInfoEntity teamDoctorInfoEntity : teamDoctorInfoEntityList) {
                list.add(this.newAccount("EHOS_DOCTOR", teamDoctorInfoEntity.getUesrId()));
            }
        }
        return list;
    }

    private <T> MessageInfo getInformCustomPersonDocParamOpinion(AdmissionInfo admissionInfo, T content, String businessCode, String medicalOpinion) {
        String doctorUserId = admissionInfo.getDoctorUserId();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)doctorUserId)) {
            log.error("IM INFORM ERROR : \u65e0\u6cd5\u67e5\u8be2\u5230\u63a5\u6536\u4eba\u4fe1\u606f");
            return new MessageInfo();
        }
        MessageInfo messageInfo = new MessageInfo();
        Message message = new Message();
        message.setMessageType(IMInformConstants.SERVICE_SYSTEM_FIXATION_TYPE);
        message.setBusinessCode(businessCode);
        message.setApplicationCode("zxzx");
        message.setAdmissionId(admissionInfo.getAdmissionId());
        message.setData(content);
        message.setMedicalOpinion(medicalOpinion);
        message.setApplicationCode("zxzx");
        messageInfo.setSingleAccount(this.newAccount("EHOS_DOCTOR", doctorUserId));
        messageInfo.setSelfAccount(this.newAccount("EHOS_PATIENT", admissionInfo.getPatientUserId()));
        if (DoctorTypeEnum.TEAM.getValue().equals(admissionInfo.getDoctorType())) {
            message.setTeamFlag("1");
            message.setMsgId(UUIDUtil.generateViewId());
            List list = this.getAccountVOS(admissionInfo);
            messageInfo.setReceiveAccounts(list);
        }
        messageInfo.setMessage(message);
        return messageInfo;
    }

    private <T> MessageInfo getMedicalOpinionCustomPersonDocParam(AdmissionInfo admissionInfo, T content, String businessCode) {
        String doctorUserId = admissionInfo.getDoctorUserId();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)doctorUserId)) {
            log.error("IM INFORM ERROR : \u65e0\u6cd5\u67e5\u8be2\u5230\u63a5\u6536\u4eba\u4fe1\u606f");
            return new MessageInfo();
        }
        MessageInfo messageInfo = new MessageInfo();
        Message message = new Message();
        message.setMessageType(IMInformConstants.SERVICE_SYSTEM_FREE_TYPE);
        message.setBusinessCode(businessCode);
        message.setApplicationCode("zxzx");
        message.setAdmissionId(admissionInfo.getAdmissionId());
        message.setData(content);
        message.setApplicationCode("zxzx");
        messageInfo.setSingleAccount(this.newAccount("EHOS_DOCTOR", doctorUserId));
        messageInfo.setSelfAccount(this.newAccount("EHOS_PATIENT", admissionInfo.getPatientUserId()));
        if (DoctorTypeEnum.TEAM.getValue().equals(admissionInfo.getDoctorType())) {
            message.setTeamFlag("1");
            message.setMsgId(UUIDUtil.generateViewId());
            List list = this.getAccountVOS(admissionInfo);
            messageInfo.setReceiveAccounts(list);
        }
        messageInfo.setMessage(message);
        return messageInfo;
    }

    private <T> MessageInfo getInformCustomPerPatientParam(AdmissionInfo admissionInfo, T content, String businessCode) {
        String patientUserId = admissionInfo.getPatientUserId();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)patientUserId)) {
            log.error("IM INFORM ERROR : \u65e0\u6cd5\u67e5\u8be2\u5230\u63a5\u6536\u4eba\u4fe1\u606f");
            return new MessageInfo();
        }
        MessageInfo messageInfo = new MessageInfo();
        Message message = new Message();
        message.setMessageType(IMInformConstants.SERVICE_SYSTEM_FREE_TYPE);
        message.setBusinessCode(businessCode);
        message.setAdmissionId(admissionInfo.getAdmissionId());
        message.setApplicationCode("zxzx");
        message.setData(content);
        message.setApplicationCode("zxzx");
        messageInfo.setSingleAccount(this.newAccount("EHOS_PATIENT", patientUserId));
        messageInfo.setSelfAccount(this.newAccount("EHOS_DOCTOR", admissionInfo.getDoctorUserId()));
        if (DoctorTypeEnum.TEAM.getValue().equals(admissionInfo.getDoctorType())) {
            message.setTeamFlag("1");
            message.setMsgId(UUIDUtil.generateViewId());
            ArrayList<AccountVO> list = new ArrayList<AccountVO>();
            list.add(this.newAccount("EHOS_PATIENT", patientUserId));
            messageInfo.setReceiveAccounts(list);
        }
        messageInfo.setMessage(message);
        return messageInfo;
    }

    private <T> MessageInfo getInformAllPersonDocParam(AdmissionInfo admissionInfo, T content) {
        String doctorUserId = admissionInfo.getDoctorUserId();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)doctorUserId)) {
            log.error("IM INFORM ERROR : \u65e0\u6cd5\u67e5\u8be2\u5230\u63a5\u6536\u4eba\u4fe1\u606f");
            return new MessageInfo();
        }
        MessageInfo messageInfo = new MessageInfo();
        Message message = new Message();
        message.setMessageType(IMInformConstants.SERVICE_SYSTEM_FIXATION_TYPE);
        message.setAdmissionId(admissionInfo.getAdmissionId());
        message.setApplicationCode("zxzx");
        message.setData(content);
        messageInfo.setSingleAccount(this.newAccount("EHOS_DOCTOR", doctorUserId));
        messageInfo.setSelfAccount(this.newAccount("EHOS_PATIENT", admissionInfo.getPatientUserId()));
        if (DoctorTypeEnum.TEAM.getValue().equals(admissionInfo.getDoctorType())) {
            message.setTeamFlag("1");
            message.setMsgId(UUIDUtil.generateViewId());
            List list = this.getAccountVOS(admissionInfo);
            messageInfo.setReceiveAccounts(list);
        }
        messageInfo.setMessage(message);
        return messageInfo;
    }

    private <T> MessageInfo getInformAllPersonDocParamOpinion(AdmissionInfo admissionInfo, T content, String medicalOpinion) {
        String doctorUserId = admissionInfo.getDoctorUserId();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)doctorUserId)) {
            log.error("IM INFORM ERROR : \u65e0\u6cd5\u67e5\u8be2\u5230\u63a5\u6536\u4eba\u4fe1\u606f");
            return new MessageInfo();
        }
        MessageInfo messageInfo = new MessageInfo();
        Message message = new Message();
        message.setMessageType(IMInformConstants.SERVICE_SYSTEM_FIXATION_TYPE);
        message.setAdmissionId(admissionInfo.getAdmissionId());
        message.setApplicationCode("zxzx");
        message.setMedicalOpinion(medicalOpinion);
        message.setData(content);
        messageInfo.setSingleAccount(this.newAccount("EHOS_DOCTOR", doctorUserId));
        messageInfo.setSelfAccount(this.newAccount("EHOS_PATIENT", admissionInfo.getPatientUserId()));
        messageInfo.setMessage(message);
        return messageInfo;
    }

    private <T> MessageInfo getPersonDocParam(AdmissionInfo admissionInfo, T content) {
        String doctorUserId = admissionInfo.getDoctorUserId();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)doctorUserId)) {
            log.error("IM INFORM ERROR : \u65e0\u6cd5\u67e5\u8be2\u5230\u63a5\u6536\u4eba\u4fe1\u606f");
            return new MessageInfo();
        }
        MessageInfo messageInfo = new MessageInfo();
        Message message = new Message();
        message.setMessageType(IMInformConstants.SERVICE_SYSTEM_FIXATION_TYPE);
        message.setAdmissionId(admissionInfo.getAdmissionId());
        message.setBusinessCode("time");
        message.setApplicationCode("zxzx");
        message.setData(content);
        message.setApplicationCode("zxzx");
        messageInfo.setSingleAccount(this.newAccount("EHOS_DOCTOR", doctorUserId));
        messageInfo.setSelfAccount(this.newAccount("EHOS_PATIENT", admissionInfo.getPatientUserId()));
        if (DoctorTypeEnum.TEAM.getValue().equals(admissionInfo.getDoctorType())) {
            message.setTeamFlag("1");
            message.setMsgId(UUIDUtil.generateViewId());
            List list = this.getAccountVOS(admissionInfo);
            messageInfo.setReceiveAccounts(list);
        }
        messageInfo.setMessage(message);
        return messageInfo;
    }

    private <T> MessageInfo getInformRefreshDocParam(AdmissionInfo admissionInfo, T content, Integer isRefresh) {
        String doctorUserId = admissionInfo.getDoctorUserId();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)doctorUserId)) {
            log.error("IM INFORM ERROR : \u65e0\u6cd5\u67e5\u8be2\u5230\u63a5\u6536\u4eba\u4fe1\u606f");
            return new MessageInfo();
        }
        MessageInfo messageInfo = new MessageInfo();
        Message message = new Message();
        message.setMessageType(IMInformConstants.SERVICE_SYSTEM_FIXATION_TYPE);
        message.setAdmissionId(admissionInfo.getAdmissionId());
        message.setApplicationCode("zxzx");
        message.setIsRefresh(isRefresh);
        message.setData(content);
        message.setApplicationCode("zxzx");
        messageInfo.setSingleAccount(this.newAccount("EHOS_DOCTOR", doctorUserId));
        messageInfo.setSelfAccount(this.newAccount("EHOS_PATIENT", admissionInfo.getPatientUserId()));
        if (DoctorTypeEnum.TEAM.getValue().equals(admissionInfo.getDoctorType())) {
            message.setTeamFlag("1");
            message.setMsgId(UUIDUtil.generateViewId());
            List list = this.getAccountVOS(admissionInfo);
            messageInfo.setReceiveAccounts(list);
        }
        messageInfo.setMessage(message);
        return messageInfo;
    }

    private <T> MessageInfo getInformPerPatientParam(AdmissionInfo admissionInfo, T content) {
        String patientUserId = admissionInfo.getPatientUserId();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)patientUserId)) {
            log.error("IM INFORM ERROR : \u65e0\u6cd5\u67e5\u8be2\u5230\u63a5\u6536\u4eba\u4fe1\u606f");
            return new MessageInfo();
        }
        MessageInfo messageInfo = new MessageInfo();
        Message message = new Message();
        message.setMessageType(IMInformConstants.SERVICE_SYSTEM_FIXATION_TYPE);
        message.setAdmissionId(admissionInfo.getAdmissionId());
        message.setApplicationCode("zxzx");
        message.setData(content);
        message.setIsRefresh(Integer.valueOf(1));
        message.setApplicationCode("zxzx");
        messageInfo.setSingleAccount(this.newAccount("EHOS_PATIENT", patientUserId));
        messageInfo.setSelfAccount(this.newAccount("EHOS_DOCTOR", admissionInfo.getDoctorUserId()));
        if (DoctorTypeEnum.TEAM.getValue().equals(admissionInfo.getDoctorType())) {
            ArrayList<AccountVO> list = new ArrayList<AccountVO>();
            list.add(this.newAccount("EHOS_PATIENT", patientUserId));
            messageInfo.setReceiveAccounts(list);
            message.setTeamFlag("1");
            message.setMsgId(UUIDUtil.generateViewId());
        }
        messageInfo.setMessage(message);
        return messageInfo;
    }

    private <T> MessageInfo getPatientParam(AdmissionInfo admissionInfo, T content) {
        String patientUserId = admissionInfo.getPatientUserId();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)patientUserId)) {
            log.error("IM INFORM ERROR : \u65e0\u6cd5\u67e5\u8be2\u5230\u63a5\u6536\u4eba\u4fe1\u606f");
            return new MessageInfo();
        }
        MessageInfo messageInfo = new MessageInfo();
        Message message = new Message();
        message.setMessageType(IMInformConstants.SERVICE_SYSTEM_FIXATION_TYPE);
        message.setAdmissionId(admissionInfo.getAdmissionId());
        message.setData(content);
        message.setApplicationCode("zxzx");
        message.setBusinessCode("time");
        messageInfo.setSingleAccount(this.newAccount("EHOS_PATIENT", patientUserId));
        messageInfo.setSelfAccount(this.newAccount("EHOS_DOCTOR", admissionInfo.getDoctorUserId()));
        if (DoctorTypeEnum.TEAM.getValue().equals(admissionInfo.getDoctorType())) {
            ArrayList<AccountVO> list = new ArrayList<AccountVO>();
            list.add(this.newAccount("EHOS_PATIENT", patientUserId));
            messageInfo.setReceiveAccounts(list);
            message.setTeamFlag("1");
            message.setMsgId(UUIDUtil.generateViewId());
        }
        messageInfo.setMessage(message);
        return messageInfo;
    }

    private <T> MessageInfo getInformRefreshPatientParam(AdmissionInfo admissionInfo, T content, Integer isRefresh) {
        String patientUserId = admissionInfo.getPatientUserId();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)patientUserId)) {
            log.error("IM INFORM ERROR : \u65e0\u6cd5\u67e5\u8be2\u5230\u63a5\u6536\u4eba\u4fe1\u606f");
            return new MessageInfo();
        }
        MessageInfo messageInfo = new MessageInfo();
        Message message = new Message();
        message.setMessageType(IMInformConstants.SERVICE_SYSTEM_FIXATION_TYPE);
        message.setAdmissionId(admissionInfo.getAdmissionId());
        message.setApplicationCode("zxzx");
        message.setIsRefresh(isRefresh);
        message.setData(content);
        messageInfo.setMessage(message);
        message.setApplicationCode("zxzx");
        messageInfo.setSingleAccount(this.newAccount("EHOS_PATIENT", patientUserId));
        messageInfo.setSelfAccount(this.newAccount("EHOS_DOCTOR", admissionInfo.getDoctorUserId()));
        if (DoctorTypeEnum.TEAM.getValue().equals(admissionInfo.getDoctorType())) {
            ArrayList<AccountVO> list = new ArrayList<AccountVO>();
            list.add(this.newAccount("EHOS_PATIENT", patientUserId));
            messageInfo.setReceiveAccounts(list);
            message.setTeamFlag("1");
            message.setMsgId(UUIDUtil.generateViewId());
        }
        messageInfo.setMessage(message);
        return messageInfo;
    }

    private <T> MessageInfo getPatientParam1(AdmissionInfo admissionInfo, T content) {
        String patientUserId = admissionInfo.getPatientUserId();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)patientUserId)) {
            log.error("IM INFORM ERROR : \u65e0\u6cd5\u67e5\u8be2\u5230\u63a5\u6536\u4eba\u4fe1\u606f");
            return new MessageInfo();
        }
        MessageInfo messageInfo = new MessageInfo();
        Message message = new Message();
        message.setMessageType(IMInformConstants.SERVICE_SYSTEM_FIXATION_TYPE);
        message.setAdmissionId(admissionInfo.getAdmissionId());
        message.setData(content);
        message.setApplicationCode("zxzx");
        message.setBusinessCode("referralTime");
        messageInfo.setSingleAccount(this.newAccount("EHOS_PATIENT", patientUserId));
        messageInfo.setSelfAccount(this.newAccount("EHOS_DOCTOR", admissionInfo.getDoctorUserId()));
        if (DoctorTypeEnum.TEAM.getValue().equals(admissionInfo.getDoctorType())) {
            ArrayList<AccountVO> list = new ArrayList<AccountVO>();
            list.add(this.newAccount("EHOS_PATIENT", patientUserId));
            messageInfo.setReceiveAccounts(list);
            message.setTeamFlag("1");
            message.setMsgId(UUIDUtil.generateViewId());
        }
        messageInfo.setMessage(message);
        return messageInfo;
    }

    private AdmissionInfo getAdmissionInfo(String admissionId) {
        Integer doctorType;
        AdmissionInfo admissionInfo = this.admissionMapper.queryImAdmissionInfo(admissionId);
        if (admissionInfo == null) {
            log.error("IM INFORM ERROR : \u6ca1\u6709\u67e5\u8be2\u5230\u5c31\u8bca\u4fe1\u606f\uff0cadmissionId:{}", (Object)admissionId);
            return new AdmissionInfo();
        }
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admissionId);
        if (orderEntity == null) {
            log.error("IM INFORM ERROR : \u6ca1\u6709\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f\uff0cadmissionId:{}", (Object)admissionId);
            return new AdmissionInfo();
        }
        log.info("orderEntity:{}" + orderEntity.toString());
        if (StringUtils.isNotEmpty((String)orderEntity.getPatientUserId())) {
            admissionInfo.setPatientUserId(orderEntity.getPatientUserId());
            log.info("PatientUserId:{}" + admissionInfo.getPatientUserId());
        }
        if ((doctorType = admissionInfo.getDoctorType()) == null) {
            log.error("IM INFORM ERROR : \u7f3a\u5931\u5c31\u8bca\u4fe1\u606f-\u533b\u751f\u7c7b\u578b doctorType");
            return new AdmissionInfo();
        }
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(admissionInfo.getDoctorId());
        BaseResponse doctorInfo = this.doctorInfofeignClient.queryPersonnelInfo(queryPersonnelInfoReq);
        UserInfoByUserIdRespVO userInfoByUserIdRespVO = this.queryDocAccountInfo(admissionInfo.getDoctorId());
        if (userInfoByUserIdRespVO == null) {
            log.error("IM INFORM ERROR : \u83b7\u53d6\u533b\u751f\u4fe1\u606f\u5931\u8d25 doctorId\uff1a{}", (Object)admissionInfo.getDoctorId());
            return new AdmissionInfo();
        }
        if (null == doctorInfo && !doctorInfo.isSuccess()) {
            log.error("IM INFORM ERROR : \u83b7\u53d6\u533b\u751f\u4fe1\u606f\u5931\u8d25 doctorId\uff1a{}", (Object)admissionInfo.getDoctorId());
            return new AdmissionInfo();
        }
        admissionInfo.setDoctorUserId(userInfoByUserIdRespVO.getUserId());
        admissionInfo.setAimName(orderEntity.getDoctorName());
        admissionInfo.setAdmissionId(admissionId);
        log.info("admissionInfo:{}" + JSON.toJSONString((Object)admissionInfo));
        return admissionInfo;
    }

    private <T> MessageInfo getInformAllTeamDocParam(AdmissionInfo admissionInfo, T content) {
        List memberInfos = admissionInfo.getMemberInfos();
        if (memberInfos == null || memberInfos.isEmpty()) {
            log.error("IM INFORM ERROR : \u65e0\u6cd5\u67e5\u8be2\u5230\u63a5\u6536\u4eba\u4fe1\u606f");
            return new MessageInfo();
        }
        MessageInfo messageInfo = new MessageInfo();
        Message message = new Message();
        message.setMessageType(IMInformConstants.SERVICE_SYSTEM_FIXATION_TYPE);
        message.setAdmissionId(admissionInfo.getAdmissionId());
        message.setData(content);
        message.setApplicationCode("zxzx");
        ArrayList receiveAccounts = new ArrayList();
        memberInfos.forEach(e -> receiveAccounts.add(this.newAccount("EHOS_DOCTOR", e.getAccount())));
        messageInfo.setReceiveAccounts(receiveAccounts);
        messageInfo.setMessage(message);
        messageInfo.setSyncFlag(IMInformConstants.COMMON_DELAY_TIME);
        return messageInfo;
    }

    private boolean teamImInform(TeamImInformReq param) {
        List messageInfos = param.getMessageInfos();
        if (messageInfos == null || messageInfos.isEmpty()) {
            log.error("IM INFORM ERROR : \u6ca1\u6709\u53ef\u53d1\u9001\u7684\u6d88\u606f");
            return false;
        }
        ArrayList msgGroupDatas = new ArrayList();
        messageInfos.forEach(e -> {
            PushGroupMsgDataVO msgGroupData = new PushGroupMsgDataVO();
            msgGroupData.setActionType("system");
            msgGroupData.setToAccount(e.getReceiveAccounts());
            msgGroupData.setMessage(JsonUtil.convertObject((Object)e.getMessage()));
            if (IMInformConstants.SERVICE_SYSTEM_FIXATION_TYPE.equals(e.getMessage().getMessageType())) {
                msgGroupData.setSyncFlag(IMInformConstants.COMMON_DELAY_TIME);
            }
            msgGroupDatas.add(msgGroupData);
        });
        PushGroupMsgReqVO parameter = new PushGroupMsgReqVO();
        parameter.setBusiCode(param.getBusiCode());
        parameter.setTreatmentId(param.getAdmissionId());
        parameter.setMsgData(msgGroupDatas);
        if (!this.pushGroupIm(parameter)) {
            log.info("IM INFORM ERROR : im \u8c03\u7528im\u7cfb\u7edf\u63a8\u9001\u5931\u8d25");
            return false;
        }
        return true;
    }

    private String queryDoctorUserId(String doctorId) {
        FindUserIdListReq findUserIdListReq = new FindUserIdListReq();
        com.ebaiyihui.common.pojo.vo.FindUserIdReqVO findUserIdReqVO = new com.ebaiyihui.common.pojo.vo.FindUserIdReqVO();
        findUserIdReqVO.setUserType(Short.valueOf(CommonConstants.STATUS_VALID.shortValue()));
        findUserIdReqVO.setReqId(doctorId);
        ArrayList<com.ebaiyihui.common.pojo.vo.FindUserIdReqVO> findUserIdReqVOList = new ArrayList<com.ebaiyihui.common.pojo.vo.FindUserIdReqVO>();
        findUserIdReqVOList.add(findUserIdReqVO);
        findUserIdListReq.setFindUserIdReqVOS(findUserIdReqVOList);
        BaseResponse response = this.userCenterClient.queryUserIdList(findUserIdListReq);
        if (!response.isSuccess()) {
            return null;
        }
        List list = (List)response.getData();
        if (list.isEmpty()) {
            return null;
        }
        FindUserIdRespVO findUserIdRespVO = (FindUserIdRespVO)list.get(0);
        return findUserIdRespVO.getUserId();
    }

    private boolean personImInform(PersonImInformReq param) {
        List messageInfos = param.getMessageInfos();
        if (messageInfos == null || messageInfos.isEmpty()) {
            log.error("IM INFORM ERROR : \u6ca1\u6709\u53ef\u53d1\u9001\u7684\u6d88\u606f");
            return false;
        }
        ArrayList msgSingleDatas = new ArrayList();
        messageInfos.forEach(e -> {
            PushSingleMsgDataVO msgsingleData = new PushSingleMsgDataVO();
            msgsingleData.setActionType("system");
            msgsingleData.setFromAccount(e.getSelfAccount());
            msgsingleData.setToAccount(e.getSingleAccount());
            msgsingleData.setMessage(JsonUtil.convertObject((Object)e.getMessage()));
            msgSingleDatas.add(msgsingleData);
        });
        PushSingleMsgReqVO parameter = new PushSingleMsgReqVO();
        parameter.setBusiCode(param.getBusiCode());
        parameter.setUniqueId(param.getAdmissionId());
        parameter.setMsgData(msgSingleDatas);
        log.info("\u63a8\u9001\u5165\u53c2:{}" + JSON.toJSONString((Object)parameter));
        boolean pushFlag = this.pushSingleIm(parameter);
        if (!pushFlag) {
            log.info("IM INFORM ERROR : im \u8c03\u7528im\u7cfb\u7edf\u63a8\u9001\u5931\u8d25");
            return false;
        }
        return true;
    }

    private boolean pushSingleIm(PushSingleMsgReqVO reqVO) {
        log.info("\u8c03\u7528IM\u7b2c\u4e09\u65b9reqVO:{}" + JSON.toJSONString((Object)reqVO));
        BaseResponse response = this.imPushMsgFeignClient.pushSingleMsg(reqVO);
        log.info("\u53d1\u9001IM\u5355\u4eba\u63a8\u9001:{}", (Object)response.toString());
        return response.isSuccess();
    }

    private boolean pushGroupIm(PushGroupMsgReqVO reqVO) {
        log.info("\u8c03\u7528IM\u7b2c\u4e09\u65b9reqVO:{}" + JSON.toJSONString((Object)reqVO));
        BaseResponse response = this.imPushMsgFeignClient.pushGroupMsg(reqVO);
        log.info("\u53d1\u9001IM\u7fa4\u804a\u63a8\u9001:{}", (Object)response.toString());
        return response.isSuccess();
    }

    private AccountVO newAccount(String appCode, String userId) {
        AccountVO accountVO = new AccountVO();
        accountVO.setAppCode(appCode);
        accountVO.setUserId(userId);
        return accountVO;
    }

    @Async
    public void patientBackSource(String admissionId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        Integer doctorType = admissionInfo.getDoctorType();
        if (null != doctorType) {
            ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
            if (admissionInfo.getServiceType().equals(ServiceTypeEnum.HOS.getValue())) {
                messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u60a8\u7684\u5728\u7ebf\u54a8\u8be2\u5df2\u9000\u6b3e,\u9000\u6b3e\u5c06\u9000\u8fd8\u81f3\u60a8\u7684\u539f\u652f\u4ed8\u8d26\u6237"), IMInformConstants.REFRESH));
                PersonImInformReq parameter = new PersonImInformReq();
                parameter.setMessageInfos(messageInfos);
                parameter.setAdmissionId(admissionId);
                parameter.setBusiCode("zxzx");
                if (this.pushImInform(messageInfos, admissionInfo)) {
                    log.info("IM INFORM COMPLETE \u60a3\u8005\u53d6\u6d88\u9000\u53f7\u6210\u529f\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
                }
            } else if (admissionInfo.getServiceType().equals(ServiceTypeEnum.NOS.getValue())) {
                messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u60a8\u7684\u5728\u7ebf\u590d\u8bca\u5df2\u9000\u6b3e,\u9000\u6b3e\u5c06\u9000\u8fd8\u81f3\u60a8\u7684\u539f\u652f\u4ed8\u8d26\u6237"), IMInformConstants.REFRESH));
                PersonImInformReq parameter = new PersonImInformReq();
                parameter.setMessageInfos(messageInfos);
                parameter.setAdmissionId(admissionId);
                parameter.setBusiCode("zxzx");
                if (this.pushImInform(messageInfos, admissionInfo)) {
                    log.info("IM INFORM COMPLETE \u60a3\u8005\u53d6\u6d88\u9000\u53f7\u6210\u529f\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
                }
            }
        }
    }

    @Async
    public void patientZeroCancel(String admissionId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        Integer doctorType = admissionInfo.getDoctorType();
        if (null != doctorType) {
            ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
            if (admissionInfo.getServiceType().equals(ServiceTypeEnum.HOS.getValue())) {
                messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u60a8\u7684\u5728\u7ebf\u54a8\u8be2\u5df2\u53d6\u6d88\uff01"), IMInformConstants.REFRESH));
                PersonImInformReq parameter = new PersonImInformReq();
                parameter.setMessageInfos(messageInfos);
                parameter.setAdmissionId(admissionId);
                parameter.setBusiCode("zxzx");
                if (this.pushImInform(messageInfos, admissionInfo)) {
                    log.info("IM INFORM COMPLETE \u5728\u7ebf\u54a8\u8be2\u60a3\u8005\u53d6\u6d880\u5143\u9000\u53f7\u6210\u529f\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
                }
            } else if (admissionInfo.getServiceType().equals(ServiceTypeEnum.NOS.getValue())) {
                messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u60a8\u7684\u5728\u7ebf\u590d\u8bca\u5df2\u53d6\u6d88\uff01"), IMInformConstants.REFRESH));
                PersonImInformReq parameter = new PersonImInformReq();
                parameter.setMessageInfos(messageInfos);
                parameter.setAdmissionId(admissionId);
                parameter.setBusiCode("zxzx");
                if (this.pushImInform(messageInfos, admissionInfo)) {
                    log.info("IM INFORM COMPLETE \u5728\u7ebf\u590d\u8bca\u60a3\u8005\u53d6\u6d880\u5143\u9000\u53f7\u6210\u529f\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
                }
            }
        }
    }

    private UserInfoByUserIdRespVO queryDocAccountInfo(String docId) {
        com.doctoruser.api.pojo.vo.FindUserIdListReq findUserIdListReq = new com.doctoruser.api.pojo.vo.FindUserIdListReq();
        FindUserIdReqVO findUserIdReqVO = new FindUserIdReqVO();
        findUserIdReqVO.setReqId(docId);
        findUserIdReqVO.setUserType(Short.valueOf((short)1));
        ArrayList<FindUserIdReqVO> findUserIdReqVOList = new ArrayList<FindUserIdReqVO>(1);
        findUserIdReqVOList.add(findUserIdReqVO);
        findUserIdListReq.setFindUserIdReqVOS(findUserIdReqVOList);
        log.info("findUserIdListReq:{}", (Object)JSON.toJSONString((Object)findUserIdListReq));
        List findUserIdRespVOS = UserRestTemplateUtil.queryUserIdList((com.doctoruser.api.pojo.vo.FindUserIdListReq)findUserIdListReq, (String)this.projProperties.getUserFindUserId());
        log.info("00001\u67e5\u8be2\u7528\u6237Id\u8bf7\u6c42\u5bf9\u8c61:{}", (Object)JSON.toJSONString((Object)findUserIdRespVOS));
        if (null == findUserIdRespVOS) {
            return null;
        }
        com.doctoruser.api.pojo.vo.FindUserIdRespVO findUserIdRespVO = (com.doctoruser.api.pojo.vo.FindUserIdRespVO)findUserIdRespVOS.get(0);
        log.info("000========:{}", (Object)JSON.toJSONString((Object)findUserIdRespVO));
        GetUserInfoByUserIdReqVO getUserInfoByUserIdReqVO = new GetUserInfoByUserIdReqVO();
        getUserInfoByUserIdReqVO.setUserId(findUserIdRespVO.getUserId());
        log.info("0002\u83b7\u53d6\u7528\u6237\u57fa\u7840\u8d44\u6599\u8bf7\u6c42\u5bf9\u8c61\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)getUserInfoByUserIdReqVO));
        UserInfoByUserIdRespVO userInfo = UserRestTemplateUtil.getUserInfo((GetUserInfoByUserIdReqVO)getUserInfoByUserIdReqVO, (String)this.projProperties.getUserInfo());
        log.info("0002\u83b7\u53d6\u7528\u6237\u57fa\u7840\u8d44\u6599\u8bf7\u6c42\u5bf9\u8c61\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)userInfo));
        if (null != userInfo) {
            return userInfo;
        }
        return null;
    }

    public void noReplyInTenMinutes(String admissionId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        Integer doctorType = admissionInfo.getDoctorType();
        String patientName = admissionInfo.getPatientName();
        if (doctorType == null) {
            return;
        }
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        messageInfos.add(this.getInformAllPersonDocParam(admissionInfo, (Object)new Text(patientName + "\u60a3\u8005\u5df2\u7ecf\u7b49\u5f85\u60a8\u7684\u56de\u590d\u8d85\u8fc710\u5206\u949f\uff0c\u8bf7\u60a8\u5c3d\u5feb\u8fdb\u884c\u56de\u590d\u3002")));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admissionId);
        parameter.setBusiCode("zxzx");
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("IM INFORM COMPLETE \u60a3\u800510\u5206\u949f\u672a\u56de\u590d\u6d88\u606f\uff0cadmissionId:{}", (Object)admissionId);
        }
    }

    public void noReplyInTwoHours(String admissionId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        Integer doctorType = admissionInfo.getDoctorType();
        String patientName = admissionInfo.getPatientName();
        if (doctorType == null) {
            return;
        }
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        messageInfos.add(this.getInformAllPersonDocParam(admissionInfo, (Object)new Text(patientName + "\u60a3\u8005\u5df2\u7ecf\u7b49\u5f85\u60a8\u7684\u56de\u590d\u8d85\u8fc7\u4e24\u5c0f\u65f6\uff0c\u8bf7\u60a8\u5c3d\u5feb\u8fdb\u884c\u56de\u590d\u3002")));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admissionId);
        parameter.setBusiCode("zxzx");
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("IM INFORM COMPLETE \u60a3\u80052\u5c0f\u65f6\u672a\u56de\u590d\u6d88\u606f\uff0cadmissionId:{}", (Object)admissionId);
        }
    }

    public void doctorNoResponse(PatientNoResponseReqVo patientNoResponseReqVo) throws AdmissionException {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(patientNoResponseReqVo.getAdmId());
        String patientName = admissionInfo.getPatientName();
        AdmissionEntity admissionEntity = this.admissionMapper.findById(patientNoResponseReqVo.getAdmId());
        if (null == admissionEntity) {
            return;
        }
        if (!AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admissionEntity.getStatus())) {
            log.info("=====\u5c31\u8bca\u72b6\u6001\u4e0d\u662f\u95ee\u8bca\u4e2d\u7684\u72b6\u6001\uff0c\u4e0d\u4f1a\u63a8\u9001IM\u6d88\u606f=====");
            return;
        }
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        PersonImInformReq parameter = new PersonImInformReq();
        if ("1".equals(patientNoResponseReqVo.getType())) {
            messageInfos.add(this.getInformAllPersonDocParam(admissionInfo, (Object)new Text(patientName + "\u60a3\u8005\u5df2\u7ecf\u7b49\u5f85\u60a8\u7684\u56de\u590d\u8d85\u8fc710\u5206\u949f\uff0c\u8bf7\u60a8\u5c3d\u5feb\u8fdb\u884c\u56de\u590d\u3002")));
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(patientNoResponseReqVo.getAdmId());
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u60a3\u800510\u5206\u949f\u672a\u56de\u590d\u6d88\u606f\uff0cadmissionId:{}", (Object)patientNoResponseReqVo.getAdmId());
            }
        } else if ("2".equals(patientNoResponseReqVo.getType())) {
            messageInfos.add(this.getInformAllPersonDocParam(admissionInfo, (Object)new Text(patientName + "\u60a3\u8005\u5df2\u7ecf\u7b49\u5f85\u60a8\u7684\u56de\u590d\u8d85\u8fc7\u4e24\u5c0f\u65f6\uff0c\u8bf7\u60a8\u5c3d\u5feb\u8fdb\u884c\u56de\u590d\u3002")));
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(patientNoResponseReqVo.getAdmId());
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u60a3\u80052\u5c0f\u65f6\u672a\u56de\u590d\u6d88\u606f\uff0cadmissionId:{}", (Object)patientNoResponseReqVo.getAdmId());
            }
        }
    }

    public void patientMedicalRecordTime(String admissionId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String time = simpleDateFormat.format(new Date());
        messageInfos.add(this.getPersonDocParam(admissionInfo, (Object)new Text(time)));
        messageInfos.add(this.getPatientParam(admissionInfo, (Object)new Text(time)));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admissionId);
        parameter.setBusiCode("zxzx");
        log.info("\u65f6\u95f4\u4e3a\uff1a{}" + JSON.toJSONString((Object)parameter.getMessageInfos()));
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("IM INFORM COMPLETE \u75c5\u4f8b\u5361\u7247\u65f6\u95f4\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
        }
    }

    public void doctorMedicalRecord(String admissionId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        if (admissionInfo.getServiceType().equals(ServiceTypeEnum.HOS.getValue())) {
            log.info("\u5728\u7ebf\u54a8\u8be2\u4e0d\u63a8\u9001");
        } else if (admissionInfo.getServiceType().equals(ServiceTypeEnum.NOS.getValue())) {
            messageInfos.add(this.getInformAllPersonDocParam(admissionInfo, (Object)new Text("\u8bf7\u60a8\u63a5\u8bca\u540e\uff0c\u518d\u6b21\u5bf9\u60a3\u8005\u8eab\u4efd\u8fdb\u884c\u786e\u8ba4\uff0c\u786e\u4fdd\u63d0\u4ea4\u75c5\u5386\u8d44\u6599\u4fe1\u606f\u4e0e\u5728\u7ebf\u590d\u8bca\u6c9f\u901a\u4eba\u5458\u662f\u540c\u4e00\u4e2a\u4eba\u3002")));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            log.info("\u63a5\u8bca\u540e\u63a8\u9001\u7ed9\u533b\u751f\uff1a{}" + JSON.toJSONString((Object)parameter.getMessageInfos()));
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u590d\u8bca\u75c5\u4f8b\u65b0\u5efa\u5b8c\u6210\u63a8\u9001\u7ed9\u533b\u751f\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
            }
        }
    }

    public void patientRefund(String admissionId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text("\u60a3\u8005\u5df2\u81ea\u884c\u9000\u6b3e"), IMInformConstants.REFRESH));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admissionId);
        parameter.setBusiCode("zxzx");
        log.info("\u60a3\u8005\u7aef\u63a8\u9001\u7ed9\u533b\u751f\uff1a{}" + JSON.toJSONString((Object)parameter.getMessageInfos()));
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("IM INFORM COMPLETE \u60a3\u8005\u7aef\u9000\u6b3e\u533b\u751f\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
        }
    }

    public void inquiryEndPre(String admissionId) {
        log.info("\u95ee\u8bca\u7ed3\u675f\u524d3\u5206\u949fim\u63a8\u9001", (Object)admissionId);
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        AdmissionEntity admissionEntity = this.admissionMapper.findById(admissionId);
        if (null == admissionEntity) {
            log.info("\u6ca1\u6709\u67e5\u8be2\u5230\u8be5\u8ba2\u5355");
            return;
        }
        if (!AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admissionEntity.getStatus())) {
            log.info("=====\u5c31\u8bca\u72b6\u6001\u4e0d\u662f\u95ee\u8bca\u4e2d\u7684\u72b6\u6001\uff0c\u4e0d\u4f1a\u63a8\u9001IM\u6d88\u606f=====");
            return;
        }
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        PersonImInformReq parameter = new PersonImInformReq();
        String type = null;
        type = admissionEntity.getServType().equals(ServiceTypeEnum.HOS.getValue()) ? "\u54a8\u8be2" : "\u590d\u8bca";
        messageInfos.add(this.getInformAllPersonDocParam(admissionInfo, (Object)new Text("\u672c\u6b21" + type + "\u5373\u5c06\u7ed3\u675f\uff0c\u5982\u9700\u5ef6\u957f" + type + "\u53ef\u901a\u8fc7\u5ef6\u65f6\u529f\u80fd\u8fdb\u884c\u5ef6\u65f6\u64cd\u4f5c")));
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admissionId);
        parameter.setBusiCode("zxzx");
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("IM INFORM COMPLE \u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
        }
    }

    public void referralDoctor(String referralId) {
        DoctorTeamEntity doctorTeamEntity = (DoctorTeamEntity)this.doctorTeamMapper.selectById((Serializable)((Object)referralId));
        if (null == doctorTeamEntity) {
            return;
        }
        log.info("doctorTeamEntity:{}" + doctorTeamEntity.toString());
        AdmissionInfo admissionInfo = this.getAdmissionInfo(doctorTeamEntity.getAdmissionId());
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        if (admissionInfo.getServiceType().equals(ServiceTypeEnum.HOS.getValue())) {
            messageInfos.add(this.getInformAllPersonDocParam(admissionInfo, (Object)new Text("\u60a8\u5df2\u5c06\u8be5\u54a8\u8be2\u8f6c\u8ba9\u7ed9" + doctorTeamEntity.getReferralDoctorName() + "\u533b\u751f\uff0c\u60a8\u7684\u54a8\u8be2\u5df2\u7ed3\u675f\u3002")));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(doctorTeamEntity.getAdmissionId());
            parameter.setBusiCode("zxzx");
            log.info("\u8f6c\u8bca\u540e\u63a8\u9001\u7ed9\u533b\u751f\uff1a{}" + JSON.toJSONString((Object)parameter.getMessageInfos()));
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u54a8\u8be2\u8f6c\u8bca\u5b8c\u6210\u540e\u63a8\u9001\u7ed9\u8f6c\u51fa\u533b\u751f\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)doctorTeamEntity.getAdmissionId());
            }
        } else if (admissionInfo.getServiceType().equals(ServiceTypeEnum.NOS.getValue())) {
            messageInfos.add(this.getInformAllPersonDocParam(admissionInfo, (Object)new Text("\u60a8\u5df2\u5c06\u8be5\u590d\u8bca\u8f6c\u8ba9\u7ed9" + doctorTeamEntity.getReferralDoctorName() + "\u533b\u751f\uff0c\u60a8\u7684\u590d\u8bca\u5df2\u7ed3\u675f\u3002")));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(doctorTeamEntity.getAdmissionId());
            parameter.setBusiCode("zxzx");
            log.info("\u8f6c\u8bca\u540e\u63a8\u9001\u7ed9\u533b\u751f\uff1a{}" + JSON.toJSONString((Object)parameter.getMessageInfos()));
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u590d\u8bca\u8f6c\u8bca\u5b8c\u6210\u540e\u63a8\u9001\u7ed9\u8f6c\u51fa\u533b\u751f\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)doctorTeamEntity.getAdmissionId());
            }
        }
    }

    public void admissionDoctor(String referralId) {
        DoctorTeamEntity doctorTeamEntity = (DoctorTeamEntity)this.doctorTeamMapper.selectById((Serializable)((Object)referralId));
        if (null == doctorTeamEntity) {
            return;
        }
        log.info("doctorTeamEntity:{}" + doctorTeamEntity.toString());
        AdmissionInfo admissionInfo = this.getAdmissionInfo(doctorTeamEntity.getAdmissionIdNew());
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        if (admissionInfo.getServiceType().equals(ServiceTypeEnum.HOS.getValue())) {
            messageInfos.add(this.getInformAllPersonDocParam(admissionInfo, (Object)new Text(doctorTeamEntity.getReferralDoctorName() + "\u533b\u751f\u5df2\u7ecf\u5c06\u54a8\u8be2\u8f6c\u8ba9\u7ed9\u60a8\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\u3002")));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(doctorTeamEntity.getAdmissionId());
            parameter.setBusiCode("zxzx");
            log.info("\u8f6c\u8bca\u540e\u63a8\u9001\u7ed9\u533b\u751f\uff1a{}" + JSON.toJSONString((Object)parameter.getMessageInfos()));
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u54a8\u8be2\u8f6c\u8bca\u5b8c\u6210\u540e\u63a8\u9001\u7ed9\u8f6c\u5165\u533b\u751f\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)doctorTeamEntity.getAdmissionId());
            }
        } else if (admissionInfo.getServiceType().equals(ServiceTypeEnum.NOS.getValue())) {
            messageInfos.add(this.getInformAllPersonDocParam(admissionInfo, (Object)new Text(doctorTeamEntity.getReferralDoctorName() + "\u533b\u751f\u5df2\u7ecf\u5c06\u590d\u8bca\u8f6c\u8ba9\u7ed9\u60a8\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\u3002")));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(doctorTeamEntity.getAdmissionId());
            parameter.setBusiCode("zxzx");
            log.info("\u8f6c\u8bca\u540e\u63a8\u9001\u7ed9\u533b\u751f\uff1a{}" + JSON.toJSONString((Object)parameter.getMessageInfos()));
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5728\u7ebf\u590d\u8bca\u8f6c\u8bca\u5b8c\u6210\u540e\u63a8\u9001\u7ed9\u8f6c\u5165\u533b\u751f\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)doctorTeamEntity.getAdmissionId());
            }
        }
    }

    public void referralCard(String referralId, String admId) {
        log.info("referralId:{}" + referralId);
        log.info("admId:{}" + admId);
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admId);
        log.info("admissionInfo\uff1a{}" + admissionInfo.toString());
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        messageInfos.add(this.getInformCustomPersonDocParam(admissionInfo, (Object)this.getReferralCard(referralId), "card"));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admId);
        parameter.setBusiCode("zxzx");
        log.info("parameter\uff1a{}" + admissionInfo.toString());
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("IM INFORM COMPLETE \u8f6c\u8bca\u5355IM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admId);
        }
    }

    public void doctorReferralCard(String referralId, String admId) {
        log.info("referralId:{}" + referralId);
        log.info("admId:{}" + admId);
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admId);
        log.info("admissionInfo\uff1a{}" + admissionInfo.toString());
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        messageInfos.add(this.getInformCustomPersonDocParam(admissionInfo, (Object)this.getDoctorReferralCard(referralId), "doctorCard"));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admId);
        parameter.setBusiCode("zxzx");
        log.info("parameter\uff1a{}" + admissionInfo.toString());
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("IM INFORM COMPLETE \u533b\u751f\u5361\u7247IM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admId);
        }
    }

    public void doctorReferralCardNew(String referralId, String admId) throws AdmissionException {
        log.info("referralId:{}" + referralId);
        log.info("admId:{}" + admId);
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admId);
        log.info("admissionInfo\uff1a{}" + admissionInfo.toString());
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        messageInfos.add(this.getInformCustomPerPatientParam(admissionInfo, (Object)this.getDoctorReferralCard(referralId), "doctorCard"));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admId);
        parameter.setBusiCode("zxzx");
        log.info("parameter\uff1a{}" + admissionInfo.toString());
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("IM INFORM COMPLETE \u60a3\u8005\u7aef\u533b\u751f\u5361\u7247IM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admId);
        }
    }

    public void referralCardNew(String referralId, String admId) {
        log.info("referralId:{}" + referralId);
        log.info("admId:{}" + admId);
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admId);
        log.info("admissionInfo\uff1a{}" + admissionInfo.toString());
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        messageInfos.add(this.getInformCustomPersonDocParam(admissionInfo, (Object)this.getReferralCardNew(referralId), "card"));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admId);
        parameter.setBusiCode("zxzx");
        log.info("parameter\uff1a{}" + admissionInfo.toString());
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("IM INFORM COMPLETE \u8f6c\u8bca\u5355IM\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admId);
        }
    }

    public void time(String admId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admId);
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        messageInfos.add(this.getPatientParam1(admissionInfo, (Object)new Text("")));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admId);
        parameter.setBusiCode("zxzx");
        log.info("\u65f6\u95f4\u4e3a\uff1a{}" + JSON.toJSONString((Object)parameter.getMessageInfos()));
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("IM INFORM COMPLETE \u8f6c\u8bca\u65f6\u95f4\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admId);
        }
    }

    public void doctorCloseScheduleToPat(String doctorName, String admissionId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        if (ServiceTypeEnum.HOS.getValue().equals(admissionInfo.getServiceType())) {
            messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u5341\u5206\u62b1\u6b49\uff0c\u60a8\u9884\u7ea6\u7684" + doctorName + "\u533b\u751f\u5df2\u505c\u8bca\uff0c\u672c\u6b21\u54a8\u8be2\u5df2\u4e3a\u60a8\u8fdb\u884c\u9000\u6b3e\u5904\u7406\uff0c\u60a8\u53ef\u4ee5\u9009\u62e9\u5176\u4ed6\u95ee\u8bca\u533b\u751f"), IMInformConstants.REFRESH));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u60a3\u8005\u53d6\u6d88\u9000\u53f7\u6210\u529f\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
            }
        } else if (admissionInfo.getServiceType().equals(ServiceTypeEnum.NOS.getValue())) {
            messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u5341\u5206\u62b1\u6b49\uff0c\u60a8\u9884\u7ea6\u7684" + doctorName + "\u533b\u751f\u5df2\u505c\u8bca\uff0c\u672c\u6b21\u590d\u8bca\u5df2\u4e3a\u60a8\u8fdb\u884c\u9000\u6b3e\u5904\u7406\uff0c\u60a8\u53ef\u4ee5\u9009\u62e9\u5176\u4ed6\u95ee\u8bca\u533b\u751f"), IMInformConstants.REFRESH));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u533b\u751f\u505c\u8bca\u7ed9\u60a3\u8005\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
            }
        }
    }

    public void doctorCloseScheduleToDoc(String admissionId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        if (ServiceTypeEnum.HOS.getValue().equals(admissionInfo.getServiceType())) {
            messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text(admissionInfo.getAimName() + "\u533b\u751f\u5df2\u505c\u8bca\uff0c\u5df2\u4e3a\u8be5\u60a3\u8005\u7684\u54a8\u8be2\u8fdb\u884c\u9000\u6b3e\u5904\u7406"), IMInformConstants.REFRESH));
        }
        if (ServiceTypeEnum.NOS.getValue().equals(admissionInfo.getServiceType())) {
            messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text(admissionInfo.getAimName() + "\u533b\u751f\u5df2\u505c\u8bca\uff0c\u5df2\u4e3a\u8be5\u60a3\u8005\u7684\u590d\u8bca\u8fdb\u884c\u9000\u6b3e\u5904\u7406"), IMInformConstants.REFRESH));
        }
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admissionId);
        parameter.setBusiCode("zxzx");
        log.info("\u60a3\u8005\u7aef\u63a8\u9001\u7ed9\u533b\u751f\uff1a{}" + JSON.toJSONString((Object)parameter.getMessageInfos()));
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("IM INFORM COMPLETE \u533b\u751f\u505c\u8bca\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
        }
    }

    public ResultData<Object> treatmentCard(String admissionId) {
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admissionId);
        String redisKey = admissionId + "_FZBL";
        Boolean flag = this.redisTemplateService.addLockNew(redisKey, redisKey, 60L);
        if (flag.booleanValue()) {
            log.info("\u8be5\u60a3\u8005\u5df2\u5f00\u8fc7\u590d\u8bca\u75c5\u5386");
            return new ResultData(true, "\u64cd\u4f5c\u6210\u529f", "-1", (Object)"\u75c5\u5386\u63d0\u4ea4\u8fc7\u9891\u7e41\uff0c\u8bf7\u7a0d\u7b49\u540e\u91cd\u65b0\u63d0\u4ea4");
        }
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        FrontResponse frontResponse = this.updateoutPatientDiagnosis(admissionInfo);
        if (frontResponse.getCode().equals("0")) {
            return new ResultData().error("\u8bca\u65ad\u4fe1\u606f\u540c\u6b65his\u5931\u8d25");
        }
        PatientMedicalRecordEntity patientMedicalRecord = this.patientMedicalRecordMapper.findById(orderEntity.getMedicalRecordId());
        patientMedicalRecord.setXRemark("\u5df2\u63a8\u9001");
        this.patientMedicalRecordMapper.updatePatientMedicalRecord(patientMedicalRecord);
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        messageInfos.add(this.getInformCustomPersonDocParam(admissionInfo, (Object)this.getTreatmentCard(admissionId), "treatmentCard"));
        messageInfos.add(this.getInformCustomPerPatientParam(admissionInfo, (Object)this.getTreatmentCard(admissionId), "treatmentCard"));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admissionId);
        parameter.setBusiCode("zxzx");
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("IM INFORM COMPLETE \u533b\u751f\u5f00\u5177\u590d\u8bca\u75c5\u4f8b\u63a8\u9001\u5361\u7247\uff0cadmissionId:{}", (Object)admissionId);
        }
        return new ResultData().success();
    }

    private FrontResponse<String> updateoutPatientDiagnosis(AdmissionInfo admissionInfo) {
        if (admissionInfo.getServiceType() == 7) {
            return FrontResponse.success((String)"1", (Object)"1");
        }
        try {
            QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
            queryPersonnelInfoReq.setDoctorId(admissionInfo.getDoctorId());
            BaseResponse personnelInfoBaseResponse = this.doctorClient.queryPersonnelInfo(queryPersonnelInfoReq);
            String emplCode = "";
            String deptCode = "";
            if (personnelInfoBaseResponse.isSuccess() && null != personnelInfoBaseResponse.getData()) {
                emplCode = ((PersonnelInfo)personnelInfoBaseResponse.getData()).getEmplCode();
                BaseResponse baseResponse = this.departmentInfoApi.getDepartmentDetail(Long.valueOf(Long.parseLong(((PersonnelInfo)personnelInfoBaseResponse.getData()).getDeptId().toString())));
            }
            log.info("emplCode:{}", (Object)emplCode);
            log.info("deptCode:{}", (Object)deptCode);
            PatientDynamicMedicalEntityVo entityVo = this.internetHospitalDetailInfoService.getMedicalInfoByAdmId(admissionInfo.getAdmissionId());
            String primaryDiagno = entityVo.getPrimaryDiagno();
            String[] array = primaryDiagno.split(";");
            HashSet<String> set = new HashSet<String>(Arrays.asList(array));
            ArrayList<DiagnosisData> diagnosisList = new ArrayList<DiagnosisData>();
            for (String fruit : set) {
                DiagnosisData diagnosisData = new DiagnosisData();
                QueryWrapper queryWrapper = new QueryWrapper();
                ICDEntity entity = new ICDEntity();
                entity.setIcdName(fruit);
                queryWrapper.setEntity((Object)entity);
                ICDEntity icdEntity = (ICDEntity)this.icdMapper.selectOne((Wrapper)queryWrapper);
                diagnosisData.setDiagnosis(fruit);
                diagnosisData.setDiagnosisCode(icdEntity.getIcdCode());
                diagnosisData.setAuthorCode(emplCode);
                diagnosisData.setDeptCode(deptCode);
                diagnosisData.setDiagnosticType("0");
                diagnosisData.setPrimaryDiagnosis("1");
                diagnosisData.setReferral("2");
                diagnosisList.add(diagnosisData);
            }
            FrontRequest param = new FrontRequest();
            DiagnosisInfoReqVo diagnosisInfoReqVo = new DiagnosisInfoReqVo();
            diagnosisInfoReqVo.setPatientNumber(admissionInfo.getPatientNumber());
            diagnosisInfoReqVo.setDiagnosisList(diagnosisList);
            param.setBody((Object)diagnosisInfoReqVo);
            FrontResponse frontResponse = new GateWayCommonUtil().requestHis("/fzOutpatient/updateOutpatientDiagnosis", param, String.class);
            return frontResponse;
        }
        catch (Exception e) {
            return FrontResponse.error((String)"", (String)"0", (String)"\u8bca\u65ad\u4fe1\u606f\u63a8\u9001his\u5f02\u5e38");
        }
    }

    public void tenMinutesBeforeEnd(String admissionId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        if (ServiceTypeEnum.HOS.getValue().equals(admissionInfo.getServiceType())) {
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)admissionInfo.getMedicalOpinion())) {
                log.info("\u533b\u751f\u5df2\u7ecf\u5f00\u5177\u8bca\u7597\u610f\u89c1\u4e0d\u63a8\u9001,\u5c31\u8bcaid\u4e3a\uff1a{}", (Object)admissionInfo.getAdmissionId());
                return;
            }
            messageInfos.add(this.getInformAllPersonDocParam(admissionInfo, (Object)new Text("\u60a8\u4e0e\u60a3\u8005\u7684\u54a8\u8be2\u5373\u5c06\u7ed3\u675f\uff0c\u8bf7\u53ca\u65f6\u4e3a\u60a3\u8005\u5f00\u5177\u8bca\u7597\u610f\u89c1\u3002")));
        }
        if (ServiceTypeEnum.NOS.getValue().equals(admissionInfo.getServiceType())) {
            PatientDynamicMedicalEntityVo entityVo = this.internetHospitalDetailInfoService.getMedicalInfoByAdmId(admissionInfo.getAdmissionId());
            if (null != entityVo) {
                log.info("\u533b\u751f\u5df2\u7ecf\u5f00\u5177\u60a3\u8005\u590d\u8bca\u75c5\u4f8b\u4e0d\u63a8\u9001,\u5c31\u8bcaid\u4e3a:{}", (Object)admissionInfo.getAdmissionId());
                return;
            }
            log.info("entityVo:{}", (Object)JSON.toJSONString((Object)entityVo));
            messageInfos.add(this.getInformAllPersonDocParam(admissionInfo, (Object)new Text("\u60a8\u4e0e\u60a3\u8005\u7684\u590d\u8bca\u5373\u5c06\u7ed3\u675f\uff0c\u8bf7\u53ca\u65f6\u4e3a\u60a3\u8005\u5f00\u5177\u590d\u8bca\u75c5\u5386\u3002")));
        }
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admissionId);
        parameter.setBusiCode("zxzx");
        log.info("\u63a8\u9001\u7ed9\u533b\u751f\uff1a{}" + JSON.toJSONString((Object)parameter.getMessageInfos()));
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("IM INFORM COMPLETE \u63d0\u524d10\u5206\u949f\u672a\u5f00\u5177\u8bca\u7597\u610f\u89c1\u533b\u751f\u63a8\u9001\uff0cadmissionId:{}", (Object)admissionId);
        }
    }

    public void passNumberToPatient(String admissionId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        messageInfos.add(this.getInformPerPatientParam(admissionInfo, (Object)new Text("\u60a8\u5df2\u9519\u8fc7\u533b\u751f\u7684\u5c31\u8bca\u53eb\u53f7,\u9884\u7ea6\u65f6\u95f4\u5185\u53ef\u70b9\u51fb\u4e0b\u65b9\u6309\u94ae\u91cd\u65b0\u9884\u7ea6\u6392\u961f\u3002")));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admissionId);
        parameter.setBusiCode("zxzx");
        log.info("\u533b\u751f\u8fc7\u53f7\u540e\u63a8\u9001\u7ed9\u60a3\u8005\uff1a{}" + JSON.toJSONString((Object)parameter.getMessageInfos()));
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("\u533b\u751f\u8fc7\u53f7\u540e\u63a8\u9001\u7ed9\u60a3\u8005\uff0cadmissionId:{}", (Object)admissionId);
        }
    }

    public void referralToDoctor(String referralId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        DoctorTeamEntity entity = new DoctorTeamEntity();
        entity.setXId(referralId);
        queryWrapper.setEntity((Object)entity);
        DoctorTeamEntity doctorTeamEntity = (DoctorTeamEntity)this.doctorTeamMapper.selectOne((Wrapper)queryWrapper);
        if (null == doctorTeamEntity) {
            return;
        }
        log.info("doctorTeamEntity:{}" + doctorTeamEntity.toString());
        AdmissionInfo admissionInfo = this.getAdmissionInfo(doctorTeamEntity.getAdmissionId());
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        if (admissionInfo.getServiceType().equals(ServiceTypeEnum.HOS.getValue())) {
            messageInfos.add(this.getInformAllPersonDocParam(admissionInfo, (Object)new Text("\u7ba1\u7406\u5458\u5df2\u5c06\u8be5\u54a8\u8be2\u8f6c\u8ba9\u7ed9" + doctorTeamEntity.getReferralDoctorName() + "\u533b\u751f,\u60a8\u7684\u54a8\u8be2\u5df2\u7ed3\u675f\u3002")));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(doctorTeamEntity.getAdmissionId());
            parameter.setBusiCode("zxzx");
            log.info("\u7ba1\u7406\u7aef\u8f6c\u8bca\u540e\u63a8\u9001\u7ed9\u8f6c\u51fa\u533b\u751f\uff1a{}" + JSON.toJSONString((Object)parameter.getMessageInfos()));
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u54a8\u8be2\u7ba1\u7406\u7aef\u8f6c\u8bca\u540e\u63a8\u9001\u7ed9\u8f6c\u51fa\u533b\u751f\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)doctorTeamEntity.getAdmissionId());
            }
        } else if (admissionInfo.getServiceType().equals(ServiceTypeEnum.NOS.getValue())) {
            messageInfos.add(this.getInformAllPersonDocParam(admissionInfo, (Object)new Text("\u7ba1\u7406\u5458\u5df2\u5c06\u8be5\u590d\u8bca\u8f6c\u8ba9\u7ed9" + doctorTeamEntity.getAdmissionDoctorName() + "\u533b\u751f,\u60a8\u7684\u590d\u8bca\u5df2\u7ed3\u675f\u3002")));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(doctorTeamEntity.getAdmissionId());
            parameter.setBusiCode("zxzx");
            log.info("\u7ba1\u7406\u7aef\u8f6c\u8bca\u540e\u63a8\u9001\u7ed9\u8f6c\u51fa\u533b\u751f\uff1a{}" + JSON.toJSONString((Object)parameter.getMessageInfos()));
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u590d\u8bca\u7ba1\u7406\u7aef\u8f6c\u8bca\u540e\u63a8\u9001\u7ed9\u8f6c\u51fa\u533b\u751f\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)doctorTeamEntity.getAdmissionId());
            }
        }
    }

    public void referralToNewDoctor(String admissionId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        if (admissionInfo.getServiceType().equals(ServiceTypeEnum.HOS.getValue())) {
            messageInfos.add(this.getInformAllPersonDocParam(admissionInfo, (Object)new Text("\u7ba1\u7406\u5458\u5df2\u5c06\u8be5\u54a8\u8be2\u8f6c\u8ba9\u7ed9\u60a8\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\u3002")));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            log.info("\u7ba1\u7406\u7aef\u8f6c\u8bca\u540e\u63a8\u9001\u7ed9\u8f6c\u5165\u533b\u751f\uff1a{}" + JSON.toJSONString((Object)parameter.getMessageInfos()));
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u54a8\u8be2\u7ba1\u7406\u7aef\u8f6c\u8bca\u540e\u63a8\u9001\u7ed9\u8f6c\u5165\u533b\u751f\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
            }
        } else if (admissionInfo.getServiceType().equals(ServiceTypeEnum.NOS.getValue())) {
            messageInfos.add(this.getInformAllPersonDocParam(admissionInfo, (Object)new Text("\u7ba1\u7406\u5458\u5df2\u5c06\u8be5\u590d\u8bca\u8f6c\u8ba9\u7ed9\u60a8\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\u3002")));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            log.info("\u7ba1\u7406\u7aef\u8f6c\u8bca\u540e\u63a8\u9001\u7ed9\u8f6c\u5165\u533b\u751f\uff1a{}" + JSON.toJSONString((Object)parameter.getMessageInfos()));
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u590d\u8bca\u7ba1\u7406\u7aef\u8f6c\u8bca\u540e\u63a8\u9001\u7ed9\u8f6c\u5165\u533b\u751f\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
            }
        }
    }

    public void toReferralDoctor(String admissionId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        messageInfos.add(this.getInformCustomPersonDocParam(admissionInfo, (Object)"\u60a8\u597d\uff0c\u53ef\u4ee5\u76f4\u63a5\u5728\u8bca\u7597\u9875\u8fdb\u884c\u54a8\u8be2!", "referralCopy"));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admissionId);
        parameter.setBusiCode("zxzx");
        log.info("\u7ba1\u7406\u7aef\u8f6c\u8bca\u540e\u63a8\u9001\u7ed9\u8f6c\u5165\u533b\u751f\u6587\u68481\uff1a{}" + JSON.toJSONString((Object)parameter.getMessageInfos()));
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("IM INFORM COMPLETE \u54a8\u8be2\u7ba1\u7406\u7aef\u8f6c\u8bca\u540e\u63a8\u9001\u7ed9\u8f6c\u5165\u533b\u751f\u6587\u68481\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
        }
    }

    public void toReferralDoctorTwo(AdmissionEntity admissionEntity, AdmissionEntity admissionEntityNew, DoctorTeamEntity doctorTeamEntity) {
        String servType = null;
        servType = ServiceTypeEnum.NOS.getValue().equals(admissionEntity.getServType()) ? "\u590d\u8bca" : "\u54a8\u8be2";
        String content = "\u60a8\u597d,\u6211\u56e0" + doctorTeamEntity.getReferralReason() + ",\u5df2\u5c06\u60a8\u7684" + servType + "\u7533\u8bf7\u8f6c\u8bca\u7ed9" + admissionEntityNew.getDoctorName() + "\u533b\u751f\u3002";
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionEntity.getXId());
        messageInfos.add(this.getInformCustomPersonDocParam(admissionInfo, (Object)content, "referralCopy"));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admissionEntity.getXId());
        parameter.setBusiCode("zxzx");
        log.info("\u7ba1\u7406\u7aef\u8f6c\u8bca\u540e\u63a8\u9001\u7ed9\u8f6c\u5165\u533b\u751f\u6587\u68482\uff1a{}" + JSON.toJSONString((Object)parameter.getMessageInfos()));
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("IM INFORM COMPLETE \u54a8\u8be2\u7ba1\u7406\u7aef\u8f6c\u8bca\u540e\u63a8\u9001\u7ed9\u8f6c\u5165\u533b\u751f\u6587\u68482\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionEntity.getXId());
        }
    }

    public void toReferralPatient(String admissionId, String admissionNewId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        AdmissionEntity admissionEntityNew = this.admissionMapper.findById(admissionNewId);
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        messageInfos.add(this.getInformCustomPerPatientParam(admissionInfo, (Object)"\u60a8\u597d,\u53ef\u4ee5\u76f4\u63a5\u5728\u8bca\u7597\u9875\u8fdb\u884c\u54a8\u8be2!", "referralCopy"));
        MessageInfo messageInfo = (MessageInfo)messageInfos.get(0);
        Message message = messageInfo.getMessage();
        message.setAdmId(admissionNewId);
        message.setServType(admissionEntityNew.getServType());
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admissionId);
        parameter.setBusiCode("zxzx");
        log.info("\u7ba1\u7406\u7aef\u8f6c\u8bca\u540e\u63a8\u9001\u7ed9\u8f6c\u5165\u533b\u751f\u6587\u68481\uff1a{}" + JSON.toJSONString((Object)parameter.getMessageInfos()));
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("IM INFORM COMPLETE \u54a8\u8be2\u7ba1\u7406\u7aef\u8f6c\u8bca\u540e\u63a8\u9001\u7ed9\u8f6c\u5165\u533b\u751f\u6587\u68481\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionId);
        }
    }

    public void toReferralPatientTwo(AdmissionEntity admissionEntity, AdmissionEntity admissionEntityNew, DoctorTeamEntity doctorTeamEntity) {
        String servType = null;
        servType = ServiceTypeEnum.NOS.getValue().equals(admissionEntity.getServType()) ? "\u590d\u8bca" : "\u54a8\u8be2";
        String content = "\u60a8\u597d,\u6211\u56e0" + doctorTeamEntity.getReferralReason() + ",\u5df2\u5c06\u60a8\u7684" + servType + "\u7533\u8bf7\u8f6c\u8bca\u7ed9" + admissionEntityNew.getDoctorName() + "\u533b\u751f\u3002";
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionEntity.getXId());
        messageInfos.add(this.getInformCustomPerPatientParam(admissionInfo, (Object)content, "referralCopy"));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admissionEntity.getXId());
        parameter.setBusiCode("zxzx");
        log.info("\u7ba1\u7406\u7aef\u8f6c\u8bca\u540e\u63a8\u9001\u7ed9\u8f6c\u5165\u533b\u751f\u6587\u68482\uff1a{}" + JSON.toJSONString((Object)parameter.getMessageInfos()));
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("IM INFORM COMPLETE \u54a8\u8be2\u7ba1\u7406\u7aef\u8f6c\u8bca\u540e\u63a8\u9001\u7ed9\u8f6c\u5165\u533b\u751f\u6587\u68482\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionEntity.getXId());
        }
    }

    public void passNumOutTimeToPat(String admId) {
        log.info("==========\u8fc7\u53f7\u8d85\u8fc7\u5c31\u8bca\u9884\u7ea6\u65f6\u95f4 \u60a3\u8005============");
        String content = "\u56e0\u5f53\u524d\u65f6\u95f4\u5df2\u8d85\u8fc7\u5c31\u8bca\u9884\u7ea6\u65f6\u95f4\uff0c\u8ba2\u5355\u5df2\u81ea\u52a8\u5931\u6548\uff0c\u7cfb\u7edf\u5c06\u81ea\u52a8\u4e3a\u60a8\u9000\u6b3e";
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admId);
        messageInfos.add(this.getInformPerPatientParam(admissionInfo, (Object)new Text(content)));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admId);
        parameter.setBusiCode("zxzx");
        log.info("\u533b\u751f\u8fc7\u53f7\u9884\u7ea6\u7ed3\u675f\u65f6\u95f4\u5230\u60a3\u8005\u672a\u91cd\u65b0\u5019\u8bca\u63a8\u7ed9\u60a3\u8005\uff1a{}" + JSON.toJSONString((Object)parameter.getMessageInfos()));
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("IM INFORM COMPLETE \u533b\u751f\u8fc7\u53f7\u9884\u7ea6\u7ed3\u675f\u65f6\u95f4\u5230\u60a3\u8005\u672a\u91cd\u65b0\u5019\u8bca\u63a8\u7ed9\u60a3\u8005\uff0cadmissionId:{}", (Object)admId);
        }
    }

    public void passNumOutTimeToDoc(AdmissionEntity admissionEntity) {
        log.info("==========\u8fc7\u53f7\u8d85\u8fc7\u5c31\u8bca\u9884\u7ea6\u65f6\u95f4 \u533b\u751f============");
        String content = "\u56e0\u5f53\u524d\u65f6\u95f4\u5df2\u8d85\u8fc7\u5c31\u8bca\u9884\u7ea6\u65f6\u95f4\uff0c\u8ba2\u5355\u5df2\u81ea\u52a8\u5931\u6548\uff0c\u7cfb\u7edf\u5c06\u81ea\u52a8\u4e3a\u60a3\u8005\u9000\u6b3e";
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionEntity.getXId());
        messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text(content), IMInformConstants.REFRESH));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admissionEntity.getXId());
        parameter.setBusiCode("zxzx");
        log.info("\u533b\u751f\u8fc7\u53f7\u9884\u7ea6\u7ed3\u675f\u65f6\u95f4\u5230\u60a3\u8005\u672a\u91cd\u65b0\u5019\u8bca\u63a8\u7ed9\u533b\u751f\uff1a{}" + JSON.toJSONString((Object)parameter.getMessageInfos()));
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("IM INFORM COMPLETE \u533b\u751f\u8fc7\u53f7\u9884\u7ea6\u7ed3\u675f\u65f6\u95f4\u5230\u60a3\u8005\u672a\u91cd\u65b0\u5019\u8bca\u63a8\u7ed9\u533b\u751f\uff0cadmissionId:{}", (Object)admissionEntity.getXId());
        }
    }

    @Async
    public void makeAnAppiontment(String admissionId) {
        log.info("==========\u5019\u8bca\u62a5\u9053============");
        QueryWrapper queryWrapper = new QueryWrapper();
        AdmissionEntity admission = new AdmissionEntity();
        admission.setXId(admissionId);
        queryWrapper.setEntity((Object)admission);
        AdmissionEntity admissioned = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)queryWrapper);
        QueryWrapper queryWrappered = new QueryWrapper();
        OrderEntity order = new OrderEntity();
        order.setXId(admissioned.getOrderId());
        queryWrappered.setEntity((Object)order);
        OrderEntity ordery = (OrderEntity)this.orderMapper.selectOne((Wrapper)queryWrappered);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String time = simpleDateFormat.format(new Date());
        String content = "\u5c31\u8bca\u65f6\u95f4" + DateUtils.dateToString((Date)ordery.getScheduleDate(), (String)FORMAT_PATTERN) + ordery.getScheduleStartTime() + "-" + ordery.getScheduleEndTime() + "\uff0c\u8bf7\u60a8\u5b89\u6392\u597d\u65f6\u95f4\u5728\u672c\u5e73\u53f0\u51c6\u65f6\u5c31\u8bca\uff0c\u4fbf\u4e8e\u533b\u751f\u53ca\u65f6\u63a5\u5165\u4e3a\u60a8\u8bca\u7597";
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        messageInfos.add(this.getPatientParam(admissionInfo, (Object)new Text(time)));
        messageInfos.add(this.getInformCustomPerPatientParam(admissionInfo, (Object)this.getCaseHistory(admissionId), "order"));
        messageInfos.add(this.getInformPerPatientParam(admissionInfo, (Object)new Text(content)));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admissionId);
        parameter.setBusiCode("zxzx");
        log.info("\u5019\u8bca\u62a5\u9053\uff1a{}" + JSON.toJSONString((Object)parameter.getMessageInfos()));
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("\u5019\u8bca\u62a5\u9053\uff0cadmissionId:{}", (Object)admissionId);
        }
    }

    public void doctorImFurthering(String admissionId) {
        log.info("==========\u533b\u751f\u7aefIM\u63a8\u9001--\u590d\u8bca\u8fdb\u884c\u4e2d============");
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        QueryWrapper queryImapper = new QueryWrapper();
        InquiryServiceConfigEntity inquiryServiceConfig = new InquiryServiceConfigEntity();
        inquiryServiceConfig.setDoctorId(admissionInfo.getDoctorId());
        inquiryServiceConfig.setServiceCode(ServiceTypeEnum.getCode((Integer)admissionInfo.getServiceType()));
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admissionInfo.getAdmissionId());
        inquiryServiceConfig.setDeptId(orderEntity.getDeptId());
        queryImapper.setEntity((Object)inquiryServiceConfig);
        InquiryServiceConfigEntity admissioned = (InquiryServiceConfigEntity)this.inquiryServiceConfigMapper.selectOne((Wrapper)queryImapper);
        Integer doctorType = admissionInfo.getDoctorType();
        if (doctorType == null) {
            return;
        }
        log.info("\u4f20\u5165\u7684servType\u4e3a\uff1a{}" + JSON.toJSONString((Object)admissionInfo.getServiceType()));
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        if (admissionInfo.getServiceType().equals(ServiceTypeEnum.HOS.getValue())) {
            messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text("\u672c\u6b21\u54a8\u8be2\u60a8\u53ef\u4e0e\u60a3\u8005\u4ea4\u6d41" + DateUtils.formatTime((int)admissioned.getServTime()) + "\uff0c\u53ef\u56de\u590d\u60a3\u8005\u5171" + admissioned.getNumLimit() + "\u6761\u6d88\u606f\uff0c\u65f6\u9650\u5230\u671f/\u56de\u590d\u6761\u6570\u7528\u5b8c\u8ba2\u5355\u81ea\u52a8\u7ed3\u675f"), IMInformConstants.REFRESH));
            messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u672c\u6b21\u54a8\u8be2\u60a8\u53ef\u4e0e\u533b\u751f\u4ea4\u6d41" + DateUtils.formatTime((int)admissioned.getServTime()) + "\uff0c\u533b\u751f\u53ef\u56de\u590d\u60a8\u5171" + admissioned.getNumLimit() + "\u6761\u6d88\u606f\uff0c\u65f6\u9650\u5230\u671f/\u56de\u590d\u6761\u6570\u7528\u5b8c\u8ba2\u5355\u81ea\u52a8\u7ed3\u675f"), IMInformConstants.REFRESH));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u533b\u751f\u7aef/\u60a3\u8005\u7aefIM\u63a8\u9001--\u590d\u8bca/\u54a8\u8be2\u8fdb\u884c\u4e2d\uff0cadmissionId:{}", (Object)admissionId);
            }
        } else if (admissionInfo.getServiceType().equals(ServiceTypeEnum.NOS.getValue())) {
            messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text("\u672c\u6b21\u590d\u8bca\u60a8\u53ef\u4e0e\u60a3\u8005\u4ea4\u6d41" + DateUtils.formatTime((int)admissioned.getServTime()) + "\uff0c\u65f6\u9650\u5230\u671f\u8ba2\u5355\u81ea\u52a8\u7ed3\u675f"), IMInformConstants.REFRESH));
            messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u672c\u6b21\u590d\u8bca\u60a8\u53ef\u4e0e\u533b\u751f\u4ea4\u6d41" + DateUtils.formatTime((int)admissioned.getServTime()) + "\uff0c\u65f6\u9650\u5230\u671f\u8ba2\u5355\u81ea\u52a8\u7ed3\u675f"), IMInformConstants.REFRESH));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u533b\u751f\u7aef/\u60a3\u8005\u7aefIM\u63a8\u9001--\u590d\u8bca/\u54a8\u8be2\u8fdb\u884c\u4e2d\uff0cadmissionId:{}", (Object)admissionId);
            }
        } else if (admissionInfo.getServiceType().equals(ServiceTypeEnum.BMMZ.getValue())) {
            messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text("\u672c\u6b21\u4fbf\u6c11\u95e8\u8bca\u60a8\u53ef\u4e0e\u60a3\u8005\u4ea4\u6d41" + DateUtils.formatTime((int)admissioned.getServTime()) + "\uff0c\u65f6\u9650\u5230\u671f\u8ba2\u5355\u81ea\u52a8\u7ed3\u675f"), IMInformConstants.REFRESH));
            messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text("\u672c\u6b21\u4fbf\u6c11\u95e8\u8bca\u60a8\u53ef\u4e0e\u533b\u751f\u4ea4\u6d41" + DateUtils.formatTime((int)admissioned.getServTime()) + "\uff0c\u65f6\u9650\u5230\u671f\u8ba2\u5355\u81ea\u52a8\u7ed3\u675f"), IMInformConstants.REFRESH));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u533b\u751f\u7aef/\u60a3\u8005\u7aefIM\u63a8\u9001--\u590d\u8bca/\u54a8\u8be2\u8fdb\u884c\u4e2d\uff0cadmissionId:{}", (Object)admissionId);
            }
        }
    }

    public void recommService(RecommServiceReqVO recommServiceReqVO) {
        String admissionId = recommServiceReqVO.getAdmId();
        log.info("admissionId:{}" + admissionId);
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        log.info("admissionInfo\uff1a{}" + admissionInfo.toString());
        if ("\u5728\u7ebf\u54a8\u8be2".equals(recommServiceReqVO.getServiceType())) {
            recommServiceReqVO.setServiceTypeId("zx");
        } else if ("\u5728\u7ebf\u590d\u8bca".equals(recommServiceReqVO.getServiceType())) {
            recommServiceReqVO.setServiceTypeId("fz");
        } else if ("\u8fdc\u7a0b\u4f1a\u8bca".equals(recommServiceReqVO.getServiceType())) {
            recommServiceReqVO.setServiceTypeId("hz");
        } else if ("\u9884\u7ea6\u6302\u53f7".equals(recommServiceReqVO.getServiceType())) {
            recommServiceReqVO.setServiceTypeId("gh");
        }
        QueryPersonnelInfoReq queryPersonnelInfo = new QueryPersonnelInfoReq();
        queryPersonnelInfo.setDoctorId(recommServiceReqVO.getDoctorId());
        BaseResponse doctorDetailsVO = this.doctorClient.queryPersonnelInfo(queryPersonnelInfo);
        recommServiceReqVO.setFromAccountHeadurl(((PersonnelInfo)doctorDetailsVO.getData()).getPortrait());
        if (DoctorTypeEnum.TEAM.getValue().equals(admissionInfo.getDoctorType()) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)recommServiceReqVO.getSenderDoctorId())) {
            PersonnelInfo senderDoctorInfo = this.getSenderDoctorInfo(recommServiceReqVO.getSenderDoctorId());
            this.pushCardMessageWithDoctorInfo(admissionInfo, (Object)recommServiceReqVO, "recommService", senderDoctorInfo);
        } else {
            ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
            messageInfos.add(this.getInformCustomPerPatientParam(admissionInfo, (Object)recommServiceReqVO, "recommService"));
            messageInfos.add(this.getMedicalOpinionCustomPersonDocParam(admissionInfo, (Object)recommServiceReqVO, "recommService"));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u60a3\u8005\u7aef\u533b\u751f\u670d\u52a1IM\u63a8\u9001\u6210\u529f\uff08\u5355\u804a\uff09\uff0cadmissionId:{}", (Object)admissionId);
            }
        }
    }

    public void recommDoctor(RecommDoctorReqVO recommDoctorReqVO) {
        OrderEntity orderEntity = this.orderMapper.findByAdmId(recommDoctorReqVO.getAdmId());
        DoctorReferralCard doctorReferralCard = new DoctorReferralCard();
        doctorReferralCard.setDeptName(recommDoctorReqVO.getDeptName());
        doctorReferralCard.setOrganId(Integer.valueOf(Integer.parseInt(orderEntity.getOrganId())));
        doctorReferralCard.setOrganName(recommDoctorReqVO.getOrganName());
        doctorReferralCard.setAdmissonDoctorId(recommDoctorReqVO.getDoctorId());
        doctorReferralCard.setAdmissonDoctorName(recommDoctorReqVO.getDoctorName());
        doctorReferralCard.setPortrait(recommDoctorReqVO.getPortrait());
        doctorReferralCard.setTitle(recommDoctorReqVO.getTitleName());
        doctorReferralCard.setDoctorCardName("\u533b\u751f\u540d\u7247");
        String admissionId = recommDoctorReqVO.getAdmId();
        log.info("admissionId:{}" + admissionId);
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        log.info("admissionInfo\uff1a{}" + admissionInfo.toString());
        QueryPersonnelInfoReq queryPersonnelInfo = new QueryPersonnelInfoReq();
        queryPersonnelInfo.setDoctorId(admissionInfo.getDoctorId());
        BaseResponse doctorDetailsVO = this.doctorClient.queryPersonnelInfo(queryPersonnelInfo);
        doctorReferralCard.setReferralDoctorPortrait(((PersonnelInfo)doctorDetailsVO.getData()).getPortrait());
        if (DoctorTypeEnum.TEAM.getValue().equals(admissionInfo.getDoctorType()) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)recommDoctorReqVO.getSenderDoctorId())) {
            PersonnelInfo senderDoctorInfo = this.getSenderDoctorInfo(recommDoctorReqVO.getSenderDoctorId());
            this.pushCardMessageWithDoctorInfo(admissionInfo, (Object)doctorReferralCard, "doctorCard", senderDoctorInfo);
        } else {
            ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
            messageInfos.add(this.getInformCustomPerPatientParam(admissionInfo, (Object)doctorReferralCard, "doctorCard"));
            messageInfos.add(this.getMedicalOpinionCustomPersonDocParam(admissionInfo, (Object)doctorReferralCard, "doctorCard"));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u60a3\u8005\u7aef\u533b\u751f\u5361\u7247IM\u63a8\u9001\u6210\u529f\uff08\u5355\u804a\uff09\uff0cadmissionId:{}", (Object)admissionId);
            }
        }
    }

    public void recommArticle(RecommArticleReqVO recommArticleReqVO) {
        String admissionId = recommArticleReqVO.getAdmId();
        log.info("\u63a8\u8350\u6587\u7ae0 admissionId:{}", (Object)admissionId);
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        log.info("admissionInfo\uff1a{}", (Object)admissionInfo.toString());
        HashMap<String, Object> articleCard = new HashMap<String, Object>();
        articleCard.put("articleId", recommArticleReqVO.getArticleId());
        articleCard.put("articleTitle", recommArticleReqVO.getArticleTitle());
        articleCard.put("articleSummary", recommArticleReqVO.getArticleSummary());
        articleCard.put("articleCover", recommArticleReqVO.getArticleCover());
        articleCard.put("articleUrl", recommArticleReqVO.getArticleUrl());
        articleCard.put("authorName", recommArticleReqVO.getAuthorName());
        articleCard.put("publishTime", recommArticleReqVO.getPublishTime());
        articleCard.put("recommendReason", recommArticleReqVO.getRecommendReason());
        articleCard.put("cardName", "\u6587\u7ae0\u63a8\u8350");
        if (DoctorTypeEnum.TEAM.getValue().equals(admissionInfo.getDoctorType()) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)recommArticleReqVO.getSenderDoctorId())) {
            PersonnelInfo senderDoctorInfo = this.getSenderDoctorInfo(recommArticleReqVO.getSenderDoctorId());
            this.pushCardMessageWithDoctorInfo(admissionInfo, articleCard, "ARTICLE", senderDoctorInfo);
        } else {
            ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
            messageInfos.add(this.getInformCustomPerPatientParam(admissionInfo, articleCard, "ARTICLE"));
            messageInfos.add(this.getMedicalOpinionCustomPersonDocParam(admissionInfo, articleCard, "ARTICLE"));
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionId);
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u60a3\u8005\u7aef\u6587\u7ae0\u63a8\u8350IM\u63a8\u9001\u6210\u529f\uff08\u5355\u804a\uff09\uff0cadmissionId:{}", (Object)admissionId);
            }
        }
    }

    private boolean pushImInform(List<MessageInfo> messageInfos, AdmissionInfo admissionInfo) {
        boolean flag = true;
        if (DoctorTypeEnum.PERSONAL.getValue().equals(admissionInfo.getDoctorType())) {
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionInfo.getAdmissionId());
            parameter.setBusiCode("zxzx");
            flag = this.personImInform(parameter);
        } else if (DoctorTypeEnum.TEAM.getValue().equals(admissionInfo.getDoctorType())) {
            TeamImInformReq parameter = new TeamImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionInfo.getAdmissionId());
            parameter.setBusiCode("zxzx");
            flag = this.teamImInform(parameter);
        }
        return flag;
    }

    public BaseResponse<?> updateImVideoStatus(UpdateImVideoStatusReq param) {
        AdmissionEntity admissionEntity = this.admissionMapper.findByAdmId(param.getAdmId());
        if (admissionEntity == null) {
            return BaseResponse.error((String)"\u672a\u67e5\u5230\u5c31\u8bca\u8bb0\u5f55");
        }
        InquiryImVideoStatus inquiryImVideoStatus = (InquiryImVideoStatus)this.inquiryImVideoStatusMapper.selectOne((Wrapper)new QueryWrapper().lambda().eq(InquiryImVideoStatus::getAdmId, (Object)param.getAdmId()));
        if (inquiryImVideoStatus == null) {
            InquiryImVideoStatus inquiryImVideoStatus1 = new InquiryImVideoStatus();
            inquiryImVideoStatus1.setAdmId(param.getAdmId());
            inquiryImVideoStatus1.setVideoStatus(param.getStatus());
            this.inquiryImVideoStatusMapper.insert((Object)inquiryImVideoStatus1);
        } else {
            inquiryImVideoStatus.setVideoStatus(param.getStatus());
            this.inquiryImVideoStatusMapper.updateById((Object)inquiryImVideoStatus);
        }
        return BaseResponse.success();
    }

    public BaseResponse<InquiryImVideoStatus> queryImVideoStatus(UpdateImVideoStatusReq param) {
        String redisKey = param.getAdmId() + "IMVIDEO";
        InquiryImVideoStatus inquiryImVideoStatus = (InquiryImVideoStatus)this.inquiryImVideoStatusMapper.selectOne((Wrapper)new QueryWrapper().lambda().eq(InquiryImVideoStatus::getAdmId, (Object)param.getAdmId()));
        if (inquiryImVideoStatus == null) {
            InquiryImVideoStatus inquiryImVideoStatus1 = new InquiryImVideoStatus();
            inquiryImVideoStatus1.setAdmId(param.getAdmId());
            inquiryImVideoStatus1.setVideoStatus("0");
            try {
                this.inquiryImVideoStatusMapper.insert((Object)inquiryImVideoStatus1);
            }
            catch (Exception e) {
                return BaseResponse.error((String)"\u60a3\u8005\u6b63\u5728\u901a\u8bdd\u4e2d...\u8bf7\u7b49\u5f8530\u79d2\u91cd\u8bd5");
            }
            Boolean flag = this.redisTemplateService.addLockNew(redisKey, redisKey, 30L);
            return BaseResponse.success((Object)inquiryImVideoStatus1);
        }
        Boolean flag = this.redisTemplateService.addLockNew(redisKey, redisKey, 30L);
        if (flag.booleanValue()) {
            return BaseResponse.error((String)"\u60a3\u8005\u6b63\u5728\u901a\u8bdd\u4e2d...\u8bf7\u7b49\u5f8530\u79d2\u91cd\u8bd5");
        }
        return BaseResponse.success((Object)inquiryImVideoStatus);
    }

    private String getDoctorName(String doctorId) {
        String doctorName = "";
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(doctorId);
        BaseResponse response = this.doctorInfofeignClient.queryPersonnelInfo(queryPersonnelInfoReq);
        log.info("\u83b7\u53d6\u533b\u751f\u4fe1\u606f:{}", (Object)response);
        if (response.isSuccess() && response.getData() != null) {
            doctorName = ((PersonnelInfo)response.getData()).getDoctorName();
        }
        return doctorName;
    }

    public void zkbgIMpushCard(String admId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admId);
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        messageInfos.add(this.getInformCustomPersonDocParam(admissionInfo, (Object)this.getCaseHistory(admId), "order"));
        messageInfos.add(this.getInformCustomPerPatientParam(admissionInfo, (Object)this.getCaseHistory(admId), "order"));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admId);
        parameter.setBusiCode("zxzx");
        log.info("=====messageInfos:{}=====" + JSON.toJSONString((Object)parameter.getMessageInfos()));
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("IM INFORM COMPLETE \u4fdd\u4f9b\u63a8\u9001\u60a3\u8005\u5361\u7247\uff0cadmissionId:{}", (Object)admId);
        }
    }

    public void zkbgIMpush(MedicalAdmissionRefEntity medicalAdmissionRefEntity) {
        String admId = medicalAdmissionRefEntity.getAdmissionId();
        String drugs = medicalAdmissionRefEntity.getDrugs();
        PatientMedicalRecordEntity patientMedicalRecordEntity = this.patientMedicalRecordMapper.findById(medicalAdmissionRefEntity.getMedicalRecordId());
        PatientEntity patientEntity = this.patientMapper.selectById(patientMedicalRecordEntity.getPatientId());
        String visiteMsg = patientMedicalRecordEntity.getVisiteMsg();
        String[] split = visiteMsg.split(",");
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admId);
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("isOfflineRecord", split[0]);
        map.put("isUsedDrug", split[1]);
        map.put("patientSex", Objects.equals(patientEntity.getGender(), 1) ? "\u7537" : "\u5973");
        messageInfos.add(this.getInformCustomPersonDocParam(admissionInfo, map, "bgRecordAndDrug"));
        messageInfos.add(this.getInformCustomPerPatientParam(admissionInfo, map, "bgRecordAndDrug"));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admId);
        parameter.setBusiCode("zxzx");
        log.info("=====messageInfos:{}=====" + JSON.toJSONString((Object)parameter.getMessageInfos()));
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("IM INFORM COMPLETE \u4fdd\u4f9b\u63a8\u9001\u81ea\u52a8\u6d88\u606f\uff0cadmissionId:{}", (Object)admId);
        }
    }

    public void zkbgIMpushDrugCard(String admId, String status) {
        MedicalAdmissionRefEntity medicalAdmissionRefEntity = (MedicalAdmissionRefEntity)this.medicalAdmissionRefMapper.selectOne((Wrapper)new QueryWrapper().lambda().eq(MedicalAdmissionRefEntity::getAdmissionId, (Object)admId));
        String drugs = medicalAdmissionRefEntity.getDrugs();
        List drugReqDtos = JSON.parseArray((String)drugs, DrugReqDto.class);
        Double sum = drugReqDtos.stream().mapToDouble(v -> Double.parseDouble(v.getPrice()) * Double.parseDouble(v.getMedNumber())).sum();
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admId);
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("drugName", ((DrugReqDto)drugReqDtos.get(0)).getDrugName());
        map.put("drugCount", String.valueOf(drugReqDtos.size()));
        map.put("status", status);
        map.put("price", sum.toString());
        map.put("drugPicture", ((DrugReqDto)drugReqDtos.get(0)).getDrugPicture());
        messageInfos.add(this.getInformCustomPerPatientParam(admissionInfo, map, "bgDrug"));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admId);
        parameter.setBusiCode("zxzx");
        log.info("=====messageInfos:{}=====" + JSON.toJSONString((Object)parameter.getMessageInfos()));
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("IM INFORM COMPLETE \u4fdd\u4f9b\u63a8\u9001\u836f\u54c1\u6d88\u606f\uff0cadmissionId:{}", (Object)admId);
        }
    }

    @Async
    public void zkFastBuyPushCard(FastCreateOrderDto dto) {
        ArrayList drugs = new ArrayList();
        dto.getDrugs().forEach(item -> {
            String s = String.format("%s*%s", item.getDrugName(), item.getMedNumber());
            drugs.add(s);
        });
        ZkCaseHistory caseHistory = new ZkCaseHistory();
        caseHistory.setAdmissionId(dto.getAdmId()).setOrderId(dto.getOrderId()).setPatientName(dto.getName()).setPatienrAge(IDCardUtil.getAge((String)dto.getIdCard())).setPatientSex(IDCardUtil.getGender((String)dto.getIdCard())).setDiagnosis(dto.getDiagnosis()).setDrugs(drugs).setDrugKind(String.format("\u5305\u542b\u5171%d\u79cd\u836f\u54c1", drugs.size()));
        AdmissionInfo admissionInfo = this.getAdmissionInfo(dto.getAdmId());
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        messageInfos.add(this.getInformCustomPersonDocParam(admissionInfo, (Object)caseHistory, "zkFbCard"));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(dto.getAdmId());
        parameter.setBusiCode("zxzx");
        log.info("=====messageInfos:{}=====" + JSON.toJSONString((Object)parameter.getMessageInfos()));
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("IM INFORM COMPLETE \u6781\u901f\u8d2d\u836f\u63a8\u9001\u60a3\u8005\u5361\u7247\uff0cadmissionId:{}", (Object)dto.getAdmId());
        }
    }

    @Async
    public void zkFastPreSuccessPat(String admId) {
        log.info("==========\u6781\u901f\u8d2d\u836f\u5f00\u65b9\u6210\u529f\u63a8\u9001============");
        String content = "\u5904\u65b9\u5df2\u5f00\u5177,\u70b9\u51fb\u67e5\u770b";
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admId);
        messageInfos.add(this.getInformRefreshPatientParam(admissionInfo, (Object)new Text(content), IMInformConstants.REFRESH));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admId);
        parameter.setBusiCode("zxzx");
        log.info("\u6781\u901f\u8d2d\u836f\u5f00\u65b9\u6210\u529f\u63a8\u9001\uff1a{}" + JSON.toJSONString((Object)parameter.getMessageInfos()));
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("\u6781\u901f\u8d2d\u836f\u5f00\u65b9\u6210\u529f\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admId);
        }
    }

    @Async
    public void zkFastPreFailDoc(String admId, String reason) {
        log.info("==========\u6781\u901f\u8d2d\u836f\u533b\u751f\u62d2\u7edd============");
        String content = "\u60a8\u5df2\u62d2\u7edd\u672c\u6b21\u5f00\u65b9\u7533\u8bf7,\u62d2\u7edd\u539f\u56e0\u4e3a:" + reason;
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admId);
        messageInfos.add(this.getInformRefreshDocParam(admissionInfo, (Object)new Text(content), IMInformConstants.REFRESH));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admId);
        parameter.setBusiCode("zxzx");
        log.info("\u6781\u901f\u8d2d\u836f\u5f00\u65b9\u6210\u529f\u63a8\u9001\uff1a{}" + JSON.toJSONString((Object)parameter.getMessageInfos()));
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("\u6781\u901f\u8d2d\u836f\u5f00\u65b9\u6210\u529f\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admId);
        }
    }

    public boolean bmAutoSendIm(String admId, String msgContent, String doctorName) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admId);
        ArrayList<PushSingleMsgDataVO> msgSingleDatas = new ArrayList<PushSingleMsgDataVO>();
        PushSingleMsgDataVO dataVO = new PushSingleMsgDataVO();
        dataVO.setActionType("user");
        dataVO.setFromAccount(this.newAccount("EHOS_DOCTOR", admissionInfo.getDoctorUserId()));
        dataVO.setToAccount(this.newAccount("EHOS_PATIENT", admissionInfo.getPatientUserId()));
        String buildMessage = this.buildMessage(msgContent, admissionInfo, doctorName);
        dataVO.setMessage(buildMessage);
        msgSingleDatas.add(dataVO);
        log.info("js-\u8c03\u7528IM\u7b2c\u4e09\u65b9reqVO:{}", (Object)JSON.toJSONString(msgSingleDatas));
        PushSingleMsgReqVO parameter = new PushSingleMsgReqVO();
        parameter.setBusiCode("zxzx");
        parameter.setUniqueId(admissionInfo.getAdmissionId());
        parameter.setMsgData(msgSingleDatas);
        log.info("js-\u8c03\u7528IM\u7b2c\u4e09\u65b9reqVO:{}", (Object)JSON.toJSONString((Object)parameter));
        BaseResponse response = this.imPushMsgFeignClient.pushSingleUserMsg(parameter);
        log.info("js-\u53d1\u9001IM\u5355\u4eba\u63a8\u9001:{}", (Object)JSON.toJSONString((Object)response));
        if (!response.isSuccess()) {
            log.info("JS - IM INFORM ERROR : im \u8c03\u7528im\u7cfb\u7edf\u63a8\u9001\u5931\u8d25");
            return false;
        }
        return true;
    }

    public void rePushCaseCards(String admId) {
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admId);
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        messageInfos.add(this.getInformCustomPersonDocParam(admissionInfo, (Object)this.getCaseHistory(admId), "order"));
        messageInfos.add(this.getInformCustomPerPatientParam(admissionInfo, (Object)this.getCaseHistory(admId), "order"));
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("\u4fbf\u6c11\u95e8\u8bca\u91cd\u65b0\u63a8\u9001\u904d\u5386\u5361\u7247\u6210\u529f\uff0cadmissionId:{}", (Object)admId);
        }
    }

    private String buildMessage(String msgContent, AdmissionInfo admissionInfo, String doctorName) {
        JSONObject message = new JSONObject();
        JSONObject dataJson = new JSONObject();
        dataJson.put("UserAction", (Object)"2000");
        dataJson.put("applicationCode", (Object)"zxzx");
        dataJson.put("appointmentId", (Object)admissionInfo.getAdmissionId());
        dataJson.put("businessCode", (Object)"zxzx");
        dataJson.put("doctorHeadUrl", (Object)"");
        dataJson.put("doctorName", (Object)doctorName);
        dataJson.put("msgType", (Object)"TEXT");
        dataJson.put("senderName", (Object)doctorName);
        dataJson.put("senderProfessional", (Object)"\u4e3b\u4efb\u533b\u5e08");
        dataJson.put("team", (Object)false);
        dataJson.put("teamFlag", (Object)0);
        dataJson.put("msgId", (Object)DateUtils.getSecondTimestamp((Date)DateUtils.getCurrentDate()));
        dataJson.put("toApplicationCode", (Object)"hytdz");
        JSONObject dataJson2 = new JSONObject();
        dataJson2.put("Data", (Object)JSONObject.toJSONString((Object)dataJson));
        message.put("data", (Object)dataJson2);
        message.put("text", (Object)msgContent);
        return JSON.toJSONString((Object)message);
    }

    private String buildCardMessageWithDoctorInfo(Message message, PersonnelInfo doctorInfo) {
        JSONObject finalMessage = new JSONObject();
        finalMessage.put("messageType", (Object)message.getMessageType());
        finalMessage.put("businessCode", (Object)message.getBusinessCode());
        finalMessage.put("admissionId", (Object)message.getAdmissionId());
        finalMessage.put("applicationCode", (Object)message.getApplicationCode());
        finalMessage.put("isRefresh", (Object)message.getIsRefresh());
        finalMessage.put("admId", (Object)message.getAdmId());
        finalMessage.put("servType", (Object)message.getServType());
        finalMessage.put("teamFlag", (Object)message.getTeamFlag());
        finalMessage.put("msgId", (Object)message.getMsgId());
        finalMessage.put("data", message.getData());
        finalMessage.put("medicalOpinion", (Object)message.getMedicalOpinion());
        if (doctorInfo != null) {
            finalMessage.put("doctorHeadUrl", (Object)doctorInfo.getPortrait());
            finalMessage.put("doctorName", (Object)doctorInfo.getDoctorName());
            finalMessage.put("senderProfessional", (Object)doctorInfo.getTitle());
        }
        return JSON.toJSONString((Object)finalMessage);
    }

    private JSONObject buildCardMessageWithDoctorInfoAsJson(Message message, PersonnelInfo doctorInfo) {
        JSONObject finalMessage = new JSONObject();
        finalMessage.put("messageType", (Object)message.getMessageType());
        finalMessage.put("businessCode", (Object)message.getBusinessCode());
        finalMessage.put("admissionId", (Object)message.getAdmissionId());
        finalMessage.put("applicationCode", (Object)message.getApplicationCode());
        finalMessage.put("isRefresh", (Object)message.getIsRefresh());
        finalMessage.put("admId", (Object)message.getAdmId());
        finalMessage.put("servType", (Object)message.getServType());
        finalMessage.put("teamFlag", (Object)message.getTeamFlag());
        finalMessage.put("msgId", (Object)message.getMsgId());
        finalMessage.put("data", message.getData());
        finalMessage.put("medicalOpinion", (Object)message.getMedicalOpinion());
        if (doctorInfo != null) {
            finalMessage.put("doctorHeadUrl", (Object)doctorInfo.getPortrait());
            finalMessage.put("doctorName", (Object)doctorInfo.getDoctorName());
            finalMessage.put("senderProfessional", (Object)doctorInfo.getTitle());
        }
        return finalMessage;
    }

    @Async
    public void doctorInquiryPrompted(String admId, String msg) {
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admId);
        messageInfos.add(this.getDoctorInformRefreshPatientParam(admissionInfo, IMInformConstants.REFRESH));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admId);
        parameter.setBusiCode("zxzx");
        log.info("\u6574\u65b9\u8d2d\u836f\u4e0b\u5355\u533b\u751f\u95ee\u8bca\u63d0\u793a\u8bed\u63a8\u9001\uff1a{}" + JSON.toJSONString((Object)parameter.getMessageInfos()));
        if (this.personUserImInform(parameter, msg, null)) {
            log.info("\u6574\u65b9\u8d2d\u836f\u4e0b\u5355\u63a8\u9001\u533b\u751f\u95ee\u8bca\u63d0\u793a\u8bed\u63a8\u9001\u6210\u529f1\uff0cadmissionId:{}", (Object)admId);
        }
    }

    public ResultData<Object> autoTreatmentCard(String admissionId) {
        String redisKey;
        Boolean flag;
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admissionId);
        if (Objects.equals(DoctorTypeEnum.TEAM.getValue(), orderEntity.getDoctorType()) && (flag = Boolean.valueOf(this.redisTemplateService.addLockNew(redisKey = orderEntity.getXId() + "_FZBL", redisKey, 600L))).booleanValue()) {
            log.info("\u8be5\u60a3\u8005\u5df2\u5f00\u8fc7\u590d\u8bca\u75c5\u5386");
            return new ResultData(true, "\u64cd\u4f5c\u6210\u529f", "-1", (Object)"\u8be5\u60a3\u8005\u5df2\u5f00\u8fc7\u590d\u8bca\u75c5\u5386");
        }
        AdmissionInfo admissionInfo = this.getAdmissionInfo(admissionId);
        PatientDynamicMedicalEntityVo entityVo = this.internetHospitalDetailInfoService.getMedicalInfoByAdmId(admissionId);
        if (null == entityVo) {
            log.info("\u75c5\u4f8b\u8be6\u60c5\u67e5\u8be2\u9519\u8bef,\u67e5\u8be2\u4e3a\u7a7a");
            return null;
        }
        String medicalDetail = entityVo.getMedicalDetail();
        List list = new ArrayList();
        list = this.internetHospitalDetailInfoService.getMedicalUserFills(entityVo.getServType(), medicalDetail, entityVo.getHospitalId(), entityVo.getDeptId());
        log.info("list:{}", (Object)JSON.toJSONString(list));
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        TreatmentCard treatmentCard = new TreatmentCard();
        treatmentCard.setMedicalRecordId(entityVo.getXId());
        treatmentCard.setMedicalUserFills(list);
        log.info("caseHistory:{}", (Object)treatmentCard.toString());
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        messageInfos.add(this.getInformCustomPersonDocParam(admissionInfo, (Object)treatmentCard, "treatmentCard"));
        messageInfos.add(this.getInformCustomPerPatientParam(admissionInfo, (Object)treatmentCard, "treatmentCard"));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admissionId);
        parameter.setBusiCode("zxzx");
        if (this.pushImInform(messageInfos, admissionInfo)) {
            log.info("IM INFORM COMPLETE \u533b\u751f\u5f00\u5177\u590d\u8bca\u75c5\u4f8b\u63a8\u9001\u5361\u7247\uff0cadmissionId:{}", (Object)admissionId);
        }
        return new ResultData().success();
    }

    private boolean personUserImInform(PersonImInformReq param, String content, Long syncFlag) {
        List messageInfos = param.getMessageInfos();
        if (messageInfos == null || messageInfos.isEmpty()) {
            log.error("IM INFORM ERROR : \u6ca1\u6709\u53ef\u53d1\u9001\u7684\u6d88\u606f");
            return false;
        }
        ArrayList msgSingleDatas = new ArrayList();
        messageInfos.forEach(e -> {
            PushSingleMsgDataVO msgsingleData = new PushSingleMsgDataVO();
            msgsingleData.setActionType("user");
            msgsingleData.setFromAccount(e.getSelfAccount());
            msgsingleData.setToAccount(e.getSingleAccount());
            if (Objects.nonNull(syncFlag)) {
                msgsingleData.setSyncFlag(syncFlag);
            }
            msgsingleData.setMessage(content);
            msgSingleDatas.add(msgsingleData);
        });
        PushSingleMsgReqVO parameter = new PushSingleMsgReqVO();
        parameter.setBusiCode(param.getBusiCode());
        parameter.setUniqueId(param.getAdmissionId());
        parameter.setMsgData(msgSingleDatas);
        log.info("\u63a8\u9001\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)parameter));
        boolean pushFlag = this.pushSingleIm(parameter);
        if (!pushFlag) {
            log.info("IM INFORM ERROR : im \u8c03\u7528im\u7cfb\u7edf\u63a8\u9001\u5931\u8d25");
            return false;
        }
        return true;
    }

    private PersonnelInfo getSenderDoctorInfo(String senderDoctorId) {
        try {
            QueryPersonnelInfoReq queryPersonnelInfo = new QueryPersonnelInfoReq();
            queryPersonnelInfo.setDoctorId(senderDoctorId);
            BaseResponse doctorResponse = this.doctorClient.queryPersonnelInfo(queryPersonnelInfo);
            if (doctorResponse.isSuccess() && doctorResponse.getData() != null) {
                PersonnelInfo doctorInfo = (PersonnelInfo)doctorResponse.getData();
                log.info("\u83b7\u53d6\u53d1\u9001\u533b\u751f\u4fe1\u606f\u6210\u529f: doctorId={}, doctorName={}, title={}", new Object[]{senderDoctorId, doctorInfo.getDoctorName(), doctorInfo.getTitle()});
                return doctorInfo;
            }
            log.warn("\u83b7\u53d6\u53d1\u9001\u533b\u751f\u4fe1\u606f\u5931\u8d25: doctorId={}, response={}", (Object)senderDoctorId, (Object)doctorResponse);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u53d1\u9001\u533b\u751f\u4fe1\u606f\u5f02\u5e38: doctorId={}", (Object)senderDoctorId, (Object)e);
        }
        return null;
    }

    private void pushCardMessageWithDoctorInfo(AdmissionInfo admissionInfo, Object content, String businessCode, PersonnelInfo senderDoctorInfo) {
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        MessageInfo patientMessageInfo = this.getInformCustomPerPatientParam(admissionInfo, content, businessCode);
        messageInfos.add(patientMessageInfo);
        MessageInfo doctorMessageInfo = this.getMedicalOpinionCustomPersonDocParam(admissionInfo, content, businessCode);
        messageInfos.add(doctorMessageInfo);
        if (DoctorTypeEnum.TEAM.getValue().equals(admissionInfo.getDoctorType())) {
            this.pushCardMessageWithDoctorInfoForTeam(messageInfos, admissionInfo, senderDoctorInfo);
        } else {
            PersonImInformReq parameter = new PersonImInformReq();
            parameter.setMessageInfos(messageInfos);
            parameter.setAdmissionId(admissionInfo.getAdmissionId());
            parameter.setBusiCode("zxzx");
            if (this.pushImInform(messageInfos, admissionInfo)) {
                log.info("IM INFORM COMPLETE \u5361\u7247\u63a8\u9001\u6210\u529f\uff0cadmissionId:{}", (Object)admissionInfo.getAdmissionId());
            }
        }
    }

    private void pushCardMessageWithDoctorInfoForTeam(List<MessageInfo> messageInfos, AdmissionInfo admissionInfo, PersonnelInfo senderDoctorInfo) {
        if (messageInfos == null || messageInfos.isEmpty()) {
            log.error("IM INFORM ERROR : \u6ca1\u6709\u53ef\u53d1\u9001\u7684\u6d88\u606f");
            return;
        }
        ArrayList msgGroupDatas = new ArrayList();
        messageInfos.forEach(e -> {
            PushGroupMsgDataVO msggroupData = new PushGroupMsgDataVO();
            msggroupData.setActionType("system");
            msggroupData.setFromAccount(e.getSelfAccount());
            msggroupData.setToAccount(e.getReceiveAccounts());
            JSONObject finalMessage = this.buildCardMessageWithDoctorInfoAsJson(e.getMessage(), senderDoctorInfo);
            msggroupData.setMessage(finalMessage.toJSONString());
            msgGroupDatas.add(msggroupData);
        });
        PushGroupMsgReqVO parameter = new PushGroupMsgReqVO();
        parameter.setBusiCode("zxzx");
        parameter.setTreatmentId(admissionInfo.getAdmissionId());
        parameter.setMsgData(msgGroupDatas);
        log.info("\u7fa4\u804a\u63a8\u9001\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)parameter));
        boolean pushFlag = this.pushGroupIm(parameter);
        if (!pushFlag) {
            log.info("IM INFORM ERROR : im \u8c03\u7528im\u7cfb\u7edf\u7fa4\u63a8\u9001\u5931\u8d25");
        } else {
            log.info("IM INFORM COMPLETE \u7fa4\u804a\u5361\u7247\u63a8\u9001\u6210\u529f\uff08\u5e26\u533b\u751f\u4fe1\u606f\uff09\uff0cadmissionId:{}", (Object)admissionInfo.getAdmissionId());
        }
    }

    private <T> MessageInfo getDoctorInformRefreshPatientParam(AdmissionInfo admissionInfo, Integer isRefresh) {
        String patientUserId = admissionInfo.getPatientUserId();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)patientUserId)) {
            log.error("IM INFORM ERROR : \u65e0\u6cd5\u67e5\u8be2\u5230\u63a5\u6536\u4eba\u4fe1\u606f");
            return new MessageInfo();
        }
        MessageInfo messageInfo = new MessageInfo();
        Message message = new Message();
        message.setApplicationCode("zxzx");
        messageInfo.setSingleAccount(this.newAccount("EHOS_PATIENT", patientUserId));
        messageInfo.setSelfAccount(this.newAccount("EHOS_DOCTOR", admissionInfo.getDoctorUserId()));
        messageInfo.setMessage(message);
        return messageInfo;
    }
}

