/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.doctoruser.api.pojo.vo.FindUserIdListReq;
import com.doctoruser.api.pojo.vo.FindUserIdReqVO;
import com.doctoruser.api.pojo.vo.FindUserIdRespVO;
import com.doctoruser.api.pojo.vo.GetUserInfoByUserIdReqVO;
import com.doctoruser.api.pojo.vo.UserInfoByUserIdRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.imforward.client.vo.AccountVO;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.service.ImPushService;
import com.ebaiyihui.onlineoutpatient.core.service.impl.ImChatTemplate;
import com.ebaiyihui.onlineoutpatient.core.utils.UserRestTemplateUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.ArticleVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ImChatMsg;
import com.ebaiyihui.onlineoutpatient.core.vo.ImChatVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ImDoctorVo;
import com.ebaiyihui.onlineoutpatient.core.vo.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImPushServiceImpl
implements ImPushService {
    private static final Logger log = LoggerFactory.getLogger(ImPushServiceImpl.class);
    public static final String PATIENT_CHAT_CODE = "EHOS_PATIENT";
    public static final String MANAGE_CHAT_CODE = "EHOS_DOCTOR";
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private ImChatTemplate imChatTemplate;

    public BaseResponse pushArticle(ImChatMsg<ArticleVo> articleMsg) {
        Map accountMap = this.getAccount(articleMsg.getSessionId(), articleMsg.getType());
        if (accountMap == null) {
            return BaseResponse.error((String)"\u5f53\u524d\u4f1a\u8bdd\u4e0d\u5b58\u5728!");
        }
        List articleList = articleMsg.getModelList();
        ImChatVo imChatVo = new ImChatVo();
        BeanUtils.copyProperties(articleMsg, (Object)imChatVo);
        articleList.stream().forEach(articleVo -> {
            Message message = new Message.MsgBuilder().messageType(Integer.valueOf(2)).businessCode("ARTICLE").admissionId(articleMsg.getSessionId()).data(articleVo).applicationCode("jkgl").build();
            String content = JSON.toJSONString((Object)message);
            imChatVo.setMsgContent(content);
            BaseResponse sendBaseResponse = this.imChatTemplate.pushSingleMsg(imChatVo, (AccountVO)accountMap.get("sender"), (AccountVO)accountMap.get("receiver"));
            BaseResponse receiverBaseResponse = this.imChatTemplate.pushSingleMsg(imChatVo, (AccountVO)accountMap.get("receiver"), (AccountVO)accountMap.get("sender"));
            log.info("\u6587\u7ae0{},\u63a8\u9001\u7ed3\u679c{}", new Object[]{articleVo.getArticleTitle(), sendBaseResponse.getMsg(), receiverBaseResponse.getMsg()});
        });
        return BaseResponse.success((Object)"\u6587\u7ae0\u63a8\u9001\u6210\u529f");
    }

    public BaseResponse pushDoctor(ImChatMsg<ImDoctorVo> doctorMsg) {
        Map accountMap = this.getAccount(doctorMsg.getSessionId(), doctorMsg.getType());
        if (accountMap == null) {
            return BaseResponse.error((String)"\u5f53\u524d\u4f1a\u8bdd\u4e0d\u5b58\u5728!");
        }
        List doctorList = doctorMsg.getModelList();
        ImChatVo imChatVo = new ImChatVo();
        BeanUtils.copyProperties(doctorMsg, (Object)imChatVo);
        doctorList.stream().forEach(doctorVo -> {
            Message message = new Message.MsgBuilder().messageType(Integer.valueOf(2)).businessCode("DOCTOR").admissionId(doctorMsg.getSessionId()).data(doctorVo).applicationCode("jkgl").build();
            String content = JSON.toJSONString((Object)message);
            imChatVo.setMsgContent(content);
            BaseResponse senderBaseResponse = this.imChatTemplate.pushSingleMsg(imChatVo, (AccountVO)accountMap.get("sender"), (AccountVO)accountMap.get("receiver"));
            BaseResponse receiverBaseResponse = this.imChatTemplate.pushSingleMsg(imChatVo, (AccountVO)accountMap.get("receiver"), (AccountVO)accountMap.get("sender"));
            log.info("\u533b\u751f{},\u63a8\u9001\u7ed3\u679c{}", new Object[]{doctorVo.getDoctorName(), senderBaseResponse.getMsg(), receiverBaseResponse.getMsg()});
        });
        return BaseResponse.success((Object)"\u63a8\u9001\u6210\u529f");
    }

    private Map<String, AccountVO> getAccount(String sessionId, Integer type) {
        OrderEntity orderEntity = this.orderMapper.findByAdmId(sessionId);
        UserInfoByUserIdRespVO userIdRespVO = this.queryDocAccountInfo(orderEntity.getDoctorId());
        HashMap<String, AccountVO> groupAccount = new HashMap<String, AccountVO>();
        AccountVO sender = new AccountVO();
        AccountVO receiver = new AccountVO();
        if (type == 1) {
            sender.setAppCode(PATIENT_CHAT_CODE);
            sender.setUserId(orderEntity.getPatientUserId());
            receiver.setAppCode(MANAGE_CHAT_CODE);
            receiver.setUserId(userIdRespVO.getUserId());
        } else {
            sender.setAppCode(MANAGE_CHAT_CODE);
            sender.setUserId(userIdRespVO.getUserId());
            receiver.setAppCode(PATIENT_CHAT_CODE);
            receiver.setUserId(orderEntity.getPatientUserId());
        }
        groupAccount.put("sender", sender);
        groupAccount.put("receiver", receiver);
        return groupAccount;
    }

    private UserInfoByUserIdRespVO queryDocAccountInfo(String docId) {
        FindUserIdListReq findUserIdListReq = new FindUserIdListReq();
        FindUserIdReqVO findUserIdReqVO = new FindUserIdReqVO();
        findUserIdReqVO.setReqId(docId);
        findUserIdReqVO.setUserType(Short.valueOf((short)1));
        ArrayList<FindUserIdReqVO> findUserIdReqVOList = new ArrayList<FindUserIdReqVO>(1);
        findUserIdReqVOList.add(findUserIdReqVO);
        findUserIdListReq.setFindUserIdReqVOS(findUserIdReqVOList);
        log.info("findUserIdListReq:{}", (Object)JSON.toJSONString((Object)findUserIdListReq));
        List findUserIdRespVOS = UserRestTemplateUtil.queryUserIdList((FindUserIdListReq)findUserIdListReq, (String)this.projProperties.getUserFindUserId());
        log.info("00001\u67e5\u8be2\u7528\u6237Id\u8bf7\u6c42\u5bf9\u8c61:{}", (Object)JSON.toJSONString((Object)findUserIdRespVOS));
        if (null == findUserIdRespVOS) {
            return null;
        }
        FindUserIdRespVO findUserIdRespVO = (FindUserIdRespVO)findUserIdRespVOS.get(0);
        log.info("000========:{}", (Object)JSON.toJSONString((Object)findUserIdRespVO));
        GetUserInfoByUserIdReqVO getUserInfoByUserIdReqVO = new GetUserInfoByUserIdReqVO();
        getUserInfoByUserIdReqVO.setUserId(findUserIdRespVO.getUserId());
        log.info("0002\u83b7\u53d6\u7528\u6237\u57fa\u7840\u8d44\u6599\u8bf7\u6c42\u5bf9\u8c61\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)getUserInfoByUserIdReqVO));
        UserInfoByUserIdRespVO userInfo = UserRestTemplateUtil.getUserInfo((GetUserInfoByUserIdReqVO)getUserInfoByUserIdReqVO, (String)this.projProperties.getUserInfo());
        log.info("0002\u83b7\u53d6\u7528\u6237\u57fa\u7840\u8d44\u6599\u8bf7\u6c42\u5bf9\u8c61\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)userInfo));
        if (null != userInfo) {
            return userInfo;
        }
        return null;
    }
}

