/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctor.basedata.api.DepartmentInfoApi;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.fz.DiagnosisInfoReqVo;
import com.ebaiyihui.his.pojo.vo.fz.DoCancelRegisterReqVo;
import com.ebaiyihui.his.pojo.vo.fz.PatientVisitReqVo;
import com.ebaiyihui.his.pojo.vo.fz.body.DiagnosisData;
import com.ebaiyihui.onlineoutpatient.common.dto.manager.MangerRefundReq;
import com.ebaiyihui.onlineoutpatient.common.util.ResultData;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.OrderStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ICDMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.InquiryMchCodeMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMedicalRecordMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ScheduleRecordMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ICDEntity;
import com.ebaiyihui.onlineoutpatient.core.model.InquiryMchCodeEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientMedicalRecordEntity;
import com.ebaiyihui.onlineoutpatient.core.sender.AliMedicalInformationSender;
import com.ebaiyihui.onlineoutpatient.core.service.HisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.service.IMInformService;
import com.ebaiyihui.onlineoutpatient.core.service.ManagerAdvisoryService;
import com.ebaiyihui.onlineoutpatient.core.service.PayCallBackService;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorInfofeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.remotecall.InternetHospitalDetailInfoService;
import com.ebaiyihui.onlineoutpatient.core.utils.gateway.GateWayCommonUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorMessageEventsVo;
import com.ebaiyihui.onlineoutpatient.core.vo.RequestRefundVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalEntityVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ManagerAdvisoryServiceImpl
implements ManagerAdvisoryService {
    private static final Logger log = LoggerFactory.getLogger(ManagerAdvisoryServiceImpl.class);
    @Autowired
    private ICDMapper icdMapper;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private PayCallBackService payCallBackService;
    @Autowired
    private IMInformService imInformService;
    @Autowired
    private InquiryMchCodeMapper inquiryMchCodeMapper;
    @Autowired
    private HisTemplateService hisTemplateService;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    AliMedicalInformationSender aliMedicalInformationSender;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private PatientMedicalRecordMapper patientMedicalRecordMapper;
    @Autowired
    private InternetHospitalDetailInfoService internetHospitalDetailInfoService;
    @Autowired
    private DoctorInfofeignClient doctorCilent;
    @Autowired
    private DepartmentInfoApi departmentInfoApi;

    public ResultData<Object> managerRefund(MangerRefundReq param) {
        ResultData result = new ResultData();
        AdmissionEntity admissionEntity = this.admissionMapper.findById(param.getAdmissionId());
        if (admissionEntity == null) {
            return result.error("\u5c31\u8bca\u4fe1\u606f\u4e3a\u7a7a");
        }
        log.info("admissionEntity:{}" + JSON.toJSONString((Object)admissionEntity));
        OrderEntity order = this.orderMapper.findById(admissionEntity.getOrderId());
        if (order == null) {
            return result.error("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        log.info("order:{}" + JSON.toJSONString((Object)order));
        QueryWrapper wrapper = new QueryWrapper();
        InquiryMchCodeEntity inquiryMchCodeEntity = new InquiryMchCodeEntity();
        inquiryMchCodeEntity.setAppCode(order.getAppCode());
        inquiryMchCodeEntity.setHospitalId(order.getHospitalId());
        log.info("inquiryMchCodeEntity:{}" + inquiryMchCodeEntity.toString());
        wrapper.setEntity((Object)inquiryMchCodeEntity);
        InquiryMchCodeEntity entity = (InquiryMchCodeEntity)this.inquiryMchCodeMapper.selectOne((Wrapper)wrapper);
        if (null == entity) {
            log.info("\u6ca1\u6709\u914d\u7f6e\u5546\u6237\u53f7\u6216his");
        }
        if (0 == order.getPayAmount().compareTo(new BigDecimal(0.0))) {
            this.orderMapper.updateStatusById(admissionEntity.getOrderId(), OrderStatusEnum.EXPIRED.getValue());
        } else {
            if (admissionEntity.getServType() == 3) {
                List<Integer> statusList = Arrays.asList(2, 7, 8, 9);
                boolean canRefund = statusList.stream().anyMatch(s -> s.equals(admissionEntity.getStatus()));
                if (canRefund) {
                    BaseResponse diagnosisList;
                    PatientMedicalRecordEntity patientMedicalRecord = this.patientMedicalRecordMapper.findById(admissionEntity.getMedicalRecordId());
                    if ("\u5df2\u63a8\u9001".equals(patientMedicalRecord.getXRemark())) {
                        PatientDynamicMedicalEntityVo entityVo = this.internetHospitalDetailInfoService.getMedicalInfoByAdmId(admissionEntity.getXId());
                        String primaryDiagno = entityVo.getPrimaryDiagno();
                        String[] array = primaryDiagno.split(";");
                        HashSet<String> set = new HashSet<String>(Arrays.asList(array));
                        diagnosisList = new ArrayList();
                        for (String fruit : set) {
                            DiagnosisData diagnosisData = new DiagnosisData();
                            QueryWrapper queryWrapper = new QueryWrapper();
                            ICDEntity icdEntity = new ICDEntity();
                            icdEntity.setIcdName(fruit);
                            queryWrapper.setEntity((Object)icdEntity);
                            ICDEntity icdEntity1 = (ICDEntity)this.icdMapper.selectOne((Wrapper)queryWrapper);
                            diagnosisData.setDiagnosisCode(icdEntity1.getIcdCode());
                            diagnosisData.setDiagnosticType("0");
                            diagnosisList.add(diagnosisData);
                        }
                        FrontRequest diagnosisInfoReqVoFrontRequest = new FrontRequest();
                        DiagnosisInfoReqVo diagnosisInfoReqVo = new DiagnosisInfoReqVo();
                        diagnosisInfoReqVo.setPatientNumber(admissionEntity.getPatientNumber());
                        diagnosisInfoReqVo.setDiagnosisList((List)diagnosisList);
                        diagnosisInfoReqVoFrontRequest.setBody((Object)diagnosisInfoReqVo);
                        FrontResponse frontResponse = new GateWayCommonUtil().requestHis("/fzOutpatient/deleteOutpatientDiagnosis", diagnosisInfoReqVoFrontRequest, String.class);
                        if (frontResponse.getCode().equals("0")) {
                            return new ResultData().error("\u5220\u9664\u8bca\u65ad\u4fe1\u606f\u540c\u6b65his\u5931\u8d25");
                        }
                    }
                    QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
                    queryPersonnelInfoReq.setDoctorId(admissionEntity.getDoctorId());
                    BaseResponse personnelInfoBaseResponse = this.doctorCilent.queryPersonnelInfo(queryPersonnelInfoReq);
                    String emplCode = "";
                    String deptCode = "";
                    if (personnelInfoBaseResponse.isSuccess() && null != personnelInfoBaseResponse.getData()) {
                        emplCode = ((PersonnelInfo)personnelInfoBaseResponse.getData()).getEmplCode();
                        diagnosisList = this.departmentInfoApi.getDepartmentDetail(Long.valueOf(Long.parseLong(((PersonnelInfo)personnelInfoBaseResponse.getData()).getDeptId().toString())));
                    }
                    log.info("emplCode:{}", (Object)emplCode);
                    log.info("deptCode:{}", (Object)deptCode);
                    PatientEntity patient = this.patientMapper.selectById(admissionEntity.getPatientId());
                    FrontRequest frontRequest = new FrontRequest();
                    PatientVisitReqVo patientVisitReqVo = new PatientVisitReqVo();
                    patientVisitReqVo.setDoctorCode(emplCode);
                    patientVisitReqVo.setDeptCode(deptCode);
                    patientVisitReqVo.setStatus("1");
                    patientVisitReqVo.setPatientName(patient.getPatientName());
                    patientVisitReqVo.setPatientNumber(admissionEntity.getPatientNumber());
                    frontRequest.setBody((Object)patientVisitReqVo);
                    FrontResponse cancelFronResponse = new GateWayCommonUtil().requestHis("/fzOutpatient/doOutpatientService", frontRequest, String.class);
                    log.info("\u63a5\u8bca\u8fd4\u56de\u503c frontResponse{}", (Object)JSON.toJSONString((Object)cancelFronResponse));
                    if (cancelFronResponse.getCode().equals("0")) {
                        if (cancelFronResponse.getMessage().contains("\u8be5\u60a3\u8005\u5df2\u7ecf\u4ea7\u751f\u4e86\u5c31\u8bca\u6570\u636e")) {
                            return new ResultData().error("\u9000\u53f7\u5931\u8d25,\u8be5\u60a3\u8005\u5df2\u7ecf\u4ea7\u751f\u4e86\u533b\u5631");
                        }
                        return new ResultData().error("\u9000\u53f7\u5931\u8d25");
                    }
                }
                FrontRequest hisParam = new FrontRequest();
                DoCancelRegisterReqVo doCancelRegisterReqVo = new DoCancelRegisterReqVo();
                doCancelRegisterReqVo.setIsRefund("0");
                doCancelRegisterReqVo.setPatientNumber(admissionEntity.getPatientNumber());
                hisParam.setBody((Object)doCancelRegisterReqVo);
                FrontResponse frontResponse = new GateWayCommonUtil().requestHis("/fzOutpatient/doCancelRegister", hisParam, String.class);
                if (frontResponse.getCode().equals("0")) {
                    return result.error("\u9000\u53f7\u4fe1\u606f\u540c\u6b65his\u5931\u8d25");
                }
            }
            RequestRefundVo requestRefundVo = new RequestRefundVo();
            requestRefundVo.setOrderId(order.getXId());
            BaseResponse baseResponse = this.payCallBackService.refundCalls(requestRefundVo);
        }
        if (Objects.equals(admissionEntity.getStatus(), AdmissionStatusEnum.WAIT_ADMISSION.getValue())) {
            admissionEntity.setStatus(AdmissionStatusEnum.ADMIN_REFUNDED_ADMISSION.getValue());
        } else {
            admissionEntity.setStatus(AdmissionStatusEnum.ADMIN_REFUNDED.getValue());
        }
        admissionEntity.setXRemark(param.getReason());
        this.admissionMapper.update(admissionEntity);
        if (StringUtils.isNotEmpty((String)order.getScheduleId())) {
            log.info("\u9884\u7ea6\u8ba2\u5355\u589e\u52a0\u6392\u73ed:{}", (Object)order.getScheduleId());
            this.scheduleRecordMapper.addAvailableCount(Long.valueOf(Long.parseLong(order.getScheduleId())));
        }
        if (null != param.getIsRefund() && param.getIsRefund().equals(1)) {
            log.info("\u7ba1\u7406\u7aef\u9000\u6b3e");
            this.imInformService.managerRefund(admissionEntity.getXId());
        } else {
            log.info("\u7533\u8bc9\u9000\u6b3e");
            this.imInformService.doctorRefundAppeal(admissionEntity.getXId(), admissionEntity.getDoctorId());
        }
        this.aliMedicalInformationSender.sendOrderInformationData(new DoctorMessageEventsVo(order.getXId()));
        return result.success((Object)"\u9000\u6b3e\u6210\u529f");
    }

    private int differentDays(Date startDate, Date endDate) {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(startDate);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(endDate);
        int startDay = startCalendar.get(6);
        int endDay = endCalendar.get(6);
        int startYear = startCalendar.get(1);
        int endYear = endCalendar.get(1);
        if (startYear != endYear) {
            int timeDistance = 0;
            for (int i = startYear; i < endYear; ++i) {
                if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                    timeDistance += 366;
                    continue;
                }
                timeDistance += 365;
            }
            return timeDistance + (endDay - startDay);
        }
        return endDay - startDay;
    }
}

