/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.ebaiyihui.onlineoutpatient.core.dao.PatientMedicalPictureMapper;
import com.ebaiyihui.onlineoutpatient.core.model.PatientMedicalPictureEntity;
import com.ebaiyihui.onlineoutpatient.core.service.PatientMedicalPictureService;
import com.ebaiyihui.onlineoutpatient.core.utils.id.UUIDUtil;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PatientMedicalPictureServiceImpl
implements PatientMedicalPictureService {
    private static final Logger log = LoggerFactory.getLogger(PatientMedicalPictureServiceImpl.class);
    @Autowired
    private PatientMedicalPictureMapper patientMedicalPictureMapper;

    public boolean insertPatientMedicalPicture(List<String> urls, String recordId) {
        if (!Optional.ofNullable(recordId).isPresent() || StringUtils.isBlank((String)recordId)) {
            return false;
        }
        List pictures = urls.stream().map(url -> new PatientMedicalPictureEntity(recordId, url)).collect(Collectors.toList());
        for (PatientMedicalPictureEntity xid : pictures) {
            xid.setXId(UUIDUtil.getUUID());
            xid.setXCreateTime(new Date());
            xid.setXUpdateTime(new Date());
            xid.setXVersion(Long.valueOf(0L));
        }
        Integer result = this.patientMedicalPictureMapper.insertList(pictures);
        return result >= 1;
    }

    public boolean updatePatientMedicalPicture(List<String> urls, String xId) {
        Integer i = this.patientMedicalPictureMapper.deleteRecordPictures(xId);
        log.info("\u5220\u9664\u56fe\u7247\u8bb0\u5f55\u6570:{}", (Object)i);
        return this.insertPatientMedicalPicture(urls, xId);
    }
}

