/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.card.client.PatientServiceClient;
import com.ebaiyihui.card.common.vo.PatientInfoReqVO;
import com.ebaiyihui.card.common.vo.PatientInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.bo.patient.PatientCheckRequestBo;
import com.ebaiyihui.onlineoutpatient.common.dto.patient.FindOneByPatientIdDTO;
import com.ebaiyihui.onlineoutpatient.common.util.ResultData;
import com.ebaiyihui.onlineoutpatient.core.common.constants.CommonConstants;
import com.ebaiyihui.onlineoutpatient.core.common.enums.CardTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.GenderEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.WhetherEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.InquiryMchCodeMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.model.InquiryMchCodeEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.service.HisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.service.PatientService;
import com.ebaiyihui.onlineoutpatient.core.service.impl.PatientServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.utils.IDCardUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.CardVerificationAndInfoReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.hisreqandresvo.CardVerificationAndInfoResVo;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PatientServiceImpl
implements PatientService {
    private static final Logger log = LoggerFactory.getLogger(PatientServiceImpl.class);
    @Resource
    private PatientMapper patientMapper;
    @Resource
    private PatientServiceClient patientServiceFeignClient;
    @Autowired
    private HisTemplateService hisTemplateService;
    @Autowired
    private InquiryMchCodeMapper inquiryMchCodeMapper;

    private IdCardValue getIdCardValue(String idCardNo) {
        if (StringUtils.isBlank((String)idCardNo)) {
            return null;
        }
        String birthday = null;
        Integer gender = null;
        char[] number = idCardNo.toCharArray();
        boolean flag = true;
        int oldLength = 15;
        int newLength = 18;
        if (number.length == oldLength) {
            for (int x = 0; x < number.length; ++x) {
                if (!flag) {
                    return null;
                }
                flag = Character.isDigit(number[x]);
            }
        } else if (number.length == newLength) {
            for (int x = 0; x < number.length - 1; ++x) {
                if (!flag) {
                    return null;
                }
                flag = Character.isDigit(number[x]);
            }
        }
        if (flag && idCardNo.length() == oldLength) {
            birthday = "19" + idCardNo.substring(6, 8) + "-" + idCardNo.substring(8, 10) + "-" + idCardNo.substring(10, 12);
            gender = Integer.parseInt(idCardNo.substring(idCardNo.length() - 3, idCardNo.length())) % 2 == 0 ? GenderEnum.FEMALE.getValue() : GenderEnum.MALE.getValue();
        } else if (flag && idCardNo.length() == newLength) {
            birthday = idCardNo.substring(6, 10) + "-" + idCardNo.substring(10, 12) + "-" + idCardNo.substring(12, 14);
            gender = Integer.parseInt(idCardNo.substring(idCardNo.length() - 4, idCardNo.length() - 1)) % 2 == 0 ? GenderEnum.FEMALE.getValue() : GenderEnum.MALE.getValue();
        }
        return new IdCardValue(this, birthday, gender);
    }

    public BaseResponse<String> checkPatient(PatientCheckRequestBo patientCheckRequestBo) {
        BaseResponse response = this.getPatientInfo(patientCheckRequestBo);
        if (!response.isSuccess()) {
            return BaseResponse.error((String)"\u83b7\u53d6\u60a3\u8005\u5e10\u53f7\u5931\u8d25");
        }
        PatientInfoRespVO patientInfoRespVO = (PatientInfoRespVO)response.getData();
        PatientEntity patientEntity = this.patientMapper.findOneByPatientId(patientCheckRequestBo.getPatientId());
        log.info("\u786e\u8ba4\u5c31\u8bca\u5361\u540e\u505a\u8d44\u683c\u786e\u8ba4patientEntity: {}", (Object)JSON.toJSONString((Object)patientEntity));
        String bitrh = IDCardUtil.getBirthByIdCard((String)patientCheckRequestBo.getIdCard());
        String gender = IDCardUtil.getGender((String)patientCheckRequestBo.getIdCard());
        log.info("\u751f\u65e5:" + bitrh + ",\u6027\u522b:" + gender);
        InquiryMchCodeEntity entity = this.getInquiryMchCodeEntity(patientCheckRequestBo.getAppCode(), patientCheckRequestBo.getOrganId());
        if (null == entity) {
            log.info("\u6ca1\u6709\u914d\u7f6e\u5546\u6237\u53f7\u6216his");
        }
        CardVerificationAndInfoResVo medicareCardInfo = null;
        if (patientCheckRequestBo.getServType().equals(ServiceTypeEnum.NOS.getValue()) && null != entity && StringUtils.isNotEmpty((String)entity.getHisUrl()) && "HYT".equals(entity.getAppCode())) {
            medicareCardInfo = this.HYTMedicareCardInfo(patientCheckRequestBo, bitrh, gender, entity, medicareCardInfo);
        }
        if (null == patientEntity) {
            patientEntity = this.patientInfo(patientCheckRequestBo, medicareCardInfo, patientInfoRespVO);
            patientEntity.setUserId(patientCheckRequestBo.getUserId());
            patientEntity.setBirthDates(bitrh);
            log.info("\u786e\u8ba4\u5c31\u8bca\u5361\u540e\u505a\u8d44\u683c\u786e\u8ba4patientEntity\u6dfb\u52a0\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)patientEntity));
            this.patientMapper.insert(patientEntity);
        } else {
            PatientEntity patient = new PatientEntity();
            patient.setXId(patientCheckRequestBo.getPatientId());
            patient.setAccountPhone(patientCheckRequestBo.getUserPhone());
            patient.setCardNo(patientCheckRequestBo.getCardNo());
            patient.setTelphone(patientInfoRespVO.getContactMobile());
            patient.setCredTypeCode(patientInfoRespVO.getCredTypeCode());
            patient.setIdcard(patientInfoRespVO.getCredNo());
            patient.setXUpdateTime(new Date());
            patient.setIsMedicare(patientCheckRequestBo.getIsMedicare());
            patient.setBirthDates(bitrh);
            patient.setUserId(patientCheckRequestBo.getUserId());
            if (patientCheckRequestBo.getServType().equals(ServiceTypeEnum.NOS.getValue()) && null != entity && StringUtils.isNotEmpty((String)entity.getHisUrl()) && StringUtils.isEmpty((String)patientEntity.getFundType()) && "HYT".equals(patientCheckRequestBo.getAppCode())) {
                patient.setFundType("0");
            }
            if (null != medicareCardInfo) {
                log.info("==============\u5b58\u5728\u8fdb\u5165================");
                patient.setMedicalNO(medicareCardInfo.getCardNO());
                patient.setFundType(medicareCardInfo.getFundType());
                patient.setPactCode(medicareCardInfo.getPactCode());
                patient.setPactName(medicareCardInfo.getPactName());
                patient.setAddress(medicareCardInfo.getAddress());
            }
            log.info("\u66f4\u65b0\u5165\u53c2:" + patient.toString());
            this.patientMapper.update(patient);
            log.info("\u66f4\u65b0\u51fa\u53c2:" + patient.toString());
        }
        return BaseResponse.success();
    }

    private PatientEntity patientInfo(PatientCheckRequestBo patientCheckRequestBO, CardVerificationAndInfoResVo medicareCardInfo, PatientInfoRespVO patientInfoRespVO) {
        PatientEntity patientEntity = new PatientEntity();
        patientEntity.setXId(patientCheckRequestBO.getPatientId());
        patientEntity.setAccountPhone(patientCheckRequestBO.getUserPhone());
        patientEntity.setPatientType(CommonConstants.PATIENT_TYPE);
        patientEntity.setUserId(patientCheckRequestBO.getUserId());
        patientEntity.setIdcard(patientInfoRespVO.getCredNo());
        patientEntity.setCardNo(patientCheckRequestBO.getCardNo());
        patientEntity.setTelphone(patientInfoRespVO.getContactMobile());
        patientEntity.setGender(Integer.valueOf(patientInfoRespVO.getGender().shortValue()));
        patientEntity.setPatientName(patientInfoRespVO.getName());
        patientEntity.setCredTypeCode(patientInfoRespVO.getCredTypeCode());
        patientEntity.setXCreateTime(new Date());
        patientEntity.setXUpdateTime(new Date());
        patientEntity.setXVersion(Long.valueOf(0L));
        patientEntity.setIsMedicare(patientCheckRequestBO.getIsMedicare());
        if (null != medicareCardInfo) {
            log.info("=============\u4e0d\u5b58\u5728\u8fdb\u5165==================");
            log.info("medicareCardInfo:" + JSON.toJSONString((Object)medicareCardInfo));
            patientEntity.setMedicalNO(medicareCardInfo.getCardNO());
            patientEntity.setFundType(medicareCardInfo.getFundType());
            patientEntity.setPactCode(medicareCardInfo.getPactCode());
            patientEntity.setPactName(medicareCardInfo.getPactName());
            patientEntity.setAddress(medicareCardInfo.getAddress());
        }
        return patientEntity;
    }

    private BaseResponse<PatientInfoRespVO> getPatientInfo(PatientCheckRequestBo patientCheckRequestBO) {
        PatientInfoReqVO patientInfoReqVO = new PatientInfoReqVO();
        patientInfoReqVO.setPatientId(patientCheckRequestBO.getPatientId());
        patientInfoReqVO.setHospitalId(patientCheckRequestBO.getOrganId());
        patientInfoReqVO.setAppCode("BYCS");
        patientInfoReqVO.setChannelCode("DOCTOR_NETINQUIRY");
        BaseResponse response = this.patientServiceFeignClient.getPatientInfo(patientInfoReqVO);
        log.info("\u786e\u8ba4\u5c31\u8bca\u5361\u540e\u505a\u8d44\u683c\u786e\u8ba4response: {}", (Object)JSON.toJSONString((Object)response));
        return response;
    }

    public InquiryMchCodeEntity getInquiryMchCodeEntity(String appCode, String hospitalId) {
        QueryWrapper wrapper = new QueryWrapper();
        InquiryMchCodeEntity inquiryMchCodeEntity = new InquiryMchCodeEntity();
        inquiryMchCodeEntity.setAppCode(appCode);
        inquiryMchCodeEntity.setHospitalId(hospitalId);
        log.info("inquiryMchCodeEntity:{}" + inquiryMchCodeEntity.toString());
        wrapper.setEntity((Object)inquiryMchCodeEntity);
        return (InquiryMchCodeEntity)this.inquiryMchCodeMapper.selectOne((Wrapper)wrapper);
    }

    public CardVerificationAndInfoResVo HYTMedicareCardInfo(PatientCheckRequestBo patientCheckRequestBO, String bitrh, String gender, InquiryMchCodeEntity entity, CardVerificationAndInfoResVo medicareCardInfo) {
        log.info("entity:" + entity.toString());
        CardVerificationAndInfoReqVo cardInfoReqVo = new CardVerificationAndInfoReqVo();
        cardInfoReqVo.setMarkNO(patientCheckRequestBO.getCardNo());
        cardInfoReqVo.setIdCard(patientCheckRequestBO.getIdCard());
        cardInfoReqVo.setName(patientCheckRequestBO.getPatientName());
        cardInfoReqVo.setSex(gender);
        cardInfoReqVo.setBirthday(bitrh);
        if (patientCheckRequestBO.getIsMedicare().equals(WhetherEnum.FORBID.getValue())) {
            cardInfoReqVo.setMarkType(CardTypeEnum.OUTPATIENT_CARD.getValue());
            medicareCardInfo = this.getMedicareCardInfo(cardInfoReqVo);
        }
        if (patientCheckRequestBO.getIsMedicare().equals(WhetherEnum.ALLOW.getValue())) {
            cardInfoReqVo.setMarkType(CardTypeEnum.MEDICARE_CARD.getValue());
            medicareCardInfo = this.getMedicareCardInfo(cardInfoReqVo);
        }
        return medicareCardInfo;
    }

    public CardVerificationAndInfoResVo getMedicareCardInfo(CardVerificationAndInfoReqVo cardVerificationAndInfoReqVo) {
        log.info("\u5361\u6821\u9a8chis\u5f00\u59cb\u65f6\u95f4:{}" + System.currentTimeMillis());
        CardVerificationAndInfoResVo cardVerificationAndInfo = this.hisTemplateService.getCardVerificationAndInfo(cardVerificationAndInfoReqVo);
        if (null == cardVerificationAndInfo || StringUtils.isEmpty((String)cardVerificationAndInfo.getFundType())) {
            log.info("============\u5361\u8be6\u60c5\u67e5\u8be2\u5931\u8d25===============");
        }
        log.info("\u5361\u6821\u9a8chis\u7ed3\u675f\u65f6\u95f4:{}" + System.currentTimeMillis());
        return cardVerificationAndInfo;
    }

    public ResultData<PatientEntity> findOneByPatientId(FindOneByPatientIdDTO dto) {
        ResultData resultData = new ResultData();
        PatientEntity entity = this.patientMapper.findOneByPatientId(dto.getPatientId());
        if (entity != null) {
            return resultData.success((Object)entity);
        }
        return resultData.error("\u672a\u67e5\u8be2\u5230\u75c5\u4eba\u4fe1\u606f");
    }
}

