/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctor.basedata.api.DepartmentInfoApi;
import com.doctoruser.api.common.enums.DoctorTypeEnum;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.fz.DiagnosisInfoReqVo;
import com.ebaiyihui.his.pojo.vo.fz.DoCancelRegisterReqVo;
import com.ebaiyihui.his.pojo.vo.fz.PatientVisitReqVo;
import com.ebaiyihui.his.pojo.vo.fz.body.DiagnosisData;
import com.ebaiyihui.onlineoutpatient.common.dto.DoctorRequestRefundDTO;
import com.ebaiyihui.onlineoutpatient.common.util.ResultData;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.PasswordVo;
import com.ebaiyihui.onlineoutpatient.common.vo.pay.RequestBusinessBillVo;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ICDMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.InquiryMchCodeMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMedicalRecordMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ServicePayBillMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ICDEntity;
import com.ebaiyihui.onlineoutpatient.core.model.InquiryMchCodeEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientMedicalRecordEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ServicePayBillEntity;
import com.ebaiyihui.onlineoutpatient.core.service.AliSmsPushService;
import com.ebaiyihui.onlineoutpatient.core.service.AlipaySmallProgramPushService;
import com.ebaiyihui.onlineoutpatient.core.service.HisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.service.IMInformService;
import com.ebaiyihui.onlineoutpatient.core.service.PayCallBackService;
import com.ebaiyihui.onlineoutpatient.core.service.PaymentService;
import com.ebaiyihui.onlineoutpatient.core.service.RedisTemplateService;
import com.ebaiyihui.onlineoutpatient.core.service.SmallProgramPushService;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorInfofeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryOrderServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.remotecall.InternetHospitalDetailInfoService;
import com.ebaiyihui.onlineoutpatient.core.utils.HttpKit;
import com.ebaiyihui.onlineoutpatient.core.utils.gateway.GateWayCommonUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.AdmissionOrCancellationReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.AdmissionOrCancellationResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.RequestRefundVo;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalEntityVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PaymentServiceImpl
implements PaymentService {
    private static final Logger log = LoggerFactory.getLogger(PaymentServiceImpl.class);
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private IMInformService iMInformService;
    @Autowired
    private PayCallBackService payCallBackService;
    @Autowired
    private SmallProgramPushService smallProgramPushService;
    @Autowired
    private AlipaySmallProgramPushService alipaySmallProgramPushService;
    @Autowired
    private BaseInquiryOrderServiceImpl baseInquiryOrderService;
    @Autowired
    private HisTemplateService hisTemplateService;
    @Autowired
    private InquiryMchCodeMapper inquiryMchCodeMapper;
    @Autowired
    private ServicePayBillMapper servicePayBillMapper;
    @Autowired
    private AliSmsPushService aliSmsPushService;
    @Autowired
    private RedisTemplateService redisTemplateService;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private PatientMedicalRecordMapper patientMedicalRecordMapper;
    @Autowired
    private DoctorInfofeignClient doctorCilent;
    @Autowired
    private DepartmentInfoApi departmentInfoApi;
    @Autowired
    private InternetHospitalDetailInfoService internetHospitalDetailInfoService;
    @Autowired
    private ICDMapper icdMapper;
    private ExecutorService executor = Executors.newCachedThreadPool();

    public ResultData<String> doctorAllRefund(DoctorRequestRefundDTO param) {
        String redisKey;
        Boolean flag;
        ResultData result = new ResultData();
        String msg = this.checkDoctorAccount(param);
        if (msg != null) {
            return result.error(msg);
        }
        AdmissionEntity admission = this.admissionMapper.findById(param.getAdmissionId());
        if (admission == null) {
            return result.error("\u5c31\u8bca\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        OrderEntity order = this.orderMapper.findById(admission.getOrderId());
        if (order == null) {
            return result.error("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        log.info("\u9000\u6b3e===", (Object)JSON.toJSONString((Object)order));
        if (0 == order.getPayAmount().compareTo(new BigDecimal(0.0))) {
            log.info("=========0\u5143\u652f\u4ed8\u4e0d\u652f\u6301\u9000\u6b3e===========");
            return result.success((Object)"0\u5143\u652f\u4ed8\u4e0d\u652f\u6301\u9000\u6b3e");
        }
        if (admission.getServType() != 7 && admission.getServType().equals(3)) {
            List<Integer> statusList = Arrays.asList(2, 7, 8, 9);
            boolean canRefund = statusList.stream().anyMatch(s -> s.equals(2));
            if (canRefund) {
                BaseResponse diagnosisList;
                PatientMedicalRecordEntity patientMedicalRecord = this.patientMedicalRecordMapper.findById(admission.getMedicalRecordId());
                if ("\u5df2\u63a8\u9001".equals(patientMedicalRecord.getXRemark())) {
                    PatientDynamicMedicalEntityVo entityVo = this.internetHospitalDetailInfoService.getMedicalInfoByAdmId(admission.getXId());
                    String primaryDiagno = entityVo.getPrimaryDiagno();
                    String[] array = primaryDiagno.split(";");
                    HashSet<String> set = new HashSet<String>(Arrays.asList(array));
                    diagnosisList = new ArrayList();
                    for (String fruit : set) {
                        DiagnosisData diagnosisData = new DiagnosisData();
                        QueryWrapper queryWrapper = new QueryWrapper();
                        ICDEntity icdEntity = new ICDEntity();
                        icdEntity.setIcdName(fruit);
                        queryWrapper.setEntity((Object)icdEntity);
                        ICDEntity icdEntity1 = (ICDEntity)this.icdMapper.selectOne((Wrapper)queryWrapper);
                        diagnosisData.setDiagnosisCode(icdEntity1.getIcdCode());
                        diagnosisData.setDiagnosticType("0");
                        diagnosisList.add(diagnosisData);
                    }
                    FrontRequest diagnosisInfoReqVoFrontRequest = new FrontRequest();
                    DiagnosisInfoReqVo diagnosisInfoReqVo = new DiagnosisInfoReqVo();
                    diagnosisInfoReqVo.setPatientNumber(admission.getPatientNumber());
                    diagnosisInfoReqVo.setDiagnosisList((List)diagnosisList);
                    diagnosisInfoReqVoFrontRequest.setBody((Object)diagnosisInfoReqVo);
                    FrontResponse frontResponse = new GateWayCommonUtil().requestHis("/fzOutpatient/deleteOutpatientDiagnosis", diagnosisInfoReqVoFrontRequest, String.class);
                    if (frontResponse.getCode().equals("0")) {
                        return new ResultData().error("\u5220\u9664\u8bca\u65ad\u4fe1\u606f\u540c\u6b65his\u5931\u8d25");
                    }
                }
                QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
                queryPersonnelInfoReq.setDoctorId(admission.getDoctorId());
                BaseResponse personnelInfoBaseResponse = this.doctorCilent.queryPersonnelInfo(queryPersonnelInfoReq);
                String emplCode = "";
                String deptCode = "";
                if (personnelInfoBaseResponse.isSuccess() && null != personnelInfoBaseResponse.getData()) {
                    emplCode = ((PersonnelInfo)personnelInfoBaseResponse.getData()).getEmplCode();
                    diagnosisList = this.departmentInfoApi.getDepartmentDetail(Long.valueOf(Long.parseLong(((PersonnelInfo)personnelInfoBaseResponse.getData()).getDeptId().toString())));
                }
                log.info("emplCode:{}", (Object)emplCode);
                log.info("deptCode:{}", (Object)deptCode);
                PatientEntity patient = this.patientMapper.selectById(admission.getPatientId());
                FrontRequest frontRequest = new FrontRequest();
                PatientVisitReqVo patientVisitReqVo = new PatientVisitReqVo();
                patientVisitReqVo.setDoctorCode(emplCode);
                patientVisitReqVo.setDeptCode(deptCode);
                patientVisitReqVo.setStatus("1");
                patientVisitReqVo.setPatientName(patient.getPatientName());
                patientVisitReqVo.setPatientNumber(admission.getPatientNumber());
                frontRequest.setBody((Object)patientVisitReqVo);
                FrontResponse cancelFronResponse = new GateWayCommonUtil().requestHis("/fzOutpatient/doOutpatientService", frontRequest, String.class);
                log.info("\u63a5\u8bca\u8fd4\u56de\u503c frontResponse{}", (Object)JSON.toJSONString((Object)cancelFronResponse));
                log.info("\u63a5\u8bca\u8fd4\u56de\u503c frontResponse{}", (Object)JSON.toJSONString((Object)cancelFronResponse));
                if (cancelFronResponse.getCode().equals("0")) {
                    if (cancelFronResponse.getMessage().contains("\u8be5\u60a3\u8005\u5df2\u7ecf\u4ea7\u751f\u4e86\u5c31\u8bca\u6570\u636e")) {
                        return new ResultData().error("\u9000\u53f7\u5931\u8d25,\u8be5\u60a3\u8005\u5df2\u7ecf\u4ea7\u751f\u4e86\u533b\u5631");
                    }
                    return new ResultData().error("\u9000\u53f7\u5931\u8d25");
                }
            }
            FrontRequest hisParam = new FrontRequest();
            DoCancelRegisterReqVo doCancelRegisterReqVo = new DoCancelRegisterReqVo();
            doCancelRegisterReqVo.setIsRefund("0");
            doCancelRegisterReqVo.setPatientNumber(admission.getPatientNumber());
            hisParam.setBody((Object)doCancelRegisterReqVo);
            FrontResponse frontResponse = new GateWayCommonUtil().requestHis("/fzOutpatient/doCancelRegister", hisParam, String.class);
            if (frontResponse.getCode().equals("0")) {
                return new ResultData().error("\u9000\u53f7\u4fe1\u606f\u540c\u6b65his\u5931\u8d25");
            }
        }
        QueryWrapper wrapper = new QueryWrapper();
        InquiryMchCodeEntity inquiryMchCodeEntity = new InquiryMchCodeEntity();
        inquiryMchCodeEntity.setAppCode(order.getAppCode());
        inquiryMchCodeEntity.setHospitalId(order.getHospitalId());
        log.info("inquiryMchCodeEntity:{}" + inquiryMchCodeEntity.toString());
        wrapper.setEntity((Object)inquiryMchCodeEntity);
        InquiryMchCodeEntity entity = (InquiryMchCodeEntity)this.inquiryMchCodeMapper.selectOne((Wrapper)wrapper);
        if (null == entity) {
            log.info("\u6ca1\u6709\u914d\u7f6e\u5546\u6237\u53f7\u6216his");
        }
        if (null != admission && admission.getStatus().equals(AdmissionStatusEnum.IN_CONSULTATION.getValue()) && order.getServType().equals(ServiceTypeEnum.NOS.getValue()) && null != entity && StringUtils.isNotEmpty((String)entity.getHisUrl()) && "HYT".equals(order.getAppCode())) {
            log.info("his\u5f00\u59cb\u53d6\u6d88\u63a5\u8bca");
            AdmissionOrCancellationReqVo admissionOrCancellationReqVo = new AdmissionOrCancellationReqVo();
            admissionOrCancellationReqVo.setClinicCode(order.getClinicCode());
            admissionOrCancellationReqVo.setYnSee("0");
            AdmissionOrCancellationResVo admissionOrCancellation = this.hisTemplateService.admissionOrCancellation(admissionOrCancellationReqVo);
            if (null == admissionOrCancellation) {
                log.info("\u53d6\u6d88\u63a5\u8bca\u5931\u8d25");
                return result.error("\u53d6\u6d88\u63a5\u8bca\u5931\u8d25");
            }
        }
        RequestRefundVo requestRefundVo = new RequestRefundVo();
        requestRefundVo.setOrderId(order.getXId());
        BaseResponse baseResponse = this.payCallBackService.refundCalls(requestRefundVo);
        admission.setStatus(AdmissionStatusEnum.REFUNDED_APPLY.getValue());
        admission.setXRemark(param.getReason());
        this.admissionMapper.update(admission);
        if (Objects.equals(DoctorTypeEnum.TEAM.getValue(), order.getDoctorType()) && (flag = Boolean.valueOf(this.redisTemplateService.addLockNew(redisKey = param.getAdmissionId() + "_YSTK", redisKey, 600L))).booleanValue()) {
            log.info("\u8be5\u60a3\u8005\u5df2\u9000\u6b3e");
            return new ResultData(true, "\u64cd\u4f5c\u6210\u529f", "-1", (Object)"\u8be5\u60a3\u8005\u5df2\u9000\u6b3e");
        }
        this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        return result.success((Object)"\u7533\u8bf7\u9000\u6b3e\u6210\u529f");
    }

    private String checkDoctorAccount(DoctorRequestRefundDTO param) {
        PasswordVo passwordVo = new PasswordVo();
        BeanUtils.copyProperties((Object)param, (Object)passwordVo);
        String url = this.projProperties.getVerifyAccount();
        BaseResponse response = null;
        try {
            String result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)passwordVo));
            response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), BaseResponse.class);
            log.info("response:{}" + JSON.toJSONString((Object)response));
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u9a8c\u8bc1\u63a5\u53e3\u5931\u8d25" + e.getMessage());
        }
        if (response.getData() != null) {
            return null;
        }
        return "\u767b\u5f55\u5bc6\u7801\u8f93\u5165\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01";
    }

    private OrderEntity getOrderById(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        OrderEntity wrapperEntity = new OrderEntity();
        wrapperEntity.setXId(id);
        queryWrapper.setEntity((Object)wrapperEntity);
        OrderEntity orderEntity = (OrderEntity)this.baseInquiryOrderService.getOne((Wrapper)queryWrapper);
        if (null == orderEntity) {
            return null;
        }
        return orderEntity;
    }

    public BaseResponse<List<ServicePayBillEntity>> getBusinessBill(RequestBusinessBillVo param) {
        if (StringUtils.isNotEmpty((String)param.getWorkServiceCode()) && !ServiceTypeEnum.HOS.getCode().equals(param.getWorkServiceCode()) && !ServiceTypeEnum.NOS.getCode().equals(param.getWorkServiceCode())) {
            return BaseResponse.success(new ArrayList());
        }
        List servicePayBillEntities = this.servicePayBillMapper.selectBillList(param);
        log.info("servicePayBillEntities:{}" + JSON.toJSONString((Object)servicePayBillEntities));
        return BaseResponse.success((Object)servicePayBillEntities);
    }

    static /* synthetic */ IMInformService access$000(PaymentServiceImpl x0) {
        return x0.iMInformService;
    }

    static /* synthetic */ OrderEntity access$100(PaymentServiceImpl x0, String x1) {
        return x0.getOrderById(x1);
    }

    static /* synthetic */ SmallProgramPushService access$200(PaymentServiceImpl x0) {
        return x0.smallProgramPushService;
    }

    static /* synthetic */ AlipaySmallProgramPushService access$300(PaymentServiceImpl x0) {
        return x0.alipaySmallProgramPushService;
    }

    static /* synthetic */ Logger access$400() {
        return log;
    }
}

