/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctor.basedata.api.vo.DoctorInfoRequestBodyReqVo;
import com.doctor.basedata.api.vo.DoctorPostRepVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.common.dto.PatientBookDTO;
import com.ebaiyihui.onlineoutpatient.common.vo.schedulerecord.PaientBookVo;
import com.ebaiyihui.onlineoutpatient.common.vo.schedulerecord.RequestGetScheduleForWeekVo;
import com.ebaiyihui.onlineoutpatient.common.vo.schedulerecord.RequestUpdateScheduleStatusVo;
import com.ebaiyihui.onlineoutpatient.common.vo.schedulerecord.ResponseGetScheduleForWeekVo;
import com.ebaiyihui.onlineoutpatient.common.vo.schedulerecord.ScheduleOfDayVo;
import com.ebaiyihui.onlineoutpatient.common.vo.schedulerecord.ScheduleRecordVo;
import com.ebaiyihui.onlineoutpatient.common.vo.schedulerecord.ScheduleTimeSaveListVo;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.OrderStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.WhetherEnum;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ScheduleRecordMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.InquiryServiceConfigEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ScheduleRecordEntity;
import com.ebaiyihui.onlineoutpatient.core.model.ScheduleTimeIntervalEntity;
import com.ebaiyihui.onlineoutpatient.core.service.AlipaySmallProgramPushService;
import com.ebaiyihui.onlineoutpatient.core.service.IMInformService;
import com.ebaiyihui.onlineoutpatient.core.service.PayCallBackService;
import com.ebaiyihui.onlineoutpatient.core.service.ScheduleRecordService;
import com.ebaiyihui.onlineoutpatient.core.service.SmallProgramPushService;
import com.ebaiyihui.onlineoutpatient.core.service.UmAppPushService;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorBaseFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorInfofeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryAdmissionServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryOrderServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseInquiryServiceConfigServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseScheduleRecordServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.service.impl.BaseScheduleTimeIntervalServiceImpl;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorInfo;
import com.ebaiyihui.onlineoutpatient.core.vo.DoctorInfoForScheduleVo;
import com.ebaiyihui.onlineoutpatient.core.vo.InsertScheduleRecordReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.RequestRefundVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ScheduleForWeekNewReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ScheduleForWeekNewResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ScheduleInfo;
import com.ebaiyihui.onlineoutpatient.core.vo.ScheduleRangeAndCount;
import com.ebaiyihui.onlineoutpatient.core.vo.ScheduleRangeAndTime;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ScheduleRecordImpl
implements ScheduleRecordService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleRecordImpl.class);
    @Autowired
    private BaseScheduleRecordServiceImpl baseScheduleRecordService;
    @Autowired
    private BaseScheduleTimeIntervalServiceImpl baseScheduleTimeIntervalService;
    @Autowired
    private BaseInquiryServiceConfigServiceImpl baseInquiryServiceConfigService;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private BaseInquiryAdmissionServiceImpl admissionService;
    @Autowired
    private BaseInquiryOrderServiceImpl orderService;
    @Autowired
    private PayCallBackService payCallBackService;
    @Autowired
    private IMInformService imInformService;
    @Autowired
    private SmallProgramPushService smallProgramPushService;
    @Autowired
    private AlipaySmallProgramPushService alipaySmallProgramPushService;
    @Autowired
    private UmAppPushService umAppPushService;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private DoctorInfofeignClient doctorCilent;
    @Autowired
    private DoctorBaseFeignClient doctorBaseFeignClient;
    private ExecutorService executor = Executors.newCachedThreadPool();

    public BaseResponse<String> insert(InsertScheduleRecordReqVo record) {
        String currentDate = DateUtils.getCurrentDateSimpleToString();
        Date dateNow = null;
        Date startRes = null;
        Date endRes = null;
        try {
            dateNow = DateUtils.strToDate((String)currentDate, (String)"yyyy-MM-dd");
            startRes = DateUtils.strToDate((String)record.getScheduleDate(), (String)"yyyy-MM-dd");
            endRes = DateUtils.strToDate((String)record.getScheduleDateEnd(), (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (dateNow.after(startRes)) {
            return BaseResponse.error((String)"\u65b0\u589e\u6392\u73ed\u65e5\u671f\u9700\u5927\u4e8e\u7b49\u4e8e\u5f53\u524d\u65e5\u671f");
        }
        List doctorInfoForScheduleList = record.getDoctorInfoForScheduleVo();
        List scheduleRangeTimeList = record.getScheduleRangeAndTime();
        ArrayList dates = new ArrayList();
        List dateReq = DateUtils.getDateRange((Date)startRes, (Date)endRes);
        log.info("dateReq{}", (Object)JSON.toJSONString((Object)dateReq));
        List allDates = DateUtils.getOneDayNextWeek((List)dateReq, (Integer)3);
        log.info("allDates{}", (Object)JSON.toJSONString((Object)allDates));
        if (WhetherEnum.ALLOW.getValue().equals(record.getIsCycleSchedule())) {
            dates.addAll(allDates);
        } else {
            dates.addAll(dateReq);
        }
        log.info("dates{}", (Object)JSON.toJSONString(dates));
        for (DoctorInfoForScheduleVo doctorInfo : doctorInfoForScheduleList) {
            QueryWrapper scheduleRecordWrapper = new QueryWrapper();
            ScheduleRecordEntity scheduleRecordEntity = new ScheduleRecordEntity();
            scheduleRecordEntity.setDoctorId(doctorInfo.getDoctorId());
            scheduleRecordEntity.setHospitalId(record.getHospitalId());
            scheduleRecordEntity.setDeptId(doctorInfo.getDeptId());
            scheduleRecordEntity.setStatus(WhetherEnum.ALLOW.getValue());
            scheduleRecordEntity.setServType(record.getServType());
            for (String oneDay : dates) {
                scheduleRecordEntity.setScheduleDate(DateUtils.strToDateNoTry((String)oneDay));
                scheduleRecordWrapper.setEntity((Object)scheduleRecordEntity);
                log.info("\u533b\u751f\u67d0\u79d1\u5ba4\u67d0\u5929\u6709\u6392\u73ed\u7684\u5165\u53c2:" + scheduleRecordEntity);
                List list = this.baseScheduleRecordService.list((Wrapper)scheduleRecordWrapper);
                if (CollectionUtils.isEmpty((Collection)list)) continue;
                log.info("list{}", (Object)list.toString());
                for (ScheduleRangeAndTime rangeReq : scheduleRangeTimeList) {
                    for (ScheduleRecordEntity rangeRes : list) {
                        Boolean aBoolean = DateUtils.rangeCompare((Date)DateUtils.strToDateNoTryForMinute((String)rangeReq.getStartTime()), (Date)DateUtils.strToDateNoTryForMinute((String)rangeReq.getEndTime()), (Date)DateUtils.strToDateNoTryForMinute((String)rangeRes.getStartTime()), (Date)DateUtils.strToDateNoTryForMinute((String)rangeRes.getEndTime()));
                        if (!aBoolean.booleanValue()) continue;
                        return BaseResponse.error((String)"\u6392\u73ed\u65f6\u6bb5\u4e0e\u5df2\u6dfb\u52a0\u6392\u73ed\u65f6\u95f4\u51b2\u7a81\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e");
                    }
                }
            }
        }
        for (DoctorInfoForScheduleVo doctorInfo : doctorInfoForScheduleList) {
            for (String oneDay : dates) {
                scheduleRangeTimeList.stream().forEach(rangeVo -> this.getInsertSchedule(record, doctorInfo, rangeVo, oneDay));
            }
        }
        return BaseResponse.success((Object)"\u65b0\u589e\u6392\u73ed\u6210\u529f");
    }

    private boolean isBoolean(Date startRes, Date endRes, ScheduleRecordEntity schedule) {
        return schedule.getScheduleDate().after(startRes) && schedule.getScheduleDate().before(endRes) || schedule.getScheduleDate().equals(startRes) || schedule.getScheduleDate().equals(endRes);
    }

    private void getInsertSchedule(InsertScheduleRecordReqVo record, DoctorInfoForScheduleVo doctorInfo, ScheduleRangeAndTime rangeRes, String s) {
        ScheduleRecordEntity schedule = new ScheduleRecordEntity();
        BeanUtils.copyProperties((Object)record, (Object)schedule);
        BeanUtils.copyProperties((Object)doctorInfo, (Object)schedule);
        BeanUtils.copyProperties((Object)rangeRes, (Object)schedule);
        schedule.setAvailableCount(rangeRes.getTotalCount());
        Date date = null;
        try {
            date = DateUtils.strToDate((String)s, (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        schedule.setScheduleDate(date);
        log.info("\u6392\u73ed\u65b0\u589e\u5165\u53c2:" + schedule.toString());
        this.baseScheduleRecordService.save((Object)schedule);
    }

    public BaseResponse<String> updateStatus(RequestUpdateScheduleStatusVo updateScheduleStatusVo) {
        ScheduleRecordEntity entity = (ScheduleRecordEntity)this.baseScheduleRecordService.getById((Serializable)updateScheduleStatusVo.getId());
        if (null == entity) {
            return BaseResponse.error((String)"\u6392\u73ed\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (null != updateScheduleStatusVo.getIsCycleSchedule()) {
            this.closeCycle(updateScheduleStatusVo, entity);
            log.info("======\u5faa\u73af\u6392\u73ed\u64cd\u4f5c\u6210\u529f======");
            return BaseResponse.success();
        }
        BaseResponse baseResponse = this.closeSchedule(updateScheduleStatusVo, entity);
        return baseResponse;
    }

    private BaseResponse<String> closeSchedule(RequestUpdateScheduleStatusVo updateScheduleStatusVo, ScheduleRecordEntity entity) {
        BaseResponse x = this.getStringBaseResponse(entity);
        if (x != null) {
            return x;
        }
        ScheduleRecordEntity entityUpdate = new ScheduleRecordEntity();
        entityUpdate.setStatus(Integer.valueOf(-1));
        if (Objects.nonNull(updateScheduleStatusVo.getIsCycleSchedule())) {
            entityUpdate.setIsCycleSchedule(updateScheduleStatusVo.getIsCycleSchedule());
        }
        entityUpdate.setId(entity.getId());
        this.baseScheduleRecordService.updateById((Object)entityUpdate);
        List list = this.orderMapper.findOrderByScheduleId(entity.getId().toString());
        if (CollectionUtils.isEmpty((Collection)list)) {
            return BaseResponse.success((Object)"\u533b\u751f\u6392\u73ed\u505c\u8bca\u6210\u529f");
        }
        log.info("\u505c\u8bca\u9700\u8981\u9000\u6b3e\u7684\u5c31\u8bca\u8bb0\u5f55\uff1a{}", (Object)list.toString());
        for (String orderId : list) {
            OrderEntity orderEntity = (OrderEntity)this.orderMapper.selectById((Serializable)((Object)orderId));
            AdmissionEntity admissionEntity = this.admissionMapper.queryAdmByOrderId(orderId);
            if (orderEntity.getStatus().equals(OrderStatusEnum.PAID.getValue()) && orderEntity.getPayAmount().compareTo(BigDecimal.ZERO) != 0) {
                RequestRefundVo requestRefundVo = new RequestRefundVo();
                requestRefundVo.setOrderId(orderEntity.getXId());
                BaseResponse baseResponse = this.payCallBackService.refundCalls(requestRefundVo);
                if (!baseResponse.isSuccess()) {
                    log.error("\u9000\u6b3e\u5931\u8d25\uff0c\u8ba2\u5355ID\uff1a{}\uff0c\u539f\u56e0\uff1a{}", (Object)orderEntity.getXId(), (Object)baseResponse.getMsg());
                    orderEntity.setXRemark(baseResponse.getMsg());
                }
            }
            if (AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(admissionEntity.getStatus())) {
                admissionEntity.setStatus(AdmissionStatusEnum.DOCTOR_CLOSED_SCHEDULE.getValue());
                admissionEntity.setXRemark("\u5f85\u63a5\u8bca\u533b\u751f\u505c\u8bca\u9000\u6b3e");
                admissionEntity.setMessage("\u533b\u751f\u505c\u8bca");
                this.imInformService.doctorCloseScheduleToPat(entity.getDoctorName(), admissionEntity.getXId());
                this.imInformService.doctorCloseScheduleToDoc(admissionEntity.getXId());
            }
            if (AdmissionStatusEnum.WAIT_ADMISSION.getValue().equals(admissionEntity.getStatus())) {
                admissionEntity.setStatus(AdmissionStatusEnum.DOCTOR_CLOSED_WATING_SCHEDULE.getValue());
                admissionEntity.setXRemark("\u5f85\u5019\u8bca\u533b\u751f\u505c\u8bca\u9000\u6b3e");
                admissionEntity.setMessage("\u533b\u751f\u505c\u8bca");
                this.imInformService.doctorCloseScheduleToPat(entity.getDoctorName(), admissionEntity.getXId());
            }
            orderEntity.setRefundTime(new Date());
            orderEntity.setStatus(OrderStatusEnum.REFUNDED.getValue());
            this.orderService.updateById((Object)orderEntity);
            admissionEntity.setEndTime(new Date());
            this.admissionService.updateById((Object)admissionEntity);
            this.executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
        return BaseResponse.success((Object)"\u533b\u751f\u6392\u73ed\u505c\u8bca\u6210\u529f");
    }

    private void closeCycle(RequestUpdateScheduleStatusVo updateScheduleStatusVo, ScheduleRecordEntity entity) {
        ScheduleRecordEntity entityUpdate = new ScheduleRecordEntity();
        entityUpdate.setIsCycleSchedule(updateScheduleStatusVo.getIsCycleSchedule());
        entityUpdate.setId(updateScheduleStatusVo.getId());
        this.baseScheduleRecordService.updateById((Object)entityUpdate);
        String date = DateUtils.dateToSimpleString((Date)entity.getScheduleDate());
        List nextDays = DateUtils.getOneDayNextWeekTwo((List)new /* Unavailable Anonymous Inner Class!! */, (Integer)5);
        List list = this.baseScheduleRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(ScheduleRecordEntity::getDeptId, (Object)entity.getDeptId())).eq(ScheduleRecordEntity::getDoctorId, (Object)entity.getDoctorId())).eq(ScheduleRecordEntity::getHospitalId, (Object)entity.getHospitalId())).eq(ScheduleRecordEntity::getServType, (Object)entity.getServType())).eq(ScheduleRecordEntity::getStartTime, (Object)entity.getStartTime())).eq(ScheduleRecordEntity::getEndTime, (Object)entity.getEndTime())).in(ScheduleRecordEntity::getScheduleDate, (Collection)nextDays));
        for (ScheduleRecordEntity scheduleRecordEntity : list) {
            if (scheduleRecordEntity.getId().equals(entity.getId())) continue;
            this.closeSchedule(updateScheduleStatusVo, scheduleRecordEntity);
        }
    }

    private OrderEntity getOrderEntity(AdmissionEntity admissionEntity) {
        QueryWrapper orderEntityQueryWrapper = new QueryWrapper();
        OrderEntity orderWrapper = new OrderEntity();
        orderWrapper.setXId(admissionEntity.getOrderId());
        orderEntityQueryWrapper.setEntity((Object)orderWrapper);
        OrderEntity orderEntity = (OrderEntity)this.orderService.getOne((Wrapper)orderEntityQueryWrapper);
        log.info("orderEntity{}", (Object)JSON.toJSONString((Object)orderEntity));
        return orderEntity;
    }

    private BaseResponse<String> getStringBaseResponse(ScheduleRecordEntity entity) {
        String nowDateStr = DateUtils.getCurrentDateSimpleToString();
        log.info("nowDateStr{}", (Object)nowDateStr);
        String hourAndSecond = DateUtils.getHourAndSecond();
        log.info("hourAndSecond{}", (Object)hourAndSecond);
        Date now = null;
        Date endEntity = null;
        Date hourAndSec = null;
        try {
            now = DateUtils.strToDate((String)nowDateStr, (String)"yyyy-MM-dd");
            endEntity = DateUtils.strToDate((String)entity.getEndTime(), (String)"HH:mm");
            hourAndSec = DateUtils.strToDate((String)hourAndSecond, (String)"HH:mm");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (entity.getStatus().equals(WhetherEnum.FORBID.getValue())) {
            return BaseResponse.error((String)"\u5df2\u505c\u8bca,\u8bf7\u52ff\u91cd\u590d\u505c\u8bca");
        }
        if (this.isBoolean(entity, now, endEntity, hourAndSec)) {
            return BaseResponse.error((String)"\u8d85\u65f6\u4e0d\u80fd\u505c\u8bca");
        }
        return null;
    }

    private boolean isBoolean(ScheduleRecordEntity entity, Date now, Date endEntity, Date hourAndSec) {
        return entity.getScheduleDate().equals(now) && hourAndSec.after(endEntity) || entity.getScheduleDate().before(now);
    }

    private AdmissionEntity getAdmissionEntity(OrderEntity orderEntity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        AdmissionEntity wrapperEntity = new AdmissionEntity();
        wrapperEntity.setOrderId(orderEntity.getXId());
        queryWrapper.setEntity((Object)wrapperEntity);
        return (AdmissionEntity)this.admissionService.getOne((Wrapper)queryWrapper);
    }

    private List<OrderEntity> getOrderEntities(ScheduleRecordEntity entity) {
        QueryWrapper orderQueryWrapper = new QueryWrapper();
        OrderEntity orderEntity1 = new OrderEntity();
        orderEntity1.setDoctorId(entity.getDoctorId());
        orderEntity1.setHospitalId(entity.getHospitalId());
        orderEntity1.setDeptId(Long.valueOf(entity.getDeptId()));
        orderEntity1.setStatus(OrderStatusEnum.PAID.getValue());
        orderQueryWrapper.setEntity((Object)orderEntity1);
        return this.orderService.list((Wrapper)orderQueryWrapper);
    }

    public BaseResponse<List<ResponseGetScheduleForWeekVo>> getScheduleForWeek(RequestGetScheduleForWeekVo getScheduleForWeekVo) {
        Date intStartDate = DateUtils.dateToDateAsFormat((Date)DateUtils.getBeginDayOfWeek());
        Date intEndDate = DateUtils.dateToDateAsFormat((Date)DateUtils.getEndDayOfWeek());
        Integer week = getScheduleForWeekVo.getWeek();
        Date startDate = null;
        Date endDate = null;
        startDate = DateUtils.getDateAfter((Date)intStartDate, (int)(7 * week));
        endDate = DateUtils.getDateAfter((Date)intEndDate, (int)(7 * week));
        QueryWrapper wrapper = new QueryWrapper();
        ScheduleRecordEntity entity = new ScheduleRecordEntity();
        entity.setDeptId(JSON.toJSONString((Object)getScheduleForWeekVo.getDeptId()));
        entity.setHospitalId(JSON.toJSONString((Object)getScheduleForWeekVo.getHospitalId()));
        wrapper.setEntity((Object)entity);
        wrapper.between((Object)"schedule_date", (Object)startDate, (Object)endDate);
        List recordEntityList = this.baseScheduleRecordService.list((Wrapper)wrapper);
        log.info("\u67e5\u8be2\u6392\u73ed\u7ed3\u679c{}", (Object)recordEntityList.toString());
        ArrayList<ResponseGetScheduleForWeekVo> list = new ArrayList<ResponseGetScheduleForWeekVo>();
        for (int i = 0; i < 7; ++i) {
            ResponseGetScheduleForWeekVo scheduleForWeekVo = new ResponseGetScheduleForWeekVo();
            Date weekDay = DateUtils.getDateAfter((Date)startDate, (int)i);
            scheduleForWeekVo.setScheduleDate(weekDay);
            ArrayList<ScheduleOfDayVo> scheduleOfDayVoList = new ArrayList<ScheduleOfDayVo>();
            for (int j = 1; j <= 3; ++j) {
                ScheduleOfDayVo scheduleOfDayVo = new ScheduleOfDayVo();
                QueryWrapper queryWrapper = new QueryWrapper();
                ScheduleTimeIntervalEntity timeIntervalEntity = new ScheduleTimeIntervalEntity();
                timeIntervalEntity.setHospitalId(getScheduleForWeekVo.getHospitalId());
                timeIntervalEntity.setScheduleRange(Integer.valueOf(j));
                queryWrapper.setEntity((Object)timeIntervalEntity);
                ScheduleTimeIntervalEntity scheduleTimeIntervalEntity = (ScheduleTimeIntervalEntity)this.baseScheduleTimeIntervalService.getOne((Wrapper)queryWrapper);
                ScheduleTimeSaveListVo saveListVo = new ScheduleTimeSaveListVo();
                if (null != scheduleTimeIntervalEntity) {
                    BeanUtils.copyProperties((Object)scheduleTimeIntervalEntity, (Object)saveListVo);
                }
                scheduleOfDayVo.setScheduleTimeSaveListVo(saveListVo);
                ArrayList<ScheduleRecordVo> scheduleRecordVoList = new ArrayList<ScheduleRecordVo>();
                if (!recordEntityList.isEmpty()) {
                    for (ScheduleRecordEntity scheduleRecordEntity : recordEntityList) {
                        if (!DateUtils.dateToSimpleString((Date)scheduleRecordEntity.getScheduleDate()).equals(DateUtils.dateToSimpleString((Date)weekDay)) || !scheduleRecordEntity.getScheduleRange().equals(j)) continue;
                        ScheduleRecordVo scheduleRecordVo = new ScheduleRecordVo();
                        BeanUtils.copyProperties((Object)scheduleRecordEntity, (Object)scheduleRecordVo);
                        QueryWrapper configQuery = new QueryWrapper();
                        InquiryServiceConfigEntity configEntity = new InquiryServiceConfigEntity();
                        configEntity.setOrganId(getScheduleForWeekVo.getHospitalId().toString());
                        configEntity.setDoctorId(scheduleRecordEntity.getDoctorId());
                        configEntity.setDeptId(Long.valueOf(Long.parseLong(scheduleRecordEntity.getDeptId())));
                        configQuery.setEntity((Object)configEntity);
                        configQuery.last("limit 1");
                        InquiryServiceConfigEntity inquiryServiceConfigEntity = (InquiryServiceConfigEntity)this.baseInquiryServiceConfigService.getOne((Wrapper)configQuery);
                        scheduleRecordVo.setPrice(inquiryServiceConfigEntity.getPrice());
                        scheduleRecordVoList.add(scheduleRecordVo);
                    }
                }
                scheduleOfDayVo.setRecordVoList(scheduleRecordVoList);
                scheduleOfDayVoList.add(scheduleOfDayVo);
            }
            scheduleForWeekVo.setScheduleOfDayVoList(scheduleOfDayVoList);
            list.add(scheduleForWeekVo);
        }
        return BaseResponse.success(list);
    }

    public BaseResponse<PaientBookVo> patientSubscribe(PatientBookDTO dto) {
        PaientBookVo paientBookVo = this.scheduleRecordMapper.patientSubscribe(dto);
        if (null == paientBookVo) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u8be5\u533b\u751f\u6392\u73ed");
        }
        if (paientBookVo.getAvailableCount() <= 0) {
            return BaseResponse.error((String)"\u8be5\u533b\u751f\u53f7\u6e90\u5df2\u7ecf\u7528\u5b8c");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        InquiryServiceConfigEntity wrapperEntity = new InquiryServiceConfigEntity();
        wrapperEntity.setDoctorId(dto.getDoctorId());
        wrapperEntity.setOrganId(dto.getOrganId());
        wrapperEntity.setDeptId(Long.valueOf(Long.parseLong(dto.getDeptId())));
        queryWrapper.setEntity((Object)wrapperEntity);
        queryWrapper.last("limit 1");
        log.info("wrapperEntity:{}" + JSON.toJSONString((Object)wrapperEntity));
        InquiryServiceConfigEntity inquiryServiceConfigEntity = (InquiryServiceConfigEntity)this.baseInquiryServiceConfigService.getOne((Wrapper)queryWrapper);
        if (null == inquiryServiceConfigEntity) {
            return BaseResponse.error((String)"\u533b\u751f\u670d\u52a1\u4fe1\u606f\u672a\u914d\u7f6e");
        }
        log.info("inquiryServiceConfigEntity:{}" + inquiryServiceConfigEntity.toString());
        ScheduleTimeIntervalEntity scheduleTimeIntervalEntity = this.getScheduleTime(Long.valueOf(dto.getOrganId()), dto.getScheduleRange());
        if (null != scheduleTimeIntervalEntity) {
            paientBookVo.setStartTime(scheduleTimeIntervalEntity.getStartTime());
            paientBookVo.setEndTime(scheduleTimeIntervalEntity.getEndTime());
        } else {
            switch (dto.getScheduleRange()) {
                case 1: {
                    paientBookVo.setStartTime("09:00");
                    paientBookVo.setEndTime("12:00");
                    break;
                }
                case 2: {
                    paientBookVo.setStartTime("13:00");
                    paientBookVo.setEndTime("18:00");
                    break;
                }
                case 3: {
                    paientBookVo.setStartTime("18:00");
                    paientBookVo.setEndTime("21:00");
                    break;
                }
                default: {
                    paientBookVo.setStartTime("09:00");
                    paientBookVo.setEndTime("21:00");
                }
            }
        }
        paientBookVo.setRegFee(inquiryServiceConfigEntity.getPrice());
        return BaseResponse.success((Object)paientBookVo);
    }

    private ScheduleTimeIntervalEntity getScheduleTime(Long hospitalId, Integer scheduleRange) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ScheduleTimeIntervalEntity timeIntervalEntity = new ScheduleTimeIntervalEntity();
        timeIntervalEntity.setHospitalId(hospitalId);
        timeIntervalEntity.setScheduleRange(scheduleRange);
        queryWrapper.setEntity((Object)timeIntervalEntity);
        return (ScheduleTimeIntervalEntity)this.baseScheduleTimeIntervalService.getOne((Wrapper)queryWrapper);
    }

    public BaseResponse<List<ScheduleForWeekNewResVo>> scheduleForWeekNew(ScheduleForWeekNewReqVo scheduleForWeekNewReqVo) {
        Date intStartDate = DateUtils.dateToDateAsFormat((Date)DateUtils.getBeginDayOfWeek());
        Date intEndDate = DateUtils.dateToDateAsFormat((Date)DateUtils.getEndDayOfWeek());
        Integer week = scheduleForWeekNewReqVo.getWeek();
        Date startDate = DateUtils.getDateAfter((Date)intStartDate, (int)(7 * week));
        Date endDate = DateUtils.getDateAfter((Date)intEndDate, (int)(7 * week));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList list = new ArrayList();
        List scheduleRecordEList = this.getScheduleRecordEntities(scheduleForWeekNewReqVo, simpleDateFormat.format(startDate), simpleDateFormat.format(endDate));
        if (CollectionUtils.isEmpty((Collection)scheduleRecordEList)) {
            list = this.noScheduleRes(startDate);
            return BaseResponse.success((Object)list);
        }
        log.info("\u67e5\u8be2\u6392\u73ed\u7ed3\u679c{}", (Object)scheduleRecordEList.size());
        Set doctorIds = scheduleRecordEList.stream().map(ScheduleRecordEntity::getDoctorId).collect(Collectors.toSet());
        log.info("\u533b\u751fid\u96c6\u5408\u4fe1\u606fdoctorIds:" + doctorIds);
        DoctorInfoRequestBodyReqVo doctorInfoRequestBodyReqVo = new DoctorInfoRequestBodyReqVo();
        doctorInfoRequestBodyReqVo.setDoctorIds(new ArrayList(doctorIds));
        BaseResponse baseResponse = this.doctorBaseFeignClient.queryDoctorPostByDoctorIds(doctorInfoRequestBodyReqVo);
        log.info("\u67e5\u8be2\u533b\u751f\u8be6\u60c5\u51fa\u53c2" + JSON.toJSONString((Object)baseResponse.getData()));
        if (!baseResponse.isSuccess()) {
            log.error("\u8fdc\u7a0b\u8c03\u7528\u533b\u751f\u4fe1\u606f\u5931\u8d25");
            return BaseResponse.error((String)"\u8fdc\u7a0b\u8c03\u7528\u533b\u751f\u4fe1\u606f\u5931\u8d25");
        }
        List doctorBasicRespVOList = (List)baseResponse.getData();
        Map<String, List<DoctorPostRepVO>> doctorPostRepVOMap = doctorBasicRespVOList.stream().collect(Collectors.groupingBy(record -> String.valueOf(record.getId())));
        Map<String, List<ScheduleRecordEntity>> groupedByDate = scheduleRecordEList.stream().collect(Collectors.groupingBy(record -> simpleDateFormat.format(record.getScheduleDate())));
        int i = 0;
        for (i = 0; i < 7; ++i) {
            ScheduleForWeekNewResVo scheduleTimeRes = new ScheduleForWeekNewResVo();
            Date dateAfter = DateUtils.getDateAfter((Date)startDate, (int)i);
            String dateKey = simpleDateFormat.format(dateAfter);
            log.info("\u7b2c\u51e0\u5929:" + dateKey);
            scheduleTimeRes.setScheduleTime(dateKey);
            List scheduleOneDayList = groupedByDate.getOrDefault(dateKey, new ArrayList());
            if (CollectionUtils.isEmpty((Collection)scheduleOneDayList)) {
                scheduleTimeRes.setScheduleInfos(new ArrayList());
                list.add(scheduleTimeRes);
                continue;
            }
            log.info("\u67d0\u5929\u7684\u6392\u73ed{}", (Object)scheduleOneDayList.toString());
            Map<String, List<ScheduleRecordEntity>> collect = scheduleOneDayList.stream().collect(Collectors.groupingBy(ScheduleRecordEntity::getDoctorId));
            ArrayList<ScheduleInfo> scheduleInfos = new ArrayList<ScheduleInfo>();
            for (String key : collect.keySet()) {
                List<ScheduleRecordEntity> scheduleRecordEntities = collect.get(key);
                Map<String, List<ScheduleRecordEntity>> collectDept = scheduleRecordEntities.stream().collect(Collectors.groupingBy(ScheduleRecordEntity::getDeptId));
                for (String keyDept : collectDept.keySet()) {
                    ScheduleInfo scheduleInfo = new ScheduleInfo();
                    List<ScheduleRecordEntity> scheduleRecord = collectDept.get(keyDept);
                    log.info("\u533b\u751fid{}", (Object)key);
                    List<DoctorPostRepVO> doctorPostRepVOS1 = doctorPostRepVOMap.get(key);
                    log.info("\u533b\u751f\u4fe1\u606f{}", (Object)JSON.toJSONString(doctorPostRepVOS1));
                    scheduleInfo.setDeptId(keyDept);
                    scheduleInfo.setDeptName(scheduleRecord.get(0).getDeptName());
                    scheduleInfo.setDoctorId(key);
                    scheduleInfo.setDoctorName(scheduleRecord.get(0).getDoctorName());
                    if (CollectionUtil.isNotEmpty(doctorPostRepVOS1)) {
                        scheduleInfo.setDoctorProfession(doctorPostRepVOS1.get(0).getProfession());
                        scheduleInfo.setDoctorPortrait(doctorPostRepVOS1.get(0).getHeadPortrait());
                    }
                    ArrayList scheduleRangeAndCounts = new ArrayList();
                    scheduleRecord.sort(Comparator.comparing(ScheduleRecordEntity::getStartTime));
                    scheduleRecord.stream().forEach(scheduleRecordCount -> {
                        ScheduleRangeAndCount scheduleRangeAndCount = new ScheduleRangeAndCount();
                        BeanUtils.copyProperties((Object)scheduleRecordCount, (Object)scheduleRangeAndCount);
                        scheduleRangeAndCounts.add(scheduleRangeAndCount);
                    });
                    scheduleRecord.sort(Comparator.comparing(ScheduleRecordEntity::getCreateTime));
                    scheduleInfo.setCreateEarliestTime(scheduleRecord.get(0).getCreateTime());
                    scheduleInfo.setScheduleRangeAndCountList(scheduleRangeAndCounts);
                    scheduleInfos.add(scheduleInfo);
                    scheduleInfos.sort(Comparator.comparing(ScheduleInfo::getCreateEarliestTime).reversed());
                    scheduleTimeRes.setScheduleInfos(scheduleInfos);
                }
            }
            list.add(scheduleTimeRes);
            log.info("list{}", (Object)list.toString());
        }
        return BaseResponse.success((Object)list);
    }

    private List<ScheduleRecordEntity> getScheduleRecordEntities(ScheduleForWeekNewReqVo scheduleForWeekNewReqVo, String format, DoctorInfo doctorInfo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ScheduleRecordEntity scheduleRecordCountEntity = new ScheduleRecordEntity();
        scheduleRecordCountEntity.setHospitalId(scheduleForWeekNewReqVo.getHospitalId().toString());
        scheduleRecordCountEntity.setDeptId(doctorInfo.getDeptId());
        scheduleRecordCountEntity.setDoctorId(doctorInfo.getDoctorId());
        try {
            scheduleRecordCountEntity.setScheduleDate(DateUtils.strToDate((String)format, (String)"yyyy-MM-dd"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        scheduleRecordCountEntity.setStatus(WhetherEnum.ALLOW.getValue());
        scheduleRecordCountEntity.setServType(scheduleForWeekNewReqVo.getServType());
        queryWrapper.setEntity((Object)scheduleRecordCountEntity);
        return this.scheduleRecordMapper.selectList((Wrapper)queryWrapper);
    }

    private InquiryServiceConfigEntity getInquiryServiceConfigEntity(List<ScheduleRecordEntity> scheduleRecord) {
        QueryWrapper inquiryServiceConfigWrapper = new QueryWrapper();
        InquiryServiceConfigEntity inquiryServiceConfigEntity = new InquiryServiceConfigEntity();
        inquiryServiceConfigEntity.setOrganId(scheduleRecord.get(0).getHospitalId());
        inquiryServiceConfigEntity.setDoctorId(scheduleRecord.get(0).getDoctorId());
        inquiryServiceConfigEntity.setDeptId(Long.valueOf(scheduleRecord.get(0).getDeptId()));
        if (ServiceTypeEnum.HOS.getValue().equals(scheduleRecord.get(0).getServType())) {
            inquiryServiceConfigEntity.setServiceCode(ServiceTypeEnum.HOS.getCode());
        }
        if (ServiceTypeEnum.NOS.getValue().equals(scheduleRecord.get(0).getServType())) {
            inquiryServiceConfigEntity.setServiceCode(ServiceTypeEnum.NOS.getCode());
        }
        inquiryServiceConfigWrapper.setEntity((Object)inquiryServiceConfigEntity);
        inquiryServiceConfigWrapper.last("limit 1");
        return (InquiryServiceConfigEntity)this.baseInquiryServiceConfigService.getOne((Wrapper)inquiryServiceConfigWrapper);
    }

    private ArrayList<ScheduleForWeekNewResVo> noScheduleRes(Date startDate) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<ScheduleForWeekNewResVo> list = new ArrayList<ScheduleForWeekNewResVo>();
        for (int i = 0; i < 7; ++i) {
            ScheduleForWeekNewResVo scheduleTimeRes = new ScheduleForWeekNewResVo();
            Date dateAfter = DateUtils.getDateAfter((Date)startDate, (int)i);
            String format = simpleDateFormat.format(dateAfter);
            log.info("\u7b2c\u51e0\u5929:" + format);
            scheduleTimeRes.setScheduleTime(format);
            scheduleTimeRes.setScheduleInfos(new ArrayList());
            list.add(scheduleTimeRes);
        }
        return list;
    }

    private List<ScheduleRecordEntity> getScheduleRecordEntities(ScheduleForWeekNewReqVo scheduleForWeekNewReqVo, String startDate, String endDate) {
        QueryWrapper wrapper = new QueryWrapper();
        ScheduleRecordEntity entity = new ScheduleRecordEntity();
        entity.setHospitalId(JSON.toJSONString((Object)scheduleForWeekNewReqVo.getHospitalId()));
        entity.setServType(scheduleForWeekNewReqVo.getServType());
        entity.setStatus(WhetherEnum.ALLOW.getValue());
        wrapper.setEntity((Object)entity);
        wrapper.between((Object)"schedule_date", (Object)startDate, (Object)endDate);
        wrapper.like(StringUtils.isNotEmpty((String)scheduleForWeekNewReqVo.getDoctorName()), (Object)"doctor_name", (Object)scheduleForWeekNewReqVo.getDoctorName());
        log.info("\u67e5\u8be2\u5165\u53c2:" + entity.toString());
        return this.scheduleRecordMapper.selectList((Wrapper)wrapper);
    }

    static /* synthetic */ SmallProgramPushService access$000(ScheduleRecordImpl x0) {
        return x0.smallProgramPushService;
    }

    static /* synthetic */ AlipaySmallProgramPushService access$100(ScheduleRecordImpl x0) {
        return x0.alipaySmallProgramPushService;
    }

    static /* synthetic */ UmAppPushService access$200(ScheduleRecordImpl x0) {
        return x0.umAppPushService;
    }
}

