/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctoruser.api.pojo.dto.organization.QueryOrganDetailDTO;
import com.doctoruser.api.pojo.vo.basedata.organization.QueryOrganDetailVO;
import com.ebaiyihui.common.pojo.login.UcWxAuthReqVo;
import com.ebaiyihui.common.pojo.login.UcWxAuthRespVo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.NewPushConfigEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.PushConfigEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ScheduleRecordEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.DoctorTeamMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.exception.AdmissionException;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.DoctorTeamEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.service.SmallProgramPushService;
import com.ebaiyihui.onlineoutpatient.core.service.client.NodeAccountFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.OrganDetailClient;
import com.ebaiyihui.onlineoutpatient.core.utils.HttpKit;
import com.ebaiyihui.onlineoutpatient.core.utils.PushUtils;
import com.ebaiyihui.onlineoutpatient.core.vo.InitiateVideoReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.PushConfigurationDetailVO;
import com.ebaiyihui.push.pojo.wechat.PushSubscribeMessageReqVO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class SmallProgramPushServiceImpl
implements SmallProgramPushService {
    private static final Logger log = LoggerFactory.getLogger(SmallProgramPushServiceImpl.class);
    public static final String MORNING_START = "09:00:00";
    public static final String AFTERNOON_START = "13:00:00";
    public static final String EVENING_START = "18:00:00";
    public static final short USER_STATUS = 1;
    public static final short USER_TYPE = 0;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private NodeAccountFeignClient nodeAccountClient;
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    private PushUtils pushUtils;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private DoctorTeamMapper doctorTeamMapper;
    @Autowired
    private OrganDetailClient organDetailClient;

    public void onlineVisitsProgramDoctorReceivePush(String patientId, String doctorName, String admId, Integer servType, String hospitalId) {
        String hospitalType = this.getHospitalType(hospitalId);
        if (ServiceTypeEnum.HOS.getValue().equals(servType)) {
            PushConfigEnum pushConfigEnum = PushConfigEnum.getPushConfigEnum((String)"doctor_received_remind".toLowerCase());
            PushSubscribeMessageReqVO pushSubscribeMessageReqVO = null;
            if ("1".equals(hospitalType)) {
                pushSubscribeMessageReqVO = this.appletPushConfig(doctorName, patientId, pushConfigEnum, admId);
            }
            if ("2".equals(hospitalType)) {
                pushSubscribeMessageReqVO = this.MZJHPushConfigForZX(doctorName, patientId, pushConfigEnum, admId, this.projProperties.getMZJHWXTemplateCode());
            }
            if (!admId.startsWith("KFZX")) {
                this.pushUtils.pushSubscribeMessage(pushSubscribeMessageReqVO);
            }
        } else {
            NewPushConfigEnum newPushConfigEnum = NewPushConfigEnum.getPushConfigEnum((String)"doctor_received_remind".toLowerCase());
            PushSubscribeMessageReqVO pushSubscribeMessageReqVO = null;
            if ("1".equals(hospitalType)) {
                pushSubscribeMessageReqVO = this.newAppletPushConfig(doctorName, patientId, newPushConfigEnum, admId);
            }
            if ("2".equals(hospitalType)) {
                pushSubscribeMessageReqVO = this.MZJHPushConfigForFZ(doctorName, patientId, newPushConfigEnum, admId, this.projProperties.getMZJHWXTemplateCode());
            }
            this.pushUtils.pushSubscribeMessage(pushSubscribeMessageReqVO);
        }
    }

    public void onlineWechatReceivePush(String patientId, String doctorName, String admId, Integer servType, String hospitalId) {
        String hospitalType = this.getHospitalType(hospitalId);
        if (ServiceTypeEnum.HOS.getValue().equals(servType)) {
            PushConfigEnum pushConfigEnum = PushConfigEnum.getPushConfigEnum((String)"fz_time_notice".toLowerCase());
            PushSubscribeMessageReqVO pushSubscribeMessageReqVO = null;
            this.pushUtils.pushSubscribeMessage(pushSubscribeMessageReqVO);
        }
    }

    public void onlineVisitsProgramRefundPush(String doctorName, String patientId, String admId, Integer servType) {
        if (ServiceTypeEnum.HOS.getValue().equals(servType)) {
            PushConfigEnum pushConfigEnum = PushConfigEnum.getPushConfigEnum((String)"order_cancel_notify".toLowerCase());
            PushSubscribeMessageReqVO pushSubscribeMessageReqVO = this.appletPushConfig(doctorName, patientId, pushConfigEnum, admId);
            log.info("\u5728\u7ebf\u54a8\u8be2\u533b\u751f\u9000\u8d39\u63a8\u9001" + JSON.toJSONString((Object)pushSubscribeMessageReqVO));
            if (!admId.startsWith("KFZX")) {
                this.pushUtils.pushSubscribeMessage(pushSubscribeMessageReqVO);
            }
        } else {
            NewPushConfigEnum newPushConfigEnum = NewPushConfigEnum.getPushConfigEnum((String)"order_cancel_notify".toLowerCase());
            PushSubscribeMessageReqVO pushSubscribeMessageReqVO = this.newAppletPushConfig(doctorName, patientId, newPushConfigEnum, admId);
            log.info("\u5728\u7ebf\u590d\u8bca\u533b\u751f\u9000\u8d39\u63a8\u9001" + JSON.toJSONString((Object)pushSubscribeMessageReqVO));
            this.pushUtils.pushSubscribeMessage(pushSubscribeMessageReqVO);
        }
    }

    public void onlineVisitsProgramCompletionPush(String doctorName, String patientId, String admId, Integer servType) {
        if (ServiceTypeEnum.HOS.getValue().equals(servType)) {
            PushConfigEnum pushConfigEnum = PushConfigEnum.getPushConfigEnum((String)"server_finished_notify".toLowerCase());
            PushSubscribeMessageReqVO pushSubscribeMessageReqVO = this.appletPushConfig(doctorName, patientId, pushConfigEnum, admId);
            log.info("\u5728\u7ebf\u54a8\u8be2\u95ee\u8bca\u5b8c\u6210\u63a8\u9001" + JSON.toJSONString((Object)pushSubscribeMessageReqVO));
            if (!admId.startsWith("KFZX")) {
                this.pushUtils.pushSubscribeMessage(pushSubscribeMessageReqVO);
            }
        } else {
            NewPushConfigEnum newPushConfigEnum = NewPushConfigEnum.getPushConfigEnum((String)"server_finished_notify".toLowerCase());
            PushSubscribeMessageReqVO pushSubscribeMessageReqVO = this.newAppletPushConfig(doctorName, patientId, newPushConfigEnum, admId);
            log.info("\u5728\u7ebf\u590d\u8bca\u95ee\u8bca\u5b8c\u6210\u63a8\u9001" + JSON.toJSONString((Object)pushSubscribeMessageReqVO));
            this.pushUtils.pushSubscribeMessage(pushSubscribeMessageReqVO);
        }
    }

    public void onlineVisitsVideoRequestPush(InitiateVideoReqVo param) {
        AdmissionEntity admissionEntity = this.admissionMapper.findById(param.getAdmId());
        if (null == admissionEntity) {
            return;
        }
        OrderEntity orderEntity = (OrderEntity)this.orderMapper.selectById((Serializable)((Object)admissionEntity.getOrderId()));
        if (Objects.equals(3, orderEntity.getKeepOrder())) {
            this.zkImVideoPush(param.getAdmId());
            return;
        }
        String hospitalType = this.getHospitalType(admissionEntity.getOrganId());
        if (ServiceTypeEnum.HOS.getValue().equals(admissionEntity.getServType())) {
            PushConfigEnum pushConfigEnum = null;
            if (Objects.isNull(param.getType()) || Objects.equals("1", param.getType())) {
                pushConfigEnum = PushConfigEnum.getPushConfigEnum((String)"video_request_notify".toLowerCase());
            } else if (Objects.equals("2", param.getType())) {
                pushConfigEnum = PushConfigEnum.getPushConfigEnum((String)"sound_request_notify".toLowerCase());
            }
            PushSubscribeMessageReqVO pushSubscribeMessageReqVO = null;
            if ("1".equals(hospitalType)) {
                pushSubscribeMessageReqVO = this.appletPushConfig(admissionEntity.getDoctorName(), admissionEntity.getPatientId(), pushConfigEnum, param.getAdmId());
            }
            if ("2".equals(hospitalType)) {
                pushSubscribeMessageReqVO = this.MZJHPushConfigForZX(admissionEntity.getDoctorName(), admissionEntity.getPatientId(), pushConfigEnum, param.getAdmId(), this.projProperties.getVedioOnlineTemplateCode());
            }
            log.info("\u5728\u7ebf\u54a8\u8be2\u533b\u751f\u5411\u60a3\u8005\u53d1\u8d77\u89c6\u9891\u63a8\u9001" + JSON.toJSONString((Object)pushSubscribeMessageReqVO));
            if (!param.getAdmId().startsWith("KFZX")) {
                this.pushUtils.pushSubscribeMessage(pushSubscribeMessageReqVO);
            }
        } else {
            NewPushConfigEnum newPushConfigEnum = null;
            if (Objects.isNull(param.getType()) || Objects.equals("1", param.getType())) {
                newPushConfigEnum = NewPushConfigEnum.getPushConfigEnum((String)"video_request_notify".toLowerCase());
            } else if (Objects.equals("2", param.getType())) {
                newPushConfigEnum = NewPushConfigEnum.getPushConfigEnum((String)"sound_request_notify".toLowerCase());
            }
            PushSubscribeMessageReqVO pushSubscribeMessageReqVO = null;
            if ("1".equals(hospitalType)) {
                pushSubscribeMessageReqVO = this.newAppletPushConfig(admissionEntity.getDoctorName(), admissionEntity.getPatientId(), newPushConfigEnum, param.getAdmId());
            }
            if ("2".equals(hospitalType)) {
                pushSubscribeMessageReqVO = this.MZJHPushConfigForFZ(admissionEntity.getDoctorName(), admissionEntity.getPatientId(), newPushConfigEnum, param.getAdmId(), this.projProperties.getVedioOnlineTemplateCode());
            }
            log.info("\u5728\u7ebf\u590d\u8bca\u533b\u751f\u5411\u60a3\u8005\u53d1\u8d77\u89c6\u9891\u63a8\u9001" + JSON.toJSONString((Object)pushSubscribeMessageReqVO));
            this.pushUtils.pushSubscribeMessage(pushSubscribeMessageReqVO);
        }
    }

    public void onlineReferralPush(String referralId, Integer servType) throws AdmissionException {
        log.info("referralId:{}" + referralId);
        QueryWrapper queryWrapper = new QueryWrapper();
        DoctorTeamEntity entity = new DoctorTeamEntity();
        entity.setXId(referralId);
        queryWrapper.setEntity((Object)entity);
        DoctorTeamEntity doctorTeamEntity = (DoctorTeamEntity)this.doctorTeamMapper.selectOne((Wrapper)queryWrapper);
        if (null == doctorTeamEntity) {
            return;
        }
        log.info("doctorTeamEntity:{}" + doctorTeamEntity.toString());
        String patientId = doctorTeamEntity.getPatientId();
        String admId = doctorTeamEntity.getAdmissionId();
        String doctorName = doctorTeamEntity.getAdmissionDoctorName();
        if (ServiceTypeEnum.HOS.getValue().equals(servType)) {
            PushConfigEnum pushConfigEnum = PushConfigEnum.getPushConfigEnum((String)"doctor_referred_remind".toLowerCase());
            PushSubscribeMessageReqVO pushSubscribeMessageReqVO = this.appletPushConfig(doctorName, patientId, pushConfigEnum, admId);
            log.info("\u5728\u7ebf\u54a8\u8be2\u8f6c\u8bca\u63a8\u9001" + JSON.toJSONString((Object)pushSubscribeMessageReqVO));
            if (!admId.startsWith("KFZX")) {
                this.pushUtils.pushSubscribeMessage(pushSubscribeMessageReqVO);
            }
        } else {
            NewPushConfigEnum newPushConfigEnum = NewPushConfigEnum.getPushConfigEnum((String)"doctor_referred_remind".toLowerCase());
            PushSubscribeMessageReqVO pushSubscribeMessageReqVO = this.newAppletPushConfig(doctorName, patientId, newPushConfigEnum, admId);
            log.info("\u5728\u7ebf\u590d\u8bca\u533b\u751f\u8f6c\u8bca\u63a8\u9001" + JSON.toJSONString((Object)pushSubscribeMessageReqVO));
            this.pushUtils.pushSubscribeMessage(pushSubscribeMessageReqVO);
        }
    }

    public void onlineVisitsTimeOutPush(String patientId, String doctorName, String admId, Integer servType) {
        if (ServiceTypeEnum.HOS.getValue().equals(servType)) {
            PushConfigEnum pushConfigEnum = PushConfigEnum.getPushConfigEnum((String)"timeout_processing_notification".toLowerCase());
            PushSubscribeMessageReqVO pushSubscribeMessageReqVO = this.appletPushConfig(doctorName, patientId, pushConfigEnum, admId);
            log.info("\u5728\u7ebf\u54a8\u8be2\u533b\u751f\u8d85\u65f6\u672a\u63a5\u8bca\u6d88\u606f\u63a8\u9001" + JSON.toJSONString((Object)pushSubscribeMessageReqVO));
            if (!admId.startsWith("KFZX")) {
                this.pushUtils.pushSubscribeMessage(pushSubscribeMessageReqVO);
            }
        } else {
            NewPushConfigEnum newPushConfigEnum = NewPushConfigEnum.getPushConfigEnum((String)"timeout_processing_notification".toLowerCase());
            PushSubscribeMessageReqVO pushSubscribeMessageReqVO = this.newAppletPushConfig(doctorName, patientId, newPushConfigEnum, admId);
            log.info("\u5728\u7ebf\u590d\u8bca\u533b\u751f\u8d85\u65f6\u672a\u63a5\u8bca\u6d88\u606f\u63a8\u9001" + JSON.toJSONString((Object)pushSubscribeMessageReqVO));
            this.pushUtils.pushSubscribeMessage(pushSubscribeMessageReqVO);
        }
    }

    public void onlineVisitsRefusalPush(String patientId, String doctorName, String admId, Integer servType, String hospitalId) {
        String hospitalType = this.getHospitalType(hospitalId);
        if (ServiceTypeEnum.HOS.getValue().equals(servType)) {
            PushConfigEnum pushConfigEnum = PushConfigEnum.getPushConfigEnum((String)"refusal_treatment_notify".toLowerCase());
            PushSubscribeMessageReqVO pushSubscribeMessageReqVO = null;
            if ("1".equals(hospitalType)) {
                pushSubscribeMessageReqVO = this.appletPushConfig(doctorName, patientId, pushConfigEnum, admId);
            }
            if ("2".equals(hospitalType)) {
                pushSubscribeMessageReqVO = this.MZJHDoctorRefusal(doctorName, patientId, admId, this.projProperties.getDoctorRefuseTemplateCode(), pushConfigEnum.getJumpUrl());
            }
            log.info("\u5728\u7ebf\u54a8\u8be2\u533b\u751f\u62d2\u7edd\u5c31\u8bca\u6d88\u606f\u63a8\u9001" + JSON.toJSONString((Object)pushSubscribeMessageReqVO));
            if (!admId.startsWith("KFZX")) {
                this.pushUtils.pushSubscribeMessage(pushSubscribeMessageReqVO);
            }
        } else {
            NewPushConfigEnum newPushConfigEnum = NewPushConfigEnum.getPushConfigEnum((String)"refusal_treatment_notify".toLowerCase());
            PushSubscribeMessageReqVO pushSubscribeMessageReqVO = null;
            if ("1".equals(hospitalType)) {
                pushSubscribeMessageReqVO = this.newAppletPushConfig(doctorName, patientId, newPushConfigEnum, admId);
            }
            if ("2".equals(hospitalType)) {
                pushSubscribeMessageReqVO = this.MZJHDoctorRefusal(doctorName, patientId, admId, this.projProperties.getDoctorRefuseTemplateCode(), newPushConfigEnum.getJumpUrl());
            }
            log.info("\u5728\u7ebf\u590d\u8bca\u533b\u751f\u62d2\u7edd\u5c31\u8bca\u6d88\u606f\u63a8\u9001" + JSON.toJSONString((Object)pushSubscribeMessageReqVO));
            this.pushUtils.pushSubscribeMessage(pushSubscribeMessageReqVO);
        }
    }

    public void onlineVisitsSeekMedicalAdvicePush(String admissionId, String templateCode, String type) throws AdmissionException {
        log.info("\u4f20\u5165\u7684\u7c7b\u578b\u4e3atype:{}" + type);
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admissionId);
        AdmissionEntity admissionMapperById = this.admissionMapper.findById(admissionId);
        if (null == admissionMapperById) {
            return;
        }
        if (!AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(admissionMapperById.getStatus())) {
            return;
        }
        if (ServiceTypeEnum.HOS.getValue().equals(admissionMapperById.getServType())) {
            PushConfigEnum pushConfigEnum = null;
            if ("0".equals(type)) {
                pushConfigEnum = PushConfigEnum.getPushConfigEnum((String)"treatment_notify".toLowerCase());
            } else if ("1".equals(type)) {
                pushConfigEnum = PushConfigEnum.getPushConfigEnum((String)"treatment_notify".toLowerCase());
            } else if ("2".equals(type)) {
                pushConfigEnum = PushConfigEnum.getPushConfigEnum((String)"treatment_notify_overtime".toLowerCase());
            }
            log.info("pushConfigEnum:{}" + JSON.toJSONString((Object)pushConfigEnum));
            PushSubscribeMessageReqVO pushSubscribeMessageReqVO = this.appletPushConfig(orderEntity.getDoctorName(), orderEntity.getPatientId(), pushConfigEnum, admissionId);
            log.info("\u5728\u7ebf\u54a8\u8be2\u60a3\u80052\u5c0f\u65f6\u672a\u56de\u590d\u6d88\u606f\u63a8\u9001" + JSON.toJSONString((Object)pushSubscribeMessageReqVO));
            if (!admissionId.startsWith("KFZX")) {
                this.pushUtils.pushSubscribeMessage(pushSubscribeMessageReqVO);
            }
        } else {
            NewPushConfigEnum newPushConfigEnum = null;
            if ("0".equals(type)) {
                newPushConfigEnum = NewPushConfigEnum.getPushConfigEnum((String)"treatment_notify".toLowerCase());
            } else if ("1".equals(type)) {
                newPushConfigEnum = NewPushConfigEnum.getPushConfigEnum((String)"treatment_notify".toLowerCase());
            } else if ("2".equals(type)) {
                newPushConfigEnum = NewPushConfigEnum.getPushConfigEnum((String)"treatment_notify_overtime".toLowerCase());
            }
            log.info("newPushConfigEnum:{}" + JSON.toJSONString((Object)newPushConfigEnum));
            PushSubscribeMessageReqVO pushSubscribeMessageReqVO = this.newAppletPushConfig(orderEntity.getDoctorName(), orderEntity.getPatientId(), newPushConfigEnum, admissionId);
            log.info("\u5728\u7ebf\u590d\u8bca\u60a3\u80052\u5c0f\u65f6\u672a\u56de\u590d\u6d88\u606f\u63a8\u9001" + JSON.toJSONString((Object)pushSubscribeMessageReqVO));
            this.pushUtils.pushSubscribeMessage(pushSubscribeMessageReqVO);
        }
    }

    public void doctorCloseSchedule(String doctorName, String admissionId) {
        AdmissionEntity admissionMapperById = this.admissionMapper.findById(admissionId);
        log.info("admissionMapperById:{}" + JSON.toJSONString((Object)admissionMapperById));
        PushSubscribeMessageReqVO pushSubscribeMessageReqVO = null;
        if (ServiceTypeEnum.HOS.getValue().equals(admissionMapperById.getServType())) {
            PushConfigEnum pushConfigEnum = PushConfigEnum.getPushConfigEnum((String)"doctor_close_schedule".toLowerCase());
            log.info("pushConfigEnum:{}" + JSON.toJSONString((Object)pushConfigEnum));
            pushSubscribeMessageReqVO = this.appletPushConfig(doctorName, admissionMapperById.getPatientId(), pushConfigEnum, admissionId);
        } else {
            NewPushConfigEnum newPushConfigEnum = NewPushConfigEnum.getPushConfigEnum((String)"doctor_close_schedule".toLowerCase());
            pushSubscribeMessageReqVO = this.newAppletPushConfig(doctorName, admissionMapperById.getPatientId(), newPushConfigEnum, admissionId);
            log.info("newPushConfigEnum:{}" + JSON.toJSONString((Object)newPushConfigEnum));
        }
        log.info("\u533b\u751f\u505c\u8bca\u5c0f\u7a0b\u5e8f\u63a8\u9001" + JSON.toJSONString((Object)pushSubscribeMessageReqVO));
        if (!admissionId.startsWith("KFZX")) {
            this.pushUtils.pushSubscribeMessage(pushSubscribeMessageReqVO);
        }
        log.info("\u533b\u751f\u505c\u8bca\u5c0f\u7a0b\u5e8f\u63a8\u9001\u6210\u529f");
    }

    public void patientWaiteRemind(String admissionId) {
        AdmissionEntity admissionEntity = this.admissionMapper.findById(admissionId);
        if (null == admissionEntity) {
            return;
        }
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admissionId);
        if (null == orderEntity) {
            return;
        }
        String scheduleStartTime = orderEntity.getScheduleStartTime();
        String scheduleEndTime = orderEntity.getScheduleEndTime();
        String waiteTime = scheduleStartTime + "-" + scheduleEndTime;
        if (ServiceTypeEnum.HOS.getValue().equals(admissionEntity.getServType())) {
            PushConfigEnum pushConfigEnum = PushConfigEnum.getPushConfigEnum((String)"waiting_reminder".toLowerCase());
            PushSubscribeMessageReqVO pushSubscribeMessageReqVO = this.waiteAppletPushConfig(admissionEntity.getDoctorName(), admissionEntity.getPatientId(), pushConfigEnum, admissionId, waiteTime);
            log.info("\u60a3\u8005\u5019\u8bca\u63d0\u9192\u63a8\u9001" + JSON.toJSONString((Object)pushSubscribeMessageReqVO));
            if (!admissionId.startsWith("KFZX")) {
                this.pushUtils.pushSubscribeMessage(pushSubscribeMessageReqVO);
            }
        } else {
            NewPushConfigEnum newPushConfigEnum = NewPushConfigEnum.getPushConfigEnum((String)"waiting_reminder".toLowerCase());
            PushSubscribeMessageReqVO pushSubscribeMessageReqVO = this.watieNewAppletPushConfig(admissionEntity.getDoctorName(), admissionEntity.getPatientId(), newPushConfigEnum, admissionId, waiteTime);
            log.info("\u60a3\u8005\u5019\u8bca\u63d0\u9192\u63a8\u9001" + JSON.toJSONString((Object)pushSubscribeMessageReqVO));
            this.pushUtils.pushSubscribeMessage(pushSubscribeMessageReqVO);
        }
    }

    public void passNumber(String admissionId, String hospitalId) {
        AdmissionEntity admissionEntity = this.admissionMapper.findById(admissionId);
        if (null == admissionEntity) {
            return;
        }
        String hospitalType = this.getHospitalType(hospitalId);
        NewPushConfigEnum newPushConfigEnum = NewPushConfigEnum.getPushConfigEnum((String)"pass_number".toLowerCase());
        PushSubscribeMessageReqVO pushSubscribeMessageReqVO = null;
        if ("1".equals(hospitalType)) {
            pushSubscribeMessageReqVO = this.newAppletPushConfig(admissionEntity.getDoctorName(), admissionEntity.getPatientId(), newPushConfigEnum, admissionId);
        }
        if ("2".equals(hospitalType)) {
            pushSubscribeMessageReqVO = this.MZJHPassNumber(admissionEntity.getDoctorName(), admissionEntity.getPatientId(), admissionEntity.getXId(), this.projProperties.getPassNumberTemplateCode(), newPushConfigEnum);
        }
        log.info("\u60a3\u8005\u8fc7\u53f7\u63a8\u9001" + JSON.toJSONString((Object)pushSubscribeMessageReqVO));
        if (!admissionId.startsWith("KFZX")) {
            this.pushUtils.pushSubscribeMessage(pushSubscribeMessageReqVO);
        }
    }

    @Async
    public void zkImVideoPush(String admId) {
        NewPushConfigEnum newPushConfigEnum = NewPushConfigEnum.getPushConfigEnum((String)NewPushConfigEnum.ZK_VIDEO_NOTIC.getTemplateCode());
        PushSubscribeMessageReqVO pushSubscribeMessageReqVO = this.zkNewPushConfig(newPushConfigEnum, admId, "inquiry_notice");
        pushSubscribeMessageReqVO.setPage("/pages/orderDetail/index?id=" + admId);
        log.info("\u4f17\u5eb7\u6781\u901f\u8d2d\u836f\u89c6\u9891\u63a8\u9001" + JSON.toJSONString((Object)pushSubscribeMessageReqVO));
        try {
            String body = HttpKit.jsonPost((String)this.projProperties.getWechatpushUrl(), (String)JSON.toJSONString((Object)pushSubscribeMessageReqVO));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("\u5c0f\u7a0b\u5e8f\u8ba2\u9605\u63a8\u9001\u8fd4\u56de\u503cbaseResponse: " + baseResponse.toString());
        }
        catch (Exception e) {
            log.error("\u5c0f\u7a0b\u5e8f\u8ba2\u9605\u63a8\u9001\u5931\u8d25" + e.getMessage());
        }
    }

    @Async
    public void zkDoctorRefund(String admId) {
        NewPushConfigEnum newPushConfigEnum = NewPushConfigEnum.getPushConfigEnum((String)NewPushConfigEnum.ZK_DOCTOR_REFUND.getTemplateCode());
        PushSubscribeMessageReqVO pushSubscribeMessageReqVO = this.zkNewPushConfig(newPushConfigEnum, admId, "inquiry_exception_notice");
        pushSubscribeMessageReqVO.setPage("/pages/orderDetail/index?id=" + admId);
        log.info("\u4f17\u5eb7\u533b\u751f\u62d2\u7edd\u5f00\u836f\u63a8\u9001" + JSON.toJSONString((Object)pushSubscribeMessageReqVO));
        try {
            String body = HttpKit.jsonPost((String)this.projProperties.getWechatpushUrl(), (String)JSON.toJSONString((Object)pushSubscribeMessageReqVO));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("\u5c0f\u7a0b\u5e8f\u8ba2\u9605\u63a8\u9001\u8fd4\u56de\u503cbaseResponse: " + baseResponse.toString());
        }
        catch (Exception e) {
            log.error("\u5c0f\u7a0b\u5e8f\u8ba2\u9605\u63a8\u9001\u5931\u8d25" + e.getMessage());
        }
    }

    public void referralForManager(String referralId, String hospitalId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        DoctorTeamEntity entity = new DoctorTeamEntity();
        entity.setXId(referralId);
        queryWrapper.setEntity((Object)entity);
        DoctorTeamEntity doctorTeamEntity = (DoctorTeamEntity)this.doctorTeamMapper.selectOne((Wrapper)queryWrapper);
        if (null == doctorTeamEntity) {
            return;
        }
        AdmissionEntity admissionEntity = this.admissionMapper.findById(doctorTeamEntity.getAdmissionId());
        if (null == admissionEntity) {
            return;
        }
        String hospitalType = this.getHospitalType(hospitalId);
        NewPushConfigEnum newPushConfigEnum = NewPushConfigEnum.getPushConfigEnum((String)"referral_manager".toLowerCase());
        PushSubscribeMessageReqVO pushSubscribeMessageReqVO = null;
        if ("1".equals(hospitalType)) {
            pushSubscribeMessageReqVO = this.newAppletPushConfig(admissionEntity.getDoctorName(), admissionEntity.getPatientId(), newPushConfigEnum, doctorTeamEntity.getAdmissionId());
        }
        if ("2".equals(hospitalType)) {
            pushSubscribeMessageReqVO = this.MZJHReferralForManager(doctorTeamEntity, admissionEntity.getPatientId(), admissionEntity, this.projProperties.getReferralForManageTemplateCode(), newPushConfigEnum);
        }
        log.info("\u60a3\u8005\u8fc7\u53f7\u63a8\u9001" + JSON.toJSONString((Object)pushSubscribeMessageReqVO));
        this.pushUtils.pushSubscribeMessage(pushSubscribeMessageReqVO);
    }

    public void OverdueFollowUp(String admissionId) {
        AdmissionEntity admissionEntity = this.admissionMapper.queryAdmByOrderId(admissionId);
        if (null == admissionEntity) {
            return;
        }
        NewPushConfigEnum newPushConfigEnum = NewPushConfigEnum.getPushConfigEnum((String)"fz_time_notice".toLowerCase());
        PushSubscribeMessageReqVO pushSubscribeMessageReqVO = null;
        pushSubscribeMessageReqVO = this.overdueFollowUpPushConfig(admissionEntity.getPatientId(), newPushConfigEnum, admissionEntity.getXId(), "fz_time_notice".toLowerCase());
        log.info("\u590d\u8bca\u8fc715\u5929\u63a8\u9001" + JSON.toJSONString((Object)pushSubscribeMessageReqVO));
        this.pushUtils.pushSubscribeMessage(pushSubscribeMessageReqVO);
    }

    private PatientEntity getUserIdByPatient(String patientId) {
        PatientEntity oneByPatientId = this.patientMapper.findOneByPatientId(patientId);
        return oneByPatientId;
    }

    private String wxAuthByCondition(String userId) {
        log.info("userId:{}" + userId);
        UcWxAuthReqVo ucWxAuthReqVo = new UcWxAuthReqVo();
        ucWxAuthReqVo.setUserId(userId);
        ucWxAuthReqVo.setStatus(Short.valueOf((short)1));
        ucWxAuthReqVo.setUserType(Short.valueOf((short)0));
        log.info("=======\u5f97\u5230oprnId{}========" + JSON.toJSONString((Object)ucWxAuthReqVo));
        BaseResponse wxAuthByCondition = this.nodeAccountClient.getWxAuthByCondition(ucWxAuthReqVo);
        log.info("\u5f97\u5230oprnId{}" + JSON.toJSONString((Object)wxAuthByCondition));
        if (wxAuthByCondition.getData() == null) {
            log.info("=================\u67e5\u8be2oprnId\u5931\u8d25==\u63a8\u9001\u5931\u8d25==============");
            return null;
        }
        return ((UcWxAuthRespVo)wxAuthByCondition.getData()).getWxOpenid();
    }

    private String wxAuthByConditionZK(String userId) {
        log.info("userId:{}" + userId);
        UcWxAuthReqVo ucWxAuthReqVo = new UcWxAuthReqVo();
        ucWxAuthReqVo.setUserId(userId);
        ucWxAuthReqVo.setStatus(Short.valueOf((short)1));
        ucWxAuthReqVo.setUserType(Short.valueOf((short)4));
        log.info("=======\u5f97\u5230oprnId{}========" + JSON.toJSONString((Object)ucWxAuthReqVo));
        BaseResponse wxAuthByCondition = this.nodeAccountClient.getWxAuthByCondition(ucWxAuthReqVo);
        log.info("\u5f97\u5230oprnId{}" + JSON.toJSONString((Object)wxAuthByCondition));
        if (wxAuthByCondition.getData() == null) {
            log.info("=================\u67e5\u8be2oprnId\u5931\u8d25==\u63a8\u9001\u5931\u8d25==============");
            return null;
        }
        return ((UcWxAuthRespVo)wxAuthByCondition.getData()).getWxOpenid();
    }

    private String schedule(Date scheduleDate, Integer scheduleRange) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        String scheduleDateStr = formatter.format(scheduleDate);
        String scheduleTime = "";
        if (ScheduleRecordEnum.MORNING.getValue().equals(scheduleRange)) {
            scheduleTime = scheduleDateStr + " " + MORNING_START;
        }
        if (ScheduleRecordEnum.AFTERNOON.getValue().equals(scheduleRange)) {
            scheduleTime = scheduleDateStr + " " + AFTERNOON_START;
        }
        if (ScheduleRecordEnum.EVENING.getValue().equals(scheduleRange)) {
            scheduleTime = scheduleDateStr + " " + EVENING_START;
        }
        return scheduleTime;
    }

    private String getWeChatClientCode(String admId) {
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (orderEntity == null) {
            return null;
        }
        String appCode = orderEntity.getAppCode();
        PushConfigurationDetailVO pushConfig = this.pushUtils.getPushConfig(appCode, "weChatApplets", "patient", "weChatApplets");
        if (null == pushConfig) {
            return null;
        }
        return pushConfig.getClientCode();
    }

    private PushSubscribeMessageReqVO appletPushConfig(String doctorName, String patientId, PushConfigEnum pushConfigEnum, String admId) {
        PatientEntity userIdByPatient = this.getUserIdByPatient(patientId);
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (null == orderEntity) {
            log.error("\u83b7\u53d6\u7684\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a" + admId);
            return null;
        }
        String openId = StringUtils.isNotEmpty((String)orderEntity.getPatientUserId()) ? this.wxAuthByCondition(orderEntity.getPatientUserId()) : this.wxAuthByCondition(userIdByPatient.getUserId());
        if (openId == null) {
            return null;
        }
        PushSubscribeMessageReqVO pushSubscribeMessageReqVO = new PushSubscribeMessageReqVO();
        pushSubscribeMessageReqVO.setOpenId(openId);
        pushSubscribeMessageReqVO.setClientCode(this.getWeChatClientCode(admId));
        pushSubscribeMessageReqVO.setTemplateCode(this.projProperties.getWxTemplateCode());
        pushSubscribeMessageReqVO.setPage(pushConfigEnum.getJumpUrl());
        LinkedHashMap data = new LinkedHashMap();
        HashMap<String, String> doctorNameMap = new HashMap<String, String>(10);
        doctorNameMap.put("value", doctorName);
        data.put("\u54a8\u8be2\u533b\u751f", doctorNameMap);
        HashMap<String, String> hintMap = new HashMap<String, String>(10);
        hintMap.put("value", pushConfigEnum.getHint());
        data.put("\u63d0\u793a\u8bf4\u660e", hintMap);
        HashMap<String, String> markMap = new HashMap<String, String>(10);
        markMap.put("value", pushConfigEnum.getPromptContent());
        data.put("\u63d0\u793a\u5185\u5bb9", markMap);
        pushSubscribeMessageReqVO.setData(data);
        log.info("data" + JSON.toJSONString(data));
        return pushSubscribeMessageReqVO;
    }

    private PushSubscribeMessageReqVO waiteAppletPushConfig(String doctorName, String patientId, PushConfigEnum pushConfigEnum, String admId, String waiteTime) {
        PatientEntity userIdByPatient = this.getUserIdByPatient(patientId);
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (null == orderEntity) {
            log.error("\u83b7\u53d6\u7684\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a" + admId);
            return null;
        }
        String openId = StringUtils.isNotEmpty((String)orderEntity.getPatientUserId()) ? this.wxAuthByCondition(orderEntity.getPatientUserId()) : this.wxAuthByCondition(userIdByPatient.getUserId());
        if (openId == null) {
            return null;
        }
        PushSubscribeMessageReqVO pushSubscribeMessageReqVO = new PushSubscribeMessageReqVO();
        pushSubscribeMessageReqVO.setOpenId(openId);
        pushSubscribeMessageReqVO.setClientCode(this.getWeChatClientCode(admId));
        pushSubscribeMessageReqVO.setTemplateCode(this.projProperties.getWxTemplateCode());
        pushSubscribeMessageReqVO.setPage(pushConfigEnum.getJumpUrl());
        LinkedHashMap data = new LinkedHashMap();
        HashMap<String, String> doctorNameMap = new HashMap<String, String>(10);
        doctorNameMap.put("value", doctorName);
        data.put("\u54a8\u8be2\u533b\u751f", doctorNameMap);
        HashMap<String, String> hintMap = new HashMap<String, String>(10);
        hintMap.put("value", pushConfigEnum.getHint());
        data.put("\u63d0\u793a\u8bf4\u660e", hintMap);
        HashMap<String, String> markMap = new HashMap<String, String>(10);
        markMap.put("value", pushConfigEnum.getPromptContent());
        data.put("\u63d0\u793a\u5185\u5bb9", markMap);
        pushSubscribeMessageReqVO.setData(data);
        log.info("data" + JSON.toJSONString(data));
        return pushSubscribeMessageReqVO;
    }

    private PushSubscribeMessageReqVO overdueFollowUpPushConfig(String patientId, NewPushConfigEnum newPushConfigEnum, String admId, String templateCode) {
        PatientEntity userIdByPatient = this.getUserIdByPatient(patientId);
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (null == orderEntity) {
            log.error("\u83b7\u53d6\u7684\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a" + admId);
            return null;
        }
        String openId = StringUtils.isNotEmpty((String)orderEntity.getPatientUserId()) ? this.wxAuthByCondition(orderEntity.getPatientUserId()) : this.wxAuthByCondition(userIdByPatient.getUserId());
        if (openId == null) {
            return null;
        }
        PushSubscribeMessageReqVO pushSubscribeMessageReqVO = new PushSubscribeMessageReqVO();
        pushSubscribeMessageReqVO.setOpenId(openId);
        pushSubscribeMessageReqVO.setClientCode(this.getWeChatClientCode(admId));
        pushSubscribeMessageReqVO.setTemplateCode(templateCode);
        pushSubscribeMessageReqVO.setPage("furtherConsultation/pages/onlineOutPatient/onlineOutPatient");
        LinkedHashMap data = new LinkedHashMap();
        HashMap<String, String> hospitalMap = new HashMap<String, String>(10);
        hospitalMap.put("value", "\u5b9c\u6625\u5e02\u4eba\u6c11\u533b\u9662\u4e92\u8054\u7f51\u533b\u9662");
        data.put("\u533b\u9662", hospitalMap);
        HashMap<String, String> patientMap = new HashMap<String, String>(10);
        patientMap.put("value", userIdByPatient.getPatientName());
        data.put("\u5c31\u8bca\u4eba", patientMap);
        HashMap<String, String> hintMap = new HashMap<String, String>(10);
        hintMap.put("value", "\u60a8\u597d\uff01\u8ddd\u60a8\u4e0a\u6b21\u5c31\u8bca\u5df2\u4e00\u6bb5\u65f6\u95f4\uff0c\u8bb0\u5f97\u590d\u8bca\u3002");
        data.put("\u6e29\u99a8\u63d0\u793a", hintMap);
        HashMap<String, String> ramarkMap = new HashMap<String, String>(10);
        ramarkMap.put("value", "\u4e92\u8054\u7f51\u533b\u9662\u5728\u7ebf\u590d\u8bca\u3001\u9001\u836f\u5230\u5bb6\u3001\u62a4\u7406\u4e0a\u95e8\uff01");
        data.put("\u5907\u6ce8", ramarkMap);
        pushSubscribeMessageReqVO.setData(data);
        log.info("data" + JSON.toJSONString(data));
        return pushSubscribeMessageReqVO;
    }

    private PushSubscribeMessageReqVO newAppletPushConfig(String doctorName, String patientId, NewPushConfigEnum newPushConfigEnum, String admId) {
        PatientEntity userIdByPatient = this.getUserIdByPatient(patientId);
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (null == orderEntity) {
            log.error("\u83b7\u53d6\u7684\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a" + admId);
            return null;
        }
        String openId = StringUtils.isNotEmpty((String)orderEntity.getPatientUserId()) ? this.wxAuthByCondition(orderEntity.getPatientUserId()) : this.wxAuthByCondition(userIdByPatient.getUserId());
        if (openId == null) {
            return null;
        }
        PushSubscribeMessageReqVO pushSubscribeMessageReqVO = new PushSubscribeMessageReqVO();
        pushSubscribeMessageReqVO.setOpenId(openId);
        pushSubscribeMessageReqVO.setClientCode(this.getWeChatClientCode(admId));
        pushSubscribeMessageReqVO.setTemplateCode(this.projProperties.getWxTemplateCode());
        pushSubscribeMessageReqVO.setPage(newPushConfigEnum.getJumpUrl());
        LinkedHashMap data = new LinkedHashMap();
        HashMap<String, String> doctorNameMap = new HashMap<String, String>(10);
        doctorNameMap.put("value", doctorName);
        data.put("\u590d\u8bca\u533b\u751f", doctorNameMap);
        HashMap<String, String> hintMap = new HashMap<String, String>(10);
        hintMap.put("value", newPushConfigEnum.getHint());
        data.put("\u63d0\u793a\u8bf4\u660e", hintMap);
        HashMap<String, String> markMap = new HashMap<String, String>(10);
        markMap.put("value", newPushConfigEnum.getPromptContent());
        data.put("\u63d0\u793a\u5185\u5bb9", markMap);
        pushSubscribeMessageReqVO.setData(data);
        log.info("data" + JSON.toJSONString(data));
        return pushSubscribeMessageReqVO;
    }

    private PushSubscribeMessageReqVO watieNewAppletPushConfig(String doctorName, String patientId, NewPushConfigEnum newPushConfigEnum, String admId, String waiteTime) {
        PatientEntity userIdByPatient = this.getUserIdByPatient(patientId);
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (null == orderEntity) {
            log.error("\u83b7\u53d6\u7684\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a" + admId);
            return null;
        }
        String openId = StringUtils.isNotEmpty((String)orderEntity.getPatientUserId()) ? this.wxAuthByCondition(orderEntity.getPatientUserId()) : this.wxAuthByCondition(userIdByPatient.getUserId());
        if (openId == null) {
            return null;
        }
        PushSubscribeMessageReqVO pushSubscribeMessageReqVO = new PushSubscribeMessageReqVO();
        pushSubscribeMessageReqVO.setOpenId(openId);
        pushSubscribeMessageReqVO.setClientCode(this.getWeChatClientCode(admId));
        pushSubscribeMessageReqVO.setTemplateCode(this.projProperties.getWxTemplateCode());
        pushSubscribeMessageReqVO.setPage(newPushConfigEnum.getJumpUrl());
        LinkedHashMap data = new LinkedHashMap();
        HashMap<String, String> doctorNameMap = new HashMap<String, String>(10);
        doctorNameMap.put("value", doctorName);
        data.put("\u590d\u8bca\u533b\u751f", doctorNameMap);
        HashMap<String, String> hintMap = new HashMap<String, String>(10);
        hintMap.put("value", newPushConfigEnum.getHint());
        data.put("\u63d0\u793a\u8bf4\u660e", hintMap);
        HashMap<String, String> markMap = new HashMap<String, String>(10);
        markMap.put("value", newPushConfigEnum.getPromptContent());
        data.put("\u63d0\u793a\u5185\u5bb9", markMap);
        pushSubscribeMessageReqVO.setData(data);
        log.info("data" + JSON.toJSONString(data));
        return pushSubscribeMessageReqVO;
    }

    private String getHospitalType(String hospitalId) {
        QueryOrganDetailDTO queryOrganDetailDTO = new QueryOrganDetailDTO();
        queryOrganDetailDTO.setOrganId(Integer.valueOf(Integer.parseInt(hospitalId)));
        BaseResponse hospitalTypeBase = this.organDetailClient.queryOrganDetail(queryOrganDetailDTO);
        if (!hospitalTypeBase.isSuccess()) {
            return null;
        }
        log.info("\u533b\u9662\u7c7b\u578b:{}", (Object)JSON.toJSONString((Object)((QueryOrganDetailVO)hospitalTypeBase.getData()).getIsPublic()));
        return ((QueryOrganDetailVO)hospitalTypeBase.getData()).getIsPublic().toString();
    }

    private PushSubscribeMessageReqVO MZJHPushConfigForZX(String doctorName, String patientId, PushConfigEnum pushConfigEnum, String admId, String templateCode) {
        PatientEntity userIdByPatient = this.getUserIdByPatient(patientId);
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (null == orderEntity) {
            log.error("\u83b7\u53d6\u7684\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a" + admId);
            return null;
        }
        String openId = StringUtils.isNotEmpty((String)orderEntity.getPatientUserId()) ? this.wxAuthByCondition(orderEntity.getPatientUserId()) : this.wxAuthByCondition(userIdByPatient.getUserId());
        if (openId == null) {
            return null;
        }
        PushSubscribeMessageReqVO pushSubscribeMessageReqVO = new PushSubscribeMessageReqVO();
        pushSubscribeMessageReqVO.setOpenId(openId);
        pushSubscribeMessageReqVO.setClientCode(this.getWeChatClientCode(admId));
        pushSubscribeMessageReqVO.setTemplateCode(templateCode);
        pushSubscribeMessageReqVO.setPage(pushConfigEnum.getJumpUrl());
        LinkedHashMap data = new LinkedHashMap();
        HashMap<String, String> doctorNameMap = new HashMap<String, String>(10);
        doctorNameMap.put("value", doctorName);
        data.put("\u9884\u7ea6\u533b\u751f", doctorNameMap);
        HashMap<String, String> hintMap = new HashMap<String, String>(10);
        hintMap.put("value", pushConfigEnum.getHint());
        data.put("\u63d0\u793a\u7c7b\u578b", hintMap);
        HashMap<String, String> markMap = new HashMap<String, String>(10);
        markMap.put("value", pushConfigEnum.getPromptContent());
        data.put("\u6e29\u99a8\u63d0\u793a", markMap);
        pushSubscribeMessageReqVO.setData(data);
        log.info("data" + JSON.toJSONString(data));
        return pushSubscribeMessageReqVO;
    }

    private PushSubscribeMessageReqVO MZJHPushConfigForFZ(String doctorName, String patientId, NewPushConfigEnum newPushConfigEnum, String admId, String templateCode) {
        PatientEntity userIdByPatient = this.getUserIdByPatient(patientId);
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (null == orderEntity) {
            log.error("\u83b7\u53d6\u7684\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a" + admId);
            return null;
        }
        String openId = StringUtils.isNotEmpty((String)orderEntity.getPatientUserId()) ? this.wxAuthByCondition(orderEntity.getPatientUserId()) : this.wxAuthByCondition(userIdByPatient.getUserId());
        if (openId == null) {
            return null;
        }
        PushSubscribeMessageReqVO pushSubscribeMessageReqVO = new PushSubscribeMessageReqVO();
        pushSubscribeMessageReqVO.setOpenId(openId);
        pushSubscribeMessageReqVO.setClientCode(this.getWeChatClientCode(admId));
        pushSubscribeMessageReqVO.setTemplateCode(templateCode);
        pushSubscribeMessageReqVO.setPage(newPushConfigEnum.getJumpUrl());
        LinkedHashMap data = new LinkedHashMap();
        HashMap<String, String> doctorNameMap = new HashMap<String, String>(10);
        doctorNameMap.put("value", doctorName);
        data.put("\u9884\u7ea6\u533b\u751f", doctorNameMap);
        HashMap<String, String> hintMap = new HashMap<String, String>(10);
        hintMap.put("value", newPushConfigEnum.getHint());
        data.put("\u63d0\u793a\u7c7b\u578b", hintMap);
        HashMap<String, String> markMap = new HashMap<String, String>(10);
        markMap.put("value", newPushConfigEnum.getPromptContent());
        data.put("\u6e29\u99a8\u63d0\u793a", markMap);
        pushSubscribeMessageReqVO.setData(data);
        log.info("data" + JSON.toJSONString(data));
        return pushSubscribeMessageReqVO;
    }

    private PushSubscribeMessageReqVO MZJHDoctorRefusal(String doctorName, String patientId, String admId, String templateCode, String jumpUrl) {
        PatientEntity userIdByPatient = this.getUserIdByPatient(patientId);
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (null == orderEntity) {
            log.error("\u83b7\u53d6\u7684\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a" + admId);
            return null;
        }
        PatientEntity patientEntity = this.patientMapper.selectById(patientId);
        QueryWrapper admWrapper = new QueryWrapper();
        AdmissionEntity admissionEntity = new AdmissionEntity();
        admissionEntity.setXId(admId);
        admWrapper.setEntity((Object)admissionEntity);
        AdmissionEntity admission = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)admWrapper);
        if (null == admission) {
            log.info("\u5c31\u8bca\u8bb0\u5f55\u4e3a\u7a7a");
            return null;
        }
        String openId = StringUtils.isNotEmpty((String)orderEntity.getPatientUserId()) ? this.wxAuthByCondition(orderEntity.getPatientUserId()) : this.wxAuthByCondition(userIdByPatient.getUserId());
        if (openId == null) {
            return null;
        }
        PushSubscribeMessageReqVO pushSubscribeMessageReqVO = new PushSubscribeMessageReqVO();
        pushSubscribeMessageReqVO.setOpenId(openId);
        pushSubscribeMessageReqVO.setClientCode(this.getWeChatClientCode(admId));
        pushSubscribeMessageReqVO.setTemplateCode(templateCode);
        pushSubscribeMessageReqVO.setPage(jumpUrl);
        LinkedHashMap data = new LinkedHashMap();
        HashMap<String, String> patientNameMap = new HashMap<String, String>(10);
        patientNameMap.put("value", patientEntity.getPatientName());
        data.put("\u60a3\u8005", patientNameMap);
        HashMap<String, String> doctorNameMap = new HashMap<String, String>(10);
        doctorNameMap.put("value", doctorName);
        data.put("\u533b\u751f\u59d3\u540d", doctorNameMap);
        HashMap<String, String> markMap = new HashMap<String, String>(10);
        markMap.put("value", admission.getMessage());
        data.put("\u62d2\u7edd\u539f\u56e0", markMap);
        pushSubscribeMessageReqVO.setData(data);
        return pushSubscribeMessageReqVO;
    }

    private PushSubscribeMessageReqVO MZJHPassNumber(String doctorName, String patientId, String admId, String templateCode, NewPushConfigEnum newPushConfigEnum) {
        PatientEntity userIdByPatient = this.getUserIdByPatient(patientId);
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (null == orderEntity) {
            log.error("\u83b7\u53d6\u7684\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a" + admId);
            return null;
        }
        PatientEntity patientEntity = this.patientMapper.selectById(patientId);
        QueryWrapper admWrapper = new QueryWrapper();
        AdmissionEntity admissionEntity = new AdmissionEntity();
        admissionEntity.setXId(admId);
        admWrapper.setEntity((Object)admissionEntity);
        AdmissionEntity admission = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)admWrapper);
        if (null == admission) {
            log.info("\u5c31\u8bca\u8bb0\u5f55\u4e3a\u7a7a");
            return null;
        }
        String openId = StringUtils.isNotEmpty((String)orderEntity.getPatientUserId()) ? this.wxAuthByCondition(orderEntity.getPatientUserId()) : this.wxAuthByCondition(userIdByPatient.getUserId());
        if (openId == null) {
            return null;
        }
        PushSubscribeMessageReqVO pushSubscribeMessageReqVO = new PushSubscribeMessageReqVO();
        pushSubscribeMessageReqVO.setOpenId(openId);
        pushSubscribeMessageReqVO.setClientCode(this.getWeChatClientCode(admId));
        pushSubscribeMessageReqVO.setTemplateCode(templateCode);
        pushSubscribeMessageReqVO.setPage(newPushConfigEnum.getJumpUrl());
        LinkedHashMap data = new LinkedHashMap();
        HashMap<String, String> patientNameMap = new HashMap<String, String>(10);
        patientNameMap.put("value", patientEntity.getPatientName());
        data.put("\u5c31\u8bca\u4eba", patientNameMap);
        HashMap<String, String> doctorNameMap = new HashMap<String, String>(10);
        doctorNameMap.put("value", doctorName);
        data.put("\u9884\u7ea6\u533b\u751f", doctorNameMap);
        HashMap<String, String> markMap = new HashMap<String, String>(10);
        markMap.put("value", newPushConfigEnum.getPromptContent());
        data.put("\u5907\u6ce8", markMap);
        pushSubscribeMessageReqVO.setData(data);
        return pushSubscribeMessageReqVO;
    }

    private PushSubscribeMessageReqVO MZJHReferralForManager(DoctorTeamEntity doctorTeamEntity, String patientId, AdmissionEntity admissionEntity, String templateCode, NewPushConfigEnum newPushConfigEnum) {
        PatientEntity userIdByPatient = this.getUserIdByPatient(patientId);
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admissionEntity.getXId());
        if (null == orderEntity) {
            log.error("\u83b7\u53d6\u7684\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a" + admissionEntity.getXId());
            return null;
        }
        QueryWrapper admNewWrapper = new QueryWrapper();
        AdmissionEntity admissionNewEntity = new AdmissionEntity();
        admissionNewEntity.setXId(doctorTeamEntity.getAdmissionIdNew());
        admNewWrapper.setEntity((Object)admissionNewEntity);
        AdmissionEntity admissionNew = (AdmissionEntity)this.admissionMapper.selectOne((Wrapper)admNewWrapper);
        if (null == admissionNew) {
            log.info("\u5c31\u8bca\u8bb0\u5f55\u4e3a\u7a7a");
            return null;
        }
        String openId = StringUtils.isNotEmpty((String)orderEntity.getPatientUserId()) ? this.wxAuthByCondition(orderEntity.getPatientUserId()) : this.wxAuthByCondition(userIdByPatient.getUserId());
        if (openId == null) {
            return null;
        }
        PushSubscribeMessageReqVO pushSubscribeMessageReqVO = new PushSubscribeMessageReqVO();
        pushSubscribeMessageReqVO.setOpenId(openId);
        pushSubscribeMessageReqVO.setClientCode(this.getWeChatClientCode(admissionEntity.getXId()));
        pushSubscribeMessageReqVO.setTemplateCode(templateCode);
        pushSubscribeMessageReqVO.setPage(newPushConfigEnum.getJumpUrl());
        LinkedHashMap data = new LinkedHashMap();
        HashMap<String, String> patientNameMap = new HashMap<String, String>(10);
        patientNameMap.put("value", admissionEntity.getDoctorName());
        data.put("\u8f6c\u51fa\u533b\u751f", patientNameMap);
        HashMap<String, String> doctorNameMap = new HashMap<String, String>(10);
        doctorNameMap.put("value", admissionNew.getDoctorName());
        data.put("\u8f6c\u5165\u533b\u751f", doctorNameMap);
        HashMap<String, String> markMap = new HashMap<String, String>(10);
        markMap.put("value", newPushConfigEnum.getPromptContent());
        data.put("\u5907\u6ce8", markMap);
        pushSubscribeMessageReqVO.setData(data);
        return pushSubscribeMessageReqVO;
    }

    private PushSubscribeMessageReqVO zkNewPushConfig(NewPushConfigEnum pushConfigEnum, String admId, String templateCode) {
        OrderEntity orderEntity = this.orderMapper.findByAdmId(admId);
        if (null == orderEntity) {
            log.error("\u83b7\u53d6\u7684\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a" + admId);
            return null;
        }
        PatientEntity userIdByPatient = this.getUserIdByPatient(orderEntity.getPatientId());
        String openId = StringUtils.isNotEmpty((String)orderEntity.getPatientUserId()) ? this.wxAuthByConditionZK(orderEntity.getPatientUserId()) : this.wxAuthByConditionZK(userIdByPatient.getUserId());
        if (openId == null) {
            return null;
        }
        PushSubscribeMessageReqVO pushSubscribeMessageReqVO = new PushSubscribeMessageReqVO();
        pushSubscribeMessageReqVO.setOpenId(openId);
        pushSubscribeMessageReqVO.setClientCode("WX_NCZK-JSGY");
        pushSubscribeMessageReqVO.setTemplateCode(templateCode);
        LinkedHashMap data = new LinkedHashMap();
        HashMap<String, String> doctorNameMap = new HashMap<String, String>();
        doctorNameMap.put("value", orderEntity.getDoctorName());
        data.put("\u54a8\u8be2\u533b\u751f", doctorNameMap);
        HashMap<String, String> hintMap = new HashMap<String, String>();
        hintMap.put("value", pushConfigEnum.getHint());
        data.put("\u63d0\u793a\u8bf4\u660e", hintMap);
        HashMap<String, String> markMap = new HashMap<String, String>();
        markMap.put("value", pushConfigEnum.getPromptContent());
        data.put("\u63d0\u793a\u5185\u5bb9", markMap);
        pushSubscribeMessageReqVO.setData(data);
        log.info("data" + JSON.toJSONString(data));
        return pushSubscribeMessageReqVO;
    }
}

