/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.manager.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctor.basedata.api.vo.DoctorPostRepVO;
import com.doctor.basedata.api.vo.GetStandDeptVo;
import com.doctor.basedata.api.vo.UcUserEvaluationVO;
import com.doctoruser.api.common.enums.DoctorTypeEnum;
import com.doctoruser.api.pojo.base.dto.AppealAllInfoDTO;
import com.doctoruser.api.pojo.base.dto.AppealDetailDTO;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.dto.manager.UpdateDealStatusDTO;
import com.doctoruser.api.pojo.base.entity.AppealEntity;
import com.doctoruser.api.pojo.base.vo.AppealDetailVO;
import com.doctoruser.api.pojo.base.vo.DocAppealRemarkVo;
import com.doctoruser.api.pojo.base.vo.DoctorIdVo;
import com.doctoruser.api.pojo.base.vo.DoctorNameAndOrganNameRes;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.ebaiyihui.client.DataScopeClient;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.imforward.client.vo.IMQueryMsgReqVO;
import com.ebaiyihui.imforward.client.vo.IMQueryTargetSdkAccountRspVO;
import com.ebaiyihui.imforward.client.vo.IMSingleMsgResultVO;
import com.ebaiyihui.onlineoutpatient.common.dto.UpdateDealDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.manager.OrderIdAndDealSeqRes;
import com.ebaiyihui.onlineoutpatient.common.dto.manager.QueryAppealOrderTypeDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.order.AppealAllDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.order.QueryOrderInfoDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.order.QueryOrderdetailsDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.order.QueryRecordByOrderIdDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.order.QueryReviewsByAdmIdDTO;
import com.ebaiyihui.onlineoutpatient.common.dto.order.UpdateextendVisitTimeDTO;
import com.ebaiyihui.onlineoutpatient.common.util.ResultData;
import com.ebaiyihui.onlineoutpatient.common.vo.AdmissionVideoEntityVo;
import com.ebaiyihui.onlineoutpatient.common.vo.AppealAllInfoVO;
import com.ebaiyihui.onlineoutpatient.common.vo.AppealDetailsVO;
import com.ebaiyihui.onlineoutpatient.common.vo.PatientAccountReq;
import com.ebaiyihui.onlineoutpatient.common.vo.PatientAdmTime;
import com.ebaiyihui.onlineoutpatient.common.vo.PatientInfoRes;
import com.ebaiyihui.onlineoutpatient.common.vo.QueryAppealOrderTypeVO;
import com.ebaiyihui.onlineoutpatient.common.vo.QueryOrderTotalVo;
import com.ebaiyihui.onlineoutpatient.common.vo.QueryRecordByOrderIdVo;
import com.ebaiyihui.onlineoutpatient.common.vo.TeamImAccount;
import com.ebaiyihui.onlineoutpatient.common.vo.UserEvaluationVO;
import com.ebaiyihui.onlineoutpatient.common.vo.doctor.HosDeptIdVo;
import com.ebaiyihui.onlineoutpatient.core.common.enums.AdmissionStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.GenderEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ImmediateConsultationVoTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.OrderStatusEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.PayChannelEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.ServiceTypeEnum;
import com.ebaiyihui.onlineoutpatient.core.common.enums.WhetherEnum;
import com.ebaiyihui.onlineoutpatient.core.common.properties.ProjProperties;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.AdmissionVideoMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.AnomalousEventMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.DoctorTeamMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.EvaluationMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.InquiryMchCodeMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.ManagerOrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.MedicalAdmissionRefMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.OrderMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.PatientMedicalPictureMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.TeamDoctorInfoMapper;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionEntity;
import com.ebaiyihui.onlineoutpatient.core.model.AdmissionVideoEntity;
import com.ebaiyihui.onlineoutpatient.core.model.AnomalousEventEntity;
import com.ebaiyihui.onlineoutpatient.core.model.DoctorTeamEntity;
import com.ebaiyihui.onlineoutpatient.core.model.EvaluationEntity;
import com.ebaiyihui.onlineoutpatient.core.model.InquiryMchCodeEntity;
import com.ebaiyihui.onlineoutpatient.core.model.OrderEntity;
import com.ebaiyihui.onlineoutpatient.core.model.PatientEntity;
import com.ebaiyihui.onlineoutpatient.core.model.TeamDoctorInfoEntity;
import com.ebaiyihui.onlineoutpatient.core.service.AdmissionVideoService;
import com.ebaiyihui.onlineoutpatient.core.service.IMInformService;
import com.ebaiyihui.onlineoutpatient.core.service.ImAccountService;
import com.ebaiyihui.onlineoutpatient.core.service.InquiryServiceConfigService;
import com.ebaiyihui.onlineoutpatient.core.service.client.DepartmentFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorAppealFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorBaseFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorInfofeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.DoctorUserEvaluationFeignClient;
import com.ebaiyihui.onlineoutpatient.core.service.client.IMSyncMsgClient;
import com.ebaiyihui.onlineoutpatient.core.service.manager.ManagerOrderService;
import com.ebaiyihui.onlineoutpatient.core.service.remotecall.InternetHospitalDetailInfoService;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.ExcelUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.HttpKit;
import com.ebaiyihui.onlineoutpatient.core.utils.IDCardUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.JsonUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.PageUtil;
import com.ebaiyihui.onlineoutpatient.core.vo.AppealDetailReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.DrugOrderCartDto;
import com.ebaiyihui.onlineoutpatient.core.vo.ExportOrderExcel;
import com.ebaiyihui.onlineoutpatient.core.vo.ExportOrderExcelNCZKVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ExportOrderExcelVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ExportOrderFzResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.ExportOrderResDto;
import com.ebaiyihui.onlineoutpatient.core.vo.ExportOrderZxResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.GetAnomalousByIdReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.GetHospitalListReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.MedicineCloudReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.OrderChartReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.OrderChartResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.OrderCountForMangVo;
import com.ebaiyihui.onlineoutpatient.core.vo.OrderListForCountReqVo;
import com.ebaiyihui.onlineoutpatient.core.vo.OrderListForCountResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.OutExportResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.QueryOrderInfoVo;
import com.ebaiyihui.onlineoutpatient.core.vo.QueryOrderMapVo;
import com.ebaiyihui.onlineoutpatient.core.vo.QueryOrderdetailsVo;
import com.ebaiyihui.onlineoutpatient.core.vo.RequestManageOrderListNCZKVo;
import com.ebaiyihui.onlineoutpatient.core.vo.RequestManageOrderListVo;
import com.ebaiyihui.onlineoutpatient.core.vo.dashboard.DocDeptDateRankingResVO;
import com.ebaiyihui.onlineoutpatient.core.vo.dashboard.DocDeptDateRankingVO;
import com.ebaiyihui.onlineoutpatient.core.vo.dashboard.ExportDeptReceiveRanking;
import com.ebaiyihui.onlineoutpatient.core.vo.dashboard.ExportDocDeptDateRanking;
import com.ebaiyihui.onlineoutpatient.core.vo.dashboard.ExportOrderDocResDto;
import com.ebaiyihui.onlineoutpatient.core.vo.dashboard.OrderListForPercentageResVo;
import com.ebaiyihui.onlineoutpatient.core.vo.dashboard.ReceptionCompletionVO;
import com.ebaiyihui.onlineoutpatient.core.vo.dashboard.ReceptionCompletionYdataVO;
import com.ebaiyihui.onlineoutpatient.core.vo.nczk.dto.QueryPatOrderListDto;
import com.ebaiyihui.sysinfocloudcommon.vo.medical.PatientDynamicMedicalEntityVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class ManagerOrderServiceImpl
implements ManagerOrderService {
    private static final Logger log = LoggerFactory.getLogger(ManagerOrderServiceImpl.class);
    public static final String APPEAL_MANAGER_KEY = "SSDD_";
    public static final String ONLINE_OUTPATIENT_KEY = "ZXWZ_";
    public static final String FILE_NAME = "zxwz";
    public static final String INVALID_STATUS_DESC = "\u5df2\u5931\u6548";
    public static final String STATUS_DESC = "\u5df2\u8f6c\u8bca";
    public static final Integer OWN_EXPENSE = 0;
    public static final String VIDEO = "m3u8";
    public static final String SOUND = "aac";
    @Autowired
    private ManagerOrderMapper managerOrderMapper;
    @Autowired
    private PatientMedicalPictureMapper patientMedicalPictureMapper;
    @Autowired
    private DoctorInfofeignClient doctorClient;
    @Autowired
    private DataScopeClient dataScopeClient;
    @Autowired
    private ProjProperties projProperties;
    @Autowired
    private AdmissionMapper admissionMapper;
    @Autowired
    private PatientMapper patientMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private DoctorAppealFeignClient appealFeignClient;
    @Autowired
    private IMInformService imInformService;
    @Autowired
    private DoctorUserEvaluationFeignClient evaluationFeignClient;
    @Autowired
    private IMSyncMsgClient imSyncMsgClient;
    @Autowired
    private InternetHospitalDetailInfoService internetHospitalDetailInfoService;
    @Autowired
    private AdmissionVideoMapper admissionVideoMapper;
    @Autowired
    private DoctorTeamMapper doctorTeamMapper;
    @Autowired
    private InquiryMchCodeMapper inquiryMchCodeMapper;
    @Autowired
    private EvaluationMapper evaluationMapper;
    @Autowired
    private InquiryServiceConfigService inquiryServiceConfigService;
    @Autowired
    private AnomalousEventMapper anomalousEventMapper;
    @Autowired
    private DepartmentFeignClient departmentFeignClient;
    @Autowired
    private TeamDoctorInfoMapper teamDoctorInfoMapper;
    @Autowired
    private ImAccountService imAccountService;
    @Autowired
    private AdmissionVideoService admissionVideoService;
    @Autowired
    private InternetHospitalDetailInfoService hospitalDetailInfoService;
    @Autowired
    private DoctorBaseFeignClient DoctorBaseApi;
    @Autowired
    private MedicalAdmissionRefMapper medicalAdmissionRefMapper;
    private static final Logger logger = LoggerFactory.getLogger(ManagerOrderServiceImpl.class);

    public static void main(String[] args) {
        System.out.println("3".equals(3));
    }

    public ResultData<QueryRecordByOrderIdVo> queryRecordByOrderId(QueryRecordByOrderIdDTO dto) {
        ResultData resultData = new ResultData();
        if (!org.springframework.util.StringUtils.isEmpty((Object)dto)) {
            AdmissionEntity admission = this.admissionMapper.findById(dto.getAdmId());
            log.info("admission:{}" + admission.toString());
            QueryRecordByOrderIdVo recordVo = this.managerOrderMapper.queryRecordByOrderId(dto);
            OrderEntity orderEntity = this.orderMapper.findByAdmId(dto.getAdmId());
            log.info("orderEntity:{}" + orderEntity.toString());
            recordVo.setHospitalName(orderEntity.getHospitalName());
            recordVo.setCardNo(recordVo.getIdCard());
            if (Objects.equals(orderEntity.getKeepOrder(), 3)) {
                QueryPatOrderListDto queryPatOrderListDto = this.medicalAdmissionRefMapper.queryAdmByAdmId(dto.getAdmId());
                log.info("queryPatOrderListDto:" + JSON.toJSONString((Object)queryPatOrderListDto));
                recordVo.setDrugReqDtos(queryPatOrderListDto.getDrug());
            }
            if (null != recordVo) {
                String medicalRecordId;
                List list = this.patientMedicalPictureMapper.queryRecordPictures(recordVo.getRecordId());
                if (!list.isEmpty()) {
                    recordVo.setPicUrls(list);
                }
                if (StringUtils.isNotBlank((String)(medicalRecordId = admission.getMedicalRecordId()))) {
                    PatientDynamicMedicalEntityVo patientDynamicMedicalEntityVo = this.internetHospitalDetailInfoService.getMedicalInfoById(admission.getMedicalRecordId());
                    if (patientDynamicMedicalEntityVo == null) {
                        resultData.error("\u83b7\u53d6\u75c5\u4f8b\u4fe1\u606f\u4e3a\u7a7a");
                    }
                    log.info("patientDynamicMedicalEntityVo:{}", (Object)JSON.toJSONString((Object)patientDynamicMedicalEntityVo));
                    List medicalSortVoList = this.internetHospitalDetailInfoService.getMedicalUserFills(patientDynamicMedicalEntityVo.getServType(), patientDynamicMedicalEntityVo.getMedicalDetail(), patientDynamicMedicalEntityVo.getHospitalId(), patientDynamicMedicalEntityVo.getDeptId());
                    if (CollectionUtils.isEmpty((Collection)medicalSortVoList)) {
                        return resultData.error("\u75c5\u4f8b\u89e3\u6790\u5931\u8d25");
                    }
                    log.info("medicalSortVoList:{}", (Object)JSON.toJSONString((Object)medicalSortVoList));
                    recordVo.setMedicalUserFills(medicalSortVoList);
                } else {
                    recordVo.setMedicalUserFills(new ArrayList());
                }
                PatientDynamicMedicalEntityVo patientDynamicMedicalEntity = this.internetHospitalDetailInfoService.getMedicalInfoByAdmId(dto.getAdmId());
                if (patientDynamicMedicalEntity == null) {
                    recordVo.setMedicalUserFillsNew(new ArrayList());
                    return resultData.success((Object)recordVo);
                }
                log.info("patientDynamicMedicalEntity:{}" + patientDynamicMedicalEntity.toString());
                List medicalSortVoListNew = this.internetHospitalDetailInfoService.getMedicalUserFills(patientDynamicMedicalEntity.getServType(), patientDynamicMedicalEntity.getMedicalDetail(), patientDynamicMedicalEntity.getHospitalId(), patientDynamicMedicalEntity.getDeptId());
                if (CollectionUtils.isEmpty((Collection)medicalSortVoListNew)) {
                    return resultData.error("\u75c5\u4f8b\u89e3\u6790\u5931\u8d25");
                }
                log.info("medicalSortVoListNew:{}" + medicalSortVoListNew.toString());
                recordVo.setMedicalUserFillsNew(medicalSortVoListNew);
                return resultData.success((Object)recordVo);
            }
            return resultData.error("\u67e5\u8be2\u75c5\u5386\u4fe1\u606f\u5931\u8d25,\u6ca1\u6709\u8be5\u8ba2\u5355\u7684\u75c5\u5386");
        }
        return resultData.error("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
    }

    public ResultData<PageUtil<QueryOrderMapVo>> queryOrderInfo(RequestManageOrderListVo vo) {
        ResultData resultData = new ResultData();
        QueryOrderInfoDTO dto = new QueryOrderInfoDTO();
        dto.setAppCode(vo.getAppCode());
        log.info("\u5165\u53c2vo:{}", (Object)JSON.toJSONString((Object)vo));
        String key = ONLINE_OUTPATIENT_KEY + vo.getUserId();
        log.info("\u67e5\u8be2\u5728\u7ebf\u95ee\u8bca\u6570\u636e\u6743\u9650key: ", (Object)key);
        if (this.setHospitalIds(vo, dto, key)) {
            return resultData.error("\u5728\u7ebf\u95ee\u8bca\u6570\u636e\u6743\u9650\u67e5\u8be2\u5931\u8d25");
        }
        List<Integer> list = new ArrayList();
        if (Objects.nonNull(vo.getAttachStatus())) {
            if (AdmissionStatusEnum.DOCTOR_CLOSED_SCHEDULE.getValue() == vo.getAttachStatus()) {
                list.add(AdmissionStatusEnum.DOCTOR_CLOSED_WATING_SCHEDULE.getValue());
            }
            if (AdmissionStatusEnum.ADMIN_REFUNDED.getValue() == vo.getAttachStatus()) {
                list.add(AdmissionStatusEnum.ADMIN_REFUNDED_ADMISSION.getValue());
            }
            if (AdmissionStatusEnum.NOT_RECEIVED_TIME_OUT.getValue() == vo.getAttachStatus()) {
                list.add(AdmissionStatusEnum.REFUNDED_REFUSE_ZERO.getValue());
            }
            if (AdmissionStatusEnum.FINISH_TIME_OUT.getValue() == vo.getAttachStatus()) {
                list.add(AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue());
            }
            list.add(vo.getAttachStatus());
        } else {
            list = this.setStatus(vo);
        }
        dto.setStatusList(list);
        dto.setDateType(vo.getDateType());
        dto.setCreateTimeStart(vo.getTimeStart() + " 00:00:00");
        dto.setCreateTimeEnd(vo.getTimeEnd() + " 23:59:59");
        dto.setSearchParams(vo.getSearchParams().replace("_", "\\_").replace("%", "\\%"));
        dto.setDoctorType(vo.getDoctorType());
        dto.setDeptId(vo.getDeptId());
        dto.setServType(vo.getServType());
        dto.setFundType(vo.getFundType());
        dto.setPageNum(vo.getPageNum());
        dto.setPageSize(vo.getPageSize());
        dto.setOrderSouce(vo.getOrderSouce());
        dto.setSmallProgramSource(vo.getSmallProgramSource());
        log.info("dto:{}" + dto.toString());
        List<Object> entityIn = new ArrayList();
        if (StringUtils.isNotEmpty((String)vo.getHospitalId())) {
            QueryWrapper wrapperQ = new QueryWrapper();
            InquiryMchCodeEntity inquiryMchCode = new InquiryMchCodeEntity();
            inquiryMchCode.setAppCode(vo.getAppCode());
            inquiryMchCode.setHospitalId(vo.getHospitalId());
            log.info("inquiryMchCodeEntity:{}" + inquiryMchCode.toString());
            wrapperQ.setEntity((Object)inquiryMchCode);
            InquiryMchCodeEntity entityI = (InquiryMchCodeEntity)this.inquiryMchCodeMapper.selectOne((Wrapper)wrapperQ);
            if (null == entityI) {
                log.info("\u8be5\u533b\u9662\u7684\u5546\u6237\u53f7\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u6570\u636e\u5e93\u4e2d\u914d\u7f6e\u5546\u6237\u53f7");
            } else if (StringUtils.isNotEmpty((String)entityI.getHisUrl())) {
                entityIn.add(entityI);
            }
        } else {
            List inquiryMchCodeEntities = this.inquiryMchCodeMapper.selectLists(vo.getAppCode(), dto.getHospitalIds());
            entityIn = inquiryMchCodeEntities.stream().filter(inquiryMchCodeEntity -> null != inquiryMchCodeEntity && StringUtils.isNotEmpty((String)inquiryMchCodeEntity.getHisUrl())).collect(Collectors.toList());
        }
        log.info("entityIn:" + JSON.toJSONString(entityIn));
        QueryOrderTotalVo queryOrderTotalVo = new QueryOrderTotalVo();
        if (CollectionUtils.isEmpty(entityIn) || ServiceTypeEnum.HOS.getValue().equals(vo.getServType())) {
            dto.setIsHis("2");
        } else {
            dto.setIsHis("1");
        }
        if (dto.getServType().equals(ServiceTypeEnum.NOS.getValue()) && "HYT".equals(vo.getAppCode()) && !CollectionUtils.isEmpty(entityIn)) {
            QueryOrderTotalVo ownCost = this.orderMapper.countCountsOwnCost(dto);
            log.info("ownCost:{}" + ownCost.toString());
            queryOrderTotalVo.setSumPayAmount(ownCost.getSumPayAmount());
        } else {
            QueryOrderTotalVo sumPayAmount = this.orderMapper.countSumPayAmount(dto);
            log.info("sumPayAmount:{}" + sumPayAmount.toString());
            queryOrderTotalVo.setSumPayAmount(sumPayAmount.getSumPayAmount());
            queryOrderTotalVo.setSumActualPayAmount(new BigDecimal(BigInteger.ZERO));
            if (Objects.isNull(vo.getStatus()) || AdmissionStatusEnum.FINISH_APPLY.getValue() == vo.getStatus()) {
                QueryOrderInfoDTO dto2 = new QueryOrderInfoDTO();
                BeanUtils.copyProperties((Object)dto, (Object)dto2);
                ArrayList<Integer> list2 = new ArrayList<Integer>();
                list2.add(7);
                list2.add(8);
                list2.add(9);
                dto2.setStatusList(list2);
                QueryOrderTotalVo sumActualPayAmount = this.orderMapper.countSumActualPayAmount(dto2);
                log.info("sumActualPayAmount:{}" + sumActualPayAmount.toString());
                queryOrderTotalVo.setSumActualPayAmount(Objects.nonNull(sumActualPayAmount.getSumActualPayAmount()) ? sumActualPayAmount.getSumActualPayAmount() : new BigDecimal(BigInteger.ZERO));
            }
        }
        QueryOrderTotalVo countPayAmount = this.orderMapper.countPayAmount(dto);
        QueryOrderTotalVo counts = this.orderMapper.countNums(dto);
        queryOrderTotalVo.setCountPayAmount(countPayAmount.getCountPayAmount());
        queryOrderTotalVo.setCounts(counts.getCounts());
        log.info("queryOrderTotalVo:{}" + queryOrderTotalVo.toString());
        PageHelper.startPage((Object)dto);
        Page result = this.managerOrderMapper.queryOrderInfo(dto);
        for (QueryOrderInfoVo queryOrderInfoVo : result) {
            if (vo.getDateType() != null && vo.getDateType().equals(3) && queryOrderInfoVo.getScheduleDate() != null) {
                String scheduleStartTime = DateUtils.dateToSimpleString((Date)queryOrderInfoVo.getScheduleDate()) + " " + queryOrderInfoVo.getScheduleStartTime() + ":00";
                queryOrderInfoVo.setStartTime(DateUtils.stringToFullDate((String)scheduleStartTime));
            }
            if (dto.getIsHis().equals("2")) {
                queryOrderInfoVo.setIsHis("2");
            } else if (dto.getIsHis().equals("1")) {
                queryOrderInfoVo.setIsHis("1");
            }
            queryOrderInfoVo.setIsSwitch(Integer.valueOf(Objects.isNull(queryOrderInfoVo.getIsSwitch()) ? 0 : queryOrderInfoVo.getIsSwitch()));
        }
        log.info("result:{}" + JSONObject.toJSONString((Object)result));
        log.info("size:{}" + result.size());
        QueryOrderMapVo queryOrderMapVo = new QueryOrderMapVo();
        if (null == queryOrderTotalVo.getSumPayAmount()) {
            queryOrderTotalVo.setSumPayAmount(new BigDecimal(0.0));
        } else {
            BigDecimal bigDecimal1 = queryOrderTotalVo.getSumPayAmount().setScale(2, 4);
            queryOrderTotalVo.setSumPayAmount(bigDecimal1);
        }
        queryOrderMapVo.setOrderTotalVo(queryOrderTotalVo);
        queryOrderMapVo.setOrderInfoVos((List)result);
        if (null != result && result.size() > 0) {
            return this.getPageUtilResultData(resultData, queryOrderTotalVo, result, queryOrderMapVo);
        }
        PageUtil pageUtil = new PageUtil();
        pageUtil.setTotal(result.getTotal());
        queryOrderMapVo.setOrderTotalVo(queryOrderTotalVo);
        queryOrderMapVo.setOrderTotalVo(queryOrderTotalVo);
        pageUtil.setObject((Object)queryOrderMapVo);
        log.info("pageUtil:{}" + JSONObject.toJSONString((Object)pageUtil));
        return resultData.success((Object)pageUtil);
    }

    private boolean setHospitalIds(RequestManageOrderListVo vo, QueryOrderInfoDTO dto, String key) {
        if (StringUtils.isEmpty((String)vo.getHospitalId())) {
            BaseResponse hospitalIds = this.dataScopeClient.getPermissionsByKey(key);
            log.info("permissionsByKey :{}", (Object)JSON.toJSONString((Object)hospitalIds));
            if (!hospitalIds.isSuccess() && hospitalIds.getData() == null) {
                return true;
            }
            dto.setHospitalIds((String)hospitalIds.getData());
        } else {
            dto.setHospitalIds(vo.getHospitalId());
        }
        return false;
    }

    private ResultData<PageUtil<QueryOrderMapVo>> getPageUtilResultData(ResultData<PageUtil<QueryOrderMapVo>> resultData, QueryOrderTotalVo queryOrderTotalVo, Page<QueryOrderInfoVo> result, QueryOrderMapVo queryOrderMapVo) {
        queryOrderMapVo.getOrderInfoVos().stream().forEach(e -> {
            String[] split;
            e.setChargePrice(new BigDecimal("0.00"));
            e.setServTypeDesc(ServiceTypeEnum.getDesc((Integer)e.getServType()));
            e.setDoctorTypeDesc(DoctorTypeEnum.getDesc((Integer)e.getDoctorType()));
            e.setStatusDesc(AdmissionStatusEnum.getDesc((Integer)e.getStatus()));
            e.setAttachStatusDesc(AdmissionStatusEnum.getDisplay((Integer)e.getStatus()));
            if (AdmissionStatusEnum.REFUNDED_REFUSE_ZERO.getValue().equals(e.getStatus()) && StringUtils.isNotEmpty((String)e.getRemark())) {
                e.setAttachStatusDesc("\u533b\u751f\u62d2\u7edd\u54a8\u8be2\u5c31\u8bca");
            }
            if (AdmissionStatusEnum.ADMIN_REFUNDED_ADMISSION.getValue().equals(e.getStatus())) {
                e.setStatus(AdmissionStatusEnum.ADMIN_REFUNDED.getValue());
            }
            QueryPersonnelInfoReq docAllInfoDto = new QueryPersonnelInfoReq();
            docAllInfoDto.setDoctorId(e.getDoctorId());
            BaseResponse personnelInfoBaseResponse = this.doctorClient.queryPersonnelInfo(docAllInfoDto);
            if (null != personnelInfoBaseResponse && personnelInfoBaseResponse.isSuccess() && null != personnelInfoBaseResponse.getData()) {
                e.setDoctorName(((PersonnelInfo)personnelInfoBaseResponse.getData()).getDoctorName());
                e.setPracticeOrganName(((PersonnelInfo)personnelInfoBaseResponse.getData()).getOrganName());
            }
            QueryWrapper wrapper = new QueryWrapper();
            InquiryMchCodeEntity inquiryMchCodeEntity = new InquiryMchCodeEntity();
            inquiryMchCodeEntity.setAppCode(e.getAppCode());
            inquiryMchCodeEntity.setHospitalId(e.getHospitalId());
            wrapper.setEntity((Object)inquiryMchCodeEntity);
            InquiryMchCodeEntity entity = (InquiryMchCodeEntity)this.inquiryMchCodeMapper.selectOne((Wrapper)wrapper);
            log.info("entity:" + JSON.toJSONString((Object)entity));
            if (e.getServType().equals(ServiceTypeEnum.NOS.getValue()) && null != entity && StringUtils.isNotEmpty((String)entity.getHisUrl()) && StringUtils.isNotEmpty((String)e.getOwnCost())) {
                BigDecimal bigDecimal = new BigDecimal(e.getOwnCost()).setScale(2, 4);
                e.setPayAmount(bigDecimal);
            }
            if (0 == BigDecimal.ZERO.compareTo(e.getPayAmount()) && "\u5df2\u9000\u6b3e".equals((split = StringUtils.split((String)e.getAttachStatusDesc(), (String)"\uff0c"))[0])) {
                e.setAttachStatusDesc(split[1]);
            }
        });
        PageUtil pageUtil = new PageUtil();
        pageUtil.setTotal(result.getTotal());
        queryOrderMapVo.setOrderTotalVo(queryOrderTotalVo);
        queryOrderMapVo.setOrderTotalVo(queryOrderTotalVo);
        pageUtil.setObject((Object)queryOrderMapVo);
        log.info("page:{}" + JSONObject.toJSONString((Object)pageUtil));
        return resultData.success((Object)pageUtil);
    }

    private List<Integer> setStatus(RequestManageOrderListVo vo) {
        Integer status = vo.getStatus();
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (status != null) {
            if (status.equals(4)) {
                list.add(AdmissionStatusEnum.REFUNDED_REFUSE.getValue());
                list.add(AdmissionStatusEnum.NOT_RECEIVED_TIME_OUT.getValue());
                list.add(AdmissionStatusEnum.REFUNDED_APPLY.getValue());
                list.add(AdmissionStatusEnum.RETIRED.getValue());
                list.add(AdmissionStatusEnum.TO_BE_RECEIVED_REFUND.getValue());
                list.add(AdmissionStatusEnum.EXPIRED.getValue());
                list.add(AdmissionStatusEnum.CANCEL.getValue());
                list.add(AdmissionStatusEnum.REFUNDED_REFUSE_ZERO.getValue());
                list.add(AdmissionStatusEnum.DOCTOR_CLOSED_SCHEDULE.getValue());
                list.add(AdmissionStatusEnum.DOCTOR_CLOSED_WATING_SCHEDULE.getValue());
                list.add(AdmissionStatusEnum.PASSNUMBER_REFUND.getValue());
                list.add(AdmissionStatusEnum.PASSNUMBER_REFUND_ZERO.getValue());
                list.add(AdmissionStatusEnum.ADMIN_REFUNDED.getValue());
                list.add(AdmissionStatusEnum.ADMIN_REFUNDED_ADMISSION.getValue());
            } else if (status.equals(7)) {
                list.add(AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue());
                list.add(AdmissionStatusEnum.FINISH_APPLY.getValue());
                list.add(AdmissionStatusEnum.FINISH_TIME_OUT.getValue());
            } else if (status.equals(40)) {
                list.add(AdmissionStatusEnum.REFERRAL_MANAGER.getValue());
                list.add(AdmissionStatusEnum.REFERRAL_MANAGER_FINISH.getValue());
                list.add(AdmissionStatusEnum.REFERRAL.getValue());
            } else {
                list.add(status);
            }
        }
        log.info("list:{}" + ((Object)list).toString());
        return list;
    }

    public ResultData<QueryOrderdetailsVo> queryOrderDetails(QueryOrderdetailsDTO dto) {
        QueryOrderdetailsVo vo = null;
        ResultData resultData = new ResultData();
        if (null != dto && StringUtils.isNotBlank((String)dto.getAdmId())) {
            OrderEntity orderEntity = this.orderMapper.findByAdmId(dto.getAdmId());
            vo = this.managerOrderMapper.queryOrderDetails(dto);
            if (null != vo) {
                BaseResponse listBaseResponse;
                List imSingleMsgResultVoS;
                BaseResponse baseResponse;
                Integer admStatus = vo.getAdmStatus();
                Integer orderStatus = vo.getOrderStatus();
                Integer status = this.admAndOrderStatus(admStatus, orderStatus);
                if (Objects.equals(admStatus, AdmissionStatusEnum.ADMIN_REFUNDED_ADMISSION.getValue())) {
                    vo.setAdmStatus(AdmissionStatusEnum.ADMIN_REFUNDED.getValue());
                }
                if (Objects.nonNull(orderEntity.getKeepOrder()) && Objects.equals(admStatus, AdmissionStatusEnum.REFUNDED_REFUSE_ZERO.getValue())) {
                    vo.setAdmStatus(Integer.valueOf(31));
                }
                vo.setStatus(status);
                PatientEntity patient = this.patientMapper.selectById(vo.getPatientId());
                if (patient == null) {
                    return resultData.error("\u672a\u67e5\u8be2\u5230\u60a3\u8005\u4fe1\u606f");
                }
                try {
                    Integer age = IDCardUtil.getAge((String)patient.getIdcard());
                    vo.setPatientAge(age);
                }
                catch (Exception e) {
                    log.error("\u8eab\u4efd\u8bc1\u53f7\u83b7\u53d6\u60a3\u8005\u5e74\u9f84\u5931\u8d25\uff0c\u8eab\u4efd\u8bc1\u53f7\u7801={}", (Object)patient.getIdcard(), (Object)e);
                }
                Integer gender = patient.getGender();
                if (GenderEnum.FEMALE.getValue().equals(gender)) {
                    vo.setPatientSex(GenderEnum.FEMALE.getDesc());
                } else {
                    vo.setPatientSex(GenderEnum.MALE.getDesc());
                }
                EvaluationEntity one = null;
                if (vo.getAdmStatus().equals(AdmissionStatusEnum.FINISH_APPLY.getValue()) || vo.getAdmStatus().equals(AdmissionStatusEnum.FINISH_TIME_OUT.getValue())) {
                    QueryWrapper evaluationWrapper = new QueryWrapper();
                    EvaluationEntity evaluationEntity = new EvaluationEntity();
                    evaluationEntity.setAdmId(dto.getAdmId());
                    evaluationEntity.setDisplay(new Integer(1).byteValue());
                    evaluationWrapper.setEntity((Object)evaluationEntity);
                    one = (EvaluationEntity)this.evaluationMapper.selectOne((Wrapper)evaluationWrapper);
                    log.info("one{}", (Object)JSON.toJSONString((Object)one));
                }
                if ((vo.getAdmStatus().equals(AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue()) || null != one) && null != (baseResponse = this.evaluationFeignClient.getDoctorEvaluationMsg("", ServiceTypeEnum.getCode((Integer)vo.getServType()), dto.getAdmId(), null)) && null != baseResponse.getData() && ((List)baseResponse.getData()).size() > 0) {
                    UcUserEvaluationVO ucUserEvaluationVO = (UcUserEvaluationVO)((List)baseResponse.getData()).get(0);
                    UserEvaluationVO userEvaluationVO = new UserEvaluationVO();
                    BeanUtils.copyProperties((Object)ucUserEvaluationVO, (Object)userEvaluationVO);
                    vo.setUserEvaluationVO(userEvaluationVO);
                }
                if (vo.getAdmStatus().equals(AdmissionStatusEnum.REFERRAL.getValue()) || vo.getAdmStatus().equals(AdmissionStatusEnum.REFERRAL_MANAGER.getValue())) {
                    QueryWrapper queryWrapper = new QueryWrapper();
                    DoctorTeamEntity entity2 = new DoctorTeamEntity();
                    entity2.setAdmissionId(dto.getAdmId());
                    queryWrapper.setEntity((Object)entity2);
                    DoctorTeamEntity doctorTeamEntity = (DoctorTeamEntity)this.doctorTeamMapper.selectOne((Wrapper)queryWrapper);
                    log.info("doctorTeamEntity:{}" + doctorTeamEntity.toString());
                    if (doctorTeamEntity != null) {
                        vo.setCreatTime(doctorTeamEntity.getXCreateTime());
                    }
                }
                BigDecimal chargePrice = new BigDecimal(0.0);
                vo.setChargePrice(chargePrice);
                DoctorIdVo req = new DoctorIdVo();
                req.setDoctorId(vo.getDoctorId());
                BaseResponse queryDoctorInfoForBank = this.doctorClient.queryDoctorInfoForBank(req);
                if (null != queryDoctorInfoForBank && queryDoctorInfoForBank.isSuccess()) {
                    vo.setDoctorName(((DoctorNameAndOrganNameRes)queryDoctorInfoForBank.getData()).getDoctorName());
                    vo.setPersonnelOrganName(((DoctorNameAndOrganNameRes)queryDoctorInfoForBank.getData()).getOrganName());
                }
                QueryPersonnelInfoReq docAllInfoDto = new QueryPersonnelInfoReq();
                docAllInfoDto.setDoctorId(vo.getDoctorId());
                BaseResponse personnelInfoBaseResponse = this.doctorClient.queryPersonnelInfo(docAllInfoDto);
                if (null != personnelInfoBaseResponse && personnelInfoBaseResponse.isSuccess() && null != personnelInfoBaseResponse.getData()) {
                    vo.setPracticeOrganName(((PersonnelInfo)personnelInfoBaseResponse.getData()).getOrganName());
                    vo.setDoctorTelephone(((PersonnelInfo)personnelInfoBaseResponse.getData()).getPhoneNum());
                    vo.setDoctorTitle(((PersonnelInfo)personnelInfoBaseResponse.getData()).getTitle());
                    vo.setDoctorPortrait(((PersonnelInfo)personnelInfoBaseResponse.getData()).getPortrait());
                }
                IMQueryMsgReqVO reqVO = new IMQueryMsgReqVO();
                PatientEntity patientEntity = this.patientMapper.findOneByPatientId(vo.getPatientId());
                reqVO.setAppCode("EHOS_PATIENT");
                ArrayList<String> admIdList = new ArrayList<String>();
                admIdList.add(dto.getAdmId());
                reqVO.setAppointmentId(admIdList);
                reqVO.setBusinessCode("zxzx");
                reqVO.setPage(Integer.valueOf(0));
                reqVO.setPageSize(Integer.valueOf(9999));
                reqVO.setMsgType("1");
                reqVO.setUserId(patientEntity.getUserId());
                List teamImAccounts = new ArrayList();
                if (DoctorTypeEnum.TEAM.getValue().equals(vo.getDoctorType())) {
                    teamImAccounts = this.getTeamImAccounts(dto.getAdmId(), "EHOS_DOCTOR");
                    reqVO.setMsgType("0");
                    vo.setTeamImAccounts(teamImAccounts);
                }
                if (null != (imSingleMsgResultVoS = (List)(listBaseResponse = this.imSyncMsgClient.queryImMsg(reqVO)).getData())) {
                    Iterator it = imSingleMsgResultVoS.iterator();
                    while (it.hasNext()) {
                        IMSingleMsgResultVO x = (IMSingleMsgResultVO)it.next();
                        if ("administrator".equals(x.getSender())) {
                            it.remove();
                            continue;
                        }
                        if (x.getSender().contains("EHOS_PATIENT")) {
                            x.setSender("EHOS_PATIENT");
                            continue;
                        }
                        if (!x.getSender().contains("EHOS_DOCTOR")) continue;
                        x.setSender("EHOS_DOCTOR");
                    }
                    List collect = imSingleMsgResultVoS.stream().sorted(Comparator.comparing(IMSingleMsgResultVO::getSendTime)).collect(Collectors.toList());
                    vo.setImSingleMsgResultVOS(collect);
                }
                String dateStr = DateUtils.dateToFullString((Date)orderEntity.getXCreateTime());
                if (null != orderEntity.getScheduleDate()) {
                    Date scheduleDate = orderEntity.getScheduleDate();
                    String scheduleDateStr = DateUtils.dateToSimpleString((Date)scheduleDate);
                    dateStr = scheduleDateStr + " " + orderEntity.getScheduleStartTime() + "-" + orderEntity.getScheduleEndTime();
                }
                vo.setAppointmentTime(dateStr);
                if (Objects.nonNull(orderEntity.getKeepOrder())) {
                    vo.setAppointmentTime("\u2014");
                }
                GetStandDeptVo deptVo = new GetStandDeptVo();
                deptVo.setOrganId(Long.valueOf(Long.parseLong(vo.getHospitalId())));
                deptVo.setDeptLevel(Integer.valueOf(1));
                deptVo.setHosDeptId(orderEntity.getDeptId());
                BaseResponse baseResponse2 = this.departmentFeignClient.getByOrganIdAndHosDeptId(deptVo);
                log.info("\u67e5\u8be2\u4e00\u7ea7\u79d1\u5ba4\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)baseResponse2));
                if (null != baseResponse2 && baseResponse2.isSuccess()) {
                    if (null != baseResponse2.getData()) {
                        // empty if block
                    }
                    HosDeptIdVo hosDeptIdVo = (HosDeptIdVo)JSON.parseObject((String)JSON.toJSONString((Object)baseResponse2.getData()), HosDeptIdVo.class);
                    log.info("hosDeptIdVo:{}", (Object)JSON.toJSONString((Object)hosDeptIdVo));
                    vo.setFirstDeptId(hosDeptIdVo.getXId());
                    vo.setFirstDeptName(hosDeptIdVo.getDisplayName());
                }
                ArrayList admissionVideoEntityVoList = new ArrayList();
                ArrayList soundEntityVoList = new ArrayList();
                QueryWrapper queryWrapper = new QueryWrapper();
                AdmissionVideoEntity admissionVideoEntity = new AdmissionVideoEntity();
                admissionVideoEntity.setAdmId(dto.getAdmId());
                queryWrapper.setEntity((Object)admissionVideoEntity);
                List<Object> admissionVideoEntityList = new ArrayList();
                admissionVideoEntityList = this.admissionVideoMapper.selectList((Wrapper)queryWrapper);
                if (CollectionUtils.isEmpty(admissionVideoEntityList) && DoctorTypeEnum.TEAM.getValue().equals(vo.getDoctorType())) {
                    admissionVideoEntityList = this.admissionVideoService.getVideoFromIm(dto.getAdmId());
                }
                if (!CollectionUtils.isEmpty(admissionVideoEntityList)) {
                    admissionVideoEntityList = admissionVideoEntityList.stream().sorted(Comparator.comparing(AdmissionVideoEntity::getStartTime).reversed()).collect(Collectors.toList());
                    admissionVideoEntityList.stream().forEach(entity -> {
                        AdmissionVideoEntityVo admissionVideoEntityVo = new AdmissionVideoEntityVo();
                        BeanUtils.copyProperties((Object)entity, (Object)admissionVideoEntityVo);
                        if (entity.getVideoUrl().endsWith(VIDEO)) {
                            admissionVideoEntityVoList.add(admissionVideoEntityVo);
                        } else if (entity.getVideoUrl().endsWith(SOUND)) {
                            soundEntityVoList.add(admissionVideoEntityVo);
                        }
                    });
                    List<Object> soundEntityVoListNew = new ArrayList();
                    soundEntityVoListNew = soundEntityVoList.stream().filter(sound -> {
                        for (AdmissionVideoEntityVo video : admissionVideoEntityVoList) {
                            if (!Objects.equals(sound.getStartTime(), video.getStartTime()) && !Objects.equals(sound.getEndTime(), video.getEndTime())) continue;
                            return false;
                        }
                        return true;
                    }).collect(Collectors.toList());
                    vo.setAdmissionVideoEntityVoList(admissionVideoEntityVoList);
                    vo.setSoundEntityVoList(soundEntityVoListNew);
                }
                PatientDynamicMedicalEntityVo patientDynamicMedicalEntity = this.internetHospitalDetailInfoService.getMedicalInfoByAdmId(dto.getAdmId());
                log.info("medicalSortVoListNew:{}" + JSON.toJSONString((Object)patientDynamicMedicalEntity));
                if (patientDynamicMedicalEntity == null) {
                    vo.setIsMedicalRecord(WhetherEnum.FORBID.getValue());
                } else {
                    vo.setIsMedicalRecord(WhetherEnum.ALLOW.getValue());
                }
                QueryWrapper queryMchCodeWrapper = new QueryWrapper();
                InquiryMchCodeEntity inquiryMchCodeEntity = new InquiryMchCodeEntity();
                inquiryMchCodeEntity.setAppCode(vo.getAppCode());
                inquiryMchCodeEntity.setHospitalId(vo.getHospitalId());
                queryMchCodeWrapper.setEntity((Object)inquiryMchCodeEntity);
                InquiryMchCodeEntity inquiryMchCode = (InquiryMchCodeEntity)this.inquiryMchCodeMapper.selectOne((Wrapper)queryMchCodeWrapper);
                if (null != inquiryMchCode && StringUtils.isNotEmpty((String)inquiryMchCode.getHisUrl()) && ServiceTypeEnum.NOS.getValue().equals(orderEntity.getServType())) {
                    vo.setIsHis("1");
                } else {
                    vo.setIsHis("2");
                }
                vo.setDeptId(orderEntity.getDeptId().toString());
                vo.setDeptName(orderEntity.getDeptName());
                QueryWrapper wrapper = new QueryWrapper();
                AnomalousEventEntity anomalousEventEntity = new AnomalousEventEntity();
                anomalousEventEntity.setAdmId(vo.getAdmId());
                wrapper.setEntity((Object)anomalousEventEntity);
                List anomalousEventList = this.anomalousEventMapper.selectList((Wrapper)wrapper);
                if (CollectionUtils.isEmpty((Collection)anomalousEventList)) {
                    vo.setAnomalousList(new ArrayList());
                } else {
                    anomalousEventList.sort(Comparator.comparing(AnomalousEventEntity::getXCreateTime));
                    vo.setAnomalousList(anomalousEventList);
                }
                return resultData.success((Object)vo);
            }
        }
        return resultData.error("\u672a\u67e5\u8be2\u5230\u8be6\u60c5");
    }

    private List<TeamImAccount> getTeamImAccounts(String admId, String imAppCode) {
        List list = this.teamDoctorInfoMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(TeamDoctorInfoEntity::getAdmId, (Object)admId));
        ArrayList<TeamImAccount> teamImAccounts = new ArrayList<TeamImAccount>();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (TeamDoctorInfoEntity teamDoctorInfoEntity : list) {
                TeamImAccount teamImAccount = new TeamImAccount();
                IMQueryTargetSdkAccountRspVO imAccountRes = this.imAccountService.queryImAccount(admId, imAppCode, teamDoctorInfoEntity.getDoctorId());
                teamImAccount.setImAccount(imAccountRes.getSdkAccount());
                teamImAccount.setDoctorName(teamDoctorInfoEntity.getDoctorName());
                teamImAccount.setPortrait(teamDoctorInfoEntity.getPortrait());
                teamImAccount.setTitle(teamDoctorInfoEntity.getTitle());
                teamImAccounts.add(teamImAccount);
            }
        }
        return teamImAccounts;
    }

    public Integer admAndOrderStatus(Integer admStatus, Integer orderStauts) {
        if (orderStauts.equals(OrderStatusEnum.TOPAY.getValue())) {
            return 1;
        }
        if (orderStauts.equals(OrderStatusEnum.EXPIRED.getValue())) {
            return 2;
        }
        if (orderStauts.equals(OrderStatusEnum.PAID.getValue())) {
            if (admStatus.equals(AdmissionStatusEnum.TO_BE_RECEIVED.getValue())) {
                return 3;
            }
            if (admStatus.equals(AdmissionStatusEnum.IN_CONSULTATION.getValue())) {
                return 4;
            }
            if (admStatus.equals(AdmissionStatusEnum.REFERRAL.getValue())) {
                return 40;
            }
        }
        if (orderStauts.equals(OrderStatusEnum.REFUNDING.getValue())) {
            if (admStatus.equals(AdmissionStatusEnum.REFUNDED_REFUSE.getValue())) {
                return 5;
            }
            if (admStatus.equals(AdmissionStatusEnum.NOT_RECEIVED_TIME_OUT.getValue())) {
                return 5;
            }
            if (admStatus.equals(AdmissionStatusEnum.REFUNDED_APPLY.getValue())) {
                return 5;
            }
        }
        if (orderStauts.equals(OrderStatusEnum.REFUNDED.getValue())) {
            if (admStatus.equals(AdmissionStatusEnum.REFUNDED_REFUSE.getValue())) {
                return 6;
            }
            if (admStatus.equals(AdmissionStatusEnum.NOT_RECEIVED_TIME_OUT.getValue())) {
                return 6;
            }
            if (admStatus.equals(AdmissionStatusEnum.REFUNDED_APPLY.getValue())) {
                return 6;
            }
        }
        if (orderStauts.equals(OrderStatusEnum.PAID.getValue())) {
            if (admStatus.equals(AdmissionStatusEnum.FINISH_APPLY.getValue())) {
                return 7;
            }
            if (admStatus.equals(AdmissionStatusEnum.FINISH_TIME_OUT.getValue())) {
                return 7;
            }
        }
        return null;
    }

    public ResultData<PatientAdmTime> queryAdmStartAndEndTime(QueryReviewsByAdmIdDTO dto) {
        ResultData result = new ResultData();
        PatientAdmTime admDate = new PatientAdmTime();
        AdmissionEntity admissionEntity = this.admissionMapper.findById(dto.getAdmId());
        if (null != admissionEntity) {
            admDate.setStartDate(admissionEntity.getStartTime());
            admDate.setEndDate(admissionEntity.getEndTime());
            PatientEntity patient = this.patientMapper.findOneByPatientId(admissionEntity.getPatientId());
            admDate.setPatientAccount(patient.getAccountPhone());
            QueryPersonnelInfoReq params = new QueryPersonnelInfoReq();
            params.setDoctorId(admissionEntity.getDoctorId());
            BaseResponse accountInfo = this.doctorClient.queryPersonnelInfo(params);
            if (null != ((PersonnelInfo)accountInfo.getData()).getPhoneNum()) {
                admDate.setDoctorAccount(((PersonnelInfo)accountInfo.getData()).getPhoneNum());
            }
        }
        return result.success((Object)admDate);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResultData<String> extendVisitTime(UpdateextendVisitTimeDTO dto) {
        Integer countTotal;
        ResultData resultData = new ResultData();
        Integer count = dto.getCount();
        if (org.springframework.util.StringUtils.isEmpty((Object)dto) || !StringUtils.isNotBlank((String)dto.getAdmId())) return resultData.error("\u53c2\u6570\u9519\u8bef");
        AdmissionEntity adm = this.admissionMapper.findById(dto.getAdmId());
        if (count != null && dto.getExtendTime() == null) {
            if (!this.checkAdmStatusForNum(adm)) return resultData.error("\u8be5\u72b6\u6001\u4e0d\u80fd\u4ec5\u589e\u52a0\u6761\u6570");
            Integer currentNum = adm.getCurrentNum() + count;
            if (currentNum > adm.getTotalNum()) {
                return resultData.error("\u589e\u52a0\u6761\u6570\u8d85\u8fc7\u5141\u8bb8\u4e0a\u9650");
            }
            adm.setCurrentNum(currentNum);
            adm.setStatus(AdmissionStatusEnum.IN_CONSULTATION.getValue());
            Integer countTotal2 = this.admissionMapper.update(adm);
            if (countTotal2 != 1) return resultData.error("\u4fee\u6539\u5931\u8d25");
            return resultData.success((Object)"\u4fee\u6539\u6210\u529f");
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)adm)) return resultData.error("\u8be5\u5c31\u8bcaid\u672a\u67e5\u8be2\u5230\u5c31\u8bca\u8bb0\u5f55");
        if (StringUtils.equals((String)"\u540e\u53f0\u5ef6\u65f6", (String)adm.getXRemark())) {
            return resultData.error("\u5df2\u5ef6\u65f6\u4e00\u6b21\uff0c\u4e0d\u80fd\u518d\u6b21\u5ef6\u65f6");
        }
        if (!this.checkAdmStatus(adm)) return resultData.error("\u8be5\u72b6\u6001\u4e0d\u80fd\u5ef6\u957f\u65f6\u95f4");
        Date endTime = adm.getEndTime();
        Calendar cal = Calendar.getInstance();
        cal.setTime(endTime);
        cal.add(7, 1);
        if (adm.getStatus().equals(AdmissionStatusEnum.IN_CONSULTATION.getValue())) {
            if (!endTime.before(dto.getExtendTime())) return resultData.error("\u8be5\u65f6\u95f4\u5c0f\u4e8e\u9884\u8ba1\u7ed3\u675f\u65f6\u95f4");
            if (!cal.getTime().after(dto.getExtendTime())) return resultData.error("\u81f3\u591a\u5ef6\u957f24\u5c0f\u65f6\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u65f6\u95f4");
            adm.setEndTime(dto.getExtendTime());
            adm.setXRemark("\u540e\u53f0\u5ef6\u65f6");
        } else {
            Calendar calnew = Calendar.getInstance();
            calnew.setTime(new Date());
            calnew.add(7, 1);
            if (cal.getTime().before(dto.getExtendTime()) && calnew.getTime().after(dto.getExtendTime())) {
                adm.setEndTime(calnew.getTime());
                adm.setXRemark("\u540e\u53f0\u5ef6\u65f6");
                adm.setStatus(AdmissionStatusEnum.IN_CONSULTATION.getValue());
            } else if (cal.getTime().before(dto.getExtendTime())) {
                adm.setEndTime(dto.getExtendTime());
                adm.setXRemark("\u540e\u53f0\u5ef6\u65f6");
                adm.setStatus(AdmissionStatusEnum.IN_CONSULTATION.getValue());
            }
        }
        if (count != null) {
            Integer currentNum = adm.getCurrentNum() + count;
            if (currentNum > adm.getTotalNum()) return resultData.error("\u589e\u52a0\u6761\u6570\u8d85\u8fc7\u5141\u8bb8\u4e0a\u9650");
            adm.setCurrentNum(currentNum);
        }
        if ((countTotal = this.admissionMapper.update(adm)) != 1) return resultData.error("\u4fee\u6539\u5931\u8d25");
        return resultData.success((Object)"\u4fee\u6539\u6210\u529f");
    }

    private boolean checkAdmStatus(AdmissionEntity entity) {
        Integer status = entity.getStatus();
        return status.equals(AdmissionStatusEnum.IN_CONSULTATION.getValue()) || status.equals(AdmissionStatusEnum.FINISH_APPLY.getValue()) || status.equals(AdmissionStatusEnum.FINISH_TIME_OUT.getValue());
    }

    private boolean checkAdmStatusForNum(AdmissionEntity entity) {
        Integer status = entity.getStatus();
        return status.equals(AdmissionStatusEnum.IN_CONSULTATION.getValue()) || status.equals(AdmissionStatusEnum.FINISH_APPLY.getValue());
    }

    public ResultData<PatientInfoRes> selectPatientNameByPhone(PatientAccountReq req) {
        ResultData result = new ResultData();
        PatientInfoRes patientName = this.patientMapper.selectPatientNameByPhone(req.getPatientAccount(), req.getCardNo());
        return result.success((Object)patientName);
    }

    public BaseResponse<Map> queryAppealInfos(AppealAllDTO reqVo) {
        log.info("\u5165\u53c2\u4e3a:{}" + reqVo.toString());
        String key = APPEAL_MANAGER_KEY + reqVo.getUserId();
        log.info("userId" + reqVo.getUserId());
        log.info("\u83b7\u53d6\u7533\u8bf7\u7ba1\u7406\u7684\u6570\u636e\u6743\u9650key: " + key);
        AppealAllInfoDTO appealAllInfoDTO = new AppealAllInfoDTO();
        BaseResponse hospitalIds = this.dataScopeClient.getPermissionsByKey(key);
        log.info("permissionsByKey :{}", (Object)JSON.toJSONString((Object)hospitalIds));
        if (!hospitalIds.isSuccess() && StringUtils.isEmpty((String)((String)hospitalIds.getData()))) {
            return BaseResponse.error((String)"\u7533\u8bc9\u7ba1\u7406\u6570\u636e\u6743\u9650\u67e5\u8be2\u5931\u8d25");
        }
        log.info("\u83b7\u53d6\u7684\u533b\u9662\u7684id\u4e3a\uff1a{}", hospitalIds.getData());
        BeanUtils.copyProperties((Object)reqVo, (Object)appealAllInfoDTO);
        appealAllInfoDTO.setHospitalIds((String)hospitalIds.getData());
        log.info("appealAllInfoDTO\uff1a{}", (Object)appealAllInfoDTO.toString());
        BaseResponse mapBaseResponse = this.appealFeignClient.queryAppealAllInfo(appealAllInfoDTO);
        log.info("mapBaseResponse:{} ", (Object)mapBaseResponse.toString());
        log.info("\u8c03\u533b\u751f\u670d\u52a1\u83b7\u53d6\u7684\u4fe1\u606f\u4e3a\uff1a{}", mapBaseResponse.getData());
        if (mapBaseResponse.getData() == null) {
            return BaseResponse.success();
        }
        Map result1 = (Map)((Map)mapBaseResponse.getData()).get("result");
        log.info("\u83b7\u53d6\u7684map\u7684\u7ed3\u679c\u4e3a:{}" + result1.toString());
        List appealInfolist = JsonUtil.json2ListBean((String)JsonUtil.toJson(result1.get("content")), AppealAllInfoVO.class);
        for (AppealAllInfoVO appealInfo : appealInfolist) {
            String dealSeq = appealInfo.getAdmissionId();
            OrderIdAndDealSeqRes res = this.managerOrderMapper.queryOrderId(dealSeq);
            if (res == null) continue;
            appealInfo.setAdmissionId(res.getAdmissionId());
            appealInfo.setOrderId(res.getOrderId());
            appealInfo.setDealSeq(res.getDealSeq());
            log.info("\u67e5\u8be2\u5230\u7684\u8ba2\u5355\u7684\u4fe1\u606f\u4e3a\uff1a{}" + res.toString());
        }
        HashMap hashMap1 = new HashMap(10);
        HashMap hashMap = new HashMap(10);
        hashMap.put("pageNum", result1.get("pageNum"));
        hashMap.put("pageSize", result1.get("pageSize"));
        hashMap.put("totalPages", result1.get("totalPages"));
        hashMap.put("total", result1.get("total"));
        hashMap1.put("queryAppealTotalVo", ((Map)mapBaseResponse.getData()).get("queryAppealTotalVo"));
        hashMap1.put("result", hashMap);
        hashMap.put("content", appealInfolist);
        log.info("\u5f97\u5230\u7684map\u4e3a\uff1a{}" + JSON.toJSONString(hashMap));
        log.info("hashMap1:{}" + JSON.toJSONString(hashMap1));
        return BaseResponse.success(hashMap1);
    }

    public ResultData<String> appealCompleta(@RequestBody UpdateDealDTO updateDealDTO) {
        ResultData result = new ResultData();
        UpdateDealStatusDTO updateDealStatusDTO = new UpdateDealStatusDTO();
        BeanUtils.copyProperties((Object)updateDealDTO, (Object)updateDealStatusDTO);
        BaseResponse listResultData = this.appealFeignClient.updateDealStatus(updateDealStatusDTO);
        if (listResultData.getData() != null) {
            OrderIdAndDealSeqRes res = this.managerOrderMapper.queryOrderId(((AppealEntity)listResultData.getData()).getServLogId());
            if (null == res) {
                return result.error("\u65e0\u6cd5\u83b7\u53d6admissionId");
            }
            this.imInformService.appealSuccess(res.getAdmissionId());
        }
        return result.success();
    }

    public BaseResponse<String> initiateAppeal(AppealDetailReqVo appealDetailDTO) {
        if (StringUtils.isNotEmpty((String)appealDetailDTO.getAdmissionId())) {
            AdmissionEntity admissionEntity = this.admissionMapper.findByAdmId(appealDetailDTO.getAdmissionId());
            appealDetailDTO.setDoctorId(admissionEntity.getDoctorId());
        }
        return this.imInformService.doctorRefundAppeal(appealDetailDTO.getAdmissionId(), appealDetailDTO.getDoctorId());
    }

    public ResultData<AppealDetailsVO> queryAppealDetail(AppealDetailDTO appealDetailDTO) {
        ResultData objectResultData = new ResultData();
        BaseResponse appealDetailVoResultData = this.appealFeignClient.queryAppealDetailInfo(appealDetailDTO);
        log.info("appealDetailVOResultData :{}", (Object)JSON.toJSONString((Object)appealDetailVoResultData));
        AppealDetailsVO appealDetailsVO = new AppealDetailsVO();
        QueryAppealOrderTypeDTO queryAppealOrderTypeDTO = new QueryAppealOrderTypeDTO();
        OrderIdAndDealSeqRes orderIdAndDealSeqRes = null;
        if (null != appealDetailVoResultData.getData()) {
            for (DocAppealRemarkVo appealDetailVO : ((AppealDetailVO)appealDetailVoResultData.getData()).getRemark()) {
                if (appealDetailVO.getStatus() != null && appealDetailVO.getStatus() == 2) {
                    appealDetailVO.setAppealTime(appealDetailVO.getProcessTime());
                }
                if (appealDetailVO.getStatus() == null || appealDetailVO.getStatus() != 1) continue;
                appealDetailVO.setProcessTime(appealDetailVO.getAppealTime());
            }
            BeanUtils.copyProperties((Object)appealDetailVoResultData.getData(), (Object)appealDetailsVO);
            appealDetailsVO.setAppealTime(((AppealDetailVO)appealDetailVoResultData.getData()).getAppealTime());
            appealDetailsVO.setProcessTime(((AppealDetailVO)appealDetailVoResultData.getData()).getProcessTime());
            String dealSeq = ((AppealDetailVO)appealDetailVoResultData.getData()).getAdmissionId();
            orderIdAndDealSeqRes = this.managerOrderMapper.queryOrderId(dealSeq);
            if (orderIdAndDealSeqRes != null) {
                queryAppealOrderTypeDTO.setAdmissionId(orderIdAndDealSeqRes.getAdmissionId());
            }
        }
        appealDetailsVO.setAppealType(this.queryAppealOrderType(queryAppealOrderTypeDTO));
        log.info("appealDetailsVO :{}" + appealDetailDTO.toString());
        try {
            List resList;
            ArrayList<AppealAllInfoVO> queryList = new ArrayList<AppealAllInfoVO>(1);
            AppealAllInfoVO queryVO = new AppealAllInfoVO();
            queryVO.setAdmissionId(orderIdAndDealSeqRes.getDealSeq());
            queryList.add(queryVO);
            ResultData appeal = this.queryAppealInfo(queryList);
            if (appeal != null && appeal.isSuccess() && (resList = (List)appeal.getData()) != null && resList.size() > 0) {
                AppealAllInfoVO resVO = (AppealAllInfoVO)resList.get(0);
                appealDetailsVO.setAppealId(resVO.getDealSeq());
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7533\u8bc9\u8ba2\u5355\u53f7 - \u67e5\u8be2\u5931\u8d25 - admId:{}", (Object)orderIdAndDealSeqRes.getAdmissionId());
            appealDetailsVO.setAppealId("\u8ba2\u5355\u53f7\u67e5\u8be2\u8d85\u65f6");
        }
        return objectResultData.success((Object)appealDetailsVO);
    }

    public BaseResponse<AppealDetailVO> checkAppeal(AppealDetailDTO appealDetailDTO) {
        return this.appealFeignClient.queryAppealDetailInfo(appealDetailDTO);
    }

    public String queryAppealOrderType(QueryAppealOrderTypeDTO param) {
        ResultData result = new ResultData();
        AdmissionEntity admissionEntity = this.admissionMapper.findById(param.getAdmissionId());
        if (admissionEntity == null) {
            return "\u6ca1\u6709\u6b64\u6761\u5c31\u8bca\u8bb0\u5f55";
        }
        String doctorType = "\u4e2a\u4eba";
        String serviceType = ServiceTypeEnum.getDesc((Integer)admissionEntity.getServType());
        QueryAppealOrderTypeVO queryAppealOrderTypeVO = new QueryAppealOrderTypeVO(doctorType + serviceType);
        if (queryAppealOrderTypeVO == null) {
            return null;
        }
        return queryAppealOrderTypeVO.getAppealOrderType();
    }

    public ResultData<List<AppealAllInfoVO>> queryAppealInfo(List<AppealAllInfoVO> reqVo) {
        ResultData result = new ResultData();
        for (AppealAllInfoVO appealInfo : reqVo) {
            String admId = appealInfo.getAdmissionId();
            OrderIdAndDealSeqRes res = this.managerOrderMapper.queryOrderId(admId);
            appealInfo.setDealSeq(res.getDealSeq());
            appealInfo.setOrderId(res.getOrderId());
        }
        result.success(reqVo);
        return result;
    }

    public BaseResponse exportOrderExcelByIds(RequestManageOrderListVo vo, HttpServletResponse response) {
        int i;
        QueryOrderInfoDTO dto = new QueryOrderInfoDTO();
        String key = ONLINE_OUTPATIENT_KEY + vo.getUserId();
        log.info("\u4e0b\u8f7d\u5165\u53c2vo:{}", (Object)JSON.toJSONString((Object)vo));
        log.info("\u67e5\u8be2\u5728\u7ebf\u95ee\u8bca\u6570\u636e\u6743\u9650key:{} ", (Object)key);
        if (StringUtils.isEmpty((String)vo.getHospitalId())) {
            BaseResponse hospitalIds = this.dataScopeClient.getPermissionsByKey(key);
            log.info("permissionsByKey :{}", (Object)JSON.toJSONString((Object)hospitalIds));
            if (!hospitalIds.isSuccess() && hospitalIds.getData() == null) {
                return BaseResponse.error((String)"\u5728\u7ebf\u95ee\u8bca\u6570\u636e\u6743\u9650\u67e5\u8be2\u5931\u8d25");
            }
            dto.setHospitalIds((String)hospitalIds.getData());
        } else {
            dto.setHospitalIds(vo.getHospitalId());
        }
        List<Integer> list1 = new ArrayList();
        if (Objects.nonNull(vo.getAttachStatus())) {
            if (AdmissionStatusEnum.DOCTOR_CLOSED_SCHEDULE.getValue() == vo.getAttachStatus()) {
                list1.add(AdmissionStatusEnum.DOCTOR_CLOSED_WATING_SCHEDULE.getValue());
            }
            if (AdmissionStatusEnum.ADMIN_REFUNDED.getValue() == vo.getAttachStatus()) {
                list1.add(AdmissionStatusEnum.ADMIN_REFUNDED_ADMISSION.getValue());
            }
            if (AdmissionStatusEnum.NOT_RECEIVED_TIME_OUT.getValue() == vo.getAttachStatus()) {
                list1.add(AdmissionStatusEnum.REFUNDED_REFUSE_ZERO.getValue());
            }
            if (AdmissionStatusEnum.FINISH_TIME_OUT.getValue() == vo.getAttachStatus()) {
                list1.add(AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue());
            }
            list1.add(vo.getAttachStatus());
        } else {
            list1 = this.setStatus(vo);
        }
        dto.setStatusList(list1);
        dto.setDateType(vo.getDateType());
        dto.setAppCode(vo.getAppCode());
        dto.setCreateTimeStart(vo.getTimeStart() + " 00:00:00");
        dto.setCreateTimeEnd(vo.getTimeEnd() + " 23:59:59");
        dto.setSearchParams(vo.getSearchParams().replace("_", "\\_").replace("%", "\\%"));
        dto.setDoctorType(vo.getDoctorType());
        dto.setServType(vo.getServType());
        dto.setDeptId(vo.getDeptId());
        dto.setFundType(vo.getFundType());
        dto.setSmallProgramSource(vo.getSmallProgramSource());
        List orderList = this.managerOrderMapper.selectOrderListByIds(dto);
        ArrayList doctorIdList = new ArrayList();
        orderList.stream().forEach(item -> doctorIdList.add(Long.valueOf(item.getDoctorId())));
        HashMap map = new HashMap(100);
        orderList.stream().forEach(item -> map.put(item.getDoctorId(), item.getDoctorId()));
        ArrayList<String> list = new ArrayList<String>();
        for (String doctorId : map.keySet()) {
            list.add(doctorId);
        }
        ArrayList doctorInfoList = new ArrayList();
        if (Objects.nonNull(orderList) && orderList.size() > 0) {
            ArrayList sortList = null;
            int frequency = list.size() / 10;
            for (i = 0; i <= frequency; ++i) {
                sortList = new ArrayList();
                for (int j = i * 10; j < i * 10 + 10; ++j) {
                    if (j >= list.size()) continue;
                    sortList.add(list.get(j));
                }
                if (CollectionUtils.isEmpty(sortList)) continue;
                log.info("\u6279\u91cf\u67e5\u8be2\u533b\u751f\u4fe1\u606f\uff1a\u533b\u751f\u7f16\u53f7{}\uff0c\u533b\u9662\u7f16\u53f7\uff1a{}", sortList, (Object)((ExportOrderExcelVo)orderList.get(0)).getOrganId());
                BaseResponse doctorInfoListResponse = this.DoctorBaseApi.getDoctorPostByDoctorIds(sortList);
                log.info("\u6279\u91cf\u67e5\u8be2\u533b\u751f\u4fe1\u606f\u7ed3\u679c\uff1a{}", (Object)doctorInfoListResponse);
                doctorInfoList.addAll((Collection)doctorInfoListResponse.getData());
            }
        }
        if (!CollectionUtils.isEmpty(doctorInfoList)) {
            Map<Long, String> collect = doctorInfoList.stream().filter(doctorInfo -> StringUtils.isNotBlank((String)doctorInfo.getEmplCode())).collect(Collectors.toMap(DoctorPostRepVO::getId, DoctorPostRepVO::getEmplCode, (key1, key2) -> key2));
            for (ExportOrderExcelVo exportOrderExcelVo : orderList) {
                exportOrderExcelVo.setDocHisJobNumber(collect.get(Long.valueOf(exportOrderExcelVo.getDoctorId())));
            }
        }
        if (Objects.nonNull(vo.getDateType()) && vo.getDateType().equals(3) && StringUtils.isNotEmpty((String)vo.getTimeStart()) && StringUtils.isNotEmpty((String)vo.getTimeEnd())) {
            orderList.sort(Comparator.comparing(ExportOrderExcelVo::getScheduleDate).thenComparing(ExportOrderExcelVo::getScheduleStartTime).reversed());
        }
        log.info("\u67e5\u8be2\u5230\u7684\u8bb0\u5f55\u4e3a\uff1a{}" + JSON.toJSONString((Object)orderList));
        MedicineCloudReqVo medicineCloudReqVo = new MedicineCloudReqVo();
        medicineCloudReqVo.setAppCode(vo.getAppCode());
        ArrayList<String> orderIds = new ArrayList<String>();
        for (i = 0; i < orderList.size(); ++i) {
            orderIds.add(((ExportOrderExcelVo)orderList.get(i)).getOrderId());
        }
        medicineCloudReqVo.setOrderIds(orderIds);
        List outExportResVoList = this.getMedicineCloudExcel(medicineCloudReqVo);
        ArrayList<ExportOrderExcel> exportOrderExcelList = new ArrayList<ExportOrderExcel>();
        for (ExportOrderExcelVo exportOrderExcelVo : orderList) {
            ExportOrderExcel exportOrderExcel = new ExportOrderExcel();
            exportOrderExcel.setPayMethod(PayChannelEnum.getDescValue((String)exportOrderExcelVo.getPayMethod()));
            String payTime = DateUtils.dateToString((Date)exportOrderExcelVo.getPaymentTime(), (String)"yyyy-MM-dd HH:mm:ss");
            exportOrderExcel.setPaymentTime(payTime);
            exportOrderExcel.setDescription(exportOrderExcelVo.getDescription());
            exportOrderExcel.setDeptName(exportOrderExcelVo.getDeptName());
            exportOrderExcel.setDoctorName(exportOrderExcelVo.getDoctorName());
            exportOrderExcel.setHospitalName(exportOrderExcelVo.getHospitalName());
            exportOrderExcel.setIllnessTime(exportOrderExcelVo.getIllnessTime());
            exportOrderExcel.setPatientName(exportOrderExcelVo.getPatientName());
            exportOrderExcel.setMedicalOpinion(exportOrderExcelVo.getMedicalOpinion());
            exportOrderExcel.setQuestion(exportOrderExcelVo.getQuestion());
            Double amount = exportOrderExcelVo.getPayAmount().doubleValue();
            String payAmount = "\u00a5" + amount.toString();
            exportOrderExcel.setPayPrice(payAmount);
            exportOrderExcel.setTags(exportOrderExcelVo.getTags());
            if (Objects.isNull(exportOrderExcelVo.getVisited())) {
                exportOrderExcel.setVisited(Integer.valueOf(0));
            } else {
                exportOrderExcel.setVisited(exportOrderExcelVo.getVisited());
            }
            exportOrderExcel.setOrderId(exportOrderExcelVo.getOrderId());
            String createTime = DateUtils.dateToString((Date)exportOrderExcelVo.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss");
            exportOrderExcel.setCreateTime(createTime);
            String updateTime = DateUtils.dateToString((Date)exportOrderExcelVo.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss");
            exportOrderExcel.setUpdateTime(updateTime);
            Integer admStatus = exportOrderExcelVo.getStatus();
            exportOrderExcel.setDisplay(AdmissionStatusEnum.getDisplay((Integer)admStatus));
            if (0 == new BigDecimal(0.0).compareTo(exportOrderExcelVo.getPayAmount())) {
                exportOrderExcel.setDisplay(exportOrderExcel.getDisplay().replace("\u5df2\u9000\u6b3e\uff0c", ""));
            }
            exportOrderExcel.setBankTradeNo(exportOrderExcelVo.getBankTradeNo());
            exportOrderExcel.setDocHisJobNumber(exportOrderExcelVo.getDocHisJobNumber());
            if (exportOrderExcelVo.getScheduleDate() != null) {
                String scheduledate = DateUtils.dateToSimpleString((Date)exportOrderExcelVo.getScheduleDate());
                String scheduleTime = scheduledate + " " + exportOrderExcelVo.getScheduleStartTime() + "~" + exportOrderExcelVo.getScheduleEndTime();
                exportOrderExcel.setScheduleTime(scheduleTime);
            }
            if (ServiceTypeEnum.NOS.getValue().equals(exportOrderExcelVo.getServType()) && "HYT".equals(exportOrderExcelVo.getAppCode())) {
                if (OWN_EXPENSE.equals(exportOrderExcelVo.getFundType())) {
                    exportOrderExcel.setFundType("\u81ea\u8d39");
                } else {
                    exportOrderExcel.setFundType("\u533b\u4fdd");
                }
            }
            if (admStatus.equals(1)) {
                exportOrderExcel.setStatus(AdmissionStatusEnum.TO_BE_RECEIVED.getDesc());
            } else if (admStatus.equals(2)) {
                exportOrderExcel.setStatus(AdmissionStatusEnum.IN_CONSULTATION.getDesc());
            } else if (admStatus.equals(4) || admStatus.equals(5) || admStatus.equals(6) || admStatus.equals(111) || admStatus.equals(15) || admStatus.equals(112) || admStatus.equals(113) || admStatus.equals(45) || admStatus.equals(46)) {
                exportOrderExcel.setStatus(INVALID_STATUS_DESC);
            } else if (admStatus.equals(7) || admStatus.equals(8) || admStatus.equals(9)) {
                exportOrderExcel.setStatus(AdmissionStatusEnum.FINISH_APPLY.getDesc());
            } else if (admStatus.equals(30)) {
                exportOrderExcel.setStatus(INVALID_STATUS_DESC);
            } else if (admStatus.equals(20)) {
                exportOrderExcel.setStatus(AdmissionStatusEnum.WAIT_ADMISSION.getDesc());
            } else if (admStatus.equals(10)) {
                exportOrderExcel.setStatus(INVALID_STATUS_DESC);
            } else if (admStatus.equals(40) || AdmissionStatusEnum.REFERRAL_MANAGER_FINISH.getValue().equals(admStatus) || AdmissionStatusEnum.REFERRAL_MANAGER.getValue().equals(admStatus)) {
                exportOrderExcel.setStatus(STATUS_DESC);
            } else if (admStatus.equals(0)) {
                exportOrderExcel.setStatus(INVALID_STATUS_DESC);
            }
            if (null == outExportResVoList || outExportResVoList.size() == 0) {
                exportOrderExcelList.add(exportOrderExcel);
                continue;
            }
            for (OutExportResVo excelOrderVo : outExportResVoList) {
                if (!exportOrderExcelVo.getOrderId().equals(excelOrderVo.getOrderId())) continue;
                exportOrderExcel.setMainCount(excelOrderVo.getMainCount());
                DecimalFormat amountFormat = new DecimalFormat("\u00a50.00");
                String pay = amountFormat.format(excelOrderVo.getPayAmount());
                exportOrderExcel.setPayAmount(pay);
                exportOrderExcel.setPayCount(excelOrderVo.getPayCount());
                DecimalFormat sumAmountFormat = new DecimalFormat("\u00a50.00");
                log.info("excelOrderVo{}", (Object)JSON.toJSONString((Object)excelOrderVo));
                String sumAmount = sumAmountFormat.format(excelOrderVo.getSumAmount());
                exportOrderExcel.setSumAmount(sumAmount);
            }
            exportOrderExcelList.add(exportOrderExcel);
        }
        log.info("\u5728\u7ebf\u95ee\u8bca\u7684\u5bfc\u51faexcel\u4e3a:{}" + JSON.toJSONString(exportOrderExcelList));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateTime = simpleDateFormat.format(new Date());
        String fileName = FILE_NAME + dateTime;
        ExcelUtils.exportExcel(exportOrderExcelList, null, null, ExportOrderExcel.class, (String)fileName, (boolean)true, (HttpServletResponse)response);
        return BaseResponse.success();
    }

    public void exportOrderExcelNCZK(RequestManageOrderListNCZKVo vo, HttpServletResponse response) {
        String beginDate = StringUtils.isNotEmpty((String)vo.getBeginDate()) ? vo.getBeginDate() + " 00:00:00" : "";
        String endDate = StringUtils.isNotEmpty((String)vo.getEndDate()) ? vo.getEndDate() + " 23:59:59" : "";
        List orderList = this.managerOrderMapper.selectOrderListForNCZK(beginDate, endDate, vo.getStatus());
        orderList.stream().forEach(entity -> {
            entity.setStatus(AdmissionStatusEnum.getDesc((Integer)Integer.parseInt(entity.getStatus())));
            entity.setType("\u6781\u901f\u5f00\u65b9");
        });
        log.info("\u5728\u7ebf\u95ee\u8bca\u7684\u5bfc\u51faexcel\u4e3a:{}" + JSON.toJSONString((Object)orderList));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateTime = simpleDateFormat.format(new Date());
        String fileName = FILE_NAME + dateTime;
        ExcelUtils.exportExcel((List)orderList, null, null, ExportOrderExcelNCZKVo.class, (String)fileName, (boolean)true, (HttpServletResponse)response);
    }

    private List<OutExportResVo> getMedicineCloudExcel(MedicineCloudReqVo medicineCloudReqVo) {
        log.info("\u8bf7\u6c42\u533b\u836f\u4e91\u5bfc\u51faexcel\u5b57\u6bb5\u63a5\u53e3\u5165\u53c2:{}" + medicineCloudReqVo.toString());
        try {
            HashMap<String, String> headerMap = new HashMap<String, String>(10);
            headerMap.put("appCode", medicineCloudReqVo.getAppCode());
            String result = HttpKit.jsonPost((String)this.projProperties.getMedicineCloudExcel(), (String)JSON.toJSONString((Object)medicineCloudReqVo), headerMap);
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), BaseResponse.class);
            List outExportResVoList = JSON.parseArray((String)JSON.toJSONString((Object)baseResponse.getData()), OutExportResVo.class);
            log.info("\u533b\u836f\u4e91\u5bfc\u51faexcel\u8fd4\u56de\u503c\u662f:{} " + outExportResVoList.toString());
            return outExportResVoList;
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u533b\u836f\u4e91\u63a5\u53e3\u5931\u8d25" + e.getMessage());
            return null;
        }
    }

    public BaseResponse<?> getHospitalListByKey(String userId, GetHospitalListReqVo getHospitalListReqVo) {
        String appCode = getHospitalListReqVo.getAppCode();
        String key = ONLINE_OUTPATIENT_KEY + userId;
        BaseResponse permissionsByKey = this.dataScopeClient.getPermissionsByKey(key);
        log.info("permissionsByKey :{}", (Object)JSON.toJSONString((Object)permissionsByKey));
        BaseResponse response = null;
        if (permissionsByKey.isSuccess() && !((String)permissionsByKey.getData()).equals(null)) {
            String url = this.projProperties.getHospitalListUrl();
            if ("-1".equals(permissionsByKey.getData())) {
                url = MessageFormat.format(url, appCode, "");
            }
            if (!"-1".equals(permissionsByKey.getData())) {
                url = MessageFormat.format(url, appCode, permissionsByKey.getData());
            }
            log.info("url :{}", (Object)JSON.toJSONString((Object)url));
            String s = null;
            try {
                s = HttpKit.get((String)url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            log.info("s{}", (Object)s);
            response = (BaseResponse)JSONObject.parseObject((String)s, BaseResponse.class);
        }
        return BaseResponse.success(response);
    }

    public List<Integer> buildStatusList(Integer status) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (status.equals(4)) {
            list.add(AdmissionStatusEnum.REFUNDED_REFUSE.getValue());
            list.add(AdmissionStatusEnum.NOT_RECEIVED_TIME_OUT.getValue());
            list.add(AdmissionStatusEnum.REFUNDED_APPLY.getValue());
            list.add(AdmissionStatusEnum.RETIRED.getValue());
            list.add(AdmissionStatusEnum.TO_BE_RECEIVED_REFUND.getValue());
            list.add(AdmissionStatusEnum.ADMIN_REFUNDED.getValue());
            list.add(AdmissionStatusEnum.ADMIN_REFUNDED_ADMISSION.getValue());
            list.add(AdmissionStatusEnum.EXPIRED.getValue());
            list.add(AdmissionStatusEnum.CANCEL.getValue());
            list.add(AdmissionStatusEnum.REFUNDED_REFUSE_ZERO.getValue());
            list.add(AdmissionStatusEnum.DOCTOR_CLOSED_SCHEDULE.getValue());
            list.add(AdmissionStatusEnum.DOCTOR_CLOSED_WATING_SCHEDULE.getValue());
        } else if (status.equals(7)) {
            list.add(AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue());
            list.add(AdmissionStatusEnum.FINISH_APPLY.getValue());
            list.add(AdmissionStatusEnum.FINISH_TIME_OUT.getValue());
        } else if (Integer.valueOf(40).equals(status)) {
            list.add(AdmissionStatusEnum.REFERRAL_MANAGER.getValue());
            list.add(AdmissionStatusEnum.REFERRAL.getValue());
            list.add(AdmissionStatusEnum.REFERRAL_MANAGER_FINISH.getValue());
        } else {
            list.add(status);
        }
        return list;
    }

    public BaseResponse<List<OrderIdAndDealSeqRes>> getOrderListBypatientId(String patientId) {
        List orderBypatientIdList = this.orderMapper.getOrderListBypatientId(patientId);
        if (CollectionUtils.isEmpty((Collection)orderBypatientIdList)) {
            return BaseResponse.success(new ArrayList());
        }
        return BaseResponse.success((Object)orderBypatientIdList);
    }

    public BaseResponse<List<OrderListForCountResVo>> getOrderList(OrderListForCountReqVo orderListForCountReqVo) {
        ArrayList orderListForCountList = new ArrayList();
        List orderListZX = this.getOrderListZX(orderListForCountReqVo);
        log.info("\u83b7\u53d6\u8ba2\u5355\u6570\u636e-\u54a8\u8be2-\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)orderListZX));
        orderListForCountReqVo.setServType(ServiceTypeEnum.NOS.getValue());
        List orderListFZ = this.getOrderListFZ(orderListForCountReqVo);
        log.info("\u83b7\u53d6\u8ba2\u5355\u6570\u636e-\u590d\u8bca-\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)orderListFZ));
        orderListZX.addAll(orderListFZ);
        orderListForCountList.addAll(orderListZX);
        log.info("\u83b7\u53d6\u8ba2\u5355\u6570\u636e\u51fa\u53c2{}", (Object)((Object)orderListForCountList).toString());
        return BaseResponse.success(orderListForCountList);
    }

    private List<OrderListForCountResVo> getOrderListZX(OrderListForCountReqVo orderListForCountReqVo) {
        ArrayList<OrderListForCountResVo> orderResList = new ArrayList<OrderListForCountResVo>();
        OrderListForCountResVo newPatientZX = new OrderListForCountResVo();
        OrderListForCountResVo completedZX = new OrderListForCountResVo();
        OrderListForCountResVo expiredZX = new OrderListForCountResVo();
        OrderListForCountResVo undoneZX = new OrderListForCountResVo();
        OrderListForCountResVo newOrderZX = new OrderListForCountResVo();
        OrderListForCountResVo newAmountZX = new OrderListForCountResVo();
        OrderListForCountResVo completedAmountZX = new OrderListForCountResVo();
        OrderListForCountResVo refunAmountZX = new OrderListForCountResVo();
        OrderListForCountResVo timeOutOrderZX = new OrderListForCountResVo();
        OrderListForCountResVo refundOrderZX = new OrderListForCountResVo();
        expiredZX.setStartTime(orderListForCountReqVo.getStartTime());
        expiredZX.setEndTime(orderListForCountReqVo.getEndTime());
        expiredZX.setServType(ServiceTypeEnum.HOS.getValue());
        expiredZX.setOrderStatus(ImmediateConsultationVoTypeEnum.TYPE_RETURN.getValue());
        expiredZX.setUnit(WhetherEnum.ALLOW.getValue());
        undoneZX.setStartTime(orderListForCountReqVo.getStartTime());
        undoneZX.setEndTime(orderListForCountReqVo.getEndTime());
        undoneZX.setServType(ServiceTypeEnum.HOS.getValue());
        undoneZX.setOrderStatus(ImmediateConsultationVoTypeEnum.IN_CONSULTATION.getValue());
        undoneZX.setUnit(WhetherEnum.ALLOW.getValue());
        completedZX.setStartTime(orderListForCountReqVo.getStartTime());
        completedZX.setEndTime(orderListForCountReqVo.getEndTime());
        completedZX.setServType(ServiceTypeEnum.HOS.getValue());
        completedZX.setOrderStatus(ImmediateConsultationVoTypeEnum.TOPAY.getValue());
        completedZX.setUnit(WhetherEnum.ALLOW.getValue());
        newOrderZX.setStartTime(orderListForCountReqVo.getStartTime());
        newOrderZX.setEndTime(orderListForCountReqVo.getEndTime());
        newOrderZX.setServType(ServiceTypeEnum.HOS.getValue());
        newOrderZX.setOrderStatus(ImmediateConsultationVoTypeEnum.OK.getValue());
        newOrderZX.setUnit(WhetherEnum.ALLOW.getValue());
        newPatientZX.setStartTime(orderListForCountReqVo.getStartTime());
        newPatientZX.setEndTime(orderListForCountReqVo.getEndTime());
        newPatientZX.setServType(ServiceTypeEnum.HOS.getValue());
        newPatientZX.setOrderStatus(ImmediateConsultationVoTypeEnum.WAIT_ADMISSION.getValue());
        newPatientZX.setUnit(WhetherEnum.FORBID.getValue());
        timeOutOrderZX.setStartTime(orderListForCountReqVo.getStartTime());
        timeOutOrderZX.setEndTime(orderListForCountReqVo.getEndTime());
        timeOutOrderZX.setServType(ServiceTypeEnum.HOS.getValue());
        timeOutOrderZX.setOrderStatus(ImmediateConsultationVoTypeEnum.TIMEOUT_ORDER.getValue());
        timeOutOrderZX.setUnit(WhetherEnum.ALLOW.getValue());
        refundOrderZX.setStartTime(orderListForCountReqVo.getStartTime());
        refundOrderZX.setEndTime(orderListForCountReqVo.getEndTime());
        refundOrderZX.setServType(ServiceTypeEnum.HOS.getValue());
        refundOrderZX.setOrderStatus(ImmediateConsultationVoTypeEnum.REFUND_ORDER.getValue());
        refundOrderZX.setUnit(WhetherEnum.ALLOW.getValue());
        newAmountZX.setStartTime(orderListForCountReqVo.getStartTime());
        newAmountZX.setEndTime(orderListForCountReqVo.getEndTime());
        newAmountZX.setServType(ServiceTypeEnum.HOS.getValue());
        newAmountZX.setOrderStatus(ImmediateConsultationVoTypeEnum.NEW_MOUNT.getValue());
        newAmountZX.setUnit(WhetherEnum.ALLOW.getValue());
        completedAmountZX.setStartTime(orderListForCountReqVo.getStartTime());
        completedAmountZX.setEndTime(orderListForCountReqVo.getEndTime());
        completedAmountZX.setServType(ServiceTypeEnum.HOS.getValue());
        completedAmountZX.setOrderStatus(ImmediateConsultationVoTypeEnum.COMPLETED_AMOUNT.getValue());
        completedAmountZX.setUnit(WhetherEnum.ALLOW.getValue());
        refunAmountZX.setStartTime(orderListForCountReqVo.getStartTime());
        refunAmountZX.setEndTime(orderListForCountReqVo.getEndTime());
        refunAmountZX.setServType(ServiceTypeEnum.HOS.getValue());
        refunAmountZX.setOrderStatus(ImmediateConsultationVoTypeEnum.REFUN_AMOUNT.getValue());
        refunAmountZX.setUnit(WhetherEnum.ALLOW.getValue());
        if (StringUtils.isEmpty((String)orderListForCountReqVo.getStartTime()) || StringUtils.isEmpty((String)orderListForCountReqVo.getEndTime())) {
            String currentDateStr = DateUtils.getCurrentDateSimpleToString();
            String yestarDayStr = DateUtils.getYestarDayToString((String)currentDateStr);
            orderListForCountReqVo.setStartTime(yestarDayStr);
            orderListForCountReqVo.setEndTime(yestarDayStr);
        }
        orderListForCountReqVo.setStartTime(orderListForCountReqVo.getStartTime() + " 00:00:00");
        orderListForCountReqVo.setEndTime(orderListForCountReqVo.getEndTime() + " 23:59:59");
        orderListForCountReqVo.setServType(ServiceTypeEnum.HOS.getValue());
        log.info("\u54a8\u8be2\u5165\u53c2{}", (Object)orderListForCountReqVo.toString());
        List admissionZxList = this.orderMapper.selectOrderDocCount(orderListForCountReqVo);
        log.info("\u54a8\u8be2\u66f4\u65b0\u65f6\u95f4\u6570\u636e{}", (Object)JSON.toJSONString((Object)admissionZxList));
        List admissionZxListCreateTime = this.orderMapper.selectOrderCountByCreateTime(orderListForCountReqVo);
        log.info("\u54a8\u8be2\u521b\u5efa\u65f6\u95f4\u6570\u636e{}", (Object)JSON.toJSONString((Object)admissionZxListCreateTime));
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        if (CollectionUtils.isEmpty((Collection)admissionZxListCreateTime) && CollectionUtils.isEmpty((Collection)admissionZxList)) {
            expiredZX.setCount(Integer.valueOf(0));
            undoneZX.setCount(Integer.valueOf(0));
            completedZX.setCount(Integer.valueOf(0));
            newOrderZX.setCount(Integer.valueOf(0));
            newPatientZX.setCount(Integer.valueOf(0));
            timeOutOrderZX.setCount(Integer.valueOf(0));
            refundOrderZX.setCount(Integer.valueOf(0));
            newAmountZX.setOrderMoney(decimalFormat.format(0.0));
            completedAmountZX.setOrderMoney(decimalFormat.format(0.0));
            refunAmountZX.setOrderMoney(decimalFormat.format(0.0));
        } else {
            ArrayList<OrderCountForMangVo> admCompleteList = new ArrayList<OrderCountForMangVo>();
            ArrayList<OrderCountForMangVo> admUndoneList = new ArrayList<OrderCountForMangVo>();
            ArrayList<OrderCountForMangVo> admExpiredList = new ArrayList<OrderCountForMangVo>();
            ArrayList<OrderCountForMangVo> admTimeOutList = new ArrayList<OrderCountForMangVo>();
            List<Object> admRefundList = new ArrayList<OrderCountForMangVo>();
            for (OrderCountForMangVo adm : admissionZxList) {
                if (AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(adm.getStatus()) || AdmissionStatusEnum.WAIT_ADMISSION.getValue().equals(adm.getStatus()) || AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(adm.getStatus())) {
                    admUndoneList.add(adm);
                }
                if (AdmissionStatusEnum.FINISH_APPLY.getValue().equals(adm.getStatus()) || AdmissionStatusEnum.FINISH_TIME_OUT.getValue().equals(adm.getStatus()) || AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue().equals(adm.getStatus())) {
                    admCompleteList.add(adm);
                }
                if (AdmissionStatusEnum.NOT_RECEIVED_TIME_OUT.getValue().equals(adm.getStatus()) || AdmissionStatusEnum.REFUNDED_REFUSE_ZERO.getValue().equals(adm.getStatus())) {
                    admTimeOutList.add(adm);
                }
                if ("3".equals(adm.getStatusOrder()) || "6".equals(adm.getStatusOrder())) {
                    admRefundList.add(adm);
                    BigDecimal bigDecimal = new BigDecimal("0.00");
                    admRefundList = admRefundList.stream().filter(item -> !bigDecimal.equals(item.getPayAmount())).collect(Collectors.toList());
                }
                if (!this.orderInvalidStatus(adm.getStatus())) continue;
                admExpiredList.add(adm);
            }
            expiredZX.setCount(Integer.valueOf(admExpiredList.size()));
            undoneZX.setCount(Integer.valueOf(admUndoneList.size()));
            completedZX.setCount(Integer.valueOf(admCompleteList.size()));
            newOrderZX.setCount(Integer.valueOf(admissionZxList.size()));
            timeOutOrderZX.setCount(Integer.valueOf(admTimeOutList.size()));
            refundOrderZX.setCount(Integer.valueOf(admRefundList.size()));
            completedAmountZX.setOrderMoney(decimalFormat.format(admCompleteList.stream().filter(x -> x.getOwnCost() != null).map(x -> new BigDecimal(x.getOwnCost())).reduce(BigDecimal.ZERO, BigDecimal::add)));
            refunAmountZX.setOrderMoney(decimalFormat.format(admExpiredList.stream().filter(x -> x.getOwnCost() != null && x.getRefundTime() != null).map(x -> new BigDecimal(x.getOwnCost())).reduce(BigDecimal.ZERO, BigDecimal::add)));
            newAmountZX.setOrderMoney(decimalFormat.format(admissionZxList.stream().filter(x -> x.getOwnCost() != null).map(x -> new BigDecimal(x.getOwnCost())).reduce(BigDecimal.ZERO, BigDecimal::add)));
            ArrayList collect = admissionZxList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<OrderCountForMangVo>(Comparator.comparing(OrderCountForMangVo::getPatientId))), ArrayList::new));
            newPatientZX.setCount(Integer.valueOf(collect.size()));
        }
        orderResList.add(completedZX);
        orderResList.add(newOrderZX);
        orderResList.add(undoneZX);
        orderResList.add(expiredZX);
        orderResList.add(newPatientZX);
        orderResList.add(newAmountZX);
        orderResList.add(completedAmountZX);
        orderResList.add(timeOutOrderZX);
        orderResList.add(refundOrderZX);
        orderResList.add(refunAmountZX);
        return orderResList;
    }

    private List<OrderListForCountResVo> getOrderListFZ(OrderListForCountReqVo orderListForCountReqVo) {
        ArrayList<OrderListForCountResVo> orderResList = new ArrayList<OrderListForCountResVo>();
        orderListForCountReqVo.setStartTime(StringUtils.substring((String)orderListForCountReqVo.getStartTime(), (int)0, (int)10));
        orderListForCountReqVo.setEndTime(StringUtils.substring((String)orderListForCountReqVo.getEndTime(), (int)0, (int)10));
        OrderListForCountResVo undoneFZ = new OrderListForCountResVo();
        OrderListForCountResVo newOrderFZ = new OrderListForCountResVo();
        OrderListForCountResVo expiredFZ = new OrderListForCountResVo();
        OrderListForCountResVo completedFZ = new OrderListForCountResVo();
        OrderListForCountResVo newPatientFZ = new OrderListForCountResVo();
        OrderListForCountResVo timeOutOrderFZ = new OrderListForCountResVo();
        OrderListForCountResVo refundOrderFZ = new OrderListForCountResVo();
        OrderListForCountResVo newAmountFZ = new OrderListForCountResVo();
        OrderListForCountResVo completedAmountFZ = new OrderListForCountResVo();
        OrderListForCountResVo refunAmountFZ = new OrderListForCountResVo();
        expiredFZ.setStartTime(orderListForCountReqVo.getStartTime());
        expiredFZ.setEndTime(orderListForCountReqVo.getEndTime());
        expiredFZ.setServType(ServiceTypeEnum.NOS.getValue());
        expiredFZ.setOrderStatus(ImmediateConsultationVoTypeEnum.TYPE_RETURN.getValue());
        expiredFZ.setUnit(WhetherEnum.ALLOW.getValue());
        undoneFZ.setStartTime(orderListForCountReqVo.getStartTime());
        undoneFZ.setEndTime(orderListForCountReqVo.getEndTime());
        undoneFZ.setServType(ServiceTypeEnum.NOS.getValue());
        undoneFZ.setOrderStatus(ImmediateConsultationVoTypeEnum.IN_CONSULTATION.getValue());
        undoneFZ.setUnit(WhetherEnum.ALLOW.getValue());
        completedFZ.setStartTime(orderListForCountReqVo.getStartTime());
        completedFZ.setEndTime(orderListForCountReqVo.getEndTime());
        completedFZ.setServType(ServiceTypeEnum.NOS.getValue());
        completedFZ.setOrderStatus(ImmediateConsultationVoTypeEnum.TOPAY.getValue());
        completedFZ.setUnit(WhetherEnum.ALLOW.getValue());
        newOrderFZ.setStartTime(orderListForCountReqVo.getStartTime());
        newOrderFZ.setEndTime(orderListForCountReqVo.getEndTime());
        newOrderFZ.setServType(ServiceTypeEnum.NOS.getValue());
        newOrderFZ.setOrderStatus(ImmediateConsultationVoTypeEnum.OK.getValue());
        newOrderFZ.setUnit(WhetherEnum.ALLOW.getValue());
        newPatientFZ.setStartTime(orderListForCountReqVo.getStartTime());
        newPatientFZ.setEndTime(orderListForCountReqVo.getEndTime());
        newPatientFZ.setServType(ServiceTypeEnum.NOS.getValue());
        newPatientFZ.setOrderStatus(ImmediateConsultationVoTypeEnum.WAIT_ADMISSION.getValue());
        newPatientFZ.setUnit(WhetherEnum.FORBID.getValue());
        timeOutOrderFZ.setStartTime(orderListForCountReqVo.getStartTime());
        timeOutOrderFZ.setEndTime(orderListForCountReqVo.getEndTime());
        timeOutOrderFZ.setServType(ServiceTypeEnum.NOS.getValue());
        timeOutOrderFZ.setOrderStatus(ImmediateConsultationVoTypeEnum.TIMEOUT_ORDER.getValue());
        timeOutOrderFZ.setUnit(WhetherEnum.ALLOW.getValue());
        refundOrderFZ.setStartTime(orderListForCountReqVo.getStartTime());
        refundOrderFZ.setEndTime(orderListForCountReqVo.getEndTime());
        refundOrderFZ.setServType(ServiceTypeEnum.NOS.getValue());
        refundOrderFZ.setOrderStatus(ImmediateConsultationVoTypeEnum.REFUND_ORDER.getValue());
        refundOrderFZ.setUnit(WhetherEnum.ALLOW.getValue());
        newAmountFZ.setStartTime(orderListForCountReqVo.getStartTime());
        newAmountFZ.setEndTime(orderListForCountReqVo.getEndTime());
        newAmountFZ.setServType(ServiceTypeEnum.NOS.getValue());
        newAmountFZ.setOrderStatus(ImmediateConsultationVoTypeEnum.NEW_MOUNT.getValue());
        newAmountFZ.setUnit(WhetherEnum.ALLOW.getValue());
        completedAmountFZ.setStartTime(orderListForCountReqVo.getStartTime());
        completedAmountFZ.setEndTime(orderListForCountReqVo.getEndTime());
        completedAmountFZ.setServType(ServiceTypeEnum.NOS.getValue());
        completedAmountFZ.setOrderStatus(ImmediateConsultationVoTypeEnum.COMPLETED_AMOUNT.getValue());
        completedAmountFZ.setUnit(WhetherEnum.ALLOW.getValue());
        refunAmountFZ.setStartTime(orderListForCountReqVo.getStartTime());
        refunAmountFZ.setEndTime(orderListForCountReqVo.getEndTime());
        refunAmountFZ.setServType(ServiceTypeEnum.NOS.getValue());
        refunAmountFZ.setOrderStatus(ImmediateConsultationVoTypeEnum.REFUN_AMOUNT.getValue());
        refunAmountFZ.setUnit(WhetherEnum.ALLOW.getValue());
        if (StringUtils.isEmpty((String)orderListForCountReqVo.getStartTime()) || StringUtils.isEmpty((String)orderListForCountReqVo.getEndTime())) {
            String currentDateStr = DateUtils.getCurrentDateSimpleToString();
            String yestarDayStr = DateUtils.getYestarDayToString((String)currentDateStr);
            orderListForCountReqVo.setStartTime(yestarDayStr);
            orderListForCountReqVo.setEndTime(yestarDayStr);
        }
        orderListForCountReqVo.setStartTime(orderListForCountReqVo.getStartTime() + " 00:00:00");
        orderListForCountReqVo.setEndTime(orderListForCountReqVo.getEndTime() + " 23:59:59");
        orderListForCountReqVo.setServType(ServiceTypeEnum.NOS.getValue());
        log.info("\u590d\u8bca\u5165\u53c2{}", (Object)orderListForCountReqVo.toString());
        List admissionFzList = this.orderMapper.selectOrderDocCount(orderListForCountReqVo);
        log.info("\u590d\u8bca\u66f4\u65b0\u65f6\u95f4\u6570\u636e{}", (Object)JSON.toJSONString((Object)admissionFzList));
        List admissionFzListCreateTime = this.orderMapper.selectOrderCountByCreateTime(orderListForCountReqVo);
        log.info("\u590d\u8bca\u521b\u5efa\u65f6\u95f4\u6570\u636e{}", (Object)JSON.toJSONString((Object)admissionFzListCreateTime));
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        if (CollectionUtils.isEmpty((Collection)admissionFzListCreateTime) && CollectionUtils.isEmpty((Collection)admissionFzList)) {
            expiredFZ.setCount(Integer.valueOf(0));
            undoneFZ.setCount(Integer.valueOf(0));
            completedFZ.setCount(Integer.valueOf(0));
            newOrderFZ.setCount(Integer.valueOf(0));
            newPatientFZ.setCount(Integer.valueOf(0));
            timeOutOrderFZ.setCount(Integer.valueOf(0));
            refundOrderFZ.setCount(Integer.valueOf(0));
            newAmountFZ.setOrderMoney(decimalFormat.format(0.0));
            completedAmountFZ.setOrderMoney(decimalFormat.format(0.0));
            refunAmountFZ.setOrderMoney(decimalFormat.format(0.0));
        } else {
            ArrayList<OrderCountForMangVo> admCompleteList = new ArrayList<OrderCountForMangVo>();
            ArrayList<OrderCountForMangVo> admUndoneList = new ArrayList<OrderCountForMangVo>();
            ArrayList<OrderCountForMangVo> admExpiredList = new ArrayList<OrderCountForMangVo>();
            ArrayList<OrderCountForMangVo> admTimeOutList = new ArrayList<OrderCountForMangVo>();
            List<Object> admRefundList = new ArrayList<OrderCountForMangVo>();
            for (OrderCountForMangVo adm : admissionFzList) {
                if (AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(adm.getStatus()) || AdmissionStatusEnum.WAIT_ADMISSION.getValue().equals(adm.getStatus()) || AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(adm.getStatus())) {
                    admUndoneList.add(adm);
                }
                if (AdmissionStatusEnum.FINISH_APPLY.getValue().equals(adm.getStatus()) || AdmissionStatusEnum.FINISH_TIME_OUT.getValue().equals(adm.getStatus()) || AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue().equals(adm.getStatus())) {
                    admCompleteList.add(adm);
                }
                if (AdmissionStatusEnum.NOT_RECEIVED_TIME_OUT.getValue().equals(adm.getStatus()) || AdmissionStatusEnum.REFUNDED_REFUSE_ZERO.getValue().equals(adm.getStatus())) {
                    admTimeOutList.add(adm);
                }
                if ("3".equals(adm.getStatusOrder()) || "6".equals(adm.getStatusOrder())) {
                    admRefundList.add(adm);
                    BigDecimal bigDecimal = new BigDecimal("0.00");
                    admRefundList = admRefundList.stream().filter(item -> !bigDecimal.equals(item.getPayAmount())).collect(Collectors.toList());
                }
                if (!this.orderInvalidStatus(adm.getStatus())) continue;
                admExpiredList.add(adm);
            }
            expiredFZ.setCount(Integer.valueOf(admExpiredList.size()));
            undoneFZ.setCount(Integer.valueOf(admUndoneList.size()));
            completedFZ.setCount(Integer.valueOf(admCompleteList.size()));
            newOrderFZ.setCount(Integer.valueOf(admissionFzList.size()));
            refundOrderFZ.setCount(Integer.valueOf(admRefundList.size()));
            timeOutOrderFZ.setCount(Integer.valueOf(admTimeOutList.size()));
            completedAmountFZ.setOrderMoney(decimalFormat.format(admCompleteList.stream().filter(x -> x.getOwnCost() != null).map(x -> new BigDecimal(x.getOwnCost())).reduce(BigDecimal.ZERO, BigDecimal::add)));
            refunAmountFZ.setOrderMoney(decimalFormat.format(admExpiredList.stream().filter(x -> x.getOwnCost() != null).map(x -> new BigDecimal(x.getOwnCost())).reduce(BigDecimal.ZERO, BigDecimal::add)));
            newAmountFZ.setOrderMoney(decimalFormat.format(admissionFzList.stream().filter(x -> x.getOwnCost() != null).map(x -> new BigDecimal(x.getOwnCost())).reduce(BigDecimal.ZERO, BigDecimal::add)));
            ArrayList collect = admissionFzList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<OrderCountForMangVo>(Comparator.comparing(OrderCountForMangVo::getPatientId))), ArrayList::new));
            newPatientFZ.setCount(Integer.valueOf(collect.size()));
        }
        orderResList.add(completedFZ);
        orderResList.add(newOrderFZ);
        orderResList.add(undoneFZ);
        orderResList.add(expiredFZ);
        orderResList.add(newPatientFZ);
        orderResList.add(timeOutOrderFZ);
        orderResList.add(refundOrderFZ);
        orderResList.add(refunAmountFZ);
        orderResList.add(newAmountFZ);
        orderResList.add(completedAmountFZ);
        return orderResList;
    }

    public BaseResponse<ExportOrderResDto> exportOrderList(OrderListForCountReqVo orderListForCountReqVo) {
        ExportOrderResDto exportOrderResDto = new ExportOrderResDto();
        Date startTime = null;
        Date endTime = null;
        try {
            startTime = DateUtils.strToDate((String)orderListForCountReqVo.getStartTime(), (String)"yyyy-MM-dd");
            endTime = DateUtils.strToDate((String)orderListForCountReqVo.getEndTime(), (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        ArrayList<ExportOrderFzResVo> exportOrderFzResVoList = new ArrayList<ExportOrderFzResVo>();
        ArrayList<ExportOrderZxResVo> exportOrderZxResVoList = new ArrayList<ExportOrderZxResVo>();
        List dateRange = DateUtils.getDateRange((Date)startTime, (Date)endTime);
        log.info("dateRange{}", (Object)JSON.toJSONString((Object)dateRange));
        for (String str : dateRange) {
            ExportOrderZxResVo exportOrderForZX = new ExportOrderZxResVo();
            ExportOrderFzResVo exportOrderForFZ = new ExportOrderFzResVo();
            exportOrderForZX.setCreateTime(str);
            exportOrderForFZ.setCreateTime(str);
            orderListForCountReqVo.setStartTime(str);
            orderListForCountReqVo.setEndTime(str);
            BaseResponse orderList = this.getOrderList(orderListForCountReqVo);
            if (!orderList.isSuccess()) {
                return BaseResponse.error((String)"\u8ba2\u5355\u67e5\u8be2\u5931\u8d25");
            }
            List data = (List)orderList.getData();
            for (OrderListForCountResVo orderData : data) {
                if (ServiceTypeEnum.NOS.getValue().equals(orderData.getServType())) {
                    if (ImmediateConsultationVoTypeEnum.OK.getValue().equals(orderData.getOrderStatus())) {
                        exportOrderForFZ.setNewOrder(orderData.getCount());
                    }
                    if (ImmediateConsultationVoTypeEnum.TOPAY.getValue().equals(orderData.getOrderStatus())) {
                        exportOrderForFZ.setCompleted(orderData.getCount());
                    }
                    if (ImmediateConsultationVoTypeEnum.IN_CONSULTATION.getValue().equals(orderData.getOrderStatus())) {
                        exportOrderForFZ.setUndone(orderData.getCount());
                    }
                    if (ImmediateConsultationVoTypeEnum.TYPE_RETURN.getValue().equals(orderData.getOrderStatus())) {
                        if (Objects.isNull(orderData.getCount())) {
                            exportOrderForFZ.setNewPatient(Integer.valueOf(0));
                        } else {
                            exportOrderForFZ.setNewPatient(orderData.getCount());
                        }
                    }
                    if (ImmediateConsultationVoTypeEnum.TIMEOUT_ORDER.getValue().equals(orderData.getOrderStatus())) {
                        if (Objects.isNull(orderData.getCount())) {
                            exportOrderForFZ.setTimeOut(Integer.valueOf(0));
                        } else {
                            exportOrderForFZ.setTimeOut(orderData.getCount());
                        }
                    }
                    if (ImmediateConsultationVoTypeEnum.REFUND_ORDER.getValue().equals(orderData.getOrderStatus())) {
                        if (Objects.isNull(orderData.getCount())) {
                            exportOrderForFZ.setRefund(Integer.valueOf(0));
                        } else {
                            exportOrderForFZ.setRefund(orderData.getCount());
                        }
                    }
                    if (ImmediateConsultationVoTypeEnum.TYPE_RETURN.getValue().equals(orderData.getOrderStatus())) {
                        if (Objects.isNull(orderData.getCount())) {
                            exportOrderForFZ.setExpired(Integer.valueOf(0));
                        } else {
                            exportOrderForFZ.setExpired(orderData.getCount());
                        }
                    }
                }
                if (!ServiceTypeEnum.HOS.getValue().equals(orderData.getServType())) continue;
                if (ImmediateConsultationVoTypeEnum.OK.getValue().equals(orderData.getOrderStatus())) {
                    exportOrderForZX.setNewOrder(orderData.getCount());
                }
                if (ImmediateConsultationVoTypeEnum.TOPAY.getValue().equals(orderData.getOrderStatus())) {
                    exportOrderForZX.setCompleted(orderData.getCount());
                }
                if (ImmediateConsultationVoTypeEnum.IN_CONSULTATION.getValue().equals(orderData.getOrderStatus())) {
                    exportOrderForZX.setUndone(orderData.getCount());
                }
                if (ImmediateConsultationVoTypeEnum.TYPE_RETURN.getValue().equals(orderData.getOrderStatus())) {
                    exportOrderForZX.setExpired(orderData.getCount());
                }
                if (ImmediateConsultationVoTypeEnum.WAIT_ADMISSION.getValue().equals(orderData.getOrderStatus())) {
                    if (Objects.isNull(orderData.getCount())) {
                        exportOrderForZX.setNewPatient(Integer.valueOf(0));
                    } else {
                        exportOrderForZX.setNewPatient(orderData.getCount());
                    }
                }
                if (ImmediateConsultationVoTypeEnum.TIMEOUT_ORDER.getValue().equals(orderData.getOrderStatus())) {
                    if (Objects.isNull(orderData.getCount())) {
                        exportOrderForZX.setTimeOut(Integer.valueOf(0));
                    } else {
                        exportOrderForZX.setTimeOut(orderData.getCount());
                    }
                }
                if (!ImmediateConsultationVoTypeEnum.REFUND_ORDER.getValue().equals(orderData.getOrderStatus())) continue;
                if (Objects.isNull(orderData.getCount())) {
                    exportOrderForZX.setRefund(Integer.valueOf(0));
                    continue;
                }
                exportOrderForZX.setRefund(orderData.getCount());
            }
            exportOrderFzResVoList.add(exportOrderForFZ);
            log.info("exportOrderFzResVoList{}", (Object)((Object)exportOrderFzResVoList).toString());
            exportOrderZxResVoList.add(exportOrderForZX);
            log.info("exportOrderZxResVoList{}", (Object)((Object)exportOrderZxResVoList).toString());
        }
        exportOrderResDto.setExportOrderFzResVoList(exportOrderFzResVoList);
        exportOrderResDto.setExportOrderZxResVoList(exportOrderZxResVoList);
        log.info("exportOrderResDto{}", (Object)exportOrderResDto.toString());
        return BaseResponse.success((Object)exportOrderResDto);
    }

    public BaseResponse<ReceptionCompletionVO> getOrderChartMonth(OrderChartReqVo orderChartReqVo) {
        ReceptionCompletionVO receptionCompletionVO = new ReceptionCompletionVO();
        ArrayList<String> xdata = new ArrayList<String>();
        ArrayList<ReceptionCompletionYdataVO> ydata = new ArrayList<ReceptionCompletionYdataVO>();
        ReceptionCompletionYdataVO newOrderreceptionCompletionYdataVO = new ReceptionCompletionYdataVO();
        ReceptionCompletionYdataVO completionOrderreceptionCompletionYdataVO = new ReceptionCompletionYdataVO();
        ReceptionCompletionYdataVO invalidOrderreceptionCompletionYdataVO = new ReceptionCompletionYdataVO();
        ReceptionCompletionYdataVO hangAirOrderreceptionCompletionYdataVO = new ReceptionCompletionYdataVO();
        ArrayList<Integer> newOrder = new ArrayList<Integer>();
        ArrayList<Integer> completionOrder = new ArrayList<Integer>();
        ArrayList<Integer> invalidOrder = new ArrayList<Integer>();
        ArrayList<Integer> hangAirOrder = new ArrayList<Integer>();
        List months = DateUtils.getMonth((String)orderChartReqVo.getStartTime(), (String)orderChartReqVo.getEndTime());
        if (CollectionUtils.isEmpty((Collection)months)) {
            return BaseResponse.success(null);
        }
        OrderListForCountReqVo orderListForCountReqVo = new OrderListForCountReqVo();
        BeanUtils.copyProperties((Object)orderChartReqVo, (Object)orderListForCountReqVo);
        orderListForCountReqVo.setDateType(orderChartReqVo.getDateType());
        BaseResponse orderDocRateLists = new BaseResponse();
        if (months.size() == 1) {
            List monthBeginAndEnd = DateUtils.getMonthBeginAndEnd((String)orderChartReqVo.getStartTime());
            if (Objects.nonNull(monthBeginAndEnd) && monthBeginAndEnd.size() > 0) {
                orderListForCountReqVo.setStartTime((String)monthBeginAndEnd.get(0));
                orderListForCountReqVo.setEndTime((String)monthBeginAndEnd.get(1));
                orderDocRateLists = this.getOrderDocRateLists(orderListForCountReqVo);
                for (Integer month : months) {
                    List collect;
                    String endTime = DateUtils.getLastDayOfMonth((String)(orderChartReqVo.getEndTime().substring(0, 5) + month));
                    String startTime = DateUtils.getStartDayOfMonth((String)(orderChartReqVo.getEndTime().substring(0, 5) + month));
                    long l = DateUtils.strToDateLong((String)endTime);
                    long l1 = DateUtils.strToDateLong((String)startTime);
                    log.info("\u6708\u7c92\u5ea6\u67e5\u8ba2\u5355\u5165\u53c2{}", (Object)orderListForCountReqVo.toString());
                    if (orderChartReqVo.getServType() == 2) {
                        collect = null;
                        if (((ExportOrderResDto)orderDocRateLists.getData()).getExportOrderZxResVoList() != null) {
                            collect = ((ExportOrderResDto)orderDocRateLists.getData()).getExportOrderZxResVoList().stream().filter(x -> DateUtils.strToDateLong((String)x.getCreateTime()) >= l1 && DateUtils.strToDateLong((String)x.getCreateTime()) <= l).collect(Collectors.toList());
                        }
                        if (collect != null && collect.size() > 0) {
                            newOrder.add(collect.stream().mapToInt(ExportOrderZxResVo::getNewOrder).sum());
                            completionOrder.add(collect.stream().mapToInt(ExportOrderZxResVo::getCompleted).sum());
                            invalidOrder.add(collect.stream().mapToInt(ExportOrderZxResVo::getExpired).sum());
                            hangAirOrder.add(collect.stream().mapToInt(ExportOrderZxResVo::getUndone).sum());
                        } else {
                            newOrder.add(0);
                            completionOrder.add(0);
                            invalidOrder.add(0);
                            hangAirOrder.add(0);
                        }
                        xdata.add(startTime + "~" + endTime);
                        continue;
                    }
                    collect = null;
                    if (((ExportOrderResDto)orderDocRateLists.getData()).getExportOrderFzResVoList() != null) {
                        collect = ((ExportOrderResDto)orderDocRateLists.getData()).getExportOrderFzResVoList().stream().filter(x -> DateUtils.strToDateLong((String)x.getCreateTime()) >= l1 && DateUtils.strToDateLong((String)x.getCreateTime()) <= l).collect(Collectors.toList());
                    }
                    if (collect != null && collect.size() > 0) {
                        newOrder.add(collect.stream().mapToInt(ExportOrderFzResVo::getNewOrder).sum());
                        completionOrder.add(collect.stream().mapToInt(ExportOrderFzResVo::getCompleted).sum());
                        invalidOrder.add(collect.stream().mapToInt(ExportOrderFzResVo::getExpired).sum());
                        hangAirOrder.add(collect.stream().mapToInt(ExportOrderFzResVo::getUndone).sum());
                    } else {
                        newOrder.add(0);
                        completionOrder.add(0);
                        invalidOrder.add(0);
                        hangAirOrder.add(0);
                    }
                    xdata.add(startTime + "~" + endTime);
                }
                newOrderreceptionCompletionYdataVO.setName("\u65b0\u589e\u8ba2\u5355").setData(newOrder);
                completionOrderreceptionCompletionYdataVO.setName("\u5b8c\u6210\u8ba2\u5355").setData(completionOrder);
                invalidOrderreceptionCompletionYdataVO.setName("\u5df2\u5931\u6548\u8ba2\u5355").setData(invalidOrder);
                hangAirOrderreceptionCompletionYdataVO.setName("\u672a\u5b8c\u6210\u8ba2\u5355").setData(hangAirOrder);
                ydata.add(newOrderreceptionCompletionYdataVO);
                ydata.add(completionOrderreceptionCompletionYdataVO);
                ydata.add(invalidOrderreceptionCompletionYdataVO);
                ydata.add(hangAirOrderreceptionCompletionYdataVO);
                receptionCompletionVO.setXdata(xdata).setYdata(ydata);
            }
        } else {
            for (Integer month : months) {
                List collect;
                String endTime = DateUtils.getLastDayOfMonth((String)(orderChartReqVo.getEndTime().substring(0, 5) + month));
                String startTime = DateUtils.getStartDayOfMonth((String)(orderChartReqVo.getEndTime().substring(0, 5) + month));
                long l = DateUtils.strToDateLong((String)endTime);
                long l1 = DateUtils.strToDateLong((String)startTime);
                orderListForCountReqVo.setStartTime(startTime);
                orderListForCountReqVo.setEndTime(endTime);
                orderDocRateLists = this.getOrderDocRateLists(orderListForCountReqVo);
                log.info("\u6708\u7c92\u5ea6\u67e5\u8ba2\u5355\u5165\u53c2{}", (Object)orderListForCountReqVo.toString());
                if (orderChartReqVo.getServType() == 2) {
                    collect = null;
                    if (((ExportOrderResDto)orderDocRateLists.getData()).getExportOrderZxResVoList() != null) {
                        collect = ((ExportOrderResDto)orderDocRateLists.getData()).getExportOrderZxResVoList().stream().filter(x -> DateUtils.strToDateLong((String)x.getCreateTime()) >= l1 && DateUtils.strToDateLong((String)x.getCreateTime()) <= l).collect(Collectors.toList());
                    }
                    if (collect != null && collect.size() > 0) {
                        newOrder.add(collect.stream().mapToInt(ExportOrderZxResVo::getNewOrder).sum());
                        completionOrder.add(collect.stream().mapToInt(ExportOrderZxResVo::getCompleted).sum());
                        invalidOrder.add(collect.stream().mapToInt(ExportOrderZxResVo::getExpired).sum());
                        hangAirOrder.add(collect.stream().mapToInt(ExportOrderZxResVo::getUndone).sum());
                    } else {
                        newOrder.add(0);
                        completionOrder.add(0);
                        invalidOrder.add(0);
                        hangAirOrder.add(0);
                    }
                    xdata.add(startTime + "~" + endTime);
                    continue;
                }
                collect = null;
                if (((ExportOrderResDto)orderDocRateLists.getData()).getExportOrderFzResVoList() != null) {
                    collect = ((ExportOrderResDto)orderDocRateLists.getData()).getExportOrderFzResVoList().stream().filter(x -> DateUtils.strToDateLong((String)x.getCreateTime()) >= l1 && DateUtils.strToDateLong((String)x.getCreateTime()) <= l).collect(Collectors.toList());
                }
                if (collect != null && collect.size() > 0) {
                    newOrder.add(collect.stream().mapToInt(ExportOrderFzResVo::getNewOrder).sum());
                    completionOrder.add(collect.stream().mapToInt(ExportOrderFzResVo::getCompleted).sum());
                    invalidOrder.add(collect.stream().mapToInt(ExportOrderFzResVo::getExpired).sum());
                    hangAirOrder.add(collect.stream().mapToInt(ExportOrderFzResVo::getUndone).sum());
                } else {
                    newOrder.add(0);
                    completionOrder.add(0);
                    invalidOrder.add(0);
                    hangAirOrder.add(0);
                }
                xdata.add(startTime + "~" + endTime);
            }
            newOrderreceptionCompletionYdataVO.setName("\u65b0\u589e\u8ba2\u5355").setData(newOrder);
            completionOrderreceptionCompletionYdataVO.setName("\u5b8c\u6210\u8ba2\u5355").setData(completionOrder);
            invalidOrderreceptionCompletionYdataVO.setName("\u5df2\u5931\u6548\u8ba2\u5355").setData(invalidOrder);
            hangAirOrderreceptionCompletionYdataVO.setName("\u672a\u5b8c\u6210\u8ba2\u5355").setData(hangAirOrder);
            ydata.add(newOrderreceptionCompletionYdataVO);
            ydata.add(completionOrderreceptionCompletionYdataVO);
            ydata.add(invalidOrderreceptionCompletionYdataVO);
            ydata.add(hangAirOrderreceptionCompletionYdataVO);
            receptionCompletionVO.setXdata(xdata).setYdata(ydata);
        }
        return BaseResponse.success((Object)receptionCompletionVO);
    }

    private ReceptionCompletionVO getYearDateByCondition(OrderChartReqVo vo) {
        ReceptionCompletionVO result = new ReceptionCompletionVO();
        ArrayList<ReceptionCompletionYdataVO> yData = new ArrayList<ReceptionCompletionYdataVO>();
        ArrayList newOrder = new ArrayList();
        ArrayList completionOrder = new ArrayList();
        ArrayList invalidOrder = new ArrayList();
        ArrayList hangAirOrder = new ArrayList();
        String[] splitStart = vo.getStartTime().split("-");
        String[] splitEnd = vo.getEndTime().split("-");
        String startTime = DateUtils.getLastDayOfMonth((String)(vo.getStartTime().substring(0, 5) + Integer.parseInt(splitStart[1])));
        String endTime = DateUtils.getLastDayOfMonth((String)(vo.getEndTime().substring(0, 5) + Integer.parseInt(splitEnd[1])));
        startTime = startTime + startTime + " 00:00:00";
        endTime = endTime + endTime + " 23:59:59";
        int difference = 0;
        difference = Integer.parseInt(splitEnd[0]) - Integer.parseInt(splitStart[0]);
        if (Objects.equals(difference, 1) && Objects.equals(splitStart[1], splitEnd[1]) && Objects.equals(splitStart[2], splitEnd[2])) {
            vo.setStartTime(startTime);
            vo.setEndTime(endTime);
            OrderListForCountReqVo requestVo = new OrderListForCountReqVo();
            BeanUtils.copyProperties((Object)vo, (Object)requestVo);
            requestVo.setDateType(vo.getDateType());
            BaseResponse orderList = this.getOrderDocRateLists(requestVo);
            ((ExportOrderResDto)orderList.getData()).getExportOrderZxResVoList().stream().forEach(item -> {
                String createTime = item.getCreateTime();
                String[] splitTime = createTime.split(" ");
                String date = splitTime[0].substring(0, 7);
                item.setCreateTime(date);
            });
            ((ExportOrderResDto)orderList.getData()).getExportOrderFzResVoList().stream().forEach(item -> {
                String createTime = item.getCreateTime();
                String[] splitTime = createTime.split(" ");
                String date = splitTime[0].substring(0, 7);
                item.setCreateTime(date);
            });
            LinkedHashMap collectZx = ((ExportOrderResDto)orderList.getData()).getExportOrderZxResVoList().stream().collect(Collectors.groupingBy(ExportOrderZxResVo::getCreateTime, LinkedHashMap::new, Collectors.toList()));
            LinkedHashMap collectFz = ((ExportOrderResDto)orderList.getData()).getExportOrderFzResVoList().stream().collect(Collectors.groupingBy(ExportOrderFzResVo::getCreateTime, LinkedHashMap::new, Collectors.toList()));
            HashMap mapZx = new HashMap(100);
            HashMap mapFz = new HashMap(100);
            ArrayList xData = new ArrayList();
            for (Map.Entry entry : collectZx.entrySet()) {
                xData.add(entry.getKey());
                mapZx.put(entry.getKey(), String.valueOf(((List)entry.getValue()).size()));
            }
            for (Map.Entry entry : collectFz.entrySet()) {
                mapFz.put(entry.getKey(), String.valueOf(((List)entry.getValue()).size()));
            }
            ReceptionCompletionYdataVO newData = new ReceptionCompletionYdataVO();
            ReceptionCompletionYdataVO completData = new ReceptionCompletionYdataVO();
            ReceptionCompletionYdataVO invalidData = new ReceptionCompletionYdataVO();
            ReceptionCompletionYdataVO undoneData = new ReceptionCompletionYdataVO();
            if (Objects.equals(vo.getServType(), 2)) {
                xData.stream().forEach(item -> {
                    List listZx = (List)collectZx.get(item);
                    if (Objects.nonNull(listZx) && listZx.size() > 0) {
                        newOrder.add(listZx.stream().mapToInt(ExportOrderZxResVo::getNewOrder).sum());
                        completionOrder.add(listZx.stream().mapToInt(ExportOrderZxResVo::getCompleted).sum());
                        invalidOrder.add(listZx.stream().mapToInt(ExportOrderZxResVo::getExpired).sum());
                        hangAirOrder.add(listZx.stream().mapToInt(ExportOrderZxResVo::getUndone).sum());
                    } else {
                        newOrder.add(0);
                        completionOrder.add(0);
                        invalidOrder.add(0);
                        hangAirOrder.add(0);
                    }
                });
            } else {
                xData.stream().forEach(item -> {
                    List listFz = (List)collectFz.get(item);
                    if (Objects.nonNull(listFz) && listFz.size() > 0) {
                        newOrder.add(listFz.stream().mapToInt(ExportOrderFzResVo::getNewOrder).sum());
                        completionOrder.add(listFz.stream().mapToInt(ExportOrderFzResVo::getCompleted).sum());
                        invalidOrder.add(listFz.stream().mapToInt(ExportOrderFzResVo::getExpired).sum());
                        hangAirOrder.add(listFz.stream().mapToInt(ExportOrderFzResVo::getUndone).sum());
                    } else {
                        newOrder.add(0);
                        completionOrder.add(0);
                        invalidOrder.add(0);
                        hangAirOrder.add(0);
                    }
                });
            }
            newData.setName("\u65b0\u589e\u8ba2\u5355").setData(newOrder);
            completData.setName("\u5b8c\u6210\u8ba2\u5355").setData(completionOrder);
            invalidData.setName("\u5df2\u5931\u6548\u8ba2\u5355").setData(invalidOrder);
            undoneData.setName("\u672a\u5b8c\u6210\u8ba2\u5355").setData(hangAirOrder);
            yData.add(newData);
            yData.add(completData);
            yData.add(invalidData);
            yData.add(undoneData);
            result.setXdata(xData).setYdata(yData);
        }
        return result;
    }

    public BaseResponse<ReceptionCompletionVO> getOrderChartWeek(OrderChartReqVo orderChartReqVo) {
        ReceptionCompletionVO receptionCompletionVO = new ReceptionCompletionVO();
        ArrayList<String> xdata = new ArrayList<String>();
        ArrayList<ReceptionCompletionYdataVO> ydata = new ArrayList<ReceptionCompletionYdataVO>();
        ReceptionCompletionYdataVO newOrderreceptionCompletionYdataVO = new ReceptionCompletionYdataVO();
        ReceptionCompletionYdataVO completionOrderreceptionCompletionYdataVO = new ReceptionCompletionYdataVO();
        ReceptionCompletionYdataVO invalidOrderreceptionCompletionYdataVO = new ReceptionCompletionYdataVO();
        ReceptionCompletionYdataVO hangAirOrderreceptionCompletionYdataVO = new ReceptionCompletionYdataVO();
        ArrayList<Integer> newOrder = new ArrayList<Integer>();
        ArrayList<Integer> completionOrder = new ArrayList<Integer>();
        ArrayList<Integer> invalidOrder = new ArrayList<Integer>();
        ArrayList<Integer> hangAirOrder = new ArrayList<Integer>();
        List betweenWeeks = null;
        try {
            betweenWeeks = DateUtils.getBetweenWeeks((String)orderChartReqVo.getStartTime(), (String)orderChartReqVo.getEndTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (CollectionUtils.isEmpty((Collection)betweenWeeks)) {
            BaseResponse.success((Object)receptionCompletionVO);
        }
        OrderListForCountReqVo orderListForCountReqVo = new OrderListForCountReqVo();
        BeanUtils.copyProperties((Object)orderChartReqVo, (Object)orderListForCountReqVo);
        orderListForCountReqVo.setStartTime(orderChartReqVo.getStartTime());
        orderListForCountReqVo.setEndTime(orderChartReqVo.getEndTime());
        orderListForCountReqVo.setDateType(orderChartReqVo.getDateType());
        BaseResponse orderDocRateLists = this.getOrderDocRateLists(orderListForCountReqVo);
        for (int i = 0; i < betweenWeeks.size(); ++i) {
            List collect;
            OrderChartResVo orderChartResVo = new OrderChartResVo();
            String endTime = (String)((Map)betweenWeeks.get(i)).get("week");
            String startTime = (String)((Map)betweenWeeks.get(i)).get("mon");
            orderChartResVo.setTimeInterval(startTime + " " + endTime);
            long l = DateUtils.strToDateLong((String)endTime);
            long l1 = DateUtils.strToDateLong((String)startTime);
            if (orderChartReqVo.getServType() == 2) {
                collect = null;
                if (((ExportOrderResDto)orderDocRateLists.getData()).getExportOrderZxResVoList() != null) {
                    collect = ((ExportOrderResDto)orderDocRateLists.getData()).getExportOrderZxResVoList().stream().filter(x -> DateUtils.strToDateLong((String)x.getCreateTime()) >= l1 && DateUtils.strToDateLong((String)x.getCreateTime()) <= l).collect(Collectors.toList());
                }
                if (collect != null && collect.size() > 0) {
                    newOrder.add(collect.stream().mapToInt(ExportOrderZxResVo::getNewOrder).sum());
                    completionOrder.add(collect.stream().mapToInt(ExportOrderZxResVo::getCompleted).sum());
                    invalidOrder.add(collect.stream().mapToInt(ExportOrderZxResVo::getExpired).sum());
                    hangAirOrder.add(collect.stream().mapToInt(ExportOrderZxResVo::getUndone).sum());
                } else {
                    newOrder.add(0);
                    completionOrder.add(0);
                    invalidOrder.add(0);
                    hangAirOrder.add(0);
                }
                xdata.add(startTime + "~" + endTime);
                continue;
            }
            collect = null;
            if (((ExportOrderResDto)orderDocRateLists.getData()).getExportOrderFzResVoList() != null) {
                collect = ((ExportOrderResDto)orderDocRateLists.getData()).getExportOrderFzResVoList().stream().filter(x -> DateUtils.strToDateLong((String)x.getCreateTime()) >= l1 && DateUtils.strToDateLong((String)x.getCreateTime()) <= l).collect(Collectors.toList());
            }
            if (collect != null && collect.size() > 0) {
                newOrder.add(collect.stream().mapToInt(ExportOrderFzResVo::getNewOrder).sum());
                completionOrder.add(collect.stream().mapToInt(ExportOrderFzResVo::getCompleted).sum());
                invalidOrder.add(collect.stream().mapToInt(ExportOrderFzResVo::getExpired).sum());
                hangAirOrder.add(collect.stream().mapToInt(ExportOrderFzResVo::getUndone).sum());
            } else {
                newOrder.add(0);
                completionOrder.add(0);
                invalidOrder.add(0);
                hangAirOrder.add(0);
            }
            xdata.add(startTime + "~" + endTime);
        }
        newOrderreceptionCompletionYdataVO.setName("\u65b0\u589e\u8ba2\u5355").setData(newOrder);
        completionOrderreceptionCompletionYdataVO.setName("\u5b8c\u6210\u8ba2\u5355").setData(completionOrder);
        invalidOrderreceptionCompletionYdataVO.setName("\u5df2\u5931\u6548\u8ba2\u5355").setData(invalidOrder);
        hangAirOrderreceptionCompletionYdataVO.setName("\u672a\u5b8c\u6210\u8ba2\u5355").setData(hangAirOrder);
        ydata.add(newOrderreceptionCompletionYdataVO);
        ydata.add(completionOrderreceptionCompletionYdataVO);
        ydata.add(invalidOrderreceptionCompletionYdataVO);
        ydata.add(hangAirOrderreceptionCompletionYdataVO);
        receptionCompletionVO.setXdata(xdata).setYdata(ydata);
        return BaseResponse.success((Object)receptionCompletionVO);
    }

    public BaseResponse<ReceptionCompletionVO> getOrderChartDay(OrderChartReqVo orderChartReqVo) {
        ReceptionCompletionVO receptionCompletionVO = new ReceptionCompletionVO();
        ArrayList<String> xdata = new ArrayList<String>();
        ArrayList<ReceptionCompletionYdataVO> ydata = new ArrayList<ReceptionCompletionYdataVO>();
        ReceptionCompletionYdataVO newOrderreceptionCompletionYdataVO = new ReceptionCompletionYdataVO();
        ReceptionCompletionYdataVO completionOrderreceptionCompletionYdataVO = new ReceptionCompletionYdataVO();
        ReceptionCompletionYdataVO invalidOrderreceptionCompletionYdataVO = new ReceptionCompletionYdataVO();
        ReceptionCompletionYdataVO hangAirOrderreceptionCompletionYdataVO = new ReceptionCompletionYdataVO();
        ArrayList<Integer> newOrder = new ArrayList<Integer>();
        ArrayList<Integer> completionOrder = new ArrayList<Integer>();
        ArrayList<Integer> invalidOrder = new ArrayList<Integer>();
        ArrayList<Integer> hangAirOrder = new ArrayList<Integer>();
        Date start = null;
        Date end = null;
        try {
            start = DateUtils.strToDate((String)orderChartReqVo.getStartTime(), (String)"yyyy-MM-dd");
            end = DateUtils.strToDate((String)orderChartReqVo.getEndTime(), (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        List dateRange = DateUtils.getDateRange((Date)start, end);
        OrderListForCountReqVo orderListForCountReqVo = new OrderListForCountReqVo();
        BeanUtils.copyProperties((Object)orderChartReqVo, (Object)orderListForCountReqVo);
        orderListForCountReqVo.setStartTime(orderChartReqVo.getStartTime());
        orderListForCountReqVo.setEndTime(orderChartReqVo.getEndTime());
        orderListForCountReqVo.setDateType(orderChartReqVo.getDateType());
        BaseResponse orderDocRateLists = this.getOrderDocRateLists(orderListForCountReqVo);
        for (String s : dateRange) {
            List collect;
            if (orderChartReqVo.getServType() == 2) {
                collect = null;
                if (((ExportOrderResDto)orderDocRateLists.getData()).getExportOrderZxResVoList() != null) {
                    collect = ((ExportOrderResDto)orderDocRateLists.getData()).getExportOrderZxResVoList().stream().filter(x -> x.getCreateTime().equals(s)).collect(Collectors.toList());
                }
                if (collect != null && collect.size() > 0) {
                    newOrder.add(collect.stream().mapToInt(ExportOrderZxResVo::getNewOrder).sum());
                    completionOrder.add(collect.stream().mapToInt(ExportOrderZxResVo::getCompleted).sum());
                    invalidOrder.add(collect.stream().mapToInt(ExportOrderZxResVo::getExpired).sum());
                    hangAirOrder.add(collect.stream().mapToInt(ExportOrderZxResVo::getUndone).sum());
                } else {
                    newOrder.add(0);
                    completionOrder.add(0);
                    invalidOrder.add(0);
                    hangAirOrder.add(0);
                }
                xdata.add(s);
                continue;
            }
            collect = null;
            if (((ExportOrderResDto)orderDocRateLists.getData()).getExportOrderFzResVoList() != null) {
                collect = ((ExportOrderResDto)orderDocRateLists.getData()).getExportOrderFzResVoList().stream().filter(x -> x.getCreateTime().equals(s)).collect(Collectors.toList());
            }
            if (collect != null && collect.size() > 0) {
                newOrder.add(collect.stream().mapToInt(ExportOrderFzResVo::getNewOrder).sum());
                completionOrder.add(collect.stream().mapToInt(ExportOrderFzResVo::getCompleted).sum());
                invalidOrder.add(collect.stream().mapToInt(ExportOrderFzResVo::getExpired).sum());
                hangAirOrder.add(collect.stream().mapToInt(ExportOrderFzResVo::getUndone).sum());
            } else {
                newOrder.add(0);
                completionOrder.add(0);
                invalidOrder.add(0);
                hangAirOrder.add(0);
            }
            xdata.add(s);
        }
        newOrderreceptionCompletionYdataVO.setName("\u65b0\u589e\u8ba2\u5355").setData(newOrder);
        completionOrderreceptionCompletionYdataVO.setName("\u5b8c\u6210\u8ba2\u5355").setData(completionOrder);
        invalidOrderreceptionCompletionYdataVO.setName("\u5df2\u5931\u6548\u8ba2\u5355").setData(invalidOrder);
        hangAirOrderreceptionCompletionYdataVO.setName("\u672a\u5b8c\u6210\u8ba2\u5355").setData(hangAirOrder);
        ydata.add(newOrderreceptionCompletionYdataVO);
        ydata.add(completionOrderreceptionCompletionYdataVO);
        ydata.add(invalidOrderreceptionCompletionYdataVO);
        ydata.add(hangAirOrderreceptionCompletionYdataVO);
        receptionCompletionVO.setXdata(xdata).setYdata(ydata);
        return BaseResponse.success((Object)receptionCompletionVO);
    }

    private BaseResponse<ExportOrderResDto> getOrderDocRateLists(OrderListForCountReqVo orderListForCountReqVo) {
        ExportOrderResDto orderListDocFZ = this.getOrderListDocRateFZ(orderListForCountReqVo);
        log.info("\u83b7\u53d6\u8ba2\u5355\u6570\u636e-\u590d\u8bca-\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)orderListDocFZ));
        ExportOrderResDto orderListRateDocZX = this.getOrderListRateDocZX(orderListForCountReqVo);
        orderListDocFZ.setExportOrderZxResVoList(orderListRateDocZX.getExportOrderZxResVoList());
        return BaseResponse.success((Object)orderListDocFZ);
    }

    public BaseResponse<String> saveAnomalousEvent(AnomalousEventEntity anomalousEventEntity) {
        if (StringUtils.isEmpty((String)anomalousEventEntity.getOrderSeq()) || StringUtils.isEmpty((String)anomalousEventEntity.getAdmId())) {
            return BaseResponse.error((String)"\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Random ran = new Random();
        int num = ran.nextInt(99999);
        String str = String.format("%05d", num);
        String currentDate = DateUtils.getCurrentDateSimpleNoSpeToString();
        anomalousEventEntity.setXId(currentDate + str);
        int insert = this.anomalousEventMapper.insert((Object)anomalousEventEntity);
        if (insert == 1) {
            return BaseResponse.success((Object)anomalousEventEntity.getXId());
        }
        return BaseResponse.error((String)"\u5f02\u5e38\u4e8b\u4ef6\u4e0a\u62a5\u5931\u8d25");
    }

    public BaseResponse<AnomalousEventEntity> getAnomalousById(GetAnomalousByIdReqVo getAnomalousByIdReqVo) {
        QueryWrapper wrapper = new QueryWrapper();
        AnomalousEventEntity anomalousEventEntity = new AnomalousEventEntity();
        anomalousEventEntity.setXId(getAnomalousByIdReqVo.getXId());
        wrapper.setEntity((Object)anomalousEventEntity);
        AnomalousEventEntity anomalousEvent = (AnomalousEventEntity)this.anomalousEventMapper.selectOne((Wrapper)wrapper);
        if (null == anomalousEvent) {
            return BaseResponse.error((String)"\u5f02\u5e38\u4e8b\u4ef6\u4e0a\u62a5\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        return BaseResponse.success((Object)anomalousEvent);
    }

    public BaseResponse<List<OrderListForPercentageResVo>> midOrderMapInfo(OrderListForCountReqVo orderListForCountReqVo) {
        orderListForCountReqVo.setStartTime(orderListForCountReqVo.getStartTime() + " 00:00:00");
        orderListForCountReqVo.setEndTime(orderListForCountReqVo.getEndTime() + " 23:59:59");
        ArrayList<Object> orderListForPercentageResVoArrayList = new ArrayList<Object>();
        orderListForCountReqVo.setStatusList(null);
        BaseResponse orderCompletionRate = this.calculateCompleteOrderRate(orderListForCountReqVo);
        orderListForCountReqVo.setStatusList(null);
        BaseResponse orderInvalidRate = this.calculateInvalidOrderRate(orderListForCountReqVo);
        orderListForCountReqVo.setStatusList(null);
        BaseResponse orderAdmissionRate = this.calculateAdmissionOrderRate(orderListForCountReqVo);
        orderListForCountReqVo.setStatusList(null);
        BaseResponse patientAverageWaitTime = this.patientAverageWaitTime(orderListForCountReqVo);
        orderListForCountReqVo.setStatusList(null);
        orderListForPercentageResVoArrayList.add(orderCompletionRate.getData());
        orderListForPercentageResVoArrayList.add(orderInvalidRate.getData());
        orderListForPercentageResVoArrayList.add(orderAdmissionRate.getData());
        orderListForPercentageResVoArrayList.add(patientAverageWaitTime.getData());
        return BaseResponse.success(orderListForPercentageResVoArrayList);
    }

    public BaseResponse<DocDeptDateRankingResVO> docDataRanking(OrderListForCountReqVo orderListForCountReqVo) {
        orderListForCountReqVo.setStartTime(orderListForCountReqVo.getStartTime() + " 00:00:00");
        orderListForCountReqVo.setEndTime(orderListForCountReqVo.getEndTime() + " 24:00:00");
        DocDeptDateRankingResVO docDeptDateRankingResVO = new DocDeptDateRankingResVO();
        ArrayList<DocDeptDateRankingVO> docDeptDateRankingVOList = new ArrayList<DocDeptDateRankingVO>();
        List<Object> docDeptDateRankingVOLists = new ArrayList();
        List list = this.orderMapper.selectOrderDocCount(orderListForCountReqVo);
        List orderListForCountList = this.replaceNewDeptName(list);
        List data = orderListForCountList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<OrderCountForMangVo>(Comparator.comparing(o -> o.getDeptId() + o.getDoctorName()))), ArrayList::new)).stream().filter(x -> x.getDeptName() != null).collect(Collectors.toList());
        for (OrderCountForMangVo doctor : data) {
            DocDeptDateRankingVO docDeptDateRankingVO = new DocDeptDateRankingVO();
            List newOrderCount = orderListForCountList.stream().filter(x -> x.getStartTime() != null && x.getDoctorName().equals(doctor.getDoctorName()) && x.getDeptId().equals(doctor.getDeptId())).collect(Collectors.toList());
            List orderCountForMang = orderListForCountList.stream().filter(x -> x.getStatus() != 65 && x.getDoctorName() != null && x.getDoctorName().equals(doctor.getDoctorName()) && x.getDeptId().equals(doctor.getDeptId())).collect(Collectors.toList());
            List completeNewOrdersList = orderListForCountList.stream().filter(x -> x.getStartTime() != null && x.getDoctorName() != null && x.getStatus() != 65 && x.getDoctorName().equals(doctor.getDoctorName()) && x.getDeptId().equals(doctor.getDeptId()) && x.getSecondsCount() != null).collect(Collectors.toList());
            docDeptDateRankingVO.setDeptName(doctor.getDeptName()).setDocName(doctor.getDoctorName()).setOrdersReceived(Integer.valueOf(orderListForCountList.stream().filter(x -> x.getReceptionTime() != null && x.getStartTime() != null && x.getDoctorName().equals(doctor.getDoctorName()) && x.getDeptId().equals(doctor.getDeptId())).collect(Collectors.toList()).size())).setHospitalId(orderListForCountReqVo.getHospitalId()).setNewOrderCount(Integer.valueOf(orderCountForMang.size()));
            List processingOrder = orderListForCountList.stream().filter(order -> Objects.nonNull(order.getReceptionTime()) && order.getDoctorName().equals(doctor.getDoctorName()) && order.getDeptId().equals(doctor.getDeptId())).collect(Collectors.toList());
            List admissionOrder = orderListForCountList.stream().filter(order -> Objects.nonNull(order.getConvertWaitTime()) && order.getDoctorName().equals(doctor.getDoctorName()) && order.getDeptId().equals(doctor.getDeptId())).collect(Collectors.toList());
            if (processingOrder.size() == 0) {
                docDeptDateRankingVO.setAvgReceiveTime(Integer.valueOf(0));
            } else {
                int sumWaitTime = 0;
                for (int i = 0; i < processingOrder.size(); ++i) {
                    if (!Objects.nonNull(((OrderCountForMangVo)processingOrder.get(i)).getStartTime()) || !Objects.nonNull(((OrderCountForMangVo)processingOrder.get(i)).getConvertWaitTime())) continue;
                    int differTime = DateUtils.secondBetween((Date)((OrderCountForMangVo)processingOrder.get(i)).getConvertWaitTime(), (Date)((OrderCountForMangVo)processingOrder.get(i)).getStartTime());
                    sumWaitTime += differTime;
                }
                int ave = sumWaitTime / 60 / processingOrder.size();
                docDeptDateRankingVO.setAvgReceiveTime(Integer.valueOf(ave));
            }
            if (processingOrder.size() == 0 || admissionOrder.size() == 0) {
                docDeptDateRankingVO.setOrdersReceivedRate(Double.valueOf(0.0));
            } else {
                docDeptDateRankingVO.setOrdersReceivedRate(Double.valueOf((double)processingOrder.size() / (double)admissionOrder.size()));
            }
            if (orderCountForMang.size() == 0) {
                docDeptDateRankingVO.setCompletionRate(Double.valueOf(0.0));
            } else {
                docDeptDateRankingVO.setCompletionRate(Double.valueOf((double)orderListForCountList.stream().filter(x -> (x.getStatus() == 2 || x.getStatus() == 7 || x.getStatus() == 8 || x.getStatus() == 9) && x.getStartTime() != null && x.getEndTime() != null && x.getDoctorName().equals(doctor.getDoctorName()) && x.getDeptId().equals(doctor.getDeptId())).collect(Collectors.toList()).size() / (double)orderCountForMang.size()));
            }
            docDeptDateRankingVOList.add(docDeptDateRankingVO);
        }
        if (!Objects.isNull(orderListForCountReqVo.getSortType())) {
            if ("1".equals(orderListForCountReqVo.getSortType())) {
                if (orderListForCountReqVo.getAvgReceiveTime() != null && !"".equals(orderListForCountReqVo.getAvgReceiveTime())) {
                    docDeptDateRankingVOLists = docDeptDateRankingVOList.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getAvgReceiveTime).reversed()).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getOrdersReceived() != null && !"".equals(orderListForCountReqVo.getOrdersReceived())) {
                    docDeptDateRankingVOLists = docDeptDateRankingVOList.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getOrdersReceived).reversed()).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getCompletionRate() != null && !"".equals(orderListForCountReqVo.getCompletionRate())) {
                    docDeptDateRankingVOLists = docDeptDateRankingVOList.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getCompletionRate).reversed()).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getNewOrderCount() != null && !"".equals(orderListForCountReqVo.getNewOrderCount())) {
                    docDeptDateRankingVOLists = docDeptDateRankingVOList.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getNewOrderCount).reversed()).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getOrdersReceivedRate() != null && !"".equals(orderListForCountReqVo.getOrdersReceivedRate())) {
                    docDeptDateRankingVOLists = docDeptDateRankingVOList.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getOrdersReceivedRate).reversed()).collect(Collectors.toList());
                }
            } else if ("2".equals(orderListForCountReqVo.getSortType())) {
                if (orderListForCountReqVo.getAvgReceiveTime() != null && !"".equals(orderListForCountReqVo.getAvgReceiveTime())) {
                    docDeptDateRankingVOLists = docDeptDateRankingVOList.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getAvgReceiveTime)).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getOrdersReceived() != null && !"".equals(orderListForCountReqVo.getOrdersReceived())) {
                    docDeptDateRankingVOLists = docDeptDateRankingVOList.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getOrdersReceived)).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getCompletionRate() != null && !"".equals(orderListForCountReqVo.getCompletionRate())) {
                    docDeptDateRankingVOLists = docDeptDateRankingVOList.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getCompletionRate)).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getNewOrderCount() != null && !"".equals(orderListForCountReqVo.getNewOrderCount())) {
                    docDeptDateRankingVOLists = docDeptDateRankingVOList.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getNewOrderCount)).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getOrdersReceivedRate() != null && !"".equals(orderListForCountReqVo.getOrdersReceivedRate())) {
                    docDeptDateRankingVOLists = docDeptDateRankingVOList.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getOrdersReceivedRate)).collect(Collectors.toList());
                }
            }
        } else {
            docDeptDateRankingVOLists = docDeptDateRankingVOList.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getOrdersReceived)).collect(Collectors.toList());
        }
        if (Objects.nonNull(orderListForCountReqVo.getHospitalId())) {
            docDeptDateRankingVOLists.forEach(x -> x.setCompletionRate(Double.valueOf(Double.parseDouble(String.format("%.1f", x.getCompletionRate() * 100.0)))));
            docDeptDateRankingVOLists.forEach(x -> x.setOrdersReceivedRate(Double.valueOf(Double.parseDouble(String.format("%.1f", x.getOrdersReceivedRate() * 100.0)))));
            docDeptDateRankingResVO.setDataType(Integer.valueOf(1)).setDocDeptDateRankingVOList(docDeptDateRankingVOLists.stream().filter(x -> x.getHospitalId().equals(orderListForCountReqVo.getHospitalId())).collect(Collectors.toList()));
            return BaseResponse.success((Object)docDeptDateRankingResVO);
        }
        if (Objects.nonNull(orderListForCountReqVo.getDeptId())) {
            docDeptDateRankingVOLists.forEach(x -> x.setCompletionRate(Double.valueOf(Double.parseDouble(String.format("%.1f", x.getCompletionRate() * 100.0)))));
            docDeptDateRankingResVO.setDataType(Integer.valueOf(1)).setDocDeptDateRankingVOList(docDeptDateRankingVOLists.stream().filter(x -> x.getDeptId().equals(orderListForCountReqVo.getDeptId())).collect(Collectors.toList()));
            return BaseResponse.success((Object)docDeptDateRankingResVO);
        }
        if (Objects.nonNull(orderListForCountReqVo.getHospitalId()) && Objects.nonNull(orderListForCountReqVo.getDeptId())) {
            docDeptDateRankingVOLists.forEach(x -> x.setCompletionRate(Double.valueOf(Double.parseDouble(String.format("%.1f", x.getCompletionRate() * 100.0)))));
            docDeptDateRankingResVO.setDataType(Integer.valueOf(1)).setDocDeptDateRankingVOList(docDeptDateRankingVOLists.stream().filter(x -> x.getDeptId().equals(orderListForCountReqVo.getDeptId()) && x.getHospitalId().equals(orderListForCountReqVo.getHospitalId())).collect(Collectors.toList()));
            return BaseResponse.success((Object)docDeptDateRankingResVO);
        }
        docDeptDateRankingResVO.setDataType(Integer.valueOf(1)).setDocDeptDateRankingVOList(docDeptDateRankingVOLists);
        return BaseResponse.success((Object)docDeptDateRankingResVO);
    }

    private List<OrderCountForMangVo> replaceNewDeptName(List<OrderCountForMangVo> list) {
        List sortList = list.stream().sorted(Comparator.comparing(OrderCountForMangVo::getCreateTime, Comparator.reverseOrder())).collect(Collectors.toList());
        LinkedHashMap map = sortList.stream().collect(Collectors.groupingBy(OrderCountForMangVo::getDeptId, LinkedHashMap::new, Collectors.toList()));
        HashMap hashMap = new HashMap(20);
        for (Map.Entry entry : map.entrySet()) {
            hashMap.put(entry.getKey(), ((OrderCountForMangVo)((List)entry.getValue()).get(0)).getDeptName());
        }
        list.stream().forEach(item -> {
            for (Map.Entry entry : hashMap.entrySet()) {
                if (!Objects.equals(item.getDeptId(), entry.getKey())) continue;
                item.setDeptName((String)entry.getValue());
            }
        });
        return list;
    }

    public BaseResponse docDataRankingExport(OrderListForCountReqVo orderListForCountReqVo, HttpServletResponse response) {
        BaseResponse docDeptDateRankingResVOBaseResponse = this.docDataRanking(orderListForCountReqVo);
        if (docDeptDateRankingResVOBaseResponse.isSuccess()) {
            DocDeptDateRankingResVO docDeptDateRankingResVO = (DocDeptDateRankingResVO)docDeptDateRankingResVOBaseResponse.getData();
            List docDeptDateRankingVOList = docDeptDateRankingResVO.getDocDeptDateRankingVOList();
            ArrayList<ExportDocDeptDateRanking> exportDocDeptDateRankingList = new ArrayList<ExportDocDeptDateRanking>();
            int i = 0;
            while (i < docDeptDateRankingVOList.size()) {
                DocDeptDateRankingVO docDeptDateRankingVO = (DocDeptDateRankingVO)docDeptDateRankingVOList.get(i);
                ExportDocDeptDateRanking exportDocDeptDateRanking = new ExportDocDeptDateRanking();
                BeanUtils.copyProperties((Object)docDeptDateRankingVO, (Object)exportDocDeptDateRanking);
                exportDocDeptDateRanking.setAvgReceiveTime(this.toHourMinute(docDeptDateRankingVO.getAvgReceiveTime()));
                exportDocDeptDateRanking.setOrdersReceivedRate(docDeptDateRankingVO.getOrdersReceivedRate() + "%");
                exportDocDeptDateRanking.setRanking(Integer.valueOf(++i));
                exportDocDeptDateRankingList.add(exportDocDeptDateRanking);
            }
            log.info("\u533b\u751f\u6570\u636e\u6392\u884c\u7684\u5bfc\u51faexcel\u4e3a:{}" + JSON.toJSONString(exportDocDeptDateRankingList));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            String dateTime = simpleDateFormat.format(new Date());
            String fileName = "\u533b\u751f\u6570\u636e\u6392\u884c" + dateTime;
            ExcelUtils.exportExcel(exportDocDeptDateRankingList, null, null, ExportDocDeptDateRanking.class, (String)fileName, (boolean)true, (HttpServletResponse)response);
            return BaseResponse.success();
        }
        return docDeptDateRankingResVOBaseResponse;
    }

    public BaseResponse<DocDeptDateRankingResVO> deptReceiveRanking(OrderListForCountReqVo orderListForCountReqVo) {
        orderListForCountReqVo.setDeptId(null);
        orderListForCountReqVo.setStartTime(orderListForCountReqVo.getStartTime() + " 00:00:00");
        orderListForCountReqVo.setEndTime(orderListForCountReqVo.getEndTime() + " 23:59:59");
        DocDeptDateRankingResVO docDeptDateRankingResVO = new DocDeptDateRankingResVO();
        ArrayList<DocDeptDateRankingVO> docDeptDateRankingVOList = new ArrayList<DocDeptDateRankingVO>();
        ArrayList<DocDeptDateRankingVO> docDeptDateRankingVOLists = new ArrayList<DocDeptDateRankingVO>();
        List<Object> docDeptDateRankingVOListsort = new ArrayList();
        List list = this.orderMapper.selectOrderDocCount(orderListForCountReqVo);
        List orderCount = this.replaceNewDeptName(list);
        ArrayList orderCountForMangVos = orderCount.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<OrderCountForMangVo>(Comparator.comparing(o -> o.getHospitalId() + o.getDeptId()))), ArrayList::new));
        for (OrderCountForMangVo doctor : orderCountForMangVos) {
            List newOrderCount = orderCount.stream().filter(x -> x.getDeptId().equals(doctor.getDeptId())).collect(Collectors.toList());
            List newOrderDateCount = orderCount.stream().filter(x -> x.getDeptId().equals(doctor.getDeptId()) && x.getStartTime() != null).collect(Collectors.toList());
            List orderCountForMang = orderCount.stream().filter(x -> x.getDoctorName() != null && x.getStatus() != 65 && x.getDeptId().equals(doctor.getDeptId())).collect(Collectors.toList());
            List completeNewOrdersList = orderCount.stream().filter(x -> x.getStartTime() != null && x.getDeptId().equals(doctor.getDeptId()) && x.getSecondsCount() != null).collect(Collectors.toList());
            List completeOrdersList = orderCount.stream().filter(x -> (x.getStatus() == 7 || x.getStatus() == 8 || x.getStatus() == 9) && x.getStartTime() != null && x.getEndTime() != null && x.getDeptId().equals(doctor.getDeptId()) && x.getTestOrder() == null && x.getTestPatient() == null).collect(Collectors.toList());
            DocDeptDateRankingVO docDeptDateRankingVO = new DocDeptDateRankingVO();
            docDeptDateRankingVO.setDeptName(doctor.getDeptName()).setDeptId(doctor.getDeptId()).setDocName(doctor.getDoctorName()).setOrdersReceived(Integer.valueOf(orderCount.stream().filter(x -> Objects.nonNull(x.getReceptionTime()) && x.getStartTime() != null && x.getDeptId().equals(doctor.getDeptId())).collect(Collectors.toList()).size())).setNewOrderCount(Integer.valueOf(newOrderCount.size()));
            List processingOrder = orderCount.stream().filter(order -> Objects.nonNull(order.getReceptionTime()) && order.getDoctorName().equals(doctor.getDoctorName()) && order.getDeptId().equals(doctor.getDeptId())).collect(Collectors.toList());
            List admissionOrder = orderCount.stream().filter(order -> Objects.nonNull(order.getConvertWaitTime()) && order.getDoctorName().equals(doctor.getDoctorName()) && order.getDeptId().equals(doctor.getDeptId())).collect(Collectors.toList());
            if (processingOrder.size() == 0) {
                docDeptDateRankingVO.setAvgReceiveTime(Integer.valueOf(0));
            } else {
                int sumWaitTime = 0;
                for (int i = 0; i < processingOrder.size(); ++i) {
                    if (!Objects.nonNull(((OrderCountForMangVo)processingOrder.get(i)).getStartTime()) || !Objects.nonNull(((OrderCountForMangVo)processingOrder.get(i)).getConvertWaitTime())) continue;
                    int differTime = DateUtils.secondBetween((Date)((OrderCountForMangVo)processingOrder.get(i)).getConvertWaitTime(), (Date)((OrderCountForMangVo)processingOrder.get(i)).getStartTime());
                    sumWaitTime += differTime;
                }
                int ave = sumWaitTime / 60 / processingOrder.size();
                docDeptDateRankingVO.setAvgReceiveTime(Integer.valueOf(ave));
            }
            if (processingOrder.size() == 0 || admissionOrder.size() == 0) {
                docDeptDateRankingVO.setOrdersReceivedRate(Double.valueOf(0.0));
            } else {
                docDeptDateRankingVO.setOrdersReceivedRate(Double.valueOf((double)processingOrder.size() / (double)admissionOrder.size()));
            }
            if (completeNewOrdersList.size() == 0) {
                docDeptDateRankingVO.setCompletionRate(Double.valueOf(0.0));
            } else {
                docDeptDateRankingVO.setCompletionRate(Double.valueOf((double)completeOrdersList.size() / (double)completeNewOrdersList.size()));
            }
            docDeptDateRankingVOList.add(docDeptDateRankingVO);
        }
        Map<String, List<DocDeptDateRankingVO>> collect = docDeptDateRankingVOList.stream().collect(Collectors.groupingBy(DocDeptDateRankingVO::getDeptId));
        for (String s : collect.keySet()) {
            DocDeptDateRankingVO docDeptDateRankingVO = new DocDeptDateRankingVO();
            docDeptDateRankingVO.setDeptName(((DocDeptDateRankingVO)collect.get(s).stream().filter(x -> x.getDeptName() != null).collect(Collectors.toList()).get(0)).getDeptName());
            if (collect.get(s).size() != 0) {
                docDeptDateRankingVO.setAvgReceiveTime(Integer.valueOf(collect.get(s).stream().mapToInt(DocDeptDateRankingVO::getAvgReceiveTime).sum() / collect.get(s).size())).setOrdersReceived(Integer.valueOf(collect.get(s).stream().mapToInt(DocDeptDateRankingVO::getOrdersReceived).sum() / collect.get(s).size())).setCompletionRate(Double.valueOf(collect.get(s).stream().mapToDouble(DocDeptDateRankingVO::getCompletionRate).sum() / (double)collect.get(s).size())).setOrdersReceivedRate(Double.valueOf(collect.get(s).stream().mapToDouble(DocDeptDateRankingVO::getOrdersReceivedRate).sum() / (double)collect.get(s).size())).setNewOrderCount(Integer.valueOf(collect.get(s).stream().mapToInt(DocDeptDateRankingVO::getNewOrderCount).sum() / collect.get(s).size()));
            } else {
                docDeptDateRankingVO.setAvgReceiveTime(Integer.valueOf(0)).setOrdersReceived(Integer.valueOf(0)).setCompletionRate(Double.valueOf(0.0)).setOrdersReceivedRate(Double.valueOf(0.0)).setNewOrderCount(Integer.valueOf(0));
            }
            docDeptDateRankingVOLists.add(docDeptDateRankingVO);
        }
        if (!Objects.isNull(orderListForCountReqVo.getSortType())) {
            if ("1".equals(orderListForCountReqVo.getSortType())) {
                if (orderListForCountReqVo.getAvgReceiveTime() != null && !"".equals(orderListForCountReqVo.getAvgReceiveTime())) {
                    docDeptDateRankingVOListsort = docDeptDateRankingVOLists.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getAvgReceiveTime).reversed()).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getOrdersReceived() != null && !"".equals(orderListForCountReqVo.getOrdersReceived())) {
                    docDeptDateRankingVOListsort = docDeptDateRankingVOLists.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getOrdersReceived).reversed()).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getCompletionRate() != null && !"".equals(orderListForCountReqVo.getCompletionRate())) {
                    docDeptDateRankingVOListsort = docDeptDateRankingVOLists.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getCompletionRate).reversed()).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getNewOrderCount() != null && !"".equals(orderListForCountReqVo.getNewOrderCount())) {
                    docDeptDateRankingVOListsort = docDeptDateRankingVOLists.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getNewOrderCount).reversed()).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getOrdersReceivedRate() != null && !"".equals(orderListForCountReqVo.getOrdersReceivedRate())) {
                    docDeptDateRankingVOListsort = docDeptDateRankingVOLists.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getOrdersReceivedRate).reversed()).collect(Collectors.toList());
                }
            } else if ("2".equals(orderListForCountReqVo.getSortType())) {
                if (orderListForCountReqVo.getAvgReceiveTime() != null && !"".equals(orderListForCountReqVo.getAvgReceiveTime())) {
                    docDeptDateRankingVOListsort = docDeptDateRankingVOLists.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getAvgReceiveTime)).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getOrdersReceived() != null && !"".equals(orderListForCountReqVo.getOrdersReceived())) {
                    docDeptDateRankingVOListsort = docDeptDateRankingVOLists.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getOrdersReceived)).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getCompletionRate() != null && !"".equals(orderListForCountReqVo.getCompletionRate())) {
                    docDeptDateRankingVOListsort = docDeptDateRankingVOLists.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getCompletionRate)).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getNewOrderCount() != null && !"".equals(orderListForCountReqVo.getNewOrderCount())) {
                    docDeptDateRankingVOListsort = docDeptDateRankingVOLists.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getNewOrderCount)).collect(Collectors.toList());
                }
                if (orderListForCountReqVo.getOrdersReceivedRate() != null && !"".equals(orderListForCountReqVo.getOrdersReceivedRate())) {
                    docDeptDateRankingVOListsort = docDeptDateRankingVOLists.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getOrdersReceivedRate)).collect(Collectors.toList());
                }
            }
        } else {
            docDeptDateRankingVOListsort = docDeptDateRankingVOLists.stream().sorted(Comparator.comparing(DocDeptDateRankingVO::getAvgReceiveTime).reversed()).collect(Collectors.toList());
        }
        docDeptDateRankingVOLists.forEach(x -> x.setCompletionRate(Double.valueOf(Double.parseDouble(String.format("%.1f", x.getCompletionRate() * 100.0)))));
        docDeptDateRankingVOLists.forEach(x -> x.setOrdersReceivedRate(Double.valueOf(Double.parseDouble(String.format("%.1f", x.getOrdersReceivedRate() * 100.0)))));
        docDeptDateRankingResVO.setDataType(Integer.valueOf(2)).setDocDeptDateRankingVOList(docDeptDateRankingVOListsort);
        return BaseResponse.success((Object)docDeptDateRankingResVO);
    }

    public BaseResponse deptReceiveRankingExport(OrderListForCountReqVo orderListForCountReqVo, HttpServletResponse response) {
        BaseResponse docDeptDateRankingResVOBaseResponse = this.deptReceiveRanking(orderListForCountReqVo);
        if (docDeptDateRankingResVOBaseResponse.isSuccess()) {
            DocDeptDateRankingResVO docDeptDateRankingResVO = (DocDeptDateRankingResVO)docDeptDateRankingResVOBaseResponse.getData();
            List docDeptDateRankingVOList = docDeptDateRankingResVO.getDocDeptDateRankingVOList();
            ArrayList<ExportDeptReceiveRanking> exportDeptReceiveRankingList = new ArrayList<ExportDeptReceiveRanking>();
            int i = 0;
            while (i < docDeptDateRankingVOList.size()) {
                DocDeptDateRankingVO docDeptDateRankingVO = (DocDeptDateRankingVO)docDeptDateRankingVOList.get(i);
                ExportDeptReceiveRanking exportDeptReceiveRanking = new ExportDeptReceiveRanking();
                BeanUtils.copyProperties((Object)docDeptDateRankingVO, (Object)exportDeptReceiveRanking);
                exportDeptReceiveRanking.setAvgReceiveTime(this.toHourMinute(docDeptDateRankingVO.getAvgReceiveTime()));
                exportDeptReceiveRanking.setOrdersReceivedRate(docDeptDateRankingVO.getOrdersReceivedRate() + "%");
                exportDeptReceiveRanking.setRanking(Integer.valueOf(++i));
                exportDeptReceiveRankingList.add(exportDeptReceiveRanking);
            }
            log.info("\u79d1\u5ba4\u63a5\u8bca\u91cf\u6392\u884c\u7684\u5bfc\u51faexcel\u4e3a:{}" + JSON.toJSONString(exportDeptReceiveRankingList));
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            String dateTime = simpleDateFormat.format(new Date());
            String fileName = "\u79d1\u5ba4\u63a5\u8bca\u91cf\u6392\u884c" + dateTime;
            ExcelUtils.exportExcel(exportDeptReceiveRankingList, null, null, ExportDeptReceiveRanking.class, (String)fileName, (boolean)true, (HttpServletResponse)response);
            return BaseResponse.success();
        }
        return docDeptDateRankingResVOBaseResponse;
    }

    private String toHourMinute(Integer minute) {
        if (Objects.isNull(minute) || minute == 0) {
            return "<1\u5206\u949f";
        }
        int h = minute / 60;
        int m = minute % 60;
        return (h == 0 ? "" : h + "\u5c0f\u65f6") + (m == 0 ? "" : m + "\u5206\u949f");
    }

    private BaseResponse<OrderListForPercentageResVo> avgLengthTreatment(OrderListForCountReqVo orderListForCountReqVo) {
        orderListForCountReqVo.setStartTime(orderListForCountReqVo.getStartTime());
        orderListForCountReqVo.setEndTime(orderListForCountReqVo.getEndTime());
        OrderListForPercentageResVo orderListForPercentageResVo = new OrderListForPercentageResVo();
        int waitingInquiryTimeCount = 0;
        List inquiryAdmissionEntities = this.orderMapper.selectOrderStatusPatientCount(orderListForCountReqVo);
        for (OrderCountForMangVo inquiryAdmissionEntity : inquiryAdmissionEntities) {
            int i = DateUtils.secondBetween((Date)inquiryAdmissionEntity.getCreateTime(), (Date)inquiryAdmissionEntity.getStartTime());
            waitingInquiryTimeCount += i;
        }
        orderListForPercentageResVo.setStartTime(orderListForCountReqVo.getStartTime()).setEndTime(orderListForCountReqVo.getEndTime()).setDataType("1").setServType(orderListForCountReqVo.getServType());
        if (waitingInquiryTimeCount == 0) {
            orderListForPercentageResVo.setDataInfo("0.0");
        } else {
            orderListForPercentageResVo.setDataInfo(String.valueOf(waitingInquiryTimeCount / 60 / inquiryAdmissionEntities.size()));
        }
        return BaseResponse.success((Object)orderListForPercentageResVo);
    }

    private BaseResponse<OrderListForPercentageResVo> totalReceptionRate(OrderListForCountReqVo orderListForCountReqVo) {
        OrderListForPercentageResVo orderListForPercentageResVo = new OrderListForPercentageResVo();
        orderListForCountReqVo.setStartTime(orderListForCountReqVo.getStartTime());
        orderListForCountReqVo.setEndTime(orderListForCountReqVo.getEndTime());
        List newAdmissionEntities = this.orderMapper.selectOrderCountByCreateTime(orderListForCountReqVo);
        ArrayList<Integer> orderType = new ArrayList<Integer>();
        orderType.add(2);
        orderType.add(7);
        orderType.add(8);
        orderType.add(9);
        orderListForCountReqVo.setStatusList(orderType);
        List inquiryAdmissionEntities = this.orderMapper.selectOrderStatusCount(orderListForCountReqVo);
        ArrayList<Integer> newOrderTypes = new ArrayList<Integer>();
        newOrderTypes.add(20);
        newOrderTypes.add(40);
        newOrderTypes.add(41);
        newOrderTypes.add(42);
        orderListForCountReqVo.setStatusList(newOrderTypes);
        List inquiryAdmissionEntitiesOrder = this.orderMapper.selectOrderStatusWaitingCount(orderListForCountReqVo);
        orderListForPercentageResVo.setStartTime(orderListForCountReqVo.getStartTime()).setEndTime(orderListForCountReqVo.getEndTime()).setDataType("2").setServType(orderListForCountReqVo.getServType());
        if (inquiryAdmissionEntities.isEmpty() || newAdmissionEntities.size() - inquiryAdmissionEntitiesOrder.size() == 0) {
            orderListForPercentageResVo.setDataInfo("0.0");
        } else {
            orderListForPercentageResVo.setDataInfo(String.format("%.1f", (double)inquiryAdmissionEntities.size() / ((double)newAdmissionEntities.size() - (double)inquiryAdmissionEntitiesOrder.size()) * 100.0));
        }
        return BaseResponse.success((Object)orderListForPercentageResVo);
    }

    private BaseResponse<OrderListForPercentageResVo> calculateCompleteOrderRate(OrderListForCountReqVo vo) {
        vo.setStatusList(null);
        OrderListForPercentageResVo orderListForPercentageResVo = new OrderListForPercentageResVo();
        List allOrderList = this.orderMapper.selectOrderStatusCount(vo);
        List admissionOrder = allOrderList.stream().filter(order -> Objects.nonNull(order.getConvertWaitTime())).collect(Collectors.toList());
        ArrayList<Integer> completeOrderType = new ArrayList<Integer>();
        completeOrderType.add(7);
        completeOrderType.add(8);
        completeOrderType.add(9);
        vo.setStatusList(completeOrderType);
        List completeOrder = this.orderMapper.selectOrderStatusCount(vo);
        orderListForPercentageResVo.setStartTime(vo.getStartTime()).setEndTime(vo.getEndTime()).setDataType("3").setServType(vo.getServType());
        if (Objects.isNull(admissionOrder) || Objects.isNull(completeOrder) || admissionOrder.size() == 0 || completeOrder.size() == 0) {
            orderListForPercentageResVo.setDataInfo("0.0");
        } else {
            orderListForPercentageResVo.setDataInfo(String.format("%.3f", (double)completeOrder.size() / (double)admissionOrder.size()));
        }
        log.info("\u8ba2\u5355\u5b8c\u6210\u7387" + orderListForPercentageResVo);
        return BaseResponse.success((Object)orderListForPercentageResVo);
    }

    private BaseResponse<OrderListForPercentageResVo> calculateInvalidOrderRate(OrderListForCountReqVo vo) {
        OrderListForPercentageResVo orderListForPercentageResVo = new OrderListForPercentageResVo();
        List allOrderList = this.orderMapper.selectOrderCountByCreateTime(vo);
        Integer[] invalidOrderStatus = new Integer[]{0, 4, 5, 6, 111, 112, 113, 11, 30, 10, 15, 114, 115, 50, 45, 46};
        ArrayList<Integer> invalidOrderType = new ArrayList<Integer>();
        invalidOrderType.addAll(Arrays.asList(invalidOrderStatus));
        vo.setStatusList(invalidOrderType);
        List invalidOrder = this.orderMapper.selectOrderStatusCount(vo);
        orderListForPercentageResVo.setStartTime(vo.getStartTime()).setEndTime(vo.getEndTime()).setDataType("6").setServType(vo.getServType());
        if (Objects.isNull(allOrderList) || Objects.isNull(invalidOrder) || allOrderList.size() == 0 || invalidOrder.size() == 0) {
            orderListForPercentageResVo.setDataInfo("0.0");
        } else {
            orderListForPercentageResVo.setDataInfo(String.format("%.3f", (double)invalidOrder.size() / (double)allOrderList.size()));
        }
        return BaseResponse.success((Object)orderListForPercentageResVo);
    }

    private BaseResponse<OrderListForPercentageResVo> calculateAdmissionOrderRate(OrderListForCountReqVo vo) {
        vo.setStatusList(null);
        OrderListForPercentageResVo orderListForPercentageResVo = new OrderListForPercentageResVo();
        List allOrderList = this.orderMapper.selectOrderStatusCount(vo);
        List admissionOrder = allOrderList.stream().filter(order -> Objects.nonNull(order.getConvertWaitTime())).collect(Collectors.toList());
        List processingOrder = allOrderList.stream().filter(order -> Objects.nonNull(order.getReceptionTime())).collect(Collectors.toList());
        orderListForPercentageResVo.setStartTime(vo.getStartTime()).setEndTime(vo.getEndTime()).setDataType("5").setServType(vo.getServType());
        if (Objects.isNull(admissionOrder) || Objects.isNull(processingOrder) || admissionOrder.size() == 0 || processingOrder.size() == 0) {
            orderListForPercentageResVo.setDataInfo("0.0");
        } else {
            orderListForPercentageResVo.setDataInfo(String.format("%.3f", (double)processingOrder.size() / (double)admissionOrder.size()));
        }
        return BaseResponse.success((Object)orderListForPercentageResVo);
    }

    private BaseResponse<OrderListForPercentageResVo> patientAverageWaitTime(OrderListForCountReqVo vo) {
        OrderListForPercentageResVo orderListForPercentageResVo = new OrderListForPercentageResVo();
        List haveReceptionTimeList = this.orderMapper.selectOrderStatusCount(vo);
        List collet = haveReceptionTimeList.stream().filter(item -> Objects.nonNull(item.getReceptionTime())).collect(Collectors.toList());
        int sumWaitTime = 0;
        for (int i = 0; i < collet.size(); ++i) {
            if (!Objects.nonNull(((OrderCountForMangVo)collet.get(i)).getStartTime()) || !Objects.nonNull(((OrderCountForMangVo)collet.get(i)).getConvertWaitTime())) continue;
            int differTime = DateUtils.secondBetween((Date)((OrderCountForMangVo)collet.get(i)).getConvertWaitTime(), (Date)((OrderCountForMangVo)collet.get(i)).getStartTime());
            sumWaitTime += differTime;
        }
        orderListForPercentageResVo.setStartTime(vo.getStartTime()).setEndTime(vo.getEndTime()).setDataType("7").setServType(vo.getServType());
        if (Objects.nonNull(collet) && collet.size() > 0) {
            int ave = sumWaitTime / 60 / collet.size();
            orderListForPercentageResVo.setDataInfo(String.valueOf(ave));
        } else {
            orderListForPercentageResVo.setDataInfo("0.0");
        }
        return BaseResponse.success((Object)orderListForPercentageResVo);
    }

    private BaseResponse<OrderListForPercentageResVo> orderCompletionRate(OrderListForCountReqVo orderListForCountReqVo) {
        orderListForCountReqVo.setStartTime(orderListForCountReqVo.getStartTime());
        orderListForCountReqVo.setEndTime(orderListForCountReqVo.getEndTime());
        OrderListForPercentageResVo orderCompletionRate = new OrderListForPercentageResVo();
        List completeNewOrdersList = this.orderMapper.selectOrderCountByCreateTime(orderListForCountReqVo);
        ArrayList<Integer> completedList = new ArrayList<Integer>();
        completedList.add(7);
        completedList.add(8);
        completedList.add(9);
        orderListForCountReqVo.setStatusList(completedList);
        List completeOrdersList = this.orderMapper.selectOrderStatusCount(orderListForCountReqVo);
        int completedSum = 0;
        int newOrderSum = 0;
        if (!completeNewOrdersList.isEmpty()) {
            newOrderSum = completeNewOrdersList.size();
        }
        if (!completeOrdersList.isEmpty()) {
            completedSum = completeOrdersList.size();
        }
        orderCompletionRate.setStartTime(orderListForCountReqVo.getStartTime()).setEndTime(orderListForCountReqVo.getEndTime()).setDataType("3").setServType(orderListForCountReqVo.getServType());
        if (completedSum == 0 || newOrderSum == 0) {
            orderCompletionRate.setDataInfo("0.0");
        } else {
            orderCompletionRate.setDataInfo(String.format("%.1f", (double)completedSum / (double)newOrderSum * 100.0));
        }
        return BaseResponse.success((Object)orderCompletionRate);
    }

    public BaseResponse<List<ExportOrderDocResDto>> exportOrderDocList(OrderListForCountReqVo orderListForCountReqVo) {
        ArrayList objects = new ArrayList();
        List orderDocLists = this.getOrderDocLists(orderListForCountReqVo);
        objects.addAll(orderDocLists);
        return BaseResponse.success(objects);
    }

    private List<ExportOrderDocResDto> getOrderDocLists(OrderListForCountReqVo orderListForCountReqVo) {
        orderListForCountReqVo.setServType(ServiceTypeEnum.NOS.getValue());
        List orderListDocListFZ = this.getOrderListDocListFZ(orderListForCountReqVo);
        log.info("\u83b7\u53d6\u8ba2\u5355\u6570\u636e-\u590d\u8bca-\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)orderListDocListFZ));
        return orderListDocListFZ;
    }

    private List<ExportOrderDocResDto> getOrderListDocListFZ(OrderListForCountReqVo orderListForCountReqVo) {
        ArrayList<ExportOrderDocResDto> exportOrderDocResDtos = new ArrayList<ExportOrderDocResDto>();
        orderListForCountReqVo.setStartTime(StringUtils.substring((String)orderListForCountReqVo.getStartTime(), (int)0, (int)10));
        orderListForCountReqVo.setEndTime(StringUtils.substring((String)orderListForCountReqVo.getEndTime(), (int)0, (int)10));
        OrderListForCountResVo undoneFZ = new OrderListForCountResVo();
        OrderListForCountResVo newOrderFZ = new OrderListForCountResVo();
        OrderListForCountResVo expiredFZ = new OrderListForCountResVo();
        OrderListForCountResVo completedFZ = new OrderListForCountResVo();
        OrderListForCountResVo newPatientFZ = new OrderListForCountResVo();
        OrderListForCountResVo newAmountFZ = new OrderListForCountResVo();
        OrderListForCountResVo completedAmountFZ = new OrderListForCountResVo();
        OrderListForCountResVo refunAmountFZ = new OrderListForCountResVo();
        expiredFZ.setEndTime(orderListForCountReqVo.getEndTime());
        expiredFZ.setServType(ServiceTypeEnum.NOS.getValue());
        expiredFZ.setOrderStatus(ImmediateConsultationVoTypeEnum.TYPE_RETURN.getValue());
        expiredFZ.setUnit(WhetherEnum.ALLOW.getValue());
        undoneFZ.setEndTime(orderListForCountReqVo.getEndTime());
        undoneFZ.setServType(ServiceTypeEnum.NOS.getValue());
        undoneFZ.setOrderStatus(ImmediateConsultationVoTypeEnum.IN_CONSULTATION.getValue());
        undoneFZ.setUnit(WhetherEnum.ALLOW.getValue());
        completedFZ.setEndTime(orderListForCountReqVo.getEndTime());
        completedFZ.setServType(ServiceTypeEnum.NOS.getValue());
        completedFZ.setOrderStatus(ImmediateConsultationVoTypeEnum.TOPAY.getValue());
        completedFZ.setUnit(WhetherEnum.ALLOW.getValue());
        newOrderFZ.setEndTime(orderListForCountReqVo.getEndTime());
        newOrderFZ.setServType(ServiceTypeEnum.NOS.getValue());
        newOrderFZ.setOrderStatus(ImmediateConsultationVoTypeEnum.OK.getValue());
        newOrderFZ.setUnit(WhetherEnum.ALLOW.getValue());
        newPatientFZ.setEndTime(orderListForCountReqVo.getEndTime());
        newPatientFZ.setServType(ServiceTypeEnum.NOS.getValue());
        newPatientFZ.setOrderStatus(ImmediateConsultationVoTypeEnum.WAIT_ADMISSION.getValue());
        newPatientFZ.setUnit(WhetherEnum.FORBID.getValue());
        newAmountFZ.setEndTime(orderListForCountReqVo.getEndTime());
        newAmountFZ.setServType(ServiceTypeEnum.NOS.getValue());
        newAmountFZ.setOrderStatus(ImmediateConsultationVoTypeEnum.NEW_MOUNT.getValue());
        newAmountFZ.setUnit(WhetherEnum.ALLOW.getValue());
        completedAmountFZ.setEndTime(orderListForCountReqVo.getEndTime());
        completedAmountFZ.setServType(ServiceTypeEnum.NOS.getValue());
        completedAmountFZ.setOrderStatus(ImmediateConsultationVoTypeEnum.COMPLETED_AMOUNT.getValue());
        completedAmountFZ.setUnit(WhetherEnum.ALLOW.getValue());
        refunAmountFZ.setEndTime(orderListForCountReqVo.getEndTime());
        refunAmountFZ.setServType(ServiceTypeEnum.NOS.getValue());
        refunAmountFZ.setOrderStatus(ImmediateConsultationVoTypeEnum.REFUN_AMOUNT.getValue());
        refunAmountFZ.setUnit(WhetherEnum.ALLOW.getValue());
        if (StringUtils.isEmpty((String)orderListForCountReqVo.getStartTime()) || StringUtils.isEmpty((String)orderListForCountReqVo.getEndTime())) {
            String currentDateStr = DateUtils.getCurrentDateSimpleToString();
            String yestarDayStr = DateUtils.getYestarDayToString((String)currentDateStr);
            orderListForCountReqVo.setStartTime(yestarDayStr);
            orderListForCountReqVo.setEndTime(yestarDayStr);
        }
        orderListForCountReqVo.setStartTime(orderListForCountReqVo.getStartTime() + " 00:00:00");
        orderListForCountReqVo.setEndTime(orderListForCountReqVo.getEndTime() + " 23:59:59");
        orderListForCountReqVo.setServType(ServiceTypeEnum.NOS.getValue());
        log.info("\u590d\u8bca\u5165\u53c2{}", (Object)orderListForCountReqVo.toString());
        List admissionFzList = this.orderMapper.selectOrderDocCount(orderListForCountReqVo);
        log.info("\u590d\u8bca\u66f4\u65b0\u65f6\u95f4\u6570\u636e{}", (Object)JSON.toJSONString((Object)admissionFzList));
        List admissionFzListCreateTime = this.orderMapper.selectOrderCountByCreateTime(orderListForCountReqVo);
        log.info("\u590d\u8bca\u521b\u5efa\u65f6\u95f4\u6570\u636e{}", (Object)JSON.toJSONString((Object)admissionFzListCreateTime));
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        if (CollectionUtils.isEmpty((Collection)admissionFzListCreateTime) && CollectionUtils.isEmpty((Collection)admissionFzList)) {
            expiredFZ.setCount(Integer.valueOf(0));
            undoneFZ.setCount(Integer.valueOf(0));
            completedFZ.setCount(Integer.valueOf(0));
            newOrderFZ.setCount(Integer.valueOf(0));
            newPatientFZ.setCount(Integer.valueOf(0));
            newAmountFZ.setOrderMoney(decimalFormat.format(0.0));
            completedAmountFZ.setOrderMoney(decimalFormat.format(0.0));
            refunAmountFZ.setOrderMoney(decimalFormat.format(0.0));
        } else {
            Map<String, List<OrderCountForMangVo>> collect1 = admissionFzListCreateTime.stream().filter(x -> x.getCreateTime() != null).collect(Collectors.groupingBy(OrderCountForMangVo::getDoctorName));
            for (String s : collect1.keySet()) {
                ExportOrderDocResDto exportOrderDocResDto = new ExportOrderDocResDto();
                Map<String, List<OrderCountForMangVo>> collect = collect1.get(s).stream().filter(x -> x.getCreateTime() != null).collect(Collectors.toList()).stream().collect(Collectors.groupingBy(x -> DateUtils.dateToSimpleString((Date)x.getCreateTime())));
                ArrayList<ExportOrderResDto> orderInfoList = new ArrayList<ExportOrderResDto>();
                ArrayList<ExportOrderFzResVo> exportOrderFzResVoList = new ArrayList<ExportOrderFzResVo>();
                ExportOrderResDto exportOrderResDto = new ExportOrderResDto();
                for (String s1 : collect.keySet()) {
                    List collect2 = admissionFzList.stream().filter(x -> x.getDoctorName().equals(s) && DateUtils.dateToSimpleString((Date)x.getCreateTime()).equals(s1)).collect(Collectors.toList());
                    ExportOrderFzResVo exportOrderForFZ = new ExportOrderFzResVo();
                    if (collect.get(s1).size() == 1) {
                        exportOrderForFZ.setCreateTime(DateUtils.dateToSimpleString((Date)collect.get(s1).get(0).getCreateTime()));
                    } else {
                        exportOrderForFZ.setCreateTime(s1);
                    }
                    List<OrderCountForMangVo> orderCountForMangVos = collect.get(s1);
                    expiredFZ.setStartTime(DateUtils.dateToSimpleString((Date)orderCountForMangVos.get(0).getCreateTime()));
                    undoneFZ.setStartTime(DateUtils.dateToSimpleString((Date)orderCountForMangVos.get(0).getCreateTime()));
                    completedFZ.setStartTime(DateUtils.dateToSimpleString((Date)orderCountForMangVos.get(0).getCreateTime()));
                    newOrderFZ.setStartTime(DateUtils.dateToSimpleString((Date)orderCountForMangVos.get(0).getCreateTime()));
                    newPatientFZ.setStartTime(DateUtils.dateToSimpleString((Date)orderCountForMangVos.get(0).getCreateTime()));
                    newAmountFZ.setStartTime(DateUtils.dateToSimpleString((Date)orderCountForMangVos.get(0).getCreateTime()));
                    completedAmountFZ.setStartTime(DateUtils.dateToSimpleString((Date)orderCountForMangVos.get(0).getCreateTime()));
                    refunAmountFZ.setStartTime(DateUtils.dateToSimpleString((Date)orderCountForMangVos.get(0).getCreateTime()));
                    expiredFZ.setDocName(orderCountForMangVos.get(0).getDoctorName());
                    undoneFZ.setDocName(orderCountForMangVos.get(0).getDoctorName());
                    completedFZ.setDocName(orderCountForMangVos.get(0).getDoctorName());
                    newOrderFZ.setDocName(orderCountForMangVos.get(0).getDoctorName());
                    newPatientFZ.setDocName(orderCountForMangVos.get(0).getDoctorName());
                    newAmountFZ.setDocName(orderCountForMangVos.get(0).getDoctorName());
                    completedAmountFZ.setDocName(orderCountForMangVos.get(0).getDoctorName());
                    refunAmountFZ.setDocName(orderCountForMangVos.get(0).getDoctorName());
                    ArrayList admUndoneList = orderCountForMangVos.stream().filter(x -> AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(x.getStatus()) || AdmissionStatusEnum.WAIT_ADMISSION.getValue().equals(x.getStatus()) || AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(x.getStatus())).collect(Collectors.toCollection(ArrayList::new));
                    ArrayList admCompleteList = orderCountForMangVos.stream().filter(x -> AdmissionStatusEnum.FINISH_APPLY.getValue().equals(x.getStatus()) || AdmissionStatusEnum.FINISH_TIME_OUT.getValue().equals(x.getStatus()) || AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue().equals(x.getStatus())).collect(Collectors.toCollection(ArrayList::new));
                    ArrayList admExpiredList = collect2.stream().filter(x -> this.orderInvalidStatus(x.getStatus())).collect(Collectors.toCollection(ArrayList::new));
                    expiredFZ.setCount(Integer.valueOf(admExpiredList.size()));
                    undoneFZ.setCount(Integer.valueOf(admUndoneList.size()));
                    completedFZ.setCount(Integer.valueOf(admCompleteList.size()));
                    newOrderFZ.setCount(Integer.valueOf(collect2.size()));
                    completedAmountFZ.setOrderMoney(decimalFormat.format(admCompleteList.stream().filter(x -> x.getOwnCost() != null).map(x -> new BigDecimal(x.getOwnCost())).reduce(BigDecimal.ZERO, BigDecimal::add)));
                    refunAmountFZ.setOrderMoney(decimalFormat.format(admExpiredList.stream().filter(x -> x.getOwnCost() != null).map(x -> new BigDecimal(x.getOwnCost())).reduce(BigDecimal.ZERO, BigDecimal::add)));
                    newAmountFZ.setOrderMoney(decimalFormat.format(collect2.stream().filter(x -> x.getOwnCost() != null).map(x -> new BigDecimal(x.getOwnCost())).reduce(BigDecimal.ZERO, BigDecimal::add)));
                    admissionFzListCreateTime = collect2.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<OrderCountForMangVo>(Comparator.comparing(OrderCountForMangVo::getPatientId))), ArrayList::new));
                    newPatientFZ.setCount(Integer.valueOf(admissionFzListCreateTime.size()));
                    exportOrderForFZ.setNewOrder(newOrderFZ.getCount());
                    exportOrderForFZ.setCompleted(completedFZ.getCount());
                    exportOrderForFZ.setUndone(undoneFZ.getCount());
                    exportOrderForFZ.setExpired(expiredFZ.getCount());
                    exportOrderForFZ.setNewPatient(newPatientFZ.getCount());
                    exportOrderForFZ.setNewMount(Double.valueOf(BigDecimal.valueOf(Double.parseDouble(newAmountFZ.getOrderMoney())).setScale(2, 4).doubleValue()));
                    exportOrderForFZ.setCompletedAmount(Double.valueOf(BigDecimal.valueOf(Double.parseDouble(completedAmountFZ.getOrderMoney())).setScale(2, 4).doubleValue()));
                    exportOrderForFZ.setRefunAmount(Double.valueOf(BigDecimal.valueOf(Double.parseDouble(refunAmountFZ.getOrderMoney())).setScale(2, 4).doubleValue()));
                    exportOrderFzResVoList.add(exportOrderForFZ);
                }
                List collect2 = exportOrderFzResVoList.stream().filter(x -> x.getCreateTime() != null && x.getCreateTime() != "").collect(Collectors.toList());
                exportOrderResDto.setExportOrderFzResVoList(collect2.stream().sorted(Comparator.comparing(d -> DateUtils.stringToSimpleDate((String)d.getCreateTime()))).collect(Collectors.toList()));
                orderInfoList.add(exportOrderResDto);
                exportOrderDocResDto.setList(orderInfoList);
                exportOrderDocResDto.setName(s);
                exportOrderDocResDtos.add(exportOrderDocResDto);
            }
        }
        return exportOrderDocResDtos;
    }

    private boolean orderInvalidStatus(Integer status) {
        return AdmissionStatusEnum.REFUNDED_REFUSE.getValue().equals(status) || AdmissionStatusEnum.NOT_RECEIVED_TIME_OUT.getValue().equals(status) || AdmissionStatusEnum.REFUNDED_APPLY.getValue().equals(status) || AdmissionStatusEnum.RETIRED.getValue().equals(status) || AdmissionStatusEnum.TO_BE_RECEIVED_REFUND.getValue().equals(status) || AdmissionStatusEnum.DOCTOR_CLOSED_SCHEDULE.getValue().equals(status) || AdmissionStatusEnum.DOCTOR_CLOSED_WATING_SCHEDULE.getValue().equals(status) || AdmissionStatusEnum.PASSNUMBER_REFUND.getValue().equals(status) || AdmissionStatusEnum.PASSNUMBER_REFUND_ZERO.getValue().equals(status) || AdmissionStatusEnum.CANCEL.getValue().equals(status) || AdmissionStatusEnum.EXPIRED.getValue().equals(status) || AdmissionStatusEnum.REFUNDED_REFUSE_ZERO.getValue().equals(status) || AdmissionStatusEnum.ADMIN_REFUNDED.getValue().equals(status) || AdmissionStatusEnum.ADMIN_REFUNDED_ADMISSION.getValue().equals(status);
    }

    private ExportOrderResDto getOrderListRateDocZX(OrderListForCountReqVo orderListForCountReqVo) {
        ExportOrderResDto exportOrderResDto = new ExportOrderResDto();
        OrderListForCountResVo newPatientZX = new OrderListForCountResVo();
        OrderListForCountResVo completedZX = new OrderListForCountResVo();
        OrderListForCountResVo expiredZX = new OrderListForCountResVo();
        OrderListForCountResVo undoneZX = new OrderListForCountResVo();
        OrderListForCountResVo newOrderZX = new OrderListForCountResVo();
        OrderListForCountResVo newAmountZX = new OrderListForCountResVo();
        OrderListForCountResVo completedAmountZX = new OrderListForCountResVo();
        OrderListForCountResVo refunAmountZX = new OrderListForCountResVo();
        expiredZX.setStartTime(orderListForCountReqVo.getStartTime());
        expiredZX.setEndTime(orderListForCountReqVo.getEndTime());
        expiredZX.setServType(ServiceTypeEnum.HOS.getValue());
        expiredZX.setOrderStatus(ImmediateConsultationVoTypeEnum.TYPE_RETURN.getValue());
        expiredZX.setUnit(WhetherEnum.ALLOW.getValue());
        undoneZX.setStartTime(orderListForCountReqVo.getStartTime());
        undoneZX.setEndTime(orderListForCountReqVo.getEndTime());
        undoneZX.setServType(ServiceTypeEnum.HOS.getValue());
        undoneZX.setOrderStatus(ImmediateConsultationVoTypeEnum.IN_CONSULTATION.getValue());
        undoneZX.setUnit(WhetherEnum.ALLOW.getValue());
        completedZX.setStartTime(orderListForCountReqVo.getStartTime());
        completedZX.setEndTime(orderListForCountReqVo.getEndTime());
        completedZX.setServType(ServiceTypeEnum.HOS.getValue());
        completedZX.setOrderStatus(ImmediateConsultationVoTypeEnum.TOPAY.getValue());
        completedZX.setUnit(WhetherEnum.ALLOW.getValue());
        newOrderZX.setStartTime(orderListForCountReqVo.getStartTime());
        newOrderZX.setEndTime(orderListForCountReqVo.getEndTime());
        newOrderZX.setServType(ServiceTypeEnum.HOS.getValue());
        newOrderZX.setOrderStatus(ImmediateConsultationVoTypeEnum.OK.getValue());
        newOrderZX.setUnit(WhetherEnum.ALLOW.getValue());
        newPatientZX.setStartTime(orderListForCountReqVo.getStartTime());
        newPatientZX.setEndTime(orderListForCountReqVo.getEndTime());
        newPatientZX.setServType(ServiceTypeEnum.HOS.getValue());
        newPatientZX.setOrderStatus(ImmediateConsultationVoTypeEnum.WAIT_ADMISSION.getValue());
        newPatientZX.setUnit(WhetherEnum.FORBID.getValue());
        newAmountZX.setStartTime(orderListForCountReqVo.getStartTime());
        newAmountZX.setEndTime(orderListForCountReqVo.getEndTime());
        newAmountZX.setServType(ServiceTypeEnum.HOS.getValue());
        newAmountZX.setOrderStatus(ImmediateConsultationVoTypeEnum.NEW_MOUNT.getValue());
        newAmountZX.setUnit(WhetherEnum.ALLOW.getValue());
        completedAmountZX.setStartTime(orderListForCountReqVo.getStartTime());
        completedAmountZX.setEndTime(orderListForCountReqVo.getEndTime());
        completedAmountZX.setServType(ServiceTypeEnum.HOS.getValue());
        completedAmountZX.setOrderStatus(ImmediateConsultationVoTypeEnum.COMPLETED_AMOUNT.getValue());
        completedAmountZX.setUnit(WhetherEnum.ALLOW.getValue());
        refunAmountZX.setStartTime(orderListForCountReqVo.getStartTime());
        refunAmountZX.setEndTime(orderListForCountReqVo.getEndTime());
        refunAmountZX.setServType(ServiceTypeEnum.HOS.getValue());
        refunAmountZX.setOrderStatus(ImmediateConsultationVoTypeEnum.REFUN_AMOUNT.getValue());
        refunAmountZX.setUnit(WhetherEnum.ALLOW.getValue());
        if (StringUtils.isEmpty((String)orderListForCountReqVo.getStartTime()) || StringUtils.isEmpty((String)orderListForCountReqVo.getEndTime())) {
            String currentDateStr = DateUtils.getCurrentDateSimpleToString();
            String yestarDayStr = DateUtils.getYestarDayToString((String)currentDateStr);
            orderListForCountReqVo.setStartTime(yestarDayStr);
            orderListForCountReqVo.setEndTime(yestarDayStr);
        }
        orderListForCountReqVo.setStartTime(orderListForCountReqVo.getStartTime() + " 00:00:00");
        orderListForCountReqVo.setEndTime(orderListForCountReqVo.getEndTime() + " 23:59:59");
        orderListForCountReqVo.setServType(ServiceTypeEnum.HOS.getValue());
        log.info("\u54a8\u8be2\u5165\u53c2{}", (Object)orderListForCountReqVo.toString());
        List admissionZxList = this.orderMapper.selectOrderDocCount(orderListForCountReqVo);
        log.info("\u54a8\u8be2\u66f4\u65b0\u65f6\u95f4\u6570\u636e{}", (Object)JSON.toJSONString((Object)admissionZxList));
        List admissionZxListCreateTime = this.orderMapper.selectOrderCountByCreateTime(orderListForCountReqVo);
        log.info("\u54a8\u8be2\u521b\u5efa\u65f6\u95f4\u6570\u636e{}", (Object)JSON.toJSONString((Object)admissionZxListCreateTime));
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        if (CollectionUtils.isEmpty((Collection)admissionZxListCreateTime) && CollectionUtils.isEmpty((Collection)admissionZxList)) {
            expiredZX.setCount(Integer.valueOf(0));
            undoneZX.setCount(Integer.valueOf(0));
            completedZX.setCount(Integer.valueOf(0));
            newOrderZX.setCount(Integer.valueOf(0));
            newPatientZX.setCount(Integer.valueOf(0));
            newAmountZX.setOrderMoney(decimalFormat.format(0.0));
            completedAmountZX.setOrderMoney(decimalFormat.format(0.0));
            refunAmountZX.setOrderMoney(decimalFormat.format(0.0));
        } else {
            Map<String, List<OrderCountForMangVo>> collect = admissionZxListCreateTime.stream().collect(Collectors.groupingBy(x -> DateUtils.dateToSimpleString((Date)x.getCreateTime())));
            ArrayList<ExportOrderZxResVo> exportOrderZxResVoList = new ArrayList<ExportOrderZxResVo>();
            for (String s : collect.keySet()) {
                ExportOrderZxResVo exportOrderForZX = new ExportOrderZxResVo();
                List<OrderCountForMangVo> orderCountForMangVos = collect.get(s);
                exportOrderForZX.setCreateTime(s);
                ArrayList admUndoneList = orderCountForMangVos.stream().filter(x -> AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(x.getStatus()) || AdmissionStatusEnum.WAIT_ADMISSION.getValue().equals(x.getStatus()) || AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(x.getStatus())).collect(Collectors.toCollection(ArrayList::new));
                ArrayList admCompleteList = orderCountForMangVos.stream().filter(x -> AdmissionStatusEnum.FINISH_APPLY.getValue().equals(x.getStatus()) || AdmissionStatusEnum.FINISH_TIME_OUT.getValue().equals(x.getStatus()) || AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue().equals(x.getStatus())).collect(Collectors.toCollection(ArrayList::new));
                ArrayList admExpiredList = admissionZxList.stream().filter(x -> DateUtils.dateToSimpleString((Date)x.getCreateTime()).equals(s)).collect(Collectors.toList()).stream().filter(x -> this.orderInvalidStatus(x.getStatus())).collect(Collectors.toCollection(ArrayList::new));
                List collect1 = admissionZxList.stream().filter(x -> DateUtils.dateToSimpleString((Date)x.getCreateTime()).equals(s)).collect(Collectors.toList());
                expiredZX.setCount(Integer.valueOf(admExpiredList.size()));
                undoneZX.setCount(Integer.valueOf(admUndoneList.size()));
                completedZX.setCount(Integer.valueOf(admCompleteList.size()));
                newOrderZX.setCount(Integer.valueOf(collect1.size()));
                completedAmountZX.setOrderMoney(decimalFormat.format(admCompleteList.stream().filter(x -> x.getOwnCost() != null).map(x -> new BigDecimal(x.getOwnCost())).reduce(BigDecimal.ZERO, BigDecimal::add)));
                refunAmountZX.setOrderMoney(decimalFormat.format(admExpiredList.stream().filter(x -> x.getOwnCost() != null).map(x -> new BigDecimal(x.getOwnCost())).reduce(BigDecimal.ZERO, BigDecimal::add)));
                newAmountZX.setOrderMoney(decimalFormat.format(collect1.stream().filter(x -> x.getOwnCost() != null).map(x -> new BigDecimal(x.getOwnCost())).reduce(BigDecimal.ZERO, BigDecimal::add)));
                admissionZxListCreateTime = collect1.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<OrderCountForMangVo>(Comparator.comparing(OrderCountForMangVo::getPatientId))), ArrayList::new));
                newPatientZX.setCount(Integer.valueOf(admissionZxListCreateTime.size()));
                exportOrderForZX.setNewOrder(newOrderZX.getCount());
                exportOrderForZX.setCompleted(completedZX.getCount());
                exportOrderForZX.setUndone(undoneZX.getCount());
                exportOrderForZX.setExpired(expiredZX.getCount());
                exportOrderForZX.setNewPatient(newPatientZX.getCount());
                exportOrderForZX.setNewMount(Double.valueOf(BigDecimal.valueOf(Double.parseDouble(newAmountZX.getOrderMoney())).setScale(2, 4).doubleValue()));
                exportOrderForZX.setCompletedAmount(Double.valueOf(BigDecimal.valueOf(Double.parseDouble(completedAmountZX.getOrderMoney())).setScale(2, 4).doubleValue()));
                exportOrderForZX.setRefunAmount(Double.valueOf(BigDecimal.valueOf(Double.parseDouble(refunAmountZX.getOrderMoney())).setScale(2, 4).doubleValue()));
                exportOrderZxResVoList.add(exportOrderForZX);
            }
            List collect1 = exportOrderZxResVoList.stream().filter(x -> x.getCreateTime() != null && !x.getCreateTime().equals("")).collect(Collectors.toList());
            exportOrderResDto.setExportOrderZxResVoList(collect1.stream().sorted(Comparator.comparing(d -> DateUtils.stringToSimpleDate((String)d.getCreateTime()))).collect(Collectors.toList()));
        }
        return exportOrderResDto;
    }

    private ExportOrderResDto getOrderListDocRateFZ(OrderListForCountReqVo orderListForCountReqVo) {
        ExportOrderResDto exportOrderResDto = new ExportOrderResDto();
        orderListForCountReqVo.setStartTime(StringUtils.substring((String)orderListForCountReqVo.getStartTime(), (int)0, (int)10));
        orderListForCountReqVo.setEndTime(StringUtils.substring((String)orderListForCountReqVo.getEndTime(), (int)0, (int)10));
        OrderListForCountResVo undoneFZ = new OrderListForCountResVo();
        OrderListForCountResVo newOrderFZ = new OrderListForCountResVo();
        OrderListForCountResVo expiredFZ = new OrderListForCountResVo();
        OrderListForCountResVo completedFZ = new OrderListForCountResVo();
        OrderListForCountResVo newPatientFZ = new OrderListForCountResVo();
        OrderListForCountResVo newAmountFZ = new OrderListForCountResVo();
        OrderListForCountResVo completedAmountFZ = new OrderListForCountResVo();
        OrderListForCountResVo refunAmountFZ = new OrderListForCountResVo();
        expiredFZ.setStartTime(orderListForCountReqVo.getStartTime());
        expiredFZ.setEndTime(orderListForCountReqVo.getEndTime());
        expiredFZ.setServType(ServiceTypeEnum.NOS.getValue());
        expiredFZ.setOrderStatus(ImmediateConsultationVoTypeEnum.TYPE_RETURN.getValue());
        expiredFZ.setUnit(WhetherEnum.ALLOW.getValue());
        undoneFZ.setStartTime(orderListForCountReqVo.getStartTime());
        undoneFZ.setEndTime(orderListForCountReqVo.getEndTime());
        undoneFZ.setServType(ServiceTypeEnum.NOS.getValue());
        undoneFZ.setOrderStatus(ImmediateConsultationVoTypeEnum.IN_CONSULTATION.getValue());
        undoneFZ.setUnit(WhetherEnum.ALLOW.getValue());
        completedFZ.setStartTime(orderListForCountReqVo.getStartTime());
        completedFZ.setEndTime(orderListForCountReqVo.getEndTime());
        completedFZ.setServType(ServiceTypeEnum.NOS.getValue());
        completedFZ.setOrderStatus(ImmediateConsultationVoTypeEnum.TOPAY.getValue());
        completedFZ.setUnit(WhetherEnum.ALLOW.getValue());
        newOrderFZ.setStartTime(orderListForCountReqVo.getStartTime());
        newOrderFZ.setEndTime(orderListForCountReqVo.getEndTime());
        newOrderFZ.setServType(ServiceTypeEnum.NOS.getValue());
        newOrderFZ.setOrderStatus(ImmediateConsultationVoTypeEnum.OK.getValue());
        newOrderFZ.setUnit(WhetherEnum.ALLOW.getValue());
        newPatientFZ.setStartTime(orderListForCountReqVo.getStartTime());
        newPatientFZ.setEndTime(orderListForCountReqVo.getEndTime());
        newPatientFZ.setServType(ServiceTypeEnum.NOS.getValue());
        newPatientFZ.setOrderStatus(ImmediateConsultationVoTypeEnum.WAIT_ADMISSION.getValue());
        newPatientFZ.setUnit(WhetherEnum.FORBID.getValue());
        newAmountFZ.setStartTime(orderListForCountReqVo.getStartTime());
        newAmountFZ.setEndTime(orderListForCountReqVo.getEndTime());
        newAmountFZ.setServType(ServiceTypeEnum.NOS.getValue());
        newAmountFZ.setOrderStatus(ImmediateConsultationVoTypeEnum.NEW_MOUNT.getValue());
        newAmountFZ.setUnit(WhetherEnum.ALLOW.getValue());
        completedAmountFZ.setStartTime(orderListForCountReqVo.getStartTime());
        completedAmountFZ.setEndTime(orderListForCountReqVo.getEndTime());
        completedAmountFZ.setServType(ServiceTypeEnum.NOS.getValue());
        completedAmountFZ.setOrderStatus(ImmediateConsultationVoTypeEnum.COMPLETED_AMOUNT.getValue());
        completedAmountFZ.setUnit(WhetherEnum.ALLOW.getValue());
        refunAmountFZ.setStartTime(orderListForCountReqVo.getStartTime());
        refunAmountFZ.setEndTime(orderListForCountReqVo.getEndTime());
        refunAmountFZ.setServType(ServiceTypeEnum.NOS.getValue());
        refunAmountFZ.setOrderStatus(ImmediateConsultationVoTypeEnum.REFUN_AMOUNT.getValue());
        refunAmountFZ.setUnit(WhetherEnum.ALLOW.getValue());
        if (StringUtils.isEmpty((String)orderListForCountReqVo.getStartTime()) || StringUtils.isEmpty((String)orderListForCountReqVo.getEndTime())) {
            String currentDateStr = DateUtils.getCurrentDateSimpleToString();
            String yestarDayStr = DateUtils.getYestarDayToString((String)currentDateStr);
            orderListForCountReqVo.setStartTime(yestarDayStr);
            orderListForCountReqVo.setEndTime(yestarDayStr);
        }
        orderListForCountReqVo.setStartTime(orderListForCountReqVo.getStartTime() + " 00:00:00");
        orderListForCountReqVo.setEndTime(orderListForCountReqVo.getEndTime() + " 23:59:59");
        orderListForCountReqVo.setServType(ServiceTypeEnum.NOS.getValue());
        log.info("\u590d\u8bca\u5165\u53c2{}", (Object)orderListForCountReqVo.toString());
        List admissionFzList = this.orderMapper.selectOrderDocCount(orderListForCountReqVo);
        log.info("\u590d\u8bca\u66f4\u65b0\u65f6\u95f4\u6570\u636e{}", (Object)JSON.toJSONString((Object)admissionFzList));
        List admissionFzListCreateTime = this.orderMapper.selectOrderCountByCreateTime(orderListForCountReqVo);
        log.info("\u590d\u8bca\u521b\u5efa\u65f6\u95f4\u6570\u636e{}", (Object)JSON.toJSONString((Object)admissionFzListCreateTime));
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        if (CollectionUtils.isEmpty((Collection)admissionFzListCreateTime) && CollectionUtils.isEmpty((Collection)admissionFzList)) {
            expiredFZ.setCount(Integer.valueOf(0));
            undoneFZ.setCount(Integer.valueOf(0));
            completedFZ.setCount(Integer.valueOf(0));
            newOrderFZ.setCount(Integer.valueOf(0));
            newPatientFZ.setCount(Integer.valueOf(0));
            newAmountFZ.setOrderMoney(decimalFormat.format(0.0));
            completedAmountFZ.setOrderMoney(decimalFormat.format(0.0));
            refunAmountFZ.setOrderMoney(decimalFormat.format(0.0));
        } else {
            Map<String, List<OrderCountForMangVo>> collect = admissionFzListCreateTime.stream().collect(Collectors.groupingBy(x -> DateUtils.dateToSimpleString((Date)x.getCreateTime())));
            ArrayList<ExportOrderFzResVo> exportOrderFzResVoList = new ArrayList<ExportOrderFzResVo>();
            for (String s : collect.keySet()) {
                ExportOrderFzResVo exportOrderForFZ = new ExportOrderFzResVo();
                List<OrderCountForMangVo> orderCountForMangVos = collect.get(s);
                exportOrderForFZ.setCreateTime(s);
                ArrayList admUndoneList = orderCountForMangVos.stream().filter(x -> s.equals(DateUtils.dateToSimpleString((Date)x.getCreateTime())) && AdmissionStatusEnum.TO_BE_RECEIVED.getValue().equals(x.getStatus()) || AdmissionStatusEnum.WAIT_ADMISSION.getValue().equals(x.getStatus()) || AdmissionStatusEnum.IN_CONSULTATION.getValue().equals(x.getStatus())).collect(Collectors.toCollection(ArrayList::new));
                ArrayList admCompleteList = orderCountForMangVos.stream().filter(x -> s.equals(DateUtils.dateToSimpleString((Date)x.getCreateTime())) && AdmissionStatusEnum.FINISH_APPLY.getValue().equals(x.getStatus()) || AdmissionStatusEnum.FINISH_TIME_OUT.getValue().equals(x.getStatus()) || AdmissionStatusEnum.FINISH_APPLY_REVIEWED.getValue().equals(x.getStatus())).collect(Collectors.toCollection(ArrayList::new));
                ArrayList admExpiredList = admissionFzList.stream().filter(x -> DateUtils.dateToSimpleString((Date)x.getCreateTime()).equals(s)).collect(Collectors.toList()).stream().filter(x -> this.orderInvalidStatus(x.getStatus())).collect(Collectors.toCollection(ArrayList::new));
                List collect1 = admissionFzList.stream().filter(x -> DateUtils.dateToSimpleString((Date)x.getCreateTime()).equals(s)).collect(Collectors.toList());
                expiredFZ.setCount(Integer.valueOf(admExpiredList.size()));
                undoneFZ.setCount(Integer.valueOf(admUndoneList.size()));
                completedFZ.setCount(Integer.valueOf(admCompleteList.size()));
                newOrderFZ.setCount(Integer.valueOf(collect1.size()));
                completedAmountFZ.setOrderMoney(decimalFormat.format(admCompleteList.stream().filter(x -> x.getOwnCost() != null).map(x -> new BigDecimal(x.getOwnCost())).reduce(BigDecimal.ZERO, BigDecimal::add)));
                refunAmountFZ.setOrderMoney(decimalFormat.format(admExpiredList.stream().filter(x -> x.getOwnCost() != null).map(x -> new BigDecimal(x.getOwnCost())).reduce(BigDecimal.ZERO, BigDecimal::add)));
                newAmountFZ.setOrderMoney(decimalFormat.format(collect1.stream().filter(x -> x.getOwnCost() != null).map(x -> new BigDecimal(x.getOwnCost())).reduce(BigDecimal.ZERO, BigDecimal::add)));
                admissionFzListCreateTime = collect1.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<OrderCountForMangVo>(Comparator.comparing(OrderCountForMangVo::getPatientId))), ArrayList::new));
                newPatientFZ.setCount(Integer.valueOf(admissionFzListCreateTime.size()));
                exportOrderForFZ.setNewOrder(newOrderFZ.getCount());
                exportOrderForFZ.setCompleted(completedFZ.getCount());
                exportOrderForFZ.setUndone(undoneFZ.getCount());
                exportOrderForFZ.setExpired(expiredFZ.getCount());
                exportOrderForFZ.setNewPatient(newPatientFZ.getCount());
                exportOrderForFZ.setNewMount(Double.valueOf(BigDecimal.valueOf(Double.parseDouble(newAmountFZ.getOrderMoney())).setScale(2, 4).doubleValue()));
                exportOrderForFZ.setCompletedAmount(Double.valueOf(BigDecimal.valueOf(Double.parseDouble(completedAmountFZ.getOrderMoney())).setScale(2, 4).doubleValue()));
                exportOrderForFZ.setRefunAmount(Double.valueOf(BigDecimal.valueOf(Double.parseDouble(refunAmountFZ.getOrderMoney())).setScale(2, 4).doubleValue()));
                exportOrderFzResVoList.add(exportOrderForFZ);
            }
            List collect1 = exportOrderFzResVoList.stream().filter(x -> x.getCreateTime() != null && x.getCreateTime() != "").collect(Collectors.toList());
            exportOrderResDto.setExportOrderFzResVoList(collect1.stream().sorted(Comparator.comparing(d -> DateUtils.stringToSimpleDate((String)d.getCreateTime()))).collect(Collectors.toList()));
        }
        return exportOrderResDto;
    }

    public BaseResponse<ReceptionCompletionVO> receptionAndCompletionRate(OrderListForCountReqVo orderChartReqVo) {
        BaseResponse receptionAndCompletionRateDay = null;
        if ("1".equals(orderChartReqVo.getTimeType())) {
            receptionAndCompletionRateDay = this.getReceptionAndCompletionRateDay(orderChartReqVo);
        } else if ("2".equals(orderChartReqVo.getTimeType())) {
            receptionAndCompletionRateDay = this.getReceptionAndCompletionRateWeek(orderChartReqVo);
        } else if ("3".equals(orderChartReqVo.getTimeType())) {
            receptionAndCompletionRateDay = this.getReceptionAndCompletionRateMonth(orderChartReqVo);
        }
        if (Objects.isNull(((ReceptionCompletionVO)receptionAndCompletionRateDay.getData()).getXdata()) || Objects.isNull(((ReceptionCompletionVO)receptionAndCompletionRateDay.getData()).getYdata())) {
            ((ReceptionCompletionVO)receptionAndCompletionRateDay.getData()).setYdata(new ArrayList());
            ((ReceptionCompletionVO)receptionAndCompletionRateDay.getData()).setXdata(new ArrayList());
        }
        return receptionAndCompletionRateDay;
    }

    public BaseResponse<ReceptionCompletionVO> getReceptionAndCompletionRateDay(OrderListForCountReqVo orderChartReqVo) {
        ReceptionCompletionVO receptionCompletionVO = new ReceptionCompletionVO();
        ArrayList<String> xdata = new ArrayList<String>();
        ArrayList<ReceptionCompletionYdataVO> ydata = new ArrayList<ReceptionCompletionYdataVO>();
        ReceptionCompletionYdataVO orderCompletionRateYdataVO = new ReceptionCompletionYdataVO();
        ReceptionCompletionYdataVO OrderListForPercentageYdataVO = new ReceptionCompletionYdataVO();
        ArrayList<Integer> receptionRate = new ArrayList<Integer>();
        ArrayList<Integer> completionRate = new ArrayList<Integer>();
        Date start = null;
        Date end = null;
        try {
            start = DateUtils.strToDate((String)orderChartReqVo.getStartTime(), (String)"yyyy-MM-dd");
            end = DateUtils.strToDate((String)orderChartReqVo.getEndTime(), (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        List dateRange = DateUtils.getDateRange((Date)start, end);
        for (String day : dateRange) {
            orderChartReqVo.setStartTime(day + " 00:00:00");
            orderChartReqVo.setEndTime(day + " 23:59:59");
            orderChartReqVo.setDateType(orderChartReqVo.getDateType());
            OrderListForCountReqVo orderListForCountReqVo = new OrderListForCountReqVo();
            BeanUtils.copyProperties((Object)orderChartReqVo, (Object)orderListForCountReqVo);
            BaseResponse orderCompletionRate = this.calculateCompleteOrderRate(orderListForCountReqVo);
            BaseResponse OrderListForPercentage = this.calculateAdmissionOrderRate(orderListForCountReqVo);
            Integer perFloat = (int)(Float.valueOf(((OrderListForPercentageResVo)orderCompletionRate.getData()).getDataInfo()).floatValue() * 100.0f);
            Integer completFloat = (int)(Float.valueOf(((OrderListForPercentageResVo)OrderListForPercentage.getData()).getDataInfo()).floatValue() * 100.0f);
            receptionRate.add(perFloat);
            completionRate.add(completFloat);
            xdata.add(day);
        }
        orderCompletionRateYdataVO.setName("\u63a5\u8bca\u7387").setData(completionRate);
        OrderListForPercentageYdataVO.setName("\u5b8c\u6210\u7387").setData(receptionRate);
        ydata.add(orderCompletionRateYdataVO);
        ydata.add(OrderListForPercentageYdataVO);
        receptionCompletionVO.setXdata(xdata).setYdata(ydata);
        return BaseResponse.success((Object)receptionCompletionVO);
    }

    public BaseResponse<ReceptionCompletionVO> getReceptionAndCompletionRateWeek(OrderListForCountReqVo orderChartReqVo) {
        ReceptionCompletionVO receptionCompletionVO = new ReceptionCompletionVO();
        ArrayList<String> xdata = new ArrayList<String>();
        ArrayList<ReceptionCompletionYdataVO> ydata = new ArrayList<ReceptionCompletionYdataVO>();
        ReceptionCompletionYdataVO orderCompletionRateYdataVO = new ReceptionCompletionYdataVO();
        ReceptionCompletionYdataVO OrderListForPercentageYdataVO = new ReceptionCompletionYdataVO();
        ArrayList<Integer> receptionRate = new ArrayList<Integer>();
        ArrayList<Integer> completionRate = new ArrayList<Integer>();
        List betweenWeeks = null;
        try {
            betweenWeeks = DateUtils.getBetweenWeeks((String)orderChartReqVo.getStartTime(), (String)orderChartReqVo.getEndTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (CollectionUtils.isEmpty((Collection)betweenWeeks)) {
            return BaseResponse.success((Object)receptionCompletionVO);
        }
        for (int i = 0; i < betweenWeeks.size(); ++i) {
            String endTime = (String)((Map)betweenWeeks.get(i)).get("week");
            String startTime = (String)((Map)betweenWeeks.get(i)).get("mon");
            orderChartReqVo.setStartTime(startTime);
            orderChartReqVo.setEndTime(endTime);
            orderChartReqVo.setDateType(orderChartReqVo.getDateType());
            OrderListForCountReqVo orderListForCountReqVo = new OrderListForCountReqVo();
            BeanUtils.copyProperties((Object)orderChartReqVo, (Object)orderListForCountReqVo);
            orderListForCountReqVo.setStartTime(orderListForCountReqVo.getStartTime() + " 00:00:00");
            orderListForCountReqVo.setEndTime(orderListForCountReqVo.getEndTime() + " 23:59:59");
            BaseResponse orderCompletionRate = this.calculateCompleteOrderRate(orderListForCountReqVo);
            BaseResponse OrderListForPercentage = this.calculateAdmissionOrderRate(orderListForCountReqVo);
            Integer perFloat = (int)(Float.valueOf(((OrderListForPercentageResVo)orderCompletionRate.getData()).getDataInfo()).floatValue() * 100.0f);
            Integer completFloat = (int)(Float.valueOf(((OrderListForPercentageResVo)OrderListForPercentage.getData()).getDataInfo()).floatValue() * 100.0f);
            receptionRate.add(perFloat);
            completionRate.add(completFloat);
            xdata.add(startTime + "~" + endTime);
        }
        orderCompletionRateYdataVO.setName("\u63a5\u8bca\u7387").setData(completionRate);
        OrderListForPercentageYdataVO.setName("\u5b8c\u6210\u7387").setData(receptionRate);
        ydata.add(orderCompletionRateYdataVO);
        ydata.add(OrderListForPercentageYdataVO);
        receptionCompletionVO.setXdata(xdata).setYdata(ydata);
        return BaseResponse.success((Object)receptionCompletionVO);
    }

    public BaseResponse<ReceptionCompletionVO> getReceptionAndCompletionRateMonth(OrderListForCountReqVo orderChartReqVo) {
        ReceptionCompletionVO receptionCompletionVO = new ReceptionCompletionVO();
        ArrayList<String> xdata = new ArrayList<String>();
        ArrayList<ReceptionCompletionYdataVO> ydata = new ArrayList<ReceptionCompletionYdataVO>();
        ReceptionCompletionYdataVO orderCompletionRateYdataVO = new ReceptionCompletionYdataVO();
        ReceptionCompletionYdataVO OrderListForPercentageYdataVO = new ReceptionCompletionYdataVO();
        ArrayList<Integer> receptionRate = new ArrayList<Integer>();
        ArrayList<Integer> completionRate = new ArrayList<Integer>();
        List months = DateUtils.getMonth((String)orderChartReqVo.getStartTime(), (String)orderChartReqVo.getEndTime());
        if (CollectionUtils.isEmpty((Collection)months)) {
            return BaseResponse.success((Object)receptionCompletionVO);
        }
        for (Integer month : months) {
            String endTime = DateUtils.getLastDayOfMonth((String)(orderChartReqVo.getEndTime().substring(0, 5) + month));
            String startTime = new StringBuffer(endTime).replace(8, 10, "01").toString();
            OrderListForCountReqVo orderListForCountReqVo = new OrderListForCountReqVo();
            BeanUtils.copyProperties((Object)orderChartReqVo, (Object)orderListForCountReqVo);
            orderListForCountReqVo.setStartTime(startTime);
            orderListForCountReqVo.setEndTime(endTime);
            orderChartReqVo.setDateType(orderChartReqVo.getDateType());
            orderListForCountReqVo.setStartTime(orderListForCountReqVo.getStartTime() + " 00:00:00");
            orderListForCountReqVo.setEndTime(orderListForCountReqVo.getEndTime() + " 23:59:59");
            BaseResponse orderCompletionRate = this.calculateCompleteOrderRate(orderListForCountReqVo);
            BaseResponse OrderListForPercentage = this.calculateAdmissionOrderRate(orderListForCountReqVo);
            Integer perFloat = (int)(Float.valueOf(((OrderListForPercentageResVo)orderCompletionRate.getData()).getDataInfo()).floatValue() * 100.0f);
            Integer completFloat = (int)(Float.valueOf(((OrderListForPercentageResVo)OrderListForPercentage.getData()).getDataInfo()).floatValue() * 100.0f);
            receptionRate.add(perFloat);
            completionRate.add(completFloat);
            xdata.add(startTime + "~" + endTime);
        }
        orderCompletionRateYdataVO.setName("\u63a5\u8bca\u7387").setData(completionRate);
        OrderListForPercentageYdataVO.setName("\u5b8c\u6210\u7387").setData(receptionRate);
        ydata.add(orderCompletionRateYdataVO);
        ydata.add(OrderListForPercentageYdataVO);
        receptionCompletionVO.setXdata(xdata).setYdata(ydata);
        return BaseResponse.success((Object)receptionCompletionVO);
    }

    public BaseResponse<String> saveDrugRecord(DrugOrderCartDto drugOrderCartDto) {
        log.info("\u8bf7\u6c42\u533b\u836f\u4e91\u6dfb\u52a0\u836f\u54c1\u5230\u8d2d\u7269\u8f66\u63a5\u53e3\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)drugOrderCartDto));
        try {
            log.info("URL=======>{},", (Object)this.projProperties.getSaveDrugRecord());
            String result = HttpKit.jsonPost((String)this.projProperties.getSaveDrugRecord(), (String)JSON.toJSONString((Object)drugOrderCartDto));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)result), BaseResponse.class);
            log.info("\u533b\u836f\u4e91\u6dfb\u52a0\u836f\u54c1\u5230\u8d2d\u7269\u8f66\u8fd4\u56de\u503c\u662f:{} ", (Object)baseResponse.toString());
            return baseResponse;
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u533b\u836f\u4e91\u63a5\u53e3\u5931\u8d25{}", (Object)e.getMessage());
            return null;
        }
    }
}

