/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.service.xgReport.impl;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.onlineoutpatient.common.dto.GetReportListsData;
import com.ebaiyihui.onlineoutpatient.common.vo.CheckReportDetailsReq;
import com.ebaiyihui.onlineoutpatient.common.vo.CheckReportDetailsRes;
import com.ebaiyihui.onlineoutpatient.common.vo.GetReportListsReq;
import com.ebaiyihui.onlineoutpatient.common.vo.GetReportListsRes;
import com.ebaiyihui.onlineoutpatient.common.vo.LisReportListReq;
import com.ebaiyihui.onlineoutpatient.common.vo.LisReportListRes;
import com.ebaiyihui.onlineoutpatient.common.vo.LisReportListResData;
import com.ebaiyihui.onlineoutpatient.common.vo.LisReportListResMicData;
import com.ebaiyihui.onlineoutpatient.common.vo.ListReportHosReq;
import com.ebaiyihui.onlineoutpatient.common.vo.ListReportHosRes;
import com.ebaiyihui.onlineoutpatient.common.vo.NetReportBaseRequest;
import com.ebaiyihui.onlineoutpatient.common.vo.OutpatientPrescriptionDetailsReq;
import com.ebaiyihui.onlineoutpatient.common.vo.OutpatientPrescriptionDetailsRes;
import com.ebaiyihui.onlineoutpatient.common.vo.OutpatientPrescriptionListReq;
import com.ebaiyihui.onlineoutpatient.common.vo.OutpatientPrescriptionListRes;
import com.ebaiyihui.onlineoutpatient.common.vo.PacsReportListReq;
import com.ebaiyihui.onlineoutpatient.common.vo.PacsReportListRes;
import com.ebaiyihui.onlineoutpatient.common.vo.PatientInfoQueryReq;
import com.ebaiyihui.onlineoutpatient.common.vo.PatientInfoQueryRes;
import com.ebaiyihui.onlineoutpatient.common.vo.PrescriptionDetailReq;
import com.ebaiyihui.onlineoutpatient.common.vo.PrescriptionDetailRes;
import com.ebaiyihui.onlineoutpatient.common.vo.PrescriptionListReq;
import com.ebaiyihui.onlineoutpatient.common.vo.PrescriptionListRes;
import com.ebaiyihui.onlineoutpatient.common.vo.ReportDetailData;
import com.ebaiyihui.onlineoutpatient.common.vo.ReportDetailMicData;
import com.ebaiyihui.onlineoutpatient.common.vo.ReportDetailReq;
import com.ebaiyihui.onlineoutpatient.common.vo.ReportDetailRes;
import com.ebaiyihui.onlineoutpatient.common.vo.ReportInfo;
import com.ebaiyihui.onlineoutpatient.core.service.xgReport.NetReportService;
import com.ebaiyihui.onlineoutpatient.core.utils.DateUtils;
import com.ebaiyihui.onlineoutpatient.core.utils.GetCardInfoUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.SnowflakeIdWorker;
import com.ebaiyihui.onlineoutpatient.core.utils.gateway.GateWayCommonUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.gateway.RouteEnum;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class NetReportServiceImpl
implements NetReportService {
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private GetCardInfoUtil getCardInfoUtil;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public BaseResponse<ListReportHosRes> queryReportHosList(ListReportHosReq param) {
        GetReportListsReq listReportParam = new GetReportListsReq();
        listReportParam.setCardNo(param.getCardNo());
        listReportParam.setPatientId(param.getPatientId());
        listReportParam.setReportType(param.getReportType());
        listReportParam.setBeginTime(DateUtils.dateToSimpleString((Date)DateUtils.getAddYear((Date)DateUtils.getCurrentDate(), (int)-3)));
        listReportParam.setEndTime(DateUtils.getCurrentDateSimpleToString());
        listReportParam.setQueryType(param.getQueryType());
        GatewayRequest gatewayRequest = this.getGateWayParam((NetReportBaseRequest)param, (Object)listReportParam);
        GatewayResponse response = new GatewayResponse();
        try {
            FrontRequest frontRequest = new FrontRequest();
            frontRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
            frontRequest.setChannel(gatewayRequest.getChannel());
            frontRequest.setChannelName(gatewayRequest.getChannelName());
            frontRequest.setBody(gatewayRequest.getBody());
            FrontResponse frontResponse = new GateWayCommonUtil().requestHis(RouteEnum.REPORT_LISTS.getValue(), frontRequest, GetReportListsRes.class);
            response = new GatewayResponse();
            response = frontResponse.getCode().equals("1") ? GatewayResponse.specialSuccess((Object)frontResponse.getBody(), (String)frontResponse.getTransactionId()) : GatewayResponse.specialError((String)frontResponse.getMessage(), (String)frontResponse.getTransactionId());
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u6c42\u524d\u7f6e\u673a\u5931\u8d25{}", (Throwable)e);
            return BaseResponse.error((String)"\u8bf7\u6c42\u524d\u7f6e\u673a\u5931\u8d25\uff01");
        }
        GetReportListsRes gateWayData = null;
        if (response != null && response.isSuccess() && response.getData() != null) {
            Object responseData = response.getData();
            if (responseData instanceof GetReportListsRes) {
                gateWayData = (GetReportListsRes)responseData;
            } else if (responseData instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)responseData;
                gateWayData = (GetReportListsRes)jsonObject.toJavaObject(GetReportListsRes.class);
            } else {
                this.logger.error("\u54cd\u5e94\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d: {}", (Object)responseData.getClass().getName());
                return BaseResponse.error((String)"\u54cd\u5e94\u6570\u636e\u683c\u5f0f\u9519\u8bef");
            }
        }
        if (gateWayData == null) {
            return BaseResponse.success();
        }
        List reportDataList = gateWayData.getDatas();
        if (null == reportDataList) {
            this.logger.error("request his gateway error - \u6682\u65e0\u6570\u636e");
            return BaseResponse.success();
        }
        Map<String, List<ReportInfo>> map = reportDataList.stream().map(arg_0 -> this.matchReportData(arg_0)).collect(Collectors.groupingBy(ReportInfo::getReportType));
        ListReportHosRes data = new ListReportHosRes();
        List<ReportInfo> reportInfoList = map.get(param.getReportType());
        if (CollectionUtils.isEmpty(reportInfoList)) {
            reportInfoList = new ArrayList<ReportInfo>();
        }
        for (ReportInfo reportInfo : reportInfoList) {
            if (!StringUtils.isBlank((CharSequence)reportInfo.getReportDate())) continue;
            reportInfo.setReportDate(reportInfo.getReportTime());
        }
        reportInfoList.sort(Comparator.comparing(ReportInfo::getReportDate).reversed());
        data.setReportList(reportInfoList);
        return BaseResponse.success((Object)data);
    }

    public BaseResponse<ReportDetailRes> queryReportDetail(ReportDetailReq param) {
        LisReportListReq lisReportListReq = new LisReportListReq();
        lisReportListReq.setReportNo(param.getReportNo());
        if (param.getReportDate() != null) {
            lisReportListReq.setReportDate(param.getReportDate());
        }
        GatewayRequest gatewayRequest = this.getGateWayParam((NetReportBaseRequest)param, (Object)lisReportListReq);
        GatewayResponse response = new GatewayResponse();
        try {
            FrontRequest frontRequest = new FrontRequest();
            frontRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
            frontRequest.setChannel(gatewayRequest.getChannel());
            frontRequest.setChannelName(gatewayRequest.getChannelName());
            frontRequest.setBody(gatewayRequest.getBody());
            FrontResponse frontResponse = new GateWayCommonUtil().requestHis(RouteEnum.LIS_REPORT_LIST.getValue(), frontRequest, LisReportListRes.class);
            response = new GatewayResponse();
            response = frontResponse.getCode().equals("1") ? GatewayResponse.specialSuccess((Object)frontResponse.getBody(), (String)frontResponse.getTransactionId()) : GatewayResponse.specialError((String)frontResponse.getMessage(), (String)frontResponse.getTransactionId());
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u6c42\u524d\u7f6e\u673a\u5931\u8d25{}", (Throwable)e);
            return BaseResponse.error((String)"\u8bf7\u6c42\u524d\u7f6e\u673a\u5931\u8d25\uff01");
        }
        LisReportListRes gateWayData = null;
        if (response != null && response.isSuccess() && response.getData() != null) {
            Object responseData = response.getData();
            if (responseData instanceof LisReportListRes) {
                gateWayData = (LisReportListRes)responseData;
            } else if (responseData instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)responseData;
                gateWayData = (LisReportListRes)jsonObject.toJavaObject(LisReportListRes.class);
            } else {
                this.logger.error("LIS\u62a5\u544a\u8be6\u60c5\u54cd\u5e94\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d: {}", (Object)responseData.getClass().getName());
                return BaseResponse.error((String)"\u54cd\u5e94\u6570\u636e\u683c\u5f0f\u9519\u8bef");
            }
        }
        if (null == gateWayData) {
            return BaseResponse.success();
        }
        ReportDetailRes reportDetail = new ReportDetailRes();
        BeanUtils.copyProperties(gateWayData, (Object)reportDetail);
        List lisReportListResDataList = gateWayData.getDatas();
        if (null == lisReportListResDataList) {
            this.logger.error("request his gateway error - \u6682\u65e0\u6570\u636e");
            return BaseResponse.success();
        }
        List reportDetailDataList = lisReportListResDataList.stream().map(arg_0 -> this.matchJyReportDetail(arg_0)).collect(Collectors.toList());
        reportDetail.setDatas(reportDetailDataList);
        try {
            if (StringUtils.isNotEmpty((CharSequence)reportDetail.getPatientDOB())) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                Date birthday = simpleDateFormat.parse(reportDetail.getPatientDOB());
                String age = String.valueOf(DateUtils.getAgeByBirth((Date)birthday));
                reportDetail.setAge(age);
            }
        }
        catch (ParseException e) {
            this.logger.info(e.toString());
            return BaseResponse.error((String)"\u8f6c\u6362\u65f6\u95f4\u5f02\u5e38");
        }
        return BaseResponse.success((Object)reportDetail);
    }

    public BaseResponse<CheckReportDetailsRes> queryCheckReportDetail(CheckReportDetailsReq param) {
        PacsReportListReq pacsReportListReq = new PacsReportListReq();
        pacsReportListReq.setReportNo(param.getReportNo());
        if (param.getPatientId() != null) {
            pacsReportListReq.setPatientId(param.getPatientId());
        }
        if (param.getQueryType() != null) {
            pacsReportListReq.setQueryType(param.getQueryType());
        }
        GatewayRequest gatewayRequest = this.getGateWayParam((NetReportBaseRequest)param, (Object)pacsReportListReq);
        GatewayResponse response = new GatewayResponse();
        try {
            FrontRequest frontRequest = new FrontRequest();
            frontRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
            frontRequest.setChannel(gatewayRequest.getChannel());
            frontRequest.setChannelName(gatewayRequest.getChannelName());
            frontRequest.setBody(gatewayRequest.getBody());
            FrontResponse frontResponse = new GateWayCommonUtil().requestHis(RouteEnum.PACS_REPORT_LIST.getValue(), frontRequest, PacsReportListRes.class);
            response = new GatewayResponse();
            response = frontResponse.getCode().equals("1") ? GatewayResponse.specialSuccess((Object)frontResponse.getBody(), (String)frontResponse.getTransactionId()) : GatewayResponse.specialError((String)frontResponse.getMessage(), (String)frontResponse.getTransactionId());
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u6c42\u524d\u7f6e\u673a\u5931\u8d25{}", (Throwable)e);
            return BaseResponse.error((String)"\u8bf7\u6c42\u524d\u7f6e\u673a\u5931\u8d25\uff01");
        }
        PacsReportListRes gateWayData = null;
        if (response != null && response.isSuccess() && response.getData() != null) {
            Object responseData = response.getData();
            if (responseData instanceof PacsReportListRes) {
                gateWayData = (PacsReportListRes)responseData;
            } else if (responseData instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)responseData;
                gateWayData = (PacsReportListRes)jsonObject.toJavaObject(PacsReportListRes.class);
            } else {
                this.logger.error("PACS\u62a5\u544a\u8be6\u60c5\u54cd\u5e94\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d: {}", (Object)responseData.getClass().getName());
                return BaseResponse.error((String)"\u54cd\u5e94\u6570\u636e\u683c\u5f0f\u9519\u8bef");
            }
        }
        if (null == gateWayData) {
            return BaseResponse.success();
        }
        CheckReportDetailsRes reportDetail = new CheckReportDetailsRes();
        BeanUtils.copyProperties(gateWayData, (Object)reportDetail);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reportDetail.getAge()})) {
            reportDetail.setAge(reportDetail.getAge().replace("\u5c81", ""));
        }
        reportDetail.setCheckImages(gateWayData.getCheckImages());
        return BaseResponse.success((Object)reportDetail);
    }

    public BaseResponse<PrescriptionListRes> queryPrescriptionList(PrescriptionListReq param) {
        OutpatientPrescriptionListReq outpatientPrescriptionListReq = new OutpatientPrescriptionListReq();
        outpatientPrescriptionListReq.setCardNo(param.getCardNo());
        outpatientPrescriptionListReq.setStartDate(param.getStartDate());
        outpatientPrescriptionListReq.setEndDate(param.getEndDate());
        GatewayRequest gatewayRequest = this.getGateWayParam((NetReportBaseRequest)param, (Object)outpatientPrescriptionListReq);
        GatewayResponse response = new GatewayResponse();
        try {
            FrontRequest frontRequest = new FrontRequest();
            frontRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
            frontRequest.setChannel(gatewayRequest.getChannel());
            frontRequest.setChannelName(gatewayRequest.getChannelName());
            frontRequest.setBody(gatewayRequest.getBody());
            FrontResponse frontResponse = new GateWayCommonUtil().requestHis(RouteEnum.OUTPATIENT_PRESCRIPTION_LIST.getValue(), frontRequest, OutpatientPrescriptionListRes.class);
            response = new GatewayResponse();
            response = frontResponse.getCode().equals("1") ? GatewayResponse.specialSuccess((Object)frontResponse.getBody(), (String)frontResponse.getTransactionId()) : GatewayResponse.specialError((String)frontResponse.getMessage(), (String)frontResponse.getTransactionId());
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u6c42\u524d\u7f6e\u673a\u5931\u8d25{}", (Throwable)e);
            return BaseResponse.error((String)"\u8bf7\u6c42\u524d\u7f6e\u673a\u5931\u8d25\uff01");
        }
        OutpatientPrescriptionListRes gateWayData = null;
        if (response != null && response.isSuccess() && response.getData() != null) {
            Object responseData = response.getData();
            if (responseData instanceof OutpatientPrescriptionListRes) {
                gateWayData = (OutpatientPrescriptionListRes)responseData;
            } else if (responseData instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)responseData;
                gateWayData = (OutpatientPrescriptionListRes)jsonObject.toJavaObject(OutpatientPrescriptionListRes.class);
            } else {
                this.logger.error("\u5904\u65b9\u5217\u8868\u54cd\u5e94\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d: {}", (Object)responseData.getClass().getName());
                return BaseResponse.error((String)"\u54cd\u5e94\u6570\u636e\u683c\u5f0f\u9519\u8bef");
            }
        }
        if (gateWayData == null) {
            return BaseResponse.success();
        }
        PrescriptionListRes prescriptionListRes = new PrescriptionListRes();
        prescriptionListRes.setItems(gateWayData.getItems());
        return BaseResponse.success((Object)prescriptionListRes);
    }

    public BaseResponse<PrescriptionDetailRes> queryPrescriptionDetail(PrescriptionDetailReq param) {
        OutpatientPrescriptionDetailsReq outpatientPrescriptionDetailsReq = new OutpatientPrescriptionDetailsReq();
        outpatientPrescriptionDetailsReq.setBillingTime(param.getBillingTime());
        outpatientPrescriptionDetailsReq.setRecipeState(param.getRecipeState());
        outpatientPrescriptionDetailsReq.setVoucherCode(param.getVoucherCode());
        GatewayRequest gatewayRequest = this.getGateWayParam((NetReportBaseRequest)param, (Object)outpatientPrescriptionDetailsReq);
        GatewayResponse response = new GatewayResponse();
        try {
            FrontRequest frontRequest = new FrontRequest();
            frontRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
            frontRequest.setChannel(gatewayRequest.getChannel());
            frontRequest.setChannelName(gatewayRequest.getChannelName());
            frontRequest.setBody(gatewayRequest.getBody());
            FrontResponse frontResponse = new GateWayCommonUtil().requestHis(RouteEnum.OUTPATIENT_PRESCRIPTION_DETAILS.getValue(), frontRequest, OutpatientPrescriptionDetailsRes.class);
            response = new GatewayResponse();
            response = frontResponse.getCode().equals("1") ? GatewayResponse.specialSuccess((Object)frontResponse.getBody(), (String)frontResponse.getTransactionId()) : GatewayResponse.specialError((String)frontResponse.getMessage(), (String)frontResponse.getTransactionId());
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u6c42\u524d\u7f6e\u673a\u5931\u8d25{}", (Throwable)e);
            return BaseResponse.error((String)"\u8bf7\u6c42\u524d\u7f6e\u673a\u5931\u8d25\uff01");
        }
        OutpatientPrescriptionDetailsRes gateWayData = null;
        if (response != null && response.isSuccess() && response.getData() != null) {
            Object responseData = response.getData();
            if (responseData instanceof OutpatientPrescriptionDetailsRes) {
                gateWayData = (OutpatientPrescriptionDetailsRes)responseData;
            } else if (responseData instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)responseData;
                gateWayData = (OutpatientPrescriptionDetailsRes)jsonObject.toJavaObject(OutpatientPrescriptionDetailsRes.class);
            } else {
                this.logger.error("\u5904\u65b9\u8be6\u60c5\u54cd\u5e94\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d: {}", (Object)responseData.getClass().getName());
                return BaseResponse.error((String)"\u54cd\u5e94\u6570\u636e\u683c\u5f0f\u9519\u8bef");
            }
        }
        if (gateWayData == null) {
            return BaseResponse.success();
        }
        PrescriptionDetailRes prescriptionDetailRes = new PrescriptionDetailRes();
        prescriptionDetailRes.setItems(gateWayData.getItems());
        return BaseResponse.success((Object)prescriptionDetailRes);
    }

    public BaseResponse<PatientInfoQueryRes> queryPatientInfo(PatientInfoQueryReq param) {
        PatientInfoQueryReq patientInfoQueryReq = new PatientInfoQueryReq();
        patientInfoQueryReq.setCardNo(param.getCardNo());
        patientInfoQueryReq.setCredNo(param.getCredNo());
        GatewayRequest gatewayRequest = this.getGateWayParam((NetReportBaseRequest)param, (Object)patientInfoQueryReq);
        GatewayResponse response = new GatewayResponse();
        try {
            FrontRequest frontRequest = new FrontRequest();
            frontRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
            frontRequest.setChannel(gatewayRequest.getChannel());
            frontRequest.setChannelName(gatewayRequest.getChannelName());
            frontRequest.setBody(gatewayRequest.getBody());
            FrontResponse frontResponse = new GateWayCommonUtil().requestHis(RouteEnum.QUERY_CARD_INFO.getValue(), frontRequest, PatientInfoQueryRes.class);
            response = new GatewayResponse();
            response = frontResponse.getCode().equals("1") ? GatewayResponse.specialSuccess((Object)frontResponse.getBody(), (String)frontResponse.getTransactionId()) : GatewayResponse.specialError((String)frontResponse.getMessage(), (String)frontResponse.getTransactionId());
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u6c42\u524d\u7f6e\u673a\u5931\u8d25{}", (Throwable)e);
            return BaseResponse.error((String)"\u8bf7\u6c42\u524d\u7f6e\u673a\u5931\u8d25\uff01");
        }
        PatientInfoQueryRes gateWayData = null;
        if (response != null && response.isSuccess() && response.getData() != null) {
            Object responseData = response.getData();
            if (responseData instanceof PatientInfoQueryRes) {
                gateWayData = (PatientInfoQueryRes)responseData;
            } else if (responseData instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)responseData;
                gateWayData = (PatientInfoQueryRes)jsonObject.toJavaObject(PatientInfoQueryRes.class);
            } else {
                this.logger.error("\u60a3\u8005\u4fe1\u606f\u67e5\u8be2\u54cd\u5e94\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d: {}", (Object)responseData.getClass().getName());
                return BaseResponse.error((String)"\u54cd\u5e94\u6570\u636e\u683c\u5f0f\u9519\u8bef");
            }
        }
        if (gateWayData == null) {
            return BaseResponse.success();
        }
        gateWayData.setCardType("1702");
        gateWayData.setCredType("01");
        gateWayData.setPatientNo(gateWayData.getPatientId());
        gateWayData.setPatientId(null);
        return BaseResponse.success((Object)gateWayData);
    }

    private ReportDetailData matchJyReportDetail(LisReportListResData lisReportListResData) {
        ReportDetailData reportDetailData = new ReportDetailData();
        BeanUtils.copyProperties((Object)lisReportListResData, (Object)reportDetailData);
        List micDataList = lisReportListResData.getMicDatas();
        if (micDataList != null) {
            List detailMicDataList = micDataList.stream().map(arg_0 -> this.matchJyReportData(arg_0)).collect(Collectors.toList());
            reportDetailData.setMicDatas(detailMicDataList);
        }
        return reportDetailData;
    }

    private ReportDetailMicData matchJyReportData(LisReportListResMicData lisReportListResMicData) {
        ReportDetailMicData reportDetailMicData = new ReportDetailMicData();
        BeanUtils.copyProperties((Object)lisReportListResMicData, (Object)reportDetailMicData);
        return reportDetailMicData;
    }

    private ReportInfo matchReportData(GetReportListsData hisReportData) {
        ReportInfo reportData = new ReportInfo();
        reportData.setReportNo(hisReportData.getReportNo());
        reportData.setReportName(hisReportData.getReportName());
        reportData.setReportType(hisReportData.getReportType());
        reportData.setReportDate(hisReportData.getReportDate());
        reportData.setReportTime(hisReportData.getReportTime());
        reportData.setTsName(hisReportData.getTsName());
        reportData.setTsCode(hisReportData.getTsCode());
        return reportData;
    }

    private <T> GatewayRequest<T> getGateWayParam(NetReportBaseRequest baseRequest, T body) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setOrganCode(baseRequest.getOrganCode());
        gatewayRequest.setBody(body);
        gatewayRequest.setChannel(baseRequest.getChannel());
        gatewayRequest.setChannelName(baseRequest.getChannelName());
        String transactionId = UUID.randomUUID().toString();
        gatewayRequest.setTransactionId(transactionId);
        this.logger.info("his gateway - transactionId:{}", (Object)transactionId);
        return gatewayRequest;
    }
}

