/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.utils;

import com.ebaiyihui.card.common.CardServiceApi;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetCardInfoUtil {
    private static final Logger log = LoggerFactory.getLogger(GetCardInfoUtil.class);
    @Autowired
    private CardServiceApi cardServiceApi;

    public CardDetailsInfoRespVO getCardDetail(CardDetailsInfoReqVO cardDetailsInfoReqVO) {
        try {
            BaseResponse cardBaseResponse = this.cardServiceApi.getCardDetail(cardDetailsInfoReqVO);
            if (null == cardBaseResponse.getData()) {
                log.error("\u3010\u5361\u7c7b\u578b\u540d\u79f0\u67e5\u8be2\u3011 buildPayItemDatasRespVO -> cardService\u8bf7\u6c42\u6570\u636e\u5f02\u5e38");
                return null;
            }
            CardDetailsInfoRespVO cardDetailsInfoRespVO = (CardDetailsInfoRespVO)cardBaseResponse.getData();
            log.info("\u3010\u5361\u7c7b\u578b\u540d\u79f0\u67e5\u8be2\u3011buildPayItemDatasRespVO -> " + cardDetailsInfoRespVO);
            return cardDetailsInfoRespVO;
        }
        catch (Exception e) {
            log.error("\u3010\u5361\u7c7b\u578b\u540d\u79f0\u67e5\u8be2\u3011buildPayItemDatasRespVO -> cardService\u8bf7\u6c42\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    public CardDetailsInfoRespVO getCardDetailBypaitentId(String patientId) {
        try {
            BaseResponse cardBaseResponse = this.cardServiceApi.findByPatientId(patientId);
            if (null == cardBaseResponse.getData()) {
                log.error("\u3010\u901a\u8fc7paitentId\u83b7\u53d6\u5361\u4fe1\u606f\u3011 findByPatientId -> cardService\u8bf7\u6c42\u65e0\u54cd\u5e94");
                return null;
            }
            CardDetailsInfoRespVO cardDetailsInfoRespVO = (CardDetailsInfoRespVO)cardBaseResponse.getData();
            if (null == cardDetailsInfoRespVO) {
                log.error("\u3010\u901a\u8fc7paitentId\u83b7\u53d6\u5361\u4fe1\u606f\u3011  findByPatientId -> cardService\u8bf7\u6c42\u6570\u636e\u5f02\u5e38");
                return null;
            }
            log.info("\u3010\u901a\u8fc7paitentId\u83b7\u53d6\u5361\u4fe1\u606f\u3011  findByPatientId -> " + cardDetailsInfoRespVO);
            return cardDetailsInfoRespVO;
        }
        catch (Exception e) {
            log.error("\u3010\u901a\u8fc7paitentId\u83b7\u53d6\u5361\u4fe1\u606f\u3011\u8c03\u7528cardService -> cardService\u8bf7\u6c42\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    public CardDetailsInfoRespVO getCardDetailByPMI(String pmi) {
        try {
            CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
            cardDetailsInfoReqVO.setCardNo(pmi);
            BaseResponse cardBaseResponse = this.cardServiceApi.getCardDetailByPmi(cardDetailsInfoReqVO);
            if (null == cardBaseResponse.getData()) {
                log.error("\u3010\u901a\u8fc7paitentId\u83b7\u53d6\u5361\u4fe1\u606f\u3011 getCardDetailByPmi -> cardService\u8bf7\u6c42\u65e0\u54cd\u5e94");
                return null;
            }
            if (((List)cardBaseResponse.getData()).size() == 0) {
                log.error("\u3010\u901a\u8fc7paitentId\u83b7\u53d6\u5361\u4fe1\u606f\u3011  getCardDetailByPmi -> cardService\u8bf7\u6c42\u6570\u636e\u5f02\u5e38");
                return null;
            }
            CardDetailsInfoRespVO cardDetailsInfoRespVO = (CardDetailsInfoRespVO)((List)cardBaseResponse.getData()).get(((List)cardBaseResponse.getData()).size() - 1);
            log.info("\u3010\u901a\u8fc7paitentId\u83b7\u53d6\u5361\u4fe1\u606f\u3011  getCardDetailByPmi -> " + cardDetailsInfoRespVO);
            return cardDetailsInfoRespVO;
        }
        catch (Exception e) {
            log.error("\u3010\u901a\u8fc7paitentId\u83b7\u53d6\u5361\u4fe1\u606f\u3011\u8c03\u7528cardService -> cardService\u8bf7\u6c42\u51fa\u9519", (Throwable)e);
            return null;
        }
    }

    public CardDetailsInfoRespVO getCardDetailById(String cardId) {
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(cardId);
        cardDetailsInfoReqVO.setChannelCode("app");
        CardDetailsInfoRespVO respVO = this.getCardDetail(cardDetailsInfoReqVO);
        return respVO;
    }
}

