/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.utils;

import com.alibaba.fastjson.JSON;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.http.client.ClientProtocolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class HttpKit {
    private static Logger log = LoggerFactory.getLogger(HttpKit.class);
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final int SO_TIMEOUT = 60000;
    private static final int MAX_TOTAL_CONNECTION = 2000;
    private static final int MAX_PER_HOST = 2000;
    private static AsyncHttpClient asyncHttpClient;
    private static final String DEFAULT_CONTENT_TYPE = "application/json";
    private static final String CONTENT_TYPE = "Content-Type";

    public static String get(String url, Map<String, String> params, Map<String, String> headers) throws IOException, ExecutionException, InterruptedException {
        Set<String> keys;
        log.info("url{}", (Object)url);
        AsyncHttpClient.BoundRequestBuilder builder = asyncHttpClient.prepareGet(url);
        builder.setBodyEncoding("UTF-8");
        if (params != null && !params.isEmpty()) {
            keys = params.keySet();
            for (String key : keys) {
                builder.addQueryParam(key, params.get(key));
            }
        }
        if (headers != null && !headers.isEmpty()) {
            keys = headers.keySet();
            for (String key : keys) {
                builder.addHeader(key, params.get(key));
            }
        }
        log.info("\u5f00\u59cb\u8bf7\u6c42\uff0c\u8bf7\u6c42\u5730\u5740:{},\u8bf7\u6c42json\u53c2\u6570:{}", (Object)url);
        ListenableFuture f = builder.execute();
        String body = ((Response)f.get()).getResponseBody("UTF-8");
        log.info("\u8bf7\u6c42\u7ed3\u675f,\u54cd\u5e94\u7ed3\u679c:{}", (Object)body);
        return body;
    }

    public static String get(String url) throws KeyManagementException, NoSuchAlgorithmException, NoSuchProviderException, UnsupportedEncodingException, IOException, ExecutionException, InterruptedException {
        return HttpKit.get((String)url, null);
    }

    public static String get(String url, Map<String, String> params) throws KeyManagementException, NoSuchAlgorithmException, NoSuchProviderException, UnsupportedEncodingException, IOException, ExecutionException, InterruptedException {
        return HttpKit.get((String)url, params, null);
    }

    public static String post(String url, Map<String, String> params) throws IOException, ExecutionException, InterruptedException {
        AsyncHttpClient.BoundRequestBuilder builder = asyncHttpClient.preparePost(url);
        builder.setBodyEncoding("UTF-8");
        if (params != null && !params.isEmpty()) {
            Set<String> keys = params.keySet();
            for (String key : keys) {
                builder.addQueryParam(key, params.get(key));
            }
        }
        ListenableFuture f = builder.execute();
        String body = ((Response)f.get()).getResponseBody("UTF-8");
        return body;
    }

    public static String post(String url, String s) throws IOException, ExecutionException, InterruptedException {
        AsyncHttpClient.BoundRequestBuilder builder = asyncHttpClient.preparePost(url);
        builder.setBodyEncoding("UTF-8");
        builder.setBody(s);
        ListenableFuture f = builder.execute();
        String body = ((Response)f.get()).getResponseBody("UTF-8");
        return body;
    }

    public static String jsonPost(String url, String bodyJsonStr) throws IOException, ExecutionException, InterruptedException {
        AsyncHttpClient.BoundRequestBuilder builder = asyncHttpClient.preparePost(url);
        builder.setHeader("Content-Type", "application/json");
        builder.setBodyEncoding("UTF-8");
        builder.setBody(bodyJsonStr);
        log.info("\u5f00\u59cb\u8bf7\u6c42\uff0c\u8bf7\u6c42\u5730\u5740:{},\u8bf7\u6c42json\u53c2\u6570:{}", (Object)url, (Object)bodyJsonStr);
        ListenableFuture f = builder.execute();
        String body = ((Response)f.get()).getResponseBody("UTF-8");
        log.info("\u8bf7\u6c42\u7ed3\u675f,\u54cd\u5e94\u7ed3\u679c:{}", (Object)body);
        return body;
    }

    public static String jsonPost(String url, String bodyJsonStr, Map<String, String> headerMap) throws IOException, ExecutionException, InterruptedException {
        if (headerMap == null || headerMap.size() == 0) {
            return HttpKit.jsonPost((String)url, (String)bodyJsonStr);
        }
        AsyncHttpClient.BoundRequestBuilder builder = asyncHttpClient.preparePost(url);
        builder.setHeader("Content-Type", "application/json");
        builder.setBodyEncoding("UTF-8");
        builder.setBody(bodyJsonStr);
        headerMap.forEach((key, value) -> builder.setHeader(key, value));
        log.info("builder:{}" + JSON.toJSONString((Object)builder));
        log.info("\u5f00\u59cb\u8bf7\u6c42\uff0c\u8bf7\u6c42\u5730\u5740:{},\u8bf7\u6c42json\u53c2\u6570:{}", (Object)url, (Object)bodyJsonStr);
        ListenableFuture f = builder.execute();
        String body = ((Response)f.get()).getResponseBody("UTF-8");
        log.info("\u8bf7\u6c42\u7ed3\u675f,\u54cd\u5e94\u7ed3\u679c:{}", (Object)body);
        return body;
    }

    public static String doGetHader(String url, String params, Map<String, Object> headers) throws ClientProtocolException, IOException {
        AsyncHttpClient.BoundRequestBuilder builder = asyncHttpClient.prepareGet(url);
        builder.setBodyEncoding("UTF-8");
        builder.setBody(params);
        if (headers != null && !headers.isEmpty()) {
            headers.forEach((key, value) -> builder.setHeader(key, String.valueOf(value)));
        }
        builder.setHeader("Content-Type", "application/json");
        ListenableFuture f = builder.execute();
        String body = null;
        try {
            body = ((Response)f.get()).getResponseBody("UTF-8");
        }
        catch (Exception e) {
            log.error("doGetHader\u8bf7\u6c42 \u53d1\u751f\u5f02\u5e38,url ={},e={}", (Object)url, (Object)e);
        }
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendGet(String url, String param) {
        String result = "";
        BufferedReader in = null;
        try {
            String line;
            String urlNameString = param == null ? url : url + "?" + param;
            URL realUrl = new URL(urlNameString);
            URLConnection connection = realUrl.openConnection();
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.17 (KHTML, like Gecko) Chrome/24.0.1312.56 Safari/537.17");
            connection.connect();
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u53d1\u9001GET\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return result;
    }

    public static String sendGet(String url) {
        return HttpKit.sendGet((String)url, null);
    }

    static {
        AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder();
        builder.setMaxConnections(2000);
        builder.setMaxConnectionsPerHost(2000);
        builder.setRequestTimeout(60000);
        asyncHttpClient = new AsyncHttpClient(builder.build());
    }
}

