/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.utils;

import com.ebaiyihui.onlineoutpatient.core.common.enums.GenderEnum;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class IDCardUtil {
    public static Integer getAge(String idcard) {
        if (idcard == null) {
            return null;
        }
        if (idcard.length() != 18) {
            return null;
        }
        return IDCardUtil.getAgeByBirthDates((String)idcard.substring(6, 14), (String)"yyyyMMdd");
    }

    public static Integer getAgeByBirthDates(String birthDateStr) {
        return IDCardUtil.getAgeByBirthDates((String)birthDateStr, (String)"yyyy-MM-dd");
    }

    public static Integer getAgeByBirthDates(String birthDateStr, String format) {
        Date birthDate;
        if (birthDateStr == null || format == null) {
            return 0;
        }
        try {
            birthDate = new SimpleDateFormat(format).parse(birthDateStr);
        }
        catch (ParseException e) {
            return 0;
        }
        Calendar calendar = Calendar.getInstance();
        if (calendar.before(birthDate)) {
            return 0;
        }
        int yearNow = calendar.get(1);
        int monthNow = calendar.get(2);
        int dayOfMonthNow = calendar.get(5);
        calendar.setTime(birthDate);
        int yearBirth = calendar.get(1);
        int monthBirth = calendar.get(2);
        int dayOfMonthBirth = calendar.get(5);
        int age = yearNow - yearBirth;
        if (monthNow <= monthBirth) {
            if (monthNow == monthBirth) {
                if (dayOfMonthNow < dayOfMonthBirth) {
                    --age;
                }
            } else {
                --age;
            }
        }
        return age;
    }

    public static String getGender(String idcard) {
        if (StringUtils.isBlank((String)idcard)) {
            return null;
        }
        String gender = null;
        char[] number = idcard.toCharArray();
        boolean flag = true;
        int oldLength = 15;
        int newLength = 18;
        if (number.length == oldLength) {
            for (int x = 0; x < number.length; ++x) {
                if (!flag) {
                    return null;
                }
                flag = Character.isDigit(number[x]);
            }
        } else if (number.length == newLength) {
            for (int x = 0; x < number.length - 1; ++x) {
                if (!flag) {
                    return null;
                }
                flag = Character.isDigit(number[x]);
            }
        }
        if (flag && idcard.length() == oldLength) {
            gender = Integer.parseInt(idcard.substring(idcard.length() - 3, idcard.length())) % 2 == 0 ? GenderEnum.FEMALE.getDesc() : GenderEnum.MALE.getDesc();
        } else if (flag && idcard.length() == newLength) {
            gender = Integer.parseInt(idcard.substring(idcard.length() - 4, idcard.length() - 1)) % 2 == 0 ? GenderEnum.FEMALE.getDesc() : GenderEnum.MALE.getDesc();
        }
        return gender;
    }

    public static Integer getGenderForInteger(String idcard) {
        if (StringUtils.isBlank((String)idcard)) {
            return null;
        }
        Integer gender = null;
        char[] number = idcard.toCharArray();
        boolean flag = true;
        int oldLength = 15;
        int newLength = 18;
        if (number.length == oldLength) {
            for (int x = 0; x < number.length; ++x) {
                if (!flag) {
                    return null;
                }
                flag = Character.isDigit(number[x]);
            }
        } else if (number.length == newLength) {
            for (int x = 0; x < number.length - 1; ++x) {
                if (!flag) {
                    return null;
                }
                flag = Character.isDigit(number[x]);
            }
        }
        if (flag && idcard.length() == oldLength) {
            gender = Integer.parseInt(idcard.substring(idcard.length() - 3, idcard.length())) % 2 == 0 ? GenderEnum.FEMALE.getValue() : GenderEnum.MALE.getValue();
        } else if (flag && idcard.length() == newLength) {
            gender = Integer.parseInt(idcard.substring(idcard.length() - 4, idcard.length() - 1)) % 2 == 0 ? GenderEnum.FEMALE.getValue() : GenderEnum.MALE.getValue();
        }
        return gender;
    }

    public static String getBirthByIdCard(String idCard) {
        if (idCard == null) {
            return null;
        }
        if (idCard.length() != 18) {
            return null;
        }
        String year = idCard.substring(6, 10);
        String month = idCard.substring(10, 12);
        String day = idCard.substring(12, 14);
        String birth = year + "-" + month + "-" + day;
        return birth;
    }
}

