/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.onlineoutpatient.core.utils.gateway;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.framework.utils.JsonUtil;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.onlineoutpatient.core.dao.HisBusinessConfigMapper;
import com.ebaiyihui.onlineoutpatient.core.dao.HisBusinessUrlEntityMapper;
import com.ebaiyihui.onlineoutpatient.core.model.HisBusinessConfigEntity;
import com.ebaiyihui.onlineoutpatient.core.model.HisBusinessUrlEntity;
import com.ebaiyihui.onlineoutpatient.core.utils.HttpKit;
import com.ebaiyihui.onlineoutpatient.core.utils.gateway.GateWayCommonUtil;
import com.ebaiyihui.onlineoutpatient.core.utils.id.UUIDUtil;
import java.lang.reflect.Type;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class GateWayCommonUtil<T> {
    private static final Logger log = LoggerFactory.getLogger(GateWayCommonUtil.class);
    @Autowired
    private HisBusinessUrlEntityMapper hisBusinessUrlEntityAutowMapper;
    @Autowired
    private HisBusinessConfigMapper hisBusinessConfigAutowMapper;
    private static HisBusinessUrlEntityMapper hisBusinessUrlEntityMapper;
    private static HisBusinessConfigMapper hisBusinessConfigMapper;

    @PostConstruct
    public void init() {
        hisBusinessUrlEntityMapper = this.hisBusinessUrlEntityAutowMapper;
        hisBusinessConfigMapper = this.hisBusinessConfigAutowMapper;
    }

    public GatewayResponse<T> requestHis(String transactionId, String organCode, String businessCode, GatewayRequest gatewayRequest, Class clazz) {
        GatewayResponse gatewayResponse = new GatewayResponse();
        FrontResponse frontResponse = new FrontResponse();
        try {
            GatewayResponse baseResponse = this.getHisBusinessUrl(transactionId, organCode, businessCode, false);
            if (baseResponse.getCode().equals("0")) {
                return GatewayResponse.specialError((String)baseResponse.getMsg(), (String)transactionId);
            }
            FrontRequest frontRequest = new FrontRequest();
            frontRequest.setTransactionId(transactionId);
            frontRequest.setChannel(gatewayRequest.getChannel());
            frontRequest.setChannelName(gatewayRequest.getChannelName());
            frontRequest.setBody(gatewayRequest.getBody());
            String url = (String)baseResponse.getData();
            String result = "";
            log.info("\u8bf7\u6c42\u524d\u7f6e\u673a\u670d\u52a1\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)frontRequest));
            result = HttpKit.jsonPost((String)url, (String)JSONObject.toJSONString((Object)frontRequest));
            log.info("\u8bf7\u6c42\u524d\u7f6e\u673a\u670d\u52a1\u51fa\u53c2\uff1a" + result);
            1 typeReference = new /* Unavailable Anonymous Inner Class!! */;
            frontResponse = (FrontResponse)JSONObject.parseObject((String)result, (Type)typeReference.getType(), (Feature[])new Feature[0]);
            if (frontResponse.getCode().equals("0")) {
                return GatewayResponse.specialError((String)frontResponse.getMessage(), (String)transactionId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return GatewayResponse.specialError((String)"\u8bf7\u6c42hsi\u524d\u7f6e\u673a\u51fa\u73b0\u5f02\u5e38", (String)transactionId);
        }
        return GatewayResponse.specialSuccess((Object)frontResponse.getBody(), (String)frontResponse.getTransactionId());
    }

    public GatewayResponse<T> requestHis(String transactionId, String organCode, String businessCode, GatewayRequest gatewayRequest) {
        GatewayResponse gatewayResponse = new GatewayResponse();
        FrontResponse frontResponse = new FrontResponse();
        try {
            GatewayResponse baseResponse = this.getHisBusinessUrl(transactionId, organCode, businessCode, false);
            if (baseResponse.getCode().equals("0")) {
                return GatewayResponse.specialError((String)baseResponse.getMsg(), (String)transactionId);
            }
            FrontRequest frontRequest = new FrontRequest();
            frontRequest.setTransactionId(transactionId);
            frontRequest.setChannel(gatewayRequest.getChannel());
            frontRequest.setChannelName(gatewayRequest.getChannelName());
            frontRequest.setBody(gatewayRequest.getBody());
            String url = (String)baseResponse.getData();
            String result = "";
            log.info("\u8bf7\u6c42\u524d\u7f6e\u673a\u670d\u52a1\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)frontRequest));
            result = HttpKit.jsonPost((String)url, (String)JSONObject.toJSONString((Object)frontRequest));
            log.info("\u8bf7\u6c42\u524d\u7f6e\u673a\u670d\u52a1\u51fa\u53c2\uff1a" + result);
            frontResponse = (FrontResponse)JSONObject.parseObject((String)result, FrontResponse.class);
            if (frontResponse.getCode().equals("0")) {
                return GatewayResponse.specialError((String)frontResponse.getMessage(), (String)transactionId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return GatewayResponse.specialError((String)"\u8bf7\u6c42hsi\u524d\u7f6e\u673a\u51fa\u73b0\u5f02\u5e38", (String)transactionId);
        }
        return GatewayResponse.specialSuccess((Object)frontResponse.getBody(), (String)frontResponse.getTransactionId());
    }

    public GatewayResponse<String> getHisBusinessUrl(String transactionId, String organCode, String businessCode, boolean redisOpen) {
        String url = "";
        HisBusinessUrlEntity hisBusinessUrlEntity = (HisBusinessUrlEntity)hisBusinessUrlEntityMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"organ_code", (Object)organCode)).eq((Object)"status", (Object)new Byte("1")));
        if (StringUtils.isEmpty((Object)hisBusinessUrlEntity)) {
            return GatewayResponse.specialError((String)"\u83b7\u53d6\u524d\u7f6e\u673a\u670d\u52a1\u57df\u540d\u5931\u8d25", (String)transactionId);
        }
        HisBusinessConfigEntity hisBusinessConfig = (HisBusinessConfigEntity)hisBusinessConfigMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"organ_code", (Object)organCode)).eq((Object)"business_code", (Object)businessCode));
        if (StringUtils.isEmpty((Object)hisBusinessConfig)) {
            return GatewayResponse.specialError((String)"\u83b7\u53d6\u524d\u7f6e\u673a\u670d\u52a1\u63a5\u53e3\u5730\u5740\u5931\u8d25", (String)transactionId);
        }
        url = hisBusinessUrlEntity.getHisFrontUrl().concat(hisBusinessConfig.getHisConfig());
        return GatewayResponse.specialSuccess((Object)url, (String)transactionId);
    }

    public FrontResponse<T> requestHis(String businessUrl, FrontRequest gatewayRequest, Class clazz) {
        FrontResponse frontResponse = new FrontResponse();
        try {
            String url = "https://ihos.chinachdu.com/yichun-hisfront" + businessUrl;
            String result = "";
            if (null != gatewayRequest) {
                gatewayRequest.setTransactionId(UUIDUtil.getUUID());
                log.info("\u8bf7\u6c42\u524d\u7f6e\u673a\u670d\u52a1\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)gatewayRequest));
                result = HttpKit.jsonPost((String)url, (String)JsonUtil.convertObject((Object)gatewayRequest));
                log.info("\u8bf7\u6c42\u524d\u7f6e\u673a\u670d\u52a1\u51fa\u53c2\uff1a" + result);
            } else {
                result = HttpKit.jsonPost((String)url, null);
            }
            2 typeReference = new /* Unavailable Anonymous Inner Class!! */;
            frontResponse = (FrontResponse)JSONObject.parseObject((String)result, (Type)typeReference.getType(), (Feature[])new Feature[0]);
            return frontResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            return FrontResponse.error((String)"", (String)"", (String)"\u8bf7\u6c42hsi\u524d\u7f6e\u673a\u51fa\u73b0\u5f02\u5e38");
        }
    }
}

