/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.charitable.assistance.server.controller;

import com.ebaiyihui.charitable.assistance.server.common.enums.AssistanceOrderStatus;
import com.ebaiyihui.charitable.assistance.server.service.AssistanceApplyOrderService;
import com.ebaiyihui.charitable.assistance.server.vo.AssistApplyOrderReqVO;
import com.ebaiyihui.charitable.assistance.server.vo.AssistApplyOrderResVO;
import com.ebaiyihui.charitable.assistance.server.vo.AssistApplyOrderSelReqVO;
import com.ebaiyihui.charitable.assistance.server.vo.AssistApplyOrderSelResVO;
import com.ebaiyihui.charitable.assistance.server.vo.EditAssistApplyOrderReqVO;
import com.ebaiyihui.charitable.assistance.server.vo.IdsReqVo;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/assistanceApplyOrder"})
@CrossOrigin(origins={"*"})
public class AssistanceApplyOrderController {
    private static final Logger log = LoggerFactory.getLogger(AssistanceApplyOrderController.class);
    public static final String UTF_8 = "UTF-8";
    @Autowired
    private AssistanceApplyOrderService assistanceApplyOrderService;

    @ApiOperation(value="\u83b7\u53d6\u6148\u5584\u6551\u52a9\u8d44\u6599\u5ba1\u6838\u4fe1\u606f\u5217\u8868")
    @RequestMapping(value={"/getAssistanceApplyOrderList"}, method={RequestMethod.POST})
    public BaseResponse<PageResult<AssistApplyOrderSelResVO>> getAssistanceApplyOrderList(@RequestBody @Validated AssistApplyOrderSelReqVO assistApplyOrderSelReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.assistanceApplyOrderService.getAssistanceApplyOrderList(assistApplyOrderSelReqVO);
    }

    @ApiOperation(value="\u65b0\u589e\u6148\u5584\u6551\u52a9\u7533\u8bf7\u4fe1\u606f")
    @RequestMapping(value={"/saveAssistanceApplyOrder"}, method={RequestMethod.POST})
    public BaseResponse<AssistApplyOrderResVO> saveAssistanceApplyOrder(@RequestBody @Validated AssistApplyOrderReqVO assistApplyOrderReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        AssistApplyOrderResVO assistApplyOrderResVO = null;
        try {
            assistApplyOrderResVO = this.assistanceApplyOrderService.saveAssistanceApplyOrder(assistApplyOrderReqVO);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)assistApplyOrderResVO);
    }

    @ApiOperation(value="\u7f16\u8f91\u6148\u5584\u6551\u52a9\u7533\u8bf7\u4fe1\u606f")
    @RequestMapping(value={"/editAssistanceApplyOrder"}, method={RequestMethod.POST})
    public BaseResponse editAssistanceApplyOrder(@RequestBody @Validated EditAssistApplyOrderReqVO editAssistApplyOrderReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        AssistApplyOrderSelResVO assistApplyOrderSelResVO = null;
        try {
            assistApplyOrderSelResVO = this.assistanceApplyOrderService.getAssistanceApplyOrderById(editAssistApplyOrderReqVO.getId());
            if (Objects.nonNull(assistApplyOrderSelResVO)) {
                if (Objects.nonNull(editAssistApplyOrderReqVO.getUserId()) && Objects.nonNull(editAssistApplyOrderReqVO.getOrderStatus())) {
                    if (editAssistApplyOrderReqVO.getOrderStatus() == AssistanceOrderStatus.CANCEL_STATUS.getValue() && assistApplyOrderSelResVO.getOrderStatus() > AssistanceOrderStatus.WAIT_STATUS.getValue()) {
                        return BaseResponse.error((String)"\u7533\u8bf7\u5355\u5df2\u5728\u5ba1\u6838\u4e2d\uff0c\u4e0d\u80fd\u591f\u53d6\u6d88");
                    }
                    if (assistApplyOrderSelResVO.getOrderStatus() > AssistanceOrderStatus.WAIT_STATUS.getValue()) {
                        return BaseResponse.error((String)"\u4fee\u6539\u5931\u8d25\uff0c\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u4e0d\u662f\u5f85\u5ba1\u6838\u72b6\u6001");
                    }
                }
                if (Objects.nonNull(editAssistApplyOrderReqVO.getAuditFirstUserId()) && Objects.nonNull(editAssistApplyOrderReqVO.getOrderStatus()) && assistApplyOrderSelResVO.getOrderStatus() > AssistanceOrderStatus.WAIT_STATUS.getValue()) {
                    return BaseResponse.error((String)"\u5ba1\u6838\u5931\u8d25\uff0c\u5f53\u524d\u5df2\u7ecf\u6709\u4e00\u7ea7\u5ba1\u6838\u4eba\u5ba1\u6838");
                }
                if (Objects.nonNull(editAssistApplyOrderReqVO.getAuditSecondUserId()) && Objects.nonNull(editAssistApplyOrderReqVO.getOrderStatus()) && assistApplyOrderSelResVO.getOrderStatus() > AssistanceOrderStatus.FINISH_STATUS.getValue()) {
                    return BaseResponse.error((String)"\u5ba1\u6838\u5931\u8d25\uff0c\u5f53\u524d\u5df2\u7ecf\u6709\u4e8c\u7ea7\u5ba1\u6838\u4eba\u5ba1\u6838");
                }
            } else {
                return BaseResponse.error((String)"\u4fee\u6539\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u5f53\u524d\u7533\u8bf7\u8ba2\u5355\u4fe1\u606f");
            }
            this.assistanceApplyOrderService.editAssistanceApplyOrder(editAssistApplyOrderReqVO);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success();
    }

    @ApiOperation(value="\u67e5\u770b\u6148\u5584\u6551\u52a9\u9879\u76ee\u4fe1\u606f\u8be6\u60c5")
    @RequestMapping(value={"/getAssistanceApplyOrderById"}, method={RequestMethod.GET})
    public BaseResponse<AssistApplyOrderSelResVO> getAssistanceApplyOrderById(Integer id) {
        AssistApplyOrderSelResVO assistApplyOrderSelResVO = null;
        try {
            assistApplyOrderSelResVO = this.assistanceApplyOrderService.getAssistanceApplyOrderById(id);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)assistApplyOrderSelResVO);
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u67e5\u770b\u6148\u5584\u6551\u52a9\u9879\u76ee\u4fe1\u606f\u8be6\u60c5")
    @RequestMapping(value={"/getAppletAssistanceApplyOrderById"}, method={RequestMethod.GET})
    public BaseResponse<AssistApplyOrderSelResVO> getAppletAssistanceApplyOrderById(Integer id) {
        AssistApplyOrderSelResVO assistApplyOrderSelResVO = null;
        try {
            assistApplyOrderSelResVO = this.assistanceApplyOrderService.getAppletAssistanceApplyOrderById(id);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)assistApplyOrderSelResVO);
    }

    @ApiOperation(value="\u6148\u5584\u6551\u52a9\u7533\u8bf7\u6279\u91cf\u5bfc\u51faExcel", httpMethod="POST", notes="\u6148\u5584\u6551\u52a9\u7533\u8bf7\u6279\u91cf\u5bfc\u51faExcel")
    @PostMapping(value={"/exportAssistanceApplyOrderExcelByIds"})
    public BaseResponse exportAssistanceApplyOrderExcelByIds(@RequestBody IdsReqVo idsReqVo, HttpServletResponse response) throws IOException {
        this.assistanceApplyOrderService.exportAssistanceApplyOrderExcelByIds(idsReqVo.getIds(), response);
        return null;
    }
}

