/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.charitable.assistance.server.controller;

import com.ebaiyihui.charitable.assistance.server.service.AssistanceInfoService;
import com.ebaiyihui.charitable.assistance.server.vo.AssistInfoIdVO;
import com.ebaiyihui.charitable.assistance.server.vo.AssistInfoReqVO;
import com.ebaiyihui.charitable.assistance.server.vo.AssistInfoSelReqVO;
import com.ebaiyihui.charitable.assistance.server.vo.AssistInfoSelResVO;
import com.ebaiyihui.charitable.assistance.server.vo.EditAssistInfoReqVO;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/assistanceInfo"})
@CrossOrigin(origins={"*"})
public class AssistanceInfoController {
    private static final Logger log = LoggerFactory.getLogger(AssistanceInfoController.class);
    @Autowired
    private AssistanceInfoService assistanceInfoService;

    @ApiOperation(value="\u83b7\u53d6\u6148\u5584\u6551\u52a9\u9879\u76ee\u4fe1\u606f\u5217\u8868")
    @RequestMapping(value={"/getAssistanceInfoList"}, method={RequestMethod.POST})
    public BaseResponse<PageResult<AssistInfoSelResVO>> getAssistanceInfoList(@RequestBody @Validated AssistInfoSelReqVO assistInfoSelReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        return this.assistanceInfoService.getAssistanceInfoList(assistInfoSelReqVO);
    }

    @ApiOperation(value="\u65b0\u589e\u6148\u5584\u6551\u52a9\u9879\u76ee\u4fe1\u606f")
    @RequestMapping(value={"/saveAssistanceInfo"}, method={RequestMethod.POST})
    public BaseResponse<AssistInfoIdVO> saveAssistanceInfo(@RequestBody @Validated AssistInfoReqVO assistInfoReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        AssistInfoIdVO assistInfoIdVO = null;
        try {
            assistInfoIdVO = this.assistanceInfoService.saveAssistanceInfo(assistInfoReqVO);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)assistInfoIdVO);
    }

    @ApiOperation(value="\u7f16\u8f91\u6148\u5584\u6551\u52a9\u9879\u76ee\u4fe1\u606f")
    @RequestMapping(value={"/editAssistanceInfo"}, method={RequestMethod.POST})
    public BaseResponse editAssistanceInfo(@RequestBody @Validated EditAssistInfoReqVO editAssistInfoReqVO, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        try {
            this.assistanceInfoService.editAssistanceInfo(editAssistInfoReqVO);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success();
    }

    @ApiOperation(value="\u67e5\u770b\u6148\u5584\u6551\u52a9\u9879\u76ee\u4fe1\u606f\u8be6\u60c5")
    @RequestMapping(value={"/getAssistanceInfoById"}, method={RequestMethod.GET})
    public BaseResponse<AssistInfoSelResVO> getAssistanceInfoById(Integer id) {
        AssistInfoSelResVO assistInfoSelResVO = null;
        try {
            assistInfoSelResVO = this.assistanceInfoService.getAssistanceInfoById(id);
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)assistInfoSelResVO);
    }
}

