/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.charitable.assistance.server.service.impl;

import com.doctoruser.api.pojo.vo.CheckIdCardReqVO;
import com.ebaiyihui.charitable.assistance.server.common.enums.AssistanceOrderStatus;
import com.ebaiyihui.charitable.assistance.server.common.enums.AssistanceStatus;
import com.ebaiyihui.charitable.assistance.server.common.enums.AssistanceTypeEnum;
import com.ebaiyihui.charitable.assistance.server.common.enums.IdVerifyEnum;
import com.ebaiyihui.charitable.assistance.server.common.enums.ReturnCodeEnum;
import com.ebaiyihui.charitable.assistance.server.entity.AssistanceApplyOrderEntity;
import com.ebaiyihui.charitable.assistance.server.entity.AssistanceOperationLogEntity;
import com.ebaiyihui.charitable.assistance.server.feign.CheckInfoApiClient;
import com.ebaiyihui.charitable.assistance.server.mapper.AssistanceApplyOrderMapper;
import com.ebaiyihui.charitable.assistance.server.service.AssistanceApplyOrderService;
import com.ebaiyihui.charitable.assistance.server.service.AssistanceOperationLogService;
import com.ebaiyihui.charitable.assistance.server.util.CommonUtils;
import com.ebaiyihui.charitable.assistance.server.util.ExcelUtils;
import com.ebaiyihui.charitable.assistance.server.util.SnowflakeIdWorker;
import com.ebaiyihui.charitable.assistance.server.vo.AssistApplyOrderReqVO;
import com.ebaiyihui.charitable.assistance.server.vo.AssistApplyOrderResVO;
import com.ebaiyihui.charitable.assistance.server.vo.AssistApplyOrderSelReqVO;
import com.ebaiyihui.charitable.assistance.server.vo.AssistApplyOrderSelResVO;
import com.ebaiyihui.charitable.assistance.server.vo.EditAssistApplyOrderReqVO;
import com.ebaiyihui.charitable.assistance.server.vo.ExportAssistanceApplyOrderExcel;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AssistanceApplyOrderServiceImpl
implements AssistanceApplyOrderService {
    private static final Logger log = LoggerFactory.getLogger(AssistanceApplyOrderServiceImpl.class);
    @Autowired
    private AssistanceApplyOrderMapper assistanceApplyOrderMapper;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Resource
    private CheckInfoApiClient checkInfoApiClient;
    @Autowired
    private AssistanceOperationLogService assistanceOperationLogService;

    public BaseResponse<PageResult<AssistApplyOrderSelResVO>> getAssistanceApplyOrderList(AssistApplyOrderSelReqVO queryVO) {
        PageResult pageResult = new PageResult(queryVO.getPageNum().intValue(), queryVO.getPageSize().intValue());
        PageHelper.startPage((int)queryVO.getPageNum(), (int)queryVO.getPageSize());
        List dataList = this.assistanceApplyOrderMapper.getAssistanceApplyOrderList(queryVO);
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return BaseResponse.success((Object)pageResult);
        }
        PageInfo pageInfo = new PageInfo(dataList);
        ArrayList resList = new ArrayList();
        dataList.stream().forEach(assistanceApplyOrderEntity -> {
            AssistApplyOrderSelResVO assistApplyOrderSelResVO = new AssistApplyOrderSelResVO();
            assistanceApplyOrderEntity.setAssignPhone(CommonUtils.mobileEncrypt((String)assistanceApplyOrderEntity.getAssignPhone()));
            assistanceApplyOrderEntity.setAgencyPhone(CommonUtils.mobileEncrypt((String)assistanceApplyOrderEntity.getAgencyPhone()));
            assistanceApplyOrderEntity.setAssignIdCard(CommonUtils.idEncrypt((String)assistanceApplyOrderEntity.getAssignIdCard()));
            assistanceApplyOrderEntity.setCardNo(CommonUtils.cardNoEncrypt((String)assistanceApplyOrderEntity.getCardNo()));
            assistanceApplyOrderEntity.setIdCard(CommonUtils.idEncrypt((String)assistanceApplyOrderEntity.getIdCard()));
            BeanUtils.copyProperties((Object)assistanceApplyOrderEntity, (Object)assistApplyOrderSelResVO);
            AssistanceOperationLogEntity assistanceOperationLogEntity = new AssistanceOperationLogEntity();
            assistanceOperationLogEntity.setOrderId(assistanceApplyOrderEntity.getOrderId());
            AssistanceOperationLogEntity operationLogEntity = this.assistanceOperationLogService.selectOne(assistanceOperationLogEntity);
            if (Objects.nonNull(operationLogEntity)) {
                assistApplyOrderSelResVO.setCirculationTime(operationLogEntity.getCreateTime());
                assistApplyOrderSelResVO.setUserName(operationLogEntity.getName());
            }
            resList.add(assistApplyOrderSelResVO);
        });
        pageResult.setContent(resList);
        pageResult.setTotal((int)pageInfo.getTotal());
        return BaseResponse.success((Object)pageResult);
    }

    @Transactional(rollbackFor={Exception.class})
    public AssistApplyOrderResVO saveAssistanceApplyOrder(AssistApplyOrderReqVO assistApplyOrderReqVO) throws Exception {
        AssistanceApplyOrderEntity assistanceApplyOrderEntity = new AssistanceApplyOrderEntity();
        BeanUtils.copyProperties((Object)assistApplyOrderReqVO, (Object)assistanceApplyOrderEntity);
        if (Objects.nonNull(assistApplyOrderReqVO.getCardName()) && Objects.nonNull(assistApplyOrderReqVO.getIdCard())) {
            log.info("\u8c03\u7528\u7528\u6237\u540d\u79f0\u548c\u8eab\u4efd\u8bc1\u7684\u5165\u53c2===\u540d\u79f0:{}\uff0c\u8eab\u4efd\u8bc1:{}", (Object)assistApplyOrderReqVO.getCardName(), (Object)assistApplyOrderReqVO.getIdCard());
            BaseResponse checkIdCardResponse = this.checkInfoApiClient.verify(assistApplyOrderReqVO.getIdCard(), assistApplyOrderReqVO.getCardName());
            log.info("\u8c03\u7528\u7528\u6237\u540d\u79f0\u548c\u8eab\u4efd\u8bc1\u7684\u8fd4\u53c2\u4fe1\u606f:{}", (Object)checkIdCardResponse);
            if (checkIdCardResponse.getCode().equals(ReturnCodeEnum.SUCCEED.getValue()) && checkIdCardResponse.getData() != null) {
                log.info("code:{}", (Object)((CheckIdCardReqVO)checkIdCardResponse.getData()).getCode());
                if (IdVerifyEnum.MATCH_STATUS.getValue() != ((CheckIdCardReqVO)checkIdCardResponse.getData()).getCode()) {
                    throw new Exception("\u94f6\u884c\u5f00\u6237\u540d\u548c\u5f00\u6237\u4eba\u8eab\u4efd\u8bc1\u4e0d\u5339\u914d");
                }
            }
        }
        String orderId = String.valueOf(this.snowflakeIdWorker.nextId());
        assistanceApplyOrderEntity.setOrderId(orderId);
        assistanceApplyOrderEntity.setStatus(AssistanceStatus.EFFECTIVE_STATUS.getValue());
        log.info("\u6148\u5584\u6551\u52a9\u7533\u8bf7\u65b0\u589e\u4fe1\u606f===\u5bf9\u8c61\u6570\u636e:{}", (Object)assistanceApplyOrderEntity);
        this.assistanceApplyOrderMapper.insert(assistanceApplyOrderEntity);
        AssistanceOperationLogEntity assistanceOperationLogEntity = new AssistanceOperationLogEntity();
        assistanceOperationLogEntity.setOrderId(orderId);
        assistanceOperationLogEntity.setUserId(assistApplyOrderReqVO.getUserId());
        assistanceOperationLogEntity.setName(assistApplyOrderReqVO.getAssignName());
        assistanceOperationLogEntity.setAppCode(assistApplyOrderReqVO.getAppCode());
        assistanceOperationLogEntity.setCreateTime(new Date());
        assistanceOperationLogEntity.setType(AssistanceTypeEnum.APPLY.getValue());
        assistanceOperationLogEntity.setTypeName(AssistanceTypeEnum.APPLY.getName());
        assistanceOperationLogEntity.setStatus(AssistanceStatus.EFFECTIVE_STATUS.getValue());
        log.info("\u6148\u5584\u6551\u52a9\u65e5\u5fd7\u8868\u4fe1\u606f===\u5bf9\u8c61\u6570\u636e:{}", (Object)assistanceOperationLogEntity);
        this.assistanceOperationLogService.insertSelective(assistanceOperationLogEntity);
        AssistApplyOrderResVO assistApplyOrderResVO = new AssistApplyOrderResVO();
        assistApplyOrderResVO.setId(assistanceApplyOrderEntity.getId());
        assistApplyOrderResVO.setOrderId(assistanceApplyOrderEntity.getOrderId());
        return assistApplyOrderResVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public void editAssistanceApplyOrder(EditAssistApplyOrderReqVO editAssistApplyOrderReqVO) throws Exception {
        AssistanceApplyOrderEntity assistanceApplyOrderEntity = new AssistanceApplyOrderEntity();
        BeanUtils.copyProperties((Object)editAssistApplyOrderReqVO, (Object)assistanceApplyOrderEntity);
        AssistanceApplyOrderEntity assistanceApplyOrder = null;
        if (Objects.nonNull(editAssistApplyOrderReqVO.getId())) {
            assistanceApplyOrder = this.getOneAssistApplyOrder(editAssistApplyOrderReqVO.getId());
        }
        if (Objects.isNull(assistanceApplyOrder)) {
            throw new Exception("\u6148\u5584\u6551\u52a9\u7533\u8bf7id\u4e0d\u5b58\u5728");
        }
        if (Objects.nonNull(editAssistApplyOrderReqVO.getCardName()) && Objects.nonNull(editAssistApplyOrderReqVO.getIdCard())) {
            log.info("\u8c03\u7528\u7528\u6237\u540d\u79f0\u548c\u8eab\u4efd\u8bc1\u7684\u5165\u53c2===\u540d\u79f0:{}\uff0c\u8eab\u4efd\u8bc1:{}", (Object)editAssistApplyOrderReqVO.getCardName(), (Object)editAssistApplyOrderReqVO.getIdCard());
            BaseResponse checkIdCardResponse = this.checkInfoApiClient.verify(editAssistApplyOrderReqVO.getIdCard(), editAssistApplyOrderReqVO.getCardName());
            log.info("\u8c03\u7528\u7528\u6237\u540d\u79f0\u548c\u8eab\u4efd\u8bc1\u7684\u8fd4\u53c2\u4fe1\u606f:{}", (Object)checkIdCardResponse);
            if (checkIdCardResponse.getCode().equals(ReturnCodeEnum.SUCCEED.getValue()) && checkIdCardResponse.getData() != null) {
                log.info("code:{}", (Object)((CheckIdCardReqVO)checkIdCardResponse.getData()).getCode());
                if (IdVerifyEnum.MATCH_STATUS.getValue() != ((CheckIdCardReqVO)checkIdCardResponse.getData()).getCode()) {
                    throw new Exception("\u94f6\u884c\u5f00\u6237\u540d\u548c\u5f00\u6237\u4eba\u8eab\u4efd\u8bc1\u4e0d\u5339\u914d");
                }
            }
        }
        log.info("\u6148\u5584\u6551\u52a9\u7533\u8bf7\u66f4\u65b0\u4fe1\u606f===\u5bf9\u8c61\u6570\u636e:{}", (Object)assistanceApplyOrderEntity);
        this.assistanceApplyOrderMapper.updateByPrimaryKeySelective(assistanceApplyOrderEntity);
        if (editAssistApplyOrderReqVO.getOrderStatus() == AssistanceOrderStatus.SECOND_IN_ING_STATUS.getValue() || editAssistApplyOrderReqVO.getOrderStatus() == AssistanceOrderStatus.FINISH_STATUS.getValue() || editAssistApplyOrderReqVO.getOrderStatus() == AssistanceOrderStatus.FAIL_STATUS.getValue()) {
            AssistanceOperationLogEntity assistanceOperationLogEntity = new AssistanceOperationLogEntity();
            assistanceOperationLogEntity.setOrderId(assistanceApplyOrder.getOrderId());
            if (StringUtils.isNotEmpty((CharSequence)editAssistApplyOrderReqVO.getAuditFirstUserId())) {
                assistanceOperationLogEntity.setUserId(editAssistApplyOrderReqVO.getAuditFirstUserId());
            } else {
                assistanceOperationLogEntity.setUserId(editAssistApplyOrderReqVO.getAuditSecondUserId());
            }
            assistanceOperationLogEntity.setName(editAssistApplyOrderReqVO.getUserName());
            assistanceOperationLogEntity.setAppCode(editAssistApplyOrderReqVO.getAppCode());
            assistanceOperationLogEntity.setCreateTime(new Date());
            if (editAssistApplyOrderReqVO.getOrderStatus() == AssistanceOrderStatus.SECOND_IN_ING_STATUS.getValue() || editAssistApplyOrderReqVO.getOrderStatus() == AssistanceOrderStatus.FINISH_STATUS.getValue()) {
                assistanceOperationLogEntity.setType(AssistanceTypeEnum.PASS.getValue());
                assistanceOperationLogEntity.setTypeName(AssistanceTypeEnum.PASS.getName());
            } else {
                assistanceOperationLogEntity.setType(AssistanceTypeEnum.RETURN.getValue());
                assistanceOperationLogEntity.setTypeName(AssistanceTypeEnum.RETURN.getName());
            }
            assistanceOperationLogEntity.setStatus(AssistanceStatus.EFFECTIVE_STATUS.getValue());
            log.info("\u6148\u5584\u6551\u52a9\u65e5\u5fd7\u8868\u4fe1\u606f===\u5bf9\u8c61\u6570\u636e:{}", (Object)assistanceOperationLogEntity);
            this.assistanceOperationLogService.insertSelective(assistanceOperationLogEntity);
        }
    }

    public AssistApplyOrderSelResVO getAssistanceApplyOrderById(Integer id) throws Exception {
        AssistanceApplyOrderEntity assistanceApplyOrderEntity = new AssistanceApplyOrderEntity();
        assistanceApplyOrderEntity.setId(id);
        assistanceApplyOrderEntity = this.getOneAssistApplyOrder(id);
        if (Objects.isNull(assistanceApplyOrderEntity)) {
            throw new Exception("\u6148\u5584\u6551\u52a9\u9879\u76eeid\u4e0d\u5b58\u5728");
        }
        AssistApplyOrderSelResVO assistApplyOrderSelResVO = new AssistApplyOrderSelResVO();
        BeanUtils.copyProperties((Object)assistanceApplyOrderEntity, (Object)assistApplyOrderSelResVO);
        return assistApplyOrderSelResVO;
    }

    public void exportAssistanceApplyOrderExcelByIds(List<String> ids, HttpServletResponse response) {
        List exportAssistanceApplyOrderExcelList = this.assistanceApplyOrderMapper.selectAssistanceApplyOrderListByIds(ids, AssistanceOrderStatus.FINISH_STATUS.getValue());
        log.info("\u6148\u5584\u6551\u52a9\u7533\u8bf7\u5bfc\u51fa\u4fe1\u606f===\u5bf9\u8c61\u6570\u636e:{}", (Object)exportAssistanceApplyOrderExcelList);
        ExcelUtils.exportExcel((List)exportAssistanceApplyOrderExcelList, (String)"\u6148\u5584\u6551\u52a9\u7533\u8bf7\u8868", (String)"\u6148\u5584\u6551\u52a9\u7533\u8bf7", ExportAssistanceApplyOrderExcel.class, (String)"\u6148\u5584\u6551\u52a9\u7533\u8bf7\u6570\u636e\u8868", (boolean)true, (HttpServletResponse)response);
    }

    public AssistApplyOrderSelResVO getAppletAssistanceApplyOrderById(Integer id) throws Exception {
        AssistanceApplyOrderEntity assistanceApplyOrderEntity = new AssistanceApplyOrderEntity();
        assistanceApplyOrderEntity.setId(id);
        assistanceApplyOrderEntity = this.getOneAssistApplyOrder(id);
        if (Objects.isNull(assistanceApplyOrderEntity)) {
            throw new Exception("\u6148\u5584\u6551\u52a9\u9879\u76eeid\u4e0d\u5b58\u5728");
        }
        AssistApplyOrderSelResVO assistApplyOrderSelResVO = new AssistApplyOrderSelResVO();
        BeanUtils.copyProperties((Object)assistanceApplyOrderEntity, (Object)assistApplyOrderSelResVO);
        return assistApplyOrderSelResVO;
    }

    public AssistanceApplyOrderEntity getOneAssistApplyOrder(Integer id) {
        AssistanceApplyOrderEntity assistanceApplyOrder = new AssistanceApplyOrderEntity();
        if (Objects.nonNull(id)) {
            assistanceApplyOrder.setId(id);
        }
        assistanceApplyOrder = this.assistanceApplyOrderMapper.selectOne(assistanceApplyOrder);
        return assistanceApplyOrder;
    }
}

