/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.charitable.assistance.server.service.impl;

import com.ebaiyihui.charitable.assistance.server.common.enums.AssistanceOrderStatus;
import com.ebaiyihui.charitable.assistance.server.common.enums.AssistanceStatus;
import com.ebaiyihui.charitable.assistance.server.entity.AssistanceApplyOrderEntity;
import com.ebaiyihui.charitable.assistance.server.entity.AssistanceInfoEntity;
import com.ebaiyihui.charitable.assistance.server.mapper.AssistanceApplyOrderMapper;
import com.ebaiyihui.charitable.assistance.server.mapper.AssistanceInfoMapper;
import com.ebaiyihui.charitable.assistance.server.service.AssistanceInfoService;
import com.ebaiyihui.charitable.assistance.server.vo.AssistApplyOrderSelReqVO;
import com.ebaiyihui.charitable.assistance.server.vo.AssistInfoIdVO;
import com.ebaiyihui.charitable.assistance.server.vo.AssistInfoReqVO;
import com.ebaiyihui.charitable.assistance.server.vo.AssistInfoSelReqVO;
import com.ebaiyihui.charitable.assistance.server.vo.AssistInfoSelResVO;
import com.ebaiyihui.charitable.assistance.server.vo.EditAssistInfoReqVO;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AssistanceInfoServiceImpl
implements AssistanceInfoService {
    private static final Logger log = LoggerFactory.getLogger(AssistanceInfoServiceImpl.class);
    @Autowired
    private AssistanceInfoMapper assistanceInfoMapper;
    @Autowired
    private AssistanceApplyOrderMapper assistanceApplyOrderMapper;

    public BaseResponse<PageResult<AssistInfoSelResVO>> getAssistanceInfoList(AssistInfoSelReqVO queryVO) {
        PageResult pageResult = new PageResult(queryVO.getPageNum().intValue(), queryVO.getPageSize().intValue());
        PageHelper.startPage((int)queryVO.getPageNum(), (int)queryVO.getPageSize());
        List dataList = this.assistanceInfoMapper.getAssistanceInfoList(queryVO);
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return BaseResponse.success((Object)pageResult);
        }
        PageInfo pageInfo = new PageInfo(dataList);
        ArrayList resList = new ArrayList();
        dataList.stream().forEach(assistanceInfoEntity -> {
            AssistInfoSelResVO assistInfoSelResVO = new AssistInfoSelResVO();
            BeanUtils.copyProperties((Object)assistanceInfoEntity, (Object)assistInfoSelResVO);
            resList.add(assistInfoSelResVO);
        });
        pageResult.setContent(resList);
        pageResult.setTotal((int)pageInfo.getTotal());
        return BaseResponse.success((Object)pageResult);
    }

    public AssistInfoIdVO saveAssistanceInfo(AssistInfoReqVO assistInfoReqVO) throws Exception {
        AssistanceInfoEntity assistanceInfoEntity = new AssistanceInfoEntity();
        BeanUtils.copyProperties((Object)assistInfoReqVO, (Object)assistanceInfoEntity);
        AssistanceInfoEntity assistanceInfo = null;
        if (Objects.nonNull(assistInfoReqVO.getAssignName())) {
            assistanceInfo = this.getOneAssistanceInfo(null, assistInfoReqVO.getAssignName());
        }
        if (Objects.nonNull(assistanceInfo)) {
            throw new Exception("\u6148\u5584\u6551\u52a9\u9879\u76ee\u540d\u79f0\u91cd\u590d");
        }
        assistanceInfoEntity.setStatus(AssistanceStatus.EFFECTIVE_STATUS.getValue());
        log.info("\u6148\u5584\u6551\u52a9\u9879\u76ee\u65b0\u589e\u4fe1\u606f===\u5bf9\u8c61\u6570\u636e:{}", (Object)assistanceInfoEntity);
        this.assistanceInfoMapper.insert(assistanceInfoEntity);
        AssistInfoIdVO assistInfoIdVO = new AssistInfoIdVO();
        assistInfoIdVO.setId(assistanceInfoEntity.getId());
        return assistInfoIdVO;
    }

    public void editAssistanceInfo(EditAssistInfoReqVO editAssistInfoReqVO) throws Exception {
        AssistanceInfoEntity assistanceInfoEntity = new AssistanceInfoEntity();
        BeanUtils.copyProperties((Object)editAssistInfoReqVO, (Object)assistanceInfoEntity);
        AssistanceInfoEntity assistanceInfo = null;
        if (Objects.nonNull(editAssistInfoReqVO.getId())) {
            assistanceInfo = this.getOneAssistanceInfo(editAssistInfoReqVO.getId(), null);
        }
        if (Objects.isNull(assistanceInfo)) {
            throw new Exception("\u6148\u5584\u6551\u52a9\u9879\u76eeid\u4e0d\u5b58\u5728");
        }
        AssistanceInfoEntity assistanceInfo2 = null;
        if (Objects.nonNull(editAssistInfoReqVO.getAssignName())) {
            assistanceInfo2 = this.getOneAssistanceInfo(null, editAssistInfoReqVO.getAssignName());
        }
        if (Objects.nonNull(assistanceInfo2) && editAssistInfoReqVO.getId() != assistanceInfo2.getId()) {
            throw new Exception("\u6148\u5584\u6551\u52a9\u9879\u76ee\u540d\u79f0\u91cd\u590d");
        }
        AssistApplyOrderSelReqVO assistApplyOrderSelReqVO = new AssistApplyOrderSelReqVO();
        assistApplyOrderSelReqVO.setAssignId(assistanceInfo.getId());
        List assistanceApplyOrderEntity = this.assistanceApplyOrderMapper.getAssistanceApplyOrderList(assistApplyOrderSelReqVO);
        for (AssistanceApplyOrderEntity assistanceApplyOrder : assistanceApplyOrderEntity) {
            if (assistanceApplyOrder.getOrderStatus() >= AssistanceOrderStatus.FINISH_STATUS.getValue()) continue;
            throw new Exception("\u8be5\u9879\u76ee\u6709\u672a\u5b8c\u6210\u7684\u7533\u8bf7\uff0c\u4e0d\u53ef\u5220\u9664");
        }
        log.info("\u6148\u5584\u6551\u52a9\u9879\u76ee\u66f4\u65b0\u4fe1\u606f===\u5bf9\u8c61\u6570\u636e:{}", (Object)assistanceInfoEntity);
        this.assistanceInfoMapper.updateByPrimaryKeySelective(assistanceInfoEntity);
    }

    public AssistInfoSelResVO getAssistanceInfoById(Integer id) throws Exception {
        AssistanceInfoEntity assistanceInfoEntity = new AssistanceInfoEntity();
        assistanceInfoEntity.setId(id);
        assistanceInfoEntity = this.getOneAssistanceInfo(id, null);
        AssistInfoSelResVO assistInfoSelResVO = new AssistInfoSelResVO();
        BeanUtils.copyProperties((Object)assistanceInfoEntity, (Object)assistInfoSelResVO);
        return assistInfoSelResVO;
    }

    public AssistanceInfoEntity getOneAssistanceInfo(Integer id, String assignName) {
        AssistanceInfoEntity assistanceInfoEntity = new AssistanceInfoEntity();
        if (Objects.nonNull(id)) {
            assistanceInfoEntity.setId(id);
        } else if (Objects.nonNull(assignName)) {
            assistanceInfoEntity.setAssignName(assignName);
        }
        return this.assistanceInfoMapper.selectOne(assistanceInfoEntity);
    }
}

