/*
 * Decompiled with CFR 0.152.
 */
package ngari.openapi;

import java.util.UUID;
import ngari.openapi.Request;
import ngari.openapi.Response;
import ngari.openapi.util.AESUtils;
import ngari.openapi.util.JSONUtils;
import ngari.openapi.util.MessageDigestUtil;
import ngari.openapi.util.OpenApiUtils;
import ngari.openapi.util.SignUtil;

public class Client {
    private String apiUrl;
    private String appKey;
    private String appSecret;
    private String encodingAesKey;

    public Client(String apiUrl, String appKey, String appSecret, String encodingAesKey) {
        this.apiUrl = apiUrl;
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.encodingAesKey = encodingAesKey;
    }

    public Response execute(Request request) throws Exception {
        request.setApiUrl(this.apiUrl);
        request.setAppKey(this.appKey);
        request.setAppSecret(this.appSecret);
        request.setEncodingAesKey(this.encodingAesKey);
        request.addHeader("X-Ca-Key", request.getAppKey());
        request.addHeader("X-Ca-Nonce", UUID.randomUUID().toString());
        request.addHeader("X-Ca-Timestamp", String.valueOf(System.currentTimeMillis()));
        String jsonStr = JSONUtils.toString(request.getBodys());
        System.out.println(jsonStr);
        String encryptStr = AESUtils.encrypt(jsonStr, request.getEncodingAesKey());
        String contentMd5 = MessageDigestUtil.base64AndMD5(encryptStr);
        request.addHeader("X-Content-MD5", contentMd5);
        String signature = SignUtil.sign(request.getAppSecret(), request.getHeaders());
        request.addHeader("X-Ca-Signature", signature);
        request.setStringBody(encryptStr);
        return OpenApiUtils.post(request);
    }

    public static void main(String[] args) throws Exception {
        String body = "[1]";
        String encryptStr = AESUtils.encrypt(body, "1234567890123456");
        String contentMd5 = MessageDigestUtil.base64AndMD5(encryptStr.getBytes());
        System.out.println(contentMd5);
    }
}

