/*
 * Decompiled with CFR 0.152.
 */
package ngari.openapi.util;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class AESUtils {
    private static final String KEY_ALGORITHM = "AES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";
    private static final String CHARSET_ENCODING = "UTF-8";

    public static byte[] initSecretKey() throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance(KEY_ALGORITHM);
        kg.init(128);
        SecretKey secretKey = kg.generateKey();
        return secretKey.getEncoded();
    }

    public static Key toKey(byte[] key) {
        return new SecretKeySpec(key, KEY_ALGORITHM);
    }

    public static String encrypt(String data, String key) throws Exception {
        return Base64.encodeBase64String(AESUtils.encrypt(data.getBytes(CHARSET_ENCODING), AESUtils.toKey(key.getBytes()), DEFAULT_CIPHER_ALGORITHM));
    }

    public static String decrypt(String data, String key) throws Exception {
        return new String(AESUtils.decrypt(Base64.decodeBase64(data.getBytes(CHARSET_ENCODING)), AESUtils.toKey(key.getBytes()), DEFAULT_CIPHER_ALGORITHM));
    }

    public static byte[] encrypt(byte[] data, Key key) throws Exception {
        return AESUtils.encrypt(data, key, DEFAULT_CIPHER_ALGORITHM);
    }

    public static byte[] encrypt(byte[] data, byte[] key) throws Exception {
        return AESUtils.encrypt(data, AESUtils.toKey(key), DEFAULT_CIPHER_ALGORITHM);
    }

    public static byte[] encrypt(byte[] data, Key key, String cipherAlgorithm) throws Exception {
        Cipher cipher = Cipher.getInstance(cipherAlgorithm);
        cipher.init(1, key);
        return cipher.doFinal(data);
    }

    public static byte[] decrypt(byte[] data, byte[] key) throws Exception {
        return AESUtils.decrypt(data, key, DEFAULT_CIPHER_ALGORITHM);
    }

    public static byte[] decrypt(byte[] data, Key key) throws Exception {
        return AESUtils.decrypt(data, key, DEFAULT_CIPHER_ALGORITHM);
    }

    public static byte[] decrypt(byte[] data, byte[] key, String cipherAlgorithm) throws Exception {
        Key k = AESUtils.toKey(key);
        return AESUtils.decrypt(data, k, cipherAlgorithm);
    }

    public static byte[] decrypt(byte[] data, Key key, String cipherAlgorithm) throws Exception {
        Cipher cipher = Cipher.getInstance(cipherAlgorithm);
        cipher.init(2, key);
        return cipher.doFinal(data);
    }

    private static String showByteArray(byte[] data) {
        if (null == data) {
            return null;
        }
        StringBuilder sb = new StringBuilder("{");
        for (byte b : data) {
            sb.append(b).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("}");
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        String original = "[1]";
        String key = "1234567890123456";
        System.out.println("original: " + original);
        String encrypt = AESUtils.encrypt(original, key);
        System.out.println("encrypt: " + encrypt + ", key: " + key);
        String decrypt = AESUtils.decrypt(encrypt, key);
        System.out.println("decrypt: " + decrypt);
    }
}

