/*
 * Decompiled with CFR 0.152.
 */
package ngari.openapi.util;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import ngari.openapi.util.Base64;
import ngari.openapi.util.JSONUtils;
import org.apache.commons.lang3.StringUtils;

public class FileAuth {
    private static FileAuth instance;
    private final SecretKeySpec secretKey;
    private String accessKey;

    public FileAuth(String accessKey, String secret) {
        if (FileAuth.isNullOrEmpty(accessKey) || FileAuth.isNullOrEmpty(secret)) {
            throw new IllegalArgumentException("empty key or secret");
        }
        byte[] sk = FileAuth.utf8Bytes(secret);
        SecretKeySpec secretKeySpec = new SecretKeySpec(sk, "HmacSHA1");
        this.accessKey = accessKey;
        this.secretKey = secretKeySpec;
        instance = this;
    }

    public static FileAuth instance() {
        if (instance == null) {
            throw new IllegalStateException("FileAuth not setup,please check");
        }
        return instance;
    }

    private static String encodeToString(byte[] data) {
        return Base64.encodeToString(data, 10);
    }

    public static byte[] decode(String data) {
        return Base64.decode(data, 10);
    }

    private static boolean isNullOrEmpty(String s) {
        return s == null || "".equals(s);
    }

    private static byte[] utf8Bytes(String data) {
        return data.getBytes(StandardCharsets.UTF_8);
    }

    public static void main(String[] args) {
        FileAuth fileAuth = new FileAuth("accessKey", "secret");
        String uptk = fileAuth.createUploadToken("other-doc");
        System.out.println(uptk);
        String token = fileAuth.createToken("5dbf93147826c67027c438bf", 3600L);
        System.out.println(token);
        System.out.println(fileAuth.createTokens("a,b,c", 3600L));
        System.out.println(fileAuth.createTokensByListStr("[\"a\",\"b\"]", 3600L));
        System.out.println(fileAuth.createTokensByListStr("[1,2]", 3600L));
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    private Mac createMac() {
        Mac mac;
        try {
            mac = Mac.getInstance("HmacSHA1");
            mac.init(this.secretKey);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
        return mac;
    }

    public String sign(byte[] data) {
        Mac mac = this.createMac();
        return FileAuth.encodeToString(mac.doFinal(data));
    }

    public String sign(String data) {
        return this.sign(FileAuth.utf8Bytes(data));
    }

    private boolean isTimeExpired(long expireTime) {
        long nowTime = System.currentTimeMillis() / 1000L;
        return nowTime > expireTime;
    }

    public String createToken(String fileId, long expires) {
        if (instance == null) {
            return null;
        }
        long deadline = System.currentTimeMillis() / 1000L + expires;
        String sign = this.sign(fileId + "?" + deadline);
        return StringUtils.join(new Object[]{deadline, this.accessKey, sign}, ":");
    }

    private String createTokens(String fileIds, long expires) {
        String[] keys = StringUtils.split(fileIds, ',');
        Object[] tokens = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            tokens[i] = this.createToken(keys[i], expires);
        }
        return StringUtils.join(tokens, ",");
    }

    private String createTokensByListStr(String fileIdListStr, long expires) {
        List fileIdList = JSONUtils.parse(fileIdListStr, List.class);
        ArrayList<String> strList = new ArrayList<String>();
        for (Object o : fileIdList) {
            strList.add(String.valueOf(o));
        }
        return JSONUtils.toString(this.createTokens(strList, expires));
    }

    private List<String> createTokens(List<String> fileIdList, long expires) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : fileIdList) {
            list.add(this.createToken(s, expires));
        }
        return list;
    }

    public String createUploadToken(String bucket) {
        HashMap<String, Object> policy = new HashMap<String, Object>();
        policy.put("scope", bucket);
        policy.put("deadline", System.currentTimeMillis() / 1000L + 3600L);
        return this.createUploadToken(bucket, policy);
    }

    public String createUploadToken(String bucket, long expires) {
        HashMap<String, Object> policy = new HashMap<String, Object>();
        policy.put("scope", bucket);
        policy.put("deadline", System.currentTimeMillis() / 1000L + expires);
        return this.createUploadToken(bucket, policy);
    }

    public String createUploadToken(String bucket, Map<String, Object> policy) {
        String sign = this.sign(JSONUtils.toString(policy));
        return this.accessKey + ':' + sign + ':' + FileAuth.encodeToString(FileAuth.utf8Bytes(JSONUtils.toString(policy)));
    }
}

