/*
 * Decompiled with CFR 0.152.
 */
package ngari.openapi.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class SignUtil {
    private static final List<String> SIGN_HEADER_LIST = Arrays.asList("X-Service-Id", "X-Service-Method", "X-Ca-Key", "X-Ca-Nonce", "X-Ca-Timestamp", "X-Content-MD5");

    public static String sign(String secret, Map<String, String> headers) {
        try {
            Mac hmacSha256 = Mac.getInstance("HmacSHA256");
            byte[] keyBytes = secret.getBytes("UTF-8");
            hmacSha256.init(new SecretKeySpec(keyBytes, 0, keyBytes.length, "HmacSHA256"));
            return new String(Base64.encodeBase64(hmacSha256.doFinal(SignUtil.buildHeaders(headers, SIGN_HEADER_LIST).getBytes("UTF-8"))), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String buildHeaders(Map<String, String> headers, List<String> signHeaderList) {
        ArrayList<String> sbList = new ArrayList<String>();
        if (null != signHeaderList) {
            Collections.sort(signHeaderList);
            if (null != headers) {
                TreeMap<String, String> sortMap = new TreeMap<String, String>();
                sortMap.putAll(headers);
                StringBuilder signHeadersStringBuilder = new StringBuilder();
                for (Map.Entry header : sortMap.entrySet()) {
                    if (!SignUtil.isHeaderToSign((String)header.getKey(), signHeaderList)) continue;
                    StringBuilder sb = new StringBuilder();
                    sb.append(((String)header.getKey()).toLowerCase());
                    sb.append(":");
                    if (!StringUtils.isBlank((CharSequence)header.getValue())) {
                        sb.append((String)header.getValue());
                    }
                    sbList.add(sb.toString());
                    if (0 < signHeadersStringBuilder.length()) {
                        signHeadersStringBuilder.append(",");
                    }
                    signHeadersStringBuilder.append(((String)header.getKey()).toLowerCase());
                }
                headers.put("X-Ca-Signature-Headers", signHeadersStringBuilder.toString());
            }
        }
        return StringUtils.join(sbList, "&");
    }

    private static boolean isHeaderToSign(String headerName, List<String> signHeaderList) {
        if (StringUtils.isBlank(headerName)) {
            return false;
        }
        if (headerName.startsWith("X-Ca-")) {
            return true;
        }
        if (null != signHeaderList) {
            for (String signHeaderPrefix : signHeaderList) {
                if (!headerName.equalsIgnoreCase(signHeaderPrefix)) continue;
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        String secret = "1234567890123456";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Service-Id", "eh.organ");
        headers.put("X-Service-Method", "");
        headers.put("X-Ca-Key", "hello");
        headers.put("X-Ca-Timestamp", String.valueOf(System.currentTimeMillis()));
        headers.put("X-Ca-Nonce", UUID.randomUUID().toString());
        headers.put("X-Content-MD5", UUID.randomUUID().toString());
        System.out.println(SignUtil.sign(secret, headers));
    }
}

