/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.controller;

import com.ebaiyihui.common.AccountApi;
import com.ebaiyihui.common.pojo.annotation.AccessCheck;
import com.ebaiyihui.common.pojo.login.CheckAccountRepeatReqVO;
import com.ebaiyihui.common.pojo.login.CheckAccountRepeatRespVO;
import com.ebaiyihui.common.pojo.login.WeChatLoginReqVO;
import com.ebaiyihui.common.pojo.login.WechatRespVO;
import com.ebaiyihui.common.pojo.vo.AccountLoginReqVO;
import com.ebaiyihui.common.pojo.vo.AccountLogoutReqVO;
import com.ebaiyihui.common.pojo.vo.AccountNoUpdateReqVO;
import com.ebaiyihui.common.pojo.vo.AccountOperateBaseReqVO;
import com.ebaiyihui.common.pojo.vo.AccountPasswordUpdateReqVO;
import com.ebaiyihui.common.pojo.vo.AccountRegisterReqVO;
import com.ebaiyihui.common.pojo.vo.BaseIdRespVO;
import com.ebaiyihui.common.pojo.vo.CloudAccountLoginReqVO;
import com.ebaiyihui.common.pojo.vo.DoctorAppLoginRespVO;
import com.ebaiyihui.common.pojo.vo.ResetPasswordReqVO;
import com.ebaiyihui.common.pojo.vo.WxAppletReqVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.MdcUtil;
import com.ebaiyihui.server.service.IAccountService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(description="\u7528\u6237\u4e2d\u5fc3\u8d26\u6237\u64cd\u4f5cAPI")
@AccessCheck(value=AccessCheck.PermissionType.ACCESS_TOKEN_API)
public class AccountController
implements AccountApi {
    @Autowired
    private IAccountService accountService;

    public BaseResponse<DoctorAppLoginRespVO> quickLogin(@RequestBody @Validated CloudAccountLoginReqVO reqVo) {
        MdcUtil.setCallerUserMethod((String)reqVo.getChannelCode(), (String)reqVo.getAccountNo(), (String)"\u4e91\u7aef\u533b\u751f\u8d26\u6237\u5feb\u6377\u767b\u5f55");
        return this.accountService.quickLogin(reqVo);
    }

    public BaseResponse<DoctorAppLoginRespVO> doctorLogin(@RequestBody @Validated AccountLoginReqVO accountLoginReqVO) {
        MdcUtil.setCallerUserMethod((String)accountLoginReqVO.getChannelCode(), (String)accountLoginReqVO.getAccountNo(), (String)"\u4e91\u7aef\u533b\u751f\u8d26\u6237\u767b\u5f55");
        return this.accountService.doctorLogin(accountLoginReqVO);
    }

    public BaseResponse<BaseIdRespVO> logout(@RequestHeader(value="accessToken") String accessToken, @RequestBody @Validated AccountLogoutReqVO accountLogoutReqVO) {
        MdcUtil.setCallerUserMethod((String)accountLogoutReqVO.getAppCode(), (String)accountLogoutReqVO.getAccountId(), (String)"\u8d26\u6237\u767b\u51fa");
        return this.accountService.logout(accessToken, accountLogoutReqVO);
    }

    public BaseResponse<BaseIdRespVO> accountCancel(@RequestBody @Validated AccountOperateBaseReqVO accountOperateBaseReqVO, @RequestHeader(value="accessToken") String accessToken) {
        MdcUtil.setCallerUserMethod((String)accountOperateBaseReqVO.getAppCode(), (String)accountOperateBaseReqVO.getAccountId(), (String)"\u8d26\u6237\u6ce8\u9500");
        return this.accountService.accountCancel(accountOperateBaseReqVO, accessToken);
    }

    public BaseResponse<BaseIdRespVO> updatePassword(@RequestBody @Validated AccountPasswordUpdateReqVO accountPasswordUpdateReqVO, @RequestHeader(value="accessToken") String accessToken) {
        MdcUtil.setCallerUserMethod((String)accountPasswordUpdateReqVO.getAppCode(), (String)accountPasswordUpdateReqVO.getAccountId(), (String)"\u5bc6\u7801\u4fee\u6539");
        return this.accountService.updatePassword(accountPasswordUpdateReqVO, accessToken);
    }

    public BaseResponse<BaseIdRespVO> updateAccountNo(@RequestBody @Validated AccountNoUpdateReqVO accountNoUpdateReqVO, @RequestHeader(value="accessToken") String accessToken) {
        MdcUtil.setCallerUserMethod((String)accountNoUpdateReqVO.getAppCode(), (String)accountNoUpdateReqVO.getAccountId(), (String)"\u767b\u5f55\u5e10\u53f7\u4fee\u6539");
        return this.accountService.updateAccountNo(accountNoUpdateReqVO, accessToken);
    }

    public BaseResponse<BaseIdRespVO> pwdVerify(@RequestBody @Validated AccountOperateBaseReqVO accountPwdVerifyReqVO) {
        MdcUtil.setCallerUserMethod((String)accountPwdVerifyReqVO.getAppCode(), (String)accountPwdVerifyReqVO.getAccountId(), (String)"\u767b\u5f55\u5bc6\u7801\u6821\u9a8c");
        return this.accountService.pwdVerify(accountPwdVerifyReqVO);
    }

    public BaseResponse<CheckAccountRepeatRespVO> accountNoVerify(@RequestBody @Validated CheckAccountRepeatReqVO checkAccountRepeatReqVO) {
        MdcUtil.setCallerUserMethod((String)checkAccountRepeatReqVO.getAppCode(), (String)checkAccountRepeatReqVO.getAccountNo(), (String)"\u68c0\u67e5\u8d26\u6237");
        return this.accountService.accountNoVerify(checkAccountRepeatReqVO);
    }

    public BaseResponse<BaseIdRespVO> resetPassword(@RequestBody @Validated ResetPasswordReqVO resetPasswordReqVO) {
        MdcUtil.setCallerUserMethod((String)resetPasswordReqVO.getAppCode(), (String)resetPasswordReqVO.getAccountNo(), (String)"\u91cd\u7f6e\u5bc6\u7801");
        return this.accountService.resetPassword(resetPasswordReqVO);
    }

    public BaseResponse<WechatRespVO> getWxApplet(@RequestBody @Validated WxAppletReqVO wxAppletReqVO) {
        return this.accountService.getWxApplet(wxAppletReqVO);
    }

    public BaseResponse<WechatRespVO> wxLogin(@RequestBody @Validated WeChatLoginReqVO weChatLoginReqVO) {
        MdcUtil.setCallerUserMethod((String)weChatLoginReqVO.getAppCode(), (String)weChatLoginReqVO.getOpenId(), (String)"\u5fae\u4fe1\u6388\u6743\u767b\u5f55");
        return this.accountService.wxLogin(weChatLoginReqVO);
    }

    public BaseResponse<BaseIdRespVO> register(@RequestBody AccountRegisterReqVO accountRegisterReqVO) {
        MdcUtil.setCallerUserMethod((String)accountRegisterReqVO.getAppCode(), (String)accountRegisterReqVO.getAccountNo(), (String)"\u533b\u751f\u8d26\u6237\u6ce8\u518c");
        return this.accountService.register(accountRegisterReqVO);
    }
}

