/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.controller;

import com.ebaiyihui.common.CardApi;
import com.ebaiyihui.common.pojo.vo.card.CardBindLogReqVO;
import com.ebaiyihui.common.pojo.vo.card.CardBindLogRespVO;
import com.ebaiyihui.common.pojo.vo.card.CardDetailQueryReqVO;
import com.ebaiyihui.common.pojo.vo.card.CardDetailRespVO;
import com.ebaiyihui.common.pojo.vo.card.CardListQueryReqVO;
import com.ebaiyihui.common.pojo.vo.card.OrganBindCountRespVO;
import com.ebaiyihui.common.pojo.vo.card.OrganCodeListReqVO;
import com.ebaiyihui.common.pojo.vo.card.UcBindCardReqVO;
import com.ebaiyihui.common.pojo.vo.card.UcCardListReqVO;
import com.ebaiyihui.common.pojo.vo.card.UcRegisterCardReqVO;
import com.ebaiyihui.common.pojo.vo.card.UnbindCardReqVO;
import com.ebaiyihui.common.pojo.vo.card.UnbindCardRespVO;
import com.ebaiyihui.common.pojo.vo.card.UpdateCardInfoVO;
import com.ebaiyihui.common.pojo.vo.card.UserPatientListRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.MdcUtil;
import com.ebaiyihui.server.service.BaseService;
import com.ebaiyihui.server.service.ICardBindLogService;
import com.ebaiyihui.server.service.ICardBindService;
import io.swagger.annotations.Api;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(description="\u5c31\u8bca\u5361\u76f8\u5173\u64cd\u4f5cAPI")
public class CardController
extends BaseService
implements CardApi {
    @Autowired
    private ICardBindService cardBindService;
    @Autowired
    private ICardBindLogService cardBindLogService;

    public BaseResponse<List<OrganBindCountRespVO>> getCardCount(@RequestBody @Validated OrganCodeListReqVO reqVo) {
        MdcUtil.setCallerUserMethod((String)reqVo.getAppCode(), (String)reqVo.getUserId(), (String)"\u83b7\u53d6\u7ed1\u5361\u6570\u91cf");
        return this.cardBindService.getBindCount(reqVo);
    }

    public BaseResponse<List<CardBindLogRespVO>> getCardLog(@RequestBody @Validated CardBindLogReqVO reqVo) {
        MdcUtil.setCallerUserMethod((String)reqVo.getAppCode(), (String)reqVo.getCardId(), (String)"\u83b7\u53d6\u7ed1\u5361\u65e5\u5fd7");
        return this.cardBindLogService.getCardBindLog(reqVo);
    }

    public BaseResponse<Map<String, Object>> getCardListForManage(@RequestBody @Validated CardListQueryReqVO reqVo) {
        return this.cardBindService.getCardList(reqVo);
    }

    public BaseResponse<CardDetailRespVO> getCardDetailForManage(@RequestBody @Validated CardDetailQueryReqVO reqVo) {
        MdcUtil.setCallerUserMethod((String)reqVo.getAppCode(), (String)reqVo.getCardId(), (String)"\u83b7\u53d6\u5361\u8be6\u60c5");
        return this.cardBindService.getCardDetail(reqVo);
    }

    public BaseResponse<UnbindCardRespVO> unbindCard(@RequestBody @Validated UnbindCardReqVO reqVo) {
        MdcUtil.setCallerUserMethod((String)reqVo.getAppCode(), (String)reqVo.getCardId(), (String)"\u89e3\u7ed1\u5c31\u8bca\u5361");
        return this.cardBindService.unbindCard(reqVo);
    }

    public BaseResponse<CardDetailRespVO> bindCard(@RequestBody @Validated UcBindCardReqVO reqVo) {
        MdcUtil.setCallerUserMethod((String)reqVo.getAppCode(), (String)reqVo.getCredNo(), (String)"\u7ed1\u5b9a\u5c31\u8bca\u5361");
        return this.cardBindService.bindCard(reqVo);
    }

    public BaseResponse<CardDetailRespVO> registerCard(@RequestBody @Validated UcRegisterCardReqVO reqVo) {
        MdcUtil.setCallerUserMethod((String)reqVo.getAppCode(), (String)reqVo.getCredNo(), (String)"\u65e0\u5361\u6ce8\u518c");
        return this.cardBindService.registerCard(reqVo);
    }

    public BaseResponse<List<UserPatientListRespVO>> getUserCardList(@RequestBody @Validated UcCardListReqVO reqVo) {
        MdcUtil.setCallerUserMethod((String)reqVo.getAppCode(), (String)reqVo.getUserId(), (String)"\u83b7\u53d6\u7528\u6237\u5c31\u8bca\u5361\u5217\u8868");
        return this.cardBindService.getUserCardList(reqVo);
    }

    public BaseResponse updateCardInfo(@RequestBody UpdateCardInfoVO reqVO) {
        MdcUtil.setCallerUserMethod((String)reqVO.getUserId(), (String)reqVO.getCardId(), (String)"\u4fee\u6539\u5c31\u8bca\u5361\u4fe1\u606f");
        return this.cardBindService.updateCardInfo(reqVO);
    }

    public BaseResponse<List<String>> getUserList(@RequestParam(value="patientId") String patientId) {
        MdcUtil.setCallerUserMethod((String)patientId, (String)"", (String)"\u6839\u636e\u60a3\u8005id\u83b7\u53d6userId\u96c6\u5408");
        return this.cardBindService.getUserList(patientId);
    }
}

