/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.controller;

import com.ebaiyihui.common.ManagerAuthApi;
import com.ebaiyihui.common.pojo.annotation.AccessCheck;
import com.ebaiyihui.common.pojo.query.UcAccountQuery;
import com.ebaiyihui.common.pojo.systemauthVo.AccountResVo;
import com.ebaiyihui.common.pojo.systemauthVo.ManagerAddReqVo;
import com.ebaiyihui.common.pojo.systemauthVo.ManagerEditReqVo;
import com.ebaiyihui.common.pojo.systemauthVo.MemberCountResVo;
import com.ebaiyihui.common.pojo.systemauthVo.VerifyPasswordReqVo;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.server.pojo.bo.ExcelData;
import com.ebaiyihui.server.service.BaseService;
import com.ebaiyihui.server.service.IManagerAuthService;
import com.ebaiyihui.server.util.ExcelUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(description="\u7cfb\u7edf\u7ba1\u7406\u6d88\u606f\u4e2a\u4eba\u8bbe\u7f6eAPI")
@AccessCheck(value=AccessCheck.PermissionType.ADMIN_API)
public class ManagerAuthController
extends BaseService
implements ManagerAuthApi {
    private static final Logger log = LoggerFactory.getLogger(ManagerAuthController.class);
    @Autowired
    private IManagerAuthService managerAuthService;

    @ApiOperation(value="\u67e5\u8be2\u6210\u5458\u7edf\u8ba1\u6570\u636e")
    public BaseResponse<MemberCountResVo> getMemberCount() {
        return this.managerAuthService.getMemberCount();
    }

    @ApiOperation(value="\u6dfb\u52a0\u6210\u5458")
    public BaseResponse<AccountResVo> addMember(@RequestBody ManagerAddReqVo managerAddReqVo) {
        return this.managerAuthService.addMember(managerAddReqVo);
    }

    @ApiOperation(value="\u7f16\u8f91\u6210\u5458,\u4fee\u6539\u57fa\u672c\u4fe1\u606f")
    public BaseResponse<AccountResVo> editMember(@RequestBody ManagerEditReqVo managerEditReqVo) {
        return this.managerAuthService.editMember(managerEditReqVo);
    }

    @ApiOperation(value="\u5220\u9664\u6210\u5458")
    public BaseResponse<Boolean> deleteMember(@RequestParam(value="accountId") String accountId) {
        return this.managerAuthService.deleteMember(accountId);
    }

    @ApiOperation(value="\u9a8c\u8bc1\u5bc6\u7801")
    public BaseResponse<Boolean> verifyPassword(@RequestBody VerifyPasswordReqVo vo) {
        return this.managerAuthService.verifyPassword(vo);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u57fa\u672c\u4fe1\u606f")
    public BaseResponse<AccountResVo> getMemberInfo(@RequestParam(value="accountId") String accountId) {
        return this.managerAuthService.getMemberInfo(accountId);
    }

    @ApiOperation(value="\u6761\u4ef6\u5206\u9875\u67e5\u8be2\u6210\u5458\u5217\u8868")
    public BaseResponse<PageResult<AccountResVo>> getMemberList(@RequestBody UcAccountQuery query) {
        if (query.getIsActive() != null && query.getIsActive() == -1) {
            ArrayList<AccountResVo> list = new ArrayList<AccountResVo>();
            list.add(new AccountResVo());
            PageResult pageResult = new PageResult();
            pageResult.setContent(list);
            return new BaseResponse("1", "\u6fc0\u6d3b\u72b6\u6001\u672a\u9009\u62e9", (Object)pageResult);
        }
        BaseResponse memberList = this.managerAuthService.getMemberList(query);
        if (memberList.getData() == null) {
            memberList = new BaseResponse();
            AccountResVo vo = new AccountResVo();
            vo.setCreateTime(new Date());
            PageResult pageRequ = new PageResult();
            ArrayList<AccountResVo> list = new ArrayList<AccountResVo>();
            list.add(vo);
            pageRequ.setContent(list);
            memberList.setData((Object)pageRequ);
        }
        return memberList;
    }

    @ApiOperation(value="\u5bfc\u51fa\u6210\u5458\u5217\u8868")
    public BaseResponse exportList(@RequestParam(value="ids") String ids, HttpServletResponse httpServletResponse) throws Exception {
        ExcelData excelData = this.managerAuthService.exportMemberList(ids);
        ExcelUtils.exportExcel((HttpServletResponse)httpServletResponse, (String)"\u6210\u5458\u4fe1\u606f\u8868", (ExcelData)excelData);
        return BaseResponse.success();
    }
}

