/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.controller;

import com.ebaiyihui.common.NodeAccountApi;
import com.ebaiyihui.common.pojo.annotation.AccessCheck;
import com.ebaiyihui.common.pojo.login.BaseUserCenterIdRespVO;
import com.ebaiyihui.common.pojo.login.CheckAccountRepeatReqVO;
import com.ebaiyihui.common.pojo.login.CheckAccountRepeatRespVO;
import com.ebaiyihui.common.pojo.login.CusSmsLoginReqVO;
import com.ebaiyihui.common.pojo.login.UcWxAuthReqVo;
import com.ebaiyihui.common.pojo.login.UcWxAuthRespVo;
import com.ebaiyihui.common.pojo.login.UserLoginReqVO;
import com.ebaiyihui.common.pojo.login.UserLoginRespVO;
import com.ebaiyihui.common.pojo.login.UserRigisterReqVO;
import com.ebaiyihui.common.pojo.login.WeChatLoginReqVO;
import com.ebaiyihui.common.pojo.login.WechatRespVO;
import com.ebaiyihui.common.pojo.login.WxBindingReqVo;
import com.ebaiyihui.common.pojo.vo.AccountLoginRespVO;
import com.ebaiyihui.common.pojo.vo.AccountLogoutIReqVO;
import com.ebaiyihui.common.pojo.vo.AccountNoUpdateReqVO;
import com.ebaiyihui.common.pojo.vo.AccountOperateBaseReqVO;
import com.ebaiyihui.common.pojo.vo.BaseIdRespVO;
import com.ebaiyihui.common.pojo.vo.GetWxOpenidReqVO;
import com.ebaiyihui.common.pojo.vo.GetWxOpenidRespVO;
import com.ebaiyihui.common.pojo.vo.GetbackPasswordReqVO;
import com.ebaiyihui.common.pojo.vo.VercodeRespVo;
import com.ebaiyihui.common.pojo.vo.WxAppletReqVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.MdcUtil;
import com.ebaiyihui.server.service.IAccessTokenService;
import com.ebaiyihui.server.service.IAccountService;
import com.ebaiyihui.server.service.IUcWxAuthService;
import com.ebaiyihui.server.util.CommonsUtils;
import com.ebaiyihui.server.util.RandomUtil;
import com.ebaiyihui.server.util.RedisUtil;
import com.ebaiyihui.server.util.VerifyCodeUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import sun.misc.BASE64Encoder;

@RestController
@AccessCheck(value=AccessCheck.PermissionType.ACCESS_TOKEN_API)
public class NodeAccountController
implements NodeAccountApi {
    private static final Logger log = LoggerFactory.getLogger(NodeAccountController.class);
    @Autowired
    private IAccountService accountService;
    @Autowired
    private IUcWxAuthService ucWxAuthService;
    @Autowired
    private IAccessTokenService accessTokenService;
    @Autowired
    RedisUtil redisUtil;

    @AccessCheck(value=AccessCheck.PermissionType.OPEN_API)
    public BaseResponse<UserLoginRespVO> login(@RequestBody @Validated UserLoginReqVO userLoginReqVO, HttpServletRequest request) {
        String headerIp = CommonsUtils.getRealIp((HttpServletRequest)request);
        MdcUtil.setCallerUserMethod((String)userLoginReqVO.getAppCode(), (String)userLoginReqVO.getAccountNo(), (String)"\u8d26\u6237\u767b\u5f55");
        return this.accountService.login(userLoginReqVO, headerIp);
    }

    public BaseResponse<BaseUserCenterIdRespVO> logout(@RequestBody @Validated AccountLogoutIReqVO accountLogoutIReqVO, @RequestHeader(value="accessToken") String accessToken, HttpServletRequest request) {
        String headerIp = CommonsUtils.getRealIp((HttpServletRequest)request);
        return this.accountService.logout(accountLogoutIReqVO, headerIp, accessToken);
    }

    public BaseResponse<BaseIdRespVO> accountCancel(@RequestBody @Validated AccountOperateBaseReqVO accountOperateBaseReqVO, @RequestHeader(value="accessToken") String accessToken) {
        MdcUtil.setCallerUserMethod((String)accountOperateBaseReqVO.getAppCode(), (String)accountOperateBaseReqVO.getAccountId(), (String)"\u8d26\u6237\u6ce8\u9500");
        return this.accountService.accountCancel(accountOperateBaseReqVO, accessToken);
    }

    public BaseResponse<BaseIdRespVO> updateAccountNo(@RequestBody @Validated AccountNoUpdateReqVO accountNoUpdateReqVO, @RequestHeader(value="accessToken") String accessToken) {
        MdcUtil.setCallerUserMethod((String)accountNoUpdateReqVO.getAppCode(), (String)accountNoUpdateReqVO.getAccountId(), (String)"\u767b\u5f55\u5e10\u53f7\u4fee\u6539");
        return this.accountService.updateAccountNo(accountNoUpdateReqVO, accessToken);
    }

    public BaseResponse<BaseIdRespVO> pwdVerify(@RequestBody @Validated AccountOperateBaseReqVO accountPwdVerifyReqVO) {
        MdcUtil.setCallerUserMethod((String)accountPwdVerifyReqVO.getAppCode(), (String)accountPwdVerifyReqVO.getAccountId(), (String)"\u767b\u5f55\u5bc6\u7801\u6821\u9a8c");
        return this.accountService.pwdVerify(accountPwdVerifyReqVO);
    }

    public BaseResponse<CheckAccountRepeatRespVO> accountNoVerify(@RequestBody @Validated CheckAccountRepeatReqVO checkAccountRepeatReqVO) {
        MdcUtil.setCallerUserMethod((String)checkAccountRepeatReqVO.getAppCode(), (String)checkAccountRepeatReqVO.getAccountNo(), (String)"\u68c0\u67e5\u8d26\u6237");
        return this.accountService.accountNoVerify(checkAccountRepeatReqVO);
    }

    public BaseResponse<BaseUserCenterIdRespVO> getbackpassword(@RequestBody @Validated GetbackPasswordReqVO getbackPasswordReqVO, HttpServletRequest request) {
        MdcUtil.setCallerUserMethod((String)getbackPasswordReqVO.getAppCode(), (String)getbackPasswordReqVO.getAccountNo(), (String)"\u5fd8\u8bb0\u5bc6\u7801");
        String headerIp = CommonsUtils.getRealIp((HttpServletRequest)request);
        getbackPasswordReqVO.setLoginIp(headerIp);
        return this.accountService.getbackPassword(getbackPasswordReqVO);
    }

    public BaseResponse<WechatRespVO> getWxApplet(@RequestBody @Validated WxAppletReqVO wxAppletReqVO) {
        return this.accountService.getWxApplet(wxAppletReqVO);
    }

    public BaseResponse<WechatRespVO> wxLogin(@RequestBody @Validated WeChatLoginReqVO weChatLoginReqVO) {
        MdcUtil.setCallerUserMethod((String)weChatLoginReqVO.getAppCode(), (String)weChatLoginReqVO.getOpenId(), (String)"\u5fae\u4fe1\u6388\u6743\u767b\u5f55");
        return this.accountService.wxLogin(weChatLoginReqVO);
    }

    public BaseResponse<AccountLoginRespVO> smsLogin(@RequestBody @Validated CusSmsLoginReqVO reqVO, HttpServletRequest request) {
        MdcUtil.setCallerUserMethod((String)reqVO.getAppCode(), (String)reqVO.getChannelCode(), (String)"\u77ed\u4fe1\u9a8c\u8bc1\u7801\u767b\u5f55");
        String headerIp = CommonsUtils.getRealIp((HttpServletRequest)request);
        reqVO.setLoginIp(headerIp);
        return this.accountService.smsLogin(reqVO);
    }

    public BaseResponse<BaseUserCenterIdRespVO> register(@RequestBody @Validated UserRigisterReqVO userRigisterReqVO) {
        MdcUtil.setCallerUserMethod((String)userRigisterReqVO.getAppCode(), (String)userRigisterReqVO.getAccountNo(), (String)"\u8d26\u6237\u6ce8\u518c");
        return this.accountService.register(userRigisterReqVO);
    }

    public BaseResponse<BaseUserCenterIdRespVO> wxBinding(@RequestBody WxBindingReqVo wxBindingReqVo) {
        return this.accountService.wxBinding(wxBindingReqVo);
    }

    public BaseResponse<UcWxAuthRespVo> getWxAuthByCondition(@RequestBody UcWxAuthReqVo ucWxAuthReqVo) {
        return this.ucWxAuthService.getWxAuthByCondition(ucWxAuthReqVo);
    }

    public BaseResponse<String> getPhoneNumber(String encrypdata, String ivdata, String sessionId) {
        return this.ucWxAuthService.getPhoneNumber(encrypdata, ivdata, sessionId);
    }

    public BaseResponse<Boolean> validateAccessToken(@RequestParam(value="accessToken") String accessToken) {
        Boolean token = this.accessTokenService.validateAccessToken(accessToken);
        if (token.booleanValue()) {
            return new BaseResponse("1", "\u64cd\u4f5c\u6210\u529f", (Object)true);
        }
        log.info("\u7f51\u5173token\u6821\u9a8c \u6821\u9a8c\u8bf7\u6c42 \u5931\u8d25 accessToken\uff1a{}", (Object)accessToken);
        return new BaseResponse("0", "\u64cd\u4f5c\u5931\u8d25", (Object)false);
    }

    public BaseResponse<VercodeRespVo> getVercode(@RequestParam(required=false, defaultValue="100") int width, @RequestParam(required=false, defaultValue="40") int height) {
        VerifyCodeUtil vc = new VerifyCodeUtil();
        if (height != 0 && width != 0) {
            vc.setHeight(height);
            vc.setWidth(width);
        }
        BufferedImage image = vc.getImage();
        String text = vc.getText();
        String random = RandomUtil.getRandom();
        this.redisUtil.set("vercode_" + random, (Object)text, 600L);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", baos);
        }
        catch (IOException e) {
            log.info("\u83b7\u53d6\u56fe\u6587\u9a8c\u8bc1\u7801 \u5f02\u5e38", (Object)e.getMessage());
            e.printStackTrace();
        }
        byte[] bytes = baos.toByteArray();
        BASE64Encoder encoder = new BASE64Encoder();
        String png_base64 = encoder.encodeBuffer(bytes).trim();
        png_base64 = png_base64.replaceAll("\n", "").replaceAll("\r", "");
        VercodeRespVo vercodeRespVo = new VercodeRespVo();
        vercodeRespVo.setVercodeKey("vercode_" + random);
        vercodeRespVo.setPng_base64("data:image/jpeg;base64," + png_base64);
        log.info("\u83b7\u53d6\u56fe\u6587\u9a8c\u8bc1\u7801 \u9a8c\u8bc1\u7801:" + text);
        return new BaseResponse("1", "\u64cd\u4f5c\u6210\u529f", (Object)vercodeRespVo);
    }

    public BaseResponse<GetWxOpenidRespVO> getWxOpenid(@RequestBody GetWxOpenidReqVO getWxOpenidReqVO) {
        return this.accountService.getWxOpenid(getWxOpenidReqVO);
    }
}

