/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.interceptor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ebaiyihui.common.enums.ErrorEnum;
import com.ebaiyihui.common.pojo.annotation.AccessCheck;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.server.interceptor.ApiAccessInterceptor;
import com.ebaiyihui.server.service.IAccessTokenService;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class ApiAccessInterceptor
extends HandlerInterceptorAdapter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAccessTokenService accessTokenService;
    private static final String AUTHORIZATION_FIELD = "accessToken";

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Class clazz = handlerMethod.getBeanType();
            Method method = handlerMethod.getMethod();
            try {
                if (clazz != null && method != null) {
                    boolean isClzAnnotation = clazz.isAnnotationPresent(AccessCheck.class);
                    boolean isMethondAnnotation = method.isAnnotationPresent(AccessCheck.class);
                    AccessCheck secure = null;
                    if (isMethondAnnotation) {
                        secure = method.getAnnotation(AccessCheck.class);
                    } else if (isClzAnnotation) {
                        secure = clazz.getAnnotation(AccessCheck.class);
                    } else {
                        return true;
                    }
                    AccessCheck.PermissionType value = secure.value();
                    boolean authenticated = true;
                    switch (1.$SwitchMap$com$ebaiyihui$common$pojo$annotation$AccessCheck$PermissionType[value.ordinal()]) {
                        case 1: {
                            authenticated = true;
                            break;
                        }
                        case 2: {
                            authenticated = this.checkAccessToken(request, method);
                            this.log.info("\u6743\u9650token\u6821\u9a8c\u63a5\u53e3 ACCESS_TOKEN_API \u6821\u9a8c\u7ed3\u679c\uff1a" + authenticated);
                            break;
                        }
                        case 3: 
                        case 4: {
                            authenticated = true;
                            break;
                        }
                        default: {
                            authenticated = false;
                        }
                    }
                    if (!authenticated) {
                        this.buildErrorResponse(response);
                        return false;
                    }
                }
            }
            catch (Exception e) {
                this.buildErrorResponse(response);
                this.log.error("\u6743\u9650\u6821\u9a8c\u4ea7\u751f\u5f02\u5e38,\u8bbf\u95ee\u63a5\u53e3\u540d\u79f0[{}],\u8bf7\u6c42\u53c2\u6570[{}],\u8bf7\u6c42\u5934\u53c2\u6570[{}]", new Object[]{method.getName(), this.getRequestParams(request), request.getHeader(AUTHORIZATION_FIELD)});
                return false;
            }
            return true;
        }
        return true;
    }

    private void buildErrorResponse(HttpServletResponse response) throws IOException {
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/json; charset=utf-8");
        PrintWriter writer = response.getWriter();
        writer.write(JSON.toJSONString((Object)BaseResponse.error((IError)ErrorEnum.NO_PERMISSION), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullStringAsEmpty}));
        writer.close();
    }

    private boolean checkAccessToken(HttpServletRequest request, Method method) {
        String authCode = request.getHeader(AUTHORIZATION_FIELD);
        String interfaceName = method.getName();
        if (StringUtils.isBlank((String)authCode)) {
            this.log.error("\u8bf7\u6c42\u4e2d\u672a\u83b7\u53d6\u5230AccessToken,\u8bbf\u95ee\u63a5\u53e3\u540d\u79f0[{}],\u8bf7\u6c42\u53c2\u6570[{}]", (Object)interfaceName, (Object)this.getRequestParams(request));
            return false;
        }
        if (!this.accessTokenService.validateAccessToken(authCode).booleanValue()) {
            this.log.error("AccessToken\u5408\u6cd5\u6027\u6821\u9a8c\u5931\u8d25,\u8bbf\u95ee\u63a5\u53e3\u540d\u79f0[{}],\u8bf7\u6c42\u53c2\u6570[{}]", (Object)interfaceName, (Object)this.getRequestParams(request));
            return false;
        }
        return true;
    }

    private Map<String, String> getRequestParams(HttpServletRequest request) {
        Enumeration names = request.getParameterNames();
        HashMap<String, String> map = new HashMap<String, String>();
        while (names.hasMoreElements()) {
            String paraKey = (String)names.nextElement();
            String paraValue = request.getParameter(paraKey);
            map.put(paraKey, paraValue);
        }
        return map;
    }
}

