/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service;

import com.ebaiyihui.common.enums.ErrorEnum;
import com.ebaiyihui.common.token.TokenBody;
import com.ebaiyihui.common.token.TokenJson;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.server.config.UniqueID;
import com.ebaiyihui.server.enums.AccountEnums;
import com.ebaiyihui.server.enums.UserEnums;
import com.ebaiyihui.server.exception.UserCenterRuntimeException;
import com.ebaiyihui.server.pojo.entity.UcAccountEntity;
import com.ebaiyihui.server.pojo.entity.UcAppTokenKeyEntity;
import com.ebaiyihui.server.pojo.entity.UcDoctorUserEntity;
import com.ebaiyihui.server.pojo.entity.UcManagerUserEntity;
import com.ebaiyihui.server.pojo.entity.UcOrganUserEntity;
import com.ebaiyihui.server.pojo.entity.UcPatientUserEntity;
import com.ebaiyihui.server.repository.UcAccountMapper;
import com.ebaiyihui.server.repository.UcAccountOperateMapper;
import com.ebaiyihui.server.repository.UcAppTokenKeyMapper;
import com.ebaiyihui.server.repository.UcCardBindLogMapper;
import com.ebaiyihui.server.repository.UcDoctorUserMapper;
import com.ebaiyihui.server.repository.UcLoginRecordMapper;
import com.ebaiyihui.server.repository.UcManageOperateMapper;
import com.ebaiyihui.server.repository.UcManagerUserMapper;
import com.ebaiyihui.server.repository.UcOrganUserMapper;
import com.ebaiyihui.server.repository.UcPatientInfoMapper;
import com.ebaiyihui.server.repository.UcPatientOperateMapper;
import com.ebaiyihui.server.repository.UcPatientUserMapper;
import com.ebaiyihui.server.repository.UcUserCardBindMapper;
import com.ebaiyihui.server.repository.UcWxAuthMapper;
import com.ebaiyihui.server.util.RedisUtil;
import com.ebaiyihui.server.util.Tokenutil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public abstract class BaseService {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected UcDoctorUserMapper ucDoctorUserMapper;
    @Autowired
    protected UcOrganUserMapper ucOrganUserMapper;
    @Autowired
    protected UcManagerUserMapper ucManagerUserMapper;
    @Autowired
    protected UcPatientUserMapper ucPatientUserMapper;
    @Autowired
    protected UcAccountMapper ucAccountMapper;
    @Autowired
    protected UniqueID uniqueID;
    @Autowired
    protected UcLoginRecordMapper ucLoginRecordMapper;
    @Autowired
    protected UcAccountOperateMapper ucAccountOperateMapper;
    @Autowired
    protected UcPatientInfoMapper ucPatientInfoMapper;
    @Autowired
    protected UcManageOperateMapper ucManageOperateMapper;
    @Autowired
    protected UcWxAuthMapper ucWxAuthMapper;
    @Autowired
    protected UcAppTokenKeyMapper ucAppTokenKeyMapper;
    @Autowired
    protected UcPatientOperateMapper ucPatientOperateMapper;
    @Autowired
    protected UcCardBindLogMapper cardBindLogMapper;
    @Autowired
    protected UcUserCardBindMapper cardBindMapper;
    @Autowired
    protected RedisUtil redisUtil;
    private static final String REGEX_PHONE = "^(13[0-9]|141|14[4-9]|15[0-3]|15[5-9]|166|17[0-1]|17[3-8]|18[0-9]|19[8-9])\\d{8}$";

    protected List<UcAccountEntity> getAllAccounts(String accountNo, Short userType, String appCode) {
        if (StringUtils.isEmpty((Object)accountNo) || StringUtils.isEmpty((Object)appCode) || userType == null) {
            this.log.warn("\u83b7\u53d6\u6240\u6709\u72b6\u6001\u7684\u8d26\u6237\u5931\u8d25,\u53c2\u6570\u7f3a\u5931,accountNo={},userType={},appCode={}", new Object[]{accountNo, userType, appCode});
            throw new UserCenterRuntimeException(IError.PARAM_CHECK_FAILD, "\u83b7\u53d6\u6240\u6709\u72b6\u6001\u7684\u8d26\u6237\u53c2\u6570\u7f3a\u5931");
        }
        List list = this.ucAccountMapper.selectListByaccountNoAndUserTypeAndAppCode(accountNo, userType, appCode);
        return list;
    }

    protected UcAccountEntity getAccount(String accountNo, Short userType, String appCode) {
        if (StringUtils.isEmpty((Object)accountNo) || StringUtils.isEmpty((Object)appCode) || userType == null) {
            this.log.warn("\u83b7\u53d6\u552f\u4e00\u975e\u6ce8\u9500\u72b6\u6001\u7684\u8d26\u6237\u5931\u8d25,\u53c2\u6570\u7f3a\u5931,accountNo={},userType={},appCode={}", new Object[]{accountNo, userType, appCode});
            throw new UserCenterRuntimeException(IError.PARAM_CHECK_FAILD, "\u83b7\u53d6\u552f\u4e00\u975e\u6ce8\u9500\u72b6\u6001\u7684\u8d26\u6237\u53c2\u6570\u7f3a\u5931");
        }
        List list = this.getAllAccounts(accountNo, userType, appCode);
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (UcAccountEntity ucAccountEntity : list) {
            if (AccountEnums.AccountStatusEnum.CANCELLATION.getValue().equals(ucAccountEntity.getStatus())) continue;
            return ucAccountEntity;
        }
        return null;
    }

    protected UcAccountEntity getAccountByUserId(String userId, Short userType, String appCode) {
        if (StringUtils.isEmpty((Object)userId) || StringUtils.isEmpty((Object)appCode) || userType == null) {
            this.log.warn("\u83b7\u53d6\u975e\u6ce8\u9500\u72b6\u6001\u7684\u8d26\u6237\u5931\u8d25,\u53c2\u6570\u7f3a\u5931,userId={},userType={},appCode={}", new Object[]{userId, userType, appCode});
            throw new UserCenterRuntimeException(IError.PARAM_CHECK_FAILD, "\u83b7\u53d6\u975e\u6ce8\u9500\u72b6\u6001\u7684\u8d26\u6237\u53c2\u6570\u7f3a\u5931");
        }
        List list = this.ucAccountMapper.selectListByUserIdAndUserTypeAndAppCode(userId, userType, appCode);
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<UcAccountEntity> accounts = new ArrayList<UcAccountEntity>();
        for (UcAccountEntity ucAccountEntity : list) {
            if (AccountEnums.AccountStatusEnum.CANCELLATION.getValue().equals(ucAccountEntity.getStatus())) continue;
            if (AccountEnums.AccountTypeEnum.CELL_PHONE.getValue().equals(ucAccountEntity.getAccountType())) {
                return ucAccountEntity;
            }
            accounts.add(ucAccountEntity);
        }
        if (!accounts.isEmpty()) {
            return (UcAccountEntity)accounts.get(0);
        }
        return null;
    }

    protected TokenBody getTokenBody(String token, String appCode) {
        if (StringUtils.isEmpty((Object)token)) {
            this.log.warn("\u83b7\u53d6TokenBody,\u53c2\u6570\u7f3a\u5931,token={},appCode={}", (Object)token, (Object)appCode);
            throw new UserCenterRuntimeException(IError.PARAM_CHECK_FAILD, "\u83b7\u53d6TokenBody\u53c2\u6570\u7f3a\u5931");
        }
        String secryKey = this.getSecryKey(appCode);
        try {
            TokenBody tokenBody = Tokenutil.parse((String)token, (String)secryKey);
            return tokenBody;
        }
        catch (Exception e) {
            this.log.warn("TOKEN\u89e3\u6790\u5931\u8d25\uff0cappCode={},token={}", (Object)appCode, (Object)token);
            throw new UserCenterRuntimeException(ErrorEnum.TOKEN_PARSE_FAIL, "TOKEN\u89e3\u6790\u5931\u8d25");
        }
    }

    protected String getSecryKey(String appCode) {
        String secryKey = (String)this.redisUtil.get(appCode);
        if (secryKey == null) {
            UcAppTokenKeyEntity entity = this.ucAppTokenKeyMapper.getByAppCode(appCode);
            if (entity == null) {
                this.log.warn("token\u5bc6\u94a5\u67e5\u8be2\u5931\u8d25\uff0cappCode={}", (Object)appCode);
                throw new UserCenterRuntimeException(ErrorEnum.TOKEN_SECRYKEY_NOT_EXIST);
            }
            secryKey = entity.getKey();
            this.redisUtil.set(appCode, (Object)secryKey);
        }
        return secryKey;
    }

    protected TokenJson getTokenJson(String token, String appCode) {
        if (StringUtils.isEmpty((Object)token)) {
            this.log.warn("\u83b7\u53d6TokenJson,\u53c2\u6570\u7f3a\u5931,token={},appCode={}", (Object)token, (Object)appCode);
            throw new UserCenterRuntimeException(IError.PARAM_CHECK_FAILD, "\u83b7\u53d6TokenJson\u53c2\u6570\u7f3a\u5931");
        }
        TokenBody tokenBody = this.getTokenBody(token, appCode);
        return tokenBody.getTokenJson();
    }

    protected void checkAccountNoRightByAccountType(String accountNo, Short accountType) {
        if (StringUtils.isEmpty((Object)accountNo) || accountType == null) {
            this.log.warn("\u901a\u8fc7\u8d26\u6237\u7c7b\u578b\u6821\u9a8c\u8d26\u6237\u6821\u9a8c\u5931\u8d25,\u53c2\u6570\u7f3a\u5931,accountNo={},accountType={}", (Object)accountNo, (Object)accountType);
            throw new UserCenterRuntimeException(IError.PARAM_CHECK_FAILD, "\u901a\u8fc7\u8d26\u6237\u7c7b\u578b\u6821\u9a8c\u8d26\u6237\u53c2\u6570\u7f3a\u5931");
        }
        switch (accountType) {
            case 0: {
                if (Pattern.matches(REGEX_PHONE, accountNo)) break;
                throw new UserCenterRuntimeException(IError.PARAM_CHECK_FAILD, "\u9519\u8bef\u7684\u767b\u5f55\u624b\u673a\u53f7\u7801");
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new UserCenterRuntimeException(IError.PARAM_CHECK_FAILD, "\u672a\u77e5\u7684\u8d26\u6237\u7c7b\u578b");
            }
        }
    }

    protected UcAccountEntity getRightAccount(String accountId) {
        UcAccountEntity account = this.ucAccountMapper.findByAccountId(accountId);
        if (account == null || AccountEnums.AccountStatusEnum.CANCELLATION.getValue().equals(account.getStatus())) {
            this.log.warn("\u8d26\u6237\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u6ce8\u9500,accountId={}", (Object)accountId);
            throw new UserCenterRuntimeException(ErrorEnum.NO_ACCOUNT);
        }
        if (AccountEnums.AccountStatusEnum.PROHIBIT.getValue().equals(account.getStatus())) {
            this.log.warn("\u8d26\u6237\u5df2\u7981\u7528,accountId={}", (Object)accountId);
            throw new UserCenterRuntimeException(ErrorEnum.DISABLED_ACCOUNT);
        }
        return account;
    }

    protected UcPatientUserEntity getPatientUserEntity(String userId) {
        Optional optional = this.ucPatientUserMapper.findByUserId(userId);
        if (!optional.isPresent()) {
            this.log.warn("\u67e5\u8be2\u60a3\u8005\u7528\u6237\u4e0d\u5b58\u5728,userId={}", (Object)userId);
            throw new UserCenterRuntimeException(ErrorEnum.USER_NOT_EXIT);
        }
        UcPatientUserEntity user = (UcPatientUserEntity)optional.get();
        if (UserEnums.UserStatusEnum.CANCELLATION.getUserStatusValue().equals(user.getUserStatus())) {
            this.log.warn("\u60a3\u8005\u7528\u6237\u5df2\u88ab\u6ce8\u9500,userId={}", (Object)userId);
            throw new UserCenterRuntimeException(ErrorEnum.USER_NOT_EXIT);
        }
        if (UserEnums.UserStatusEnum.PROHIBIT.getUserStatusValue().equals(user.getUserStatus())) {
            this.log.warn("\u60a3\u8005\u7528\u6237\u5df2\u88ab\u7981\u7528,userId={}", (Object)userId);
            throw new UserCenterRuntimeException(ErrorEnum.DISABLED_USER, "\u7528\u6237\u5df2\u7ecf\u88ab\u7981\u7528");
        }
        return user;
    }

    protected UcDoctorUserEntity getDoctorUserEntity(String userId) {
        Optional optional = this.ucDoctorUserMapper.selectByUserId(userId);
        if (!optional.isPresent()) {
            this.log.warn("\u67e5\u8be2\u533b\u751f\u7528\u6237\u4e0d\u5b58\u5728,userId={}", (Object)userId);
            throw new UserCenterRuntimeException(ErrorEnum.USER_NOT_EXIT);
        }
        UcDoctorUserEntity user = (UcDoctorUserEntity)optional.get();
        if (UserEnums.UserStatusEnum.CANCELLATION.getUserStatusValue().equals(user.getUserStatus())) {
            this.log.warn("\u533b\u751f\u7528\u6237\u5df2\u88ab\u6ce8\u9500,userId={}", (Object)userId);
            throw new UserCenterRuntimeException(ErrorEnum.USER_NOT_EXIT);
        }
        if (UserEnums.UserStatusEnum.PROHIBIT.getUserStatusValue().equals(user.getUserStatus())) {
            this.log.warn("\u533b\u751f\u7528\u6237\u5df2\u88ab\u7981\u7528,userId={}", (Object)userId);
            throw new UserCenterRuntimeException(ErrorEnum.DISABLED_USER, "\u7528\u6237\u5df2\u7ecf\u88ab\u7981\u7528");
        }
        return user;
    }

    protected UcManagerUserEntity getManagerUserEntity(String userId) {
        Optional optional = this.ucManagerUserMapper.selectByUserId(userId);
        if (!optional.isPresent()) {
            this.log.warn("\u67e5\u8be2\u7ba1\u7406\u5458\u7528\u6237\u4e0d\u5b58\u5728,userId={}", (Object)userId);
            throw new UserCenterRuntimeException(ErrorEnum.USER_NOT_EXIT);
        }
        UcManagerUserEntity user = (UcManagerUserEntity)optional.get();
        if (UserEnums.UserStatusEnum.CANCELLATION.getUserStatusValue().equals(user.getUserStatus())) {
            this.log.warn("\u7ba1\u7406\u5458\u7528\u6237\u5df2\u88ab\u6ce8\u9500,userId={}", (Object)userId);
            throw new UserCenterRuntimeException(ErrorEnum.USER_NOT_EXIT);
        }
        if (UserEnums.UserStatusEnum.PROHIBIT.getUserStatusValue().equals(user.getUserStatus())) {
            this.log.warn("\u7ba1\u7406\u5458\u7528\u6237\u5df2\u88ab\u7981\u7528,userId={}", (Object)userId);
            throw new UserCenterRuntimeException(ErrorEnum.DISABLED_USER, "\u7528\u6237\u5df2\u7ecf\u88ab\u7981\u7528");
        }
        return user;
    }

    protected UcOrganUserEntity getOrganUserEntity(String userId) {
        Optional optional = this.ucOrganUserMapper.selectByUserId(userId);
        if (!optional.isPresent()) {
            this.log.warn("\u67e5\u8be2\u673a\u6784\u7528\u6237\u4e0d\u5b58\u5728,userId={}", (Object)userId);
            throw new UserCenterRuntimeException(ErrorEnum.USER_NOT_EXIT);
        }
        UcOrganUserEntity user = (UcOrganUserEntity)optional.get();
        if (UserEnums.UserStatusEnum.CANCELLATION.getUserStatusValue().equals(user.getUserStatus())) {
            this.log.warn("\u673a\u6784\u7528\u6237\u5df2\u88ab\u6ce8\u9500,userId={}", (Object)userId);
            throw new UserCenterRuntimeException(ErrorEnum.USER_NOT_EXIT);
        }
        if (UserEnums.UserStatusEnum.PROHIBIT.getUserStatusValue().equals(user.getUserStatus())) {
            this.log.warn("\u673a\u6784\u7528\u6237\u5df2\u88ab\u7981\u7528,userId={}", (Object)userId);
            throw new UserCenterRuntimeException(ErrorEnum.DISABLED_USER, "\u7528\u6237\u5df2\u7ecf\u88ab\u7981\u7528");
        }
        return user;
    }

    protected UcAccountEntity getDoctorAccount(String doctorId, String appCode) {
        List userIds = this.ucDoctorUserMapper.findByDoctorIdAndAppCode(doctorId, appCode);
        if (userIds == null || userIds.isEmpty()) {
            return null;
        }
        UcAccountEntity account = this.getAccountByUserId((String)userIds.get(0), UserEnums.UserTypeEnum.DOCTOR.getUserTypeValue(), appCode);
        return account;
    }

    public Boolean isVercodePhone(String phoneNum) {
        if (phoneNum == null) {
            return false;
        }
        if (this.redisUtil.hasKey(ErrorEnum.VERCODE_NEED_PHONENUM + "_" + phoneNum)) {
            int loginCount = (Integer)this.redisUtil.get(ErrorEnum.VERCODE_NEED_PHONENUM + "_" + phoneNum);
            if (loginCount >= 10) {
                this.log.info("\u540c\u4e00\u4e2a\u624b\u673a\u53f7\u572824\u5c0f\u65f6\u5185\u51fa\u73b0\u8d85\u8fc710\u6b21\uff0c\u6b21\u6570\uff1a{},ip:{}", (Object)loginCount, (Object)phoneNum);
                return true;
            }
            long expire = this.redisUtil.getExpire(ErrorEnum.VERCODE_NEED_PHONENUM + "_" + phoneNum);
            ++loginCount;
            if (expire <= 0L) {
                expire = 86400L;
                loginCount = 1;
            }
            this.redisUtil.set(ErrorEnum.VERCODE_NEED_PHONENUM + "_" + phoneNum, (Object)loginCount, expire, TimeUnit.SECONDS);
            this.log.info("\u540c\u4e00\u4e2a\u624b\u673a\u53f7\u572824\u5c0f\u65f6\u5185\u51fa\u73b0\u6b21\u6570loginCount:{},ip:{}", (Object)loginCount, (Object)phoneNum);
            return false;
        }
        long expire = 86400L;
        int loginCount = 1;
        this.redisUtil.set(ErrorEnum.VERCODE_NEED_PHONENUM + "_" + phoneNum, (Object)loginCount, expire, TimeUnit.SECONDS);
        this.log.info("\u540c\u4e00\u4e2a\u624b\u673a\u53f7\u572824\u5c0f\u65f6\u5185\u51fa\u73b0\u6b21\u6570loginCount:{},ip:{}", (Object)loginCount, (Object)phoneNum);
        return false;
    }

    public Boolean isVercodeIP(String loginIp) {
        if (loginIp == null) {
            return false;
        }
        if (this.redisUtil.hasKey(ErrorEnum.VERCODE_NEED_IP + "_" + loginIp)) {
            int loginCount = (Integer)this.redisUtil.get(ErrorEnum.VERCODE_NEED_IP + "_" + loginIp);
            if (loginCount > 20) {
                this.log.info("\u540c\u4e00\u4e2aIP\u572824\u5c0f\u65f6\u5185\u51fa\u73b0\u8d85\u8fc720\u6b21\uff0c\u6b21\u6570\uff1a{},ip:{}", (Object)loginCount, (Object)loginIp);
                return true;
            }
            long expire = this.redisUtil.getExpire(ErrorEnum.VERCODE_NEED_IP + "_" + loginIp);
            ++loginCount;
            if (expire <= 0L) {
                expire = 86400L;
                loginCount = 1;
            }
            this.redisUtil.set(ErrorEnum.VERCODE_NEED_IP + "_" + loginIp, (Object)loginCount, expire, TimeUnit.SECONDS);
            this.log.info("\u540c\u4e00\u4e2aIP\u572824\u5c0f\u65f6\u5185\u767b\u5f55\u6b21\u6570\uff0c\u6b21\u6570\uff1a{},ip:{}", (Object)loginCount, (Object)loginIp);
            return false;
        }
        long expire = 86400L;
        int loginCount = 1;
        this.redisUtil.set(ErrorEnum.VERCODE_NEED_IP + "_" + loginIp, (Object)loginCount, expire, TimeUnit.SECONDS);
        this.log.info("\u540c\u4e00\u4e2aIP\u572824\u5c0f\u65f6\u5185\u767b\u5f55\u6b21\u6570\uff0c\u6b21\u6570\uff1a{},ip:{}", (Object)loginCount, (Object)loginIp);
        return false;
    }

    public boolean verifyVercode(String vercodeKey, String vercodeValue) {
        Object vercode = "";
        if (!StringUtils.isEmpty((Object)vercodeKey) && !StringUtils.isEmpty((Object)vercodeValue) && (vercode = this.redisUtil.get(vercodeKey)) != null && vercodeValue.equalsIgnoreCase((String)vercode)) {
            this.log.info("\u56fe\u6587\u9a8c\u8bc1\u901a\u8fc7  \u5165\u53c2\uff1a{},\u5b9e\u9645\u9a8c\u8bc1\u7801\uff1a{}", (Object)vercodeValue, vercode);
            return true;
        }
        this.log.info("\u56fe\u6587\u9a8c\u8bc1\u4e0d\u6b63\u786e \u5165\u53c2\uff1a{},\u5b9e\u9645\u9a8c\u8bc1\u7801\uff1a{}", (Object)vercodeValue, vercode);
        return false;
    }
}

