/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.ebaiyihui.common.token.TokenBody;
import com.ebaiyihui.common.token.TokenJson;
import com.ebaiyihui.server.service.IAccessTokenService;
import com.ebaiyihui.server.service.ICacheService;
import com.ebaiyihui.server.util.Tokenutil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccessTokenServiceImpl
implements IAccessTokenService {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICacheService cacheService;

    public Boolean validateAccessToken(String accessToken) {
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return false;
        }
        TokenBody parseToken = null;
        try {
            parseToken = Tokenutil.parse((String)accessToken, (String)"hxgy-ehospital");
        }
        catch (Exception e) {
            this.log.error("Token\u53c2\u6570\u89e3\u6790\u5931\u8d25\uff0cToken\u4fe1\u606f[{}]", (Object)accessToken);
            return false;
        }
        if (parseToken == null || !Tokenutil.validateToken((String)accessToken, (String)"hxgy-ehospital")) {
            this.log.error("Token\u5408\u6cd5\u6027\u5931\u8d25\uff0cToken\u4fe1\u606f[{}]", (Object)parseToken);
            return false;
        }
        TokenJson tokenJson = parseToken.getTokenJson();
        String tokenKey = Tokenutil.genTokenKey((String)tokenJson.getUserId(), (String)tokenJson.getAppCode(), (String)tokenJson.getDeviceType());
        String loginToken = this.validateTokenLogin(tokenKey);
        if (StringUtils.isBlank((CharSequence)loginToken)) {
            this.log.error("Token\u767b\u5f55\u4fe1\u606f\u5df2\u5931\u6548\uff0cToken\u4fe1\u606f[{}]", (Object)parseToken);
            return false;
        }
        if (!accessToken.equals(loginToken)) {
            this.log.error("Token\u767b\u5f55\u4fe1\u606f\u5df2\u5931\u6548\uff0c\u7528\u6237\u5728\u5176\u4ed6\u8bbe\u5907\u91cd\u65b0\u767b\u5f55,Token\u4fe1\u606f[{}]", (Object)accessToken);
            return false;
        }
        return true;
    }

    public String validateTokenLogin(String tokenKey) {
        return this.cacheService.getLoginToken(tokenKey);
    }
}

