/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import cn.binarywang.wx.miniapp.config.WxMaInMemoryConfig;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ebaiyihui.client.DataScopeClient;
import com.ebaiyihui.common.enums.ErrorEnum;
import com.ebaiyihui.common.enums.LoginDeviceType;
import com.ebaiyihui.common.pojo.login.BaseUserCenterIdRespVO;
import com.ebaiyihui.common.pojo.login.CheckAccountRepeatReqVO;
import com.ebaiyihui.common.pojo.login.CheckAccountRepeatRespVO;
import com.ebaiyihui.common.pojo.login.CusSmsLoginReqVO;
import com.ebaiyihui.common.pojo.login.SmsLoginReqVO;
import com.ebaiyihui.common.pojo.login.UserLoginReqVO;
import com.ebaiyihui.common.pojo.login.UserLoginRespVO;
import com.ebaiyihui.common.pojo.login.UserRigisterReqVO;
import com.ebaiyihui.common.pojo.login.WeChatLoginReqVO;
import com.ebaiyihui.common.pojo.login.WechatRespVO;
import com.ebaiyihui.common.pojo.login.WxBindingReqVo;
import com.ebaiyihui.common.pojo.vo.AccountLoginReqVO;
import com.ebaiyihui.common.pojo.vo.AccountLoginRespVO;
import com.ebaiyihui.common.pojo.vo.AccountLogoutIReqVO;
import com.ebaiyihui.common.pojo.vo.AccountLogoutReqVO;
import com.ebaiyihui.common.pojo.vo.AccountNoCheckReqVO;
import com.ebaiyihui.common.pojo.vo.AccountNoCheckRespVO;
import com.ebaiyihui.common.pojo.vo.AccountNoUpdateReqVO;
import com.ebaiyihui.common.pojo.vo.AccountOperateBaseReqVO;
import com.ebaiyihui.common.pojo.vo.AccountPasswordUpdateReqVO;
import com.ebaiyihui.common.pojo.vo.AccountRegisterBaseReqVO;
import com.ebaiyihui.common.pojo.vo.AccountRegisterReqVO;
import com.ebaiyihui.common.pojo.vo.BaseIdRespVO;
import com.ebaiyihui.common.pojo.vo.CloudAccountLoginReqVO;
import com.ebaiyihui.common.pojo.vo.DoctorAppLoginRespDoctor;
import com.ebaiyihui.common.pojo.vo.DoctorAppLoginRespImInfo;
import com.ebaiyihui.common.pojo.vo.DoctorAppLoginRespVO;
import com.ebaiyihui.common.pojo.vo.GetWxOpenidReqVO;
import com.ebaiyihui.common.pojo.vo.GetWxOpenidRespVO;
import com.ebaiyihui.common.pojo.vo.GetbackPasswordReqVO;
import com.ebaiyihui.common.pojo.vo.ResetPasswordReqVO;
import com.ebaiyihui.common.pojo.vo.UserCenterBaseReqVO;
import com.ebaiyihui.common.pojo.vo.UserInfoRespVO;
import com.ebaiyihui.common.pojo.vo.WxAppletReqVO;
import com.ebaiyihui.common.token.TokenBody;
import com.ebaiyihui.common.token.TokenJson;
import com.ebaiyihui.common.token.UserCenterTokenParseUtil;
import com.ebaiyihui.common.token.exception.TokenParseException;
import com.ebaiyihui.doctor.cilent.DoctorCilent;
import com.ebaiyihui.doctor.common.vo.doctor.FindBaseInfoReqVO;
import com.ebaiyihui.doctor.common.vo.doctor.FindBaseInfoResVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.framework.utils.JsonUtil;
import com.ebaiyihui.imforward.client.feignClient.IMClient;
import com.ebaiyihui.imforward.client.vo.IMQueryUserLoginReqVO;
import com.ebaiyihui.imforward.client.vo.IMQueryUserLoginRspVO;
import com.ebaiyihui.push.SmsApiClient;
import com.ebaiyihui.push.UmengApiClient;
import com.ebaiyihui.push.pojo.sms.SmsVerifiAuthCodeReqVO;
import com.ebaiyihui.push.pojo.umeng.android.AndroidUnicastReqVO;
import com.ebaiyihui.push.pojo.umeng.ios.IOSUnicastReqVO;
import com.ebaiyihui.server.enums.AccountEnums;
import com.ebaiyihui.server.enums.CommonEnums;
import com.ebaiyihui.server.enums.EHErrorEnum;
import com.ebaiyihui.server.enums.PushCenterContants;
import com.ebaiyihui.server.enums.UserEnums;
import com.ebaiyihui.server.enums.WxAuthEnums;
import com.ebaiyihui.server.exception.UserCenterRuntimeException;
import com.ebaiyihui.server.pojo.entity.UcAccountEntity;
import com.ebaiyihui.server.pojo.entity.UcAccountOperateEntity;
import com.ebaiyihui.server.pojo.entity.UcDoctorUserEntity;
import com.ebaiyihui.server.pojo.entity.UcLoginRecordEntity;
import com.ebaiyihui.server.pojo.entity.UcManagerUserEntity;
import com.ebaiyihui.server.pojo.entity.UcOrganUserEntity;
import com.ebaiyihui.server.pojo.entity.UcPatientInfoEntity;
import com.ebaiyihui.server.pojo.entity.UcPatientOperateEntity;
import com.ebaiyihui.server.pojo.entity.UcPatientUserEntity;
import com.ebaiyihui.server.pojo.entity.UcWxAuthEntity;
import com.ebaiyihui.server.pojo.entity.UserEntity;
import com.ebaiyihui.server.repository.UcWxAuthMapper;
import com.ebaiyihui.server.service.BaseService;
import com.ebaiyihui.server.service.IAccountService;
import com.ebaiyihui.server.service.ICacheService;
import com.ebaiyihui.server.service.IMessageService;
import com.ebaiyihui.server.service.IUserService;
import com.ebaiyihui.server.util.PasswordAndSalt;
import com.ebaiyihui.server.util.PasswordUtil;
import com.ebaiyihui.server.util.RandomUtil;
import com.ebaiyihui.server.util.RedisUtil;
import com.ebaiyihui.server.util.Tokenutil;
import com.ebaiyihui.server.util.WXLabelUtil;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.chanjar.weixin.common.error.WxErrorException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class AccountServiceImpl
extends BaseService
implements IAccountService {
    @Autowired
    private IUserService userService;
    @Autowired
    private ICacheService cacheService;
    @Autowired
    private IMessageService messageService;
    @Autowired
    private DoctorCilent baseDataDoctorFeignClient;
    @Autowired
    private IMClient imClient;
    @Autowired
    private UmengApiClient umengApiClient;
    @Autowired
    private SmsApiClient smsApiClient;
    @Autowired
    private UcWxAuthMapper ucWxAuthMapper;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private DataScopeClient dataScopeClient;
    @Value(value="${WXAppid}")
    String WXAppid;
    @Value(value="${WXSecret}")
    String WXSecret;
    @Value(value="${wxdeploy}")
    String wxDeploy;
    @Value(value="${doctoruser.domain}")
    String doctoruserDomain;
    private static final String SMS_DEL_FLAG = "D";
    public static final String JWT_SECRET = "hxgy-ehospital";

    public BaseResponse<UserLoginRespVO> login(UserLoginReqVO userLoginReqVO, String headerIp) {
        this.log.info("\u8d26\u6237\u767b\u5f55 \u8bf7\u6c42\u53c2\u6570{}", (Object)userLoginReqVO);
        AccountLoginReqVO userLoginReq = new AccountLoginReqVO();
        BeanUtils.copyProperties((Object)userLoginReqVO, (Object)userLoginReq);
        userLoginReq.setLoginIp(headerIp);
        userLoginReq.setLoginDeviceType(LoginDeviceType.valueOf((String)userLoginReqVO.getLoginDeviceType().toString()));
        BaseResponse loginResp = this.login(userLoginReq);
        this.log.info("\u8d26\u6237\u767b\u5f55 \u8c03\u7528\u7528\u6237\u4e2d\u5fc3\u8fd4\u56de\u53c2\u6570{}", (Object)loginResp);
        AccountLoginRespVO loginRespData = (AccountLoginRespVO)loginResp.getData();
        if ("0".equals(loginResp.getCode())) {
            this.log.info("\u8d26\u6237\u767b\u5f55\uff0c\u8fd4\u56de\u9519\u8bef\u4fe1\u606f{}", (Object)JsonUtil.convertObject((Object)loginResp.getMsg()));
            String errCode = loginResp.getErrCode();
            if (ErrorEnum.DISABLED_ACCOUNT.getErrCode().equals(errCode)) {
                return BaseResponse.error((IError)EHErrorEnum.LOGIN_PROHIBIT_ACCOUNT);
            }
            if (ErrorEnum.NO_ACCOUNT.getErrCode().equals(errCode) || ErrorEnum.INVALID_PASSWORD.getErrCode().equals(errCode)) {
                return BaseResponse.error((IError)EHErrorEnum.LOGIN_NO_ACCOUNT);
            }
            return this.getBaseResponse(loginResp.getErrCode(), loginResp.getMsg());
        }
        UserLoginRespVO userLoginResp = new UserLoginRespVO();
        BeanUtils.copyProperties((Object)loginRespData, (Object)userLoginResp);
        UserInfoRespVO userInfo = loginRespData.getUserInfoRespVO();
        userLoginResp.setContactMobile(userInfo.getContactMobile());
        userLoginResp.setHeadPortrait(userInfo.getHeadPortrait());
        userLoginResp.setName(userInfo.getName());
        this.log.info("\u8d26\u6237\u767b\u5f55 \u8fd4\u56de\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)userLoginResp));
        try {
            if (UserEnums.UserTypeEnum.MANAGER.getUserTypeValue().equals(userLoginReqVO.getUserType())) {
                BaseResponse cloudUserScope = this.dataScopeClient.getCloudUserScope(loginRespData.getUserId());
                String url = this.doctoruserDomain + "/api/v1/organ_auth/saveMgrDataAuth";
                this.restTemplate.postForObject(url, cloudUserScope.getData(), Map.class, new Object[0]);
                if ("0".equalsIgnoreCase(cloudUserScope.getCode())) {
                    this.log.info("\u767b\u5f55 \u83b7\u53d6\u7ba1\u7406\u5458\u6570\u636e\u6743\u9650 \u5f02\u5e38 code:{},msg:{}", ((Map)cloudUserScope.getData()).get("errCode"), ((Map)cloudUserScope.getData()).get("msg"));
                } else {
                    this.log.info("\u767b\u5f55 \u83b7\u53d6\u7ba1\u7406\u5458\u6570\u636e\u6743\u9650 \u6210\u529f map:{}", (Object)cloudUserScope);
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u767b\u5f55 \u83b7\u53d6\u7ba1\u7406\u5458\u6570\u636e\u6743\u9650 \u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
        return BaseResponse.success((Object)userLoginResp);
    }

    public BaseResponse<AccountLoginRespVO> login(AccountLoginReqVO accountLoginReqVO) {
        this.log.info("\u8d26\u6237\u767b\u5f55 \u8c03\u7528\u7528\u6237\u4e2d\u5fc3\u8bf7\u6c42\u53c2\u6570{}", (Object)accountLoginReqVO);
        if (StringUtils.isEmpty((Object)accountLoginReqVO.getVercodeKey()) && StringUtils.isEmpty((Object)accountLoginReqVO.getVercodeValue()) && LoginDeviceType.WEB.equals((Object)accountLoginReqVO.getLoginDeviceType()) && !UserEnums.UserTypeEnum.DOCTOR.getUserTypeValue().equals(accountLoginReqVO.getUserType()) && (super.isVercodeIP(accountLoginReqVO.getLoginIp()).booleanValue() || super.isVercodePhone(accountLoginReqVO.getAccountNo()).booleanValue())) {
            this.log.info("PC\u7aef\u767b\u5f55 \u9700\u8981\u8fdb\u884c\u56fe\u6587\u9a8c\u8bc1");
            return BaseResponse.error((IError)ErrorEnum.VERCODE_NEED_YES);
        }
        if (!(StringUtils.isEmpty((Object)accountLoginReqVO.getVercodeKey()) || StringUtils.isEmpty((Object)accountLoginReqVO.getVercodeValue()) || super.verifyVercode(accountLoginReqVO.getVercodeKey(), accountLoginReqVO.getVercodeValue()))) {
            return BaseResponse.error((IError)ErrorEnum.VERCODE_ERROR, (String)"\u56fe\u6587\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
        }
        UcAccountEntity account = this.validLoginAccount(accountLoginReqVO);
        this.log.info("\u9a8c\u8bc1\u767b\u5f55\u8d26\u53f7:{}", (Object)account);
        UserEntity userEntity = this.userService.getUserEntity(account.getUserId(), account.getUserType());
        if (userEntity == null) {
            this.log.warn("\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684\u7528\u6237\u4fe1\u606f,\u8bf7\u6c42\u4fe1\u606f[{}]" + accountLoginReqVO);
            throw new UserCenterRuntimeException(ErrorEnum.USER_NOT_EXIT);
        }
        String tokenKey = this.loginInfoValid((CloudAccountLoginReqVO)accountLoginReqVO, account);
        this.log.info("\u5237\u65b0token {}", (Object)tokenKey);
        String loginToken = this.genLoginToken((CloudAccountLoginReqVO)accountLoginReqVO, account, tokenKey);
        AccountLoginRespVO loginRespVO = this.createAccountLoginResp(account, userEntity, loginToken);
        return BaseResponse.success((Object)loginRespVO);
    }

    private BaseResponse getBaseResponse(String errCode, String msg) {
        BaseResponse response = new BaseResponse();
        response.setCode("0");
        response.setErrCode(errCode);
        response.setMsg(msg);
        return response;
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<BaseIdRespVO> register(AccountRegisterReqVO accountRegisterReqVO) {
        UcPatientUserEntity user;
        this.log.info("\u8d26\u6237\u6ce8\u518c\uff1a{}", (Object)accountRegisterReqVO);
        this.checkAccountNoRightByAccountType(accountRegisterReqVO.getAccountNo(), accountRegisterReqVO.getAccountType());
        List relationAccountList = accountRegisterReqVO.getRelationAccountList();
        this.checkAccountNoRepeat(accountRegisterReqVO.getAccountNo(), relationAccountList);
        this.checkAccountExist(accountRegisterReqVO);
        BaseIdRespVO data = new BaseIdRespVO();
        String userId = null;
        if (UserEnums.UserTypeEnum.PATIENT.getUserTypeValue().equals(accountRegisterReqVO.getUserType())) {
            this.buildPatientUserEntity(accountRegisterReqVO);
            user = this.buildPatientUserEntity(accountRegisterReqVO);
            this.ucPatientUserMapper.save(user);
            userId = user.getUserId();
            this.log.info("\u60a3\u8005\u7528\u6237\u6dfb\u52a0\u6210\u529f,\u8bf7\u6c42\u53c2\u6570={},\u60a3\u8005\u4fe1\u606f={}", (Object)JsonUtil.convertObject((Object)accountRegisterReqVO), (Object)JsonUtil.convertObject((Object)user));
        } else if (UserEnums.UserTypeEnum.DOCTOR.getUserTypeValue().equals(accountRegisterReqVO.getUserType())) {
            user = this.buildDoctorUserEntity(accountRegisterReqVO);
            this.ucDoctorUserMapper.save((UcDoctorUserEntity)user);
            userId = user.getUserId();
            this.log.info("\u533b\u751f\u7528\u6237\u6dfb\u52a0\u6210\u529f,\u8bf7\u6c42\u53c2\u6570={},\u533b\u751f\u4fe1\u606f={}", (Object)JsonUtil.convertObject((Object)accountRegisterReqVO), (Object)JsonUtil.convertObject((Object)user));
        } else if (UserEnums.UserTypeEnum.ORGAN.getUserTypeValue().equals(accountRegisterReqVO.getUserType())) {
            user = this.buildOrganUserEntity(accountRegisterReqVO);
            this.ucOrganUserMapper.save((UcOrganUserEntity)user);
            userId = user.getUserId();
            this.log.info("\u673a\u6784\u7528\u6237\u6dfb\u52a0\u6210\u529f,\u8bf7\u6c42\u53c2\u6570={},\u673a\u6784\u4fe1\u606f={}", (Object)JsonUtil.convertObject((Object)accountRegisterReqVO), (Object)JsonUtil.convertObject((Object)user));
        } else if (UserEnums.UserTypeEnum.MANAGER.getUserTypeValue().equals(accountRegisterReqVO.getUserType())) {
            user = this.buildManagerUserEntity(accountRegisterReqVO);
            this.ucManagerUserMapper.save((UcManagerUserEntity)user);
            userId = user.getUserId();
            this.log.info("\u7ba1\u7406\u5458\u7528\u6237\u6dfb\u52a0\u6210\u529f,\u8bf7\u6c42\u53c2\u6570={},\u7ba1\u7406\u5458\u4fe1\u606f={}", (Object)JsonUtil.convertObject((Object)accountRegisterReqVO), (Object)JsonUtil.convertObject((Object)user));
        } else {
            throw new UserCenterRuntimeException(IError.PARAM_CHECK_FAILD, "\u672a\u77e5\u7684\u7528\u6237\u7c7b\u578b");
        }
        data.setUserId(userId);
        UcAccountEntity account = new UcAccountEntity(accountRegisterReqVO, userId);
        String accountId = accountRegisterReqVO.getAccountId();
        if (StringUtils.isEmpty((Object)accountId)) {
            long accountIdValue = this.uniqueID.nextId();
            accountId = String.valueOf(accountIdValue);
            account.setAccountId(accountId);
            data.setAccountId(accountId);
        } else {
            account.setAccountId(accountId);
            data.setAccountId(accountId);
        }
        this.ucAccountMapper.save(account);
        this.log.info("\u65b0\u589e\u8d26\u6237 \u6dfb\u52a0\u6210\u529f,\u8bf7\u6c42\u53c2\u6570={},\u8d26\u6237\u4fe1\u606f={}", (Object)JsonUtil.convertObject((Object)accountRegisterReqVO), (Object)JsonUtil.convertObject((Object)account));
        UcAccountOperateEntity accountOperate = new UcAccountOperateEntity(accountRegisterReqVO.getChannelCode(), AccountEnums.AccountOperationEnum.REGISTER.getValue(), "\u6ce8\u518c\u8d26\u6237", accountId, JsonUtil.convertObject((Object)accountRegisterReqVO));
        this.ucAccountOperateMapper.save(accountOperate);
        if (relationAccountList != null && !relationAccountList.isEmpty()) {
            AccountRegisterReqVO tempAccountRegisterReqVO = new AccountRegisterReqVO();
            BeanUtils.copyProperties((Object)accountRegisterReqVO, (Object)tempAccountRegisterReqVO);
            for (AccountRegisterBaseReqVO accountRegisterBaseReqVO : relationAccountList) {
                tempAccountRegisterReqVO.setAccountNo(accountRegisterBaseReqVO.getAccountNo());
                tempAccountRegisterReqVO.setAccountType(accountRegisterBaseReqVO.getAccountType());
                UcAccountEntity tempAccount = new UcAccountEntity(tempAccountRegisterReqVO, userId);
                long tempAccountIdValue = this.uniqueID.nextId();
                tempAccount.setAccountId(String.valueOf(tempAccountIdValue));
                this.ucAccountMapper.save(tempAccount);
                UcAccountOperateEntity tempAccountOperate = new UcAccountOperateEntity(accountRegisterReqVO.getChannelCode(), AccountEnums.AccountOperationEnum.REGISTER.getValue(), accountRegisterReqVO.getName() + "\u5173\u8054\u6ce8\u518c\u8d26\u6237,\u4e3b\u8d26\u53f7accountId:" + data.getAccountId() + "\u6ce8\u518c\u8d26\u6237\u540d:" + accountRegisterReqVO.getAccountNo(), account.getAccountId(), JsonUtil.convertObject((Object)accountRegisterReqVO));
                this.ucAccountOperateMapper.save(tempAccountOperate);
                this.log.info("\u65b0\u589e\u5173\u8054\u8d26\u6237\u6dfb\u52a0,\u8bf7\u6c42\u53c2\u6570={},\u8d26\u6237\u4fe1\u606f={}", (Object)JsonUtil.convertObject((Object)accountRegisterReqVO), (Object)JsonUtil.convertObject((Object)tempAccountOperate));
            }
        }
        return BaseResponse.success((Object)data);
    }

    public BaseResponse<BaseUserCenterIdRespVO> register(UserRigisterReqVO userRigisterReqVO) {
        this.log.info("\u8d26\u6237\u6ce8\u518c\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)userRigisterReqVO));
        SmsVerifiAuthCodeReqVO smsVerifiAuthCodeReqVo = new SmsVerifiAuthCodeReqVO();
        smsVerifiAuthCodeReqVo.setAuthCode(userRigisterReqVO.getAuthCode());
        smsVerifiAuthCodeReqVo.setAuthKey(userRigisterReqVO.getAuthKey());
        smsVerifiAuthCodeReqVo.setOperate(SMS_DEL_FLAG);
        smsVerifiAuthCodeReqVo.setPhoneNum(userRigisterReqVO.getAccountNo());
        this.log.info("\u8d26\u6237\u6ce8\u518c\uff0c\u6821\u9a8c\u77ed\u4fe1\u9a8c\u8bc1\u7801\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)smsVerifiAuthCodeReqVo));
        BaseResponse checkMsgResp = this.smsApiClient.verifiSmsAuthCode(smsVerifiAuthCodeReqVo);
        this.log.info("\u8d26\u6237\u6ce8\u518c\uff0c\u6821\u9a8c\u77ed\u4fe1\u9a8c\u8bc1\u7801\uff0c\u8fd4\u56de\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)checkMsgResp));
        if ("0".equals(checkMsgResp.getCode())) {
            return checkMsgResp;
        }
        AccountRegisterReqVO accountRegisterReqVO = new AccountRegisterReqVO();
        BeanUtils.copyProperties((Object)userRigisterReqVO, (Object)accountRegisterReqVO);
        accountRegisterReqVO.setUserType(PushCenterContants.CUSTOMER_USER_TYPE);
        this.log.info("\u8d26\u6237\u6ce8\u518c\uff0c\u8c03\u7528\u7528\u6237\u4e2d\u5fc3\u8bf7\u6c42\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)accountRegisterReqVO));
        BaseResponse resp = this.register(accountRegisterReqVO);
        this.log.info("\u8d26\u6237\u6ce8\u518c\uff0c\u8c03\u7528\u7528\u6237\u4e2d\u5fc3\u8fd4\u56de\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)resp));
        return this.getUnionResponse(resp);
    }

    private BaseResponse<BaseUserCenterIdRespVO> getUnionResponse(BaseResponse<BaseIdRespVO> resp) {
        if ("0".equals(resp.getCode())) {
            this.log.warn("\u8c03\u7528\u5176\u4ed6\u670d\u52a1\u8fd4\u56de\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f{}", (Object)JsonUtil.convertObject((Object)resp.getMsg()));
            return this.getBaseResponse(resp.getErrCode(), resp.getMsg());
        }
        BaseIdRespVO respData = (BaseIdRespVO)resp.getData();
        BaseUserCenterIdRespVO userCompleteInfoResp = new BaseUserCenterIdRespVO();
        BeanUtils.copyProperties((Object)respData, (Object)userCompleteInfoResp);
        this.log.info("\u8fd4\u56de\u524d\u7aef\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)userCompleteInfoResp));
        return BaseResponse.success((Object)userCompleteInfoResp);
    }

    public BaseResponse<BaseUserCenterIdRespVO> logout(AccountLogoutIReqVO accountLogoutIReqVO, String headerIp, String accessToken) {
        this.log.info("\u8d26\u6237\u767b\u51fa\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)accountLogoutIReqVO));
        TokenBody tokenBody = this.parseToken(accessToken);
        if (tokenBody == null) {
            return BaseResponse.error((IError)ErrorEnum.TOKEN_PARSE_FAIL);
        }
        TokenJson tokenJson = tokenBody.getTokenJson();
        if (!this.checkToken(tokenJson, (UserCenterBaseReqVO)accountLogoutIReqVO)) {
            this.log.warn("token\u68c0\u9a8c\u5f02\u5e38\uff0ctokenJson{}", (Object)tokenJson);
            return BaseResponse.error((IError)ErrorEnum.TOKEN_PARSE_FAIL);
        }
        AccountLogoutReqVO accountLogoutReqVO = new AccountLogoutReqVO();
        accountLogoutReqVO.setChannelCode(accountLogoutIReqVO.getChannelCode());
        accountLogoutReqVO.setLoginIp(headerIp);
        accountLogoutReqVO.setDeviceNumber(accountLogoutIReqVO.getDeviceNumber());
        accountLogoutReqVO.setAppCode(accountLogoutIReqVO.getAppCode());
        accountLogoutReqVO.setAccountId(tokenJson.getAccountId());
        accountLogoutReqVO.setUserId(tokenJson.getUserId());
        accountLogoutReqVO.setDeviceType(tokenJson.getDeviceType());
        this.log.info("\u8d26\u6237\u767b\u51fa\uff0c\u8c03\u7528\u7528\u6237\u4e2d\u5fc3\u8bf7\u6c42\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)accountLogoutReqVO));
        BaseResponse resp = this.logout(accessToken, accountLogoutReqVO);
        this.log.info("\u8d26\u6237\u767b\u51fa\uff0c\u8c03\u7528\u7528\u6237\u4e2d\u5fc3\u8fd4\u56de\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)resp));
        return this.getUnionResponse(resp);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<BaseIdRespVO> logout(String token, AccountLogoutReqVO reqVO) {
        boolean delLoginToken;
        String accountId = reqVO.getAccountId();
        UcAccountEntity account = this.getRightAccount(accountId);
        String userId = reqVO.getUserId();
        String appCode = reqVO.getAppCode();
        TokenJson tokenJson = this.getTokenJson(token, appCode);
        if (!userId.equals(account.getUserId()) || !tokenJson.getUserId().equals(userId)) {
            this.log.warn("\u8d26\u6237\u767b\u51fa\uff0c\u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u7528\u6237ID\u4e0e\u8bf7\u6c42\u53c2\u6570\u4e2d\u7528\u6237ID\u4e0d\u5339\u914d\uff0c\u8bf7\u6c42\u53c2\u6570={}", (Object)JsonUtil.convertObject((Object)reqVO));
            return BaseResponse.error((IError)IError.PARAM_CHECK_FAILD);
        }
        String tokenKey = Tokenutil.genTokenKey((String)account.getUserId(), (String)tokenJson.getAppCode(), (String)tokenJson.getDeviceType());
        String cacheToken = this.cacheService.getLoginToken(tokenKey);
        if (cacheToken.equalsIgnoreCase(token) && !(delLoginToken = this.cacheService.delLoginToken(tokenKey))) {
            this.log.warn("\u767b\u51fa\u5931\u8d25\uff0c\u5220\u9664\u7528\u6237\u5386\u53f2\u767b\u5f55token\u5931\u8d25,\u672a\u5220\u9664Token[{}]" + cacheToken);
        }
        this.messageService.tokenInvalidMsg(cacheToken, CommonEnums.TokenInvalidCause.LOGOUT);
        UcLoginRecordEntity entity = this.bulidUcLoginRecordEntity(token, reqVO);
        this.ucLoginRecordMapper.save(entity);
        BaseIdRespVO data = new BaseIdRespVO();
        data.setAccountId(accountId);
        data.setUserId(userId);
        this.log.info("\u8d26\u6237\u767b\u51fa,\u4fdd\u5b58\u767b\u51fa\u8bb0\u5f55\uff0c\u8bf7\u6c42\u53c2\u6570={}\uff0c\u767b\u51fa\u8bb0\u5f55\u5b9e\u4f53={}", (Object)JsonUtil.convertObject((Object)reqVO), (Object)JsonUtil.convertObject((Object)entity));
        return BaseResponse.success((Object)data);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<BaseIdRespVO> accountCancel(AccountOperateBaseReqVO accountOperateBaseReqVO, String token) {
        String accountId = accountOperateBaseReqVO.getAccountId();
        String appCode = accountOperateBaseReqVO.getAppCode();
        TokenJson tokenJson = this.getTokenJson(token, appCode);
        UcAccountEntity account = this.getRightAccount(accountId);
        this.checkAccountPassword(accountOperateBaseReqVO, account);
        this.deleteAllToken(tokenJson.getUserId(), tokenJson.getAppCode());
        String tokenKey = Tokenutil.genTokenKey((String)tokenJson.getUserId(), (String)tokenJson.getAppCode(), (String)tokenJson.getDeviceType());
        String cacheToken = this.cacheService.getLoginToken(tokenKey);
        this.accountCancelLinkAction(account, cacheToken);
        this.messageService.tokenInvalidMsg(cacheToken, CommonEnums.TokenInvalidCause.CANCEL);
        account.setStatus(AccountEnums.AccountStatusEnum.CANCELLATION.getValue());
        this.ucAccountMapper.save(account);
        UcAccountOperateEntity operate = new UcAccountOperateEntity(accountOperateBaseReqVO.getChannelCode(), AccountEnums.AccountOperationEnum.ACCOUNT_CANCELLATION.getValue(), "\u8d26\u6237\u6ce8\u9500", accountId, JsonUtil.convertObject((Object)accountOperateBaseReqVO));
        this.ucAccountOperateMapper.save(operate);
        BaseIdRespVO data = new BaseIdRespVO(account.getUserId(), accountId);
        return BaseResponse.success((Object)data);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<BaseIdRespVO> updatePassword(AccountPasswordUpdateReqVO accountPasswordUpdateReqVO, String token) {
        if (accountPasswordUpdateReqVO.getPasswordNew().trim().length() < 6) {
            return BaseResponse.error((IError)IError.PARAM_CHECK_FAILD, (String)"\u8bf7\u8f93\u5165\u5408\u6cd5\u7684\u65b0\u5bc6\u7801");
        }
        String accountId = accountPasswordUpdateReqVO.getAccountId();
        String appCode = accountPasswordUpdateReqVO.getAppCode();
        TokenJson tokenJson = this.getTokenJson(token, appCode);
        UcAccountEntity account = this.getRightAccount(accountId);
        try {
            this.checkAccountPassword((AccountOperateBaseReqVO)accountPasswordUpdateReqVO, account);
        }
        catch (UserCenterRuntimeException e) {
            return BaseResponse.error((IError)IError.PARAM_CHECK_FAILD, (String)"\u539f\u767b\u5f55\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        this.deletaAllTokenExceptOne(tokenJson.getUserId(), tokenJson.getAppCode(), tokenJson.getDeviceType());
        String tokenKey = Tokenutil.genTokenKey((String)tokenJson.getUserId(), (String)tokenJson.getAppCode(), (String)tokenJson.getDeviceType());
        String cacheToken = this.cacheService.getLoginToken(tokenKey);
        this.messageService.tokenInvalidMsg(cacheToken, CommonEnums.TokenInvalidCause.UPDATE_ACCOUNT_PASSWORD);
        PasswordAndSalt passwordAndSalt = PasswordUtil.mix((String)accountPasswordUpdateReqVO.getPasswordNew().trim());
        account.setAccountPw(passwordAndSalt.getMixedPassword());
        account.setPwSalt(passwordAndSalt.getSalt());
        this.ucAccountMapper.save(account);
        UcAccountOperateEntity operate = new UcAccountOperateEntity(accountPasswordUpdateReqVO.getChannelCode(), AccountEnums.AccountOperationEnum.UPDATE_PASSWORD.getValue(), "\u4fee\u6539\u4e86\u8d26\u6237\u5bc6\u7801", accountId, JsonUtil.convertObject((Object)accountPasswordUpdateReqVO));
        this.ucAccountOperateMapper.save(operate);
        BaseIdRespVO data = new BaseIdRespVO(account.getUserId(), accountId);
        return BaseResponse.success((Object)data);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<BaseIdRespVO> updateAccountNo(AccountNoUpdateReqVO accountNoUpdateReqVO, String token) {
        this.checkAccountNoRightByAccountType(accountNoUpdateReqVO.getAccountNoNew(), accountNoUpdateReqVO.getAccountType());
        String accountId = accountNoUpdateReqVO.getAccountId();
        String appCode = accountNoUpdateReqVO.getAppCode();
        TokenJson tokenJson = this.getTokenJson(token, appCode);
        UcAccountEntity account = this.getRightAccount(accountId);
        this.checkAccountPassword((AccountOperateBaseReqVO)accountNoUpdateReqVO, account);
        UcAccountEntity checkNewAccount = this.getAccount(accountNoUpdateReqVO.getAccountNoNew(), account.getUserType(), account.getAppCode());
        if (checkNewAccount != null) {
            this.log.warn("\u65b0\u767b\u5f55\u8d26\u6237\u540d\u91cd\u590d,\u4fee\u6539\u767b\u5f55\u8d26\u6237\u540d\u5931\u8d25,\u8bf7\u6c42\u53c2\u6570={}", (Object)JsonUtil.convertObject((Object)accountNoUpdateReqVO));
            throw new UserCenterRuntimeException(IError.PARAM_CHECK_FAILD, "\u65b0\u767b\u5f55\u8d26\u6237\u540d\u91cd\u590d,\u65e0\u6cd5\u4fee\u6539");
        }
        this.deletaAllTokenExceptOne(tokenJson.getUserId(), tokenJson.getAppCode(), tokenJson.getDeviceType());
        String tokenKey = Tokenutil.genTokenKey((String)tokenJson.getUserId(), (String)tokenJson.getAppCode(), (String)tokenJson.getDeviceType());
        String cacheToken = this.cacheService.getLoginToken(tokenKey);
        this.messageService.tokenInvalidMsg(cacheToken, CommonEnums.TokenInvalidCause.UPDATE_ACCOUNT_NO);
        account.setAccountNo(accountNoUpdateReqVO.getAccountNoNew().trim());
        account.setAccountType(accountNoUpdateReqVO.getAccountType());
        this.ucAccountMapper.save(account);
        UcAccountOperateEntity operate = new UcAccountOperateEntity(accountNoUpdateReqVO.getChannelCode(), AccountEnums.AccountOperationEnum.UPDATE_ACCOUNT_NO.getValue(), "\u4fee\u6539\u4e86\u767b\u5f55\u8d26\u6237", accountId, JsonUtil.convertObject((Object)accountNoUpdateReqVO));
        this.ucAccountOperateMapper.save(operate);
        BaseIdRespVO data = new BaseIdRespVO(account.getUserId(), accountId);
        return BaseResponse.success((Object)data);
    }

    public BaseResponse<BaseIdRespVO> pwdVerify(AccountOperateBaseReqVO accountOperateBaseReqVO) {
        UcAccountEntity account = this.getRightAccount(accountOperateBaseReqVO.getAccountId());
        this.checkAccountPassword(accountOperateBaseReqVO, account);
        BaseIdRespVO data = new BaseIdRespVO(account.getUserId(), account.getAccountId());
        return BaseResponse.success((Object)data);
    }

    public BaseResponse<AccountNoCheckRespVO> accountNoVerify(AccountNoCheckReqVO accountNoCheckReqVO) {
        Optional wxBind;
        AccountNoCheckRespVO data = new AccountNoCheckRespVO();
        UcAccountEntity account = this.getAccount(accountNoCheckReqVO.getAccountNo(), accountNoCheckReqVO.getUserType(), accountNoCheckReqVO.getAppCode());
        if (account == null) {
            return BaseResponse.success((Object)data);
        }
        data.setIsRepeat(Boolean.TRUE);
        if (!StringUtils.isEmpty((Object)account.getAccountPw())) {
            data.setSetPassword(Boolean.TRUE);
        }
        if (Boolean.TRUE.equals(accountNoCheckReqVO.getCheckWXBind()) && (wxBind = this.ucWxAuthMapper.findByUserIdAndUserTypeAndStatus(account.getUserId(), account.getUserType(), WxAuthEnums.WxAuthStatusEnum.NORMAL.getValue())).isPresent()) {
            data.setWxBind(Boolean.TRUE);
        }
        return BaseResponse.success((Object)data);
    }

    public BaseResponse<CheckAccountRepeatRespVO> accountNoVerify(CheckAccountRepeatReqVO checkAccountRepeatReqVO) {
        this.log.info("\u8d26\u53f7\u68c0\u67e5\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)checkAccountRepeatReqVO));
        AccountNoCheckReqVO accountNoCheckReqVO = new AccountNoCheckReqVO();
        BeanUtils.copyProperties((Object)checkAccountRepeatReqVO, (Object)accountNoCheckReqVO);
        accountNoCheckReqVO.setUserType(PushCenterContants.CUSTOMER_USER_TYPE);
        this.log.info("\u8d26\u53f7\u68c0\u67e5\uff0c\u8c03\u7528\u7528\u6237\u4e2d\u5fc3\u8bf7\u6c42\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)accountNoCheckReqVO));
        BaseResponse urResponse = this.accountNoVerify(accountNoCheckReqVO);
        this.log.info("\u8d26\u53f7\u68c0\u67e5\uff0c\u8c03\u7528\u7528\u6237\u4e2d\u5fc3\u8fd4\u56de\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)urResponse));
        BaseResponse result = new BaseResponse();
        BeanUtils.copyProperties((Object)urResponse, (Object)result);
        this.log.info("\u8d26\u53f7\u68c0\u67e5\uff0c\u8fd4\u56de\u524d\u7aef\u53c2\u6570{[]}", (Object)JsonUtil.convertObject((Object)result));
        return result;
    }

    public BaseResponse<BaseUserCenterIdRespVO> getbackPassword(GetbackPasswordReqVO getbackPasswordReqVO) {
        this.log.info("\u627e\u56de\u5bc6\u7801\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)getbackPasswordReqVO));
        if (StringUtils.isEmpty((Object)getbackPasswordReqVO.getVercodeKey()) && StringUtils.isEmpty((Object)getbackPasswordReqVO.getVercodeValue()) && LoginDeviceType.WEB.equals((Object)getbackPasswordReqVO.getLoginDeviceType()) && (super.isVercodeIP(getbackPasswordReqVO.getLoginIp()).booleanValue() || super.isVercodePhone(getbackPasswordReqVO.getAccountNo()).booleanValue())) {
            this.log.info("PC\u7aef\u627e\u56de\u5bc6\u7801 \u9700\u8981\u8fdb\u884c\u56fe\u6587\u9a8c\u8bc1");
            return BaseResponse.error((IError)ErrorEnum.VERCODE_NEED_YES);
        }
        if (!(StringUtils.isEmpty((Object)getbackPasswordReqVO.getVercodeKey()) || StringUtils.isEmpty((Object)getbackPasswordReqVO.getVercodeValue()) || super.verifyVercode(getbackPasswordReqVO.getVercodeKey(), getbackPasswordReqVO.getVercodeValue()))) {
            return BaseResponse.error((IError)ErrorEnum.VERCODE_ERROR, (String)"\u56fe\u6587\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
        }
        SmsVerifiAuthCodeReqVO smsVerifiAuthCodeReqVo = new SmsVerifiAuthCodeReqVO();
        smsVerifiAuthCodeReqVo.setAuthCode(getbackPasswordReqVO.getAuthCode());
        smsVerifiAuthCodeReqVo.setAuthKey(getbackPasswordReqVO.getAuthKey());
        smsVerifiAuthCodeReqVo.setOperate(SMS_DEL_FLAG);
        smsVerifiAuthCodeReqVo.setPhoneNum(getbackPasswordReqVO.getAccountNo());
        if (!LoginDeviceType.WEB.toString().equalsIgnoreCase(getbackPasswordReqVO.getLoginDeviceType())) {
            this.log.info("\u627e\u56de\u5bc6\u7801\uff0c\u77ed\u4fe1\u9a8c\u8bc1\u7801\u6821\u9a8c\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)smsVerifiAuthCodeReqVo));
            BaseResponse checkMsgResp = this.smsApiClient.verifiSmsAuthCode(smsVerifiAuthCodeReqVo);
            this.log.info("\u627e\u56de\u5bc6\u7801\uff0c\u77ed\u4fe1\u9a8c\u8bc1\u7801\u6821\u9a8c\uff0c\u8fd4\u56de\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)checkMsgResp));
            if ("0".equals(checkMsgResp.getCode())) {
                return checkMsgResp;
            }
        }
        ResetPasswordReqVO resetPasswordReqVO = new ResetPasswordReqVO();
        BeanUtils.copyProperties((Object)getbackPasswordReqVO, (Object)resetPasswordReqVO);
        resetPasswordReqVO.setPassword(getbackPasswordReqVO.getPasswordNew());
        if (getbackPasswordReqVO.getUserType() != null) {
            resetPasswordReqVO.setUserType(getbackPasswordReqVO.getUserType());
        } else {
            resetPasswordReqVO.setUserType(PushCenterContants.CUSTOMER_USER_TYPE);
        }
        resetPasswordReqVO.setLoginDeviceType(getbackPasswordReqVO.getLoginDeviceType());
        BaseResponse resp = this.resetPassword(resetPasswordReqVO);
        if ("0".equals(resp.getCode())) {
            return BaseResponse.error((IError)IError.DATA_NOT_EXIST, (String)resp.getMsg());
        }
        BaseIdRespVO respData = (BaseIdRespVO)resp.getData();
        BaseUserCenterIdRespVO userRegisterResp = new BaseUserCenterIdRespVO();
        BeanUtils.copyProperties((Object)respData, (Object)userRegisterResp);
        this.log.info("\u627e\u56de\u5bc6\u7801\uff0c\u8fd4\u56de\u524d\u7aef\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)userRegisterResp));
        return BaseResponse.success((Object)userRegisterResp);
    }

    public BaseResponse<BaseIdRespVO> resetPassword(ResetPasswordReqVO resetPasswordReqVO) {
        this.log.info("\u627e\u56de\u5bc6\u7801\uff0c\u8c03\u7528\u7528\u6237\u4e2d\u5fc3\u8bf7\u6c42\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)resetPasswordReqVO));
        UcAccountEntity account = this.getAccount(resetPasswordReqVO.getAccountNo(), resetPasswordReqVO.getUserType(), resetPasswordReqVO.getAppCode());
        if (account == null) {
            return BaseResponse.error((IError)ErrorEnum.NO_ACCOUNT);
        }
        if (AccountEnums.AccountStatusEnum.PROHIBIT.getValue().equals(account.getStatus())) {
            return BaseResponse.error((IError)ErrorEnum.DISABLED_ACCOUNT);
        }
        if (LoginDeviceType.WEB.toString().equalsIgnoreCase(resetPasswordReqVO.getLoginDeviceType())) {
            this.validNewPassword(account, resetPasswordReqVO.getPassword());
        }
        this.deleteAllToken(account.getUserId(), account.getAppCode());
        PasswordAndSalt passwordAndSalt = PasswordUtil.mix((String)resetPasswordReqVO.getPassword());
        account.setAccountPw(passwordAndSalt.getMixedPassword());
        account.setPwSalt(passwordAndSalt.getSalt());
        account.setUpdateTime(new Date());
        this.ucAccountMapper.save(account);
        this.log.info("\u627e\u56de\u5bc6\u7801\uff0c\u4fdd\u5b58\u91cd\u7f6e\u540e\u7684\u5bc6\u7801:{}-->{},\u539f\u5bc6\u7801\uff1a{}", new Object[]{resetPasswordReqVO.getPassword(), passwordAndSalt.getMixedPassword(), account.getAccountPw()});
        UcAccountOperateEntity operate = new UcAccountOperateEntity(resetPasswordReqVO.getChannelCode(), AccountEnums.AccountOperationEnum.UPDATE_PASSWORD.getValue(), "\u91cd\u7f6e\u4e86\u8d26\u6237\u5bc6\u7801", account.getAccountId(), JsonUtil.convertObject((Object)resetPasswordReqVO));
        this.ucAccountOperateMapper.save(operate);
        this.log.info("\u627e\u56de\u5bc6\u7801\uff0c\u8c03\u7528\u7528\u6237\u4e2d\u5fc3\u8fd4\u56de\u53c2\u6570UserId:{},AccountId:{}", (Object)account.getUserId(), (Object)account.getAccountId());
        return BaseResponse.success((Object)new BaseIdRespVO(account.getUserId(), account.getAccountId()));
    }

    public BaseResponse<DoctorAppLoginRespVO> doctorLogin(AccountLoginReqVO accountLoginReqVO) {
        UcAccountEntity account = this.validLoginAccount(accountLoginReqVO);
        return this.getDoctorAppLoginRespVO(account, (CloudAccountLoginReqVO)accountLoginReqVO);
    }

    private BaseResponse<DoctorAppLoginRespVO> getDoctorAppLoginRespVO(UcAccountEntity account, CloudAccountLoginReqVO reqVo) {
        UcDoctorUserEntity userEntity = (UcDoctorUserEntity)this.userService.getUserEntity(account.getUserId(), UserEnums.UserTypeEnum.DOCTOR.getUserTypeValue());
        if (userEntity == null) {
            this.log.warn("\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684\u7528\u6237\u4fe1\u606f,\u8bf7\u6c42\u4fe1\u606f[{}]" + reqVo);
            throw new UserCenterRuntimeException(ErrorEnum.USER_NOT_EXIT);
        }
        String tokenKey = this.loginInfoValid(reqVo, account);
        this.log.info("\u4e91\u4e0b\u6570\u636e\u767b\u5f55tokenkey:[{}]", (Object)tokenKey);
        String loginToken = this.genLoginToken(reqVo, account, tokenKey);
        DoctorAppLoginRespVO doctorAppLoginRespVO = new DoctorAppLoginRespVO();
        doctorAppLoginRespVO.setToken(loginToken);
        UserInfoRespVO userInfoRespVO = this.userService.getUserInfoRespVO((UserEntity)userEntity, account.getUserType());
        doctorAppLoginRespVO.setAccountId(account.getAccountId());
        doctorAppLoginRespVO.setAccountStatus(account.getStatus());
        doctorAppLoginRespVO.setContactMobile(userInfoRespVO.getContactMobile());
        doctorAppLoginRespVO.setHeadPortrait(userInfoRespVO.getHeadPortrait());
        doctorAppLoginRespVO.setName(userInfoRespVO.getName());
        doctorAppLoginRespVO.setNickName(userInfoRespVO.getNickName());
        doctorAppLoginRespVO.setToken(loginToken);
        doctorAppLoginRespVO.setUserId(userInfoRespVO.getUserId());
        doctorAppLoginRespVO.setUserType(account.getUserType());
        if (StringUtils.isEmpty((Object)userEntity.getDoctorId())) {
            return BaseResponse.success((Object)doctorAppLoginRespVO);
        }
        FindBaseInfoReqVO findBaseInfoReqVO = new FindBaseInfoReqVO();
        findBaseInfoReqVO.setDoctorId(userEntity.getDoctorId());
        BaseResponse findBaseInfoResponse = this.baseDataDoctorFeignClient.findBaseInfo(findBaseInfoReqVO);
        if (!findBaseInfoResponse.isSuccess()) {
            this.log.warn("\u8c03\u7528\u57fa\u7840\u670d\u52a1\u67e5\u8be2\u533b\u751f\u4fe1\u606f\u8fd4\u56de\u9519\u8bef,\u8bf7\u6c42\u4fe1\u606f[{}]\uff0c\u8fd4\u56de\u4fe1\u606f[{}]", (Object)findBaseInfoReqVO, (Object)findBaseInfoResponse);
            return BaseResponse.error((IError)IError.DATA_NOT_EXIST);
        }
        FindBaseInfoResVO findBaseInfoResVO = (FindBaseInfoResVO)findBaseInfoResponse.getData();
        DoctorAppLoginRespDoctor doctorAppLoginRespDoctor = new DoctorAppLoginRespDoctor();
        BeanUtils.copyProperties((Object)findBaseInfoResVO, (Object)doctorAppLoginRespDoctor);
        doctorAppLoginRespVO.setDoctorLoginInfo(doctorAppLoginRespDoctor);
        IMQueryUserLoginReqVO querySdkLogin = new IMQueryUserLoginReqVO();
        querySdkLogin.setAppCode("EHOS_DOCTOR");
        querySdkLogin.setUserId(doctorAppLoginRespVO.getUserId());
        IMQueryUserLoginRspVO imAccountRes = this.querySdkLogin(querySdkLogin);
        if (null != imAccountRes) {
            DoctorAppLoginRespImInfo sdkLogin = new DoctorAppLoginRespImInfo();
            sdkLogin.setLogin(imAccountRes.getLogin());
            sdkLogin.setSig(imAccountRes.getSig());
            sdkLogin.setThirdSdkAccount(imAccountRes.getSdkAccount());
            doctorAppLoginRespVO.setSdkLogin(sdkLogin);
        }
        return BaseResponse.success((Object)doctorAppLoginRespVO);
    }

    public BaseResponse<DoctorAppLoginRespVO> quickLogin(CloudAccountLoginReqVO reqVo) {
        UcAccountEntity account = this.validLoginNoPwd(reqVo);
        return this.getDoctorAppLoginRespVO(account, reqVo);
    }

    private IMQueryUserLoginRspVO querySdkLogin(IMQueryUserLoginReqVO req) {
        if (StringUtils.isEmpty((Object)req.getAppCode()) || StringUtils.isEmpty((Object)req.getUserId())) {
            return null;
        }
        try {
            this.log.info("\u767b\u9646\u67e5\u8be2IM\u4fe1\u606f - \u8bf7\u6c42:{}", (Object)JsonUtil.convertObject((Object)req));
            BaseResponse response = this.imClient.queryUserLogin(req);
            this.log.info("\u767b\u9646\u67e5\u8be2IM\u4fe1\u606f - \u54cd\u5e94:{}", (Object)JsonUtil.convertObject((Object)response));
            if (response.isSuccess()) {
                return (IMQueryUserLoginRspVO)response.getData();
            }
        }
        catch (Exception e) {
            this.log.error("\u767b\u9646\u67e5\u8be2IM\u4fe1\u606f \u8c03\u7528\u5f02\u5e38 AccountServiceImpl/querySdkLogin  {}", (Throwable)e);
        }
        return null;
    }

    private void checkAccountNoRepeat(String accountNo, List<AccountRegisterBaseReqVO> relationAccountList) {
        if (relationAccountList == null || relationAccountList.isEmpty()) {
            return;
        }
        ArrayList<String> accountNoList = new ArrayList<String>();
        accountNoList.add(accountNo);
        for (AccountRegisterBaseReqVO accountRegisterBaseReqVO : relationAccountList) {
            this.checkAccountNoRightByAccountType(accountRegisterBaseReqVO.getAccountNo(), accountRegisterBaseReqVO.getAccountType());
            if (accountNoList.contains(accountRegisterBaseReqVO.getAccountNo())) {
                this.log.warn("\u5173\u8054\u6ce8\u518c\u8d26\u53f7\u91cd\u590d\uff0c\u65e0\u6cd5\u91cd\u590d\u6ce8\u518c,accountNo={}", (Object)accountRegisterBaseReqVO.getAccountNo());
                throw new UserCenterRuntimeException(ErrorEnum.DATA_DUPLICATE, "\u5173\u8054\u6ce8\u518c\u8d26\u53f7" + accountRegisterBaseReqVO.getAccountNo() + "\u91cd\u590d");
            }
            accountNoList.add(accountRegisterBaseReqVO.getAccountNo());
        }
    }

    private void checkAccountExist(AccountRegisterReqVO accountRegisterReqVO) {
        String appCode;
        Short userType;
        String accountNo = accountRegisterReqVO.getAccountNo();
        UcAccountEntity account = this.getAccount(accountNo, userType = accountRegisterReqVO.getUserType(), appCode = accountRegisterReqVO.getAppCode());
        if (account != null) {
            this.log.warn("\u8d26\u53f7\u5df2\u7ecf\u88ab\u6ce8\u518c,accountNo={},userType={},appCode={}", new Object[]{accountNo, userType, appCode});
            throw new UserCenterRuntimeException(ErrorEnum.DATA_DUPLICATE, "\u60a8\u8f93\u5165\u7684\u8d26\u6237\u5df2\u88ab\u6ce8\u518c,\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        List relationAccountList = accountRegisterReqVO.relationAccountList;
        if (relationAccountList != null && !relationAccountList.isEmpty()) {
            for (AccountRegisterBaseReqVO accountRegisterBaseReqVO : relationAccountList) {
                account = this.getAccount(accountRegisterBaseReqVO.getAccountNo(), userType, appCode);
                if (account == null) continue;
                this.log.warn("\u5173\u8054\u8d26\u53f7\u5df2\u7ecf\u88ab\u6ce8\u518c,accountNo={},userType={},appCode={}", new Object[]{accountRegisterBaseReqVO.getAccountNo(), userType, appCode});
                throw new UserCenterRuntimeException(ErrorEnum.DATA_DUPLICATE, "\u5173\u8054\u8d26\u6237\u5df2\u88ab\u6ce8\u518c,\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
        }
    }

    private UcPatientUserEntity buildPatientUserEntity(AccountRegisterReqVO accountRegisterReqVO) {
        UcPatientUserEntity user = new UcPatientUserEntity(accountRegisterReqVO);
        long userId = this.uniqueID.nextId();
        user.setUserId(String.valueOf(userId));
        return user;
    }

    private UcDoctorUserEntity buildDoctorUserEntity(AccountRegisterReqVO accountRegisterReqVO) {
        if (StringUtils.isEmpty((Object)accountRegisterReqVO.getName())) {
            throw new UserCenterRuntimeException(IError.PARAM_CHECK_FAILD, "\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.isEmpty((Object)accountRegisterReqVO.getDataId())) {
            UcAccountEntity account = this.getDoctorAccount(accountRegisterReqVO.getDataId(), accountRegisterReqVO.getAppCode());
            if (account != null && AccountEnums.AccountStatusEnum.NORMAL.getValue().equals(account.getStatus())) {
                throw new UserCenterRuntimeException(ErrorEnum.DATA_DUPLICATE, "\u5df2\u6709\u8be5doctorId\u7684\u533b\u751f");
            }
            if (account != null && AccountEnums.AccountStatusEnum.PROHIBIT.getValue().equals(account.getStatus())) {
                throw new UserCenterRuntimeException(ErrorEnum.DISABLED_ACCOUNT, "\u8be5doctorId\u533b\u751f\u5df2\u88ab\u7981\u7528");
            }
        }
        UcDoctorUserEntity user = new UcDoctorUserEntity(accountRegisterReqVO);
        long userId = this.uniqueID.nextId();
        user.setUserId(String.valueOf(userId));
        return user;
    }

    private UcOrganUserEntity buildOrganUserEntity(AccountRegisterReqVO accountRegisterReqVO) {
        if (StringUtils.isEmpty((Object)accountRegisterReqVO.getName())) {
            throw new UserCenterRuntimeException(IError.PARAM_CHECK_FAILD, "\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)accountRegisterReqVO.getContactMobile())) {
            throw new UserCenterRuntimeException(IError.PARAM_CHECK_FAILD, "\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)accountRegisterReqVO.getHeadPortrait())) {
            throw new UserCenterRuntimeException(IError.PARAM_CHECK_FAILD, "\u56fe\u6807\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)accountRegisterReqVO.getIntroduction())) {
            throw new UserCenterRuntimeException(IError.PARAM_CHECK_FAILD, "\u7b80\u4ecb\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UcOrganUserEntity user = new UcOrganUserEntity(accountRegisterReqVO);
        long userId = this.uniqueID.nextId();
        user.setUserId(String.valueOf(userId));
        return user;
    }

    private UcManagerUserEntity buildManagerUserEntity(AccountRegisterReqVO accountRegisterReqVO) {
        UcManagerUserEntity user = new UcManagerUserEntity(accountRegisterReqVO);
        long userId = this.uniqueID.nextId();
        user.setUserId(String.valueOf(userId));
        return user;
    }

    private UcLoginRecordEntity bulidUcLoginRecordEntity(String token, AccountLogoutReqVO accountLogoutReqVO) {
        UcLoginRecordEntity entity = new UcLoginRecordEntity();
        String accountId = accountLogoutReqVO.getAccountId();
        entity.setAccountId(accountId);
        entity.setLoginType(AccountEnums.LoginTypeEnum.LOGOUT.getType());
        String loginIp = accountLogoutReqVO.getLoginIp();
        entity.setLoginIp(loginIp);
        String loginBussinessCode = accountLogoutReqVO.getChannelCode();
        entity.setLoginBussinessCode(loginBussinessCode);
        entity.setLoginToken(token);
        String deviceType = accountLogoutReqVO.getDeviceType();
        entity.setDeviceType(deviceType);
        String deviceNumber = accountLogoutReqVO.getDeviceNumber();
        entity.setDeviceNumber(deviceNumber);
        entity.setCreateTime(new Date());
        return entity;
    }

    private String genLoginToken(CloudAccountLoginReqVO accountLoginReqVO, UcAccountEntity account, String tokenKey) {
        UcPatientUserEntity user;
        TokenJson tokenJson = new TokenJson();
        tokenJson.setUserId(account.getUserId());
        tokenJson.setAccountId(account.getAccountId());
        tokenJson.setAppCode(account.getAppCode());
        tokenJson.setChannelCode(accountLoginReqVO.getChannelCode());
        tokenJson.setUserType(account.getUserType().shortValue());
        tokenJson.setDevicenumber(accountLoginReqVO.getLoginDeviceNum());
        tokenJson.setDeviceType(accountLoginReqVO.getLoginDeviceType().name());
        tokenJson.setAccountNo(account.getAccountNo());
        if (UserEnums.UserTypeEnum.PATIENT.getUserTypeValue().equals(account.getUserType())) {
            user = this.getPatientUserEntity(account.getUserId());
            tokenJson.setName(user.getName());
        } else if (UserEnums.UserTypeEnum.DOCTOR.getUserTypeValue().equals(account.getUserType())) {
            user = this.getDoctorUserEntity(account.getUserId());
            tokenJson.setName(user.getName());
        } else if (UserEnums.UserTypeEnum.ORGAN.getUserTypeValue().equals(account.getUserType())) {
            user = this.getOrganUserEntity(account.getUserId());
            tokenJson.setName(user.getOrganName());
        } else if (UserEnums.UserTypeEnum.MANAGER.getUserTypeValue().equals(account.getUserType())) {
            user = this.getManagerUserEntity(account.getUserId());
            tokenJson.setName(user.getName());
        } else {
            throw new UserCenterRuntimeException(IError.PARAM_CHECK_FAILD, "\u672a\u77e5\u7684\u7528\u6237\u7c7b\u578b");
        }
        String appCode = accountLoginReqVO.getAppCode();
        String secryKey = this.getSecryKey(appCode);
        this.log.info("\u767b\u5f55\u6210\u529f\u751f\u6210token\u7684secryKey[{}]", (Object)secryKey);
        String loginToken = Tokenutil.gen((TokenJson)tokenJson, (String)secryKey);
        this.cacheService.addLoginToken(tokenKey, loginToken);
        UcLoginRecordEntity loginRecord = new UcLoginRecordEntity();
        loginRecord.setAccountId(account.getAccountId());
        loginRecord.setDeviceType(accountLoginReqVO.getLoginDeviceType().name());
        loginRecord.setLoginBussinessCode(accountLoginReqVO.getChannelCode());
        loginRecord.setLoginType(AccountEnums.LoginTypeEnum.LOGIN.getType());
        loginRecord.setLoginToken(loginToken);
        loginRecord.setLoginIp(accountLoginReqVO.getLoginIp());
        loginRecord.setDeviceNumber(accountLoginReqVO.getLoginDeviceNum());
        loginRecord.setCreateTime(new Date());
        this.ucLoginRecordMapper.save(loginRecord);
        account.setLastLoginIp(accountLoginReqVO.getLoginIp());
        account.setLastLoginTime(new Date());
        this.ucAccountMapper.save(account);
        this.log.info("\u7528\u6237\u6210\u529f\u767b\u5f55\uff0c\u767b\u5f55\u7528\u6237\u4fe1\u606f[{}]", (Object)tokenJson);
        return loginToken;
    }

    private String loginInfoValid(CloudAccountLoginReqVO reqVO, UcAccountEntity account) {
        String tokenKey;
        block9: {
            this.log.info("\u767b\u5f55\u4fe1\u606f\u6821\u9a8c  (\u82e5\u5176\u4ed6\u76f8\u540c\u8bbe\u5907\u5df2\u767b\u5f55\u5219\u901a\u77e5\u4e0b\u7ebf CloudAccountLoginReqVO:{},UcAccountEntity\uff1a{}", (Object)JSON.toJSONString((Object)reqVO), (Object)JSON.toJSONString((Object)account));
            String deviceType = reqVO.getLoginDeviceType().name();
            tokenKey = Tokenutil.genTokenKey((String)account.getUserId(), (String)account.getAppCode(), (String)deviceType);
            String cacheToken = this.cacheService.getLoginToken(tokenKey);
            this.log.info("===============\u67e5\u8be2\u5230\u7684\u7f13\u5b58Token\uff1a{}============", (Object)cacheToken);
            if (!StringUtils.isEmpty((Object)cacheToken)) {
                boolean delLoginToken = this.cacheService.delLoginToken(tokenKey);
                if (!delLoginToken) {
                    this.log.warn("\u5220\u9664\u7528\u6237\u5386\u53f2\u767b\u5f55token\u5931\u8d25,\u672a\u5220\u9664Token[{}]" + cacheToken);
                }
                String secryKey = this.getSecryKey(account.getAppCode());
                try {
                    TokenBody tokenBody = Tokenutil.parse((String)cacheToken, (String)secryKey);
                    TokenJson tokenJson = tokenBody.getTokenJson();
                    String devicenumber = tokenJson.getDevicenumber();
                    this.log.info("devicenumber\uff1a" + devicenumber + ";\u4f20\u5165\u7684\u8bbe\u5907\u53f7\uff1a" + reqVO.getLoginDeviceNum());
                    if (devicenumber.equals(reqVO.getLoginDeviceNum())) break block9;
                    this.log.info("\u4e0d\u662f\u540c\u4e00\u4e2a\u8bbe\u5907\u767b\u5f55\uff0c\u53d1\u9001\u63a8\u9001\u6d88\u606f\u901a\u77e5\u4e0b\u7ebf,userID[{}]", (Object)account.getUserId());
                    String channelCode = tokenJson.getChannelCode();
                    if (channelCode.contains("IOS")) {
                        IOSUnicastReqVO iosUnicastReqVO = new IOSUnicastReqVO();
                        HashMap<String, String> extra = new HashMap<String, String>();
                        extra.put("notifyType", "offline");
                        iosUnicastReqVO.setExtra(extra);
                        iosUnicastReqVO.setBody("\u60a8\u7684\u8d26\u6237\u6b63\u5728\u5176\u4ed6\u8bbe\u5907\u767b\u5f55\uff0c\u82e5\u975e\u672c\u4eba\u64cd\u4f5c\u8bf7\u6ce8\u610f\u8d26\u6237\u5b89\u5168\u3002");
                        iosUnicastReqVO.setBusiStyle("\u60a8\u7684\u8d26\u6237\u6b63\u5728\u5176\u4ed6\u8bbe\u5907\u767b\u5f55\uff0c\u82e5\u975e\u672c\u4eba\u64cd\u4f5c\u8bf7\u6ce8\u610f\u8d26\u6237\u5b89\u5168\u3002");
                        iosUnicastReqVO.setBusiCode("dz_drop_line");
                        iosUnicastReqVO.setDeviceTokens(tokenJson.getDevicenumber());
                        iosUnicastReqVO.setSubTitle("\u767b\u9646\u4e0b\u7ebf\u901a\u77e5");
                        iosUnicastReqVO.setUserId(tokenJson.getUserId());
                        iosUnicastReqVO.setUserType(account.getUserType().shortValue());
                        BaseResponse iosUnicast = null;
                        try {
                            iosUnicast = this.umengApiClient.pushUmIosUnicast(iosUnicastReqVO);
                        }
                        catch (HystrixRuntimeException e) {
                            this.log.error("\u63a8\u9001\u6d88\u606f \u5f02\u5e38 HystrixRuntimeException:{}", (Throwable)e);
                        }
                        this.log.info("\u63a8\u9001\u6d88\u606f token\u5931\u6548\u5230\u8bbe\u5907\uff0cuserID[{}],req[{}],response[{}]", new Object[]{tokenJson.getUserId(), iosUnicastReqVO, iosUnicast});
                        break block9;
                    }
                    if (!channelCode.contains("ANDROID")) break block9;
                    AndroidUnicastReqVO unicastReqVO = new AndroidUnicastReqVO();
                    HashMap<String, String> extra = new HashMap<String, String>();
                    extra.put("notifyType", "offline");
                    unicastReqVO.setExtra(extra);
                    unicastReqVO.setCustom(JsonUtil.convertObject(extra));
                    unicastReqVO.setText("\u60a8\u7684\u8d26\u6237\u6b63\u5728\u5176\u4ed6\u8bbe\u5907\u767b\u5f55\uff0c\u82e5\u975e\u672c\u4eba\u64cd\u4f5c\u8bf7\u6ce8\u610f\u8d26\u6237\u5b89\u5168\u3002");
                    unicastReqVO.setBusiStyle("\u60a8\u7684\u8d26\u6237\u6b63\u5728\u5176\u4ed6\u8bbe\u5907\u767b\u5f55\uff0c\u82e5\u975e\u672c\u4eba\u64cd\u4f5c\u8bf7\u6ce8\u610f\u8d26\u6237\u5b89\u5168\u3002");
                    unicastReqVO.setBusiCode("dz_drop_line");
                    unicastReqVO.setDeviceTokens(tokenJson.getDevicenumber());
                    unicastReqVO.setTitle("\u767b\u9646\u4e0b\u7ebf\u901a\u77e5");
                    unicastReqVO.setUserId(tokenJson.getUserId());
                    unicastReqVO.setUserType(account.getUserType().shortValue());
                    BaseResponse iosUnicast = null;
                    try {
                        iosUnicast = this.umengApiClient.pushUmAndroidUnicast(unicastReqVO);
                    }
                    catch (HystrixRuntimeException e) {
                        this.log.error("\u63a8\u9001\u6d88\u606f \u5f02\u5e38 HystrixRuntimeException:{}", (Throwable)e);
                    }
                    this.log.info("\u63a8\u9001\u6d88\u606f token\u5931\u6548\u5230\u8bbe\u5907\uff0cuserID[{}],req[{}],response[{}]", new Object[]{tokenJson.getUserId(), unicastReqVO, iosUnicast});
                }
                catch (TokenParseException e) {
                    this.log.info("\u63a8\u9001\u6d88\u606ftoken\u5931\u6548\u5230\u8bbe\u5907\u53d1\u751f\u5f02\u5e38\uff0cuserID[{}],e[{}]", (Object)account.getUserId(), (Object)e);
                }
            }
        }
        return tokenKey;
    }

    private AccountLoginRespVO createAccountLoginResp(UcAccountEntity account, UserEntity userEntity, String loginToken) {
        AccountLoginRespVO loginRespVO = new AccountLoginRespVO();
        BeanUtils.copyProperties((Object)account, (Object)loginRespVO);
        loginRespVO.setToken(loginToken);
        UserInfoRespVO userInfoRespVO = this.userService.getUserInfoRespVO(userEntity, account.getUserType());
        loginRespVO.setUserInfoRespVO(userInfoRespVO);
        loginRespVO.setAccountStatus(userInfoRespVO.getUserStatus());
        return loginRespVO;
    }

    private UcAccountEntity validLoginNoPwd(CloudAccountLoginReqVO accountLoginReqVO) {
        UcAccountEntity queryUcAccountEntity = new UcAccountEntity();
        queryUcAccountEntity.setAccountNo(accountLoginReqVO.getAccountNo());
        queryUcAccountEntity.setUserType(UserEnums.UserTypeEnum.DOCTOR.getUserTypeValue());
        queryUcAccountEntity.setAppCode(accountLoginReqVO.getAppCode());
        queryUcAccountEntity.setStatus(AccountEnums.AccountStatusEnum.NORMAL.getValue());
        Optional ucAccountEntityOptional = this.getUcAccountEntity(queryUcAccountEntity);
        UcAccountEntity accountEntity = (UcAccountEntity)ucAccountEntityOptional.get();
        return accountEntity;
    }

    private Optional<UcAccountEntity> getUcAccountEntity(UcAccountEntity queryUcAccountEntity) {
        Short status;
        String appCode;
        Short userType;
        String accountNo = queryUcAccountEntity.getAccountNo();
        Optional ucAccountEntityOptional = this.ucAccountMapper.selectByAccountNoAndUserTypeAndAppCodeAndStatus(accountNo, userType = queryUcAccountEntity.getUserType(), appCode = queryUcAccountEntity.getAppCode(), status = queryUcAccountEntity.getStatus());
        if (!ucAccountEntityOptional.isPresent()) {
            status = AccountEnums.AccountStatusEnum.PROHIBIT.getValue();
            Optional prohibitAccountOptional = this.ucAccountMapper.selectByAccountNoAndUserTypeAndAppCodeAndStatus(accountNo, userType, appCode, status);
            if (prohibitAccountOptional.isPresent()) {
                this.log.warn("\u8d26\u6237\u5df2\u7ecf\u88ab\u7981\u7528\uff0c\u8d26\u6237\u767b\u5f55\u4fe1\u606f[{}]", (Object)prohibitAccountOptional);
                throw new UserCenterRuntimeException(ErrorEnum.DISABLED_ACCOUNT);
            }
            this.log.warn("\u672a\u67e5\u8be2\u53ef\u7528\u7684\u8d26\u6237\u4fe1\u606f\uff0c\u8d26\u6237\u767b\u5f55\u4fe1\u606f[{}]", (Object)prohibitAccountOptional);
            throw new UserCenterRuntimeException(ErrorEnum.NO_ACCOUNT);
        }
        return ucAccountEntityOptional;
    }

    private UcAccountEntity validLoginAccount(AccountLoginReqVO accountLoginReqVO) {
        UcAccountEntity queryUcAccountEntity = new UcAccountEntity();
        queryUcAccountEntity.setAccountNo(accountLoginReqVO.getAccountNo());
        queryUcAccountEntity.setUserType(accountLoginReqVO.getUserType());
        queryUcAccountEntity.setAppCode(accountLoginReqVO.getAppCode());
        queryUcAccountEntity.setStatus(AccountEnums.AccountStatusEnum.NORMAL.getValue());
        Optional ucAccountEntityOptional = this.getUcAccountEntity(queryUcAccountEntity);
        UcAccountEntity accountEntity = (UcAccountEntity)ucAccountEntityOptional.get();
        String pwd = PasswordUtil.mix((String)accountLoginReqVO.getPassword(), (String)accountEntity.getPwSalt());
        if (!pwd.equals(accountEntity.getAccountPw())) {
            this.log.info("\u767b\u5f55\u5bc6\u7801\u6821\u9a8c\u5931\u8d25\uff0c\u7528\u6237\u767b\u5f55\u4fe1\u606f[{}]", (Object)accountLoginReqVO);
            throw new UserCenterRuntimeException(ErrorEnum.INVALID_PASSWORD);
        }
        return accountEntity;
    }

    private Boolean validNewPassword(UcAccountEntity ucAccountEntity, String passwordNew) {
        String newPwd = PasswordUtil.mix((String)passwordNew, (String)ucAccountEntity.getPwSalt());
        if (newPwd.equals(ucAccountEntity.getAccountPw())) {
            this.log.info("\u627e\u56de\u5bc6\u7801 \u65b0\u5bc6\u7801\u4e0e\u65e7\u5bc6\u7801\u4e0d\u80fd\u76f8\u540c\uff0c\u65b0\u5bc6\u7801[{}]", (Object)passwordNew);
            throw new UserCenterRuntimeException(ErrorEnum.INVALID_NEW_PASSWORD);
        }
        return true;
    }

    private void deleteAllToken(String userId, String appCode) {
        for (LoginDeviceType loginDeviceType : LoginDeviceType.values()) {
            String tokenKey = Tokenutil.genTokenKey((String)userId, (String)appCode, (String)loginDeviceType.toString());
            if (this.cacheService.delLoginToken(tokenKey)) continue;
            this.log.warn("\u7f13\u5b58\u5220\u9664\u5931\u8d25,tokenKey={}", (Object)tokenKey);
            throw new UserCenterRuntimeException(ErrorEnum.TOKEN_DELETE_FAIL);
        }
    }

    private void deletaAllTokenExceptOne(String userId, String appCode, String deviceType) {
        if (StringUtils.isEmpty((Object)deviceType)) {
            this.deleteAllToken(userId, appCode);
        }
        for (LoginDeviceType loginDeviceType : LoginDeviceType.values()) {
            String tokenKey = Tokenutil.genTokenKey((String)userId, (String)appCode, (String)loginDeviceType.toString());
            if (deviceType.equals(loginDeviceType.toString()) || this.cacheService.delLoginToken(tokenKey)) continue;
            this.log.warn("\u7f13\u5b58\u5220\u9664\u5931\u8d25,tokenKey={}", (Object)tokenKey);
            throw new UserCenterRuntimeException(ErrorEnum.TOKEN_DELETE_FAIL);
        }
    }

    private void checkAccountPassword(AccountOperateBaseReqVO accountOperateBaseReqVO, UcAccountEntity account) {
        if (accountOperateBaseReqVO.getNeedCheckPw().booleanValue()) {
            if (StringUtils.isEmpty((Object)accountOperateBaseReqVO.getPassword())) {
                throw new UserCenterRuntimeException(ErrorEnum.INVALID_PASSWORD, "\u767b\u5f55\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
            String password = accountOperateBaseReqVO.getPassword().trim();
            String mixPassword = PasswordUtil.mix((String)password, (String)account.getPwSalt());
            if (!account.getAccountPw().equals(mixPassword)) {
                throw new UserCenterRuntimeException(ErrorEnum.INVALID_PASSWORD, "\u767b\u5f55\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
        }
    }

    private void accountCancelLinkAction(UcAccountEntity account, String cacheToken) {
        Optional patientInfo;
        if (UserEnums.UserTypeEnum.PATIENT.getUserTypeValue().equals(account.getUserType()) && (patientInfo = this.ucPatientInfoMapper.findByUserIdAndPatientInfoStatus(account.getUserId(), UserEnums.PatientInfoStatusEnum.BINDING.getBinding())).isPresent() && !((List)patientInfo.get()).isEmpty()) {
            List patientInfoList = (List)patientInfo.get();
            String userId = account.getUserId();
            this.messageService.tokenInvalidMsg(cacheToken, CommonEnums.TokenInvalidCause.ULINK_PATIENT);
            String patientId = null;
            for (UcPatientInfoEntity patientInfoEntity : patientInfoList) {
                patientId = patientInfoEntity.getPatientId();
                patientInfoEntity.setPatientInfoStatus(UserEnums.PatientInfoStatusEnum.UNBINGDING.getBinding());
                this.ucPatientInfoMapper.save(patientInfoEntity);
                UcPatientOperateEntity patientOperateEntity = new UcPatientOperateEntity(account.getAccountId(), userId, patientId, patientInfoEntity.getId(), UserEnums.PatientInfoStatusEnum.UNBINGDING.getBinding(), UserEnums.PatientOperatorEnum.ACCOUNT_CANCEL.getUserType());
                this.ucPatientOperateMapper.save(patientOperateEntity);
                this.messageService.patientActionMsg(userId, patientId, UserEnums.PatientInfoStatusEnum.UNBINGDING);
            }
        }
    }

    public BaseResponse<WechatRespVO> getWxApplet(WxAppletReqVO wxAppletReqVO) {
        Map map = (Map)JSONArray.parseObject((String)this.wxDeploy).get((Object)wxAppletReqVO.getAppIdType());
        if (null == map) {
            return BaseResponse.error((String)"\u672a\u83b7\u53d6appid\u548csecret!");
        }
        String WXAppid = map.get("WXAppid") + "";
        String WXSecret = map.get("WXSecret") + "";
        this.log.info("\u83b7\u53d6openId\u5165\u53c2\uff1a[{}],\u83b7\u53d6WXAppid\uff1a[{}],\u83b7\u53d6WXSecret\uff1a[{}]", new Object[]{JsonUtil.convertObject((Object)wxAppletReqVO), WXAppid, WXSecret});
        WxMaInMemoryConfig wxMaConfig = new WxMaInMemoryConfig();
        wxMaConfig.setAppid(WXAppid);
        wxMaConfig.setSecret(WXSecret);
        WxMaServiceImpl wxService = new WxMaServiceImpl();
        wxService.setWxMaConfig((WxMaConfig)wxMaConfig);
        WechatRespVO outputVo = new WechatRespVO();
        try {
            WxMaJscode2SessionResult session = wxService.getUserService().getSessionInfo(wxAppletReqVO.getCode());
            this.log.info("\u83b7\u53d6openId\u8fd4\u56de\u503c\uff1a[{}]", (Object)JsonUtil.convertObject((Object)session));
            String openId = session.getOpenid();
            String unionId = session.getUnionid();
            Optional byUserIdAndUserTypeAndStatus = this.ucWxAuthMapper.findByUserIdAndUserTypeAndStatus(wxAppletReqVO.getUserId(), Short.valueOf(wxAppletReqVO.getUserType()), Short.valueOf("1"));
            UcWxAuthEntity ucWxAuthEntity = new UcWxAuthEntity();
            ucWxAuthEntity.setAccountId(wxAppletReqVO.getAccountId());
            ucWxAuthEntity.setUserId(wxAppletReqVO.getUserId());
            ucWxAuthEntity.setWxOpenid(openId);
            ucWxAuthEntity.setWxUnionid(unionId);
            ucWxAuthEntity.setUserType(Short.valueOf(wxAppletReqVO.getUserType()));
            ucWxAuthEntity.setSubordinateType(Short.valueOf(wxAppletReqVO.getSubordinateType()));
            ucWxAuthEntity.setAppIdType(wxAppletReqVO.getAppIdType());
            ucWxAuthEntity.setStatus(Short.valueOf("1"));
            ucWxAuthEntity.setUpdateTime(new Date());
            if (byUserIdAndUserTypeAndStatus.isPresent()) {
                ucWxAuthEntity.setId(((UcWxAuthEntity)byUserIdAndUserTypeAndStatus.get()).getId());
            } else {
                ucWxAuthEntity.setCreateTime(new Date());
            }
            WxBindingReqVo wxBindingReqVo = new WxBindingReqVo();
            BeanUtils.copyProperties((Object)ucWxAuthEntity, (Object)wxBindingReqVo);
            this.wxBinding(wxBindingReqVo);
            outputVo.setOpenId(openId);
            outputVo.setUnionId(unionId);
            String sessionKey = session.getSessionKey();
            String sessionId = RandomUtil.getRandom();
            this.redisUtil.set(sessionId, (Object)(sessionKey + "," + openId));
            outputVo.setSessionId(sessionId);
        }
        catch (WxErrorException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return BaseResponse.success((Object)outputVo);
    }

    public BaseResponse<WechatRespVO> wxLogin(WeChatLoginReqVO weChatLoginReqVO) {
        Optional wxAuthOp = this.ucWxAuthMapper.findByWxOpenidAndUserTypeAndSubordinateType(weChatLoginReqVO.getOpenId(), UserEnums.UserTypeEnum.getByTypeValue((Short)weChatLoginReqVO.getUserType()), weChatLoginReqVO.getRequestType());
        if (wxAuthOp.isPresent()) {
            UcWxAuthEntity wxAuth = (UcWxAuthEntity)wxAuthOp.get();
            if (WxAuthEnums.WxAuthStatusEnum.PROHIBIT.equals((Object)wxAuth.getStatus())) {
                return BaseResponse.error((IError)ErrorEnum.WECHAT_FORBID);
            }
            if (WxAuthEnums.WxAuthStatusEnum.UNBIND.equals((Object)wxAuth.getStatus())) {
                return BaseResponse.success((Object)new WechatRespVO(wxAuth.getWxOpenid(), wxAuth.getWxUnionid(), null, weChatLoginReqVO.getUserType(), weChatLoginReqVO.getSubordinateType(), WxAuthEnums.WxAuthStatusEnum.UNBIND.getValue()));
            }
            UcAccountEntity account = this.getRightAccount(wxAuth.getAccountId());
            if (!wxAuth.getUserId().equals(account.getUserId()) || !wxAuth.getUserType().equals(account.getUserType())) {
                this.log.warn("\u5fae\u4fe1\u7ed1\u5b9a\u7528\u6237\u4e0e\u8d26\u6237\u5b9e\u9645\u6240\u5c5e\u8d26\u6237\u4e0d\u5339\u914d,\u8bf7\u6c42\u4fe1\u606f={}\uff0c\u8d26\u6237={}", (Object)JsonUtil.convertObject((Object)weChatLoginReqVO), (Object)JsonUtil.convertObject((Object)account));
                return BaseResponse.error((IError)ErrorEnum.USER_NOT_MATCH);
            }
            UserEntity userEntity = this.userService.getUserEntity(account.getUserId(), account.getUserType());
            if (userEntity == null) {
                this.log.warn("\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684\u7528\u6237\u4fe1\u606f,\u8bf7\u6c42\u4fe1\u606f[{}],\u8d26\u6237\u4fe1\u606f={}", (Object)JsonUtil.convertObject((Object)weChatLoginReqVO), (Object)JsonUtil.convertObject((Object)account));
                return BaseResponse.error((IError)ErrorEnum.USER_NOT_EXIT);
            }
            CloudAccountLoginReqVO accountLoginReqVO = new CloudAccountLoginReqVO();
            accountLoginReqVO.setLoginDeviceNum(weChatLoginReqVO.getLoginDeviceNum());
            accountLoginReqVO.setLoginDeviceType(weChatLoginReqVO.getLoginDeviceType());
            accountLoginReqVO.setAppCode(weChatLoginReqVO.getAppCode());
            accountLoginReqVO.setChannelCode(weChatLoginReqVO.getChannelCode());
            accountLoginReqVO.setLoginIp(weChatLoginReqVO.getLoginIp());
            String tokenKey = this.loginInfoValid(accountLoginReqVO, account);
            String loginToken = this.genLoginToken(accountLoginReqVO, account, tokenKey);
            WechatRespVO data = this.createWeChatLoginResp(account, userEntity, loginToken, wxAuth);
            return BaseResponse.success((Object)data);
        }
        UcWxAuthEntity wxAuth = new UcWxAuthEntity();
        wxAuth.setNickname(weChatLoginReqVO.getNickname());
        wxAuth.setWxOpenid(weChatLoginReqVO.getOpenId());
        wxAuth.setWxUnionid(weChatLoginReqVO.getUnionId());
        wxAuth.setUserType(weChatLoginReqVO.getUserType());
        wxAuth.setHeadPortrait(weChatLoginReqVO.getHeadimg());
        wxAuth.setStatus(WxAuthEnums.WxAuthStatusEnum.UNBIND.getValue());
        wxAuth.setSubordinateType(weChatLoginReqVO.getSubordinateType());
        this.ucWxAuthMapper.save(wxAuth);
        return BaseResponse.success((Object)new WechatRespVO(weChatLoginReqVO.getOpenId(), weChatLoginReqVO.getUnionId(), null, weChatLoginReqVO.getUserType(), weChatLoginReqVO.getSubordinateType(), WxAuthEnums.WxAuthStatusEnum.UNBIND.getValue()));
    }

    public BaseResponse<AccountLoginRespVO> smsLogin(SmsLoginReqVO smsLoginReqVO) {
        UcAccountEntity accountEntity = this.getAccountEntity(smsLoginReqVO.getAccountNo(), smsLoginReqVO.getUserType());
        if (accountEntity == null) {
            this.log.warn("\u672a\u67e5\u8be2\u5230\u8d26\u6237:[{}]\u4fe1\u606f", (Object)smsLoginReqVO.getAccountNo());
            throw new UserCenterRuntimeException(ErrorEnum.NO_ACCOUNT);
        }
        UserEntity userEntity = this.userService.getUserEntity(accountEntity.getUserId(), accountEntity.getUserType());
        if (userEntity == null) {
            this.log.warn("\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684\u7528\u6237\u4fe1\u606f,\u8bf7\u6c42\u4fe1\u606f[{}]" + smsLoginReqVO);
            throw new UserCenterRuntimeException(ErrorEnum.USER_NOT_EXIT);
        }
        String tokenKey = this.loginInfoValid((CloudAccountLoginReqVO)smsLoginReqVO, accountEntity);
        String loginToken = this.genLoginToken((CloudAccountLoginReqVO)smsLoginReqVO, accountEntity, tokenKey);
        AccountLoginRespVO accountLoginResp = this.createAccountLoginResp(accountEntity, userEntity, loginToken);
        accountLoginResp.setName(accountLoginResp.getUserInfoRespVO().getName());
        accountLoginResp.setHeadPortrait(accountLoginResp.getUserInfoRespVO().getHeadPortrait());
        accountLoginResp.setContactMobile(accountLoginResp.getUserInfoRespVO().getContactMobile());
        accountLoginResp.setNickName(accountLoginResp.getUserInfoRespVO().getNickName());
        return BaseResponse.success((Object)accountLoginResp);
    }

    public BaseResponse<AccountLoginRespVO> smsLogin(CusSmsLoginReqVO reqVO) {
        BaseResponse checkMsgResp;
        this.log.info("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u767b\u5f55 \u8c03\u7528\u7528\u6237\u4e2d\u5fc3\u8bf7\u6c42\u53c2\u6570{}", (Object)reqVO);
        if (StringUtils.isEmpty((Object)reqVO.getVercodeKey()) && StringUtils.isEmpty((Object)reqVO.getVercodeValue()) && LoginDeviceType.WEB.equals((Object)reqVO.getLoginDeviceType()) && !UserEnums.UserTypeEnum.DOCTOR.getUserTypeValue().equals(reqVO.getUserType()) && (super.isVercodeIP(reqVO.getLoginIp()).booleanValue() || super.isVercodePhone(reqVO.getAccountNo()).booleanValue())) {
            this.log.info("PC\u7aef\u767b\u5f55 \u9700\u8981\u8fdb\u884c\u56fe\u6587\u9a8c\u8bc1");
            return BaseResponse.error((IError)ErrorEnum.VERCODE_NEED_YES);
        }
        if (!(StringUtils.isEmpty((Object)reqVO.getVercodeKey()) || StringUtils.isEmpty((Object)reqVO.getVercodeValue()) || super.verifyVercode(reqVO.getVercodeKey(), reqVO.getVercodeValue()))) {
            return BaseResponse.error((IError)ErrorEnum.VERCODE_ERROR, (String)"\u56fe\u6587\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
        }
        if (reqVO.getAuthKey() == null) {
            this.log.error("\u77ed\u4fe1\u6821\u9a8c\u7801\u767b\u5f55 \u53c2\u6570\u9519\u8bef\uff0c\u77ed\u4fe1\u552f\u4e00key\uff08authKey\uff09\u4e0d\u80fd\u4e3a\u7a7a");
            return BaseResponse.error((String)"\u77ed\u4fe1\u767b\u5f55\u5f02\u5e38");
        }
        SmsVerifiAuthCodeReqVO smsVerifiAuthCodeReqVo = new SmsVerifiAuthCodeReqVO();
        smsVerifiAuthCodeReqVo.setAuthCode(reqVO.getAuthCode());
        smsVerifiAuthCodeReqVo.setAuthKey(reqVO.getAuthKey());
        smsVerifiAuthCodeReqVo.setOperate(SMS_DEL_FLAG);
        smsVerifiAuthCodeReqVo.setPhoneNum(reqVO.getAccountNo());
        this.log.info("\u8d26\u6237\u767b\u9646\uff0c\u8c03\u7528\u63a8\u9001\u670d\u52a1\uff0c\u6821\u9a8c\u77ed\u4fe1\u9a8c\u8bc1\u7801\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)smsVerifiAuthCodeReqVo));
        try {
            checkMsgResp = this.smsApiClient.verifiSmsAuthCode(smsVerifiAuthCodeReqVo);
        }
        catch (Exception e) {
            this.log.error("\u8d26\u6237\u767b\u9646\uff0c\u8c03\u7528\u63a8\u9001\u670d\u52a1\uff0c\u6821\u9a8c\u77ed\u4fe1\u9a8c\u8bc1\u7801 \u5f02\u5e38\uff0c{}", (Object)e.getMessage());
            return BaseResponse.error((IError)IError.DefaultErrorEnum.PARAM_CHECK_FAILD, (String)"\u8c03\u7528\u77ed\u4fe1\u6821\u9a8c\u670d\u52a1\u5f02\u5e38");
        }
        this.log.info("\u8d26\u6237\u767b\u9646\uff0c\u6821\u9a8c\u77ed\u4fe1\u9a8c\u8bc1\u7801\uff0c\u8fd4\u56de\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)checkMsgResp));
        if (!checkMsgResp.isSuccess()) {
            return checkMsgResp;
        }
        SmsLoginReqVO smsLoginReqVO = new SmsLoginReqVO();
        smsLoginReqVO.setUserType(reqVO.getUserType());
        smsLoginReqVO.setAccountNo(reqVO.getAccountNo());
        smsLoginReqVO.setAppCode(reqVO.getAppCode());
        smsLoginReqVO.setChannelCode(reqVO.getChannelCode());
        smsLoginReqVO.setLoginDeviceNum(reqVO.getLoginDeviceNum());
        smsLoginReqVO.setLoginDeviceType(reqVO.getLoginDeviceType());
        smsLoginReqVO.setLoginIp(reqVO.getLoginIp());
        this.log.info("\u8d26\u6237\u767b\u9646\uff0c\u8c03\u7528\u7528\u6237\u4e2d\u5fc3\u767b\u9646\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)smsLoginReqVO));
        BaseResponse accountLoginRespVO = this.smsLogin(smsLoginReqVO);
        this.log.info("\u8d26\u6237\u767b\u9646\uff0c\u8c03\u7528\u7528\u6237\u4e2d\u5fc3\u767b\u9646\uff0c\u8fd4\u56de\u53c2\u6570{}", (Object)JsonUtil.convertObject((Object)accountLoginRespVO));
        try {
            if (UserEnums.UserTypeEnum.MANAGER.getUserTypeValue().equals(reqVO.getUserType())) {
                BaseResponse cloudUserScope = this.dataScopeClient.getCloudUserScope(((AccountLoginRespVO)accountLoginRespVO.getData()).getUserId());
                String url = this.doctoruserDomain + "/api/v1/organ_auth/saveMgrDataAuth";
                this.restTemplate.postForObject(url, cloudUserScope.getData(), Map.class, new Object[0]);
                if ("0".equalsIgnoreCase(cloudUserScope.getCode())) {
                    this.log.info("\u767b\u5f55 \u83b7\u53d6\u7ba1\u7406\u5458\u6570\u636e\u6743\u9650 \u5f02\u5e38 code:{},msg:{}", ((Map)cloudUserScope.getData()).get("errCode"), ((Map)cloudUserScope.getData()).get("msg"));
                } else {
                    this.log.info("\u767b\u5f55 \u83b7\u53d6\u7ba1\u7406\u5458\u6570\u636e\u6743\u9650 \u6210\u529f map:{}", (Object)cloudUserScope);
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u767b\u5f55 \u83b7\u53d6\u7ba1\u7406\u5458\u6570\u636e\u6743\u9650 \u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
        if (!accountLoginRespVO.isSuccess()) {
            this.log.warn("\u8c03\u7528\u7528\u6237\u4e2d\u5fc3\u767b\u5f55\u5931\u8d25");
            return BaseResponse.error((String)accountLoginRespVO.getMsg());
        }
        return BaseResponse.success((Object)accountLoginRespVO.getData());
    }

    private UcAccountEntity getAccountEntity(String phoneNo, Short userType) {
        Optional accountEntityOptional = this.ucAccountMapper.selectByAccountNoAndUserType(phoneNo, userType);
        if (accountEntityOptional.isPresent()) {
            return (UcAccountEntity)accountEntityOptional.get();
        }
        return null;
    }

    private WechatRespVO createWeChatLoginResp(UcAccountEntity account, UserEntity userEntity, String loginToken, UcWxAuthEntity wxAuth) {
        WechatRespVO data = new WechatRespVO();
        BeanUtils.copyProperties((Object)account, (Object)data);
        data.setToken(loginToken);
        UserInfoRespVO userInfoRespVO = this.userService.getUserInfoRespVO(userEntity, account.getUserType());
        data.setUserInfoRespVO(userInfoRespVO);
        data.setAccountStatus(userInfoRespVO.getUserStatus());
        data.setOpenId(wxAuth.getWxOpenid());
        data.setUnionId(wxAuth.getWxUnionid());
        data.setSubordinateType(wxAuth.getSubordinateType());
        data.setWxstatus(wxAuth.getStatus());
        return data;
    }

    private TokenBody parseToken(String accessToken) {
        try {
            TokenBody tokenBody = UserCenterTokenParseUtil.parse((String)accessToken, (String)JWT_SECRET);
            if (tokenBody.getTtl().before(new Date())) {
                this.log.warn("token\u89e3\u6790\u5f02\u5e38\uff0caccessToken{}", (Object)accessToken);
                return null;
            }
            return tokenBody;
        }
        catch (TokenParseException | ExpiredJwtException | MalformedJwtException | SignatureException e) {
            this.log.warn("token\u89e3\u6790\u5f02\u5e38\uff0caccessToken{}", (Object)accessToken);
            return null;
        }
    }

    private boolean checkToken(TokenJson tokenJson, UserCenterBaseReqVO baseReq) {
        if (tokenJson == null) {
            return false;
        }
        if (tokenJson.getAppCode().equals(baseReq.getAppCode())) {
            return true;
        }
        return tokenJson.getChannelCode().equals(baseReq.getChannelCode());
    }

    public BaseResponse<BaseUserCenterIdRespVO> wxBinding(WxBindingReqVo wxBindingReqVo) {
        this.log.info("\u5fae\u4fe1\u8d26\u53f7\u7ed1\u5b9a  \u5173\u6ce8\u5fae\u4fe1\u516c\u4f17\u53f7  \u8bf7\u6c42\u53c2\u6570{}", (Object)wxBindingReqVo);
        new Thread(() -> WXLabelUtil.accessToken((RestTemplate)this.restTemplate, (RedisUtil)this.redisUtil, (String)this.WXAppid, (String)this.WXSecret, (String)wxBindingReqVo.getWxOpenid(), (String)"\u7528\u6237")).start();
        this.log.info("\u5fae\u4fe1\u8d26\u53f7\u7ed1\u5b9a \u5165\u53c2\uff1awxBindingReqVo\uff1a{}", (Object)wxBindingReqVo);
        Optional wxopenIdOptional = this.ucWxAuthMapper.findByWxOpenidAndUserTypeAndSubordinateType(wxBindingReqVo.getWxOpenid(), wxBindingReqVo.getUserType(), wxBindingReqVo.getSubordinateType());
        Optional userOptional = this.ucWxAuthMapper.findByUserIdAndUserTypeAndStatus(wxBindingReqVo.getUserId(), wxBindingReqVo.getUserType(), WxAuthEnums.WxAuthStatusEnum.NORMAL.getValue());
        boolean userIdExist = userOptional.isPresent();
        boolean openIdExist = wxopenIdOptional.isPresent();
        this.log.info("\u5fae\u4fe1\u8d26\u53f7\u7ed1\u5b9a userIdExist:{},openIdExist:{}", (Object)userIdExist, (Object)openIdExist);
        if (userIdExist || openIdExist) {
            if (openIdExist && userIdExist) {
                if (((UcWxAuthEntity)userOptional.get()).getUserId().equals(((UcWxAuthEntity)wxopenIdOptional.get()).getUserId())) {
                    this.log.info("\u5fae\u4fe1\u8d26\u53f7\u7ed1\u5b9a \u540c\u4e00\u6761\u8bb0\u5f55 \u6210\u529f {}", wxopenIdOptional.get());
                    BaseUserCenterIdRespVO baseUserCenterIdRespVO = new BaseUserCenterIdRespVO(wxBindingReqVo.getAccountId(), wxBindingReqVo.getUserId());
                    return new BaseResponse("1", "\u64cd\u4f5c\u6210\u529f", (Object)baseUserCenterIdRespVO);
                }
                this.ucWxAuthMapper.deleteById(((UcWxAuthEntity)userOptional.get()).getId());
                this.log.info("\u5220\u9664\u5df2\u5b58\u5728\u7684user\u7ed1\u5b9a\u4fe1\u606f userOptional:{}", userOptional.get());
                UcWxAuthEntity wxAuthEntity = (UcWxAuthEntity)wxopenIdOptional.get();
                wxAuthEntity.setAccountId(wxBindingReqVo.getAccountId());
                wxAuthEntity.setUserId(wxBindingReqVo.getUserId());
                wxAuthEntity.setHeadPortrait(wxBindingReqVo.getHeadPortrait());
                wxAuthEntity.setNickname(wxBindingReqVo.getNickname());
                wxAuthEntity.setWxUnionid(wxBindingReqVo.getWxUnionid());
                wxAuthEntity.setStatus(WxAuthEnums.WxAuthStatusEnum.NORMAL.getValue());
                wxAuthEntity.setUpdateTime(new Date());
                this.log.info("\u5fae\u4fe1\u8d26\u53f7\u7ed1\u5b9a \u66f4\u65b0\u6570\u636ewxAuthEntity:{}", (Object)wxAuthEntity);
                this.ucWxAuthMapper.updateByPrimaryKeySelective(wxAuthEntity);
                this.log.info("\u5fae\u4fe1\u8d26\u53f7\u7ed1\u5b9a  userId\u5b58\u5728&openId\u5b58\u5728 \u6210\u529f {}", (Object)wxAuthEntity);
                BaseUserCenterIdRespVO baseUserCenterIdRespVO = new BaseUserCenterIdRespVO(wxBindingReqVo.getAccountId(), wxBindingReqVo.getUserId());
                return new BaseResponse("1", "\u64cd\u4f5c\u6210\u529f", (Object)baseUserCenterIdRespVO);
            }
            if (openIdExist) {
                UcWxAuthEntity wxAuthEntity = (UcWxAuthEntity)wxopenIdOptional.get();
                wxAuthEntity.setAccountId(wxBindingReqVo.getAccountId());
                wxAuthEntity.setUserId(wxBindingReqVo.getUserId());
                wxAuthEntity.setUserType(wxBindingReqVo.getUserType());
                wxAuthEntity.setStatus(WxAuthEnums.WxAuthStatusEnum.NORMAL.getValue());
                wxAuthEntity.setUpdateTime(new Date());
                this.ucWxAuthMapper.updateByPrimaryKeySelective(wxAuthEntity);
                this.log.info("\u5fae\u4fe1\u8d26\u53f7\u7ed1\u5b9a  openId\u5b58\u5728 \u6210\u529f {}", (Object)wxAuthEntity);
                BaseUserCenterIdRespVO baseUserCenterIdRespVO = new BaseUserCenterIdRespVO(wxBindingReqVo.getAccountId(), wxBindingReqVo.getUserId());
                return new BaseResponse("1", "\u64cd\u4f5c\u6210\u529f", (Object)baseUserCenterIdRespVO);
            }
            UcWxAuthEntity wxAuthEntity = (UcWxAuthEntity)userOptional.get();
            wxAuthEntity.setWxOpenid(wxBindingReqVo.getWxOpenid());
            wxAuthEntity.setWxOpenid(wxBindingReqVo.getWxOpenid());
            wxAuthEntity.setUserType(wxBindingReqVo.getUserType());
            wxAuthEntity.setSubordinateType(wxBindingReqVo.getSubordinateType());
            wxAuthEntity.setHeadPortrait(wxBindingReqVo.getHeadPortrait());
            wxAuthEntity.setNickname(wxBindingReqVo.getNickname());
            wxAuthEntity.setWxUnionid(wxBindingReqVo.getWxUnionid());
            wxAuthEntity.setStatus(WxAuthEnums.WxAuthStatusEnum.NORMAL.getValue());
            wxAuthEntity.setUpdateTime(new Date());
            this.ucWxAuthMapper.updateByPrimaryKeySelective(wxAuthEntity);
            this.log.info("\u5fae\u4fe1\u8d26\u53f7\u7ed1\u5b9a userId\u5b58\u5728 \u6210\u529f {}", (Object)wxAuthEntity);
            BaseUserCenterIdRespVO baseUserCenterIdRespVO = new BaseUserCenterIdRespVO(wxBindingReqVo.getAccountId(), wxBindingReqVo.getUserId());
            return new BaseResponse("1", "\u64cd\u4f5c\u6210\u529f", (Object)baseUserCenterIdRespVO);
        }
        UcWxAuthEntity wxAuth = new UcWxAuthEntity();
        BeanUtils.copyProperties((Object)wxBindingReqVo, (Object)wxAuth);
        wxAuth.setCreateTime(new Date());
        wxAuth.setUpdateTime(new Date());
        wxAuth.setStatus(WxAuthEnums.WxAuthStatusEnum.NORMAL.getValue());
        this.ucWxAuthMapper.insertSelective(wxAuth);
        this.log.info("\u5fae\u4fe1\u8d26\u53f7\u7ed1\u5b9a \u65b0\u589e \u6210\u529f {}", (Object)wxAuth);
        BaseUserCenterIdRespVO baseUserCenterIdRespVO = new BaseUserCenterIdRespVO(wxBindingReqVo.getAccountId(), wxBindingReqVo.getUserId());
        return new BaseResponse("1", "\u64cd\u4f5c\u6210\u529f", (Object)baseUserCenterIdRespVO);
    }

    public BaseResponse<GetWxOpenidRespVO> getWxOpenid(GetWxOpenidReqVO getWxOpenidVO) {
        Map map = (Map)JSONArray.parseObject((String)this.wxDeploy).get((Object)getWxOpenidVO.getAppIdType());
        if (null == map) {
            return BaseResponse.error((String)"\u672a\u83b7\u53d6appid\u548csecret!");
        }
        String WXAppid = String.valueOf(map.get("WXAppid"));
        String WXSecret = String.valueOf(map.get("WXSecret"));
        this.log.info("\u83b7\u53d6\u5f53\u524d\u5fae\u4fe1\u7528\u6237openId\u5165\u53c2\uff1a[{}],\u83b7\u53d6WXAppid\uff1a[{}],\u83b7\u53d6WXSecret\uff1a[{}]", new Object[]{JsonUtil.convertObject((Object)getWxOpenidVO), WXAppid, WXSecret});
        WxMaInMemoryConfig wxMaConfig = new WxMaInMemoryConfig();
        wxMaConfig.setAppid(WXAppid);
        wxMaConfig.setSecret(WXSecret);
        WxMaServiceImpl wxService = new WxMaServiceImpl();
        wxService.setWxMaConfig((WxMaConfig)wxMaConfig);
        GetWxOpenidRespVO getWxOpenidRespVO = new GetWxOpenidRespVO();
        try {
            WxMaJscode2SessionResult session = wxService.getUserService().getSessionInfo(getWxOpenidVO.getCode());
            this.log.info("\u83b7\u53d6\u5f53\u524d\u5fae\u4fe1\u7528\u6237openId\u8fd4\u56de\u503c\uff1a[{}]", (Object)JsonUtil.convertObject((Object)session));
            String openId = session.getOpenid();
            String unionId = session.getUnionid();
            getWxOpenidRespVO.setCode(getWxOpenidVO.getCode());
            getWxOpenidRespVO.setOpenid(openId);
            getWxOpenidRespVO.setUnionid(unionId);
        }
        catch (WxErrorException e) {
            this.log.error("\u83b7\u53d6\u5f53\u524d\u5fae\u4fe1\u7528\u6237openId\u5931\u8d25,Message:{},{}", (Object)e.getMessage(), (Object)e);
            return BaseResponse.error((String)"\u83b7\u53d6\u5f53\u524d\u5fae\u4fe1\u7528\u6237openId\u5931\u8d25");
        }
        return BaseResponse.success((Object)getWxOpenidRespVO);
    }
}

