/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.ebaiyihui.common.pojo.vo.card.CardBindLogReqVO;
import com.ebaiyihui.common.pojo.vo.card.CardBindLogRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.server.enums.CardEnums;
import com.ebaiyihui.server.pojo.entity.UcCardBindLogEntity;
import com.ebaiyihui.server.service.BaseService;
import com.ebaiyihui.server.service.ICardBindLogService;
import com.ebaiyihui.server.service.IUserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CardBindLogServiceImpl
extends BaseService
implements ICardBindLogService {
    @Autowired
    private IUserService userService;

    public BaseResponse<List<CardBindLogRespVO>> getCardBindLog(CardBindLogReqVO cardBindLogReqVo) {
        ArrayList<CardBindLogRespVO> bindLogResplist = new ArrayList<CardBindLogRespVO>();
        List bindLogList = this.cardBindLogMapper.findByCardId(cardBindLogReqVo.getCardId());
        if (CollectionUtils.isEmpty((Collection)bindLogList)) {
            this.log.warn("\u672a\u67e5\u8be2\u5230\u7ed1\u5361\u65e5\u5fd7\uff01cardId = {}", (Object)cardBindLogReqVo.getCardId());
            return BaseResponse.error((IError)IError.DATA_NOT_EXIST, (String)"\u672a\u67e5\u8be2\u5230\u7ed1\u5361\u65e5\u5fd7\uff01");
        }
        for (UcCardBindLogEntity ucCardBindLogEntity : bindLogList) {
            CardBindLogRespVO cardBindLogRespVo = new CardBindLogRespVO();
            cardBindLogRespVo.setAccountId(ucCardBindLogEntity.getAccountId());
            cardBindLogRespVo.setCardId(ucCardBindLogEntity.getCardId());
            cardBindLogRespVo.setCreateTime(ucCardBindLogEntity.getCreateTime());
            cardBindLogRespVo.setOperateType(Short.valueOf((short)ucCardBindLogEntity.getOperateType().ordinal()));
            cardBindLogRespVo.setOperateUser(Short.valueOf((short)ucCardBindLogEntity.getOperateUser().ordinal()));
            String operateTime = ucCardBindLogEntity.getCreateTime().toString();
            String operateUser = CardEnums.CardOperiteUserType.getDesc((CardEnums.CardOperiteUserType)ucCardBindLogEntity.getOperateUser());
            String operateType = CardEnums.CardBindStatus.getDesc((CardEnums.CardBindStatus)ucCardBindLogEntity.getOperateType());
            String managerName = "";
            String logDescription = operateTime.substring(0, operateTime.length() - 2) + " \u88ab" + managerName + operateUser + operateType;
            cardBindLogRespVo.setLogDescription(logDescription);
            bindLogResplist.add(cardBindLogRespVo);
        }
        List bindLogResplistResult = bindLogResplist.stream().sorted(Comparator.comparing(CardBindLogRespVO::getCreateTime).reversed()).collect(Collectors.toList());
        return BaseResponse.success(bindLogResplistResult);
    }
}

