/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.ebaiyihui.card.client.ICardHospitalFeignClient;
import com.ebaiyihui.card.client.ICardServiceFeginClient;
import com.ebaiyihui.card.common.vo.BindCardReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.card.common.vo.OrganConfigReqVO;
import com.ebaiyihui.card.common.vo.OrganConfigRespVO;
import com.ebaiyihui.card.common.vo.RegisterCardReqVO;
import com.ebaiyihui.card.common.vo.UpdateCardInfoReqVO;
import com.ebaiyihui.common.enums.ErrorEnum;
import com.ebaiyihui.common.pojo.vo.BaseReqVO;
import com.ebaiyihui.common.pojo.vo.card.CardDetailQueryReqVO;
import com.ebaiyihui.common.pojo.vo.card.CardDetailRespVO;
import com.ebaiyihui.common.pojo.vo.card.CardListQueryReqVO;
import com.ebaiyihui.common.pojo.vo.card.CardListRespVO;
import com.ebaiyihui.common.pojo.vo.card.OrganBindCountRespVO;
import com.ebaiyihui.common.pojo.vo.card.OrganCodeListReqVO;
import com.ebaiyihui.common.pojo.vo.card.UcBindCardReqVO;
import com.ebaiyihui.common.pojo.vo.card.UcCardListReqVO;
import com.ebaiyihui.common.pojo.vo.card.UcRegisterCardReqVO;
import com.ebaiyihui.common.pojo.vo.card.UnbindCardReqVO;
import com.ebaiyihui.common.pojo.vo.card.UnbindCardRespVO;
import com.ebaiyihui.common.pojo.vo.card.UpdateCardInfoVO;
import com.ebaiyihui.common.pojo.vo.card.UserCardListRespVO;
import com.ebaiyihui.common.pojo.vo.card.UserPatientListRespVO;
import com.ebaiyihui.common.token.TokenBody;
import com.ebaiyihui.common.token.TokenJson;
import com.ebaiyihui.common.token.exception.TokenParseException;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.framework.utils.IdCardUtil;
import com.ebaiyihui.framework.utils.JsonUtil;
import com.ebaiyihui.push.UmengApiClient;
import com.ebaiyihui.push.pojo.umeng.android.AndroidUnicastReqVO;
import com.ebaiyihui.push.pojo.umeng.ios.IOSUnicastReqVO;
import com.ebaiyihui.server.enums.CardEnums;
import com.ebaiyihui.server.enums.UserEnums;
import com.ebaiyihui.server.exception.UserCenterRuntimeException;
import com.ebaiyihui.server.pojo.bo.ExcelData;
import com.ebaiyihui.server.pojo.bo.OrganBindCountBO;
import com.ebaiyihui.server.pojo.entity.UcAccountEntity;
import com.ebaiyihui.server.pojo.entity.UcCardBindLogEntity;
import com.ebaiyihui.server.pojo.entity.UcPatientInfoEntity;
import com.ebaiyihui.server.pojo.entity.UcUserCardBindEntity;
import com.ebaiyihui.server.repository.UcAccountMapper;
import com.ebaiyihui.server.service.BaseService;
import com.ebaiyihui.server.service.ICacheService;
import com.ebaiyihui.server.service.ICardBindService;
import com.ebaiyihui.server.service.ICardHospitalService;
import com.ebaiyihui.server.service.IUserService;
import com.ebaiyihui.server.util.DateUtils;
import com.ebaiyihui.server.util.Tokenutil;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import jodd.util.StringUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class CardBindServiceImpl
extends BaseService
implements ICardBindService {
    @Autowired
    private ICardServiceFeginClient cardServiceFeginClient;
    @Autowired
    private IUserService userService;
    @Autowired
    private ICardHospitalFeignClient cardHospitaFeignClient;
    @Autowired
    private ICardHospitalService cardHospitaService;
    @Autowired
    private ICacheService cacheService;
    @Autowired
    private UmengApiClient umengApiClient;
    private static String ID_CARD_CODE = "01";
    private static String HOUSEHOLD_CARD_CODE = "09";
    @Autowired
    private UcAccountMapper ucAccountMapper;

    public BaseResponse<List<OrganBindCountRespVO>> getBindCount(OrganCodeListReqVO organCodeListReqVo) {
        ArrayList<OrganBindCountRespVO> organBindCountRespList = new ArrayList<OrganBindCountRespVO>();
        List organList = organCodeListReqVo.getOrganCodeReqVO();
        List cardCountlist = this.cardBindMapper.getCardCount(organList, organCodeListReqVo.getUserId(), CardEnums.CardBindStatus.BIND);
        HashMap<String, Long> cardCountMap = new HashMap<String, Long>();
        for (OrganBindCountBO organBindCountBo : cardCountlist) {
            cardCountMap.put(organBindCountBo.getOrganCode(), organBindCountBo.getBindCount());
        }
        for (String organCode : organList) {
            OrganBindCountRespVO organBindCountRespVO = new OrganBindCountRespVO();
            organBindCountRespVO.setOrganCode(organCode);
            if (cardCountMap.containsKey(organCode)) {
                organBindCountRespVO.setCount((Long)cardCountMap.get(organCode));
            } else {
                organBindCountRespVO.setCount(Long.valueOf(0L));
            }
            organBindCountRespList.add(organBindCountRespVO);
        }
        return BaseResponse.success(organBindCountRespList);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<UnbindCardRespVO> unbindCard(UnbindCardReqVO reqVo) {
        this.log.info("\u89e3\u7ed1\u5c31\u8bca\u5361\u8bf7\u6c42\u53c2\u6570={}", (Object)JsonUtil.convertObject((Object)reqVo));
        UcUserCardBindEntity userBind = this.cardBindMapper.findOneByUserIdAndCardId(reqVo.getUserId(), reqVo.getCardId());
        if (userBind != null) {
            UnbindCardRespVO data = new UnbindCardRespVO(reqVo);
            if (CardEnums.CardBindStatus.BIND.equals((Object)userBind.getBindStatus())) {
                OrganConfigReqVO organConfigReq = new OrganConfigReqVO(userBind.getOrganCode(), reqVo.getChannelCode());
                BaseResponse hospitalResp = this.cardHospitaFeignClient.getOrganConfig(organConfigReq);
                if (!hospitalResp.isSuccess()) {
                    this.log.warn("\u83b7\u53d6\u5c31\u8bca\u5361\u6240\u5c5e\u673a\u6784\u4fe1\u606f\u5931\u8d25,organCode={},\u54cd\u5e94={}", (Object)userBind.getOrganCode(), (Object)JsonUtil.convertObject((Object)hospitalResp));
                    return BaseResponse.error((IError)IError.FEIGN_FAIL, (String)hospitalResp.getMsg());
                }
                String ss = CardEnums.CardBindStatus.BIND.name();
                this.unbindCard(userBind, (OrganConfigRespVO)hospitalResp.getData());
                userBind.setUnbindReason(reqVo.getUnbindReason());
                this.cardBindMapper.save(userBind);
                UcCardBindLogEntity unbindLong = new UcCardBindLogEntity(reqVo.getAccountId(), reqVo.getCardId(), CardEnums.CardBindStatus.UNBIND, userBind.getId(), reqVo.getOperateUser());
                this.log.info("\u7ed1\u5361\u65e5\u5fd7\u4fdd\u5b58\u5bf9\u8c61,unbindLong = {}", (Object)unbindLong);
                this.cardBindLogMapper.save(unbindLong);
            }
            return BaseResponse.success((Object)data);
        }
        return BaseResponse.error((IError)ErrorEnum.BIND_CARD_NOT_EXIST);
    }

    public BaseResponse<CardDetailRespVO> getCardDetail(CardDetailQueryReqVO cardDetailQueryReqVO) {
        UcUserCardBindEntity ucUserCardBindEntity = this.cardBindMapper.findByBindStatusAndCardId(CardEnums.CardBindStatus.BIND, cardDetailQueryReqVO.getCardId());
        if (ucUserCardBindEntity == null) {
            this.log.warn("\u672a\u67e5\u8be2\u5230\u5361\u7ed1\u5b9a\u8be6\u60c5\uff0ccardId = {}", (Object)cardDetailQueryReqVO.getCardId());
            return BaseResponse.error((IError)IError.DATA_NOT_EXIST, (String)"\u672a\u67e5\u8be2\u5230\u5361\u7ed1\u5b9a\u8be6\u60c5!");
        }
        BaseResponse data = this.getCardDetailsInfoRespVOFromCardService(cardDetailQueryReqVO);
        if (!data.isSuccess()) {
            this.log.warn("\u672a\u4ece\u5c31\u8bca\u5361\u4e2d\u5fc3\u67e5\u8be2\u5230\u5361\u57fa\u7840\u4fe1\u606f\uff01");
            return BaseResponse.error((IError)IError.DATA_NOT_EXIST, (String)"\u672a\u4ece\u5c31\u8bca\u5361\u4e2d\u5fc3\u67e5\u8be2\u5230\u5361\u57fa\u7840\u4fe1\u606f\uff01");
        }
        CardDetailRespVO cardDetailRespVO = this.buildCardDetail((CardDetailsInfoRespVO)data.getData(), ucUserCardBindEntity, (BaseReqVO)cardDetailQueryReqVO);
        return BaseResponse.success((Object)cardDetailRespVO);
    }

    public BaseResponse<Map<String, Object>> getCardList(CardListQueryReqVO cardListQueryReqVO) {
        UcAccountEntity ucAccountEntity;
        if (StringUtil.isNotBlank((String)cardListQueryReqVO.getSearchParam()) && null != (ucAccountEntity = this.ucAccountMapper.selectByAccountNO(cardListQueryReqVO.getSearchParam())) && StringUtil.isNotEmpty((CharSequence)ucAccountEntity.getUserId())) {
            cardListQueryReqVO.setSearchParam(ucAccountEntity.getUserId());
        }
        PageHelper.startPage((int)cardListQueryReqVO.getPageNum(), (int)cardListQueryReqVO.getPageSize());
        Page byStatus = this.cardBindMapper.findByStatus(CardEnums.CardBindStatus.BIND, cardListQueryReqVO.getCardTypeCode(), cardListQueryReqVO.getOrganCode(), cardListQueryReqVO.getStartTime(), cardListQueryReqVO.getEndTime(), cardListQueryReqVO.getSearchParam());
        if (null != byStatus && byStatus.size() > 0) {
            for (CardListRespVO cardListRespVO : byStatus) {
                CardDetailsInfoReqVO cardStatusReqVO = new CardDetailsInfoReqVO();
                cardStatusReqVO.setCardId(cardListRespVO.getCardId());
                BaseResponse cardStatusFromCardService = this.getCardStatusFromCardService(cardStatusReqVO);
                if (null != cardStatusFromCardService.getData()) {
                    this.buildCardListRespVO(cardListRespVO, (CardDetailsInfoRespVO)cardStatusFromCardService.getData());
                    continue;
                }
                this.log.info("\u7efc\u5408\u7ba1\u7406\u5e73\u53f0\u83b7\u53d6\u5217\u8868\u6570\u636e\u5f02\u5e38\uff0c\u672a\u67e5\u8be2\u5230\u5361\u8be6\u7ec6\uff1a{}", (Object)JsonUtil.convertObject((Object)cardStatusReqVO));
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("total", byStatus.getTotal());
        map.put("pageData", byStatus.getResult());
        map.put("pages", byStatus.getPages());
        map.put("data", byStatus);
        List byStatusPatientNum = this.cardBindMapper.findByStatusPatientNum(CardEnums.CardBindStatus.BIND, cardListQueryReqVO.getCardTypeCode(), cardListQueryReqVO.getOrganCode(), cardListQueryReqVO.getStartTime(), cardListQueryReqVO.getEndTime(), cardListQueryReqVO.getSearchParam());
        if (null != byStatusPatientNum && byStatusPatientNum.size() > 0) {
            map.put("patientTotal", byStatusPatientNum.size());
        } else {
            map.put("patientTotal", 0);
        }
        return BaseResponse.success(map);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<CardDetailRespVO> bindCard(UcBindCardReqVO reqVo) {
        if (StringUtil.isNotEmpty((CharSequence)reqVo.getAccountNo()) && StringUtil.isEmpty((CharSequence)reqVo.getUserId())) {
            UcAccountEntity ucAccountEntity = this.ucAccountMapper.selectByAccountNO(reqVo.getAccountNo());
            if (null != ucAccountEntity) {
                reqVo.setUserId(ucAccountEntity.getUserId());
                reqVo.setAccountId(ucAccountEntity.getAccountId());
            } else {
                return BaseResponse.error((String)"\u7ed1\u5b9a\u8d26\u53f7\u4e0d\u5b58\u5728\uff01");
            }
        }
        this.log.info("\u6ce8\u518c\u5c31\u8bca\u5361\u5165\u53c2[{}]", (Object)reqVo.toString());
        this.checkBindCredParams(reqVo);
        if (this.checkFive(reqVo.getUserId(), reqVo.getCredNo()).booleanValue()) {
            throw new UserCenterRuntimeException(IError.PARAM_CHECK_FAILD, "\u6dfb\u52a0\u5931\u8d25\uff0c\u5c31\u8bca\u4eba\u5df2\u6ee1\u4e94\u4f4d\uff0c\u60a8\u53ef\u89e3\u7ed1\u540e\u6dfb\u52a0");
        }
        this.checkUserCanBindCard(reqVo.getUserId(), reqVo.getOrganCode(), reqVo.getChannelCode());
        return this.bindCardInHis(reqVo);
    }

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<CardDetailRespVO> registerCard(UcRegisterCardReqVO reqVo) {
        List byCardNo;
        if ("1703".equals(reqVo.getCardTypeCode())) {
            reqVo.setOrganCode("100000");
            reqVo.setOrganName("\u4f70\u533b\u5e73\u53f0");
        }
        if (StringUtil.isNotEmpty((CharSequence)reqVo.getAccountNo()) && StringUtil.isEmpty((CharSequence)reqVo.getUserId())) {
            UcAccountEntity ucAccountEntity = this.ucAccountMapper.selectByAccountNO(reqVo.getAccountNo());
            if (null != ucAccountEntity) {
                reqVo.setUserId(ucAccountEntity.getUserId());
                reqVo.setAccountId(ucAccountEntity.getAccountId());
            } else {
                return BaseResponse.error((String)"\u7ed1\u5b9a\u8d26\u53f7\u4e0d\u5b58\u5728\uff01");
            }
        }
        this.log.info("\u6ce8\u518c\u5c31\u8bca\u5361\u5165\u53c2[{}]", (Object)reqVo.toString());
        this.checkRegisterCredParams(reqVo);
        if (this.checkFive(reqVo.getUserId(), reqVo.getCredNo()).booleanValue()) {
            throw new UserCenterRuntimeException(IError.PARAM_CHECK_FAILD, "\u6dfb\u52a0\u5931\u8d25\uff0c\u5c31\u8bca\u4eba\u5df2\u6ee1\u4e94\u4f4d\uff0c\u60a8\u53ef\u89e3\u7ed1\u540e\u6dfb\u52a0");
        }
        this.checkUserCanBindCard(reqVo.getUserId(), reqVo.getOrganCode(), reqVo.getChannelCode());
        RegisterCardReqVO reqVO = this.buildregisterCardVO(reqVo);
        BaseResponse registerCardResp = this.cardServiceFeginClient.registerCard(reqVO);
        if (registerCardResp.isSuccess() && null != registerCardResp.getData() && null != (byCardNo = this.cardBindMapper.findByCardNo(((CardDetailsInfoRespVO)registerCardResp.getData()).getCardNo(), CardEnums.CardBindStatus.BIND)) && byCardNo.size() > 0) {
            throw new UserCenterRuntimeException(IError.PARAM_CHECK_FAILD, "\u8be5\u60a3\u8005\u5df2\u88ab\u6dfb\u52a0\uff0c\u8bf7\u5148\u89e3\u7ed1");
        }
        return this.handleCardResp((UcBindCardReqVO)reqVo, registerCardResp, CardEnums.CardSignType.REGISTER);
    }

    private Boolean checkFive(String userId, String credNo) {
        HashSet<String> credNos = new HashSet<String>();
        List byUserId = this.cardBindMapper.findByUserId(userId, CardEnums.CardBindStatus.BIND);
        for (UcUserCardBindEntity uucbe : byUserId) {
            CardDetailRespVO data;
            CardDetailQueryReqVO cardDetailQueryReqVO = new CardDetailQueryReqVO();
            cardDetailQueryReqVO.setCardId(uucbe.getCardId());
            BaseResponse cardDetail = this.getCardDetail(cardDetailQueryReqVO);
            if (!cardDetail.isSuccess() || null == (data = (CardDetailRespVO)cardDetail.getData())) continue;
            credNos.add(data.getCredNo());
        }
        this.log.info("\u6821\u9a8c5\u4e2a\u4eba\u8eab\u4efd\u8bc1\u53f7[{}]", (Object)((Object)credNos).toString());
        if (credNos.size() >= 5 && !credNos.contains(credNo)) {
            return true;
        }
        return false;
    }

    public BaseResponse<List<UserPatientListRespVO>> getUserCardList(UcCardListReqVO reqVo) {
        List byUserIdAndOrganCode = this.cardBindMapper.findByUserIdAndOrganCode(reqVo.getUserId(), reqVo.getOrganCode(), CardEnums.CardBindStatus.BIND);
        if (null != byUserIdAndOrganCode && byUserIdAndOrganCode.size() > 0) {
            for (UserPatientListRespVO userPatientListRespVO : byUserIdAndOrganCode) {
                List byUserIdAndOrganCodeAndBindStatus = this.cardBindMapper.findByUserIdAndOrganCodeAndBindStatus(reqVo.getUserId(), reqVo.getOrganCode(), userPatientListRespVO.getPatientId(), CardEnums.CardBindStatus.BIND);
                if (null == byUserIdAndOrganCodeAndBindStatus) continue;
                userPatientListRespVO.setUserCardListRespVOS(byUserIdAndOrganCodeAndBindStatus);
                UserCardListRespVO userCardListRespVO = byUserIdAndOrganCodeAndBindStatus.stream().max(Comparator.comparing(UserCardListRespVO::getUpdateTime)).get();
                if (null == userCardListRespVO.getRelation()) continue;
                for (UserEnums.UserRelationEnum userRelationEnum : UserEnums.UserRelationEnum.values()) {
                    if (!userCardListRespVO.getRelation().equals(userRelationEnum.getUserRelation())) continue;
                    userPatientListRespVO.setRelation(userRelationEnum.getUserRelationDesc());
                }
            }
        }
        return BaseResponse.success((Object)byUserIdAndOrganCode);
    }

    public BaseResponse updateCardInfo(UpdateCardInfoVO reqVO) {
        int i = this.cardBindMapper.updateByUserIdAndCardId(reqVO.getUserId(), reqVO.getCardId(), reqVO.getRelation());
        UpdateCardInfoReqVO updateCardInfoReqVO = new UpdateCardInfoReqVO();
        BeanUtils.copyProperties((Object)reqVO, (Object)updateCardInfoReqVO);
        BaseResponse cardDetailsInfoRespVOBaseResponse = this.cardServiceFeginClient.updateCardInfo(updateCardInfoReqVO);
        if (cardDetailsInfoRespVOBaseResponse.isSuccess()) {
            return BaseResponse.success();
        }
        return BaseResponse.error((String)"fail!");
    }

    public BaseResponse<List<String>> getUserList(String patientId) {
        return BaseResponse.success((Object)this.cardBindMapper.getUserList(patientId));
    }

    public ExcelData cardExcel(CardListQueryReqVO reqVo) {
        BaseResponse cardList = this.getCardList(reqVo);
        Page data = (Page)((Map)cardList.getData()).get("data");
        ExcelData excelData = new ExcelData();
        excelData.setName("\u5361\u5217\u8868");
        excelData.setRows(this.doctorToExcel((List)data));
        excelData.setTitles(this.doctorTitle());
        return excelData;
    }

    private List<List<Object>> doctorToExcel(List<CardListRespVO> listVos) {
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        for (CardListRespVO vo : listVos) {
            result.add(this.doctorRow(vo));
        }
        return result;
    }

    private List<Object> doctorRow(CardListRespVO vo) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(vo.getPatientId());
        result.add(vo.getPatientName());
        result.add(vo.getCredTypeName());
        result.add(vo.getCredNo());
        if (vo.getGender() == 1) {
            result.add("\u7537");
        } else if (vo.getGender() == 2) {
            result.add("\u5973");
        }
        result.add(formatter.format(vo.getBirthdate()));
        result.add(vo.getTel());
        result.add(vo.getCardTypeName());
        result.add(vo.getCardNo());
        result.add(vo.getOrganName());
        result.add(vo.getAccountNo());
        result.add(formatter.format(vo.getBindTime()));
        return result;
    }

    private List<String> doctorTitle() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("\u60a3\u8005id");
        result.add("\u59d3\u540d");
        result.add("\u8bc1\u4ef6\u7c7b\u578b");
        result.add("\u8bc1\u4ef6\u53f7");
        result.add("\u6027\u522b");
        result.add("\u51fa\u751f\u5e74\u6708\u65e5");
        result.add("\u8054\u7cfb\u7535\u8bdd");
        result.add("\u5c31\u8bca\u5361\u7c7b\u578b");
        result.add("\u5c31\u8bca\u5361\u53f7");
        result.add("\u6240\u5c5e\u533b\u9662");
        result.add("\u7ed1\u5b9a\u8d26\u53f7");
        result.add("\u7ed1\u5b9a\u65f6\u95f4");
        return result;
    }

    private UcUserCardBindEntity checkCardCanBind(String cardNo, String organCode, String userId) {
        UcUserCardBindEntity ucUserCardBindEntity = null;
        List cards = this.cardBindMapper.findListByCardNoAndOrganCode(cardNo, organCode);
        if (CollectionUtils.isEmpty((Collection)cards)) {
            return ucUserCardBindEntity;
        }
        Date now = new Date();
        for (UcUserCardBindEntity userCardBind : cards) {
            if (CardEnums.CardBindStatus.BIND.equals((Object)userCardBind.getBindStatus())) {
                if (userCardBind.getUserId().equals(userId)) {
                    throw new UserCenterRuntimeException(ErrorEnum.CARD_BIND_ITSLEF);
                }
                throw new UserCenterRuntimeException(ErrorEnum.CARD_ALREADY_BIND);
            }
            if (CardEnums.CardBindStatus.UNBIND.equals((Object)userCardBind.getBindStatus()) && userCardBind.getCardReleaseTime().after(now)) {
                throw new UserCenterRuntimeException(ErrorEnum.CARD_NOT_RELEASE);
            }
            ucUserCardBindEntity = userCardBind;
        }
        return ucUserCardBindEntity;
    }

    private void checkUserCanBindCard(String userId, String organCode, String channelCode) {
        OrganConfigRespVO config = this.cardHospitaService.getOrganConfig(organCode);
        if (!ObjectUtils.isEmpty((Object)config)) {
            if (config.getCardSlot() == null || config.getCardSlot() < 0) {
                return;
            }
            Integer maxBindCardNum = config.getCardSlot();
            List cards = this.cardBindMapper.findListByUserIdAndOrganCode(userId, organCode);
            if (CollectionUtils.isEmpty((Collection)cards)) {
                return;
            }
            Date now = new Date();
            for (UcUserCardBindEntity userCardBind : cards) {
                Integer n;
                Integer n2;
                if (CardEnums.CardBindStatus.BIND.equals((Object)userCardBind.getBindStatus())) {
                    n2 = maxBindCardNum;
                    n = maxBindCardNum = Integer.valueOf(maxBindCardNum - 1);
                    continue;
                }
                if (!CardEnums.CardBindStatus.UNBIND.equals((Object)userCardBind.getBindStatus()) || !userCardBind.getCardReleaseTime().after(now)) continue;
                n2 = maxBindCardNum;
                n = maxBindCardNum = Integer.valueOf(maxBindCardNum - 1);
            }
            if (maxBindCardNum <= 0) {
                throw new UserCenterRuntimeException(IError.PARAM_CHECK_FAILD, "\u5df2\u8fbe\u6700\u5927\u7ed1\u5361\u6570\u91cf\u4e0a\u9650,\u7ed1\u5361\u5931\u8d25");
            }
            return;
        }
        throw new UserCenterRuntimeException(ErrorEnum.FEGIN_ERROR);
    }

    private BaseResponse<CardDetailRespVO> bindCardInHis(UcBindCardReqVO reqVo) {
        List byCardNo;
        BindCardReqVO reqVO = this.buildBindCardReqVO(reqVo);
        BaseResponse bindResult = this.cardServiceFeginClient.bindCard(reqVO);
        if (bindResult.isSuccess() && null != bindResult.getData() && null != (byCardNo = this.cardBindMapper.findByCardNo(((CardDetailsInfoRespVO)bindResult.getData()).getCardNo(), CardEnums.CardBindStatus.BIND)) && byCardNo.size() > 0) {
            throw new UserCenterRuntimeException(IError.PARAM_CHECK_FAILD, "\u8be5\u60a3\u8005\u5df2\u88ab\u6dfb\u52a0\uff0c\u8bf7\u5148\u89e3\u7ed1");
        }
        return this.handleCardResp(reqVo, bindResult, CardEnums.CardSignType.WINDOW);
    }

    private void sengUnbindCardMsg(UnbindCardReqVO reqVO, String cardNo) {
        String deviceType = reqVO.getLoginDeviceType().name();
        String appCode = reqVO.getAppCode();
        String userId = reqVO.getUserId();
        String tokenKey = Tokenutil.genTokenKey((String)userId, (String)appCode, (String)deviceType);
        String cacheToken = this.cacheService.getLoginToken(tokenKey);
        if (!StringUtils.isEmpty((Object)cacheToken)) {
            String secryKey = this.getSecryKey(appCode);
            String msg = String.format("\u7528\u6237\u60a8\u597d\uff0c\u60a8\u5c3e\u53f7%s\u7684\u5c31\u8bca\u5361\u5728%s\u5df2\u5728\u672c\u8d26\u6237\u6210\u529f\u89e3\u7ed1", cardNo.substring(cardNo.length() - 4, cardNo.length()), DateUtils.getCurrentDayTime());
            try {
                TokenBody tokenBody = Tokenutil.parse((String)cacheToken, (String)secryKey);
                TokenJson tokenJson = tokenBody.getTokenJson();
                String channelCode = tokenJson.getChannelCode();
                if (channelCode.contains("IOS")) {
                    IOSUnicastReqVO iosUnicastReqVO = new IOSUnicastReqVO();
                    HashMap<String, String> extra = new HashMap<String, String>();
                    extra.put("type", "unbind");
                    extra.put("userId", userId);
                    iosUnicastReqVO.setExtra(extra);
                    iosUnicastReqVO.setBody(msg);
                    iosUnicastReqVO.setBusiStyle(msg);
                    iosUnicastReqVO.setBusiCode("card_manage");
                    iosUnicastReqVO.setDeviceTokens(tokenJson.getDevicenumber());
                    iosUnicastReqVO.setSubTitle("\u89e3\u7ed1\u5c31\u8bca\u5361\u901a\u77e5");
                    iosUnicastReqVO.setUserId(userId);
                    iosUnicastReqVO.setUserType(UserEnums.UserTypeEnum.PATIENT.getUserTypeValue().shortValue());
                    BaseResponse iosUnicast = this.umengApiClient.pushUmIosUnicast(iosUnicastReqVO);
                    this.log.info("\u63a8\u9001\u89e3\u7ed1\u5c31\u8bca\u5361\u6210\u529f\u6d88\u606f\u5230IOS\u8bbe\u5907\uff0cuserID[{}],req[{}],response[{}]", new Object[]{userId, iosUnicastReqVO, iosUnicast});
                    return;
                }
                if (channelCode.contains("ANDROID")) {
                    AndroidUnicastReqVO unicastReqVO = new AndroidUnicastReqVO();
                    HashMap<String, String> extra = new HashMap<String, String>();
                    extra.put("type", "unbind");
                    extra.put("userId", userId);
                    unicastReqVO.setExtra(extra);
                    unicastReqVO.setCustom(JsonUtil.convertObject(extra));
                    unicastReqVO.setText(msg);
                    unicastReqVO.setBusiStyle(msg);
                    unicastReqVO.setBusiCode("card_manage");
                    unicastReqVO.setDeviceTokens(userId);
                    unicastReqVO.setTitle("\u89e3\u7ed1\u5c31\u8bca\u5361\u901a\u77e5");
                    unicastReqVO.setUserId(tokenJson.getUserId());
                    unicastReqVO.setUserType(UserEnums.UserTypeEnum.PATIENT.getUserTypeValue().shortValue());
                    BaseResponse iosUnicast = this.umengApiClient.pushUmAndroidUnicast(unicastReqVO);
                    this.log.info("\u63a8\u9001\u89e3\u7ed1\u5c31\u8bca\u5361\u6210\u529f\u6d88\u606f\u5230ANDROID\u8bbe\u5907\uff0cuserID[{}],req[{}],response[{}]", new Object[]{userId, unicastReqVO, iosUnicast});
                    return;
                }
            }
            catch (TokenParseException e) {
                this.log.info("\u63a8\u9001\u89e3\u7ed1\u5c31\u8bca\u5361\u6210\u529f\u6d88\u606f\u5230\u8bbe\u5907\u53d1\u751f\u5f02\u5e38\uff0cuserID[{}],e[{}]", (Object)userId, (Object)e);
            }
        }
        this.log.info("\u89e3\u7ed1\u5c31\u8bca\u5361\u63a8\u9001\u5931\u8d25,\u672a\u83b7\u53d6\u5230cacheToken,deviceType={},appCode={},userId={},tokenKey={}", new Object[]{deviceType, appCode, userId, tokenKey});
    }

    private void unbindCard(UcUserCardBindEntity userBind, OrganConfigRespVO hospitalConfig) {
        Integer slotReleaseTime;
        Date now = new Date();
        userBind.setBindStatus(CardEnums.CardBindStatus.UNBIND);
        userBind.setUnbindTime(now);
        Integer cardReleaseTime = hospitalConfig.getCardReleaseTime();
        if (cardReleaseTime != null && cardReleaseTime > 0) {
            userBind.setCardReleaseTime(DateUtils.dateModifOfSecond((Date)now, (int)cardReleaseTime));
        }
        if ((slotReleaseTime = hospitalConfig.getSlotReleaseTime()) != null && slotReleaseTime > 0) {
            userBind.setSlotReleaseTime(DateUtils.dateModifOfSecond((Date)now, (int)slotReleaseTime));
        }
    }

    private CardDetailRespVO buildCardDetail(CardDetailsInfoRespVO data, UcUserCardBindEntity ucUserCardBindEntity, BaseReqVO reqVO) {
        CardDetailRespVO cardDetailRespVO = new CardDetailRespVO();
        cardDetailRespVO.setCardId(data.getCardId());
        cardDetailRespVO.setCardNo(data.getCardNo());
        cardDetailRespVO.setCardTypeCode(data.getCardTypeCode());
        cardDetailRespVO.setCardTypeName(data.getCardTypeName());
        cardDetailRespVO.setProvinceCode(data.getProvinceCode());
        cardDetailRespVO.setProvinceName(data.getProvinceName());
        cardDetailRespVO.setCityCode(data.getCityCode());
        cardDetailRespVO.setCityName(data.getCityName());
        cardDetailRespVO.setCityAreaName(data.getCityAreaName());
        cardDetailRespVO.setCityAreaCode(data.getCityAreaCode());
        cardDetailRespVO.setCredNo(data.getCredNo());
        cardDetailRespVO.setCredTypeCode(data.getCredTypeCode());
        cardDetailRespVO.setCredTypeName(data.getCredTypeName());
        cardDetailRespVO.setDetailAddress(data.getDetailAddress());
        cardDetailRespVO.setGender(data.getGender());
        cardDetailRespVO.setNationCode(data.getNationCode());
        cardDetailRespVO.setNationName(data.getNationName());
        cardDetailRespVO.setCardStatus(data.getCardStatus());
        cardDetailRespVO.setCardStatusDesc(data.getCardStatusDesc());
        cardDetailRespVO.setBirthdate(data.getBirth());
        cardDetailRespVO.setOccupationCode(data.getOccupationCode());
        cardDetailRespVO.setOccupationName(data.getOccupationName());
        cardDetailRespVO.setOrganCode(data.getOrganCode());
        cardDetailRespVO.setOrganName(data.getOrganName());
        cardDetailRespVO.setPatientId(data.getPatientId());
        cardDetailRespVO.setPatientName(data.getPatientName());
        cardDetailRespVO.setTel(data.getTel());
        cardDetailRespVO.setHisAddress(data.getHisAddress());
        cardDetailRespVO.setBindStatus(Short.valueOf((short)ucUserCardBindEntity.getBindStatus().ordinal()));
        cardDetailRespVO.setSignType(Short.valueOf((short)ucUserCardBindEntity.getSignType().ordinal()));
        cardDetailRespVO.setRelation(Short.valueOf((short)ucUserCardBindEntity.getRelation().ordinal()));
        cardDetailRespVO.setUserId(ucUserCardBindEntity.getUserId());
        cardDetailRespVO.setBindTime(ucUserCardBindEntity.getBindTime());
        String signTypeName = CardEnums.CardSignType.getDesc((CardEnums.CardSignType)ucUserCardBindEntity.getSignType());
        cardDetailRespVO.setSignTypeName(signTypeName);
        String userId = ucUserCardBindEntity.getUserId();
        UcAccountEntity ucAccountEntity = this.ucAccountMapper.selectByUserId(userId);
        if (null != ucAccountEntity) {
            cardDetailRespVO.setAccountNo(ucAccountEntity.getAccountNo());
        }
        return cardDetailRespVO;
    }

    private BaseResponse<List<UserCardListRespVO>> handleUserCardList(List<UcUserCardBindEntity> ucUserCardBindEntities) {
        ArrayList<UserCardListRespVO> userCardListRespVOS = new ArrayList<UserCardListRespVO>();
        for (UcUserCardBindEntity userCardBind : ucUserCardBindEntities) {
            UserCardListRespVO respVO = new UserCardListRespVO();
            respVO.setCardId(userCardBind.getCardId());
            respVO.setCardNo(userCardBind.getCardNo());
            respVO.setCardType(userCardBind.getCardTypeCode());
            respVO.setCardTypeDesc(userCardBind.getCardTypeName());
            respVO.setOrganCode(userCardBind.getOrganCode());
            respVO.setPatientName(userCardBind.getPatientName());
            respVO.setStatus(Short.valueOf((short)userCardBind.getBindStatus().ordinal()));
            userCardListRespVOS.add(respVO);
        }
        return BaseResponse.success(userCardListRespVOS);
    }

    private BaseResponse<CardDetailRespVO> handleCardResp(UcBindCardReqVO reqVo, BaseResponse<?> bindResult, CardEnums.CardSignType cardSignType) {
        if (bindResult.isSuccess()) {
            CardDetailsInfoRespVO cardDetailsInfo = (CardDetailsInfoRespVO)bindResult.getData();
            UcUserCardBindEntity userCardBindOp = this.cardBindMapper.findOneByUserIdAndCardId(reqVo.getUserId(), cardDetailsInfo.getCardId());
            UcUserCardBindEntity userCardBind = this.updateBindInfo(reqVo, cardDetailsInfo, userCardBindOp);
            userCardBind.setSignType(cardSignType);
            this.cardBindMapper.save(userCardBind);
            UcCardBindLogEntity bindLog = new UcCardBindLogEntity(reqVo.getAccountId(), userCardBind.getCardId(), CardEnums.CardBindStatus.BIND, userCardBind.getId(), reqVo.getOperateUser());
            this.cardBindLogMapper.save(bindLog);
            CardDetailRespVO data = this.buildCardDetail(cardDetailsInfo, userCardBind, (BaseReqVO)reqVo);
            UcPatientInfoEntity ucPatientInfoEntity = new UcPatientInfoEntity();
            ucPatientInfoEntity.setPatientId(userCardBind.getPatientId());
            ucPatientInfoEntity.setUserId(userCardBind.getUserId());
            ucPatientInfoEntity.setUserRelation(userCardBind.getRelation().ordinal() == 0 ? Short.valueOf("0") : Short.valueOf("6"));
            ucPatientInfoEntity.setPatientInfoStatus(Short.valueOf("0"));
            ucPatientInfoEntity.setUpdateTime(new Date());
            UcPatientInfoEntity upife = this.ucPatientInfoMapper.selectByPatientIdAndUserId(ucPatientInfoEntity.getPatientId(), ucPatientInfoEntity.getUserId());
            if (null != upife) {
                ucPatientInfoEntity.setId(upife.getId());
            } else {
                ucPatientInfoEntity.setCreateTime(new Date());
            }
            this.ucPatientInfoMapper.save(ucPatientInfoEntity);
            return BaseResponse.success((Object)data);
        }
        return BaseResponse.error((IError)IError.FEIGN_FAIL, (String)bindResult.getMsg());
    }

    private RegisterCardReqVO buildregisterCardVO(UcRegisterCardReqVO ucReqVO) {
        RegisterCardReqVO reqVO = new RegisterCardReqVO();
        reqVO.setAppCode(ucReqVO.getAppCode());
        reqVO.setChannelCode(ucReqVO.getChannelCode());
        reqVO.setCityAreaCode(ucReqVO.getCityAreaCode());
        reqVO.setCityAreaName(ucReqVO.getCityAreaName());
        reqVO.setCityCode(ucReqVO.getCityCode());
        reqVO.setCityName(ucReqVO.getCityName());
        reqVO.setCredNo(ucReqVO.getCredNo());
        reqVO.setCredTypeCode(ucReqVO.getCredTypeCode());
        reqVO.setCredTypeName(ucReqVO.getCredTypeName());
        reqVO.setDetailAddress(ucReqVO.getDetailAddress());
        reqVO.setNationCode(ucReqVO.getNationCode());
        reqVO.setNationName(ucReqVO.getNationName());
        reqVO.setOccupationCode(ucReqVO.getOccupationCode());
        reqVO.setOccupationName(ucReqVO.getOccupationName());
        reqVO.setPatientName(ucReqVO.getPatientName());
        reqVO.setOrganCode(ucReqVO.getOrganCode());
        reqVO.setOrganName(ucReqVO.getOrganName());
        reqVO.setProvinceCode(ucReqVO.getProvinceCode());
        reqVO.setProvinceName(ucReqVO.getProvinceName());
        reqVO.setTel(ucReqVO.getTel());
        reqVO.setCardTypeCode(ucReqVO.getCardTypeCode());
        reqVO.setCardTypeName(ucReqVO.getCardTypeName());
        return reqVO;
    }

    private UcUserCardBindEntity updateBindInfo(UcBindCardReqVO reqVo, CardDetailsInfoRespVO cardDetailsInfo, UcUserCardBindEntity userCardBindOp) {
        UcUserCardBindEntity userCardBind;
        if (userCardBindOp == null) {
            userCardBind = new UcUserCardBindEntity();
            userCardBind.setCardId(cardDetailsInfo.getCardId());
            userCardBind.setCardNo(cardDetailsInfo.getCardNo());
            userCardBind.setUserId(reqVo.getUserId());
            userCardBind.setOrganCode(reqVo.getOrganCode());
            userCardBind.setOrganName(reqVo.getOrganName());
            userCardBind.setCardTypeCode(cardDetailsInfo.getCardTypeCode());
            userCardBind.setCardTypeName(cardDetailsInfo.getCardTypeName());
            userCardBind.setPatientId(cardDetailsInfo.getPatientId());
        } else {
            userCardBind = userCardBindOp;
        }
        userCardBind.setBindStatus(CardEnums.CardBindStatus.BIND);
        for (UserEnums.UserRelationEnum userRelationEnum : UserEnums.UserRelationEnum.values()) {
            if (!reqVo.getIsPerson().equals(userRelationEnum.getUserRelation())) continue;
            userCardBind.setRelation(userRelationEnum);
        }
        userCardBind.setBindTime(new Date());
        userCardBind.setPatientName(reqVo.getPatientName());
        return userCardBind;
    }

    private BindCardReqVO buildBindCardReqVO(UcBindCardReqVO usercenterBindCardReqVO) {
        BindCardReqVO cardServiceBindCardReqVO = new BindCardReqVO();
        cardServiceBindCardReqVO.setAppCode(usercenterBindCardReqVO.getAppCode());
        cardServiceBindCardReqVO.setChannelCode(usercenterBindCardReqVO.getChannelCode());
        cardServiceBindCardReqVO.setCredNo(usercenterBindCardReqVO.getCredNo());
        cardServiceBindCardReqVO.setCredTypeCode(usercenterBindCardReqVO.getCredTypeCode());
        cardServiceBindCardReqVO.setCredTypeName(usercenterBindCardReqVO.getCredTypeName());
        cardServiceBindCardReqVO.setOrganCode(usercenterBindCardReqVO.getOrganCode());
        cardServiceBindCardReqVO.setOrganName(usercenterBindCardReqVO.getOrganName());
        cardServiceBindCardReqVO.setPatientName(usercenterBindCardReqVO.getPatientName());
        cardServiceBindCardReqVO.setTel(usercenterBindCardReqVO.getTel());
        cardServiceBindCardReqVO.setCardTypeCode(usercenterBindCardReqVO.getCardTypeCode());
        cardServiceBindCardReqVO.setCardTypeName(usercenterBindCardReqVO.getCardTypeName());
        cardServiceBindCardReqVO.setTel(usercenterBindCardReqVO.getTel());
        return cardServiceBindCardReqVO;
    }

    private BaseResponse<CardDetailsInfoRespVO> getCardDetailsInfoRespVOFromCardService(CardDetailQueryReqVO cardDetailQueryReqVO) {
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(cardDetailQueryReqVO.getCardId());
        cardDetailsInfoReqVO.setChannelCode(cardDetailQueryReqVO.getChannelCode());
        this.log.info("\u67e5\u8be2\u5c31\u8bca\u5361\u8be6\u60c5\uff0c\u8c03\u7528\u5c31\u8bca\u5361\u4e2d\u5fc3\u8bf7\u6c42\u53c2\u6570{}", (Object)cardDetailsInfoReqVO);
        BaseResponse cardDetailFromCardService = this.cardServiceFeginClient.getCardDetail(cardDetailsInfoReqVO);
        this.log.info("\u67e5\u8be2\u5c31\u8bca\u5361\u8be6\u60c5\uff0c\u8c03\u7528\u5c31\u8bca\u5361\u4e2d\u5fc3\u8fd4\u56de\u53c2\u6570{}", (Object)cardDetailFromCardService);
        return cardDetailFromCardService;
    }

    private CardListRespVO buildCardListRespVO(CardListRespVO cardListRespVO, CardDetailsInfoRespVO cardDetailsInfoRespVO) {
        String birthStr;
        cardListRespVO.setOrganCode(cardDetailsInfoRespVO.getOrganCode());
        cardListRespVO.setOrganName(cardDetailsInfoRespVO.getOrganName());
        cardListRespVO.setPatientId(cardDetailsInfoRespVO.getPatientId());
        cardListRespVO.setPatientName(cardDetailsInfoRespVO.getPatientName());
        cardListRespVO.setCredNo(cardDetailsInfoRespVO.getCredNo());
        cardListRespVO.setCredTypeCode(cardDetailsInfoRespVO.getCredTypeCode());
        cardListRespVO.setCredTypeName(cardDetailsInfoRespVO.getCredTypeName());
        cardListRespVO.setCardTypeCode(cardDetailsInfoRespVO.getCardTypeCode());
        cardListRespVO.setCardTypeName(cardDetailsInfoRespVO.getCardTypeName());
        cardListRespVO.setCardNo(cardDetailsInfoRespVO.getCardNo());
        cardListRespVO.setCardId(cardDetailsInfoRespVO.getCardId());
        cardListRespVO.setGender(cardDetailsInfoRespVO.getGender());
        cardListRespVO.setTel(cardDetailsInfoRespVO.getTel());
        cardListRespVO.setCardStatus(cardDetailsInfoRespVO.getCardStatus());
        cardListRespVO.setCardStatusDesc(cardDetailsInfoRespVO.getCardStatusDesc());
        UcAccountEntity ucAccountEntity = this.ucAccountMapper.selectByUserId(cardListRespVO.getUserId());
        if (null != ucAccountEntity) {
            cardListRespVO.setAccountNo(ucAccountEntity.getAccountNo());
        }
        if (IdCardUtil.validateIdCard18((String)cardListRespVO.getCredNo()) && (birthStr = IdCardUtil.getBirthByIdCard2((String)cardListRespVO.getCredNo())) != null) {
            try {
                Date dob = DateUtils.formatDate((String)birthStr);
                cardListRespVO.setBirthdate(dob);
            }
            catch (ParseException e) {
                this.log.warn("\u8bc1\u4ef6\u53f7\u89e3\u6790\u51fa\u751f\u65e5\u671f\u5931\u8d25,e={}", (Throwable)e);
            }
        }
        return cardListRespVO;
    }

    private BaseResponse<CardDetailsInfoRespVO> getCardStatusFromCardService(CardDetailsInfoReqVO cardDetailsInfoRespVO) {
        this.log.info("\u67e5\u8be2\u5c31\u8bca\u5361\u5217\u8868\uff0c\u8c03\u7528\u5c31\u8bca\u5361\u4e2d\u5fc3\u8bf7\u6c42\u53c2\u6570{}", (Object)cardDetailsInfoRespVO);
        BaseResponse cardDetail = this.cardServiceFeginClient.getCardDetail(cardDetailsInfoRespVO);
        this.log.info("\u67e5\u8be2\u5c31\u8bca\u5361\u5217\u8868\uff0c\u8c03\u7528\u5c31\u8bca\u5361\u4e2d\u5fc3\u8fd4\u56de\u53c2\u6570{}", (Object)cardDetail);
        return cardDetail;
    }

    private void checkBindCredParams(UcBindCardReqVO reqVo) {
        if (ID_CARD_CODE.equals(reqVo.getCredTypeCode()) || HOUSEHOLD_CARD_CODE.equals(reqVo.getCredTypeCode())) {
            if (IdCardUtil.validateIdCard15((String)reqVo.getCredNo())) {
                String s = IdCardUtil.convert15CardTo18((String)reqVo.getCredNo());
                reqVo.setCredNo(s);
                this.log.info("15\u4f4d\u539f\u8eab\u4efd\u8bc1\u53f7\uff1a{},\u8f6c\u6362\u540e18\u4f4d\u8eab\u4efd\u8bc1\u53f7\uff1a{}", (Object)reqVo.getCredNo(), (Object)s);
            }
            if (!IdCardUtil.validateIdCard18((String)reqVo.getCredNo())) {
                this.log.warn("\u8eab\u4efd\u8bc1\u6216\u6237\u53e3\u7c3f\u9a8c\u8bc1\u5931\u8d25[{}],\u5361\u53f7\u4fe1\u606f[{}]", (Object)reqVo.getCredNo());
                throw new UserCenterRuntimeException(ErrorEnum.CARD_REGISTER_CRED_WRONG);
            }
        }
    }

    private void checkRegisterCredParams(UcRegisterCardReqVO reqVo) {
        if (ID_CARD_CODE.equals(reqVo.getCredTypeCode()) || HOUSEHOLD_CARD_CODE.equals(reqVo.getCredTypeCode())) {
            if (IdCardUtil.validateIdCard15((String)reqVo.getCredNo())) {
                String s = IdCardUtil.convert15CardTo18((String)reqVo.getCredNo());
                reqVo.setCredNo(s);
                this.log.info("15\u4f4d\u539f\u8eab\u4efd\u8bc1\u53f7\uff1a{},\u8f6c\u6362\u540e18\u4f4d\u8eab\u4efd\u8bc1\u53f7\uff1a{}", (Object)reqVo.getCredNo(), (Object)s);
            }
            if (!IdCardUtil.validateIdCard18((String)reqVo.getCredNo())) {
                this.log.warn("\u8eab\u4efd\u8bc1\u6216\u6237\u53e3\u7c3f\u9a8c\u8bc1\u5931\u8d25[{}],\u5361\u53f7\u4fe1\u606f[{}]", (Object)reqVo.getCredNo());
                throw new UserCenterRuntimeException(ErrorEnum.CARD_REGISTER_CRED_WRONG);
            }
        }
    }
}

