/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.ebaiyihui.card.client.ICardHospitalFeignClient;
import com.ebaiyihui.card.common.vo.OrganConfigReqVO;
import com.ebaiyihui.card.common.vo.OrganConfigRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.JsonUtil;
import com.ebaiyihui.server.service.ICardHospitalService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;

@Service
public class CardHospitalServiceImpl
implements ICardHospitalService {
    private static final Logger log = LoggerFactory.getLogger(CardHospitalServiceImpl.class);
    @Autowired
    private ICardHospitalFeignClient cardHospitalFeignClient;

    public OrganConfigRespVO getOrganConfig(String organCode) {
        OrganConfigReqVO organConfigReq = new OrganConfigReqVO();
        organConfigReq.setChannelCode("HXGY-USER");
        organConfigReq.setOrganCode(organCode);
        BaseResponse organConfig = this.cardHospitalFeignClient.getOrganConfig(organConfigReq);
        log.info("\u672a\u5728\u7f13\u5b58\u4e2d\u83b7\u53d6\u5230\u673a\u6784[{}]\u914d\u7f6e\u4fe1\u606f\uff0c\u8d70\u5361\u670d\u52a1\u83b7\u53d6\uff0c\u8fd4\u56de\u4fe1\u606f[{}]", (Object)organCode, (Object)JsonUtil.convertObject((Object)organConfig));
        if (organConfig.isSuccess()) {
            return (OrganConfigRespVO)organConfig.getData();
        }
        return null;
    }

    @CacheEvict(value={"dataCache"}, key="'mCardHospital:'+#organCode")
    public BaseResponse<?> delOrganConfig(String organCode) {
        log.info("\u6e05\u9664\u7f13\u5b58\u4e2d\u83b7\u53d6\u5230\u673a\u6784[{}]\u914d\u7f6e\u4fe1\u606f", (Object)organCode);
        return BaseResponse.success();
    }
}

