/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.ebaiyihui.client.RoleClient;
import com.ebaiyihui.client.UserOrganClient;
import com.ebaiyihui.common.UserOrganInfoVO;
import com.ebaiyihui.common.enums.ErrorEnum;
import com.ebaiyihui.common.pojo.query.UcAccountQuery;
import com.ebaiyihui.common.pojo.systemauthVo.AccountResVo;
import com.ebaiyihui.common.pojo.systemauthVo.ManagerAddReqVo;
import com.ebaiyihui.common.pojo.systemauthVo.ManagerEditReqVo;
import com.ebaiyihui.common.pojo.systemauthVo.MemberCountResVo;
import com.ebaiyihui.common.pojo.systemauthVo.VerifyPasswordReqVo;
import com.ebaiyihui.common.vo.role.RoleInfoVO;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.server.enums.AccountEnums;
import com.ebaiyihui.server.enums.UserEnums;
import com.ebaiyihui.server.exception.UserCenterRuntimeException;
import com.ebaiyihui.server.pojo.bo.ExcelData;
import com.ebaiyihui.server.pojo.entity.UcAccountEntity;
import com.ebaiyihui.server.pojo.entity.UcManagerUserEntity;
import com.ebaiyihui.server.repository.UcAccountMapper;
import com.ebaiyihui.server.repository.UcManagerUserMapper;
import com.ebaiyihui.server.service.BaseService;
import com.ebaiyihui.server.service.IManagerAuthService;
import com.ebaiyihui.server.util.PasswordUtil;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ManagerAuthServiceImpl
extends BaseService
implements IManagerAuthService {
    private static final Logger log = LoggerFactory.getLogger(ManagerAuthServiceImpl.class);
    @Autowired
    private UcAccountMapper accountMapper;
    @Autowired
    private UcManagerUserMapper managerUserMapper;
    @Autowired
    private RoleClient roleClient;
    @Autowired
    private UserOrganClient userOrganClient;

    public BaseResponse<MemberCountResVo> getMemberCount() {
        log.info("ManagerAuth::\u8fdb\u5165[\u83b7\u53d6\u6210\u5458\u7edf\u8ba1\u4fe1\u606f]\u65b9\u6cd5");
        UcAccountQuery query = new UcAccountQuery();
        MemberCountResVo vo = new MemberCountResVo();
        vo.setAllCount(this.accountMapper.selectCountByCondition(query));
        query.setIsActive(AccountEnums.ActiveEnum.ACTIVE_YES.getValue());
        vo.setActiveCount(this.accountMapper.selectCountByCondition(query));
        query.setIsActive(AccountEnums.ActiveEnum.ACTIVE_NO.getValue());
        vo.setNotActiveCount(this.accountMapper.selectCountByCondition(query));
        log.info("ManagerAuth::[\u83b7\u53d6\u6210\u5458\u7edf\u8ba1\u4fe1\u606f]\u6210\u529f");
        return BaseResponse.success((Object)vo);
    }

    @Transactional
    public BaseResponse<AccountResVo> addMember(ManagerAddReqVo vo) {
        log.info("ManagerAuth::\u8fdb\u5165[\u6dfb\u52a0\u6210\u5458]\u65b9\u6cd5,\u5165\u53c2\u4e3a{}", (Object)vo);
        this.verifyLoginAvailable(vo.getLoginName(), vo.getLoginPhone());
        UcAccountEntity entity = new UcAccountEntity();
        entity.setAccountNo(vo.getLoginPhone());
        entity.setAccountPw(PasswordUtil.mixPassword((String)vo.getPassword()));
        entity.setLoginName(vo.getLoginName());
        entity.setRealName(vo.getRealName());
        entity.setAppCode(vo.getAppCode());
        entity.setRegisterChannel(vo.getChannelCode());
        String snowId = this.uniqueID.getNextId();
        entity.setAccountId(snowId);
        entity.setUserId(snowId);
        entity.setUserType(UserEnums.UserTypeEnum.MANAGER.getUserTypeValue());
        entity.setAccountType(AccountEnums.AccountTypeEnum.CELL_PHONE.getValue());
        entity.setStatus(UserEnums.UserStatusEnum.NORMAL.getUserStatusValue());
        entity.setIsActive(AccountEnums.ActiveEnum.ACTIVE_NO.getValue());
        this.accountMapper.insertSelective(entity);
        log.info("ManagerAuth::\u6210\u5458\u6210\u529f\u6dfb\u52a0\u5230 uc_account \u8868\u4e2d");
        this.updateManagerUser(entity);
        log.info("ManagerAuth::\u6210\u5458\u6210\u529f\u6dfb\u52a0\u5230 uc_manager_user \u8868\u4e2d");
        AccountResVo resVo = this.getResVo(entity);
        return BaseResponse.success((Object)resVo);
    }

    private AccountResVo getResVo(UcAccountEntity entity) {
        AccountResVo vo = new AccountResVo();
        vo.setId(entity.getId());
        vo.setCreateTime(entity.getCreateTime());
        vo.setLoginName(entity.getLoginName());
        vo.setIsActive(entity.getIsActive());
        vo.setAccountNo(entity.getAccountNo());
        vo.setUserId(entity.getUserId());
        vo.setAccountId(entity.getAccountId());
        vo.setRealName(entity.getRealName());
        return vo;
    }

    private void updateManagerUser(UcAccountEntity entity) {
        Optional optional = this.managerUserMapper.selectByUserId(entity.getUserId());
        UcManagerUserEntity manager = optional.isPresent() ? (UcManagerUserEntity)optional.get() : new UcManagerUserEntity();
        manager.setUserId(entity.getUserId());
        manager.setContactMobile(entity.getAccountNo());
        manager.setRegisterMobile(entity.getAccountNo());
        manager.setName(entity.getLoginName());
        manager.setUserStatus(entity.getStatus());
        manager.setIsActive(entity.getIsActive());
        this.managerUserMapper.save(manager);
    }

    public BaseResponse<AccountResVo> editMember(ManagerEditReqVo vo) {
        log.info("ManagerAuth::[\u4fee\u6539\u6210\u5458\u4fe1\u606f]\u65b9\u6cd5\u8fdb\u5165...\u5165\u53c2\u4e3a{}", (Object)vo);
        UcAccountEntity ucAccountEntity = this.accountMapper.findByAccountId(vo.getObjectAccountId());
        log.info("ManagerAuth::[\u4fee\u6539\u6210\u5458\u4fe1\u606f]\u67e5\u8be2\u4fee\u6539\u5bf9\u8c61,accountId = {},ucAccount = {}", (Object)vo.getObjectAccountId(), (Object)ucAccountEntity);
        if (!StringUtil.isBlank((CharSequence)vo.getRealName())) {
            ucAccountEntity.setRealName(vo.getRealName());
        }
        if (!StringUtil.isBlank((CharSequence)vo.getLoginName())) {
            ucAccountEntity.setLoginName(vo.getLoginName());
        }
        if (!StringUtil.isBlank((CharSequence)vo.getLoginPhone())) {
            ucAccountEntity.setAccountNo(vo.getLoginPhone());
        }
        if (!StringUtil.isBlank((CharSequence)vo.getPassword())) {
            String mixPassword = PasswordUtil.mixPassword((String)vo.getPassword());
            ucAccountEntity.setAccountPw(mixPassword);
        }
        if (vo.getObjectAccountId().equals(vo.getOperateAccountId())) {
            ucAccountEntity.setIsActive(AccountEnums.ActiveEnum.ACTIVE_YES.getValue());
            log.info("ManagerAuth::[\u4fee\u6539\u6210\u5458\u4fe1\u606f]\u662f\u672c\u4eba\u4fee\u6539\u4fe1\u606f,\u8d26\u6237\u72b6\u6001\u5df2\u7ecf\u6fc0\u6d3b!");
        }
        this.accountMapper.updateByPrimaryKeySelective(ucAccountEntity);
        this.updateManagerUser(ucAccountEntity);
        AccountResVo resVo = this.getResVo(ucAccountEntity);
        log.info("ManagerAuth::[\u4fee\u6539\u6210\u5458\u4fe1\u606f]\u6210\u529f!");
        return BaseResponse.success((Object)resVo);
    }

    public BaseResponse<Boolean> deleteMember(String accountId) {
        log.info("ManagerAuth::[\u5220\u9664\u6210\u5458]\u65b9\u6cd5\u8fdb\u5165...accountId = {}", (Object)accountId);
        UcAccountEntity entity = this.accountMapper.findByAccountId(accountId);
        entity.setStatus(AccountEnums.AccountStatusEnum.CANCELLATION.getValue());
        this.accountMapper.updateByPrimaryKeySelective(entity);
        Optional optional = this.managerUserMapper.selectByUserId(entity.getUserId());
        if (optional.isPresent()) {
            UcManagerUserEntity managerUserEntity = (UcManagerUserEntity)optional.get();
            managerUserEntity.setUserStatus(AccountEnums.AccountStatusEnum.CANCELLATION.getValue());
            this.managerUserMapper.updateByPrimaryKeySelective(managerUserEntity);
        }
        log.info("ManagerAuth::[\u5220\u9664\u6210\u5458]\u65b9\u6cd5\u6210\u529f!");
        return BaseResponse.success((Object)true);
    }

    public BaseResponse<Boolean> verifyPassword(VerifyPasswordReqVo vo) {
        UcAccountEntity entity = this.getRightAccount(vo.getAccountId());
        String mixPassword = PasswordUtil.mix((String)vo.getPassword(), (String)entity.getPwSalt());
        if (!entity.getAccountPw().equals(mixPassword)) {
            throw new UserCenterRuntimeException(ErrorEnum.INVALID_PASSWORD, "\u767b\u5f55\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        return BaseResponse.success((Object)true);
    }

    public boolean verifyLoginAvailable(String loginName, String loginPhone) {
        UcAccountQuery query = new UcAccountQuery();
        query.setStatusList("0,1,3,4");
        query.setAccountNo(loginPhone);
        Page ucAccountEntities = this.accountMapper.selectByCondition(query);
        if (ucAccountEntities.size() != 0) {
            throw new UserCenterRuntimeException(IError.PARAM_CHECK_FAILD, "\u8be5\u624b\u673a\u53f7\u5df2\u5b58\u5728!");
        }
        query.setAccountNo(null);
        query.setLoginName(loginName);
        ucAccountEntities = this.accountMapper.selectByCondition(query);
        if (ucAccountEntities.size() != 0) {
            throw new UserCenterRuntimeException(IError.PARAM_CHECK_FAILD, "\u8be5\u7528\u6237\u540d\u5df2\u5b58\u5728!");
        }
        return true;
    }

    public BaseResponse<AccountResVo> getMemberInfo(String accountId) {
        log.info("ManagerAuth::[\u83b7\u53d6\u6210\u5458\u4fe1\u606f] \u65b9\u6cd5\u8fdb\u5165...accountId = {}", (Object)accountId);
        UcAccountEntity account = this.getRightAccount(accountId);
        AccountResVo vo = this.getResVo(account);
        BaseResponse roleList = this.roleClient.findByUserId(account.getUserId());
        vo.setRoleList((List)roleList.getData());
        log.info("ManagerAuth::[\u83b7\u53d6\u6210\u5458\u4fe1\u606f] \u8c03\u7528\u83b7\u53d6\u89d2\u8272\u4fe1\u606f, roleList = {}", roleList.getData());
        BaseResponse organList = this.userOrganClient.select(account.getUserId());
        vo.setRelHospitalList((List)organList.getData());
        log.info("ManagerAuth::[\u83b7\u53d6\u6210\u5458\u4fe1\u606f] \u8c03\u7528\u83b7\u53d6\u533b\u9662\u4fe1\u606f, organList = {}", organList.getData());
        return BaseResponse.success((Object)vo);
    }

    public BaseResponse<PageResult<AccountResVo>> getMemberList(UcAccountQuery query) {
        List userIds;
        log.info("ManagerAuth::[\u83b7\u53d6\u6210\u5458\u5217\u8868]\u65b9\u6cd5\u8fdb\u5165... \u67e5\u8be2\u5165\u53c2 = {}", (Object)query);
        if (query.getPageNum() != null && query.getPageSize() != null) {
            PageHelper.startPage((int)query.getPageNum(), (int)query.getPageSize());
        }
        if (StringUtil.isBlank((CharSequence)query.getStatusList())) {
            query.setStatusList("0");
        }
        if ((userIds = query.getUserIds()) != null && userIds.size() > 0) {
            query.setUserIdList(userIds.stream().collect(Collectors.joining(",")));
        }
        Page entityPage = this.accountMapper.selectByCondition(query);
        ArrayList list = new ArrayList();
        entityPage.forEach(item -> {
            AccountResVo vo = this.getResVo(item);
            try {
                BaseResponse roleList = this.roleClient.findByUserId(item.getUserId());
                vo.setRoleList((List)roleList.getData());
            }
            catch (Exception e) {
                log.error("ManagerAuth:[\u83b7\u53d6\u6210\u5458\u5217\u8868--\u83b7\u53d6\u89d2\u8272] {}", (Throwable)e);
            }
            try {
                BaseResponse organList = this.userOrganClient.select(item.getUserId());
                vo.setRelHospitalList((List)organList.getData());
            }
            catch (Exception e) {
                log.error("ManagerAuth:[\u83b7\u53d6\u6210\u5458\u5217\u8868--\u83b7\u53d6\u533b\u9662] {}", (Throwable)e);
            }
            list.add(vo);
        });
        PageResult result = new PageResult();
        result.setTotal((int)entityPage.getTotal());
        result.setTotalPages(entityPage.getPages());
        result.setContent(list);
        if (query.getPageNum() != null && query.getPageSize() != null) {
            result.setPageNum(query.getPageNum().intValue());
            result.setPageSize(query.getPageSize().intValue());
        }
        log.info("ManagerAuth::[\u83b7\u53d6\u6210\u5458\u5217\u8868]\u65b9\u6cd5\u6267\u884c\u5b8c\u6210!");
        return BaseResponse.success((Object)result);
    }

    public ExcelData exportMemberList(String ids) {
        log.info("ManagerAuth::[\u5bfc\u51fa\u6210\u5458\u8868\u683c]\u65b9\u6cd5\u8fdb\u5165... ids = {} ", (Object)ids);
        UcAccountQuery query = new UcAccountQuery();
        query.setIds(ids);
        Page accountEntities = this.ucAccountMapper.selectByCondition(query);
        ExcelData excelData = new ExcelData();
        excelData.setName("\u6210\u5458\u4fe1\u606f");
        excelData.setTitles(this.getTitle());
        List collect = accountEntities.stream().map(arg_0 -> this.getRow(arg_0)).collect(Collectors.toList());
        excelData.setRows(collect);
        log.info("ManagerAuth::[\u5bfc\u51fa\u6210\u5458\u8868\u683c] \u65b9\u6cd5\u6267\u884c\u6210\u529f!");
        return excelData;
    }

    private List<Object> getRow(UcAccountEntity entity) {
        SimpleDateFormat sdf = new SimpleDateFormat("YYYY\u5e74-MM\u6708-dd\u65e5");
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(entity.getRealName());
        list.add(entity.getLoginName());
        list.add(entity.getAccountNo());
        try {
            List organInfoVOList = (List)this.userOrganClient.select(entity.getUserId()).getData();
            String organString = organInfoVOList.stream().map(UserOrganInfoVO::getOrganName).collect(Collectors.joining(","));
            list.add(organString);
        }
        catch (RuntimeException e) {
            log.error("\u5bfc\u51fa\u8868\u683c:\u83b7\u53d6\u6240\u5c5e\u533b\u9662\u5931\u8d25! message = {}", (Throwable)e);
            list.add("");
        }
        try {
            List roleList = (List)this.roleClient.findByUserId(entity.getUserId()).getData();
            String roleString = roleList.stream().map(RoleInfoVO::getRoleName).collect(Collectors.joining(","));
            list.add(roleString);
        }
        catch (RuntimeException e) {
            log.error("\u5bfc\u51fa\u8868\u683c:\u83b7\u53d6\u7528\u6237\u89d2\u8272\u5931\u8d25! message = {}", (Throwable)e);
            list.add("");
        }
        list.add(sdf.format(entity.getCreateTime() == null ? new Date() : entity.getCreateTime()));
        list.add(AccountEnums.ActiveEnum.getByValue((Short)(entity.getIsActive() == null ? AccountEnums.ActiveEnum.ACTIVE_NO.getValue() : entity.getIsActive())).getDesc());
        return list;
    }

    private List<String> getTitle() {
        return Arrays.asList("\u59d3\u540d", "\u7528\u6237\u540d", "\u624b\u673a\u53f7", "\u6240\u5c5e\u533b\u9662", "\u89d2\u8272", "\u52a0\u5165\u65f6\u95f4", "\u72b6\u6001");
    }
}

