/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.server.service.impl;

import com.ebaiyihui.common.pojo.login.UcWxAuthReqVo;
import com.ebaiyihui.common.pojo.login.UcWxAuthRespVo;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.server.pojo.entity.UcWxAuthEntity;
import com.ebaiyihui.server.repository.UcWxAuthMapper;
import com.ebaiyihui.server.service.IUcWxAuthService;
import com.ebaiyihui.server.util.GetPhoneNumberUtil;
import com.ebaiyihui.server.util.RedisUtil;
import java.util.Optional;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UcWxAuthServiceImpl
implements IUcWxAuthService {
    private static final Logger log = LoggerFactory.getLogger(UcWxAuthServiceImpl.class);
    @Autowired
    private UcWxAuthMapper ucWxAuthMapper;
    @Autowired
    private RedisUtil redisUtil;

    public BaseResponse<UcWxAuthRespVo> getWxAuthByCondition(UcWxAuthReqVo ucWxAuthReqVo) {
        log.info("getWxAuth \u6839\u636e\u8d26\u6237\u7684userID\u67e5\u8be2\u5fae\u4fe1\u6388\u6743\u4fe1\u606f [\u5165\u53c2]{}", (Object)ucWxAuthReqVo);
        Optional entityOptional = this.ucWxAuthMapper.findByUserIdAndUserTypeAndStatus(ucWxAuthReqVo.getUserId(), ucWxAuthReqVo.getUserType(), ucWxAuthReqVo.getStatus());
        if (!entityOptional.isPresent()) {
            log.info("getWxAuth \u6839\u636e\u8d26\u6237\u7684userID\u67e5\u8be2\u5fae\u4fe1\u6388\u6743\u4fe1\u606f \u3010\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return new BaseResponse("1", "\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a", null);
        }
        UcWxAuthEntity ucWxAuthEntity = (UcWxAuthEntity)entityOptional.get();
        UcWxAuthRespVo ucWxAuthRespVo = new UcWxAuthRespVo();
        BeanUtils.copyProperties((Object)ucWxAuthEntity, (Object)ucWxAuthRespVo);
        log.info("getWxAuth \u6839\u636e\u8d26\u6237\u7684userID\u67e5\u8be2\u5fae\u4fe1\u6388\u6743\u4fe1\u606f\u6210\u529f [\u67e5\u8be2\u7ed3\u679c] {}", (Object)ucWxAuthRespVo);
        return new BaseResponse("1", "\u64cd\u4f5c\u6210\u529f", (Object)ucWxAuthRespVo);
    }

    public BaseResponse<String> getPhoneNumber(String encrypdata, String ivdata, String sessionId) {
        log.info("\u83b7\u53d6\u5fae\u4fe1\u624b\u673a\u53f7 [\u5165\u53c2]encrypdata: {}, ivdata: {}, sessionId: {}", new Object[]{encrypdata, ivdata, sessionId});
        if (StringUtils.isEmpty((Object)encrypdata) || StringUtils.isEmpty((Object)ivdata) || StringUtils.isEmpty((Object)sessionId)) {
            return new BaseResponse("0", "\u64cd\u4f5c\u5931\u8d25", (Object)"\u53c2\u6570\u975e\u6cd5");
        }
        String sessionkey = this.redisUtil.get(sessionId).toString().split(",")[0];
        byte[] encrypData = Base64.decode((String)encrypdata);
        byte[] ivData = Base64.decode((String)ivdata);
        byte[] sessionKey = Base64.decode((String)sessionkey);
        String str = "";
        try {
            str = GetPhoneNumberUtil.decrypt((byte[])sessionKey, (byte[])ivData, (byte[])encrypData);
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u5fae\u4fe1\u624b\u673a\u53f7\u5931\u8d25 {}", (Throwable)e);
            e.printStackTrace();
        }
        log.info("\u83b7\u53d6\u5fae\u4fe1\u624b\u673a\u53f7\u6210\u529f [\u624b\u673a\u53f7]{}", (Object)str);
        return new BaseResponse("1", "\u64cd\u4f5c\u6210\u529f", (Object)str);
    }
}

