/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.controller;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.config.DisableAuthConfig;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.exception.AppointmentRefundException;
import com.ebaiyihui.wisdommedical.exception.InHospitalException;
import com.ebaiyihui.wisdommedical.exception.OutreachException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentPayorderMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientDepositDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientPayorderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpRechargePaymentOrderEntityMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentPayorderEntity;
import com.ebaiyihui.wisdommedical.model.InpatientPayorderEntity;
import com.ebaiyihui.wisdommedical.model.OpRechargePaymentOrderEntity;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentRefundReq;
import com.ebaiyihui.wisdommedical.pojo.vo.RefundRequest;
import com.ebaiyihui.wisdommedical.pojo.vo.RefundResponse;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.GetRefundRecordRes;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.OutreachRequest;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.OutreachResponse;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.RefundReq;
import com.ebaiyihui.wisdommedical.pojo.vo.outreach.RefundReqVO;
import com.ebaiyihui.wisdommedical.service.InHospitalService;
import com.ebaiyihui.wisdommedical.service.OutpatientPaymentService;
import com.ebaiyihui.wisdommedical.service.RefundService;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6302\u53f7\u9000\u6b3eapi"})
@RequestMapping(value={"/api/v1/refund"})
public class RefundController {
    private static final Logger log = LoggerFactory.getLogger(RefundController.class);
    private static final int ACCOUNT_PLATFORM = 2;
    @Autowired
    private RefundService refundService;
    @Autowired
    private OutpatientPaymentService outpatientPaymentService;
    @Autowired
    private InHospitalService inHospitalService;
    @Autowired
    private AppointmentPayorderMapper appointmentPayOrderMapper;
    @Autowired
    private OpRechargePaymentOrderEntityMapper opRechargePaymentOrderEntityMapper;
    @Autowired
    private InpatientDepositDetailEntityMapper inpatientDepositDetailEntityMapper;
    @Autowired
    private InpatientPayorderEntityMapper inpatientPayorderEntityMapper;
    @Autowired
    private static SnowflakeIdWorker snowflakeIdWorker;

    @ApiOperation(value="\u5bf9\u8d26\u5e73\u53f0\u6302\u53f7\u9000\u6b3e", notes="\u5bf9\u8d26\u5e73\u53f0\u6302\u53f7\u9000\u6b3e")
    @PostMapping(value={"appointmentRefundForAccount"})
    public RefundResponse<String> appointmentRefundForAccount(@Valid @RequestBody RefundRequest<AppointmentRefundReq> refundRequest, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return RefundResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        RefundResponse refundResponse = null;
        try {
            refundResponse = this.refundService.appointmentRefund(refundRequest, 2);
        }
        catch (AppointmentRefundException e) {
            return RefundResponse.error((String)e.getMessage());
        }
        return refundResponse;
    }

    @ApiOperation(value="\u5411his\u5e73\u53f0\u63d0\u4f9b\u7684\u95e8\u8bca\u7f34\u8d39\u9000\u6b3e", notes="\u5411his\u5e73\u53f0\u63d0\u4f9b\u7684\u95e8\u8bca\u7f34\u8d39\u9000\u6b3e")
    @PostMapping(value={"/outpatientRefundForHis"})
    public OutreachResponse<String> outpatientRefundForHis(@Valid @RequestBody OutreachRequest<RefundReqVO> refundRequest, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return OutreachResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        OutreachResponse refundResponse = null;
        try {
            refundResponse = this.refundService.outpatientRefundForHis(refundRequest);
        }
        catch (Exception e) {
            log.error("\u95e8\u8bca\u7f34\u8d39his\u53d1\u8d77\u9000\u6b3e\u5931\u8d25->{}", (Throwable)e);
            return OutreachResponse.error((String)e.getMessage());
        }
        return refundResponse;
    }

    @ApiOperation(value="\u5411his\u5e73\u53f0\u63d0\u4f9b\u7684\u4f4f\u9662\u9884\u7f34\u91d1\u9000\u6b3e", notes="\u5411his\u5e73\u53f0\u63d0\u4f9b\u7684\u4f4f\u9662\u9884\u7f34\u91d1\u9000\u6b3e")
    @PostMapping(value={"/inHospitalRefundForHis"})
    public OutreachResponse<String> inHospitalRefundForHis(@RequestBody OutreachRequest<RefundReqVO> refundRequest) {
        OutreachResponse refundResponse = null;
        try {
            refundResponse = this.refundService.inHospitalRefundForHis(refundRequest);
        }
        catch (OutreachException e) {
            return OutreachResponse.error((String)e.getMessage());
        }
        return refundResponse;
    }

    @ApiOperation(value="\u5411his\u5e73\u53f0\u63d0\u4f9b\u7684\u6302\u53f7\u539f\u8def\u9000\u8d39", notes="\u5411his\u5e73\u53f0\u63d0\u4f9b\u7684\u6302\u53f7\u539f\u8def\u9000\u8d39")
    @PostMapping(value={"/withdrawNumber"})
    @DisableAuthConfig
    public BaseResponse<String> withdrawNumber(@RequestBody RefundReq withdrawNumberVoReq) {
        BaseResponse refundResponse = null;
        try {
            String orderType = withdrawNumberVoReq.getOrderType();
            if ("1".equals(orderType)) {
                AppointmentPayorderEntity appointmentPayorderEntity = this.appointmentPayOrderMapper.selectByOrderSeq(withdrawNumberVoReq.getSysAppointmentId());
                if (Objects.isNull(appointmentPayorderEntity)) {
                    OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOrderSeq(withdrawNumberVoReq.getSysAppointmentId());
                    if (Objects.isNull(opRechargePaymentOrderEntity)) {
                        return BaseResponse.error((String)"\u4ea4\u6613\u6d41\u6c34\u53f7\u6709\u8bef,\u8bf7\u6838\u5b9e");
                    }
                    refundResponse = this.refundService.outPatientRefund(withdrawNumberVoReq);
                    return refundResponse;
                }
                refundResponse = this.refundService.withdrawNumber(withdrawNumberVoReq);
            } else if ("2".equals(orderType)) {
                OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOrderSeq(withdrawNumberVoReq.getSysAppointmentId());
                if (Objects.isNull(opRechargePaymentOrderEntity)) {
                    AppointmentPayorderEntity appointmentPayorderEntity = this.appointmentPayOrderMapper.selectByOrderSeq(withdrawNumberVoReq.getSysAppointmentId());
                    if (Objects.isNull(appointmentPayorderEntity)) {
                        return BaseResponse.error((String)"\u4ea4\u6613\u6d41\u6c34\u53f7\u6709\u8bef,\u8bf7\u6838\u5b9e");
                    }
                    refundResponse = this.refundService.withdrawNumber(withdrawNumberVoReq);
                    return refundResponse;
                }
                refundResponse = this.refundService.outPatientRefund(withdrawNumberVoReq);
            } else if ("3".equals(orderType)) {
                InpatientPayorderEntity inpatientPayorderEntity = this.inpatientPayorderEntityMapper.selectoneByPayBillNo(withdrawNumberVoReq.getSysAppointmentId());
                if (Objects.isNull(inpatientPayorderEntity)) {
                    return BaseResponse.error((String)"\u4ea4\u6613\u6d41\u6c34\u53f7\u6709\u8bef,\u8bf7\u6838\u5b9e");
                }
                refundResponse = this.refundService.inHospitalRefund(withdrawNumberVoReq, inpatientPayorderEntity);
            }
        }
        catch (AppointmentException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        catch (InHospitalException e) {
            throw new RuntimeException(e);
        }
        return refundResponse;
    }

    @ApiOperation(value="\u83b7\u53d6\u9000\u6b3e\u8bb0\u5f55\u8be6\u60c5\u63a5\u53e3", notes="\u83b7\u53d6\u9000\u6b3e\u8bb0\u5f55\u8be6\u60c5\u63a5\u53e3")
    @GetMapping(value={"/getRefundRecords"})
    @DisableAuthConfig
    public BaseResponse<List<GetRefundRecordRes>> getRefundRecords(String outPatientId) {
        BaseResponse refundResponse = new BaseResponse();
        List RefundRecordResList = this.refundService.getRefundRecords(outPatientId);
        refundResponse.setData((Object)RefundRecordResList);
        return refundResponse;
    }
}

