/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.controller.appointment;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.model.DoctorRecordEntity;
import com.ebaiyihui.wisdommedical.pojo.vo.ScheduleDoctorVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ScheduleDoctorVoRes;
import com.ebaiyihui.wisdommedical.service.DoctorService;
import io.swagger.annotations.Api;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u533b\u751fapi"})
@RequestMapping(value={"/api/v1/doctor"})
public class DoctorController {
    private static final Logger log = LoggerFactory.getLogger(DoctorController.class);
    @Autowired
    private DoctorService doctorService;

    @GetMapping(value={"/getDoctorRecordEntity"})
    public BaseResponse<DoctorRecordEntity> getDoctorRecordEntity(@RequestParam(value="doctorId") String doctorId, @RequestParam(value="hospitalCode") String hospitalCode) {
        DoctorRecordEntity doctorRecordEntity = this.doctorService.getDoctorRecordEntity(doctorId, hospitalCode);
        return BaseResponse.success((Object)doctorRecordEntity);
    }

    @PostMapping(value={"/updateDoctorIdByDoctorCode"})
    public BaseResponse<String> updateDoctorIdByDoctorCode(@RequestParam(value="doctorId") String doctorId, @RequestParam(value="doctorCode") String doctorCode, @RequestParam(value="hospitalCode") String hospitalCode) {
        this.doctorService.updateDoctorIdByDoctorCode(doctorId, doctorCode, hospitalCode);
        return BaseResponse.success();
    }

    @PostMapping(value={"/getDoctorCodesByDoctorIds"})
    public BaseResponse<List<Long>> getDoctorCodeByDoctorId(@RequestParam(value="doctorId") String doctorId) {
        List doctorCodeList = this.doctorService.getDoctorCodeListBydoctorIds(doctorId);
        return BaseResponse.success((Object)doctorCodeList);
    }

    @PostMapping(value={"/getSchduleDoctor"})
    public BaseResponse<List<ScheduleDoctorVoRes>> getSchduleDoctor(@RequestBody @Valid ScheduleDoctorVoReq scheduleDoctorVoReq) {
        List scheduleDoctor = this.doctorService.getScheduleDoctor(scheduleDoctorVoReq);
        return BaseResponse.success((Object)scheduleDoctor);
    }
}

