/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.rabbitmq;

import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ebaiyihui.push.enums.MedicalPushOrderStatusEnum;
import com.ebaiyihui.push.pojo.miniapp.AlibabaMedicalPushReqVO;
import com.ebaiyihui.push.pojo.miniapp.RegistrationPushReqVo;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.service.AppointmentService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisCluster;

@Component
public class DelayedAppointmentRecordReceiver {
    private static final Logger log = LoggerFactory.getLogger(DelayedAppointmentRecordReceiver.class);
    public static final int NO_PAY_AUTO_CANCEL_APPOINTMENT = 2;
    @Autowired
    private AppointmentService appointmentService;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private JedisCluster jedisCluster;
    private static String AUTO_CANCEL = "\u8d85\u65f6\u672a\u4ed8\u6b3e\u81ea\u52a8\u53d6\u6d88";

    @RabbitListener(queues={"wisdommedical.appointment.delayed.order.jcszxyy_pro"})
    @RabbitHandler
    public void process(String orderEntity) {
        log.info("orderEntity->{}", (Object)JSON.toJSONString((Object)orderEntity, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        AppointmentRecordEntity appointmentRecordEntity1 = (AppointmentRecordEntity)JSON.parseObject((String)orderEntity, AppointmentRecordEntity.class);
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(appointmentRecordEntity1.getSysAppointmentId());
        RegistrationPushReqVo registrationPushReqVo = new RegistrationPushReqVo();
        AlibabaMedicalPushReqVO alibabaMedicalPushReqVO = new AlibabaMedicalPushReqVO();
        alibabaMedicalPushReqVO.setData((Object)registrationPushReqVo);
        alibabaMedicalPushReqVO.setType("1");
        alibabaMedicalPushReqVO.setClientCode("ALI_JCSZXYY");
        alibabaMedicalPushReqVO.setAuthCode(null);
        alibabaMedicalPushReqVO.setOutBizNo(appointmentRecordEntity.getSysAppointmentId());
        String format1 = DateUtil.format((Date)appointmentRecordEntity.getCreatetime(), (String)"yyyy-MM-dd HH:mm:ss");
        alibabaMedicalPushReqVO.setOrderCreateTime(format1);
        alibabaMedicalPushReqVO.setOrderModifiedTime(DateUtil.now());
        alibabaMedicalPushReqVO.setAmount("0.00");
        alibabaMedicalPushReqVO.setPayAmount("0.00");
        alibabaMedicalPushReqVO.setTradeNno(null);
        alibabaMedicalPushReqVO.setItemName(appointmentRecordEntity.getDocName());
        alibabaMedicalPushReqVO.setQuantity(1);
        alibabaMedicalPushReqVO.setSkuId(appointmentRecordEntity.getAppointmentId());
        alibabaMedicalPushReqVO.setUnitPrice("0.00");
        alibabaMedicalPushReqVO.setDepartment(appointmentRecordEntity.getDeptName());
        alibabaMedicalPushReqVO.setDeptNum(appointmentRecordEntity.getDeptCode());
        alibabaMedicalPushReqVO.setDeptLoc(appointmentRecordEntity.getDeptName());
        alibabaMedicalPushReqVO.setNavigation("alipays://platformapi/startapp?appId=2021003159636707");
        alibabaMedicalPushReqVO.setDoctor(appointmentRecordEntity.getDocName());
        alibabaMedicalPushReqVO.setDoctorRank(null);
        alibabaMedicalPushReqVO.setDoctorId(appointmentRecordEntity.getDocCode());
        alibabaMedicalPushReqVO.setDoctorAvatar(null);
        alibabaMedicalPushReqVO.setPatient(appointmentRecordEntity.getPatientName());
        String format = DateUtil.format((Date)DateUtil.parse((CharSequence)appointmentRecordEntity.getAdmDate(), (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
        appointmentRecordEntity.setAdmDate(format + " " + (appointmentRecordEntity.getAdmTimeRange().split("-")[1].equals("23:59") ? "23:00" : appointmentRecordEntity.getAdmTimeRange().split("-")[1]));
        alibabaMedicalPushReqVO.setScheduledTime(appointmentRecordEntity.getAdmDate() + ":00");
        alibabaMedicalPushReqVO.setTakeNumUrl(null);
        alibabaMedicalPushReqVO.setTakeNumPassword(null);
        alibabaMedicalPushReqVO.setCallNumUrl(null);
        alibabaMedicalPushReqVO.setMedicalOrderId(appointmentRecordEntity.getSysAppointmentId());
        alibabaMedicalPushReqVO.setMedicalNum(appointmentRecordEntity.getAppointmentNo());
        alibabaMedicalPushReqVO.setMerchantOrderLinkPage("alipays://platformapi/startapp?appId=2021003159636707&page=wisdomTreatment%2Fpages%2Fregister%2FmyRegister%2Findex");
        alibabaMedicalPushReqVO.setMerchantOrderStatus(MedicalPushOrderStatusEnum.getDisplay((Integer)8));
        log.info("\u63a8\u9001\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)alibabaMedicalPushReqVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        String post = HttpUtil.post((String)this.propertiesConstant.getSmartMdicalNewsPushUrl(), (String)JSON.toJSONString((Object)alibabaMedicalPushReqVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        log.info("\u63a8\u9001\u8fd4\u56de\u503c->{}", (Object)post);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.CANCEL.getValue());
        appointmentRecordEntity.setUpdatetime((Date)DateUtil.date());
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
    }
}

